/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifdef REGISTER_H
#else
#define REGISTER_H


#if 0
#ifndef VERIFICATION
    #define Wr64(addr, data) *(volatile uint64_t *)(addr)=(data)
    #define Rd64(addr) *(volatile uint64_t *)(addr)
    #define Wr(addr, data) *(volatile uint32_t *)(addr)=(data)
    #define Rd(addr) *(volatile uint32_t *)(addr)
    #define Wr_reg_bits(reg, val, start, len) \
      Wr(reg, ((Rd(reg) & ~(((1L<<(len))-1)<<(start))) | ((uint32_t)(val) << (start))))
#else
    #include "dpi.h"
#endif
#endif

//
// Reading file:  ./REG_LIST_RTL.h
//
// synopsys translate_off
// synopsys translate_on
//
//
// Reading file:  ../mmc_lp4/dmc/rtl/dmc_sec.vh
//
//`define DMC_SEC_REG_BASE                32'hfe037000
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe037000
// -----------------------------------------------
//DMC use 15bits ID to identify the input ports and ID.
// bit 14:10.
// 0 : CPU and MALI.   Mali and cpu will be separated to 2 channel. CPU traffic will be assigned to ID = 0. Mali traffic will assigned to ID =1.
// 1 : Mali
// 2 : PCIE
// 3 : HDMI.
// 4 : HEVC_F.
// 5 : TEST.
// 6 : USB
// 7 : Device.
// 8 : HEVC_B
// 9 : WAVE.
//10 : CPU, GPU and NNA. CPU will assign to ID = 13.  GPU and NNA still in ID = 10. we use the GPU/NNA ID to cotrol the secure control.
//11 : GDC.
//12 : ISP.
// 15:13    Not used.
// 16:  VPU read 0.
// 17:  VPU read 1.
// 18: VPU read 2.
// 19: VPU write 0.
// 20: VPU write 1.
// 21: VDEC.
// 22: HCODEC.
// 23: ge2d.
//control bit for  SubID functions for all the input.
// ARM   2 bit.    HPROT[1] == 0 : SECURE CPU;   HPROT[1] == 1 : NONSEC CPU.
// GPU   2 bit.    HPROT[2] == 1 : SECURE GPU;   HPROT[2] == 0 : NONSEC GPU access;
// PCIE  1 bit.
// HDCP  2 bits.   ID AR/AWID[0].
// HEVC_F  9 bits. dc_id_in[7:4] == 0 : for IMEM. dc_id_in[7:4] == 1 : for PMEM. dc_id_in[7:5]  != 0 for other 7 types.
// TEST  1 type.
// USB   1 type.
// DEVICE  AO_CPU : AR/AWID[7:3] == 4'ha.  4bits control.   use AR/WID[1:0].
//         DMA    : AR/AWID[7:3] == 4'h2.  8bits control    use AR/WID[3:1].
//         AUDIO  : AR/AWID[7:3] == 4'h6.  16bits control.  use AR/AWID[3:0].
//         the others total 13 bits use AR/AWID[7:3] - (4'ha, 4'h2 and 4'h6).
//VPU read port 0 and read port 2. total 16bits. use ARID[3:0] (number 0~15).
//VPU read port 1.  total 8bits.   use ARID[3:0] (number 0~7).
//VPU write port 0  total 16bits.  use AWID[3:0] (number 0~16).
//VPU write port 1  total 8bits.   use AWID[3:0] (number 0~7).
//VDEC  total 16bits.  use AR/WID[5:2]
//HCODEC total 16bits. use AR/WID[5:2].
//GE2D.  total 3bits.  2 read bits, check ARID[0].  1 write bit.   AWID dont care.
//HEVC_B.  8 bits.  use AR/WID[7:5].
//NNA.    AR/WPROT[1] == 0:  secure access.  AR/WPROT[1] == 1: None secure access.
//GDC.   4bits for AR/AWID[5:4]. actually for write there's only 1 ID. AWID[5:4] always 0.
//ISP.   one channel.
//there's total 16 ranges in the whole memory range.
// 15 ranges can be defined in 64kbyte boundary start address and end address.
// the 16th range is all other space not defined by 15 ranges.
// Each range can be enabled or disabled and  each range use security level bit to select key to do data scramble.
// The ranges can be overlapped or crossover.  But from 0 to 15 ranges, the earlier has higher priority.
#define DMC_SEC_RANGE0_CTRL                        ((0x0000  << 2) + 0xfe037000)
  //default : 32'hffff0000
  //bit 31:16   | 0 | range0_eda | range 0 end address  higher 16bits.
  //bit 15:0    | 0 | range0_sta | range 0 start address higher 16bits.
#define DMC_SEC_RANGE0_CTRL1                       ((0x0001  << 2) + 0xfe037000)
  //default : 32'h00000003
  //bit 7:5 | 0 | range0_security_level | range0 security level for DMA and DEMUX only.
  //bit 4  | 0 | range0_prot_en       | range0 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range0_local_des_en  | range0 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES_EN to decide this region data describe enable or not.
  //bit 2  | 0 | range0_lock  |  lock range 0 registers. write 1 to lock range 0 register. can't change anymore.
  //bit 1  | 0 | range0_key_sel | range 0 data describe key selection.  1 : key1. 0 : key0.
  //bit 0  | 0 | range0_en    | range 0 enable bit. 1 : enable, 0 : disable.
#define DMC_SEC_RANGE1_CTRL                        ((0x0002  << 2) + 0xfe037000)
  //default : 32'hffffffff
  //bit 31:16   | 0 | range1_eda | range 1 end address  higher 16bits.
  //bit 15:0    | 0 | range1_sta | range 1 start address higher 16bits.
#define DMC_SEC_RANGE1_CTRL1                       ((0x0003  << 2) + 0xfe037000)
  //default : 0
  //bit 7:5 | 0 | range1_security_level | range1 security level for DMA and DEMUX only.
  //bit 4  | 0 | range1_prot_en       | range1 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range1_local_des_en  | range1 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES_EN to decide this region data describe enable or not.
  //bit 2  | 0 | range1_lock  |  lock range 1 registers. write 1 to lock range 1 register. can't change anymore.
  //bit 1  | 0 | range1_key_sel | range 1 data describe key selection.  1 : key1. 1 : key0.
  //bit 0  | 0 | range1_en    | range 0 enable bit. 1 : enable, 0 : disable.
#define DMC_SEC_RANGE2_CTRL                        ((0x0004  << 2) + 0xfe037000)
  //default : 32'hffffffff
  //bit 31:16   | 0 | range2_eda | range 2 end address  higher 16bits.
  //bit 15:0    | 0 | range2_sta | range 2 start address higher 16bits.
#define DMC_SEC_RANGE2_CTRL1                       ((0x0005  << 2) + 0xfe037000)
  //default : 0
  //bit 7:5 | 0 | range2_security_level | range2 security level for DMA and DEMUX only.
  //bit 4  | 0 | range2_prot_en       | range2 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range2_local_des_en  | range2 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES to decide this region data describe enable or not.
  //bit 2  | 0 | range2_lock  |  lock range 2 registers. write 1 to lock range 2 register. can't change anymore.
  //bit 1  | 0 | range2_key_sel | range 2 data describe key selection.  1 : key1. 1 : key0.
  //bit 0  | 0 | range2_en    | range 2 enable bit. 1 : enable, 0 : disable.
#define DMC_SEC_RANGE3_CTRL                        ((0x0006  << 2) + 0xfe037000)
  //default : 32'hffffffff
  //bit 31:16   | 0 | range3_eda | range 3 end address  higher 16bits.
  //bit 15:0    | 0 | range3_sta | range 3 start address higher 16bits.
#define DMC_SEC_RANGE3_CTRL1                       ((0x0007  << 2) + 0xfe037000)
  //default : 0
  //bit 7:5 | 0 | range3_security_level | range3 security level for DMA and DEMUX only.
  //bit 4  | 0 | range3_prot_en       | range3 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range3_local_des_en  | range3 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES to decide this region data describe enable or not.
  //bit 2  | 0 | range3_lock    | lock range 3 registers. write 1 to lock range 3 related registers. can't change anymore.
  //bit 1  | 0 | range3_key_sel | range 3 data describe key selection.  1 : key1. 1 : key0.
  //bit 0  | 0 | range3_en      | range 3 enable bit. 1 : enable, 0 : disable.
#define DMC_SEC_RANGE4_CTRL                        ((0x0008  << 2) + 0xfe037000)
  //default : 32'hffffffff
  //bit 31:16   | 0 | range4_eda | range 4 end address  higher 16bits.
  //bit 15:0    | 0 | range4_sta | range 4 start address higher 16bits.
#define DMC_SEC_RANGE4_CTRL1                       ((0x0009  << 2) + 0xfe037000)
  //default : 0
  //bit 7:5 | 0 | range4_security_level | range4 security level for DMA and DEMUX only.
  //bit 4  | 0 | range4_prot_en       | range4 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range4_local_des_en  | range4 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES to decide this region data describe enable or not.
  //bit 2  | 0 | range4_lock    | lock range 4 registers. write 1 to lock range 4 related registers. can't change anymore.
  //bit 1  | 0 | range4_key_sel | range 4 data describe key selection.  1 : key1. 1 : key0.
  //bit 0  | 0 | range4_en      | range 4 enable bit. 1 : enable, 0 : disable.
#define DMC_SEC_RANGE5_CTRL                        ((0x000a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_CTRL1                       ((0x000b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_CTRL                        ((0x000c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_CTRL1                       ((0x000d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_CTRL                        ((0x000e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_CTRL1                       ((0x000f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_CTRL                        ((0x0010  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_CTRL1                       ((0x0011  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_CTRL                        ((0x0012  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_CTRL1                       ((0x0013  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_CTRL                       ((0x0014  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_CTRL1                      ((0x0015  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_CTRL                       ((0x0016  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_CTRL1                      ((0x0017  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_CTRL                       ((0x0018  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_CTRL1                      ((0x0019  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_CTRL                       ((0x001a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_CTRL1                      ((0x001b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_CTRL                       ((0x001c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_CTRL1                      ((0x001d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_CTRL1                      ((0x001f  << 2) + 0xfe037000)
  //default : 0
  //bit 7:5 | 0 | range1_security_level | range1 security level for DMC and DEMUX only.
  //bit 4  | 0 | range1_prot_en       | range1 allow protect monitor function.  1: allowed.  0: not allowed.
  //bit 3  | 0 | range1_local_des_en  | range1 data describe enable.  1: enable. 0 : disable. this bit works together with GLOBAL_DES_EN to decide this region data describe enable or not.
  //bit 2  | 0 | range1_lock  |  lock range 1 registers. write 1 to lock range 1 register. can't change anymore.
  //bit 1  | 0 | range1_key_sel | range 1 data describe key selection.  1 : key1. 1 : key0.
  //bit 0  | 0 | not used. range 15 is always enabled.
//per range per sub ID access enable.
#define DMC_SEC_RANGE0_RID_CTRL0                   ((0x0020  << 2) + 0xfe037000)
  //default : 0
  //range_rd_sid_en[31:0];
#define DMC_SEC_RANGE0_RID_CTRL1                   ((0x0021  << 2) + 0xfe037000)
  //default : 0
  //range_rd_sid_en[63:32];
#define DMC_SEC_RANGE0_RID_CTRL2                   ((0x0022  << 2) + 0xfe037000)
  //default : 0
  //range_rd_sid_en[95:64];
#define DMC_SEC_RANGE0_RID_CTRL3                   ((0x0023  << 2) + 0xfe037000)
  //default : 0
  //range_rd_sid_en[127:96];
#define DMC_SEC_RANGE0_RID_CTRL4                   ((0x0024  << 2) + 0xfe037000)
  //default : 0 not used in
#define DMC_SEC_RANGE1_RID_CTRL0                   ((0x0026  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_RID_CTRL1                   ((0x0027  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_RID_CTRL2                   ((0x0028  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_RID_CTRL3                   ((0x0029  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_RID_CTRL4                   ((0x002a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_RID_CTRL0                   ((0x002c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_RID_CTRL1                   ((0x002d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_RID_CTRL2                   ((0x002e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_RID_CTRL3                   ((0x002f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_RID_CTRL4                   ((0x0030  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_RID_CTRL0                   ((0x0032  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_RID_CTRL1                   ((0x0033  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_RID_CTRL2                   ((0x0034  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_RID_CTRL3                   ((0x0035  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_RID_CTRL4                   ((0x0036  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_RID_CTRL0                   ((0x0038  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_RID_CTRL1                   ((0x0039  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_RID_CTRL2                   ((0x003a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_RID_CTRL3                   ((0x003b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_RID_CTRL4                   ((0x003c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_RID_CTRL0                   ((0x003e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_RID_CTRL1                   ((0x003f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_RID_CTRL2                   ((0x0040  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_RID_CTRL3                   ((0x0041  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_RID_CTRL4                   ((0x0042  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_RID_CTRL0                   ((0x0044  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_RID_CTRL1                   ((0x0045  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_RID_CTRL2                   ((0x0046  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_RID_CTRL3                   ((0x0047  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_RID_CTRL4                   ((0x0048  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_RID_CTRL0                   ((0x004a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_RID_CTRL1                   ((0x004b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_RID_CTRL2                   ((0x004c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_RID_CTRL3                   ((0x004d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_RID_CTRL4                   ((0x004e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_RID_CTRL0                   ((0x0050  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_RID_CTRL1                   ((0x0051  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_RID_CTRL2                   ((0x0052  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_RID_CTRL3                   ((0x0053  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_RID_CTRL4                   ((0x0054  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_RID_CTRL0                   ((0x0056  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_RID_CTRL1                   ((0x0057  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_RID_CTRL2                   ((0x0058  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_RID_CTRL3                   ((0x0059  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_RID_CTRL4                   ((0x005a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_RID_CTRL0                  ((0x005c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_RID_CTRL1                  ((0x005d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_RID_CTRL2                  ((0x005e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_RID_CTRL3                  ((0x005f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_RID_CTRL4                  ((0x0060  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_RID_CTRL0                  ((0x0062  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_RID_CTRL1                  ((0x0063  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_RID_CTRL2                  ((0x0064  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_RID_CTRL3                  ((0x0065  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_RID_CTRL4                  ((0x0066  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_RID_CTRL0                  ((0x0068  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_RID_CTRL1                  ((0x0069  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_RID_CTRL2                  ((0x006a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_RID_CTRL3                  ((0x006b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_RID_CTRL4                  ((0x006c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_RID_CTRL0                  ((0x006e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_RID_CTRL1                  ((0x006f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_RID_CTRL2                  ((0x0070  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_RID_CTRL3                  ((0x0071  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_RID_CTRL4                  ((0x0072  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_RID_CTRL0                  ((0x0074  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_RID_CTRL1                  ((0x0075  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_RID_CTRL2                  ((0x0076  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_RID_CTRL3                  ((0x0077  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_RID_CTRL4                  ((0x0078  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_RID_CTRL0                  ((0x007a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_RID_CTRL1                  ((0x007b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_RID_CTRL2                  ((0x007c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_RID_CTRL3                  ((0x007d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_RID_CTRL4                  ((0x007e  << 2) + 0xfe037000)
//per range per sub ID access enable.
#define DMC_SEC_RANGE0_WID_CTRL0                   ((0x0080  << 2) + 0xfe037000)
#define DMC_SEC_RANGE0_WID_CTRL1                   ((0x0081  << 2) + 0xfe037000)
#define DMC_SEC_RANGE0_WID_CTRL2                   ((0x0082  << 2) + 0xfe037000)
#define DMC_SEC_RANGE0_WID_CTRL3                   ((0x0083  << 2) + 0xfe037000)
#define DMC_SEC_RANGE0_WID_CTRL4                   ((0x0084  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_WID_CTRL0                   ((0x0086  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_WID_CTRL1                   ((0x0087  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_WID_CTRL2                   ((0x0088  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_WID_CTRL3                   ((0x0089  << 2) + 0xfe037000)
#define DMC_SEC_RANGE1_WID_CTRL4                   ((0x008a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_WID_CTRL0                   ((0x008c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_WID_CTRL1                   ((0x008d  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_WID_CTRL2                   ((0x008e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_WID_CTRL3                   ((0x008f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE2_WID_CTRL4                   ((0x0090  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_WID_CTRL0                   ((0x0092  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_WID_CTRL1                   ((0x0093  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_WID_CTRL2                   ((0x0094  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_WID_CTRL3                   ((0x0095  << 2) + 0xfe037000)
#define DMC_SEC_RANGE3_WID_CTRL4                   ((0x0096  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_WID_CTRL0                   ((0x0098  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_WID_CTRL1                   ((0x0099  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_WID_CTRL2                   ((0x009a  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_WID_CTRL3                   ((0x009b  << 2) + 0xfe037000)
#define DMC_SEC_RANGE4_WID_CTRL4                   ((0x009c  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_WID_CTRL0                   ((0x009e  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_WID_CTRL1                   ((0x009f  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_WID_CTRL2                   ((0x00a0  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_WID_CTRL3                   ((0x00a1  << 2) + 0xfe037000)
#define DMC_SEC_RANGE5_WID_CTRL4                   ((0x00a2  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_WID_CTRL0                   ((0x00a4  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_WID_CTRL1                   ((0x00a5  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_WID_CTRL2                   ((0x00a6  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_WID_CTRL3                   ((0x00a7  << 2) + 0xfe037000)
#define DMC_SEC_RANGE6_WID_CTRL4                   ((0x00a8  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_WID_CTRL0                   ((0x00aa  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_WID_CTRL1                   ((0x00ab  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_WID_CTRL2                   ((0x00ac  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_WID_CTRL3                   ((0x00ad  << 2) + 0xfe037000)
#define DMC_SEC_RANGE7_WID_CTRL4                   ((0x00ae  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_WID_CTRL0                   ((0x00b0  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_WID_CTRL1                   ((0x00b1  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_WID_CTRL2                   ((0x00b2  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_WID_CTRL3                   ((0x00b3  << 2) + 0xfe037000)
#define DMC_SEC_RANGE8_WID_CTRL4                   ((0x00b4  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_WID_CTRL0                   ((0x00b6  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_WID_CTRL1                   ((0x00b7  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_WID_CTRL2                   ((0x00b8  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_WID_CTRL3                   ((0x00b9  << 2) + 0xfe037000)
#define DMC_SEC_RANGE9_WID_CTRL4                   ((0x00ba  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_WID_CTRL0                  ((0x00bc  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_WID_CTRL1                  ((0x00bd  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_WID_CTRL2                  ((0x00be  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_WID_CTRL3                  ((0x00bf  << 2) + 0xfe037000)
#define DMC_SEC_RANGE10_WID_CTRL4                  ((0x00c0  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_WID_CTRL0                  ((0x00c2  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_WID_CTRL1                  ((0x00c3  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_WID_CTRL2                  ((0x00c4  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_WID_CTRL3                  ((0x00c5  << 2) + 0xfe037000)
#define DMC_SEC_RANGE11_WID_CTRL4                  ((0x00c6  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_WID_CTRL0                  ((0x00c8  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_WID_CTRL1                  ((0x00c9  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_WID_CTRL2                  ((0x00ca  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_WID_CTRL3                  ((0x00cb  << 2) + 0xfe037000)
#define DMC_SEC_RANGE12_WID_CTRL4                  ((0x00cc  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_WID_CTRL0                  ((0x00ce  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_WID_CTRL1                  ((0x00cf  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_WID_CTRL2                  ((0x00d0  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_WID_CTRL3                  ((0x00d1  << 2) + 0xfe037000)
#define DMC_SEC_RANGE13_WID_CTRL4                  ((0x00d2  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_WID_CTRL0                  ((0x00d4  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_WID_CTRL1                  ((0x00d5  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_WID_CTRL2                  ((0x00d6  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_WID_CTRL3                  ((0x00d7  << 2) + 0xfe037000)
#define DMC_SEC_RANGE14_WID_CTRL4                  ((0x00d8  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_WID_CTRL0                  ((0x00da  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_WID_CTRL1                  ((0x00db  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_WID_CTRL2                  ((0x00dc  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_WID_CTRL3                  ((0x00dd  << 2) + 0xfe037000)
#define DMC_SEC_RANGE15_WID_CTRL4                  ((0x00de  << 2) + 0xfe037000)
#define DMC_DES_CTRL                               ((0x00e1  << 2) + 0xfe037000)
 //bit 31 : range15_des_en policy : 1 range15_des_en = range15_local_des_en && GLOBAL_DES_EN. 0 : range15_des_en = range15_local_des_en ||  GLOBAL_DES_EN.
 //bit 30 : range14_des_en policy : 1 range14_des_en = range14_local_des_en && GLOBAL_DES_EN. 0 : range14_des_en = range14_local_des_en ||  GLOBAL_DES_EN.
 //bit 29 : range13_des_en policy : 1 range13_des_en = range13_local_des_en && GLOBAL_DES_EN. 0 : range13_des_en = range13_local_des_en ||  GLOBAL_DES_EN.
 //bit 28 : range12_des_en policy : 1 range12_des_en = range12_local_des_en && GLOBAL_DES_EN. 0 : range12_des_en = range12_local_des_en ||  GLOBAL_DES_EN.
 //bit 27 : range11_des_en policy : 1 range11_des_en = range11_local_des_en && GLOBAL_DES_EN. 0 : range11_des_en = range11_local_des_en ||  GLOBAL_DES_EN.
 //bit 26 : range10_des_en policy : 1 range11_des_en = range10_local_des_en && GLOBAL_DES_EN. 0 : range10_des_en = range10_local_des_en ||  GLOBAL_DES_EN.
 //bit 25 : range9_des_en policy  : 1  range9_des_en =  range9_local_des_en && GLOBAL_DES_EN. 0 :  range9_des_en =  range9_local_des_en ||  GLOBAL_DES_EN.
 //bit 24 : range8_des_en policy  : 1  range8_des_en =  range8_local_des_en && GLOBAL_DES_EN. 0 :  range8_des_en =  range8_local_des_en ||  GLOBAL_DES_EN.
 //bit 23 : range7_des_en policy  : 1  range7_des_en =  range7_local_des_en && GLOBAL_DES_EN. 0 :  range7_des_en =  range7_local_des_en ||  GLOBAL_DES_EN.
 //bit 22 : range6_des_en policy  : 1  range6_des_en =  range6_local_des_en && GLOBAL_DES_EN. 0 :  range6_des_en =  range6_local_des_en ||  GLOBAL_DES_EN.
 //bit 21 : range5_des_en policy  : 1  range5_des_en =  range5_local_des_en && GLOBAL_DES_EN. 0 :  range5_des_en =  range5_local_des_en ||  GLOBAL_DES_EN.
 //bit 20 : range4_des_en policy  : 1  range4_des_en =  range4_local_des_en && GLOBAL_DES_EN. 0 :  range4_des_en =  range4_local_des_en ||  GLOBAL_DES_EN.
 //bit 19 : range3_des_en policy  : 1  range3_des_en =  range3_local_des_en && GLOBAL_DES_EN. 0 :  range3_des_en =  range3_local_des_en ||  GLOBAL_DES_EN.
 //bit 18 : range2_des_en policy  : 1  range2_des_en =  range2_local_des_en && GLOBAL_DES_EN. 0 :  range2_des_en =  range2_local_des_en ||  GLOBAL_DES_EN.
 //bit 17 : range1_des_en policy  : 1  range1_des_en =  range1_local_des_en && GLOBAL_DES_EN. 0 :  range1_des_en =  range1_local_des_en ||  GLOBAL_DES_EN.
 //bit 16 : range0_des_en policy  : 1  range0_des_en =  range0_local_des_en && GLOBAL_DES_EN. 0 :  range0_des_en =  range0_local_des_en ||  GLOBAL_DES_EN.
 //bit 1 | 0 | GLOBAL_DES_EN |  1: Global DES enable. 0 : global DES disable.  default is 0.
 //bit 0 | 0 | DES_lock  |  one time lock bit. after write 1 to this bit, DMC_DES_CTRL,DMC_DES_PADDING  can't be write and read.
//DES KEY registers and DES_PADDING can only be reset by pad reset.  But it can be changed by software after watch dog reset.
#define DMC_DES_KEY0_REG0                          ((0x00e2  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY0_REG1                          ((0x00e3  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY0_REG2                          ((0x00e4  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY0_REG3                          ((0x00e5  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY1_REG0                          ((0x00e6  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY1_REG1                          ((0x00e7  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY1_REG2                          ((0x00e8  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_KEY1_REG3                          ((0x00e9  << 2) + 0xfe037000)
  //default : 0
#define DMC_DES_PADDING                            ((0x00e0  << 2) + 0xfe037000)
  //default : 0
  //bit 31:0 | 0 | des_pading | 32bits address padding used for DES dkey generation.
//FROM SC2, the APB bus provided Master ID through PUSER signals.
//there's total 8 master IDs could access DMC non-secure registers.
//we assign 1 control bit for each APB Master and each DMC non-secure register domains
//and we added one lock bits to lock this setting can't be modified any more.
#define DDR_APB_SEC_CTRL0                          ((0x00f0  << 2) + 0xfe037000)
   // APB access  control for dmc REQUEST control register access control register.
   // default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL1                          ((0x00f1  << 2) + 0xfe037000)
   // APB access control for DMC DRAM timing parameter and DFI inteface registers.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL2                          ((0x00f2  << 2) + 0xfe037000)
   // APB access control for DMC PLL clock frequency control register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL3                          ((0x00f3  << 2) + 0xfe037000)
   // APB access control for DMC sticky control register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL4                          ((0x00f4  << 2) + 0xfe037000)
   // APB access control for DMC test control register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL5                          ((0x00f5  << 2) + 0xfe037000)
   // APB access control for DMC clk reset control register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL6                          ((0x00f6  << 2) + 0xfe037000)
   // APB access control for DMC protection register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL7                          ((0x00f7  << 2) + 0xfe037000)
   // APB access control for DMC normal register.
   //default : 0x0ff
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL8                          ((0x00f8  << 2) + 0xfe037000)
   // APB access control for DDR PHY group registers.
   //default : 0x50005
   //bit 23:16.  APB access enable for DDR PHY group 1 register.
   //bit 10  PHY IMEM control 1: force PHY IMEM output 0. 0: normal working mode.
   //bit 9   PHY DMEM control 1: force PHY DMEM output 0. 0: normal working mode.
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
#define DDR_APB_SEC_CTRL9                          ((0x00f9  << 2) + 0xfe037000)
   // APB access control for DMC canvas register.
   //default : 0x005
   //bit 8    lock bit if this bit =  1,  this register is locked and cannot modified anymore.
   //bit 7:0.  APB access enable for each APB user ID. one ID one bit. 1: enable. 0 disable.
//registers to check the security protection and watch point error information.
#define DMC_SEC_STATUS                             ((0x00fa  << 2) + 0xfe037000)
 //bit 31~2. not used.
 //bit 6
 //bit 5
 //bit 4
 //bit 3   1 : normal security register write violation.( APB bus WDATA not equal the register value when APB write).  write 1 to clean this bit to 0.
 //bit 2   sec_alert.   1 DMC security register alert function triggered. can't clean. only reset DMC can clear this bit.
 //bit 1   write security violation.
 //bit 0.  read security violation.
#define DMC_VIO_ADDR0                              ((0x00fb  << 2) + 0xfe037000)
  //ddr0 write secure violation address.
#define DMC_VIO_ADDR1                              ((0x00fc  << 2) + 0xfe037000)
  //bit 31:24 . not used. always 0.
  //24     ddr0 secure check violation.
  //23     not used.
  //22     not used.
  //21     not used.
  //20.    not used.
  //19     ddr0 write address overflow. write out of DDR size.
  //18:16. ddr0 write violation AWPROT bits.
  //15:0   ddr0_write violation ID.
#define DMC_VIO_ADDR2                              ((0x00fd  << 2) + 0xfe037000)
  //ddr0 read secure violation address
#define DMC_VIO_ADDR3                              ((0x00fe  << 2) + 0xfe037000)
  //24     ddr0 read secure check violation.
  //23     not used.
  //22     not used.
  //21     ddr0 read trap1 violation
  //20     ddr0 read trap0 violation
  //19     ddr 0 read address overflow. write out of DDR size.
  //18:16. ddr 0 read violation ARPROT bits.
  //15:0   ddr 0 read violation ID.
#define DMC_DDR_CTRL                               ((0x0100  << 2) + 0xfe037000)
   //bit 27.   0 : canvas use 64bytes boundary
              // 1 : canvas use 32bytes boundary.
  //bit 24:22   3'b000 : ddr3 mode.
              //3'b001 : ddr4 mode.
              //3'b010 : lpddr3 mode.
              //3'b011 : lpddr4 mode.
   //bit 21.   rank1 enable bit. if 1,  rank1 used the address map is as bit 5:3 defined.
   //bit 20    DDR4 BG1 enable bit.
   //bit 18:   ddrphy_16b, DDR PHY DDR SDRAM data bits width.  1: 16bits. 0 : 32 bits.
   //bit 16.   ddr_16b,   1: only use 16bits data in a 32bits DDR PHY data interface. 0 : normal data interface.
  //bit 7:4 :  ddr1_size.  DDR rank1 size control.
     //4'b0000 : DDR rank 1 is 128Mbyte.
     //4'b0001 : DDR rank 1 is 256Mbyte.
     //4'b0010 : DDR rank 1 is 512Mbyte.
     //4'b0011 : DDR rank 1 is 1Gbyte.
     //4'b0100 : DDR rank 1 is 2Gbyte.
     //4'b0101 : DDR rank 1 is 4Gbyte.
     //4'b1000 : DDR rank 1 is 192Mbyte.
     //4'b1001 : DDR rank 1 is 374Mbyte.
     //4'b1010 : DDR rank 1 is 768Mbyte.
     //4'b1011 : DDR rank 1 is 1.5Gbyte.
     //4'b1100 : DDR rank 1 is 3Gbyte.
     //others :  reserved.
  //bit 3:0  :  ddr0_size. DDR rank0 size control.
     //4'b0000 : DDR rank 0 is 128Mbyte.
     //4'b0001 : DDR rank 0 is 256Mbyte.
     //4'b0010 : DDR rank 0 is 512Mbyte.
     //4'b0011 : DDR rank 0 is 1Gbyte.
     //4'b0100 : DDR rank 0 is 2Gbyte.
     //4'b0101 : DDR rank 0 is 4Gbyte.
     //4'b1000 : DDR rank 1 is 192Mbyte.
     //4'b1001 : DDR rank 1 is 374Mbyte.
     //4'b1010 : DDR rank 1 is 768Mbyte.
     //4'b1011 : DDR rank 1 is 1.5Gbyte.
     //4'b1100 : DDR rank 1 is 3Gbyte.
     //others :  reserved.
//DDR3/4 LPDDR3/4 SDRAM address  to 32bits linear address address map:
//DDR0_ADDRMAP is used to select RANK0 bank, row, col address selection.
//DDR1_ADDRMAP is used to select RANK1 bank, row, col address selection.
#define DDR0_ADDRMAP_0                             ((0x0101  << 2) + 0xfe037000)
  //29:25 ca8.
  //24:20 ca7.
  //19:15 ca6.
  //14:10 ca5.
  //9:5   ca4.
  //4:0   ca3.
#define DDR0_ADDRMAP_1                             ((0x0102  << 2) + 0xfe037000)
  //29:25 ra2.
  //24:20 ra1.
  //19:15 ra0.
  //14:10 ca11.
  //9:5   ca10.
  //4:0   ca9.
#define DDR0_ADDRMAP_2                             ((0x0103  << 2) + 0xfe037000)
  //29:25 ra8.
  //24:20 ra7.
  //19:15 ra6.
  //14:10 ra5.
  //9:5   ra4.
  //4:0   ra3.
#define DDR0_ADDRMAP_3                             ((0x0104  << 2) + 0xfe037000)
  //29:25 ra14.
  //24:20 ra13.
  //19:15 ra12.
  //14:10 ra11.
  //9:5   ra10.
  //4:0   ra9.
#define DDR0_ADDRMAP_4                             ((0x0105  << 2) + 0xfe037000)
  //29:25 ra16 for DDR4 SDRAM
  //24:20 bg1  for DDR4 SDRAM.
  //19:15 ba2.    or bg0 for DDR4.
  //14:10 ba1.
  //9:5   ba0.
  //4:0   ra15.
#define DDR1_ADDRMAP_0                             ((0x0106  << 2) + 0xfe037000)
  //29:25 ca8.
  //24:20 ca7.
  //19:15 ca6.
  //14:10 ca5.
  //9:5   ca4.
  //4:0   ca3.
#define DDR1_ADDRMAP_1                             ((0x0107  << 2) + 0xfe037000)
  //29:25 ra2.
  //24:20 ra1.
  //19:15 ra0.
  //14:10 ca11.
  //9:5   ca10.
  //4:0   ca9.
#define DDR1_ADDRMAP_2                             ((0x0108  << 2) + 0xfe037000)
  //29:25 ra8.
  //24:20 ra7.
  //19:15 ra6.
  //14:10 ra5.
  //9:5   ra4.
  //4:0   ra3.
#define DDR1_ADDRMAP_3                             ((0x0109  << 2) + 0xfe037000)
  //29:25 ra14.
  //24:20 ra13.
  //19:15 ra12.
  //14:10 ra11.
  //9:5   ra10.
  //4:0   ra9.
#define DDR1_ADDRMAP_4                             ((0x010a  << 2) + 0xfe037000)
  //29:25 ra16 for DDR4 SDRAM
  //24:20 bg1  for DDR4 SDRAM.
  //19:15 ba2  or bg0 for DDR4 SDRAM..
  //14:10 ba1.
  //9:5   ba0.
  //4:0   ra15.
#define DMC_AXI2DDR0                               ((0x0120  << 2) + 0xfe037000)
  //for AXI address first 256MB  AXI ADDRESS[31:28] == 4'b0000.
  //bit 7  ddr_data_with   0 : 32bits.  1: 16bits data in a 16bits data bus.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr data 16bits mode   0 : 32bits.  1: 16 bits valid data in a 32bits data bus.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR1                               ((0x0121  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0001.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR2                               ((0x0122  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0010.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR3                               ((0x0123  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0011.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR4                               ((0x0124  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0100.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR5                               ((0x0125  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0101.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR6                               ((0x0126  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0110.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR7                               ((0x0127  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b0111.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR8                               ((0x0128  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1000.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDR9                               ((0x0129  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1001.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRA                               ((0x012a  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1010.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRB                               ((0x012b  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1011.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRC                               ((0x012c  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1100.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRD                               ((0x012d  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1101.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRE                               ((0x012e  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1110.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_AXI2DDRF                               ((0x012f  << 2) + 0xfe037000)
  //for AXI_ADDRESS[31:28] == 4'b1111.
  //bit 6  range_valid     1 : valid address 0 : not valid.
  //bit 5  rank_sel,       0 : rank0.   1: rank1.
  //bit 4  ddr_data_width, 0 : 32bits.  1: 16bits.
  //bti 3:0. remap to one rank of DDR SDRAM linear address[31:28]
#define DMC_DDR_CTRL1                              ((0x0130  << 2) + 0xfe037000)
  //bit 0. DMC_DDR_LOCK.    1: LOCK DMC_DDR_CTRL, DMC_DDR_CTRL1, DMC_AXI2DDRx, DDR0/1_ADDRMAP_x registers. those register can't modified any more.
                        //  0: all these registers can be read/write by secure APB access.
//
// Closing file:  ../mmc_lp4/dmc/rtl/dmc_sec.vh
//
//
// Reading file:  ../mmc_lp4/dmc_clk_freq/rtl/dmc_clk_freq.vh
//
//`ifdef DMC_FREQ_REG_DEFINE
//`else
//`define DMC_FREQ_REG_DEFINE
// -----------------------------------------------
// REG_BASE:  APB1_BASE_ADDR = 0xfe036c00
// -----------------------------------------------
//`define DMC_FREQ_REG_BASE      32'hfe036c00
#define AM_DDR_PLL_CNTL0                           ((0x0000  << 2) + 0xfe036c00)
  //bit 29    : dpll_reset.
  //bit 28    : dpll_en.
  //bit 27:26 : dpll_clk_en
  //bit 25    : dpll_inv_sel
  //bit 21:19 : od1  OD1[0] : 0 /2,  1: /4.   OD1[2:1].  2'b00: /1, 2'b01: /2. 2'b10 /4. 2'b11: /8.
  //bit 18:16 : od
  //bit 14:10 : dpll_ref_div_n
  //bit 8:0   : dpll_int_num
#define AM_DDR_PLL_CNTL1                           ((0x0001  << 2) + 0xfe036c00)
  //bit 18:0    : ddr_dpll_frac
#define AM_DDR_PLL_CNTL2                           ((0x0002  << 2) + 0xfe036c00)
  //bit 22:20  : fref_sel
  //bit 17:16  : os_ssc
  //bit 15:12  : ssc_str_m
  //bit 8      : ssc_en
  //bit 7:4    : ssc_dep_sel
  //bit 1:0    : dpll ss_mode.
#define AM_DDR_PLL_CNTL3                           ((0x0003  << 2) + 0xfe036c00)
  //bit 31     : afc bypass
  //bit 30     : afc clk sel
  //bit 29     : code new
  //bit 28     : dco_m_en
  //bit 27     : dco_sdm_en
  //bit 26     : div2
  //bit 25     : div mode
  //bit 24     : fast_lock mode
  //bit 23     : fb_pre_div
  //bit 22     : filter_mode
  //bit 21     : fix_en
  //bit 20     : freq_shift_en
  //bit 19     : load
  //bit 18     : load_en
  //bit 17     : lock_f
  //bit 16     : pulse_width_en
  //bit 15     : sdmnc_en
  //bit 14     : sdmnc_mode
  //bit 13     : sdmnc_range
  //bit 12     : tdc_en
  //bit 11     : tdc_mode_sel
  //bit 10     :  wait_en
#define AM_DDR_PLL_CNTL4                           ((0x0004  << 2) + 0xfe036c00)
  //bit 1:0    : pfd_gain
  //bit 7:4    : filter_pvt1
  //bit 11:8   : filter pvt2
  //bit 13:12  : acq_gain
  //bit 18:16  : lambda0
  //bit 22:20  : lambda1
  //bit 26:24  : rou
  //bit 30:28  : alpha
#define AM_DDR_PLL_CNTL5                           ((0x0005  << 2) + 0xfe036c00)
  //bit 15:0   : reve
  //bit 21:16  : lm_s
  //bit 27:24  : lm_w
  //bit 30:28  : adj_vco_ldo
#define AM_DDR_PLL_CNTL6                           ((0x0006  << 2) + 0xfe036c00)
  //bit 15:0   : reve
  //bit 21:16  : lm_s
  //bit 27:24  : lm_w
  //bit 30:28  : adj_vco_ldo
#define AM_DDR_PLL_STS                             ((0x0007  << 2) + 0xfe036c00)
  //bit 31     : DDR_PLL_LOCK
  //bit 30:19  : not used.
  //bit 18     : DDR_AFC_DONE
  //bit 17     : DDR_PLL_LOCK
  //bit 16:7   : DDR_DPLL_OUT_RSV
  //bit 6:0    : DDR_SDMNC_MONITOR
#define DDR_CLK_CNTL                               ((0x0008  << 2) + 0xfe036c00)
  //bit 31     ddr_pll_clk enable. enable the clock from DDR_PLL to clock generateion.
  // whenever change the DDR_PLL frequency, disable the clock, after the DDR_PLL locked, then enable it again.
  //bit 30.    ddr_pll_prod_test_en.  enable the clock to clock/32 which to clock frequency measurement and production test pin.
  //bit 29.    not used.
  //bit 28.    clock generation logic soft reset. 0 = reset.
  //bit 27.    phy_4xclk phase inverter..
  //bit 25.    DDRPHY DfiClk/DMC clock selection.  1:  AM_PLL clk output /2.  0: directly output from AM_PLL .
  //bit 24.    enable AM_PLL CLK output /2 function.   1: enable.  0: disable.   if try to use this clkoutput/2 function.
  //bit 26.    pll_freq divide/2. 1:  use pll div/2 clock as the n_clk. 0: use pll clock as n_clk.  this setting is used for the synopsys DDR PHY PLL fast lock mode.
  //bit 2. enable dmc_clk.
  //bit 1. not used.
  //bit 0. enable LPDDR4-PHY clock
#define DDR_PHY_CTRL                               ((0x0009  << 2) + 0xfe036c00)
  // LPDDR4 power on reset need to special combination of PwrOkIn and phy_reset_n.
  //bit 31:  DDr PHY power on status.  read only.
  //bit 4.   DDR PHY PwrOkIn pin.
  //bit 1.   DDR PHY APB soft reset_n.
  //bit 0.   phy_reset_n.
#define AM_DDR_PLL_FREQ1_OD                        ((0x000c  << 2) + 0xfe036c00)
 //freqency set 1 PLL OD and OD1 setting. when change to freqency 1 will use this setting.
//frequency set 0 use original DDR_PLL_CNTL0 setting.
 //bit 8     currunt FREQ selection.  it can forced to change to select which freqency to select, or it can auto changed by FREQ change hardware.
 //bit 5:3   OD1.
 //bit 2:0.  OD.
//`endif
//
// Closing file:  ../mmc_lp4/dmc_clk_freq/rtl/dmc_clk_freq.vh
//
//
// Reading file:  ../mmc_lp4/dmc/rtl/dmc_reg.vh
//
//`define DMC_REG_BASE      32'hfe036000
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe036000
// -----------------------------------------------
#define DMC_REQ_CTRL                               ((0x0000  << 2) + 0xfe036000)
  //bit 23.  enable dmc request of ambus chan 7. Reserved for GE2D interface. Async interface.
  //bit 22.  enable dmc request of ambus chan 6. DOS HCODEC  interface   Sync interface.
  //bit 21.  enable dmc request of ambus chan 5. DOS VDEC  interface   Sync interface.
  //bit 20.  enable dmc request of ambus chan 4. VPU write interface 1  Sync interface.
  //bit 19.  enable dmc request of ambus chan 3. VPU write interface 0  Sync interface.
  //bit 18.  enable dmc request of ambus chan 2. VPU read interface 2.   Sync interface.
  //bit 17.  enable dmc request of ambus chan 1. VPU read interface 1.   Sync interface.
  //bit 16.  enable dmc request of ambus chan 0. VPU read interface 0.  Sync interface.
  //bit 9    enable dmc request of axibus chan 9.  wave  async interface.
  //bit 8.   enable dmc request of axibus chan 8   hevc_b  async interface.
  //bit 7.   enable dmc request of axibus chan 7.  DEVICE.    Async interface.
  //bit 6.   enable dmc request of axibus chan 6.  USB   Async interface.
  //bit 5.   enable dmc request of axibus chan 5.  reserved for dmc_test.
  //bit 4.   enable dmc request of axibus chan 4.  hevc front Async interface.
  //bit 3.   enable dmc request of axibus chan 3.  HDCP/HDMI   Async interface.
  //bit 2.   enable dmc request of axibus chan 2.  pcie  async
  //bit 1.   enable dmc request of axibus chan 1.  Mali .  async interface.
  //bit 0.   enable dmc request of axibus chan 0.  CPU/A53   async interface.
//DMC CLK and RESET domain register. please check DMC_SEC_APB_CTRLx register for access details.
#define DMC_SOFT_RST                               ((0x0001  << 2) + 0xfe036000)
  //bit 31~24. reserved for future.
  //bit 23:16 8 AMBUS input interface n_clk domain reset_n signal. 0 : reset.  1: normal working mode.
  //bit 15:0. 16 AXI BUS input interfaces n_clk domain reset_n signal. 0: reset. 1: normal working mode. each bit for one interface.
#define DMC_SOFT_RST1                              ((0x0002  << 2) + 0xfe036000)
  //To reset the Async interface, you need to disable the interface both clock domain, then reset both n_clk and m_clk domain
  //bit 31~24 not used.
  //bit 23.16  8 am bus interfaces master clock domain reset_n signal. 0 : reset : 1 normal working mode.
  //bit 15:0.  16 AXI bus interfaces master clock domain reset_n signal. 0 : reset : 1 normal working mode.
#define DMC_SOFT_RST2                              ((0x0003  << 2) + 0xfe036000)
  //bit 31~11.  reserved for future.
  //bit 10  DMC DFI cmd soft reset_n
  //bit 9   DMC DFI MISC soft reset_n
  //bit 8   DMC DFI data soft reset_n
  //bit 7   DMC DFI dcu soft reset_n
  //bit 6   DMC siu soft reset_n
  //bit 5.  DMC test soft reset_n.  0 : reset. 1 : normal working mode.
  //bit 4.  DMC low power control module soft reset_n.    0 : reset. 1 : normal working mode.
  //bit 3.  DMC QOS monitor module soft reset_n.   0 : reset. 1 : normal working mode.
  //bit 2.  DMC register module soft reset_n.       0 : reset. 1 : normal working mode.
  //bit 1.  DMC canvas transfer module soft reset_n.  0 : reset. 1 : normal working mode.
  //bit 0.  DMC command buffers and command generation modules soft reset.  0 = reset. 1:
#define DMC_RST_STS1                               ((0x0004  << 2) + 0xfe036000)
  //31~24.  not used.
  //23~0.   Read only.  the DMC_SOFT_RST1 signal in n_clk domain. the purpose of this register is when one of the 2 clocks is too slow or too fast,  we can read this register to make sure another clock domain reset is done.
#define DMC_CLKG_CTRL0                             ((0x0006  << 2) + 0xfe036000)
  //bit 23:16. enable the 8 ambus interfaces both main and n_clk auto clock gating function. each 1 bit for one interface.
  //bit 15:0.  enable the 16 axi interfaces both main and n_clk auto clock gating function. each 1 bit for one interface.
#define DMC_CLKG_CTRL1                             ((0x0007  << 2) + 0xfe036000)
  //bit 23:16. force to disable the 8 ambus interfaces both main and n_clk. each 1 bit for one interface.
  //bit 15:0.  force to disable the 16 axi interfaces both main and n_clk. each 1 bit for one interface.
#define DMC_CLKG_CTRL2                             ((0x0008  << 2) + 0xfe036000)
  //bit 12  enalbe auto clock gating for awcmdfifo.
  //bit 11  enalbe auto clock gating for arcmdfifo.
  //bit 10  enable auto clock gating for dfi command generation
  //bit 9   enable auto clock gating for dram controller
  //bit 8   enable auto clock gating for dfi data path.
  //bit 7.  enalbe auto clock gating for write rsp generation.
  //bit 6.  enalbe auto clock gating for read rsp generation.
  //bit 5.  enalbe auto clock gating for ddr0 command filter.
  //bit 4.  enalbe auto clock gating for ddr0 write reorder buffer.
  //bit 3.  enalbe auto clock gating for ddr0 write data buffer.
  //bit 2.  enalbe auto clock gating for ddr0 read reorder buffer.
  //bit 1.  enalbe auto clock gating for read canvas.
  //bit 0.  enalbe auto clock gating for write canvas.
#define DMC_CLKG_CTRL3                             ((0x0009  << 2) + 0xfe036000)
  //bit 12  force to disable the clock of awcmdfifo.
  //bit 11  force to disable the clock of arcmdfifo.
  //bit 10  force to disable the clock of dfi command generation
  //bit 9   force to disable the clock of dram controller
  //bit 8   force to disable the clock of dfi data path.
  //bit 7. force to disable the clock of write rsp generation.
  //bit 6. force to disable the clock of read rsp generation.
  //bit 5.  force to disable the clock of  command filter.
  //bit 4.  force to disable the clock of  write reorder buffer.
  //bit 3.  force to disable the clock of write data buffer.
  //bit 2.  force to disable the clock of read reorder buffer.
  //bit 1.  force to disable the clock of read canvas.
  //bit 0.  force to disable the clock of write canvas.
// DMC CANVAS setting domain control registers.
#define DC_CAV_LUT_DATAL                           ((0x0012  << 2) + 0xfe036000)
  //low 32 bits of canvas data which need to be configured to canvas memory.
#define DC_CAV_LUT_DATAH                           ((0x0013  << 2) + 0xfe036000)
  //high 32bits of canvas data which need to be configured to canvas memory.
  //64bits CANVAS look up table
  //bit 60:58   Endian control.
      //3'b000:  no endian change.
      //3'b001:
  //bit 57:56.   Canvas block mode.  2 : 64x32, 1: 32x32; 0 : linear mode.
  //bit 55:      canvas Y direction wrap control. 1: wrap back in y.  0: not wrap back.
  //bit 54:      canvas X direction wrap control. 1: wrap back in X.  0: not wrap back.
  //bit 53:41.   canvas Hight.
  //bit 40:29.   canvas Width, unit: 8bytes. must in 32bytes boundary. that means last 2 bits must be 0.
  //bit 28:0.    canvas start address.   unit. 8 bytes. must be in 32bytes boundary. that means last 2bits must be 0.
#define DC_CAV_LUT_ADDR                            ((0x0014  << 2) + 0xfe036000)
  //bit 9:8.   write 9:8 2'b10. the canvas data will saved in canvas memory with addres 7:0.
  //bit 7:0.   256 canvas Look up table address.
#define DC_CAV_LUT_RDATAL                          ((0x0015  << 2) + 0xfe036000)
  // CBUS low 32bytes canvas read back data from LUT.
#define DC_CAV_LUT_RDATAH                          ((0x0016  << 2) + 0xfe036000)
  // Cbus high 32bytes canvas read back data from LUT.
// there are total 256 canvas table, So we added a 256bits register to record the those canvas mode.
// when we configure the canvas table and if the canvas mode is 32x32 blkmode, we'll mark this related bit.
// we will use this bit to check the VPU canvas access. if it's in 32x32 blkmode, we need break the input in 32bytes boundary.
// You can also use below register to read/write those bit.
#define DC_CAV_BLK_CTRL0                           ((0x0018  << 2) + 0xfe036000)
 //canvas index 31:0 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL1                           ((0x0019  << 2) + 0xfe036000)
 //canvas index 63:32 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL2                           ((0x001a  << 2) + 0xfe036000)
 //canvas index 95:64 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL3                           ((0x001b  << 2) + 0xfe036000)
 //canvas index 127:96 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL4                           ((0x001c  << 2) + 0xfe036000)
 //canvas index 159:128 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL5                           ((0x001d  << 2) + 0xfe036000)
 //canvas index 191:160 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL6                           ((0x001e  << 2) + 0xfe036000)
 //canvas index 223:192 blkmode. 1 : 32x32. 0 : others.
#define DC_CAV_BLK_CTRL7                           ((0x001f  << 2) + 0xfe036000)
 //canvas index 255:224 blkmode. 1 : 32x32. 0 : others.
#define DMC_MON_CTRL0                              ((0x0020  << 2) + 0xfe036000)
   //bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
   //bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
   //bit 7.    BW monitor 3 enable.
   //bit 6.    BW monitor 3 enable.
   //bit 5.    BW monitor 3 enable.
   //bit 4.    BW monitor 3 enable.
   //bit 3.    BW monitor 3 enable.
   //bit 2.    BW monitor 2 enable.
   //bit 1.    BW monitor 1 enable.
   //bit 0.    BW monitor 0 enable.
#define DMC_MON_TIMER                              ((0x0021  << 2) + 0xfe036000)
 // timer for the monitor period.
#define DMC_MON_ALL_IDLE_CNT                       ((0x0022  << 2) + 0xfe036000)
  // at the test period,  the whole MMC all channel IDLE time. unit, dmc clock.
#define DMC_MON_ALL_BW                             ((0x0023  << 2) + 0xfe036000)
  // at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ALL16_BW                           ((0x0024  << 2) + 0xfe036000)
  // at the test period,  the whole MMC granted data cycles which goes to 16bits ddr. unit:64bits
#define DMC_MON0_CTRL                              ((0x0025  << 2) + 0xfe036000)
  //BW MONITOR 0 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON0_CTRL1                             ((0x0026  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 0 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON0_CTRL2                             ((0x0027  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 0 port select for the selected channel.
#define DMC_MON0_BW                                ((0x0028  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON1_CTRL                              ((0x0029  << 2) + 0xfe036000)
  //BW monitor 1 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON1_CTRL1                             ((0x002a  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 1 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON1_CTRL2                             ((0x002b  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 1 port select for the selected channel.
#define DMC_MON1_BW                                ((0x002c  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON2_CTRL                              ((0x002d  << 2) + 0xfe036000)
  //BW monitor 2 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON2_CTRL1                             ((0x002e  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 2 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON2_CTRL2                             ((0x002f  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 2 port select for the selected channel.
#define DMC_MON2_BW                                ((0x0030  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON3_CTRL                              ((0x0031  << 2) + 0xfe036000)
  //BW monitor 3 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON3_CTRL1                             ((0x0032  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 3 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON3_CTRL2                             ((0x0033  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 3 port select for the selected channel.
#define DMC_MON3_BW                                ((0x0034  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON4_CTRL                              ((0x0035  << 2) + 0xfe036000)
  //BW monitor 4 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON4_CTRL1                             ((0x0036  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 4 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON4_CTRL2                             ((0x0037  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 4 port select for the selected channel.
#define DMC_MON4_BW                                ((0x0038  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON5_CTRL                              ((0x0039  << 2) + 0xfe036000)
  //BW monitor 5 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON5_CTRL1                             ((0x003a  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 5 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON5_CTRL2                             ((0x003b  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 5 port select for the selected channel.
#define DMC_MON5_BW                                ((0x003c  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON6_CTRL                              ((0x003d  << 2) + 0xfe036000)
  //BW monitor 6 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON6_CTRL1                             ((0x003e  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 6 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON6_CTRL2                             ((0x003f  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 6 port select for the selected channel.
#define DMC_MON6_BW                                ((0x0040  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_MON7_CTRL                              ((0x0041  << 2) + 0xfe036000)
  //BW monitor 7 address range control.  start address <= AXI address[31:16] <= end address
  //bit 31:16  End address[31:16]
  //bit 15:0.  start address[31:16]
#define DMC_MON7_CTRL1                             ((0x0042  << 2) + 0xfe036000)
   //bit 23:0.  BW monitor 7 channel select.   8 ambus port and 16 AXI port selection. 1 bit for one port.
  // if only 1 channel selected, you can use DMC_MONx_CTRL2 to chose any subid of this selected channel. otherwise DMC_MONx_CTRL2 should be set 0xffff
#define DMC_MON7_CTRL2                             ((0x0043  << 2) + 0xfe036000)
   //bit 15:0.  BW monitor 7 port select for the selected channel.
#define DMC_MON7_BW                                ((0x0044  << 2) + 0xfe036000)
  // at the test period, this range granted data cycles for the select channel and ports.
#define DMC_CMD_FILTER_CTRL1                       ((0x0050  << 2) + 0xfe036000)
  //not used.
#define DMC_CMD_FILTER_CTRL2                       ((0x0051  << 2) + 0xfe036000)
  //31:24. keep the bank active if there's urgent level 3 read bank hit request.
  //23:16. keep the bank active if there's urgent level 2 read bank hit request.
  //15:8.  keep the bank active if there's urgent level 1 read bank hit request.
  //7:0.   keep the bank active if there's urgent level 0 read bank hit request.
#define DMC_CMD_FILTER_CTRL3                       ((0x0052  << 2) + 0xfe036000)
  //bit 31.    force wbuf empty.
  //bit 30:26  wbuf high level number
  //bit 25:21  wbuf mid  level number
  //bit 20:16  wbuf low level number
  //bit 14:10  rbuf high level number
  //bit 9:5    rbuf middle level number
  //bit 4:0    rbuf low level number
#define DMC_CMD_FILTER_CTRL4                       ((0x0053  << 2) + 0xfe036000)
  //bit 29:25.  tITW.long
  //bit 24:20.  tITW. short
  //bit 19:12   tAP auto precharge the bank not used if idle that long time.
  //bit 11:6    write to read accesses if there write hit request.
  //bit 5:0     read to write accesses if there write hit request.
#define DMC_CMD_FILTER_CTRL5                       ((0x0054  << 2) + 0xfe036000)
  //bit 31:24   Once ddr data bus switch to read, the maxmum read command number to give up the bus when there's write request pending for write buffer.
  //bit 23:16   Once ddr data bus switch to write, the maxmum write command number to give up the bus when there's read request pending too long.
  //bit 15:8.   Once ddr data bus switch to read, the minimum read command number to transfer back to write stage if there's still pending read request.
  //bit 7:0.    Once ddr data bus switch to write, the minimum write command number to transfer back to read stage if there's still pending write request.
#define DMC_CMD_FILTER_CTRL6                       ((0x0055  << 2) + 0xfe036000)
  //bit 31:24   write urgent 3 request pending hold num.
  //bit 23:16   write urgent 2 request pending hold num.
  //bit 15:8.   write urgent 1 request pending hold num.
  //bit 7:0.    write urgent 0 request pending hold num.
#define DMC_CMD_FILTER_CTRL7                       ((0x0056  << 2) + 0xfe036000)
  //bit 31:24.  aw_req_pedning singal assertion after wbuf full.
  //bit 23:16   aw_req_pending singal hold how long if wbuf not full.
  //bit 15:8    write to read waiting cycles if there write hit request.
  //bit 7:0     read to write waiting cycles if there write hit request.
#define DMC_CMD_FILTER_CTRL8                       ((0x0057  << 2) + 0xfe036000)
  //bit 31:8    reserved.
  //bit 7:0     rank limit to change to another rank.
#define DMC_CMD_BUFFER_CTRL                        ((0x0058  << 2) + 0xfe036000)
  //bit 31:26  total write buffer number. default 32.
  //bit 25:20  total read buffer number. default 32.
  //bit 19:8    reserved.
  //bit 7:0    aw_pending_inc_num.  incease write ugent level 1 when write command waiting to in write buffer that long.
#define DMC_CMD_BUFFER_CTRL1                       ((0x0059  << 2) + 0xfe036000)
  //bit 29:24  read buffer number in non-urgent request.
  //bit 23:16  read buffer bank miss watch dog threshold.
  //bit 15:12  read buffer urgent level 3 counter inc weight.
  //bit 11:8   read buffer urgent level 2 counter inc weight.
  //bit 7:4    read buffer urgent level 1 counter inc weight.
  //bit 3:0    read buffer urgent level 0 counter inc weight.
#define DMC_2ARB_CTRL                              ((0x005c  << 2) + 0xfe036000)
  //32:24. Waiting limit to use the highest urgent level in the pipelines.
  //22.    1: allow to increase 2 urgent levels if waiting time is doubled than inc_ugt_limit.
  //21:12  inc_ugt_limit.  if waiting time > inc_ugt_limit, increase the urgent level by one
  //11:6.  the final arbitration control from AXI bus(port channel 0~7).
  //5:0.   the final arbitration weight control for Ambus ( port channel 8~15).
#define DMC_VERSION                                ((0x005f  << 2) + 0xfe036000)
   //read only 32'h000a0008  for sc2
#define DMC_AM0_CHAN_CTRL                          ((0x0060  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM0_HOLD_CTRL                          ((0x0061  << 2) + 0xfe036000)
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM0_CHAN_CTRL1                         ((0x0062  << 2) + 0xfe036000)
 //bit 31:    side band signal used as block other request.
 //bit 30 :   side band urgent  increase enable.
 //bit 29 :   side band urgent decrease urgent enable.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits read request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits read request.
#define DMC_AM0_CHAN_CTRL2                         ((0x0063  << 2) + 0xfe036000)
 //bit 31:24  not used.
 //bit 23:16 : when side band signal used as block other request, and side bank signal is high,  block the ambus related bits write request.
 //bit 15:0  : when side band signal used as block other request, and side bank signal is high,  block the axi bus related bits write request.
#define DMC_AM1_CHAN_CTRL                          ((0x0064  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM1_HOLD_CTRL                          ((0x0065  << 2) + 0xfe036000)
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM1_CHAN_CTRL1                         ((0x0066  << 2) + 0xfe036000)
 //bit 31:    side band signal used as block other request.
 //bit 30 :   side band urgent  increase enable.
 //bit 29 :   side band urgent decrease urgent enable.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits read request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits read request.
#define DMC_AM1_CHAN_CTRL2                         ((0x0067  << 2) + 0xfe036000)
 //bit 31:24  not used.
 //bit 23:16 : when side band signal used as block other request, and side bank signal is high,  block the ambus related bits write request.
 //bit 15:0  : when side band signal used as block other request, and side bank signal is high,  block the axi bus related bits write request.
#define DMC_AM2_CHAN_CTRL                          ((0x0068  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM2_HOLD_CTRL                          ((0x0069  << 2) + 0xfe036000)
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM2_CHAN_CTRL1                         ((0x006a  << 2) + 0xfe036000)
 //bit 31:    side band signal used as block other request.
 //bit 30 :   side band urgent  increase enable.
 //bit 29 :   side band urgent decrease urgent enable.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits read request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits read request.
#define DMC_AM2_CHAN_CTRL2                         ((0x006b  << 2) + 0xfe036000)
 //bit 31:24  not used.
 //bit 23:16 : when side band signal used as block other request, and side bank signal is high, block the ambus related bits write request.
 //bit 15:0  : when side band signal used as block other request, and side bank signal is high, block the axi bus related bits write request.
#define DMC_AM3_CHAN_CTRL                          ((0x006c  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM3_HOLD_CTRL                          ((0x006d  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM3_CHAN_CTRL1                         ((0x006e  << 2) + 0xfe036000)
 //bit 31:    side band signal used as block other request.
 //bit 30 :   side band urgent  increase enable.
 //bit 29 :   side band urgent decrease urgent enable.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits read request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits read request.
#define DMC_AM3_CHAN_CTRL2                         ((0x006f  << 2) + 0xfe036000)
 //bit 31:24  not used.
 //bit 23:16 : when side band signal used as block other request, and side bank signal is high, block the ambus related bits write request.
 //bit 15:0  : when side band signal used as block other request, and side bank signal is high, block the axi bus related bits write request.
#define DMC_AM4_CHAN_CTRL                          ((0x0070  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM4_HOLD_CTRL                          ((0x0071  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM4_CHAN_CTRL1                         ((0x0072  << 2) + 0xfe036000)
 //bit 31:    side band signal used as block other request.
 //bit 30 :   side band urgent  increase enable.
 //bit 29 :   side band urgent decrease urgent enable.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits read request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits read request.
#define DMC_AM4_CHAN_CTRL2                         ((0x0073  << 2) + 0xfe036000)
 //bit 31:24  not used.
 //bit 23:16 : when bit 31 enabled, block the ambus related bits write request.
 //bit 15:0  : when bit 31 enabled, block the axi bus related bits write request.
#define DMC_AM5_CHAN_CTRL                          ((0x0074  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM5_HOLD_CTRL                          ((0x0075  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM6_CHAN_CTRL                          ((0x0078  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM6_HOLD_CTRL                          ((0x0079  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM7_CHAN_CTRL                          ((0x007c  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AM7_HOLD_CTRL                          ((0x007d  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI0_CHAN_CTRL                         ((0x0080  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi0 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      arbiter weight
#define DMC_AXI0_HOLD_CTRL                         ((0x0081  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI0_CHAN_CTRL1                        ((0x0082  << 2) + 0xfe036000)
  //bit 31:28.  FIQ status
  //bit 27:24.  IRQ status.
  //bit 22      use ACTIVE input as clock gating control.
  //bit 21:20.  chan0 QOS mode.
  //bit 19:16.   AXI0 QOS high limit.
  //bit 15:12    AXI0 QOS mit limit.
  //bit 11  ARM  FIQ controlled super urgent enable.
  //bit 10  ARM  FIQ controlled urgent enable.
  //bit  9. ARM IRQ controlled super urgent enable.
  //bit  8. ARM IRQ controlled urgent enable.
  //bit  7.  IRQ/FIQ controll enable.
  //bit  6:5.  not used.
  //bit 4. enable AXI0 auto urgent enable. When there's no other request, treat the AXI0 as super urgent request. other wise, use the bit3:0 to set the urgent.
  //bit 3:2 A9 urgent if there's VIU request.
  //bit 1:0 A9 urgent if there's request other than VIU
#define DMC_AXI1_CHAN_CTRL                         ((0x0084  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI1_HOLD_CTRL                         ((0x0085  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI1_CHAN_CTRL1                        ((0x0086  << 2) + 0xfe036000)
  //bit 31:28.  FIQ status
  //bit 27:24.  IRQ status.
  //bit 21:20.  Mali QOS mode.
  //bit 19:16.   mail QOS high limit.
  //bit 15:12    mail QOS mit limit.
  //bit 11  ARM  FIQ controlled super urgent enable.
  //bit 10  ARM  FIQ controlled urgent enable.
  //bit  9. ARM IRQ controlled super urgent enable.
  //bit  8. ARM IRQ controlled urgent enable.
  //bit  7.  IRQ/FIQ controll enable.
  //bit  6:0.  not used.
#define DMC_AXI2_CHAN_CTRL                         ((0x0088  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI2_HOLD_CTRL                         ((0x0089  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI3_CHAN_CTRL                         ((0x008c  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI3_HOLD_CTRL                         ((0x008d  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI4_CHAN_CTRL                         ((0x0090  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI4_HOLD_CTRL                         ((0x0091  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI5_CHAN_CTRL                         ((0x0094  << 2) + 0xfe036000)
  //not used.
#define DMC_AXI5_HOLD_CTRL                         ((0x0095  << 2) + 0xfe036000)
  //not used.
#define DMC_AXI6_CHAN_CTRL                         ((0x0098  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI6_HOLD_CTRL                         ((0x0099  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI7_CHAN_CTRL                         ((0x009c  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI7_HOLD_CTRL                         ((0x009d  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI8_CHAN_CTRL                         ((0x00a0  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI8_HOLD_CTRL                         ((0x00a1  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI9_CHAN_CTRL                         ((0x00a4  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI9_HOLD_CTRL                         ((0x00a5  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI10_CHAN_CTRL                        ((0x00a8  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI10_HOLD_CTRL                        ((0x00a9  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI10_CHAN_CTRL1                       ((0x00aa  << 2) + 0xfe036000)
  //bit 11  Mali/NNA channel FIQ controlled super urgent enable.
  //bit 10  Mali/NNA channel FIQ controlled urgent enable.
  //bit  9. Mali/NNA channel IRQ controlled super urgent enable.
  //bit  8. Mali/NNA channel IRQ controlled urgent enable.
  //bit  7.  IRQ/FIQ controll enable.
  //bit  6:0.  not used.
#define DMC_AXI11_CHAN_CTRL                        ((0x00ac  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI11_HOLD_CTRL                        ((0x00ad  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI12_CHAN_CTRL                        ((0x00b0  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI12_HOLD_CTRL                        ((0x00b1  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AXI13_CHAN_CTRL                        ((0x00b4  << 2) + 0xfe036000)
  //bit 31       enable to incr 2 urgent levels if the pending cycles is doubled.
  //bit 30       enable to incr 3 urgent levels.
  //bit 29:20.   write request pending cycle number  to inc urgent level if not granted.
  //bit 19.      axi0 default urgent control : 1 use AWUGT/ARUGT pins in the port. 0 : use bit[15:14] of this register..
  //bit 18.      force this channel all request to be super urgent request.
  //bit 17.      force this channel all request to be urgent request.
  //bit 16.      force this channel all request to be non urgent request.
  //bit 15:14    axi1 default urgent level.
  //bit 13:4.    read request pending cycle number  to inc urgent level if not granted.
  //bit 3:0      canvas arbiter arbiter weight
#define DMC_AXI13_HOLD_CTRL                        ((0x00b5  << 2) + 0xfe036000)
    //31:24 write hold num.   max outstanding request number.
    //23:16  write hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
    //15:8 read hold num.   max outstanding request number.
    //7:0  read hold release num. if the outstanding request == hold num, then hold this request unless the outstanding request number bellow the hold release number, then continue to request.
#define DMC_AM0_CHAN_STS                           ((0x00b8  << 2) + 0xfe036000)
#define DMC_AM1_CHAN_STS                           ((0x00b9  << 2) + 0xfe036000)
#define DMC_AM2_CHAN_STS                           ((0x00ba  << 2) + 0xfe036000)
#define DMC_AM3_CHAN_STS                           ((0x00bb  << 2) + 0xfe036000)
#define DMC_AM4_CHAN_STS                           ((0x00bc  << 2) + 0xfe036000)
#define DMC_AM5_CHAN_STS                           ((0x00bd  << 2) + 0xfe036000)
#define DMC_AM6_CHAN_STS                           ((0x00be  << 2) + 0xfe036000)
#define DMC_AM7_CHAN_STS                           ((0x00bf  << 2) + 0xfe036000)
#define DMC_AXI0_CHAN_STS                          ((0x00c0  << 2) + 0xfe036000)
#define DMC_AXI1_CHAN_STS                          ((0x00c1  << 2) + 0xfe036000)
#define DMC_AXI2_CHAN_STS                          ((0x00c2  << 2) + 0xfe036000)
#define DMC_AXI3_CHAN_STS                          ((0x00c3  << 2) + 0xfe036000)
#define DMC_AXI4_CHAN_STS                          ((0x00c4  << 2) + 0xfe036000)
#define DMC_AXI5_CHAN_STS                          ((0x00c5  << 2) + 0xfe036000)
#define DMC_AXI6_CHAN_STS                          ((0x00c6  << 2) + 0xfe036000)
#define DMC_AXI7_CHAN_STS                          ((0x00c7  << 2) + 0xfe036000)
#define DMC_AXI8_CHAN_STS                          ((0x00c8  << 2) + 0xfe036000)
#define DMC_AXI9_CHAN_STS                          ((0x00c9  << 2) + 0xfe036000)
#define DMC_AXI10_CHAN_STS                         ((0x00ca  << 2) + 0xfe036000)
#define DMC_AXI11_CHAN_STS                         ((0x00cb  << 2) + 0xfe036000)
#define DMC_AXI12_CHAN_STS                         ((0x00cc  << 2) + 0xfe036000)
#define DMC_AXI13_CHAN_STS                         ((0x00cd  << 2) + 0xfe036000)
#define DMC_CHAN_STS                               ((0x00ce  << 2) + 0xfe036000)
  //AXI0  is first CPU and Mali combined channel from CCI-400 directly.  The first 2Gbyte address will go through this channel.
  //AXI10  is the second CPU, Mali channel combined with NNA  from NIC-400.  The upper 2Gbyte address will go through this channel.
  // read only register.
  // the second mali and NNA channel IDLE.
  // the second CPU channel IDLE.
  // the first mali channel IDLE.
  // the first CPU channel IDLE.
  //bit 27      always 1
  //bit 26      ddr0 write data buffer idle. 1 : idle 0: busy.
  //bit 25      always 1.
  //bit 24      ddr0 wbuf idle.              1 : idle 0: busy.
  //bit 23:16   ambus channel idle.          1 : idle 0: busy.
  //bit 15:0.   axibus channel idle.         1 : idle 0: busy.
#define DMC_IRQ_STS                                ((0x00cf  << 2) + 0xfe036000)
  //bit 31:3   Not used.
  //bit 2 :    QOS Monitor interrupt flag.  1: means there's QOS monitor interrup.  write 1 to clean this interrupt.
  //bit 1 :    WRITE protection interrupt.  1: means there's write protection violation.  need to write DMC_PROT_IRQ_CTRL  bit 1to clean this bit.
  //bit 0 :    read protection interrupt.   1: means there's read  protection violation.  need to write DMC_PROT_IRQ_CTRL bit 0 to clean this bit.
#define DMC_PROT0_RANGE                            ((0x00d0  << 2) + 0xfe036000)
  //protection 0 address range. the range define is 64Kbyte boundary.  current address [31:16] >= start address && current address [31:16] <= end address.
  //bit 31:16 :   range end address.
  //bit 15:0  :   range start address
#define DMC_PROT0_CTRL                             ((0x00d1  << 2) + 0xfe036000)
  //bit 23:16. each bit to enable one of the 8 ambus channal for the protection function.
  //bit 15:0   each bit to enable one of the 15 channel input for the protection function.
#define DMC_PROT0_CTRL1                            ((0x00d2  << 2) + 0xfe036000)
  //bit 26.  protection 0  read access protection enable.
  //bit 25.  protection 0  write access block function. if enabled, the access wouldn't write to the DDR SDRAM.  if not enabled only generate a interrupt, but the access still wrote to DDR.
  //bit 24.  protection range 0  write access protection enable.
#define DMC_PROT1_RANGE                            ((0x00d3  << 2) + 0xfe036000)
  //protection 1 address range. the range define is 64Kbyte boundary.  current address [31:16] >= start address && current address [31:16] <= end address.
  //bit 31:16 :   range end address.
  //bit 15:0  :   range start address
#define DMC_PROT1_CTRL                             ((0x00d4  << 2) + 0xfe036000)
  //bit 23:16. each bit to enable one of the 8 ambus channal for the protection function.
  //bit 15:0   each bit to enable one of the 15 channel input for the protection function.
#define DMC_PROT1_CTRL1                            ((0x00d5  << 2) + 0xfe036000)
  //bit 26.  protection range 1 read access protection enable bit.
  //bit 25.  protection 1  write access block function. if enabled, the access wouldn't write to the DDR SDRAM.  if not enabled only generate a interrupt, but the access still wrote to DDR.
  //bit 24.  protection range 1 write access protection enable bit.
#define DMC_PROT_VIO_0                             ((0x00d6  << 2) + 0xfe036000)
  //ddr0 write protection violation address.
#define DMC_PROT_VIO_1                             ((0x00d7  << 2) + 0xfe036000)
  //bit 31:21 . not used. always 0.
  //20     ddr0 protection 1 violation.
  //19     ddr0 protection 0 violation.
  //18:16. ddr0 write violation AWPROT bits.
  //15:0   ddr0_write violation ID.
#define DMC_PROT_VIO_2                             ((0x00d8  << 2) + 0xfe036000)
  //ddr0 read prot violation address
#define DMC_PROT_VIO_3                             ((0x00d9  << 2) + 0xfe036000)
  //bit 31:21 . not used. always 0.
  //20     ddr0 read protection 1 violation.
  //19     ddr0 read protection 0 violation.
  //18:16. ddr0 read violation ARPROT bits.
  //15:0   ddr0 read violation ID.
#define DMC_PROT_IRQ_CTRL                          ((0x00da  << 2) + 0xfe036000)
  //bit 2 :  protect function IRQ enable.
  //bit 1 :  write protection violation.  write 1 to clean write protection vio registers.
  //bit 0 :  read  protection violation.  write 1 to clean read protection vio registers.
//`define DMC_TEST_REG_BASE                32'hfe037800
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe037800
// -----------------------------------------------
#define DMC_TEST_STA                               ((0x0000  << 2) + 0xfe037800)
  //test start address.  for non-sha mode,  the last 5 bits would be ignored. the test address at 32bytes boundary.
  //                     for sha mode,      address must be in 64 bytes boundary. that mean the last 6 bits must be 0.
#define DMC_TEST_EDA                               ((0x0001  << 2) + 0xfe037800)
  //test end address.  for non-sha mode,  the last 5 bits would be ignored. the test address at 32bytes boundary.
  //                   for sha mode,       address must be in 64 bytes boundary. that mean the last 6bits must be 1.
#define DMC_TEST_CTRL                              ((0x0002  << 2) + 0xfe037800)
   //bit 31.  enable test.
   //bit 30.  when enable test, enable the write to DDR function.
   //bit 29.  when enable test, enable the read from DDR function.
   //bit 28.  when enable test,  enable the sha calculation function  must be same as read enable but without write function.
   //bit 27.  enable to compare data.  when do the read enable to enable the error comparison. suppose the read data should be same as the data in the write buffer.
   //bit 26.  0: save sha result to test_sha_message registers.  1 : don't save.
   //bit 25.  address generation type.  0: continuous increase the address in the range of test start address and test end address.
   //                                   1: test module would pick the random address from test start address  and test end address.
   //bit 24.  done type.      0 : use the DMC_TEST_NUM register as the counter of test numbers.
   //                             for write if the write command number == the DMC_TEST_NUM, the write is done.
   //                             for read if the read command number == the DMC TEST_num, the read id done. for one read command can be repeated repeat number times.
   //                         1 : finshed at end address.
   //bit 23.  wdata type.     1 : the first write is {WD3, WD2,WD1,WD0}, then the latter is the previous data plus a pattern.( { + WD7,  + WD6, + WD5, + WD4}).
   //                         0 : the WDATA is the data in write register.
   //bit 23.  1  compare the sha result with the test sha message registers. 0 : dont compare the result.
   //bit 22:20.   read repeat times.  for non-sha function, we can define multi times of the read. the test module would repeat the same adddress repeat times.
   //bit 19.     limit write.  0: no outstanding write request limitation.
   //                          1: limit the outstanding write commands to the number of bits [15:8]
   //bit 18.     limit read.   0. no outstanding read request limitation.
   //                          1. limit the read outstanding request to the number of bits[7:0].
   //bit 17:16.  sha mode for sha function enabled.  00 : not used.  01 : sha1. 2: sha2-256. 3: sha2_224. not used in GXL fixed to be  Sha 2.
   //bit 15:8.   write outstanding commands limit.
   //bit 7:0.    read  outstanding commands limit.
#define DMC_TEST_NUM                               ((0x0003  << 2) + 0xfe037800)
   // how many test command for the test if the DMC_TEST_CTRL bit 24 is 0.
#define DMC_TEST_WDG                               ((0x0004  << 2) + 0xfe037800)
  //31:16.  write response watch dog.
  //15:0.   read response  watch dog.
#define DMC_TEST_COMP_MASK                         ((0x0005  << 2) + 0xfe037800)
  //32bits for DMC TEST COMPARE bit enable.
  //1 : to MASK this bit.  0: compare this bit.
#define DMC_TEST_WSTRB0                            ((0x0006  << 2) + 0xfe037800)
  //MPC WR FIFO command DM bit write data
  //bit 31:16  the second cycle.
  //bit 15:0   the first cycle.
#define DMC_TEST_WSTRB1                            ((0x0007  << 2) + 0xfe037800)
  //MPC WR FIFO command DM bit write data
  //bit 31:16. the Forth cycle.
  //bit 15:0.  the third cycle.
#define DMC_TEST_WD0                               ((0x0010  << 2) + 0xfe037800)
   // write data 0 for write command. also for read back data comparison.
#define DMC_TEST_WD1                               ((0x0011  << 2) + 0xfe037800)
   // write data 1 for write command. also for read back data comparison.
#define DMC_TEST_WD2                               ((0x0012  << 2) + 0xfe037800)
   // write data 2 for write command. also for read back data comparison.
#define DMC_TEST_WD3                               ((0x0013  << 2) + 0xfe037800)
   // write data 3 for write command. also for read back data comparison.
#define DMC_TEST_WD4                               ((0x0014  << 2) + 0xfe037800)
   // write data 4 for write command. also for read back data comparison.
#define DMC_TEST_WD5                               ((0x0015  << 2) + 0xfe037800)
   // write data 5 for write command. also for read back data comparison.
#define DMC_TEST_WD6                               ((0x0016  << 2) + 0xfe037800)
   // write data 6 for write command. also for read back data comparison.
#define DMC_TEST_WD7                               ((0x0017  << 2) + 0xfe037800)
   // write data 7 for write command. also for read back data comparison.
#define DMC_TEST_WD8                               ((0x0018  << 2) + 0xfe037800)
   // write data 8 for write command. also for read back data comparison.
#define DMC_TEST_WD9                               ((0x0019  << 2) + 0xfe037800)
   // write data 9 for write command. also for read back data comparison.
#define DMC_TEST_WD10                              ((0x001a  << 2) + 0xfe037800)
   // write data 10 for write command. also for read back data comparison.
#define DMC_TEST_WD11                              ((0x001b  << 2) + 0xfe037800)
   // write data 11 for write command. also for read back data comparison.
#define DMC_TEST_WD12                              ((0x001c  << 2) + 0xfe037800)
   // write data 12 for write command. also for read back data comparison.
#define DMC_TEST_WD13                              ((0x001d  << 2) + 0xfe037800)
   // write data 13 for write command. also for read back data comparison.
#define DMC_TEST_WD14                              ((0x001e  << 2) + 0xfe037800)
   // write data 14 for write command. also for read back data comparison.
#define DMC_TEST_WD15                              ((0x001f  << 2) + 0xfe037800)
   // write data 15 for write command. also for read back data comparison.
#define DMC_TEST_RD0                               ((0x0020  << 2) + 0xfe037800)
   // the read back data 0.  if error happens, it would capture the first error data.
#define DMC_TEST_RD1                               ((0x0021  << 2) + 0xfe037800)
   // the read back data 1.  if error happens, it would capture the first error data.
#define DMC_TEST_RD2                               ((0x0022  << 2) + 0xfe037800)
   // the read back data 2.  if error happens, it would capture the first error data.
#define DMC_TEST_RD3                               ((0x0023  << 2) + 0xfe037800)
   // the read back data 3.  if error happens, it would capture the first error data.
#define DMC_TEST_RD4                               ((0x0024  << 2) + 0xfe037800)
   // the read back data 4.  if error happens, it would capture the first error data.
#define DMC_TEST_RD5                               ((0x0025  << 2) + 0xfe037800)
   // the read back data 5.  if error happens, it would capture the first error data.
#define DMC_TEST_RD6                               ((0x0026  << 2) + 0xfe037800)
   // the read back data 6.  if error happens, it would capture the first error data.
#define DMC_TEST_RD7                               ((0x0027  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD8                               ((0x0028  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD9                               ((0x0029  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD10                              ((0x002a  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD11                              ((0x002b  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD12                              ((0x002c  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD13                              ((0x002d  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD14                              ((0x002e  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_RD15                              ((0x002f  << 2) + 0xfe037800)
   // the read back data 7.  if error happens, it would capture the first error data.
#define DMC_TEST_ERR_ADDR                          ((0x0040  << 2) + 0xfe037800)
  //read only. it capture the first error address.
#define DMC_TEST_ERR_CNT                           ((0x0041  << 2) + 0xfe037800)
  //read only. how many data error happens in the whole test period.
#define DMC_TEST_STS                               ((0x0042  << 2) + 0xfe037800)
  //read only.
  //bit 31,   test done bit. write 1 to clean.
  //bit 30,   indicate address err
  //bit 29~7.  not used.
  //bit 6.    read data resp error(caused by security or rd latency).
  //bit 5.    test MRR/MPR rd latency error. write 1 clear
  //bit 4,    sha done.     write 1 to clean.
  //bit 3,    write done.   write 1 to clean.
  //bit 2,    read done.    write 1 to clean
  //bit 1,    write watchdog triggered.   write 1 to clean
  //bit 0,    read watchdog triggered.    write 1 to clean.
#define DMC_TEST_WRCMD_ADDR                        ((0x0043  << 2) + 0xfe037800)
  //read only. the current write cmd address.
#define DMC_TEST_RDCMD_ADDR                        ((0x0044  << 2) + 0xfe037800)
   //read only. the current read command address.
#define DMC_TEST_RDRSP_ADDR                        ((0x0045  << 2) + 0xfe037800)
  //read only. the failed read response address(for error data )
//
// Closing file:  ../mmc_lp4/dmc/rtl/dmc_reg.vh
//
//
// Reading file:  ../mmc_lp4/dmc/rtl/dmc_siu_reg.vh
//
//`define DMC_DRAM_REG_BASE      32'hfe036400
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe036400
// -----------------------------------------------
//there's 2 set of timing DDR timing parameter for 2 set of DDR freqency parameter.
//when change frequency, the hardware would automatically select one of these two set of timing parameter
//DMC_DRAM_* is for Frequency set 0.
//DMC_NFQ_* is for Freqency set 1.
#define DMC_DRAM_TMRD                              ((0x0000  << 2) + 0xfe036400)
   //bit 4:0.  tMRD. //MR command cycles, in DDR3/4.  in LPDDR4, it should be value of tMRW
#define DMC_DRAM_TRFC                              ((0x0001  << 2) + 0xfe036400)
   //bit 9:0 tRFC
#define DMC_DRAM_TRP                               ((0x0002  << 2) + 0xfe036400)
   //bit 21:16.  tRP for precharge all banks.
   //bit 5:0.    tRP for precharge one bank.
#define DMC_DRAM_TRTW                              ((0x0003  << 2) + 0xfe036400)
   //bit 31:6:   Not used.
   //bit 5:0     DDR3/4 mode : tRTW.
   // For LPDDR4 .  The total read command -> write command = (RL + BL/2 - tWODTON) + TDQSCK_MAX + tWPRE +RD(tRPST).
   //                 tRTW = TDQSCK_max + tWPRE + tRD(tRPST)  + (delay margin)
#define DMC_DRAM_TCL                               ((0x0004  << 2) + 0xfe036400)
  //bit 5:0  tCL/tRL. read latency.
#define DMC_DRAM_TCWL                              ((0x0005  << 2) + 0xfe036400)
  //bit 5:0.  CWL:  write latency.
#define DMC_DRAM_TRAS                              ((0x0006  << 2) + 0xfe036400)
  //bit 7:0.  tRAS.  minimum active to precharge time for same bank.
#define DMC_DRAM_TRC                               ((0x0007  << 2) + 0xfe036400)
  //bit 7:0.  tRC.  minimum active to active time for same bank.
#define DMC_DRAM_TRCD                              ((0x0008  << 2) + 0xfe036400)
  //bit 7:0  tRCD  active to read/write timing for same bank.
#define DMC_DRAM_TRRD                              ((0x0009  << 2) + 0xfe036400)
  //bit 21:16.  tRRD_l  active bank A to active B in same band group for DDR4.
  //bit 5:0.    tRRD/tRRD_s   active bank A to active bank b time.
              //tRRD_s:   active bank A to active bank b in different bank grousp for DDR4.
#define DMC_DRAM_TFAW                              ((0x000a  << 2) + 0xfe036400)
  //bit 8:0   tFAW.  four active command windows
#define DMC_DRAM_TRTP                              ((0x000b  << 2) + 0xfe036400)
  //bit 5:0  tRTP.
#define DMC_DRAM_TWR                               ((0x000c  << 2) + 0xfe036400)
  //bit 5:0 tWR.
#define DMC_DRAM_TWTR                              ((0x000d  << 2) + 0xfe036400)
  //bit 21:16 tWTR_l   For DDR4 WTR_l.  FOR DDR3/LPDDR4 same as tWTR_s.
  //bit 5:0 tWTR_s.
#define DMC_DRAM_TCCD                              ((0x000e  << 2) + 0xfe036400)
  //bit 19:16. tCCD/tCCD_l.
  //bit 3:0 tCCD/tCCD_s    read to read command time or write to write command time.
#define DMC_DRAM_TEXSR                             ((0x000f  << 2) + 0xfe036400)
  //bit 12:0. tEXSR.  EXIT SELF-REFRESH to read/write command.
#define DMC_DRAM_TXS                               ((0x0010  << 2) + 0xfe036400)
  //bit 9:0  tXS.  EXIT SELF_REFRESH to other command time
#define DMC_DRAM_TXP                               ((0x0011  << 2) + 0xfe036400)
  //bit 3:0. tXP.  EXIT power down to other command time
#define DMC_DRAM_TXPDLL                            ((0x0012  << 2) + 0xfe036400)
  //bit 12:0.  tXPDLL,  EXIT power down to read/write command time(need to relock PLL).
#define DMC_DRAM_TZQCS                             ((0x0013  << 2) + 0xfe036400)
  //bit 11:0.  ZQCS command to other command time.
#define DMC_DRAM_TCKSRE                            ((0x0014  << 2) + 0xfe036400)
  //bit 4:0. enter self refresh to disable clock time.
#define DMC_DRAM_TCKSRX                            ((0x0015  << 2) + 0xfe036400)
  //bit 4:0. enable clock to exit self refresh time.
#define DMC_DRAM_TCKE                              ((0x0016  << 2) + 0xfe036400)
  //bit 4:0.  CKE high or low minimum time.
#define DMC_DRAM_TMOD                              ((0x0017  << 2) + 0xfe036400)
  //bit 4:0  tMOD.  MRR/MRW to other command time. in LPDDR4, still use this register but it called tMRD.
#define DMC_DRAM_TDQS                              ((0x0018  << 2) + 0xfe036400)
  //bit 31:28 reserved
  //bit 27:24 tDQS. the delay for write after read in different rank.
  //bit 23:20 reserved
  //bit 19:16 tDQS. the delay for read after write in different rank.
  //bit 15:12 reserved
  //bit 11:8  tDQS. the delay for write after write in different rank.
  //bit 7:4 reserved
  //bit 3:0 tDQS. the delay for read after read in different rank.
#define DMC_DRAM_TRSTL                             ((0x0019  << 2) + 0xfe036400)
  //not used.
#define DMC_DRAM_TZQLAT                            ((0x001a  << 2) + 0xfe036400)
  //bit 5:0 ZQ LATCH command to other comand timing in LPDDR4 mode.
#define DMC_DRAM_TMRR                              ((0x001b  << 2) + 0xfe036400)
  //bit 7:0 tMRR  not used in DMC.
#define DMC_DRAM_TCKESR                            ((0x001c  << 2) + 0xfe036400)
 //bit 9:0 tCKESR.   CKE low minimum pulse in self refresh mode.
#define DMC_DRAM_TDPD                              ((0x001d  << 2) + 0xfe036400)
 //not support.
#define DMC_DRAM_DFITCTRLDELAY                     ((0x001e  << 2) + 0xfe036400)
  //bit 3:0. DFI_t_ctrldealy
#define DMC_DRAM_DFITPHYWRDATA                     ((0x001f  << 2) + 0xfe036400)
  //bit 5:0.  dfi_t_phy_wrdata.
#define DMC_DRAM_DFITPHYWRLAT                      ((0x0020  << 2) + 0xfe036400)
  //bit 5:0.  dfi_t_phy_wrlat.  in DDR3/4/LPDDR3 mode:   WL -5.   in LPDDR4 mode: WL -5 + 2.
#define DMC_DRAM_DFITRDDATAEN                      ((0x0021  << 2) + 0xfe036400)
  //bit 5:0.  dfi_t_rddata_en.  in DDR3/4/LPDDR3 mode: RL -5. in LPDDR4 mode : RL -5 + 1.
#define DMC_DRAM_DFITPHYRDLAT                      ((0x0022  << 2) + 0xfe036400)
  //bit 5:0.  dfi_t_rdlat.
#define DMC_DRAM_DFITCTRLUPDMIN                    ((0x0023  << 2) + 0xfe036400)
  //bit 7:0.  CTRLUPD_MIN  minimum clock cycle to maintain CTRLUPD_REQ.
#define DMC_DRAM_DFITCTRLUPDMAX                    ((0x0024  << 2) + 0xfe036400)
  //bit 7:0   CTRLUPD_MAX.  maxmum clock cycle to maintain CTRLUPD_REQ if no CTRLUPD_ACK response.
#define DMC_DRAM_DFITREFMSKI                       ((0x0026  << 2) + 0xfe036400)
  //not used.
#define DMC_DRAM_DFITCTRLUPDI                      ((0x0027  << 2) + 0xfe036400)
  //not used.
#define DMC_DRAM_DFITDRAMCLK                       ((0x0028  << 2) + 0xfe036400)
//bit 17    dram clk1 enable.
//bit 16    dram clk0 enable.
//bit 15:8  DRAM CLK disable waiting time
//bit 7:0   DRAM CLK enable  enable timer
#define DMC_DRAM_DFITLPRESP                        ((0x002a  << 2) + 0xfe036400)
  //bit 3:0.  dfi_lp_ctrl_req response time. after dfi_lp_ctrl_req asserted, and after response time if there's still no dfi_lp_ack respone, then drop the dfi_lp_ctrl_req.
#define DMC_DRAM_TCKECK                            ((0x002c  << 2) + 0xfe036400)
 //bit 4:0. tCKECK  from CKE low to assert dfi_dram_clk_disable time. this time + dfi_t_ctrl_delay
#define DMC_DRAM_TREFI                             ((0x002d  << 2) + 0xfe036400)
 //write this register will update the auto refresh related register to the auto refresh control logic.
 //bit 31:24:  tZQCI dmc send zqci period.  unit is how much auto refresh period.
 //bit 23:16   pvti  dmc send dfi_ctrlupd_req period.  unit is one auto refresh period.
 //bit 15:8.   tREFI.dmc send auto refresh command period. unit is 100ns.
 //bit 7:0.    t100ns period. unit is dmc clock cycles
#define DMC_DRAM_TSR                               ((0x002e  << 2) + 0xfe036400)
  //bit 5:0 tSR.  self resfresh enter to exit time.
#define DMC_DRAM_TCCDMW                            ((0x002f  << 2) + 0xfe036400)
  //bit 5:0.  4*tCCD in LPDDR4 mask write.
#define DMC_DRAM_TESCKE                            ((0x0030  << 2) + 0xfe036400)
  //bit 5:0  tESCKE.  enter self refresh to power time for LPDDR4.
#define DMC_DRAM_TREFI_DDR3                        ((0x0031  << 2) + 0xfe036400)
  //7:0. DDR3 SDRAM tREFI single auto refresh time . the unit is t100ns.
  //use this to check in 8*tREFI time, the DMC should not sent more than 16 auto REFRESH command.
#define DMC_DRAM_TZQCAL                            ((0x0032  << 2) + 0xfe036400)
  //11:0. ZQCAL for LPDDR4. ZQINIT/ZQoper for DDR3/4 ZQCL command.
#define DMC_DRAM_T10US                             ((0x0033  << 2) + 0xfe036400)
  //10us clock cycle number used for LP2 mode.
#define DMC_DRAM_TMRRI                             ((0x0034  << 2) + 0xfe036400)
//bit 7:0   tMRRI for MRR
#define DMC_DRAM_TXS_FAST                          ((0x0035  << 2) + 0xfe036400)
 //bit 9:0 DDR4 mode XS_FAST exit self_refrest to zqcl/zqcs/mrs command.
#define DMC_DRAM_DFIODTCFG                         ((0x0036  << 2) + 0xfe036400)
  //bit 12.  rank1 ODT default. default value for ODT[1] pins if theres no read/write activity.
  //bit 11.  rank1 ODT write sel.  enable ODT[1] if there's write occur in rank1.
  //bit 10.  rank1 ODT write nsel. enable ODT[1] if theres's write occur in rank0.
  //bit 9.   rank1 odt read sel.   enable ODT[1] if there's read occur in rank1.
  //bit 8.   rank1 odt read nsel.  enable ODT[1] if there's read occure in rank0.
  //bit 4.   rank0 ODT default.    default value for ODT[0] pins if theres no read/write activity.
  //bit 3.   rank0 ODT write sel.  enable ODT[0] if there's write occur in rank0.
  //bit 2.   rank0 ODT write nsel. enable ODT[0] if theres's write occur in rank1.
  //bit 1.   rank0 odt read sel.   enable ODT[0] if there's read occur in rank0.
  //bit 0.   rank0 odt read nsel.  enable ODT[0] if there's read occure in rank1.
#define DMC_DRAM_DFIODTCFG1                        ((0x0037  << 2) + 0xfe036400)
  //bit 27:24  ODT length for BL8 read transfer.
  //bit 19:16. ODT length for BL8 write transfer.
  //bit 12:8.  ODT latency for reads.  suppose to be 0.
  //bit 4:0.   ODT latency for writes.  suppose to be 0.
#define DMC_DRAM_TWODTON                           ((0x0038  << 2) + 0xfe036400)
  //bit 5:0   DRAM write access ODT on time.
  //   in DDR3/4 should be same as WL.
  //   in LPDDR4 ODT enable  mode:  tODTLon + tODTon.min
  //   In LPDDR4 ODT disable mode:  tWL.
#define DMC_DRAM_TRETRAIN                          ((0x0039  << 2) + 0xfe036400)
 //bit 15:0 LPDDR4 OSCRING retraining timer(units = auto_refresh timer). sync with autorefresh
#define DMC_DRAM_PHYADDRON                         ((0x003a  << 2) + 0xfe036400)
  //bit 5:0 PHY_CTRL_ADDR_ON for new PHY. default : 12 unit: DfiClk
#define DMC_DRAM_PHYWRON                           ((0x003b  << 2) + 0xfe036400)
  //bit 6:0 PHY_CTRL_ADDR_ON for new PHY. unit: ddr clk
  // PHY_CTRL_WR_ON.  = 20 + WL + (tDQSS+ tDQS2DQ + tWPST)/ddr_clk + BL/2
#define DMC_DRAM_PHYRDON                           ((0x003c  << 2) + 0xfe036400)
  // PHY_CTRL_RD_ON.  = 20 + RL + (tDQSCK+ tRPST + tDQSQ)/ddr_clk + BL/2
#define DMC_DRAM_ZQCTRL                            ((0x003d  << 2) + 0xfe036400)
  //tZQCI bits in DMC_DRAM_TREFI  defined how many refresh period send ZQCS/ZQUPD/command.
  //this register defines in 0~tZQCI period, which refresh period count to send partial ZQCS/ZACAL/ZQUPD command
  //31:24.  in LPDDR4 case when to send ZQLAT comman to both RANKs of LPDDR4 SDRAM
  //23:16.  when to send PHY ZQ UPDATE command.
  //15:8.   when to send ZQCS/ZQCAL to rank1 DDR SDRAM.
  //7:0.    when to senc ZQCS/ZQCAL to rank0 DDR SDRAM.
//timing paramter for frequency set 1.
#define DMC_NFQ_TMRD                               ((0x0040  << 2) + 0xfe036400)
#define DMC_NFQ_TRFC                               ((0x0041  << 2) + 0xfe036400)
#define DMC_NFQ_TRP                                ((0x0042  << 2) + 0xfe036400)
#define DMC_NFQ_TRTW                               ((0x0043  << 2) + 0xfe036400)
#define DMC_NFQ_TCL                                ((0x0044  << 2) + 0xfe036400)
#define DMC_NFQ_TCWL                               ((0x0045  << 2) + 0xfe036400)
#define DMC_NFQ_TRAS                               ((0x0046  << 2) + 0xfe036400)
#define DMC_NFQ_TRC                                ((0x0047  << 2) + 0xfe036400)
#define DMC_NFQ_TRCD                               ((0x0048  << 2) + 0xfe036400)
#define DMC_NFQ_TRRD                               ((0x0049  << 2) + 0xfe036400)
#define DMC_NFQ_TFAW                               ((0x004a  << 2) + 0xfe036400)
#define DMC_NFQ_TRTP                               ((0x004b  << 2) + 0xfe036400)
#define DMC_NFQ_TWR                                ((0x004c  << 2) + 0xfe036400)
#define DMC_NFQ_TWTR                               ((0x004d  << 2) + 0xfe036400)
#define DMC_NFQ_TCCD                               ((0x004e  << 2) + 0xfe036400)
#define DMC_NFQ_TEXSR                              ((0x004f  << 2) + 0xfe036400)
#define DMC_NFQ_TXS                                ((0x0050  << 2) + 0xfe036400)
#define DMC_NFQ_TXP                                ((0x0051  << 2) + 0xfe036400)
#define DMC_NFQ_TXPDLL                             ((0x0052  << 2) + 0xfe036400)
#define DMC_NFQ_TZQCS                              ((0x0053  << 2) + 0xfe036400)
#define DMC_NFQ_TCKSRE                             ((0x0054  << 2) + 0xfe036400)
#define DMC_NFQ_TCKSRX                             ((0x0055  << 2) + 0xfe036400)
#define DMC_NFQ_TCKE                               ((0x0056  << 2) + 0xfe036400)
#define DMC_NFQ_TMOD                               ((0x0057  << 2) + 0xfe036400)
#define DMC_NFQ_TDQS                               ((0x0058  << 2) + 0xfe036400)
#define DMC_NFQ_TRSTL                              ((0x0059  << 2) + 0xfe036400)
#define DMC_NFQ_TZQLAT                             ((0x005a  << 2) + 0xfe036400)
#define DMC_NFQ_TMRR                               ((0x005b  << 2) + 0xfe036400)
#define DMC_NFQ_TCKESR                             ((0x005c  << 2) + 0xfe036400)
#define DMC_NFQ_TDPD                               ((0x005d  << 2) + 0xfe036400)
#define DMC_NFQ_DFITCTRLDELAY                      ((0x005e  << 2) + 0xfe036400)
#define DMC_NFQ_DFITPHYWRDATA                      ((0x005f  << 2) + 0xfe036400)
#define DMC_NFQ_DFITPHYWRLAT                       ((0x0060  << 2) + 0xfe036400)
#define DMC_NFQ_DFITRDDATAEN                       ((0x0061  << 2) + 0xfe036400)
#define DMC_NFQ_DFITPHYRDLAT                       ((0x0062  << 2) + 0xfe036400)
#define DMC_NFQ_DFITCTRLUPDMIN                     ((0x0063  << 2) + 0xfe036400)
#define DMC_NFQ_DFITCTRLUPDMAX                     ((0x0064  << 2) + 0xfe036400)
#define DMC_NFQ_DFITREFMSKI                        ((0x0066  << 2) + 0xfe036400)
#define DMC_NFQ_DFITCTRLUPDI                       ((0x0067  << 2) + 0xfe036400)
#define DMC_NFQ_DFITDRAMCLK                        ((0x0068  << 2) + 0xfe036400)
#define DMC_NFQ_DFITLPRESP                         ((0x006a  << 2) + 0xfe036400)
#define DMC_NFQ_TCKECK                             ((0x006c  << 2) + 0xfe036400)
#define DMC_NFQ_TREFI                              ((0x006d  << 2) + 0xfe036400)
#define DMC_NFQ_TSR                                ((0x006e  << 2) + 0xfe036400)
#define DMC_NFQ_TCCDMW                             ((0x006f  << 2) + 0xfe036400)
#define DMC_NFQ_TESCKE                             ((0x0070  << 2) + 0xfe036400)
#define DMC_NFQ_TREFI_DDR3                         ((0x0071  << 2) + 0xfe036400)
#define DMC_NFQ_TZQCAL                             ((0x0072  << 2) + 0xfe036400)
#define DMC_NFQ_T10US                              ((0x0073  << 2) + 0xfe036400)
#define DMC_NFQ_TMRRI                              ((0x0074  << 2) + 0xfe036400)
#define DMC_NFQ_TXS_FAST                           ((0x0075  << 2) + 0xfe036400)
#define DMC_NFQ_DFIODTCFG                          ((0x0076  << 2) + 0xfe036400)
#define DMC_NFQ_DFIODTCFG1                         ((0x0077  << 2) + 0xfe036400)
#define DMC_NFQ_TWODTON                            ((0x0078  << 2) + 0xfe036400)
#define DMC_NFQ_TRETRAIN                           ((0x0079  << 2) + 0xfe036400)
#define DMC_NFQ_PHYADDRON                          ((0x007a  << 2) + 0xfe036400)
#define DMC_NFQ_PHYWRON                            ((0x007b  << 2) + 0xfe036400)
#define DMC_NFQ_PHYRDON                            ((0x007c  << 2) + 0xfe036400)
#define DMC_NFQ_ZQCTRL                             ((0x007d  << 2) + 0xfe036400)
//end of second frequency timing parameter
#define DMC_DRAM_DFITPHYUPDTYPE0                   ((0x0080  << 2) + 0xfe036400)
 //dfi_phyupd_ack hold time for dfi_phyupd_req type = 0.
#define DMC_DRAM_DFITPHYUPDTYPE1                   ((0x0081  << 2) + 0xfe036400)
 //dfi_phyupd_ack hold time for dfi_phyupd_req type = 1.
#define DMC_DRAM_DFITPHYUPDTYPE2                   ((0x0082  << 2) + 0xfe036400)
 //dfi_phyupd_ack hold time for dfi_phyupd_req type = 2.
#define DMC_DRAM_DFITPHYUPDTYPE3                   ((0x0083  << 2) + 0xfe036400)
 //dfi_phyupd_ack hold time for dfi_phyupd_req type = 3.
#define DMC_DRAM_MCFG                              ((0x0086  << 2) + 0xfe036400)
 //bit 31:27  not used.
 //bit 26:24  rank1_d16_sel.  16bit mode, rank 1 byte selection.
 //bit 23     not used.
 //bit 22:20. rank0_d16_sel. 16bit mode, rank 0 byte selection.
 //bit 19.   send PHY ZQ command  after siu self refresh exit. 1 : enable.  0 : disable.
 //bit 18.   send retrain command after siu self refresh exit. 1 : enable. 0 : disable.
 //bit 17.   in DDR3/4 mode, send ZQCL command after exit register triggered self refresh.
 //bit 16.   send refresh command after finish frequency change. 1 : enable. 0 : disable.
 //bit 15.   send refresh command after finish LPDDR4 retraining. 1 : enable. 0 : disable.
 //bit 14.   1: cke init low.  0 : cke init high.
 //bit 13    1: dbi write enable only for LPDDR4.
 //bit 12.   1: dbi read inversion.   0:  dbi read high inversion.
 //bit 11.   1: dbi read enable. 0:  dbi not enabled.
 //bit 10    1: enable staggered chip select for 2 ranks DRAM.
 //bit 9     1: enable send auto refresh command to DDR SDRAM when PCTL is in CFG/STOP state.
 //bit 8     send auto refr cmd before enter register triggered  self refresh
 //bit 7     send auto refr cmd after exit register triggered self refresh mode.
 //bit 6     disable dram clock after enter register triggered self refresh.
 //bit 5     send DFI_LP_REQ to PHY after enter register triggered elf refresh mode.
 //bit 4     send DRAM to power down mode after enter self refresh. ONLY for LPDDR4.
 //bit 3     send DFI_CTRLUPD_REQ after exit register triggered self refresh.
 //bit 2     send ZQCS command after exit register triggered self refresh.
 //bit 1     enable PHY triggered DFI_PHYUPD_REQ.
 //bit 0     2T mode. always 1 in DDR3/4 mode.
#define DMC_DRAM_ZQ_CTRL                           ((0x0087  << 2) + 0xfe036400)
 //bit 2  ZQ command must be send in different time.
 //bit 1  ZQ command can be send at same time.
 //bit 0  rank0 ZQ only
#define DMC_DRAM_MCFG1                             ((0x0088  << 2) + 0xfe036400)
 //bit7:0 LPDDR4 WDBI mode maskwrite dbi pattern
#define DMC_DRAM_DFI_CTRL                          ((0x0089  << 2) + 0xfe036400)
  //bit 31 siu_dfi_lat err generation enable.  1: if dfi read latency violation, generate data error. 0 : disable.
  //bit 20 phy_ctrl_rd_on phy_ctrl_wr_on ignore 16bit mode.  1: sending 0xf in 16bit mode.  0: sending valid byte enable in 16bit mode
  //bit 19: dfi_init_complete wait enable.  1: after dfi_init_complete, wait additional EXSR time for new command. 0: phy will handle all the timing    after dfi_init_complete DMC can do everything they want.
  //bit 18:  dfi_rddata_cs_n polarity.  0:  rank0 select = 2'b10. rank1 select = 2'b10. 1: rank0 select = 2'b01, rank1_select = 2'b10.
  //bit 17:  dfi_wrdata_cs_n polarity.  0:  rank0 select = 2'b10. rank1 select = 2'b10. 1: rank0 select = 2'b01, rank1_select = 2'b10.
  //bit 16:  force PHY ctrl_on  if = 1, phy_ctrl_on singal will keep on.
   //bit 15 siu_dfi1_lp_en
  //bit 14 siu_dfi_lp_ack_and
  //bit 13 siu_dfi_lp_ack_or
  //bit 12 siu_dfi1_init_start_en
  //bit 11 siu_dfi_init_com_and
  //bit 10 siu_dfi_init_com_or
  //bit  9 siu_dfi1_freq_en
  //bit  8 siu_dfi1_dram_clk_dis_en
  //bit  7 siu_dfi_phyupd_type_sel
  //bit  6 siu_dfi1_phyupd_ack_en
  //bit  5 siu_dfi_phyupd_req_and
  //bit  4 siu_dfi_phyupd_req_or
  //bit  3 siu_dfi_ctrlupd_ack_and
  //bit  2 siu_dfi_ctrlupd_ack_or
  //bit  1 siu_dfi1_ctrlupd_req_en
  //bit  0 siu_dfi1_cmd_en
#define DMC_DRAM_DFIINITCFG                        ((0x008a  << 2) + 0xfe036400)
  //bit 31.   dfi_init_complete status. read only.
  //bit 15:14.  Frequency set 1 dfi_freq_ratio value.
  //bit 12:8    Frequency set 1 dfi_freq value.
  //bit 7:6     Frequency set 0 dfi_freq_ratio value.
  //bit 5:1     Frequency set 0 dfi_freq value.
  //bit 0.      dfi_init_start value  can be use manually config dfi_init_start signal.
#define DMC_DRAM_APD_CTRL                          ((0x008c  << 2) + 0xfe036400)
 //bit 19:16  DFI_LP_WAKEUP value in APD DFI_LP_REQ mode
 //bit 12    1: exit power down slow mode(waiting PLL LOCK).  0 : fast mode.
 //bit 11    enable DFI_LP_REQ when enter Auto power down mode.
 //bit 10    disable DFI_clk_disable when enter auto power down mode.
 //bit 9:0    0  disable auto power down mode.
            //non zero value to enable auto power down when DMC is in idle state for this number of clock cycles.
#define DMC_DRAM_ASR_CTRL                          ((0x008d  << 2) + 0xfe036400)
  //bit 31. enable RETRAIN PHY after auto selfrefresh exit. for AM_PHY only.
  //bit 30. in DDR3/4 mode, send ZQCL command after exit from auto self refresh mode.
  //bit 29. enable PHY clock in LP2 mode.  1: enable. 0 : disable.
  //bit 28. enable dmc wait 10us after LP2 mode exit if it's long time the PHY in LP2 mode..
  //bit [27:24] DFI_LP_WAKEUP value in self refresh DFI_LP_REQ mode.
  //bit 23 : send REFRESH command after exit from auto self refersh mode(ASR).
  //bit 22 : send REFERSH command before enter to Auto self refresh mode(ASR).
  //bit 21 : send ZQCS command after exit from Auto self refresh mode(ASR).
  //bit 20 : send dfi_ctrl_upd after exit from ASR mode
  //bit 19 : send power down command when enter ASR mode. //for LPDDR4 only.
  //bit 18 : set the PHY enter LP2 mode after enter ASR mode.
  //bit 17 : send DFI_LP_REQ  after enter ASR mode.
  //bit 16 : set DFI_CLK_DISABLE after enter ASR mode.
  //bit 15:0.   0 disable auto ASR mode.
             // Non-zero value enable ASR mode. when DMC is in idle state for this number of clock cycles, the DMC will enter ASR mode.
#define DMC_DRAM_REFR_CTRL                         ((0x0092  << 2) + 0xfe036400)
  //bit 22  dmc to control DFI_CTRLUPD_REQ  with zq generation together.
  //bit 21  dmc to control PHY ZQ generation enable.
  //bit 20  dmc to control zqlat(in LPDDR4 mode) generation enable.
  //bit 19  dmc to control zqcs1 generation enable.
  //bit 18  dmc to control zqcs0 generation enable.
  //bit 17:8 auto refresh request pending cnt if there's page hit request.
  //bit 7  retrain enable for auto refresh frequent. 1: enable. 0: disable.
  //bit 6  Disabled auto refresh command if over 16 auto refresh command sent in 2 TREFI_DDR3 period
  //bit 5  enable dmc send ZQCS command .
  //bit 4. enable dmc send DFI_CTRUPD_REQ.
  //bit 3:1. how many refresh command send for one period. = this number + 1
  //bit 0.  enable dmc send auto refresh command.
#define DMC_DRAM_FREQ_CTRL                         ((0x0093  << 2) + 0xfe036400)
//bit 31 .  write 1 to change freqency   read 0: finished.
//bit 30.   waiting for software to send some manual command.  1 : waiting. 0 : not ready yet.
//bit 29:22.  not used.
//bit 21     after Freqchange send PHY ZQ update.
//bit 20    send CTRLUPD_REQ to PHY after freq_change finished.
//bit 19:16. how many cycles to send PLL change req after init_complete signal to low.
//bit 15.   freq pre  config_en. Before freq enter stop state let DMC configure DDR SDRAM.
//bit 14.   freq post config_en. After  freq enter stop state let DMC configure DDR SDRAM.
//bit 13.   send zqcl after freq change in DDR3/4 mode.
//bit 12.   send zqcs after freq change. 1: enable. 0 not send.
//bit 11.   in AUTO MRW function: the data format.  1: use USR_CMD format.  0: MRW format.
//bit 10.   AUTO MRW function:  1 use hardware auto MRW function.  0: don't do auto MRW.
//bit 9.  1 : FREQ MRW done. let FREQ change machine continue.
//bit 8   FREQ WAIT. 1 when freq change finishes, state machine stop at self refresh state in case there's something need to handle.
              //     0 after freq change finishes  the state machine go back to access state.
//bit 7   when change PLL setting, disable dmc clock
//bit 6   when change PLL setting, disable PHY DfiClk and DfiCtlClk.
//bit 5   check vpu_sleep_en ==1 when do FREQ change.  if vpu_sleep_en == 0, just wait.
//bit 4   nxt frequency selection.  1 = freq1. 0 = freq0.
//bit 3:1.  not used.
//bit 0.   current frequency selection.
#define DMC_DRAM_SCFG                              ((0x0094  << 2) + 0xfe036400)
  // bit 2:0 only one bit can be high at same time.
  // bit 2  1 : to ask PCTL enter ACCESS STATE.  0 : deassert the request.
  // bit 1  1 : to ask PCTL enter SELF REFRESH STATE.  0 : deassert the request.
  // bit 0  1 : to ask PCTL enter STOP/CONFIG STATE .  0 : deassert the request.
#define DMC_DRAM_STAT                              ((0x0095  << 2) + 0xfe036400)
  //bit 31     rd latency error. 1: means after dfiphytrdlat cycles, the read data still not back.
  //bit 28:24   dram_sr_state
  //bit 23:20   stop_st
  //bit 19:15   sleep_st
  //bit 14:12  ACCESS STATUS 0 :  ACCESS is in normal working mode.
                          //1 :   ACCESS sending precharge command.
                          //2 :   ACCESS sending AUTO refresh command.
                          //3 :   ACCESS sending DIF_CTRLUPD_REQ command.
                          //4 :   ACCESS sending ZQCS command to DDR DRAM(ZQCAL for LPDDR4).
                          //5 :   ACCESS sending ZQLATCH command to  LPDDR4 only.
  //bit 11:8   APD STATUS:   0 :   APD_IDLE
                          //1 :    APD sending PRECHARGE command
                          //2 :    APD sending CKE low command
                          //3 :    APD sending DISABLE DRAM CLOCK command
                          //4 :    APD sending DFI_LP_CTRL_REQ
                          //5 :    APD in Auto Power down mode.
                          //6 :    APD deassert DFI_LP_CTRL_REQ
                          //7 :    APD sending enable DRAM CLOCK command
                          //8 :    APD sending out CKE high command.
  //bit 7:4: DRAM_STATUS:  0  :    DRAM IDLE
                         //1  :    DRAM_STOP/DRAM_CFG
                         //2  :    DRAM_ACCESS
                         //3  :    DRAM_SLEEP
                         //4  :    DRAM APD(AUTO POWER DOWN).
                         //5  :    IDLE -> STOP/CONFIG
                         //6  :    STOP -> SLEEP
                         //7  :    STOP -> ACCESS
                         //8  :    ACCESS -> SLEEP.
                         //9  :    ACCESS -> STOP
                         //A  :    ACCESS -> APD
                         //B  :    SLEEP -> STOP
                         //C  :    SLEEP -> ACCESS
                         //D  :    APD -> ACCESS
   //bit 3        reserved.
   //bit 2        1 : DRAM enter normal working state.
   //bit 1        1 : DRAM enter sleep state. self refresh state.
   //bit 0        1 : dram enter cfg state.
#define DMC_DRAM_STAT1                             ((0x0096  << 2) + 0xfe036400)
  //bit 11:8  freq_st.
    //4'h0 : IDLE
    //4'h1 : FREQ_CHECK_VPU
    //4'h2 : FREQ_WAITING_STOP
    //4'h3 : FREQ_DRAM_CFG.  waiting DMC/software to send special MRW/MPC command to configure DDR SDRAM either before Freq change or after freq change.
    //4'h4 : FREQ_SELF_REFR_ST.
    //4'h5 : FREQ_SET_DFI_FREQ.
    //4'h6 : FREQ_DFI_INIT_START_HIGH.
    //4'h7 : FREQ_CHANGE PLL_ST.
    //4'h8 : FREQ_UPDATA REG.
    //4'h9 : FREQ_DFI_INIT_START_LOW.
    //4'ha : FREQ_WAITING_FINISH
    //4'hb : FREQ_ZQCS
    //4'hc : FREQ_ZQ_LATCH
    //4'hd : FREQ_PVT
  //bit 7:5   train_st
  //bit 4:0   dram_phy_st
#define DMC_PHY_RETRAINING_CTRL                    ((0x0097  << 2) + 0xfe036400)
  //bit 31 :  phy_retraining enable.
  //bit 30 :  check  vpu sleep_en.
  //bit 25:24 : retraining dfi_freq[4:3], the [2:0] bit still use the dfi_freq bits to keep the frequency.
  //bit 23:0: retraining period unit : 100ns.
#define DMC_DFI_ERR_STAT                           ((0x0098  << 2) + 0xfe036400)
 //LPDDR4 PHY DFI error information.
 //bit 31:20. not used.
 //bit 9.    ddr0_dfi_error
 //bit 8:5   ddr0_dfi_error_info.
 //bit 4.    ddr1_dfi_error.
 //bit 3:0.  ddr1_dfi_error_info.
#define DMC_LP2_TIMER                              ((0x009a  << 2) + 0xfe036400)
//bit 15:0.   timer setting to measure how long the chip is entered LP2 mode.
//this timer is 40bits counter with DMC PCLK.
//we use the high 16bits to compare this register. if the counter is large than this number,  that means  the PHY need addition 10us after wakeup the PHY and before exit self_refresh mode.
#define DMC_DRAM_COMPLETE_WAIT                     ((0x009b  << 2) + 0xfe036400)
 //read only how long to waiting for DFI_INIT_COMPLETE become high after DFI_INIT_START triggered.
#define DMC_DRAM_DFI_SWAP_0                        ((0x00a0  << 2) + 0xfe036400)
  //bit 5:0. dfi_act_n function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_1                        ((0x00a1  << 2) + 0xfe036400)
  //bit 5:0. dfi_ras_n function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_2                        ((0x00a2  << 2) + 0xfe036400)
  //bit 5:0. dfi_cas_n function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_3                        ((0x00a3  << 2) + 0xfe036400)
  //bit 5:0. dfi_we_n function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_4                        ((0x00a4  << 2) + 0xfe036400)
  //bit 5:0. dfi_bg0 function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_5                        ((0x00a5  << 2) + 0xfe036400)
  //bit 5:0. dfi_bg[1] function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_6                        ((0x00a6  << 2) + 0xfe036400)
  //bit 5:0. dfi_ba[0] function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_7                        ((0x00a7  << 2) + 0xfe036400)
  //bit 5:0. dfi_ba[1] function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_8                        ((0x00a8  << 2) + 0xfe036400)
  //bit 5:0. dfi_ba[2] function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_9                        ((0x00a9  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[0] function select
  // 6'h00 : the function itself.
  // 6'h01 : act_n.
  // 6'h02 : ras_n.
  // 6'h03 : cas_n.
  // 6'h04 : we_n.
  // 6'h05 : bg[0].
  // 6'h06 : bg[1].
  // 6'h07 : ba[0].
  // 6'h08 : ba[1].
  // 6'h09 : ba[2].
  // 6'h0a : a[0].
  // 6'h0b : a[1].
  // 6'h0c : a[2].
  // 6'h0d : a[3].
  // 6'h0e : a[4].
  // 6'h0f : a[5].
  // 6'h10 : a[6].
  // 6'h11 : a[7].
  // 6'h12 : a[8].
  // 6'h13 : a[9].
  // 6'h14 : a[10].
  // 6'h15 : a[11].
  // 6'h16 : a[12].
  // 6'h17 : a[13].
  // 6'h18 : a[14].
  // 6'h19 : a[15].
  // 6'h1a : a[16].
  // 6'h1b : a[17].
#define DMC_DRAM_DFI_SWAP_10                       ((0x00aa  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[1] function select
#define DMC_DRAM_DFI_SWAP_11                       ((0x00ab  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[2] function select
#define DMC_DRAM_DFI_SWAP_12                       ((0x00ac  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[3] function select
#define DMC_DRAM_DFI_SWAP_13                       ((0x00ad  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[4] function select
#define DMC_DRAM_DFI_SWAP_14                       ((0x00ae  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[5] function select
#define DMC_DRAM_DFI_SWAP_15                       ((0x00af  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[6] function select
#define DMC_DRAM_DFI_SWAP_16                       ((0x00b0  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[7] function select
#define DMC_DRAM_DFI_SWAP_17                       ((0x00b1  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[8] function select
#define DMC_DRAM_DFI_SWAP_18                       ((0x00b2  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[9] function select
#define DMC_DRAM_DFI_SWAP_19                       ((0x00b3  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[10] function select
#define DMC_DRAM_DFI_SWAP_20                       ((0x00b4  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[11] function select
#define DMC_DRAM_DFI_SWAP_21                       ((0x00b5  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[12] function select
#define DMC_DRAM_DFI_SWAP_22                       ((0x00b6  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[13] function select
#define DMC_DRAM_DFI_SWAP_23                       ((0x00b7  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[14] function select
#define DMC_DRAM_DFI_SWAP_24                       ((0x00b8  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[15] function select
#define DMC_DRAM_DFI_SWAP_25                       ((0x00b9  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[16] function select
#define DMC_DRAM_DFI_SWAP_26                       ((0x00ba  << 2) + 0xfe036400)
  //bit 5:0. dfi_a[17] function select
#define DMC_DRAM_CMD                               ((0x00d0  << 2) + 0xfe036400)
 //bit 31. cmd done.  write 0 to clean.
 //bit 30. data done. write 0 to clean.
 //bit 5.  user defined command.
 //bit 4.  LPDDR4 MPC write data command( MPC WR FIFO).
 //bit 3.  LPDDR4 MPC read data command (MPC RD Calibration and RD FIFO).
 //bit 2.  LPDDR4 MPC-1 command ( NOP,  Start DQS interval ....)
 //bit 1.  mrr comand.
 //bit 0.  mrw command.
#define DMC_DRAM_CMD_CODE                          ((0x00d1  << 2) + 0xfe036400)
 //bit 31:28  user command case: = {act_n, ras_n, cas_n, we_n}
 //bit 27:26. 128bits data cycles . 0: 1 clock cycles;  1: 2  clock cycles; 2: 3 clock cycles; 3:4 clock cycles.
 //           LPDDR4 : 4 clock cycles;
 //           DDR3/4/LPDDR3  : 2 clock cycles.
 //bit 25     MRW/MRR/MPC command rank 1 select.  1: select.  0: not select.
 //bit 24.    MRW/MRR/MPC command rank 0 select.  1: select.  0: not select.
 //bit 23:16  MR addr.  DDR4 case :  18:16 ba[2:0].    20:19 BG[1:0].
 //bit 15:0   opcode.
#define DMC_DRAM_CMD_TIME                          ((0x00d2  << 2) + 0xfe036400)
//bit 31:16  PRE  CMD timer. //delay how many cycle to start the command.
//bit 15:0   POST CMD timer  //delay how many cycle after the command execute.
#define DMC_DRAM_WSTRB0                            ((0x00d3  << 2) + 0xfe036400)
#define DMC_DRAM_WSTRB1                            ((0x00d4  << 2) + 0xfe036400)
#define DMC_DRAM_RDBI0                             ((0x00d5  << 2) + 0xfe036400)
  //MPC RD FIFO command DBI read back data
  //bit 31:16  the second cycle.
  //bit 15:0   the first cycle.
#define DMC_DRAM_RDBI1                             ((0x00d6  << 2) + 0xfe036400)
  //MPC RD FIFO command DBI read back data
  //bit 31:16. the Forth cycle.
  //bit 15:0.  the third cycle.
//WD0~16 and RD0~16 can be used as MRW command as Frequency change .
//WD0~16 is for Freq1 DRAM MR setting, it would send to DRAM right before FREQ0-> FREQ1
//RD0_16 is for Freq0 DRAM MR setting. it would send to DRAM right before FREQ1-> FREQ0.
//each register can be one MRW command. So total 16 MRW command can be sent to DRAM.
//The register formats:
//bit 31.   MRW/USER comand enable.  1: enabled command. 0 not enabled.
//bit 30.   last MRW/USER command.   if this bit =1, After send this command, the DRAM controller will contine frequency next stage.
//bit 29:26. USER COMMAND parameter: in DDR3/DDR4.  {act_n, ras_n, cas_n, we_n} value for user command
                                     //in LPDDR4.  bit 16: 1 4 cycles command.  0 2 cycles command.
//bit 25     MRW/USER command rank 1 select.  1: select.  0: not select.
//bit 24.    MRW/USER command rank 0 select.  1: select.  0: not select.
//bit 23:0.  USER command.
             //DDR3:    18:16 bank address. 15:0:  address.
             //DDR4:    20:19 bank group address.   18:16: bank address. 15:0 address.
             //LPDDR3:   9:0. rising edge address.  19:10.  falling edge address.
             //LPDDR4.   5:0, first edge address,  11:6 second edge address, 17:12: third edge address. 23:18, forth edge address.
           //MRW command format:
              //bit 23:16  MR addr.  DDR4 case :  18:16 ba[2:0].    20:19 BG[1:0].
              //bit 15:0   opcode.
#define DMC_DRAM_WD0                               ((0x00e0  << 2) + 0xfe036400)
#define DMC_DRAM_WD1                               ((0x00e1  << 2) + 0xfe036400)
#define DMC_DRAM_WD2                               ((0x00e2  << 2) + 0xfe036400)
#define DMC_DRAM_WD3                               ((0x00e3  << 2) + 0xfe036400)
#define DMC_DRAM_WD4                               ((0x00e4  << 2) + 0xfe036400)
#define DMC_DRAM_WD5                               ((0x00e5  << 2) + 0xfe036400)
#define DMC_DRAM_WD6                               ((0x00e6  << 2) + 0xfe036400)
#define DMC_DRAM_WD7                               ((0x00e7  << 2) + 0xfe036400)
#define DMC_DRAM_WD8                               ((0x00e8  << 2) + 0xfe036400)
#define DMC_DRAM_WD9                               ((0x00e9  << 2) + 0xfe036400)
#define DMC_DRAM_WD10                              ((0x00ea  << 2) + 0xfe036400)
#define DMC_DRAM_WD11                              ((0x00eb  << 2) + 0xfe036400)
#define DMC_DRAM_WD12                              ((0x00ec  << 2) + 0xfe036400)
#define DMC_DRAM_WD13                              ((0x00ed  << 2) + 0xfe036400)
#define DMC_DRAM_WD14                              ((0x00ee  << 2) + 0xfe036400)
#define DMC_DRAM_WD15                              ((0x00ef  << 2) + 0xfe036400)
#define DMC_DRAM_RD0                               ((0x00f0  << 2) + 0xfe036400)
#define DMC_DRAM_RD1                               ((0x00f1  << 2) + 0xfe036400)
#define DMC_DRAM_RD2                               ((0x00f2  << 2) + 0xfe036400)
#define DMC_DRAM_RD3                               ((0x00f3  << 2) + 0xfe036400)
#define DMC_DRAM_RD4                               ((0x00f4  << 2) + 0xfe036400)
#define DMC_DRAM_RD5                               ((0x00f5  << 2) + 0xfe036400)
#define DMC_DRAM_RD6                               ((0x00f6  << 2) + 0xfe036400)
#define DMC_DRAM_RD7                               ((0x00f7  << 2) + 0xfe036400)
#define DMC_DRAM_RD8                               ((0x00f8  << 2) + 0xfe036400)
#define DMC_DRAM_RD9                               ((0x00f9  << 2) + 0xfe036400)
#define DMC_DRAM_RD10                              ((0x00fa  << 2) + 0xfe036400)
#define DMC_DRAM_RD11                              ((0x00fb  << 2) + 0xfe036400)
#define DMC_DRAM_RD12                              ((0x00fc  << 2) + 0xfe036400)
#define DMC_DRAM_RD13                              ((0x00fd  << 2) + 0xfe036400)
#define DMC_DRAM_RD14                              ((0x00fe  << 2) + 0xfe036400)
#define DMC_DRAM_RD15                              ((0x00ff  << 2) + 0xfe036400)
//
// Closing file:  ../mmc_lp4/dmc/rtl/dmc_siu_reg.vh
//
//
// Reading file:  ../mmc_lp4/dmc/rtl/dmc_sticky_reg.vh
//
//`define DMC_STICKY_REG_BASE   32'hfe036800
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe036800
// -----------------------------------------------
//those register is for software save some temporary value. and because it's in RAM. it won't lose if DMC get reseted.
#define DMC_STICKY_0                               ((0x0000  << 2) + 0xfe036800)
#define DMC_STICKY_1                               ((0x0001  << 2) + 0xfe036800)
#define DMC_STICKY_2                               ((0x0002  << 2) + 0xfe036800)
#define DMC_STICKY_3                               ((0x0003  << 2) + 0xfe036800)
#define DMC_STICKY_4                               ((0x0004  << 2) + 0xfe036800)
#define DMC_STICKY_5                               ((0x0005  << 2) + 0xfe036800)
#define DMC_STICKY_6                               ((0x0006  << 2) + 0xfe036800)
#define DMC_STICKY_7                               ((0x0007  << 2) + 0xfe036800)
#define DMC_STICKY_8                               ((0x0008  << 2) + 0xfe036800)
#define DMC_STICKY_9                               ((0x0009  << 2) + 0xfe036800)
#define DMC_STICKY_10                              ((0x000a  << 2) + 0xfe036800)
#define DMC_STICKY_11                              ((0x000b  << 2) + 0xfe036800)
#define DMC_STICKY_12                              ((0x000c  << 2) + 0xfe036800)
#define DMC_STICKY_13                              ((0x000d  << 2) + 0xfe036800)
#define DMC_STICKY_14                              ((0x000e  << 2) + 0xfe036800)
#define DMC_STICKY_15                              ((0x000f  << 2) + 0xfe036800)
#define DMC_STICKY_16                              ((0x0010  << 2) + 0xfe036800)
#define DMC_STICKY_17                              ((0x0011  << 2) + 0xfe036800)
#define DMC_STICKY_18                              ((0x0012  << 2) + 0xfe036800)
#define DMC_STICKY_19                              ((0x0013  << 2) + 0xfe036800)
#define DMC_STICKY_20                              ((0x0014  << 2) + 0xfe036800)
#define DMC_STICKY_21                              ((0x0015  << 2) + 0xfe036800)
#define DMC_STICKY_22                              ((0x0016  << 2) + 0xfe036800)
#define DMC_STICKY_23                              ((0x0017  << 2) + 0xfe036800)
#define DMC_STICKY_24                              ((0x0018  << 2) + 0xfe036800)
#define DMC_STICKY_25                              ((0x0019  << 2) + 0xfe036800)
#define DMC_STICKY_26                              ((0x001a  << 2) + 0xfe036800)
#define DMC_STICKY_27                              ((0x001b  << 2) + 0xfe036800)
#define DMC_STICKY_28                              ((0x001c  << 2) + 0xfe036800)
#define DMC_STICKY_29                              ((0x001d  << 2) + 0xfe036800)
#define DMC_STICKY_30                              ((0x001e  << 2) + 0xfe036800)
#define DMC_STICKY_31                              ((0x001f  << 2) + 0xfe036800)
#define DMC_STICKY_32                              ((0x0020  << 2) + 0xfe036800)
#define DMC_STICKY_33                              ((0x0021  << 2) + 0xfe036800)
#define DMC_STICKY_34                              ((0x0022  << 2) + 0xfe036800)
#define DMC_STICKY_35                              ((0x0023  << 2) + 0xfe036800)
#define DMC_STICKY_36                              ((0x0024  << 2) + 0xfe036800)
#define DMC_STICKY_37                              ((0x0025  << 2) + 0xfe036800)
#define DMC_STICKY_38                              ((0x0026  << 2) + 0xfe036800)
#define DMC_STICKY_39                              ((0x0027  << 2) + 0xfe036800)
#define DMC_STICKY_40                              ((0x0028  << 2) + 0xfe036800)
#define DMC_STICKY_41                              ((0x0029  << 2) + 0xfe036800)
#define DMC_STICKY_42                              ((0x002a  << 2) + 0xfe036800)
#define DMC_STICKY_43                              ((0x002b  << 2) + 0xfe036800)
#define DMC_STICKY_44                              ((0x002c  << 2) + 0xfe036800)
#define DMC_STICKY_45                              ((0x002d  << 2) + 0xfe036800)
#define DMC_STICKY_46                              ((0x002e  << 2) + 0xfe036800)
#define DMC_STICKY_47                              ((0x002f  << 2) + 0xfe036800)
#define DMC_STICKY_48                              ((0x0030  << 2) + 0xfe036800)
#define DMC_STICKY_49                              ((0x0031  << 2) + 0xfe036800)
#define DMC_STICKY_50                              ((0x0032  << 2) + 0xfe036800)
#define DMC_STICKY_51                              ((0x0033  << 2) + 0xfe036800)
#define DMC_STICKY_52                              ((0x0034  << 2) + 0xfe036800)
#define DMC_STICKY_53                              ((0x0035  << 2) + 0xfe036800)
#define DMC_STICKY_54                              ((0x0036  << 2) + 0xfe036800)
#define DMC_STICKY_55                              ((0x0037  << 2) + 0xfe036800)
#define DMC_STICKY_56                              ((0x0038  << 2) + 0xfe036800)
#define DMC_STICKY_57                              ((0x0039  << 2) + 0xfe036800)
#define DMC_STICKY_58                              ((0x003a  << 2) + 0xfe036800)
#define DMC_STICKY_59                              ((0x003b  << 2) + 0xfe036800)
#define DMC_STICKY_60                              ((0x003c  << 2) + 0xfe036800)
#define DMC_STICKY_61                              ((0x003d  << 2) + 0xfe036800)
#define DMC_STICKY_62                              ((0x003e  << 2) + 0xfe036800)
#define DMC_STICKY_63                              ((0x003f  << 2) + 0xfe036800)
//
// Closing file:  ../mmc_lp4/dmc/rtl/dmc_sticky_reg.vh
//
//========================================================================
// STARTUP
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe02e000
// -----------------------------------------------
#define STARTUP_LOCK                               ((0x0000  << 2) + 0xfe02e000)
#define STARTUP_DFU_STS                            ((0x0004  << 2) + 0xfe02e000)
#define STARTUP_BOOT_SRC                           ((0x0008  << 2) + 0xfe02e000)
#define STARTUP_TEE_REQ_DFU                        ((0x0009  << 2) + 0xfe02e000)
#define STARTUP_BOOT_OVERRIDE                      ((0x000a  << 2) + 0xfe02e000)
#define STARTUP_COLD_BOOT_CNT                      ((0x000b  << 2) + 0xfe02e000)
#define STARTUP_KEY_PRESERVE                       ((0x000c  << 2) + 0xfe02e000)
//========================================================================
// MIPI_DSI_PHY
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe01c000
// -----------------------------------------------
//`define MIPI_DSI_PHY_START      8'h00
//`define MIPI_DSI_PHY_END        16'hffff
#define MIPI_DSI_PHY_CTRL                          ((0x0000  << 2) + 0xfe01c000)
  //bit 31.  soft reset for the phy. 1 = reset. 0 = dessert the reset.
  //bit 30.  clock lane soft reset.
  //bit 29.  data byte lane 3 soft reset.
  //bit 28.  data byte lane 2 soft reset.
  //bit 27.  data byte lane 1 soft reset.
  //bit 26.  data byte lane 0 soft reset.
  //bit 5.   LPDT data endian.  1 = transfer the high bit first. 0 : transfer the low bit first.
  //bit 4.   HS data endian.
  //bit 3.  force data byte lane in stop mode.
  //bit 2.  force data byte lane 0 in reciever mode.
  //bit 1. write 1 to sync the txclkesc input. the internal logic have to use txclkesc to decide Txvalid and Txready.
  //bit 0.  enalbe the MIPI DSI PHY TxDDRClk.
#define MIPI_DSI_CHAN_CTRL                         ((0x0001  << 2) + 0xfe01c000)
  //bit 31.   clk lane tx_hs_en control selection.  1 = from register. 0 use clk lane state machine.
  //bit 30.   register bit for clock lane tx_hs_en.
  //bit 29.  clk lane tx_lp_en contrl selection.  1 = from register. 0 from clk lane state machine.
  //bit 28.  register bit for clock lane tx_lp_en.
  //bit 27.  chan0 tx_hs_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 26.  register bit for chan0 tx_hs_en.
  //bit 25.  chan0 tx_lp_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 24. register bit from chan0 tx_lp_en.
  //bit 23.  chan0 rx_lp_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 22. register bit from chan0 rx_lp_en.
  //bit 21.  chan0 contention detection enable control selection. 1 = from register. 0 from chan0 state machine.
  //bit 20. register bit from chan0 contention detection enable.
  //bit 19.  chan1 tx_hs_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 18.  register bit for chan1 tx_hs_en.
  //bit 17.  chan1 tx_lp_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 16. register bit from chan1 tx_lp_en.
  //bit 15.  chan2 tx_hs_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 14.  register bit for chan2 tx_hs_en.
  //bit 13.  chan2 tx_lp_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 12. register bit from chan2 tx_lp_en.
  //bit 11. chan3 tx_hs_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 10. register bit for chan3 tx_hs_en.
  //bit 9.  chan3 tx_lp_en control selection. 1 = from register. 0 from chan0 state machine.
  //bit 8. register bit from chan3 tx_lp_en.
  //bit 4.  clk chan power down. this bit is also used as the power down of the whole MIPI_DSI_PHY.
  //bit 3.  chan3 power down.
  //bit 2.  chan2 power down.
  //bit 1.  chan1 power down.
  //bit 0.  chan0 power down.
#define MIPI_DSI_CHAN_STS                          ((0x0002  << 2) + 0xfe01c000)
 //bit 24.  chan0 TX->RX turn can't accept the ACK command from slave watch dog triggered.  write 1 to clear the status bit.
 //bit 23.  chan0 RX ESC command watch dog triggered. write 1 to clean this bit.
 //bit
#define MIPI_DSI_CLK_TIM                           ((0x0003  << 2) + 0xfe01c000)
  //bit 31:24. TCLK_PREPARE.
  //bit 23:16. TCLK_ZERO.
  //bit 15:8.  TCLK_POST.
  //bit 7:0.   TCLK_TRAIL.
#define MIPI_DSI_HS_TIM                            ((0x0004  << 2) + 0xfe01c000)
  //bit 31:24. THS_PREPARE.
  //bit 23:16. THS_ZERO.
  //bit 15:8.  THS_TRAIL.
  //bit 7:0.   THS_EXIT.
#define MIPI_DSI_LP_TIM                            ((0x0005  << 2) + 0xfe01c000)
  //bit 31:24. tTA_GET.
  //bit 23:16. tTA_GO.
  //bit 15:8.  tTA_SURE.
  //bit 7:0.   tLPX.
#define MIPI_DSI_ANA_UP_TIM                        ((0x0006  << 2) + 0xfe01c000)
  //wait time to  MIPI DIS analog ready.
#define MIPI_DSI_INIT_TIM                          ((0x0007  << 2) + 0xfe01c000)
  // TINIT.
#define MIPI_DSI_WAKEUP_TIM                        ((0x0008  << 2) + 0xfe01c000)
  //TWAKEUP.
#define MIPI_DSI_LPOK_TIM                          ((0x0009  << 2) + 0xfe01c000)
  //bit 31:0 when in RxULPS state, RX reciever is in sleep mode.
  //every MIPI_DSI_ULPS_CHECK period, the reciever would be enabled once, and waiting this timer period to get the stable input.
#define MIPI_DSI_LP_WCHDOG                         ((0x000a  << 2) + 0xfe01c000)
  //bit 31:0 watch dog timer for MIPI DSI LP receive state.
#define MIPI_DSI_ANA_CTRL                          ((0x000b  << 2) + 0xfe01c000)
  //bit 31:0 tMBIAS.  timer to wait for analog mBIAS voltage stable.
#define MIPI_DSI_CLK_TIM1                          ((0x000c  << 2) + 0xfe01c000)
  //bit 31:8  not used.
  //bit 7:0    tCLK_PRE
#define MIPI_DSI_TURN_WCHDOG                       ((0x000d  << 2) + 0xfe01c000)
 //bit 31:0 watch dog timer for lane 0 LP turn around waiting time.
#define MIPI_DSI_ULPS_CHECK                        ((0x000e  << 2) + 0xfe01c000)
 //bit 31:0 when Lane0 in LP recieve state,  if the another side sent Low power command,  using this timer to enable Tcheck the another size wakeup nor not.
#define MIPI_DSI_TEST_CTRL0                        ((0x000f  << 2) + 0xfe01c000)
#define MIPI_DSI_TEST_CTRL1                        ((0x0010  << 2) + 0xfe01c000)
//========================================================================
//  Temp sensor PLL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe020000
// -----------------------------------------------
#define TS_PLL_CFG_REG1                            ((0x0001  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG2                            ((0x0002  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG3                            ((0x0003  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG4                            ((0x0004  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG5                            ((0x0005  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG6                            ((0x0006  << 2) + 0xfe020000)
#define TS_PLL_CFG_REG7                            ((0x0007  << 2) + 0xfe020000)
#define TS_PLL_STAT0                               ((0x0010  << 2) + 0xfe020000)
#define TS_PLL_STAT1                               ((0x0011  << 2) + 0xfe020000)
#define TS_PLL_STAT2                               ((0x0012  << 2) + 0xfe020000)
#define TS_PLL_STAT3                               ((0x0013  << 2) + 0xfe020000)
#define TS_PLL_STAT4                               ((0x0014  << 2) + 0xfe020000)
#define TS_PLL_STAT5                               ((0x0015  << 2) + 0xfe020000)
#define TS_PLL_STAT6                               ((0x0016  << 2) + 0xfe020000)
#define TS_PLL_STAT7                               ((0x0017  << 2) + 0xfe020000)
#define TS_PLL_STAT8                               ((0x0018  << 2) + 0xfe020000)
#define TS_PLL_STAT9                               ((0x0019  << 2) + 0xfe020000)
//========================================================================
//  Temp sensor DDR
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe022000
// -----------------------------------------------
#define TS_DDR_CFG_REG1                            ((0x0001  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG2                            ((0x0002  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG3                            ((0x0003  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG4                            ((0x0004  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG5                            ((0x0005  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG6                            ((0x0006  << 2) + 0xfe022000)
#define TS_DDR_CFG_REG7                            ((0x0007  << 2) + 0xfe022000)
#define TS_DDR_STAT0                               ((0x0010  << 2) + 0xfe022000)
#define TS_DDR_STAT1                               ((0x0011  << 2) + 0xfe022000)
#define TS_DDR_STAT2                               ((0x0012  << 2) + 0xfe022000)
#define TS_DDR_STAT3                               ((0x0013  << 2) + 0xfe022000)
#define TS_DDR_STAT4                               ((0x0014  << 2) + 0xfe022000)
#define TS_DDR_STAT5                               ((0x0015  << 2) + 0xfe022000)
#define TS_DDR_STAT6                               ((0x0016  << 2) + 0xfe022000)
#define TS_DDR_STAT7                               ((0x0017  << 2) + 0xfe022000)
#define TS_DDR_STAT8                               ((0x0018  << 2) + 0xfe022000)
#define TS_DDR_STAT9                               ((0x0019  << 2) + 0xfe022000)
//========================================================================
//  Temp sensor GPU
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe035000
// -----------------------------------------------
//`define TS_GPU_CFG_REG1                         8'h01
//`define TS_GPU_CFG_REG2                         8'h02
//`define TS_GPU_CFG_REG3                         8'h03
//`define TS_GPU_CFG_REG4                         8'h04
//`define TS_GPU_CFG_REG5                         8'h05
//`define TS_GPU_CFG_REG6                         8'h06
//`define TS_GPU_CFG_REG7                         8'h07
//`define TS_GPU_STAT0                            8'h10
//`define TS_GPU_STAT1                            8'h11
//`define TS_GPU_STAT2                            8'h12
//`define TS_GPU_STAT3                            8'h13
//`define TS_GPU_STAT4                            8'h14
//`define TS_GPU_STAT5                            8'h15
//`define TS_GPU_STAT6                            8'h16
//`define TS_GPU_STAT7                            8'h17
//`define TS_GPU_STAT8                            8'h18
//`define TS_GPU_STAT9                            8'h19
//========================================================================
//  RNG
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe034000
// -----------------------------------------------
//========================================================================
//  ACODEC
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe01a000
// -----------------------------------------------
#define ACODEC_0                                   ((0x0000  << 2) + 0xfe01a000)
#define ACODEC_1                                   ((0x0001  << 2) + 0xfe01a000)
#define ACODEC_2                                   ((0x0002  << 2) + 0xfe01a000)
#define ACODEC_3                                   ((0x0003  << 2) + 0xfe01a000)
#define ACODEC_4                                   ((0x0004  << 2) + 0xfe01a000)
#define ACODEC_5                                   ((0x0005  << 2) + 0xfe01a000)
#define ACODEC_6                                   ((0x0006  << 2) + 0xfe01a000)
#define ACODEC_7                                   ((0x0007  << 2) + 0xfe01a000)
//========================================================================
//  AML USB PHY A
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe03c000
// -----------------------------------------------
#define AMLUSB_A0                                  ((0x0000  << 2) + 0xfe03c000)
#define AMLUSB_A1                                  ((0x0001  << 2) + 0xfe03c000)
#define AMLUSB_A2                                  ((0x0002  << 2) + 0xfe03c000)
#define AMLUSB_A3                                  ((0x0003  << 2) + 0xfe03c000)
#define AMLUSB_A4                                  ((0x0004  << 2) + 0xfe03c000)
#define AMLUSB_A5                                  ((0x0005  << 2) + 0xfe03c000)
#define AMLUSB_A6                                  ((0x0006  << 2) + 0xfe03c000)
#define AMLUSB_A7                                  ((0x0007  << 2) + 0xfe03c000)
#define AMLUSB_A8                                  ((0x0008  << 2) + 0xfe03c000)
#define AMLUSB_A9                                  ((0x0009  << 2) + 0xfe03c000)
#define AMLUSB_A10                                 ((0x000a  << 2) + 0xfe03c000)
#define AMLUSB_A11                                 ((0x000b  << 2) + 0xfe03c000)
#define AMLUSB_A12                                 ((0x000c  << 2) + 0xfe03c000)
#define AMLUSB_A13                                 ((0x000d  << 2) + 0xfe03c000)
#define AMLUSB_A14                                 ((0x000e  << 2) + 0xfe03c000)
#define AMLUSB_A15                                 ((0x000f  << 2) + 0xfe03c000)
#define AMLUSB_A16                                 ((0x0010  << 2) + 0xfe03c000)
#define AMLUSB_A17                                 ((0x0011  << 2) + 0xfe03c000)
#define AMLUSB_A18                                 ((0x0012  << 2) + 0xfe03c000)
#define AMLUSB_A19                                 ((0x0013  << 2) + 0xfe03c000)
#define AMLUSB_A20                                 ((0x0014  << 2) + 0xfe03c000)
#define AMLUSB_A21                                 ((0x0015  << 2) + 0xfe03c000)
#define AMLUSB_A22                                 ((0x0016  << 2) + 0xfe03c000)
#define AMLUSB_A23                                 ((0x0017  << 2) + 0xfe03c000)
#define AMLUSB_A24                                 ((0x0018  << 2) + 0xfe03c000)
#define AMLUSB_A25                                 ((0x0019  << 2) + 0xfe03c000)
#define AMLUSB_A26                                 ((0x001a  << 2) + 0xfe03c000)
#define AMLUSB_A27                                 ((0x001b  << 2) + 0xfe03c000)
#define AMLUSB_A28                                 ((0x001c  << 2) + 0xfe03c000)
#define AMLUSB_A29                                 ((0x001d  << 2) + 0xfe03c000)
#define AMLUSB_A30                                 ((0x001e  << 2) + 0xfe03c000)
#define AMLUSB_A31                                 ((0x001f  << 2) + 0xfe03c000)
//========================================================================
//  AML USB PHY B
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe03e000
// -----------------------------------------------
#define AMLUSB_B0                                  ((0x0000  << 2) + 0xfe03e000)
#define AMLUSB_B1                                  ((0x0001  << 2) + 0xfe03e000)
#define AMLUSB_B2                                  ((0x0002  << 2) + 0xfe03e000)
#define AMLUSB_B3                                  ((0x0003  << 2) + 0xfe03e000)
#define AMLUSB_B4                                  ((0x0004  << 2) + 0xfe03e000)
#define AMLUSB_B5                                  ((0x0005  << 2) + 0xfe03e000)
#define AMLUSB_B6                                  ((0x0006  << 2) + 0xfe03e000)
#define AMLUSB_B7                                  ((0x0007  << 2) + 0xfe03e000)
#define AMLUSB_B8                                  ((0x0008  << 2) + 0xfe03e000)
#define AMLUSB_B9                                  ((0x0009  << 2) + 0xfe03e000)
#define AMLUSB_B10                                 ((0x000a  << 2) + 0xfe03e000)
#define AMLUSB_B11                                 ((0x000b  << 2) + 0xfe03e000)
#define AMLUSB_B12                                 ((0x000c  << 2) + 0xfe03e000)
#define AMLUSB_B13                                 ((0x000d  << 2) + 0xfe03e000)
#define AMLUSB_B14                                 ((0x000e  << 2) + 0xfe03e000)
#define AMLUSB_B15                                 ((0x000f  << 2) + 0xfe03e000)
#define AMLUSB_B16                                 ((0x0010  << 2) + 0xfe03e000)
#define AMLUSB_B17                                 ((0x0011  << 2) + 0xfe03e000)
#define AMLUSB_B18                                 ((0x0012  << 2) + 0xfe03e000)
#define AMLUSB_B19                                 ((0x0013  << 2) + 0xfe03e000)
#define AMLUSB_B20                                 ((0x0014  << 2) + 0xfe03e000)
#define AMLUSB_B21                                 ((0x0015  << 2) + 0xfe03e000)
#define AMLUSB_B22                                 ((0x0016  << 2) + 0xfe03e000)
#define AMLUSB_B23                                 ((0x0017  << 2) + 0xfe03e000)
#define AMLUSB_B24                                 ((0x0018  << 2) + 0xfe03e000)
#define AMLUSB_B25                                 ((0x0019  << 2) + 0xfe03e000)
#define AMLUSB_B26                                 ((0x001a  << 2) + 0xfe03e000)
#define AMLUSB_B27                                 ((0x001b  << 2) + 0xfe03e000)
#define AMLUSB_B28                                 ((0x001c  << 2) + 0xfe03e000)
#define AMLUSB_B29                                 ((0x001d  << 2) + 0xfe03e000)
#define AMLUSB_B30                                 ((0x001e  << 2) + 0xfe03e000)
#define AMLUSB_B31                                 ((0x001f  << 2) + 0xfe03e000)
//========================================================================
//  PAD_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe004000
// -----------------------------------------------
#define PADCTRL_PIN_MUX_REG0                       ((0x0000  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG1                       ((0x0001  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG2                       ((0x0002  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG3                       ((0x0003  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG4                       ((0x0004  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG5                       ((0x0005  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG6                       ((0x0006  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG7                       ((0x0007  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG8                       ((0x0008  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REG9                       ((0x0009  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGA                       ((0x000a  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGB                       ((0x000b  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGC                       ((0x000c  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGD                       ((0x000d  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGE                       ((0x000e  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGF                       ((0x000f  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGG                       ((0x0010  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGH                       ((0x0011  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGI                       ((0x0012  << 2) + 0xfe004000)
#define PADCTRL_PIN_MUX_REGJ                       ((0x0013  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL0                     ((0x0020  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL1                     ((0x0021  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL2                     ((0x0022  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL3                     ((0x0023  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL4                     ((0x0024  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL5                     ((0x0025  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL6                     ((0x0026  << 2) + 0xfe004000)
#define PADCTRL_GPIO_IRQ_CTRL7                     ((0x0027  << 2) + 0xfe004000)
#define PADCTRL_WORLD_SYNC_CTRL0                   ((0x0028  << 2) + 0xfe004000)
#define PADCTRL_GPIO_MSR_CTRL0                     ((0x0029  << 2) + 0xfe004000)
#define PADCTRL_MISC_CTRL0                         ((0x002a  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_I                            ((0x0030  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_O                            ((0x0031  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_OEN                          ((0x0032  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_PULL_EN                      ((0x0033  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_PULL_UP                      ((0x0034  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_LOCK                         ((0x0035  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_PROT                         ((0x0036  << 2) + 0xfe004000)
#define PADCTRL_GPIOZ_DS                           ((0x0037  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_I                            ((0x0040  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_O                            ((0x0041  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_OEN                          ((0x0042  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_PULL_EN                      ((0x0043  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_PULL_UP                      ((0x0044  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_LOCK                         ((0x0045  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_PROT                         ((0x0046  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_DS                           ((0x0047  << 2) + 0xfe004000)
#define PADCTRL_GPIOX_DS_EXT                       ((0x0048  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_I                            ((0x0050  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_O                            ((0x0051  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_OEN                          ((0x0052  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_PULL_EN                      ((0x0053  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_PULL_UP                      ((0x0054  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_LOCK                         ((0x0055  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_PROT                         ((0x0056  << 2) + 0xfe004000)
#define PADCTRL_GPIOH_DS                           ((0x0057  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_I                            ((0x0060  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_O                            ((0x0061  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_OEN                          ((0x0062  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_PULL_EN                      ((0x0063  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_PULL_UP                      ((0x0064  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_LOCK                         ((0x0065  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_PROT                         ((0x0066  << 2) + 0xfe004000)
#define PADCTRL_GPIOD_DS                           ((0x0067  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_I                            ((0x0070  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_O                            ((0x0071  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_OEN                          ((0x0072  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_PULL_EN                      ((0x0073  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_PULL_UP                      ((0x0074  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_LOCK                         ((0x0075  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_PROT                         ((0x0076  << 2) + 0xfe004000)
#define PADCTRL_GPIOE_DS                           ((0x0077  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_I                            ((0x0080  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_O                            ((0x0081  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_OEN                          ((0x0082  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_PULL_EN                      ((0x0083  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_PULL_UP                      ((0x0084  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_LOCK                         ((0x0085  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_PROT                         ((0x0086  << 2) + 0xfe004000)
#define PADCTRL_GPIOC_DS                           ((0x0087  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_I                            ((0x0090  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_O                            ((0x0091  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_OEN                          ((0x0092  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_PULL_EN                      ((0x0093  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_PULL_UP                      ((0x0094  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_LOCK                         ((0x0095  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_PROT                         ((0x0096  << 2) + 0xfe004000)
#define PADCTRL_GPIOB_DS                           ((0x0097  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_I                            ((0x00a0  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_O                            ((0x00a1  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_OEN                          ((0x00a2  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_PULL_EN                      ((0x00a3  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_PULL_UP                      ((0x00a4  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_LOCK                         ((0x00a5  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_PROT                         ((0x00a6  << 2) + 0xfe004000)
#define PADCTRL_GPIOA_DS                           ((0x00a7  << 2) + 0xfe004000)
#define PADCTRL_TESTN_I                            ((0x00b0  << 2) + 0xfe004000)
#define PADCTRL_TESTN_O                            ((0x00b1  << 2) + 0xfe004000)
#define PADCTRL_TESTN_OEN                          ((0x00b2  << 2) + 0xfe004000)
#define PADCTRL_TESTN_PULL_EN                      ((0x00b3  << 2) + 0xfe004000)
#define PADCTRL_TESTN_PULL_UP                      ((0x00b4  << 2) + 0xfe004000)
#define PADCTRL_TESTN_LOCK                         ((0x00b5  << 2) + 0xfe004000)
#define PADCTRL_TESTN_PROT                         ((0x00b6  << 2) + 0xfe004000)
#define PADCTRL_TESTN_DS                           ((0x00b7  << 2) + 0xfe004000)
#define PADCTRL_ANALOG_I                           ((0x00c0  << 2) + 0xfe004000)
#define PADCTRL_ANALOG_EN                          ((0x00c1  << 2) + 0xfe004000)
#define PADCTRL_LOCK_PIN_MUX0                      ((0x00d0  << 2) + 0xfe004000)
#define PADCTRL_LOCK_PIN_MUX1                      ((0x00d1  << 2) + 0xfe004000)
#define PADCTRL_LOCK_PIN_MUX2                      ((0x00d2  << 2) + 0xfe004000)
#define PADCTRL_LOCK_PIN_MUX3                      ((0x00d3  << 2) + 0xfe004000)
#define PADCTRL_LOCK_PIN_MUX4                      ((0x00d4  << 2) + 0xfe004000)
#define PADCTRL_PROT_PIN_MUX0                      ((0x00d8  << 2) + 0xfe004000)
#define PADCTRL_PROT_PIN_MUX1                      ((0x00d9  << 2) + 0xfe004000)
#define PADCTRL_PROT_PIN_MUX2                      ((0x00da  << 2) + 0xfe004000)
#define PADCTRL_PROT_PIN_MUX3                      ((0x00db  << 2) + 0xfe004000)
#define PADCTRL_PROT_PIN_MUX4                      ((0x00dc  << 2) + 0xfe004000)
#define PADCTRL_MUTE_CTRL                          ((0x00e0  << 2) + 0xfe004000)
#define PADCTRL_MUTE_TDM_DISA                      ((0x00e1  << 2) + 0xfe004000)
#define PADCTRL_DEBUG_SEL                          ((0x00e2  << 2) + 0xfe004000)
//========================================================================
//  SYS_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe010000
// -----------------------------------------------
#define SYSCTRL_METAL_REV0                         ((0x0000  << 2) + 0xfe010000)
#define SYSCTRL_METAL_REV1                         ((0x0001  << 2) + 0xfe010000)
#define SYSCTRL_METAL_REV2                         ((0x0002  << 2) + 0xfe010000)
#define SYSCTRL_CHIP_ID                            ((0x000b  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE1_REG0                    ((0x0010  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE1_STICKY_REG0             ((0x0011  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE1_SEC_REG0                ((0x0012  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE1_STICKY_SEC_REG0         ((0x0013  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_REG0                     ((0x0014  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_REG1                     ((0x0015  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_SEC_REG0                 ((0x0016  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_STICKY_REG0              ((0x0017  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_STICKY_REG1              ((0x0018  << 2) + 0xfe010000)
#define SYSCTRL_WRITEONCE_STICKY_SEC_REG0          ((0x0019  << 2) + 0xfe010000)
#define SYSCTRL_TIMERA_CTRL                        ((0x0030  << 2) + 0xfe010000)
#define SYSCTRL_TIMERA                             ((0x0031  << 2) + 0xfe010000)
#define SYSCTRL_TIMERB_CTRL                        ((0x0032  << 2) + 0xfe010000)
#define SYSCTRL_TIMERB                             ((0x0033  << 2) + 0xfe010000)
#define SYSCTRL_TIMERC_CTRL                        ((0x0034  << 2) + 0xfe010000)
#define SYSCTRL_TIMERC                             ((0x0035  << 2) + 0xfe010000)
#define SYSCTRL_TIMERD_CTRL                        ((0x0036  << 2) + 0xfe010000)
#define SYSCTRL_TIMERD                             ((0x0037  << 2) + 0xfe010000)
#define SYSCTRL_SEC_TIMERA_CTRL                    ((0x0038  << 2) + 0xfe010000)
#define SYSCTRL_SEC_TIMERA                         ((0x0039  << 2) + 0xfe010000)
#define SYSCTRL_TIMERE_CTRL                        ((0x003a  << 2) + 0xfe010000)
#define SYSCTRL_TIMERE                             ((0x003b  << 2) + 0xfe010000)
#define SYSCTRL_TIMERE_HI                          ((0x003c  << 2) + 0xfe010000)
#define SYSCTRL_TIMERF_CTRL                        ((0x003d  << 2) + 0xfe010000)
#define SYSCTRL_TIMERF                             ((0x003e  << 2) + 0xfe010000)
#define SYSCTRL_TIMERF_HI                          ((0x003f  << 2) + 0xfe010000)
#define SYSCTRL_TIMERG_CTRL                        ((0x0040  << 2) + 0xfe010000)
#define SYSCTRL_TIMERG                             ((0x0041  << 2) + 0xfe010000)
#define SYSCTRL_TIMERH_CTRL                        ((0x0042  << 2) + 0xfe010000)
#define SYSCTRL_TIMERH                             ((0x0043  << 2) + 0xfe010000)
#define SYSCTRL_TIMERI_CTRL                        ((0x0044  << 2) + 0xfe010000)
#define SYSCTRL_TIMERI                             ((0x0045  << 2) + 0xfe010000)
#define SYSCTRL_TIMERJ_CTRL                        ((0x0046  << 2) + 0xfe010000)
#define SYSCTRL_TIMERJ                             ((0x0047  << 2) + 0xfe010000)
#define SYSCTRL_SEC_TIMERE_CTRL                    ((0x0048  << 2) + 0xfe010000)
#define SYSCTRL_SEC_TIMERE                         ((0x0049  << 2) + 0xfe010000)
#define SYSCTRL_SEC_TIMERE_HI                      ((0x004a  << 2) + 0xfe010000)
#define SYSCTRL_OSC_RING_CTRL0                     ((0x0050  << 2) + 0xfe010000)
#define SYSCTRL_OSC_RING_CTRL1                     ((0x0051  << 2) + 0xfe010000)
#define SYSCTRL_AM2AXI_CTRL0                       ((0x0052  << 2) + 0xfe010000)
#define SYSCTRL_AM2AXI_STS                         ((0x0053  << 2) + 0xfe010000)
#define SYSCTRL_AXI_PIPE_CTRL0                     ((0x0055  << 2) + 0xfe010000)
#define SYSCTRL_AXI_PIPE_CTRL1                     ((0x0056  << 2) + 0xfe010000)
#define SYSCTRL_TIMER90K                           ((0x0057  << 2) + 0xfe010000)
#define SYSCTRL_SCR                                ((0x0058  << 2) + 0xfe010000)
#define SYSCTRL_HPG_TIMER                          ((0x0059  << 2) + 0xfe010000)
//`define SYSCTRL_VIPNANOQ_CTRL0                  10'h5A
#define SYSCTRL_AHB2DDR_CTRL0                      ((0x005b  << 2) + 0xfe010000)
#define SYSCTRL_AHB2DDR_CTRL1                      ((0x005c  << 2) + 0xfe010000)
#define SYSCTRL_POC                                ((0x0060  << 2) + 0xfe010000)
#define SYSCTRL_VPU_SECURE_REG0                    ((0x0061  << 2) + 0xfe010000)
#define SYSCTRL_VPU_SECURE_REG1                    ((0x0062  << 2) + 0xfe010000)
//`define SYSCTRL_NIC_CFG0                        10'h63
#define SYSCTRL_ALERT_STS_STICKY                   ((0x0064  << 2) + 0xfe010000)
#define SYSCTRL_ALERT_ENABLE                       ((0x0066  << 2) + 0xfe010000)
#define SYSCTRL_ENABLE_SPIFC                       ((0x0068  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG0                         ((0x0090  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG1                         ((0x0091  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG2                         ((0x0092  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG3                         ((0x0093  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG4                         ((0x0094  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG5                         ((0x0095  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG6                         ((0x0096  << 2) + 0xfe010000)
#define SYSCTRL_DEBUG_REG7                         ((0x0097  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG0                        ((0x00a0  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG1                        ((0x00a1  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG2                        ((0x00a2  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG3                        ((0x00a3  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG4                        ((0x00a4  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG5                        ((0x00a5  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG6                        ((0x00a6  << 2) + 0xfe010000)
#define SYSCTRL_STATUS_REG7                        ((0x00a7  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG0                        ((0x00b0  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG1                        ((0x00b1  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG2                        ((0x00b2  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG3                        ((0x00b3  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG4                        ((0x00b4  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG5                        ((0x00b5  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG6                        ((0x00b6  << 2) + 0xfe010000)
#define SYSCTRL_STICKY_REG7                        ((0x00b7  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG0                    ((0x00c0  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG1                    ((0x00c1  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG2                    ((0x00c2  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG3                    ((0x00c3  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG4                    ((0x00c4  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG5                    ((0x00c5  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG6                    ((0x00c6  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG7                    ((0x00c7  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG8                    ((0x00c8  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG9                    ((0x00c9  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG10                   ((0x00ca  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG11                   ((0x00cb  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG12                   ((0x00cc  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG13                   ((0x00cd  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG14                   ((0x00ce  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG15                   ((0x00cf  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG16                   ((0x00d0  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG17                   ((0x00d1  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG18                   ((0x00d2  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG19                   ((0x00d3  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG20                   ((0x00d4  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG21                   ((0x00d5  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG22                   ((0x00d6  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG23                   ((0x00d7  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG24                   ((0x00d8  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG25                   ((0x00d9  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG26                   ((0x00da  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG27                   ((0x00db  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG28                   ((0x00dc  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG29                   ((0x00dd  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG30                   ((0x00de  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STATUS_REG31                   ((0x00df  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG0                    ((0x00e0  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG1                    ((0x00e1  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG2                    ((0x00e2  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG3                    ((0x00e3  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG4                    ((0x00e4  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG5                    ((0x00e5  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG6                    ((0x00e6  << 2) + 0xfe010000)
#define SYSCTRL_SEC_STICKY_REG7                    ((0x00e7  << 2) + 0xfe010000)
#define SYSCTRL_MSG_INDEX0_STICKY                  ((0x00f0  << 2) + 0xfe010000)
#define SYSCTRL_MSG_INDEX1_STICKY                  ((0x00f1  << 2) + 0xfe010000)
#define SYSCTRL_MSG_INDEX2_STICKY                  ((0x00f2  << 2) + 0xfe010000)
#define SYSCTRL_MSG_INDEX3_STICKY                  ((0x00f3  << 2) + 0xfe010000)
//========================================================================
//  CLK_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe000000
// -----------------------------------------------
#define CLKCTRL_OSCIN_CTRL                         ((0x0001  << 2) + 0xfe000000)
#define CLKCTRL_RTC_BY_OSCIN_CTRL0                 ((0x0002  << 2) + 0xfe000000)
#define CLKCTRL_RTC_BY_OSCIN_CTRL1                 ((0x0003  << 2) + 0xfe000000)
#define CLKCTRL_RTC_CTRL                           ((0x0004  << 2) + 0xfe000000)
#define CLKCTRL_CHECK_CLK_RESULT                   ((0x0005  << 2) + 0xfe000000)
#define CLKCTRL_MBIST_ATSPEED_CTRL                 ((0x0006  << 2) + 0xfe000000)
#define CLKCTRL_LOCK_BIT_REG0                      ((0x0008  << 2) + 0xfe000000)
#define CLKCTRL_LOCK_BIT_REG1                      ((0x0009  << 2) + 0xfe000000)
#define CLKCTRL_LOCK_BIT_REG2                      ((0x000a  << 2) + 0xfe000000)
#define CLKCTRL_LOCK_BIT_REG3                      ((0x000b  << 2) + 0xfe000000)
#define CLKCTRL_PROT_BIT_REG0                      ((0x000c  << 2) + 0xfe000000)
#define CLKCTRL_PROT_BIT_REG1                      ((0x000d  << 2) + 0xfe000000)
#define CLKCTRL_PROT_BIT_REG2                      ((0x000e  << 2) + 0xfe000000)
#define CLKCTRL_PROT_BIT_REG3                      ((0x000f  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_CTRL0                      ((0x0010  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN0_REG0                   ((0x0011  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN0_REG1                   ((0x0012  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN0_REG2                   ((0x0013  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN0_REG3                   ((0x0014  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN1_REG0                   ((0x0015  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN1_REG1                   ((0x0016  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN1_REG2                   ((0x0017  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_EN1_REG3                   ((0x0018  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_VPU_EN0                    ((0x0019  << 2) + 0xfe000000)
#define CLKCTRL_SYS_CLK_VPU_EN1                    ((0x001a  << 2) + 0xfe000000)
#define CLKCTRL_AXI_CLK_CTRL0                      ((0x001b  << 2) + 0xfe000000)
#define CLKCTRL_TST_CTRL0                          ((0x0020  << 2) + 0xfe000000)
#define CLKCTRL_TST_CTRL1                          ((0x0021  << 2) + 0xfe000000)
#define CLKCTRL_CECA_CTRL0                         ((0x0022  << 2) + 0xfe000000)
#define CLKCTRL_CECA_CTRL1                         ((0x0023  << 2) + 0xfe000000)
#define CLKCTRL_CECB_CTRL0                         ((0x0024  << 2) + 0xfe000000)
#define CLKCTRL_CECB_CTRL1                         ((0x0025  << 2) + 0xfe000000)
#define CLKCTRL_SC_CLK_CTRL                        ((0x0026  << 2) + 0xfe000000)
#define CLKCTRL_DSPA_CLK_CTRL0                     ((0x0027  << 2) + 0xfe000000)
#define CLKCTRL_DSPB_CLK_CTRL0                     ((0x0028  << 2) + 0xfe000000)
#define CLKCTRL_RAMA_CLK_CTRL0                     ((0x0029  << 2) + 0xfe000000)
#define CLKCTRL_CLK12_24_CTRL                      ((0x002a  << 2) + 0xfe000000)
#define CLKCTRL_VID_CLK_CTRL                       ((0x0030  << 2) + 0xfe000000)
#define CLKCTRL_VID_CLK_CTRL2                      ((0x0031  << 2) + 0xfe000000)
#define CLKCTRL_VID_CLK_DIV                        ((0x0032  << 2) + 0xfe000000)
#define CLKCTRL_VIID_CLK_DIV                       ((0x0033  << 2) + 0xfe000000)
#define CLKCTRL_VIID_CLK_CTRL                      ((0x0034  << 2) + 0xfe000000)
#define CLKCTRL_HDMI_CLK_CTRL                      ((0x0038  << 2) + 0xfe000000)
#define CLKCTRL_VID_PLL_CLK_DIV                    ((0x0039  << 2) + 0xfe000000)
#define CLKCTRL_VPU_CLK_CTRL                       ((0x003a  << 2) + 0xfe000000)
#define CLKCTRL_VPU_CLKB_CTRL                      ((0x003b  << 2) + 0xfe000000)
#define CLKCTRL_VPU_CLKC_CTRL                      ((0x003c  << 2) + 0xfe000000)
#define CLKCTRL_VID_LOCK_CLK_CTRL                  ((0x003d  << 2) + 0xfe000000)
#define CLKCTRL_VDIN_MEAS_CLK_CTRL                 ((0x003e  << 2) + 0xfe000000)
#define CLKCTRL_VAPBCLK_CTRL                       ((0x003f  << 2) + 0xfe000000)
#define CLKCTRL_HDCP22_CLK_CTRL                    ((0x0040  << 2) + 0xfe000000)
#define CLKCTRL_MIPIDSI_PHY_CLK_CTRL               ((0x0041  << 2) + 0xfe000000)
#define CLKCTRL_CDAC_CLK_CTRL                      ((0x0042  << 2) + 0xfe000000)
#define CLKCTRL_MIPI_CSI_PHY_CLK_CTRL              ((0x0043  << 2) + 0xfe000000)
#define CLKCTRL_CSI2_ADAPT_CLK_CTRL                ((0x0044  << 2) + 0xfe000000)
#define CLKCTRL_VDEC_CLK_CTRL                      ((0x0050  << 2) + 0xfe000000)
#define CLKCTRL_VDEC2_CLK_CTRL                     ((0x0051  << 2) + 0xfe000000)
#define CLKCTRL_VDEC3_CLK_CTRL                     ((0x0052  << 2) + 0xfe000000)
#define CLKCTRL_VDEC4_CLK_CTRL                     ((0x0053  << 2) + 0xfe000000)
#define CLKCTRL_WAVE420L_CLK_CTRL                  ((0x0054  << 2) + 0xfe000000)
#define CLKCTRL_WAVE420L_CLK_CTRL2                 ((0x0055  << 2) + 0xfe000000)
#define CLKCTRL_TS_CLK_CTRL                        ((0x0056  << 2) + 0xfe000000)
#define CLKCTRL_MALI_CLK_CTRL                      ((0x0057  << 2) + 0xfe000000)
#define CLKCTRL_VIPNANOQ_CLK_CTRL                  ((0x0058  << 2) + 0xfe000000)
#define CLKCTRL_ETH_CLK_CTRL                       ((0x0059  << 2) + 0xfe000000)
#define CLKCTRL_NAND_CLK_CTRL                      ((0x005a  << 2) + 0xfe000000)
#define CLKCTRL_SD_EMMC_CLK_CTRL                   ((0x005b  << 2) + 0xfe000000)
#define CLKCTRL_BT656_CLK_CTRL                     ((0x005c  << 2) + 0xfe000000)
#define CLKCTRL_SPICC_CLK_CTRL                     ((0x005d  << 2) + 0xfe000000)
#define CLKCTRL_GEN_CLK_CTRL                       ((0x005e  << 2) + 0xfe000000)
#define CLKCTRL_SAR_CLK_CTRL0                      ((0x005f  << 2) + 0xfe000000)
#define CLKCTRL_PWM_CLK_AB_CTRL                    ((0x0060  << 2) + 0xfe000000)
#define CLKCTRL_PWM_CLK_CD_CTRL                    ((0x0061  << 2) + 0xfe000000)
#define CLKCTRL_PWM_CLK_EF_CTRL                    ((0x0062  << 2) + 0xfe000000)
#define CLKCTRL_PWM_CLK_GH_CTRL                    ((0x0063  << 2) + 0xfe000000)
#define CLKCTRL_PWM_CLK_IJ_CTRL                    ((0x0064  << 2) + 0xfe000000)
#define CLKCTRL_DEMOD_CLK_CTRL                     ((0x0080  << 2) + 0xfe000000)
#define CLKCTRL_TIMESTAMP_CTRL                     ((0x0100  << 2) + 0xfe000000)
#define CLKCTRL_TIMESTAMP_CTRL1                    ((0x0101  << 2) + 0xfe000000)
#define CLKCTRL_TIMESTAMP_CTRL2                    ((0x0103  << 2) + 0xfe000000)
#define CLKCTRL_TIMESTAMP_RD0                      ((0x0104  << 2) + 0xfe000000)
#define CLKCTRL_TIMESTAMP_RD1                      ((0x0105  << 2) + 0xfe000000)
#define CLKCTRL_TIMEBASE_CTRL0                     ((0x0106  << 2) + 0xfe000000)
#define CLKCTRL_TIMEBASE_CTRL1                     ((0x0107  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_CPU_CFG01                    ((0x0120  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_CPU_CFG2                     ((0x0121  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_ENCP_CFG0                    ((0x0122  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_MALI_CFG01                   ((0x0123  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_HEVCB_CFG01                  ((0x0124  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_HEVCB_CFG2                   ((0x0125  << 2) + 0xfe000000)
#define CLKCTRL_EFUSE_LOCK                         ((0x0126  << 2) + 0xfe000000)
//========================================================================
//  PWR_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe00c000
// -----------------------------------------------
#define PWRCTRL_PWR_ACK0                           ((0x0000  << 2) + 0xfe00c000)
#define PWRCTRL_PWR_ACK1                           ((0x0001  << 2) + 0xfe00c000)
#define PWRCTRL_PWR_OFF0                           ((0x0004  << 2) + 0xfe00c000)
#define PWRCTRL_PWR_OFF1                           ((0x0005  << 2) + 0xfe00c000)
#define PWRCTRL_ISO_EN0                            ((0x0008  << 2) + 0xfe00c000)
#define PWRCTRL_ISO_EN1                            ((0x0009  << 2) + 0xfe00c000)
#define PWRCTRL_FOCRST0                            ((0x000c  << 2) + 0xfe00c000)
#define PWRCTRL_FOCRST1                            ((0x000d  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD0                            ((0x0010  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD1                            ((0x0011  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD2                            ((0x0012  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD3                            ((0x0013  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD4                            ((0x0014  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD5                            ((0x0015  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD6                            ((0x0016  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD7                            ((0x0017  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD8                            ((0x0018  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD9                            ((0x0019  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD10                           ((0x001a  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD11                           ((0x001b  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD12                           ((0x001c  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD13                           ((0x001d  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD14                           ((0x001e  << 2) + 0xfe00c000)
#define PWRCTRL_MEM_PD15                           ((0x001f  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_AUTO_OFF_CTRL0                ((0x0040  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_AUTO_OFF_CTRL1                ((0x0041  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_AUTO_OFF_CTRL2                ((0x0042  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_AUTO_OFF_CTRL3                ((0x0043  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_AUTO_OFF_CTRL4                ((0x0044  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_TIMER_TH_01                   ((0x0048  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_TIMER_TH_23                   ((0x0049  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_TIMER_TH_45                   ((0x004a  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_TIMER_TH_67                   ((0x004b  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_TIMER_TH_89                   ((0x004c  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK0                     ((0x0050  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK1                     ((0x0051  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK2                     ((0x0052  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK3                     ((0x0053  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK4                     ((0x0054  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK5                     ((0x0055  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK6                     ((0x0056  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_IRQ_MASK7                     ((0x0057  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_INIT_SET                ((0x0060  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_OFF_SET                 ((0x0061  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_ON_A_SET                ((0x0062  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_ON_B_SET                ((0x0063  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_ON_C_SET                ((0x0064  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_ON_D_SET                ((0x0065  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_MEMPD_STS                     ((0x0066  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_STS0                      ((0x0067  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_STS1                      ((0x0068  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_STS2                      ((0x0069  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_START_OFF                 ((0x006d  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_START_ON                  ((0x006e  << 2) + 0xfe00c000)
#define PWRCTRL_CPU0_FSM_JUMP                      ((0x006f  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_AUTO_OFF_CTRL0                ((0x0070  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_AUTO_OFF_CTRL1                ((0x0071  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_AUTO_OFF_CTRL2                ((0x0072  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_AUTO_OFF_CTRL3                ((0x0073  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_AUTO_OFF_CTRL4                ((0x0074  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_TIMER_TH_01                   ((0x0078  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_TIMER_TH_23                   ((0x0079  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_TIMER_TH_45                   ((0x007a  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_TIMER_TH_67                   ((0x007b  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_TIMER_TH_89                   ((0x007c  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK0                     ((0x0080  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK1                     ((0x0081  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK2                     ((0x0082  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK3                     ((0x0083  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK4                     ((0x0084  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK5                     ((0x0085  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK6                     ((0x0086  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_IRQ_MASK7                     ((0x0087  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_INIT_SET                ((0x0090  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_OFF_SET                 ((0x0091  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_ON_A_SET                ((0x0092  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_ON_B_SET                ((0x0093  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_ON_C_SET                ((0x0094  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_ON_D_SET                ((0x0095  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_MEMPD_STS                     ((0x0096  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_STS0                      ((0x0097  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_STS1                      ((0x0098  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_STS2                      ((0x0099  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_START_OFF                 ((0x009d  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_START_ON                  ((0x009e  << 2) + 0xfe00c000)
#define PWRCTRL_CPU1_FSM_JUMP                      ((0x009f  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_AUTO_OFF_CTRL0                ((0x00a0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_AUTO_OFF_CTRL1                ((0x00a1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_AUTO_OFF_CTRL2                ((0x00a2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_AUTO_OFF_CTRL3                ((0x00a3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_AUTO_OFF_CTRL4                ((0x00a4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_TIMER_TH_01                   ((0x00a8  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_TIMER_TH_23                   ((0x00a9  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_TIMER_TH_45                   ((0x00aa  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_TIMER_TH_67                   ((0x00ab  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_TIMER_TH_89                   ((0x00ac  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK0                     ((0x00b0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK1                     ((0x00b1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK2                     ((0x00b2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK3                     ((0x00b3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK4                     ((0x00b4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK5                     ((0x00b5  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK6                     ((0x00b6  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_IRQ_MASK7                     ((0x00b7  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_INIT_SET                ((0x00c0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_OFF_SET                 ((0x00c1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_ON_A_SET                ((0x00c2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_ON_B_SET                ((0x00c3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_ON_C_SET                ((0x00c4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_ON_D_SET                ((0x00c5  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_MEMPD_STS                     ((0x00c6  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_STS0                      ((0x00c7  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_STS1                      ((0x00c8  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_STS2                      ((0x00c9  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_START_OFF                 ((0x00cd  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_START_ON                  ((0x00ce  << 2) + 0xfe00c000)
#define PWRCTRL_CPU2_FSM_JUMP                      ((0x00cf  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_AUTO_OFF_CTRL0                ((0x00d0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_AUTO_OFF_CTRL1                ((0x00d1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_AUTO_OFF_CTRL2                ((0x00d2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_AUTO_OFF_CTRL3                ((0x00d3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_AUTO_OFF_CTRL4                ((0x00d4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_TIMER_TH_01                   ((0x00d8  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_TIMER_TH_23                   ((0x00d9  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_TIMER_TH_45                   ((0x00da  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_TIMER_TH_67                   ((0x00db  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_TIMER_TH_89                   ((0x00dc  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK0                     ((0x00e0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK1                     ((0x00e1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK2                     ((0x00e2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK3                     ((0x00e3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK4                     ((0x00e4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK5                     ((0x00e5  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK6                     ((0x00e6  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_IRQ_MASK7                     ((0x00e7  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_INIT_SET                ((0x00f0  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_OFF_SET                 ((0x00f1  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_ON_A_SET                ((0x00f2  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_ON_B_SET                ((0x00f3  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_ON_C_SET                ((0x00f4  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_ON_D_SET                ((0x00f5  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_MEMPD_STS                     ((0x00f6  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_STS0                      ((0x00f7  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_STS1                      ((0x00f8  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_STS2                      ((0x00f9  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_START_OFF                 ((0x00fd  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_START_ON                  ((0x00fe  << 2) + 0xfe00c000)
#define PWRCTRL_CPU3_FSM_JUMP                      ((0x00ff  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_AUTO_OFF_CTRL0              ((0x0100  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_AUTO_OFF_CTRL1              ((0x0101  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_AUTO_OFF_CTRL2              ((0x0102  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_AUTO_OFF_CTRL3              ((0x0103  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_AUTO_OFF_CTRL4              ((0x0104  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_TIMER_TH_01                 ((0x0108  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_TIMER_TH_23                 ((0x0109  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_TIMER_TH_45                 ((0x010a  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_TIMER_TH_67                 ((0x010b  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_TIMER_TH_89                 ((0x010c  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK0                   ((0x0110  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK1                   ((0x0111  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK2                   ((0x0112  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK3                   ((0x0113  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK4                   ((0x0114  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK5                   ((0x0115  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK6                   ((0x0116  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_IRQ_MASK7                   ((0x0117  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_INIT_SET              ((0x0120  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_OFF_SET               ((0x0121  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_ON_A_SET              ((0x0122  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_ON_B_SET              ((0x0123  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_ON_C_SET              ((0x0124  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_ON_D_SET              ((0x0125  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_MEMPD_STS                   ((0x0126  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_STS0                    ((0x0127  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_STS1                    ((0x0128  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_STS2                    ((0x0129  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_START_OFF               ((0x012d  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_START_ON                ((0x012e  << 2) + 0xfe00c000)
#define PWRCTRL_CPUTOP_FSM_JUMP                    ((0x012f  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_AUTO_OFF_CTRL0                ((0x0130  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_AUTO_OFF_CTRL1                ((0x0131  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_AUTO_OFF_CTRL2                ((0x0132  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_AUTO_OFF_CTRL3                ((0x0133  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_AUTO_OFF_CTRL4                ((0x0134  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_TIMER_TH_01                   ((0x0138  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_TIMER_TH_23                   ((0x0139  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_TIMER_TH_45                   ((0x013a  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_TIMER_TH_67                   ((0x013b  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_TIMER_TH_89                   ((0x013c  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK0                     ((0x0140  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK1                     ((0x0141  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK2                     ((0x0142  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK3                     ((0x0143  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK4                     ((0x0144  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK5                     ((0x0145  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK6                     ((0x0146  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_IRQ_MASK7                     ((0x0147  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_INIT_SET                ((0x0150  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_OFF_SET                 ((0x0151  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_ON_A_SET                ((0x0152  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_ON_B_SET                ((0x0153  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_ON_C_SET                ((0x0154  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_ON_D_SET                ((0x0155  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_MEMPD_STS                     ((0x0156  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_STS0                      ((0x0157  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_STS1                      ((0x0158  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_STS2                      ((0x0159  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_START_OFF                 ((0x015d  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_START_ON                  ((0x015e  << 2) + 0xfe00c000)
#define PWRCTRL_DSPA_FSM_JUMP                      ((0x015f  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_AUTO_OFF_CTRL0                ((0x0160  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_AUTO_OFF_CTRL1                ((0x0161  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_AUTO_OFF_CTRL2                ((0x0162  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_AUTO_OFF_CTRL3                ((0x0163  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_AUTO_OFF_CTRL4                ((0x0164  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_TIMER_TH_01                   ((0x0168  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_TIMER_TH_23                   ((0x0169  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_TIMER_TH_45                   ((0x016a  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_TIMER_TH_67                   ((0x016b  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_TIMER_TH_89                   ((0x016c  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK0                     ((0x0170  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK1                     ((0x0171  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK2                     ((0x0172  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK3                     ((0x0173  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK4                     ((0x0174  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK5                     ((0x0175  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK6                     ((0x0176  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_IRQ_MASK7                     ((0x0177  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_INIT_SET                ((0x0180  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_OFF_SET                 ((0x0181  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_ON_A_SET                ((0x0182  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_ON_B_SET                ((0x0183  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_ON_C_SET                ((0x0184  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_ON_D_SET                ((0x0185  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_MEMPD_STS                     ((0x0186  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_STS0                      ((0x0187  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_STS1                      ((0x0188  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_STS2                      ((0x0189  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_START_OFF                 ((0x018d  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_START_ON                  ((0x018e  << 2) + 0xfe00c000)
#define PWRCTRL_DSPB_FSM_JUMP                      ((0x018f  << 2) + 0xfe00c000)
//========================================================================
// RSA
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe042000
// -----------------------------------------------
#define RSA_BASE                                   ((0x0000  << 2) + 0xfe042000)
//========================================================================
//  AOCPU
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe09c000
// -----------------------------------------------
#define AOCPU_CPU_CTRL0                            ((0x0000  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_CTRL1                            ((0x0001  << 2) + 0xfe09c000)
//Bit 31:11-       0   - n205 address shift, 1: 0x8000_0000~0x4000_0000
//Bit 30:11-       0   - reserved
//Bit 10   -       0   - gate by sleep, 1: gate, 0: free run
//Bit  9   -       0   - RXEV for riscv input refer riscv doc
//Bit  8   -       0   - reserved
//Bit   7:6-       0   - n205_debug_sel,aocpu_core_status0 info select
//Bit   5:2-       0   - reserved
//Bit 1    -       0   - n205_i_dbg_stop
//Bit 0    -       0   - n205_pc_enable
#define AOCPU_CPU_CTRL2                            ((0x0002  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_CTRL3                            ((0x0003  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_CTRL4                            ((0x0004  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_CTRL5                            ((0x0005  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_STS0                             ((0x000a  << 2) + 0xfe09c000)
//Bit 31:0 -       0   - n205_debug_sel==0 : n205_trace_cause, 1:n205_trace_tval, 2:n205_trace_iaddr, 3:n205_trace_instr
#define AOCPU_CPU_STS1                             ((0x000b  << 2) + 0xfe09c000)
//Bit 31   -       0   - n205_core_sleep_value
//Bit 30:29-       0   - n205_trace_priv
//Bit 28:20-       0   - reserved
//Bit 19   -       0   - n205_core_wfi_mode
//Bit 18   -       0   - n205_trace_invalid
//Bit 17   -       0   - n205_trace_iexception
//Bit 16   -       0   - n205_trace_interrupt
//Bit 15:0 -       0   - reserved
#define AOCPU_CPU_STS2                             ((0x000c  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_CPU_STS3                             ((0x000d  << 2) + 0xfe09c000)
//Bit 31   -       0   - n205_hart_halted
//Bit 30   -       0   - n205_ndmreset
//Bit 29   -       0   - n205_dmactive
//Bit 28:0 -       0   - reserved
#define AOCPU_CPU_VECTOR                           ((0x000f  << 2) + 0xfe09c000)
//Bit 31:0-   0x1000_0000   - reserved
#define AOCPU_IRQ_SEL0                             ((0x0010  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR03 interrupt source select in int_map
//Bit 23:16-       0   - INTISR02 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR01 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR00 interrupt source select in int_map
#define AOCPU_IRQ_SEL1                             ((0x0011  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR07 interrupt source select in int_map
//Bit 23:16-       0   - INTISR06 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR05 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR04 interrupt source select in int_map
#define AOCPU_IRQ_SEL2                             ((0x0012  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR11 interrupt source select in int_map
//Bit 23:16-       0   - INTISR10 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR09 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR08 interrupt source select in int_map
#define AOCPU_IRQ_SEL3                             ((0x0013  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR15 interrupt source select in int_map
//Bit 23:16-       0   - INTISR14 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR13 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR12 interrupt source select in int_map
#define AOCPU_IRQ_SEL4                             ((0x0014  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR19 interrupt source select in int_map
//Bit 23:16-       0   - INTISR18 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR17 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR16 interrupt source select in int_map
#define AOCPU_IRQ_SEL5                             ((0x0015  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR23 interrupt source select in int_map
//Bit 23:16-       0   - INTISR22 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR21 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR20 interrupt source select in int_map
#define AOCPU_IRQ_SEL6                             ((0x0016  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR27 interrupt source select in int_map
//Bit 23:16-       0   - INTISR26 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR25 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR24 interrupt source select in int_map
#define AOCPU_IRQ_SEL7                             ((0x0017  << 2) + 0xfe09c000)
//Bit 31:24-       0   - INTISR31 interrupt source select in int_map
//Bit 23:16-       0   - INTISR30 interrupt source select in int_map
//Bit 15:8 -       0   - INTISR29 interrupt source select in int_map
//Bit  7:0 -       0   - INTISR28 interrupt source select in int_map
#define AOCPU_STS00_BYCPU                          ((0x0018  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS01_BYCPU                          ((0x0019  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS02_BYCPU                          ((0x001a  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS03_BYCPU                          ((0x001b  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS04_BYCPU                          ((0x001c  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS05_BYCPU                          ((0x001d  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS06_BYCPU                          ((0x001e  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
#define AOCPU_STS07_BYCPU                          ((0x001f  << 2) + 0xfe09c000)
//Bit 31:0-       0   - reserved
//========================================================================
//  AUCPU
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe09e000
// -----------------------------------------------
#define AUCPU_CPU_CTRL0                            ((0x0000  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_CTRL1                            ((0x0001  << 2) + 0xfe09e000)
//Bit 31:11-       0   - reserved
//Bit 10   -       0   - gate by sleep
//Bit 9    -       0   - RXEV
//Bit 8    -       0   - reserved
//Bit 7:6  -       0   - n205_debug_sel,aucpu_core_status0 info select
//Bit 5:2  -       0   - reserved
//Bit 1    -       0   - n205_i_dbg_stop
//Bit 0    -       0   - n205_pc_enable
#define AUCPU_CPU_CTRL2                            ((0x0002  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_CTRL3                            ((0x0003  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_CTRL4                            ((0x0004  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_CTRL5                            ((0x0005  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_STS0                             ((0x000a  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - n205_debug_sel==0 : n205_trace_cause, 1:n205_trace_tval, 2:n205_trace_iaddr, 3:n205_trace_instr
#define AUCPU_CPU_STS1                             ((0x000b  << 2) + 0xfe09e000)
//Bit 31   -       0   - n205_core_sleep_value
//Bit 30:29-       0   - n205_trace_priv
//Bit 28:20-       0   - reserved
//Bit 19   -       0   - n205_core_wfi_mode
//Bit 18   -       0   - n205_trace_invalid
//Bit 17   -       0   - n205_trace_iexception
//Bit 16   -       0   - n205_trace_interrupt
//Bit 15:0 -       0   - reserved
#define AUCPU_CPU_STS2                             ((0x000c  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_CPU_STS3                             ((0x000d  << 2) + 0xfe09e000)
//Bit 31   -       0   - n205_hart_halted
//Bit 30   -       0   - n205_ndmreset
//Bit 29   -       0   - n205_dmactive
//Bit 28:0 -       0   - reserved
#define AUCPU_DMA_APB_SEL                          ((0x0010  << 2) + 0xfe09e000)
//Bit 31:30-       0   - reserved
//Bit 0    -       0   - 1: riscv control dma, 0: ap control dma
#define AUCPU_IRQ_AP2RISCV                         ((0x0011  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - AP cpu send irq to riscv
#define AUCPU_IRQ_RISCV2AP                         ((0x0012  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - riscv send irq to AP
#define AUCPU_STS00_BY_AP                          ((0x0020  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS01_BY_AP                          ((0x0021  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS02_BY_AP                          ((0x0022  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS03_BY_AP                          ((0x0023  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS04_BY_AP                          ((0x0024  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS05_BY_AP                          ((0x0025  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS06_BY_AP                          ((0x0026  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS07_BY_AP                          ((0x0027  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS08_BY_AP                          ((0x0028  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS09_BY_AP                          ((0x0029  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS10_BY_AP                          ((0x002a  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS11_BY_AP                          ((0x002b  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS12_BY_AP                          ((0x002c  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS13_BY_AP                          ((0x002d  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS14_BY_AP                          ((0x002e  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS15_BY_AP                          ((0x002f  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS16_BY_AP                          ((0x0030  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS17_BY_AP                          ((0x0031  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS18_BY_AP                          ((0x0032  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS19_BY_AP                          ((0x0033  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS20_BY_AP                          ((0x0034  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS21_BY_AP                          ((0x0035  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS22_BY_AP                          ((0x0036  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS23_BY_AP                          ((0x0037  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS24_BY_AP                          ((0x0038  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS25_BY_AP                          ((0x0039  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS26_BY_AP                          ((0x003a  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS27_BY_AP                          ((0x003b  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS28_BY_AP                          ((0x003c  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS29_BY_AP                          ((0x003d  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS30_BY_AP                          ((0x003e  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS31_BY_AP                          ((0x003f  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS00_BY_RISCV                       ((0x0040  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS01_BY_RISCV                       ((0x0041  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS02_BY_RISCV                       ((0x0042  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS03_BY_RISCV                       ((0x0043  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS04_BY_RISCV                       ((0x0044  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS05_BY_RISCV                       ((0x0045  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS06_BY_RISCV                       ((0x0046  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS07_BY_RISCV                       ((0x0047  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS08_BY_RISCV                       ((0x0048  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS09_BY_RISCV                       ((0x0049  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS10_BY_RISCV                       ((0x004a  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS11_BY_RISCV                       ((0x004b  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS12_BY_RISCV                       ((0x004c  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS13_BY_RISCV                       ((0x004d  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS14_BY_RISCV                       ((0x004e  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS15_BY_RISCV                       ((0x004f  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS16_BY_RISCV                       ((0x0050  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS17_BY_RISCV                       ((0x0051  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS18_BY_RISCV                       ((0x0052  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS19_BY_RISCV                       ((0x0053  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS20_BY_RISCV                       ((0x0054  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS21_BY_RISCV                       ((0x0055  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS22_BY_RISCV                       ((0x0056  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS23_BY_RISCV                       ((0x0057  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS24_BY_RISCV                       ((0x0058  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS25_BY_RISCV                       ((0x0059  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS26_BY_RISCV                       ((0x005a  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS27_BY_RISCV                       ((0x005b  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS28_BY_RISCV                       ((0x005c  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS29_BY_RISCV                       ((0x005d  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS30_BY_RISCV                       ((0x005e  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_STS31_BY_RISCV                       ((0x005f  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - reserved
#define AUCPU_DEMUX_STS_BY_RISCV                   ((0x0060  << 2) + 0xfe09e000)
//Bit 31   -       0   - read only, demux status updated
//Bit 31:8 -       0   - reserved
//Bit  7:0 -       0   - read demux chn select
#define AUCPU_DEMUX_STS0                           ((0x0061  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - demux status 0
#define AUCPU_DEMUX_STS1                           ((0x0062  << 2) + 0xfe09e000)
//Bit 31:0 -       0   - demux status 1
//========================================================================
//  AXI_SRAM
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe090000
// -----------------------------------------------
#define SRAM_RANGE0_STA                            ((0x0000  << 2) + 0xfe090000)
#define SRAM_RANGE1_STA                            ((0x0001  << 2) + 0xfe090000)
#define SRAM_RANGE2_STA                            ((0x0002  << 2) + 0xfe090000)
#define SRAM_RANGE3_STA                            ((0x0003  << 2) + 0xfe090000)
#define SRAM_RANGE4_STA                            ((0x0004  << 2) + 0xfe090000)
#define SRAM_RANGE5_STA                            ((0x0005  << 2) + 0xfe090000)
#define SRAM_RANGE6_STA                            ((0x0006  << 2) + 0xfe090000)
#define SRAM_RANGE7_STA                            ((0x0007  << 2) + 0xfe090000)
#define SRAM_RANGE8_STA                            ((0x0008  << 2) + 0xfe090000)
#define SRAM_RANGE9_STA                            ((0x0009  << 2) + 0xfe090000)
#define SRAM_RANGE10_STA                           ((0x000a  << 2) + 0xfe090000)
#define SRAM_RANGE11_STA                           ((0x000b  << 2) + 0xfe090000)
#define SRAM_RANGE12_STA                           ((0x000c  << 2) + 0xfe090000)
#define SRAM_RANGE13_STA                           ((0x000d  << 2) + 0xfe090000)
#define SRAM_RANGE14_STA                           ((0x000e  << 2) + 0xfe090000)
#define SRAM_RANGE0_EDA                            ((0x000f  << 2) + 0xfe090000)
#define SRAM_RANGE1_EDA                            ((0x0010  << 2) + 0xfe090000)
#define SRAM_RANGE2_EDA                            ((0x0011  << 2) + 0xfe090000)
#define SRAM_RANGE3_EDA                            ((0x0012  << 2) + 0xfe090000)
#define SRAM_RANGE4_EDA                            ((0x0013  << 2) + 0xfe090000)
#define SRAM_RANGE5_EDA                            ((0x0014  << 2) + 0xfe090000)
#define SRAM_RANGE6_EDA                            ((0x0015  << 2) + 0xfe090000)
#define SRAM_RANGE7_EDA                            ((0x0016  << 2) + 0xfe090000)
#define SRAM_RANGE8_EDA                            ((0x0017  << 2) + 0xfe090000)
#define SRAM_RANGE9_EDA                            ((0x0018  << 2) + 0xfe090000)
#define SRAM_RANGE10_EDA                           ((0x0019  << 2) + 0xfe090000)
#define SRAM_RANGE11_EDA                           ((0x001a  << 2) + 0xfe090000)
#define SRAM_RANGE12_EDA                           ((0x001b  << 2) + 0xfe090000)
#define SRAM_RANGE13_EDA                           ((0x001c  << 2) + 0xfe090000)
#define SRAM_RANGE14_EDA                           ((0x001d  << 2) + 0xfe090000)
#define SRAM_RANGE0_READ_CTRL0                     ((0x001e  << 2) + 0xfe090000)
#define SRAM_RANGE1_READ_CTRL0                     ((0x001f  << 2) + 0xfe090000)
#define SRAM_RANGE2_READ_CTRL0                     ((0x0020  << 2) + 0xfe090000)
#define SRAM_RANGE3_READ_CTRL0                     ((0x0021  << 2) + 0xfe090000)
#define SRAM_RANGE4_READ_CTRL0                     ((0x0022  << 2) + 0xfe090000)
#define SRAM_RANGE5_READ_CTRL0                     ((0x0023  << 2) + 0xfe090000)
#define SRAM_RANGE6_READ_CTRL0                     ((0x0024  << 2) + 0xfe090000)
#define SRAM_RANGE7_READ_CTRL0                     ((0x0025  << 2) + 0xfe090000)
#define SRAM_RANGE8_READ_CTRL0                     ((0x0026  << 2) + 0xfe090000)
#define SRAM_RANGE9_READ_CTRL0                     ((0x0027  << 2) + 0xfe090000)
#define SRAM_RANGE10_READ_CTRL0                    ((0x0028  << 2) + 0xfe090000)
#define SRAM_RANGE11_READ_CTRL0                    ((0x0029  << 2) + 0xfe090000)
#define SRAM_RANGE12_READ_CTRL0                    ((0x002a  << 2) + 0xfe090000)
#define SRAM_RANGE13_READ_CTRL0                    ((0x002b  << 2) + 0xfe090000)
#define SRAM_RANGE14_READ_CTRL0                    ((0x002c  << 2) + 0xfe090000)
#define SRAM_RANGE15_READ_CTRL0                    ((0x002d  << 2) + 0xfe090000)
#define SRAM_RANGE0_WRITE_CTRL0                    ((0x002e  << 2) + 0xfe090000)
#define SRAM_RANGE1_WRITE_CTRL0                    ((0x002f  << 2) + 0xfe090000)
#define SRAM_RANGE2_WRITE_CTRL0                    ((0x0030  << 2) + 0xfe090000)
#define SRAM_RANGE3_WRITE_CTRL0                    ((0x0031  << 2) + 0xfe090000)
#define SRAM_RANGE4_WRITE_CTRL0                    ((0x0032  << 2) + 0xfe090000)
#define SRAM_RANGE5_WRITE_CTRL0                    ((0x0033  << 2) + 0xfe090000)
#define SRAM_RANGE6_WRITE_CTRL0                    ((0x0034  << 2) + 0xfe090000)
#define SRAM_RANGE7_WRITE_CTRL0                    ((0x0035  << 2) + 0xfe090000)
#define SRAM_RANGE8_WRITE_CTRL0                    ((0x0036  << 2) + 0xfe090000)
#define SRAM_RANGE9_WRITE_CTRL0                    ((0x0037  << 2) + 0xfe090000)
#define SRAM_RANGE10_WRITE_CTRL0                   ((0x0038  << 2) + 0xfe090000)
#define SRAM_RANGE11_WRITE_CTRL0                   ((0x0039  << 2) + 0xfe090000)
#define SRAM_RANGE12_WRITE_CTRL0                   ((0x003a  << 2) + 0xfe090000)
#define SRAM_RANGE13_WRITE_CTRL0                   ((0x003b  << 2) + 0xfe090000)
#define SRAM_RANGE14_WRITE_CTRL0                   ((0x003c  << 2) + 0xfe090000)
#define SRAM_RANGE15_WRITE_CTRL0                   ((0x003d  << 2) + 0xfe090000)
#define SRAM_RANGE0_READ_CTRL1                     ((0x003e  << 2) + 0xfe090000)
#define SRAM_RANGE1_READ_CTRL1                     ((0x003f  << 2) + 0xfe090000)
#define SRAM_RANGE2_READ_CTRL1                     ((0x0040  << 2) + 0xfe090000)
#define SRAM_RANGE3_READ_CTRL1                     ((0x0041  << 2) + 0xfe090000)
#define SRAM_RANGE4_READ_CTRL1                     ((0x0042  << 2) + 0xfe090000)
#define SRAM_RANGE5_READ_CTRL1                     ((0x0043  << 2) + 0xfe090000)
#define SRAM_RANGE6_READ_CTRL1                     ((0x0044  << 2) + 0xfe090000)
#define SRAM_RANGE7_READ_CTRL1                     ((0x0045  << 2) + 0xfe090000)
#define SRAM_RANGE8_READ_CTRL1                     ((0x0046  << 2) + 0xfe090000)
#define SRAM_RANGE9_READ_CTRL1                     ((0x0047  << 2) + 0xfe090000)
#define SRAM_RANGE10_READ_CTRL1                    ((0x0048  << 2) + 0xfe090000)
#define SRAM_RANGE11_READ_CTRL1                    ((0x0049  << 2) + 0xfe090000)
#define SRAM_RANGE12_READ_CTRL1                    ((0x004a  << 2) + 0xfe090000)
#define SRAM_RANGE13_READ_CTRL1                    ((0x004b  << 2) + 0xfe090000)
#define SRAM_RANGE14_READ_CTRL1                    ((0x004c  << 2) + 0xfe090000)
#define SRAM_RANGE15_READ_CTRL1                    ((0x004d  << 2) + 0xfe090000)
#define SRAM_RANGE0_WRITE_CTRL1                    ((0x004e  << 2) + 0xfe090000)
#define SRAM_RANGE1_WRITE_CTRL1                    ((0x004f  << 2) + 0xfe090000)
#define SRAM_RANGE2_WRITE_CTRL1                    ((0x0050  << 2) + 0xfe090000)
#define SRAM_RANGE3_WRITE_CTRL1                    ((0x0051  << 2) + 0xfe090000)
#define SRAM_RANGE4_WRITE_CTRL1                    ((0x0052  << 2) + 0xfe090000)
#define SRAM_RANGE5_WRITE_CTRL1                    ((0x0053  << 2) + 0xfe090000)
#define SRAM_RANGE6_WRITE_CTRL1                    ((0x0054  << 2) + 0xfe090000)
#define SRAM_RANGE7_WRITE_CTRL1                    ((0x0055  << 2) + 0xfe090000)
#define SRAM_RANGE8_WRITE_CTRL1                    ((0x0056  << 2) + 0xfe090000)
#define SRAM_RANGE9_WRITE_CTRL1                    ((0x0057  << 2) + 0xfe090000)
#define SRAM_RANGE10_WRITE_CTRL1                   ((0x0058  << 2) + 0xfe090000)
#define SRAM_RANGE11_WRITE_CTRL1                   ((0x0059  << 2) + 0xfe090000)
#define SRAM_RANGE12_WRITE_CTRL1                   ((0x005a  << 2) + 0xfe090000)
#define SRAM_RANGE13_WRITE_CTRL1                   ((0x005b  << 2) + 0xfe090000)
#define SRAM_RANGE14_WRITE_CTRL1                   ((0x005c  << 2) + 0xfe090000)
#define SRAM_RANGE15_WRITE_CTRL1                   ((0x005d  << 2) + 0xfe090000)
#define SRAM_GLOBAL_READ_CTRL0                     ((0x005e  << 2) + 0xfe090000)
#define SRAM_GLOBAL_READ_CTRL1                     ((0x005f  << 2) + 0xfe090000)
#define SRAM_GLOBAL_WRITE_CTRL0                    ((0x0060  << 2) + 0xfe090000)
#define SRAM_GLOBAL_WRITE_CTRL1                    ((0x0061  << 2) + 0xfe090000)
#define SRAM_SEC_CTRL0                             ((0x0062  << 2) + 0xfe090000)
#define SRAM_REG_LOCK0                             ((0x0063  << 2) + 0xfe090000)
#define SRAM_REG_LOCK1                             ((0x0064  << 2) + 0xfe090000)
#define SRAM_REG_LOCK2                             ((0x0065  << 2) + 0xfe090000)
#define SRAM_GLOBAL_READ_CTRL0_LOCK                ((0x0066  << 2) + 0xfe090000)
#define SRAM_GLOBAL_READ_CTRL1_LOCK                ((0x0067  << 2) + 0xfe090000)
#define SRAM_GLOBAL_WRITE_CTRL0_LOCK               ((0x0068  << 2) + 0xfe090000)
#define SRAM_GLOBAL_WRITE_CTRL1_LOCK               ((0x0069  << 2) + 0xfe090000)
#define SRAM_SEC_CTRL0_LOCK                        ((0x006a  << 2) + 0xfe090000)
#define SRAM_STATUS_REG                            ((0x006b  << 2) + 0xfe090000)
//========================================================================
//  MAILBOX
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe006000
// -----------------------------------------------
#define MAILBOX_WR_MBOX00                          ((0x0000  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX01                          ((0x0020  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX02                          ((0x0040  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX03                          ((0x0060  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX04                          ((0x0080  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX05                          ((0x00a0  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX06                          ((0x00c0  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX07                          ((0x00e0  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX08                          ((0x0100  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX09                          ((0x0120  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX10                          ((0x0140  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX11                          ((0x0160  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX12                          ((0x0180  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX13                          ((0x01a0  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX14                          ((0x01c0  << 2) + 0xfe006000)
#define MAILBOX_WR_MBOX15                          ((0x01e0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX00                          ((0x0200  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX01                          ((0x0220  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX02                          ((0x0240  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX03                          ((0x0260  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX04                          ((0x0280  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX05                          ((0x02a0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX06                          ((0x02c0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX07                          ((0x02e0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX08                          ((0x0300  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX09                          ((0x0320  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX10                          ((0x0340  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX11                          ((0x0360  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX12                          ((0x0380  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX13                          ((0x03a0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX14                          ((0x03c0  << 2) + 0xfe006000)
#define MAILBOX_RD_MBOX15                          ((0x03e0  << 2) + 0xfe006000)
#define MAILBOX_LOCK_BIT0                          ((0x0400  << 2) + 0xfe006000)
#define MAILBOX_LOCK_BIT1                          ((0x0401  << 2) + 0xfe006000)
#define MAILBOX_PROT_BIT0                          ((0x0402  << 2) + 0xfe006000)
#define MAILBOX_PROT_BIT1                          ((0x0403  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_IRQA_CLR                 ((0x0404  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_IRQB_CLR                 ((0x0405  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_IRQC_CLR                 ((0x0406  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_IRQD_CLR                 ((0x0407  << 2) + 0xfe006000)
#define MAILBOX_IRQA_MASK                          ((0x0408  << 2) + 0xfe006000)
#define MAILBOX_IRQB_MASK                          ((0x0409  << 2) + 0xfe006000)
#define MAILBOX_IRQC_MASK                          ((0x040a  << 2) + 0xfe006000)
#define MAILBOX_IRQD_MASK                          ((0x040b  << 2) + 0xfe006000)
#define MAILBOX_IRQ_TYPE                           ((0x040c  << 2) + 0xfe006000)
#define MAILBOX_IRQA_CLR                           ((0x0410  << 2) + 0xfe006000)
#define MAILBOX_IRQB_CLR                           ((0x0411  << 2) + 0xfe006000)
#define MAILBOX_IRQC_CLR                           ((0x0412  << 2) + 0xfe006000)
#define MAILBOX_IRQD_CLR                           ((0x0413  << 2) + 0xfe006000)
#define MAILBOX_IRQA_STS                           ((0x0414  << 2) + 0xfe006000)
#define MAILBOX_IRQB_STS                           ((0x0415  << 2) + 0xfe006000)
#define MAILBOX_IRQC_STS                           ((0x0416  << 2) + 0xfe006000)
#define MAILBOX_IRQD_STS                           ((0x0417  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX00                   ((0x0420  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX01                   ((0x0421  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX02                   ((0x0422  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX03                   ((0x0423  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX04                   ((0x0424  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX05                   ((0x0425  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX06                   ((0x0426  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX07                   ((0x0427  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX08                   ((0x0428  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX09                   ((0x0429  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX10                   ((0x042a  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX11                   ((0x042b  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX12                   ((0x042c  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX13                   ((0x042d  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX14                   ((0x042e  << 2) + 0xfe006000)
#define MAILBOX_ACCESS_EN_MBOX15                   ((0x042f  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX00                         ((0x0430  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX01                         ((0x0431  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX02                         ((0x0432  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX03                         ((0x0433  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX04                         ((0x0434  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX05                         ((0x0435  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX06                         ((0x0436  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX07                         ((0x0437  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX08                         ((0x0438  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX09                         ((0x0439  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX10                         ((0x043a  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX11                         ((0x043b  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX12                         ((0x043c  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX13                         ((0x043d  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX14                         ((0x043e  << 2) + 0xfe006000)
#define MAILBOX_SET_MBOX15                         ((0x043f  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX00                         ((0x0440  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX01                         ((0x0441  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX02                         ((0x0442  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX03                         ((0x0443  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX04                         ((0x0444  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX05                         ((0x0445  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX06                         ((0x0446  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX07                         ((0x0447  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX08                         ((0x0448  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX09                         ((0x0449  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX10                         ((0x044a  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX11                         ((0x044b  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX12                         ((0x044c  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX13                         ((0x044d  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX14                         ((0x044e  << 2) + 0xfe006000)
#define MAILBOX_CLR_MBOX15                         ((0x044f  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX00                         ((0x0450  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX01                         ((0x0451  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX02                         ((0x0452  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX03                         ((0x0453  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX04                         ((0x0454  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX05                         ((0x0455  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX06                         ((0x0456  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX07                         ((0x0457  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX08                         ((0x0458  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX09                         ((0x0459  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX10                         ((0x045a  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX11                         ((0x045b  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX12                         ((0x045c  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX13                         ((0x045d  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX14                         ((0x045e  << 2) + 0xfe006000)
#define MAILBOX_STS_MBOX15                         ((0x045f  << 2) + 0xfe006000)
//========================================================================
//  IRQ_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe00a000
// -----------------------------------------------
#define IRQCTRL_IRQ_INV0                           ((0x0000  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV1                           ((0x0001  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV2                           ((0x0002  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV3                           ((0x0003  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV4                           ((0x0004  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV5                           ((0x0005  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV6                           ((0x0006  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_INV7                           ((0x0007  << 2) + 0xfe00a000)
#define IRQCTRL_MASK0_GIC                          ((0x0010  << 2) + 0xfe00a000)
#define IRQCTRL_MASK1_GIC                          ((0x0011  << 2) + 0xfe00a000)
#define IRQCTRL_MASK2_GIC                          ((0x0012  << 2) + 0xfe00a000)
#define IRQCTRL_MASK3_GIC                          ((0x0013  << 2) + 0xfe00a000)
#define IRQCTRL_MASK4_GIC                          ((0x0014  << 2) + 0xfe00a000)
#define IRQCTRL_MASK5_GIC                          ((0x0015  << 2) + 0xfe00a000)
#define IRQCTRL_MASK6_GIC                          ((0x0016  << 2) + 0xfe00a000)
#define IRQCTRL_MASK7_GIC                          ((0x0017  << 2) + 0xfe00a000)
#define IRQCTRL_MASK0_DSP                          ((0x0020  << 2) + 0xfe00a000)
#define IRQCTRL_MASK1_DSP                          ((0x0021  << 2) + 0xfe00a000)
#define IRQCTRL_MASK2_DSP                          ((0x0022  << 2) + 0xfe00a000)
#define IRQCTRL_MASK3_DSP                          ((0x0023  << 2) + 0xfe00a000)
#define IRQCTRL_MASK4_DSP                          ((0x0024  << 2) + 0xfe00a000)
#define IRQCTRL_MASK5_DSP                          ((0x0025  << 2) + 0xfe00a000)
#define IRQCTRL_MASK6_DSP                          ((0x0026  << 2) + 0xfe00a000)
#define IRQCTRL_MASK7_DSP                          ((0x0027  << 2) + 0xfe00a000)
#define IRQCTRL_MASK0_PWRCTRL                      ((0x0030  << 2) + 0xfe00a000)
#define IRQCTRL_MASK1_PWRCTRL                      ((0x0031  << 2) + 0xfe00a000)
#define IRQCTRL_MASK2_PWRCTRL                      ((0x0032  << 2) + 0xfe00a000)
#define IRQCTRL_MASK3_PWRCTRL                      ((0x0033  << 2) + 0xfe00a000)
#define IRQCTRL_MASK4_PWRCTRL                      ((0x0034  << 2) + 0xfe00a000)
#define IRQCTRL_MASK5_PWRCTRL                      ((0x0035  << 2) + 0xfe00a000)
#define IRQCTRL_MASK6_PWRCTRL                      ((0x0036  << 2) + 0xfe00a000)
#define IRQCTRL_MASK7_PWRCTRL                      ((0x0037  << 2) + 0xfe00a000)
#define IRQCTRL_MASK0_AOCPU                        ((0x0040  << 2) + 0xfe00a000)
#define IRQCTRL_MASK1_AOCPU                        ((0x0041  << 2) + 0xfe00a000)
#define IRQCTRL_MASK2_AOCPU                        ((0x0042  << 2) + 0xfe00a000)
#define IRQCTRL_MASK3_AOCPU                        ((0x0043  << 2) + 0xfe00a000)
#define IRQCTRL_MASK4_AOCPU                        ((0x0044  << 2) + 0xfe00a000)
#define IRQCTRL_MASK5_AOCPU                        ((0x0045  << 2) + 0xfe00a000)
#define IRQCTRL_MASK6_AOCPU                        ((0x0046  << 2) + 0xfe00a000)
#define IRQCTRL_MASK7_AOCPU                        ((0x0047  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE0                          ((0x0050  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE1                          ((0x0051  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE2                          ((0x0052  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE3                          ((0x0053  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE4                          ((0x0054  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE5                          ((0x0055  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE6                          ((0x0056  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_MODE7                          ((0x0057  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH0                         ((0x0060  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH1                         ((0x0061  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH2                         ((0x0062  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH3                         ((0x0063  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH4                         ((0x0064  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH5                         ((0x0065  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH6                         ((0x0066  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH7                         ((0x0067  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR0                     ((0x0070  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR1                     ((0x0071  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR2                     ((0x0072  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR3                     ((0x0073  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR4                     ((0x0074  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR5                     ((0x0075  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR6                     ((0x0076  << 2) + 0xfe00a000)
#define IRQCTRL_IRQ_LATCH_CLR7                     ((0x0077  << 2) + 0xfe00a000)
#define IRQCTRL_LOCK_BIT                           ((0x0080  << 2) + 0xfe00a000)
#define IRQCTRL_PROT_BIT                           ((0x0081  << 2) + 0xfe00a000)
//========================================================================
//  RESET_CTRL - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe002000
// -----------------------------------------------
#define RESETCTRL_RESET0                           ((0x0000  << 2) + 0xfe002000)
#define RESETCTRL_RESET1                           ((0x0001  << 2) + 0xfe002000)
#define RESETCTRL_RESET2                           ((0x0002  << 2) + 0xfe002000)
#define RESETCTRL_RESET3                           ((0x0003  << 2) + 0xfe002000)
#define RESETCTRL_RESET4                           ((0x0004  << 2) + 0xfe002000)
#define RESETCTRL_RESET5                           ((0x0005  << 2) + 0xfe002000)
#define RESETCTRL_RESET0_LEVEL                     ((0x0010  << 2) + 0xfe002000)
#define RESETCTRL_RESET1_LEVEL                     ((0x0011  << 2) + 0xfe002000)
#define RESETCTRL_RESET2_LEVEL                     ((0x0012  << 2) + 0xfe002000)
#define RESETCTRL_RESET3_LEVEL                     ((0x0013  << 2) + 0xfe002000)
#define RESETCTRL_RESET4_LEVEL                     ((0x0014  << 2) + 0xfe002000)
#define RESETCTRL_RESET5_LEVEL                     ((0x0015  << 2) + 0xfe002000)
#define RESETCTRL_RESET0_MASK                      ((0x0020  << 2) + 0xfe002000)
#define RESETCTRL_RESET1_MASK                      ((0x0021  << 2) + 0xfe002000)
#define RESETCTRL_RESET2_MASK                      ((0x0022  << 2) + 0xfe002000)
#define RESETCTRL_RESET3_MASK                      ((0x0023  << 2) + 0xfe002000)
#define RESETCTRL_RESET4_MASK                      ((0x0024  << 2) + 0xfe002000)
#define RESETCTRL_RESET5_MASK                      ((0x0025  << 2) + 0xfe002000)
#define RESETCTRL_RESET_HOLD_CYC                   ((0x0030  << 2) + 0xfe002000)
#define RESETCTRL_WATCHDOG_CTRL0                   ((0x0040  << 2) + 0xfe002000)
#define RESETCTRL_WATCHDOG_CTRL1                   ((0x0041  << 2) + 0xfe002000)
#define RESETCTRL_WATCHDOG_CNT                     ((0x0042  << 2) + 0xfe002000)
#define RESETCTRL_WATCHDOG_CLR                     ((0x0043  << 2) + 0xfe002000)
#define RESETCTRL_SEC_WATCHDOG_CTRL0               ((0x0044  << 2) + 0xfe002000)
#define RESETCTRL_SEC_WATCHDOG_CTRL1               ((0x0045  << 2) + 0xfe002000)
#define RESETCTRL_SEC_WATCHDOG_CNT                 ((0x0046  << 2) + 0xfe002000)
#define RESETCTRL_SEC_WATCHDOG_CLR                 ((0x0047  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET0                       ((0x0050  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET1                       ((0x0051  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET0_LEVEL                 ((0x0060  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET1_LEVEL                 ((0x0061  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET0_MASK                  ((0x0070  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET1_MASK                  ((0x0071  << 2) + 0xfe002000)
#define RESETCTRL_RESET0_LOCK                      ((0x0080  << 2) + 0xfe002000)
#define RESETCTRL_RESET1_LOCK                      ((0x0081  << 2) + 0xfe002000)
#define RESETCTRL_RESET2_LOCK                      ((0x0082  << 2) + 0xfe002000)
#define RESETCTRL_RESET3_LOCK                      ((0x0083  << 2) + 0xfe002000)
#define RESETCTRL_RESET4_LOCK                      ((0x0084  << 2) + 0xfe002000)
#define RESETCTRL_RESET5_LOCK                      ((0x0085  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET0_LOCK                  ((0x0088  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET1_LOCK                  ((0x0089  << 2) + 0xfe002000)
#define RESETCTRL_RESET0_PROT                      ((0x0090  << 2) + 0xfe002000)
#define RESETCTRL_RESET1_PROT                      ((0x0091  << 2) + 0xfe002000)
#define RESETCTRL_RESET2_PROT                      ((0x0092  << 2) + 0xfe002000)
#define RESETCTRL_RESET3_PROT                      ((0x0093  << 2) + 0xfe002000)
#define RESETCTRL_RESET4_PROT                      ((0x0094  << 2) + 0xfe002000)
#define RESETCTRL_RESET5_PROT                      ((0x0095  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET0_PROT                  ((0x0098  << 2) + 0xfe002000)
#define RESETCTRL_SEC_RESET1_PROT                  ((0x0099  << 2) + 0xfe002000)
//========================================================================
//  CPU_CTRL
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe00e000
// -----------------------------------------------
#define CPUCTRL_SYS_CPU_RESET_CNTL                 ((0x0050  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL                   ((0x0051  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL1                  ((0x0052  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL2                  ((0x0053  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL3                  ((0x0054  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL4                  ((0x0055  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL5                  ((0x0056  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_CTRL6                  ((0x0057  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CLK_RESULT                 ((0x0058  << 2) + 0xfe00e000)
#define CPUCTRL_ROM_DISABLE                        ((0x0060  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_POR_CFG0                   ((0x0090  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_POR_CFG1                   ((0x0091  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG0                       ((0x0092  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG1                       ((0x0093  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG2                       ((0x0094  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG3                       ((0x0095  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG4                       ((0x0096  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG5                       ((0x0097  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG6                       ((0x0098  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG7                       ((0x0099  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG8                       ((0x009a  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG9                       ((0x009b  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG10                      ((0x009c  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG11                      ((0x009d  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG12                      ((0x009e  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_CFG13                      ((0x009f  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS0                    ((0x00a0  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS1                    ((0x00a1  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS2                    ((0x00a2  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS3                    ((0x00a3  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS4                    ((0x00a4  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS5                    ((0x00a5  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS6                    ((0x00a6  << 2) + 0xfe00e000)
#define CPUCTRL_SYS_CPU_STATUS7                    ((0x00a7  << 2) + 0xfe00e000)
#define SYS_CPU_MISC                               ((0x00a8  << 2) + 0xfe00e000)
//========================================================================
//  SAR_ADC
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe026000
// -----------------------------------------------
#define SAR_ADC_REG0                               ((0x0000  << 2) + 0xfe026000)
#define SAR_ADC_CHAN_LIST                          ((0x0001  << 2) + 0xfe026000)
#define SAR_ADC_AVG_CNTL                           ((0x0002  << 2) + 0xfe026000)
#define SAR_ADC_REG3                               ((0x0003  << 2) + 0xfe026000)
#define SAR_ADC_DELAY                              ((0x0004  << 2) + 0xfe026000)
#define SAR_ADC_LAST_RD                            ((0x0005  << 2) + 0xfe026000)
#define SAR_ADC_FIFO_RD                            ((0x0006  << 2) + 0xfe026000)
#define SAR_ADC_AUX_SW                             ((0x0007  << 2) + 0xfe026000)
#define SAR_ADC_CHAN_10_SW                         ((0x0008  << 2) + 0xfe026000)
#define SAR_ADC_DETECT_IDLE_SW                     ((0x0009  << 2) + 0xfe026000)
#define SAR_ADC_DELTA_10                           ((0x000a  << 2) + 0xfe026000)
#define SAR_ADC_REG11                              ((0x000b  << 2) + 0xfe026000)
#define SAR_ADC_REG12                              ((0x000c  << 2) + 0xfe026000)
#define SAR_ADC_REG13                              ((0x000d  << 2) + 0xfe026000)
#define SAR_ADC_CHNL01                             ((0x000e  << 2) + 0xfe026000)
#define SAR_ADC_CHNL23                             ((0x000f  << 2) + 0xfe026000)
#define SAR_ADC_CHNL45                             ((0x0010  << 2) + 0xfe026000)
#define SAR_ADC_CHNL67                             ((0x0011  << 2) + 0xfe026000)
//========================================================================
//  ANA_CTRL - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe008000
// -----------------------------------------------
#define ANACTRL_SYSPLL_CTRL0                       ((0x0000  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL1                       ((0x0001  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL2                       ((0x0002  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL3                       ((0x0003  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL4                       ((0x0004  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL5                       ((0x0005  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_CTRL6                       ((0x0006  << 2) + 0xfe008000)
#define ANACTRL_SYSPLL_STS                         ((0x0007  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL0                       ((0x0010  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL1                       ((0x0011  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL2                       ((0x0012  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL3                       ((0x0013  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL4                       ((0x0014  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL5                       ((0x0015  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_CTRL6                       ((0x0016  << 2) + 0xfe008000)
#define ANACTRL_FIXPLL_STS                         ((0x0017  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL0                       ((0x0020  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL1                       ((0x0021  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL2                       ((0x0022  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL3                       ((0x0023  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL4                       ((0x0024  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL5                       ((0x0025  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_CTRL6                       ((0x0026  << 2) + 0xfe008000)
#define ANACTRL_GP0PLL_STS                         ((0x0027  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL0                       ((0x0030  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL1                       ((0x0031  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL2                       ((0x0032  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL3                       ((0x0033  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL4                       ((0x0034  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL5                       ((0x0035  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_CTRL6                       ((0x0036  << 2) + 0xfe008000)
#define ANACTRL_GP1PLL_STS                         ((0x0037  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL0                      ((0x0040  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL1                      ((0x0041  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL2                      ((0x0042  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL3                      ((0x0043  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL4                      ((0x0044  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL5                      ((0x0045  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_CTRL6                      ((0x0046  << 2) + 0xfe008000)
#define ANACTRL_HIFIPLL_STS                        ((0x0047  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL0                      ((0x0050  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL1                      ((0x0051  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL2                      ((0x0052  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL3                      ((0x0053  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL4                      ((0x0054  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_CTRL5                      ((0x0055  << 2) + 0xfe008000)
#define ANACTRL_PCIEPLL_STS                        ((0x0056  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL0                         ((0x0060  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL1                         ((0x0061  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL2                         ((0x0062  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL3                         ((0x0063  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL4                         ((0x0064  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL5                         ((0x0065  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL6                         ((0x0066  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL7                         ((0x0067  << 2) + 0xfe008000)
#define ANACTRL_MPLL_CTRL8                         ((0x0068  << 2) + 0xfe008000)
#define ANACTRL_MPLL_STS                           ((0x0069  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL0                      ((0x0070  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL1                      ((0x0071  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL2                      ((0x0072  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL3                      ((0x0073  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL4                      ((0x0074  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL5                      ((0x0075  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_CTRL6                      ((0x0076  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_STS                        ((0x0077  << 2) + 0xfe008000)
#define ANACTRL_HDMIPLL_VLOCK                      ((0x0079  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL0                      ((0x0080  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL1                      ((0x0081  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL2                      ((0x0082  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL3                      ((0x0083  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL4                      ((0x0084  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_CTRL5                      ((0x0085  << 2) + 0xfe008000)
#define ANACTRL_HDMIPHY_STS                        ((0x0086  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL0                      ((0x0090  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL1                      ((0x0091  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL2                      ((0x0092  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL3                      ((0x0093  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL4                      ((0x0094  << 2) + 0xfe008000)
#define ANACTRL_MIPICSI_CTRL5                      ((0x0095  << 2) + 0xfe008000)
#define ANACTRL_MIPIDSI_CTRL0                      ((0x00a0  << 2) + 0xfe008000)
#define ANACTRL_MIPIDSI_CTRL1                      ((0x00a1  << 2) + 0xfe008000)
#define ANACTRL_MIPIDSI_CTRL2                      ((0x00a2  << 2) + 0xfe008000)
#define ANACTRL_MIPIDSI_STS                        ((0x00a3  << 2) + 0xfe008000)
#define ANACTRL_VDAC_CTRL0                         ((0x00b0  << 2) + 0xfe008000)
#define ANACTRL_VDAC_CTRL1                         ((0x00b1  << 2) + 0xfe008000)
#define ANACTRL_POR_CTRL                           ((0x00b6  << 2) + 0xfe008000)
#define ANACTRL_LOCK_BIT                           ((0x00b8  << 2) + 0xfe008000)
#define ANACTRL_PROT_BIT                           ((0x00b9  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL                       ((0x00c0  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL1                      ((0x00c1  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL2                      ((0x00c2  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL3                      ((0x00c3  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL4                      ((0x00c4  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL5                      ((0x00c5  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_CTRL6                      ((0x00c6  << 2) + 0xfe008000)
#define ANACTRL_ADC_PLL_STS                        ((0x00c7  << 2) + 0xfe008000)
#define ANACTRL_S2_DADC_CTRL                       ((0x00d0  << 2) + 0xfe008000)
#define ANACTRL_S2_DADC_CTRL2                      ((0x00d1  << 2) + 0xfe008000)
//========================================================================
//  Ethernet Phy
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe028000
// -----------------------------------------------
#define ETH_PHY_DBG_CTL0                           ((0x0000  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CTL1                           ((0x0001  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CFG0                           ((0x0002  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CFG1                           ((0x0003  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CFG2                           ((0x0004  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CFG3                           ((0x0005  << 2) + 0xfe028000)
#define ETH_PHY_DBG_CFG4                           ((0x0006  << 2) + 0xfe028000)
#define ETH_PLL_STS                                ((0x0010  << 2) + 0xfe028000)
#define ETH_PLL_CTL0                               ((0x0011  << 2) + 0xfe028000)
#define ETH_PLL_CTL1                               ((0x0012  << 2) + 0xfe028000)
#define ETH_PLL_CTL2                               ((0x0013  << 2) + 0xfe028000)
#define ETH_PLL_CTL3                               ((0x0014  << 2) + 0xfe028000)
#define ETH_PLL_CTL4                               ((0x0015  << 2) + 0xfe028000)
#define ETH_PLL_CTL5                               ((0x0016  << 2) + 0xfe028000)
#define ETH_PLL_CTL6                               ((0x0017  << 2) + 0xfe028000)
#define ETH_PLL_CTL7                               ((0x0018  << 2) + 0xfe028000)
#define ETH_PHY_CNTL0                              ((0x0020  << 2) + 0xfe028000)
#define ETH_PHY_CNTL1                              ((0x0021  << 2) + 0xfe028000)
#define ETH_PHY_CNTL2                              ((0x0022  << 2) + 0xfe028000)
#define ETH_PHY_CNTL3                              ((0x0023  << 2) + 0xfe028000)
#define ETH_PHY_STS0                               ((0x0025  << 2) + 0xfe028000)
#define ETH_PHY_STS1                               ((0x0026  << 2) + 0xfe028000)
#define ETH_PHY_STS2                               ((0x0027  << 2) + 0xfe028000)
#define ETH_PHY_DBG_REG                            ((0x0028  << 2) + 0xfe028000)
//========================================================================
//  Ethernet TOP
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe024000
// -----------------------------------------------
#define ETHTOP_CNTL0                               ((0x0000  << 2) + 0xfe024000)
#define ETHTOP_CNTL1                               ((0x0001  << 2) + 0xfe024000)
//========================================================================
//  I2C Slave A
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe064000
// -----------------------------------------------
#define I2C_S_A_CONTROL_REG                        ((0x0000  << 2) + 0xfe064000)
#define I2C_S_A_SEND_REG                           ((0x0001  << 2) + 0xfe064000)
#define I2C_S_A_RECV_REG                           ((0x0002  << 2) + 0xfe064000)
#define I2C_S_A_CNTL1_REG                          ((0x0003  << 2) + 0xfe064000)
//========================================================================
//  IR RX/TX
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe084000
// -----------------------------------------------
#define IRCTRL_IR_DEC_LDR_ACTIVE                   ((0x0000  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_LDR_IDLE                     ((0x0001  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_LDR_REPEAT                   ((0x0002  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_BIT_0                        ((0x0003  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_REG0                         ((0x0004  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_FRAME                        ((0x0005  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_STATUS                       ((0x0006  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_REG1                         ((0x0007  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_LDR_ACTIVE                ((0x0010  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_LDR_IDLE                  ((0x0011  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_LDR_REPEAT                ((0x0012  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_BIT_0                     ((0x0013  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_REG0                      ((0x0014  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FRAME                     ((0x0015  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_STATUS                    ((0x0016  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_REG1                      ((0x0017  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_REG2                      ((0x0018  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_DURATN2                   ((0x0019  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_DURATN3                   ((0x001a  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FRAME1                    ((0x001b  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_STATUS1                   ((0x001c  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_STATUS2                   ((0x001d  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_REG3                      ((0x001e  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FRAME_RSV0                ((0x001f  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FRAME_RSV1                ((0x0020  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FILTE                     ((0x0021  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_IRQ_CTL                   ((0x0022  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_FIFO_CTL                  ((0x0023  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_WIDTH_NEW                 ((0x0024  << 2) + 0xfe084000)
#define IRCTRL_MF_IR_DEC_REPEAT_DET                ((0x0025  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_CNTL0                  ((0x0030  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_CNTL1                  ((0x0031  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_IIR_THD                ((0x0032  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_THD0                   ((0x0033  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_THD1                   ((0x0034  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_SUM_CNT0               ((0x0035  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_SUM_CNT1               ((0x0036  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_CNT0                   ((0x0037  << 2) + 0xfe084000)
#define IRCTRL_IR_DEC_DEMOD_CNT1                   ((0x0038  << 2) + 0xfe084000)
#define IRCTRL_IR_BLASTER_ADDR0                    ((0x0043  << 2) + 0xfe084000)
#define IRCTRL_IR_BLASTER_ADDR1                    ((0x0044  << 2) + 0xfe084000)
#define IRCTRL_IR_BLASTER_ADDR2                    ((0x0045  << 2) + 0xfe084000)
#define IRCTRL_IR_BLASTER_ADDR3                    ((0x0046  << 2) + 0xfe084000)
//========================================================================
//  I2C Master A
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe066000
// -----------------------------------------------
#define I2C_M_A_CONTROL_REG                        ((0x0000  << 2) + 0xfe066000)
#define I2C_M_A_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe066000)
#define I2C_M_A_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe066000)
#define I2C_M_A_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe066000)
#define I2C_M_A_WDATA_REG0                         ((0x0004  << 2) + 0xfe066000)
#define I2C_M_A_WDATA_REG1                         ((0x0005  << 2) + 0xfe066000)
#define I2C_M_A_RDATA_REG0                         ((0x0006  << 2) + 0xfe066000)
#define I2C_M_A_RDATA_REG1                         ((0x0007  << 2) + 0xfe066000)
#define I2C_M_A_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe066000)
#define I2C_M_A_CNTL_DELY1                         ((0x0009  << 2) + 0xfe066000)
#define I2C_M_A_CNTL_DELY2                         ((0x000a  << 2) + 0xfe066000)
#define I2C_M_A_LOW_DELY                           ((0x000b  << 2) + 0xfe066000)
#define I2C_M_A_HIGH_DELY                          ((0x000c  << 2) + 0xfe066000)
#define I2C_M_A_FIFO_CTRL0                         ((0x000d  << 2) + 0xfe066000)
#define I2C_M_A_FIFO_CTRL1                         ((0x000e  << 2) + 0xfe066000)
#define I2C_M_A_FIFO_PENDING                       ((0x000f  << 2) + 0xfe066000)
#define I2C_M_A_FIFO_PENDING_MASK                  ((0x0010  << 2) + 0xfe066000)
#define I2C_M_A_FIFO_ST0                           ((0x0011  << 2) + 0xfe066000)
//========================================================================
//  I2C Master B
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe068000
// -----------------------------------------------
#define I2C_M_B_CONTROL_REG                        ((0x0000  << 2) + 0xfe068000)
#define I2C_M_B_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe068000)
#define I2C_M_B_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe068000)
#define I2C_M_B_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe068000)
#define I2C_M_B_WDATA_REG0                         ((0x0004  << 2) + 0xfe068000)
#define I2C_M_B_WDATA_REG1                         ((0x0005  << 2) + 0xfe068000)
#define I2C_M_B_RDATA_REG0                         ((0x0006  << 2) + 0xfe068000)
#define I2C_M_B_RDATA_REG1                         ((0x0007  << 2) + 0xfe068000)
#define I2C_M_B_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe068000)
#define I2C_M_B_CNTL_DELY1                         ((0x0009  << 2) + 0xfe068000)
#define I2C_M_B_CNTL_DELY2                         ((0x000a  << 2) + 0xfe068000)
#define I2C_M_B_LOW_DELY                           ((0x000b  << 2) + 0xfe068000)
#define I2C_M_B_HIGH_DELY                          ((0x000c  << 2) + 0xfe068000)
#define I2C_M_B_FIFO_CTRL0                         ((0x000d  << 2) + 0xfe068000)
#define I2C_M_B_FIFO_CTRL1                         ((0x000e  << 2) + 0xfe068000)
#define I2C_M_B_FIFO_PENDING                       ((0x000f  << 2) + 0xfe068000)
#define I2C_M_B_FIFO_PENDING_MASK                  ((0x0010  << 2) + 0xfe068000)
#define I2C_M_B_FIFO_ST0                           ((0x0011  << 2) + 0xfe068000)
//========================================================================
//  I2C Master C
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe06a000
// -----------------------------------------------
#define I2C_M_C_CONTROL_REG                        ((0x0000  << 2) + 0xfe06a000)
#define I2C_M_C_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe06a000)
#define I2C_M_C_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe06a000)
#define I2C_M_C_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe06a000)
#define I2C_M_C_WDATA_REG0                         ((0x0004  << 2) + 0xfe06a000)
#define I2C_M_C_WDATA_REG1                         ((0x0005  << 2) + 0xfe06a000)
#define I2C_M_C_RDATA_REG0                         ((0x0006  << 2) + 0xfe06a000)
#define I2C_M_C_RDATA_REG1                         ((0x0007  << 2) + 0xfe06a000)
#define I2C_M_C_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe06a000)
#define I2C_M_C_CNTL_DELY1                         ((0x0009  << 2) + 0xfe06a000)
#define I2C_M_C_CNTL_DELY2                         ((0x000a  << 2) + 0xfe06a000)
#define I2C_M_C_LOW_DELY                           ((0x000b  << 2) + 0xfe06a000)
#define I2C_M_C_HIGH_DELY                          ((0x000c  << 2) + 0xfe06a000)
#define I2C_M_C_FIFO_CTRL0                         ((0x000d  << 2) + 0xfe06a000)
#define I2C_M_C_FIFO_CTRL1                         ((0x000e  << 2) + 0xfe06a000)
#define I2C_M_C_FIFO_PENDING                       ((0x000f  << 2) + 0xfe06a000)
#define I2C_M_C_FIFO_PENDING_MASK                  ((0x0010  << 2) + 0xfe06a000)
#define I2C_M_C_FIFO_ST0                           ((0x0011  << 2) + 0xfe06a000)
//========================================================================
//  I2C Master D
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe06c000
// -----------------------------------------------
#define I2C_M_D_CONTROL_REG                        ((0x0000  << 2) + 0xfe06c000)
#define I2C_M_D_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe06c000)
#define I2C_M_D_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe06c000)
#define I2C_M_D_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe06c000)
#define I2C_M_D_WDATA_REG0                         ((0x0004  << 2) + 0xfe06c000)
#define I2C_M_D_WDATA_REG1                         ((0x0005  << 2) + 0xfe06c000)
#define I2C_M_D_RDATA_REG0                         ((0x0006  << 2) + 0xfe06c000)
#define I2C_M_D_RDATA_REG1                         ((0x0007  << 2) + 0xfe06c000)
#define I2C_M_D_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe06c000)
#define I2C_M_D_CNTL_DELY1                         ((0x0009  << 2) + 0xfe06c000)
#define I2C_M_D_CNTL_DELY2                         ((0x000a  << 2) + 0xfe06c000)
#define I2C_M_D_LOW_DELY                           ((0x000b  << 2) + 0xfe06c000)
#define I2C_M_D_HIGH_DELY                          ((0x000c  << 2) + 0xfe06c000)
#define I2C_M_D_FIFO_CTRL0                         ((0x000d  << 2) + 0xfe06c000)
#define I2C_M_D_FIFO_CTRL1                         ((0x000e  << 2) + 0xfe06c000)
#define I2C_M_D_FIFO_PENDING                       ((0x000f  << 2) + 0xfe06c000)
#define I2C_M_D_FIFO_PENDING_MASK                  ((0x0010  << 2) + 0xfe06c000)
#define I2C_M_D_FIFO_ST0                           ((0x0011  << 2) + 0xfe06c000)
//========================================================================
//  I2C Master E
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe06e000
// -----------------------------------------------
#define I2C_M_E_CONTROL_REG                        ((0x0000  << 2) + 0xfe06e000)
#define I2C_M_E_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe06e000)
#define I2C_M_E_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe06e000)
#define I2C_M_E_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe06e000)
#define I2C_M_E_WDATA_REG0                         ((0x0004  << 2) + 0xfe06e000)
#define I2C_M_E_WDATA_REG1                         ((0x0005  << 2) + 0xfe06e000)
#define I2C_M_E_RDATA_REG0                         ((0x0006  << 2) + 0xfe06e000)
#define I2C_M_E_RDATA_REG1                         ((0x0007  << 2) + 0xfe06e000)
#define I2C_M_E_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe06e000)
#define I2C_M_E_CNTL_DELY1                         ((0x0009  << 2) + 0xfe06e000)
#define I2C_M_E_CNTL_DELY2                         ((0x000a  << 2) + 0xfe06e000)
#define I2C_M_E_LOW_DELY                           ((0x000b  << 2) + 0xfe06e000)
#define I2C_M_E_HIGH_DELY                          ((0x000c  << 2) + 0xfe06e000)
#define I2C_M_E_FIFO_CTRL0                         ((0x000d  << 2) + 0xfe06e000)
#define I2C_M_E_FIFO_CTRL1                         ((0x000e  << 2) + 0xfe06e000)
#define I2C_M_E_FIFO_PENDING                       ((0x000f  << 2) + 0xfe06e000)
#define I2C_M_E_FIFO_PENDING_MASK                  ((0x0010  << 2) + 0xfe06e000)
#define I2C_M_E_FIFO_ST0                           ((0x0011  << 2) + 0xfe06e000)
//========================================================================
//  I2C Master F
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe070000
// -----------------------------------------------
#define I2C_M_F_CONTROL_REG                        ((0x0000  << 2) + 0xfe070000)
#define I2C_M_F_SLAVE_ADDR                         ((0x0001  << 2) + 0xfe070000)
#define I2C_M_F_TOKEN_LIST0                        ((0x0002  << 2) + 0xfe070000)
#define I2C_M_F_TOKEN_LIST1                        ((0x0003  << 2) + 0xfe070000)
#define I2C_M_F_WDATA_REG0                         ((0x0004  << 2) + 0xfe070000)
#define I2C_M_F_WDATA_REG1                         ((0x0005  << 2) + 0xfe070000)
#define I2C_M_F_RDATA_REG0                         ((0x0006  << 2) + 0xfe070000)
#define I2C_M_F_RDATA_REG1                         ((0x0007  << 2) + 0xfe070000)
#define I2C_M_F_TIMEOUT_TH                         ((0x0008  << 2) + 0xfe070000)
#define I2C_M_F_CNTL_DELY1                         ((0x0009  << 2) + 0xfe070000)
#define I2C_M_F_CNTL_DELY2                         ((0x000a  << 2) + 0xfe070000)
#define I2C_M_F_LOW_DELY                           ((0x000b  << 2) + 0xfe070000)
#define I2C_M_F_HIGH_DELY                          ((0x000c  << 2) + 0xfe070000)
#define I2C_M_F_FIFO_CTRL_REG                      ((0x000d  << 2) + 0xfe070000)
#define I2C_M_F_STATE_REG                          ((0x000e  << 2) + 0xfe070000)
//========================================================================
//  APB0_UART_A - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe078000
// -----------------------------------------------
#define UART_A_WFIFO                               ((0x0000  << 2) + 0xfe078000)
#define UART_A_RFIFO                               ((0x0001  << 2) + 0xfe078000)
#define UART_A_CONTROL                             ((0x0002  << 2) + 0xfe078000)
#define UART_A_STATUS                              ((0x0003  << 2) + 0xfe078000)
#define UART_A_MISC                                ((0x0004  << 2) + 0xfe078000)
#define UART_A_REG5                                ((0x0005  << 2) + 0xfe078000)
//========================================================================
//  APB0_UART_B - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe07a000
// -----------------------------------------------
#define UART_B_WFIFO                               ((0x0000  << 2) + 0xfe07a000)
#define UART_B_RFIFO                               ((0x0001  << 2) + 0xfe07a000)
#define UART_B_CONTROL                             ((0x0002  << 2) + 0xfe07a000)
#define UART_B_STATUS                              ((0x0003  << 2) + 0xfe07a000)
#define UART_B_MISC                                ((0x0004  << 2) + 0xfe07a000)
#define UART_B_REG5                                ((0x0005  << 2) + 0xfe07a000)
//========================================================================
//  APB0_UART_C - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe07c000
// -----------------------------------------------
#define UART_C_WFIFO                               ((0x0000  << 2) + 0xfe07c000)
#define UART_C_RFIFO                               ((0x0001  << 2) + 0xfe07c000)
#define UART_C_CONTROL                             ((0x0002  << 2) + 0xfe07c000)
#define UART_C_STATUS                              ((0x0003  << 2) + 0xfe07c000)
#define UART_C_MISC                                ((0x0004  << 2) + 0xfe07c000)
#define UART_C_REG5                                ((0x0005  << 2) + 0xfe07c000)
//========================================================================
//  APB0_UART_D - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe07e000
// -----------------------------------------------
#define UART_D_WFIFO                               ((0x0000  << 2) + 0xfe07e000)
#define UART_D_RFIFO                               ((0x0001  << 2) + 0xfe07e000)
#define UART_D_CONTROL                             ((0x0002  << 2) + 0xfe07e000)
#define UART_D_STATUS                              ((0x0003  << 2) + 0xfe07e000)
#define UART_D_MISC                                ((0x0004  << 2) + 0xfe07e000)
#define UART_D_REG5                                ((0x0005  << 2) + 0xfe07e000)
//========================================================================
//  APB0_UART_E - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe080000
// -----------------------------------------------
#define UART_E_WFIFO                               ((0x0000  << 2) + 0xfe080000)
#define UART_E_RFIFO                               ((0x0001  << 2) + 0xfe080000)
#define UART_E_CONTROL                             ((0x0002  << 2) + 0xfe080000)
#define UART_E_STATUS                              ((0x0003  << 2) + 0xfe080000)
#define UART_E_MISC                                ((0x0004  << 2) + 0xfe080000)
#define UART_E_REG5                                ((0x0005  << 2) + 0xfe080000)
//========================================================================
//  PWM_AB - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe058000
// -----------------------------------------------
#define PWMAB_PWM_A                                ((0x0000  << 2) + 0xfe058000)
#define PWMAB_PWM_B                                ((0x0001  << 2) + 0xfe058000)
#define PWMAB_MISC_REG_AB                          ((0x0002  << 2) + 0xfe058000)
#define PWMAB_DELTA_SIGMA_AB                       ((0x0003  << 2) + 0xfe058000)
#define PWMAB_TIME_AB                              ((0x0004  << 2) + 0xfe058000)
#define PWMAB_A2                                   ((0x0005  << 2) + 0xfe058000)
#define PWMAB_B2                                   ((0x0006  << 2) + 0xfe058000)
#define PWMAB_BLINK_AB                             ((0x0007  << 2) + 0xfe058000)
#define PWMAB_LOCK_AB                              ((0x0008  << 2) + 0xfe058000)
//========================================================================
//  PWM_CD - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe05a000
// -----------------------------------------------
#define PWMCD_PWM_A                                ((0x0000  << 2) + 0xfe05a000)
#define PWMCD_PWM_B                                ((0x0001  << 2) + 0xfe05a000)
#define PWMCD_MISC_REG_AB                          ((0x0002  << 2) + 0xfe05a000)
#define PWMCD_DELTA_SIGMA_AB                       ((0x0003  << 2) + 0xfe05a000)
#define PWMCD_TIME_AB                              ((0x0004  << 2) + 0xfe05a000)
#define PWMCD_A2                                   ((0x0005  << 2) + 0xfe05a000)
#define PWMCD_B2                                   ((0x0006  << 2) + 0xfe05a000)
#define PWMCD_BLINK_AB                             ((0x0007  << 2) + 0xfe05a000)
#define PWMCD_LOCK_AB                              ((0x0008  << 2) + 0xfe05a000)
//========================================================================
//  PWM_EF - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe05c000
// -----------------------------------------------
#define PWMEF_PWM_A                                ((0x0000  << 2) + 0xfe05c000)
#define PWMEF_PWM_B                                ((0x0001  << 2) + 0xfe05c000)
#define PWMEF_MISC_REG_AB                          ((0x0002  << 2) + 0xfe05c000)
#define PWMEF_DELTA_SIGMA_AB                       ((0x0003  << 2) + 0xfe05c000)
#define PWMEF_TIME_AB                              ((0x0004  << 2) + 0xfe05c000)
#define PWMEF_A2                                   ((0x0005  << 2) + 0xfe05c000)
#define PWMEF_B2                                   ((0x0006  << 2) + 0xfe05c000)
#define PWMEF_BLINK_AB                             ((0x0007  << 2) + 0xfe05c000)
#define PWMEF_LOCK_AB                              ((0x0008  << 2) + 0xfe05c000)
//========================================================================
//  PWM_GH - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe05e000
// -----------------------------------------------
#define PWMGH_PWM_A                                ((0x0000  << 2) + 0xfe05e000)
#define PWMGH_PWM_B                                ((0x0001  << 2) + 0xfe05e000)
#define PWMGH_MISC_REG_AB                          ((0x0002  << 2) + 0xfe05e000)
#define PWMGH_DELTA_SIGMA_AB                       ((0x0003  << 2) + 0xfe05e000)
#define PWMGH_TIME_AB                              ((0x0004  << 2) + 0xfe05e000)
#define PWMGH_A2                                   ((0x0005  << 2) + 0xfe05e000)
#define PWMGH_B2                                   ((0x0006  << 2) + 0xfe05e000)
#define PWMGH_BLINK_AB                             ((0x0007  << 2) + 0xfe05e000)
#define PWMGH_LOCK_AB                              ((0x0008  << 2) + 0xfe05e000)
//========================================================================
//  PWM_IJ - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe060000
// -----------------------------------------------
#define PWMIJ_PWM_A                                ((0x0000  << 2) + 0xfe060000)
#define PWMIJ_PWM_B                                ((0x0001  << 2) + 0xfe060000)
#define PWMIJ_MISC_REG_AB                          ((0x0002  << 2) + 0xfe060000)
#define PWMIJ_DELTA_SIGMA_AB                       ((0x0003  << 2) + 0xfe060000)
#define PWMIJ_TIME_AB                              ((0x0004  << 2) + 0xfe060000)
#define PWMIJ_A2                                   ((0x0005  << 2) + 0xfe060000)
#define PWMIJ_B2                                   ((0x0006  << 2) + 0xfe060000)
#define PWMIJ_BLINK_AB                             ((0x0007  << 2) + 0xfe060000)
#define PWMIJ_LOCK_AB                              ((0x0008  << 2) + 0xfe060000)
//========================================================================
//  SPICC_0
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe050000
// -----------------------------------------------
#define SPICC0_RXDATA                              ((0x0000  << 2) + 0xfe050000)
#define SPICC0_TXDATA                              ((0x0001  << 2) + 0xfe050000)
#define SPICC0_CONREG                              ((0x0002  << 2) + 0xfe050000)
#define SPICC0_INTREG                              ((0x0003  << 2) + 0xfe050000)
#define SPICC0_DMAREG                              ((0x0004  << 2) + 0xfe050000)
#define SPICC0_STATREG                             ((0x0005  << 2) + 0xfe050000)
#define SPICC0_PERIODREG                           ((0x0006  << 2) + 0xfe050000)
#define SPICC0_TESTREG                             ((0x0007  << 2) + 0xfe050000)
#define SPICC0_DRADDR                              ((0x0008  << 2) + 0xfe050000)
#define SPICC0_DWADDR                              ((0x0009  << 2) + 0xfe050000)
#define SPICC0_LD_CNTL0                            ((0x000a  << 2) + 0xfe050000)
#define SPICC0_LD_CNTL1                            ((0x000b  << 2) + 0xfe050000)
#define SPICC0_LD_RADDR                            ((0x000c  << 2) + 0xfe050000)
#define SPICC0_LD_WADDR                            ((0x000d  << 2) + 0xfe050000)
#define SPICC0_ENHANCE_CNTL                        ((0x000e  << 2) + 0xfe050000)
#define SPICC0_ENHANCE_CNTL1                       ((0x000f  << 2) + 0xfe050000)
#define SPICC0_ENHANCE_CNTL2                       ((0x0010  << 2) + 0xfe050000)
//========================================================================
//  SPICC_1
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe052000
// -----------------------------------------------
#define SPICC1_RXDATA                              ((0x0000  << 2) + 0xfe052000)
#define SPICC1_TXDATA                              ((0x0001  << 2) + 0xfe052000)
#define SPICC1_CONREG                              ((0x0002  << 2) + 0xfe052000)
#define SPICC1_INTREG                              ((0x0003  << 2) + 0xfe052000)
#define SPICC1_DMAREG                              ((0x0004  << 2) + 0xfe052000)
#define SPICC1_STATREG                             ((0x0005  << 2) + 0xfe052000)
#define SPICC1_PERIODREG                           ((0x0006  << 2) + 0xfe052000)
#define SPICC1_TESTREG                             ((0x0007  << 2) + 0xfe052000)
#define SPICC1_DRADDR                              ((0x0008  << 2) + 0xfe052000)
#define SPICC1_DWADDR                              ((0x0009  << 2) + 0xfe052000)
#define SPICC1_LD_CNTL0                            ((0x000a  << 2) + 0xfe052000)
#define SPICC1_LD_CNTL1                            ((0x000b  << 2) + 0xfe052000)
#define SPICC1_LD_RADDR                            ((0x000c  << 2) + 0xfe052000)
#define SPICC1_LD_WADDR                            ((0x000d  << 2) + 0xfe052000)
#define SPICC1_ENHANCE_CNTL                        ((0x000e  << 2) + 0xfe052000)
#define SPICC1_ENHANCE_CNTL1                       ((0x000f  << 2) + 0xfe052000)
#define SPICC1_ENHANCE_CNTL2                       ((0x0010  << 2) + 0xfe052000)
//========================================================================
//  AIFIFO - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe046000
// -----------------------------------------------
#define AIU_AIFIFO_CTRL                            ((0x0000  << 2) + 0xfe046000)
#define AIU_AIFIFO_STATUS                          ((0x0001  << 2) + 0xfe046000)
#define AIU_AIFIFO_GBIT                            ((0x0002  << 2) + 0xfe046000)
#define AIU_AIFIFO_CLB                             ((0x0003  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_START_PTR                   ((0x0004  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_CURR_PTR                    ((0x0005  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_END_PTR                     ((0x0006  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_BYTES_AVAIL                 ((0x0007  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_CONTROL                     ((0x0008  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_MAN_WP                      ((0x0009  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_MAN_RP                      ((0x000a  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_LEVEL                       ((0x000b  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_BUF_CNTL                    ((0x000c  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_BUF_WRAP_COUNT              ((0x000d  << 2) + 0xfe046000)
#define AIU_MEM_AIFIFO_MEM_CTL                     ((0x000f  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_CNTL                     ((0x0010  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_SYNC_0                   ((0x0011  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_SYNC_1                   ((0x0012  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_0                        ((0x0013  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_1                        ((0x0014  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_2                        ((0x0015  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_3                        ((0x0016  << 2) + 0xfe046000)
#define AIFIFO_TIME_STAMP_LENGTH                   ((0x0017  << 2) + 0xfe046000)
//========================================================================
//  MSR_CLK - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe048000
// -----------------------------------------------
#define MSR_CLK_REG0                               ((0x0000  << 2) + 0xfe048000)
#define MSR_CLK_REG1                               ((0x0001  << 2) + 0xfe048000)
#define MSR_CLK_REG2                               ((0x0002  << 2) + 0xfe048000)
#define MSR_CLK_REG3                               ((0x0003  << 2) + 0xfe048000)
#define MSR_CLK_REG4                               ((0x0004  << 2) + 0xfe048000)
#define MSR_CLK_REG5                               ((0x0005  << 2) + 0xfe048000)
#define MSR_CLK_DUTY                               ((0x0006  << 2) + 0xfe048000)
//========================================================================
//  SPIFC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe056000
// -----------------------------------------------
#define SPI_FLASH_CMD                              ((0x0000  << 2) + 0xfe056000)
    // SPI_FLASH_READ    31
    // SPI_FLASH_WREN    30
    // SPI_FLASH_WRDI    29
    // SPI_FLASH_RDID    28
    // SPI_FLASH_RDSR    27
    // SPI_FLASH_WRSR    26
    // SPI_FLASH_PP      25
    // SPI_FLASH_SE      24
    // SPI_FLASH_BE      23
    // SPI_FLASH_CE      22
    // SPI_FLASH_DP      21
    // SPI_FLASH_RES     20
    // SPI_HPM           19
    // SPI_FLASH_USR     18
    // SPI_FLASH_USR_ADDR 15
    // SPI_FLASH_USR_DUMMY 14
    // SPI_FLASH_USR_DIN   13
    // SPI_FLASH_USR_DOUT   12
    // SPI_FLASH_USR_DUMMY_BLEN   10
    // SPI_FLASH_USR_CMD     0
#define SPI_FLASH_ADDR                             ((0x0001  << 2) + 0xfe056000)
    // SPI_FLASH_BYTES_LEN 24
    // SPI_FLASH_ADDR_START 0
#define SPI_FLASH_CTRL                             ((0x0002  << 2) + 0xfe056000)
    // SPI_ENABLE_AHB    17
    // SPI_SST_AAI       16
    // SPI_RES_RID       15
    // SPI_FREAD_DUAL    14
    // SPI_READ_READ_EN  13
    // SPI_CLK_DIV0      12
    // SPI_CLKCNT_N      8
    // SPI_CLKCNT_H      4
    // SPI_CLKCNT_L      0
#define SPI_FLASH_CTRL1                            ((0x0003  << 2) + 0xfe056000)
#define SPI_FLASH_STATUS                           ((0x0004  << 2) + 0xfe056000)
#define SPI_FLASH_CTRL2                            ((0x0005  << 2) + 0xfe056000)
#define SPI_FLASH_CLOCK                            ((0x0006  << 2) + 0xfe056000)
#define SPI_FLASH_USER                             ((0x0007  << 2) + 0xfe056000)
#define SPI_FLASH_USER1                            ((0x0008  << 2) + 0xfe056000)
#define SPI_FLASH_USER2                            ((0x0009  << 2) + 0xfe056000)
#define SPI_FLASH_USER3                            ((0x000a  << 2) + 0xfe056000)
#define SPI_FLASH_USER4                            ((0x000b  << 2) + 0xfe056000)
#define SPI_FLASH_SLAVE                            ((0x000c  << 2) + 0xfe056000)
#define SPI_FLASH_SLAVE1                           ((0x000d  << 2) + 0xfe056000)
#define SPI_FLASH_SLAVE2                           ((0x000e  << 2) + 0xfe056000)
#define SPI_FLASH_SLAVE3                           ((0x000f  << 2) + 0xfe056000)
#define SPI_FLASH_C0                               ((0x0010  << 2) + 0xfe056000)
#define SPI_FLASH_C1                               ((0x0011  << 2) + 0xfe056000)
#define SPI_FLASH_C2                               ((0x0012  << 2) + 0xfe056000)
#define SPI_FLASH_C3                               ((0x0013  << 2) + 0xfe056000)
#define SPI_FLASH_C4                               ((0x0014  << 2) + 0xfe056000)
#define SPI_FLASH_C5                               ((0x0015  << 2) + 0xfe056000)
#define SPI_FLASH_C6                               ((0x0016  << 2) + 0xfe056000)
#define SPI_FLASH_C7                               ((0x0017  << 2) + 0xfe056000)
#define SPI_FLASH_B8                               ((0x0018  << 2) + 0xfe056000)
#define SPI_FLASH_B9                               ((0x0019  << 2) + 0xfe056000)
#define SPI_FLASH_B10                              ((0x001a  << 2) + 0xfe056000)
#define SPI_FLASH_B11                              ((0x001b  << 2) + 0xfe056000)
#define SPI_FLASH_B12                              ((0x001c  << 2) + 0xfe056000)
#define SPI_FLASH_B13                              ((0x001d  << 2) + 0xfe056000)
#define SPI_FLASH_B14                              ((0x001e  << 2) + 0xfe056000)
#define SPI_FLASH_B15                              ((0x001f  << 2) + 0xfe056000)
//========================================================================
//  CEC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe044000
// -----------------------------------------------
#define CECA_GEN_CNTL                              ((0x0000  << 2) + 0xfe044000)
#define CECA_RW_REG                                ((0x0001  << 2) + 0xfe044000)
#define CECA_INTR_MASKN                            ((0x0002  << 2) + 0xfe044000)
#define CECA_INTR_CLR                              ((0x0003  << 2) + 0xfe044000)
#define CECA_INTR_STAT                             ((0x0004  << 2) + 0xfe044000)
#define CECB_GEN_CNTL                              ((0x0010  << 2) + 0xfe044000)
#define CECB_RW_REG                                ((0x0011  << 2) + 0xfe044000)
#define CECB_INTR_MASKN                            ((0x0012  << 2) + 0xfe044000)
#define CECB_INTR_CLR                              ((0x0013  << 2) + 0xfe044000)
#define CECB_INTR_STAT                             ((0x0014  << 2) + 0xfe044000)
//========================================================================
//  SMART CARD - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe038000
// -----------------------------------------------
#define SMARTCARD_REG0                             ((0x0000  << 2) + 0xfe038000)
#define SMARTCARD_REG1                             ((0x0001  << 2) + 0xfe038000)
#define SMARTCARD_REG2                             ((0x0002  << 2) + 0xfe038000)
#define SMARTCARD_STATUS                           ((0x0003  << 2) + 0xfe038000)
#define SMARTCARD_INTR                             ((0x0004  << 2) + 0xfe038000)
#define SMARTCARD_REG5                             ((0x0005  << 2) + 0xfe038000)
#define SMARTCARD_REG6                             ((0x0006  << 2) + 0xfe038000)
#define SMARTCARD_FIFO                             ((0x0007  << 2) + 0xfe038000)
#define SMARTCARD_REG8                             ((0x0008  << 2) + 0xfe038000)
//========================================================================
//  CAPU
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe012000
// -----------------------------------------------
#define CAPU_ACCESS_EN_AHB_ETH                     ((0x00c2  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_AHB_USB0                    ((0x00c1  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_AHB_USB1                    ((0x00c0  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_16M_SLOT0                   ((0x00b0  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_256K_SLOT1                  ((0x00a1  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_256K_SLOT0                  ((0x00a0  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT5                   ((0x0085  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT4                   ((0x0084  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT3                   ((0x0083  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT2                   ((0x0082  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT1                   ((0x0081  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_64K_SLOT0                   ((0x0080  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4F                   ((0x004f  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4E                   ((0x004e  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4D                   ((0x004d  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4C                   ((0x004c  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4B                   ((0x004b  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT4A                   ((0x004a  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT49                   ((0x0049  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT48                   ((0x0048  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT47                   ((0x0047  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT46                   ((0x0046  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT45                   ((0x0045  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT44                   ((0x0044  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT43                   ((0x0043  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT42                   ((0x0042  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT41                   ((0x0041  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT40                   ((0x0040  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3F                   ((0x003f  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3E                   ((0x003e  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3D                   ((0x003d  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3C                   ((0x003c  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3B                   ((0x003b  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT3A                   ((0x003a  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT39                   ((0x0039  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT38                   ((0x0038  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT37                   ((0x0037  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT36                   ((0x0036  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT35                   ((0x0035  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT34                   ((0x0034  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT33                   ((0x0033  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT32                   ((0x0032  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT31                   ((0x0031  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT30                   ((0x0030  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2F                   ((0x002f  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2E                   ((0x002e  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2D                   ((0x002d  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2C                   ((0x002c  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2B                   ((0x002b  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT2A                   ((0x002a  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT29                   ((0x0029  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT28                   ((0x0028  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT27                   ((0x0027  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT26                   ((0x0026  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT25                   ((0x0025  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT24                   ((0x0024  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT23                   ((0x0023  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT22                   ((0x0022  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT21                   ((0x0021  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT20                   ((0x0020  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1F                   ((0x001f  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1E                   ((0x001e  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1D                   ((0x001d  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1C                   ((0x001c  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1B                   ((0x001b  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT1A                   ((0x001a  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT19                   ((0x0019  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT18                   ((0x0018  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT17                   ((0x0017  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT16                   ((0x0016  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT15                   ((0x0015  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT14                   ((0x0014  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT13                   ((0x0013  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT12                   ((0x0012  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT11                   ((0x0011  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT10                   ((0x0010  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0F                   ((0x000f  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0E                   ((0x000e  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0D                   ((0x000d  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0C                   ((0x000c  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0B                   ((0x000b  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT0A                   ((0x000a  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT09                   ((0x0009  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT08                   ((0x0008  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT07                   ((0x0007  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT06                   ((0x0006  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT05                   ((0x0005  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT04                   ((0x0004  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT03                   ((0x0003  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT02                   ((0x0002  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT01                   ((0x0001  << 2) + 0xfe012000)
#define CAPU_ACCESS_EN_8K_SLOT00                   ((0x0000  << 2) + 0xfe012000)
//========================================================================
//  BT656
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe030000
// -----------------------------------------------
#define BT_CTRL                                    ((0x0000  << 2) + 0xfe030000)
    #define BT_SOFT_RESET           31      // Soft reset
    #define BT_JPEG_START           30
    #define BT_JPEG_IGNORE_BYTES    18     //20:18
    #define BT_JPEG_IGNORE_LAST     17
    #define BT_UPDATE_ST_SEL        16
    #define BT_COLOR_REPEAT         15
    #define BT_VIDEO_MODE           13     // 14:13
    #define BT_AUTO_FMT             12
    #define BT_PROG_MODE            11
    #define BT_JPEG_MODE            10
    #define BT_XCLK27_EN_BIT        9      // 1 : xclk27 is input.     0 : xclk27 is output.
    #define BT_FID_EN_BIT           8       // 1 : enable use FID port.
    #define BT_CLK27_SEL_BIT        7       // 1 : external xclk27      0 : internal clk27.
    #define BT_CLK27_PHASE_BIT      6       // 1 : no inverted          0 : inverted.
    #define BT_ACE_MODE_BIT         5       // 1 : auto cover error by hardware.
    #define BT_SLICE_MODE_BIT       4       // 1 : no ancillary flag     0 : with ancillary flag.
    #define BT_FMT_MODE_BIT         3       // 1 : ntsc                 0 : pal.
    #define BT_REF_MODE_BIT         2       // 1 : from bit stream.     0 : from ports.
    #define BT_MODE_BIT             1       // 1 : BT656 model          0 : SAA7118 mode.
    #define BT_EN_BIT               0       // 1 : enable.
#define BT_VBISTART                                ((0x0001  << 2) + 0xfe030000)
#define BT_VBIEND                                  ((0x0002  << 2) + 0xfe030000)
#define BT_FIELDSADR                               ((0x0003  << 2) + 0xfe030000)
#define BT_LINECTRL                                ((0x0004  << 2) + 0xfe030000)
#define BT_VIDEOSTART                              ((0x0005  << 2) + 0xfe030000)
#define BT_VIDEOEND                                ((0x0006  << 2) + 0xfe030000)
#define BT_SLICELINE0                              ((0x0007  << 2) + 0xfe030000)
#define BT_SLICELINE1                              ((0x0008  << 2) + 0xfe030000)
#define BT_PORT_CTRL                               ((0x0009  << 2) + 0xfe030000)
  #define BT_HSYNC_PHASE           0
  #define BT_VSYNC_PHASE           1
  #define BT_HSYNC_PULSE           2
  #define BT_VSYNC_PULSE           3
  #define BT_FID_PHASE             4
  #define BT_FID_HSVS              5
  #define BT_IDQ_EN                6
  #define BT_IDQ_PHASE             7
  #define BT_D8B                   8
  #define BT_10BTO8B               9
  #define BT_FID_DELAY            10    //12:10
  #define BT_VSYNC_DELAY          13    //
  #define BT_HSYNC_DELAY          16
  #define BT_FID_HSVS_PCNT        19
  #define BT_FID_HSVS_VS_RISING   20
  #define BT_FID_HSVS_VS_FALLING  21
  #define BT_VREF_FROM_VS_ONLY    22
  #define BT_PORT_ACTIVE_HMODE    23
  #define BT_DUAL_EDGE_CLK_EN     24
  #define BT_CLK_INV_SEL          25
  #define BT_DATA_ENDIAN          26
#define BT_SWAP_CTRL                               ((0x000a  << 2) + 0xfe030000)
#define BT_601_CTRL0                               ((0x000e  << 2) + 0xfe030000)
#define BT_601_CTRL1                               ((0x000f  << 2) + 0xfe030000)
#define BT_601_CTRL2                               ((0x0010  << 2) + 0xfe030000)
#define BT_601_CTRL3                               ((0x0011  << 2) + 0xfe030000)
#define BT_FIELD_LUMA                              ((0x0012  << 2) + 0xfe030000)
#define BT_RAW_CTRL                                ((0x0013  << 2) + 0xfe030000)
#define BT_STATUS                                  ((0x0014  << 2) + 0xfe030000)
#define BT_INT_CTRL                                ((0x0015  << 2) + 0xfe030000)
#define BT_VLINE_STATUS                            ((0x0017  << 2) + 0xfe030000)
#define BT_ERR_CNT                                 ((0x0019  << 2) + 0xfe030000)
#define BT_LCNT_STATUS                             ((0x001a  << 2) + 0xfe030000)
#define BT_PCNT_STATUS                             ((0x001c  << 2) + 0xfe030000)
#define BT_DELAY_CTRL                              ((0x001d  << 2) + 0xfe030000)
#define BT_REF_000                                 ((0x0020  << 2) + 0xfe030000)
#define BT_REF_001                                 ((0x0021  << 2) + 0xfe030000)
#define BT_REF_010                                 ((0x0022  << 2) + 0xfe030000)
#define BT_REF_011                                 ((0x0023  << 2) + 0xfe030000)
#define BT_REF_100                                 ((0x0024  << 2) + 0xfe030000)
#define BT_REF_101                                 ((0x0025  << 2) + 0xfe030000)
#define BT_REF_110                                 ((0x0026  << 2) + 0xfe030000)
#define BT_REF_111                                 ((0x0027  << 2) + 0xfe030000)
//========================================================================
//  PDM
//========================================================================
//`include "../audio/rtl/pdm_reg.vh"
//
// Reading file:  REG_LIST_AUDIO_RTL.h
//
//========================================================================
//  AUDIO - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe330000
// -----------------------------------------------
#define EE_AUDIO_CLK_GATE_EN0                      ((0x0000  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_GATE_EN1                      ((0x0001  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_A_CTRL                       ((0x0002  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_B_CTRL                       ((0x0003  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_C_CTRL                       ((0x0004  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_D_CTRL                       ((0x0005  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_E_CTRL                       ((0x0006  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_F_CTRL                       ((0x0007  << 2) + 0xfe330000)
#define EE_AUDIO_SW_RESET0                         ((0x000a  << 2) + 0xfe330000)
#define EE_AUDIO_SW_RESET1                         ((0x000b  << 2) + 0xfe330000)
#define EE_AUDIO_CLK81_CTRL                        ((0x000c  << 2) + 0xfe330000)
#define EE_AUDIO_CLK81_EN                          ((0x000d  << 2) + 0xfe330000)
#define EE_AUDIO_MST_A_SCLK_CTRL0                  ((0x0010  << 2) + 0xfe330000)
#define EE_AUDIO_MST_A_SCLK_CTRL1                  ((0x0011  << 2) + 0xfe330000)
#define EE_AUDIO_MST_B_SCLK_CTRL0                  ((0x0012  << 2) + 0xfe330000)
#define EE_AUDIO_MST_B_SCLK_CTRL1                  ((0x0013  << 2) + 0xfe330000)
#define EE_AUDIO_MST_C_SCLK_CTRL0                  ((0x0014  << 2) + 0xfe330000)
#define EE_AUDIO_MST_C_SCLK_CTRL1                  ((0x0015  << 2) + 0xfe330000)
#define EE_AUDIO_MST_D_SCLK_CTRL0                  ((0x0016  << 2) + 0xfe330000)
#define EE_AUDIO_MST_D_SCLK_CTRL1                  ((0x0017  << 2) + 0xfe330000)
#define EE_AUDIO_MST_E_SCLK_CTRL0                  ((0x0018  << 2) + 0xfe330000)
#define EE_AUDIO_MST_E_SCLK_CTRL1                  ((0x0019  << 2) + 0xfe330000)
#define EE_AUDIO_MST_F_SCLK_CTRL0                  ((0x001a  << 2) + 0xfe330000)
#define EE_AUDIO_MST_F_SCLK_CTRL1                  ((0x001b  << 2) + 0xfe330000)
#define EE_AUDIO_MST_DLY_CTRL0                     ((0x001c  << 2) + 0xfe330000)
#define EE_AUDIO_MST_DLY_CTRL1                     ((0x001d  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMIN_A_CTRL                  ((0x0020  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMIN_B_CTRL                  ((0x0021  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMIN_C_CTRL                  ((0x0022  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMIN_LB_CTRL                 ((0x0023  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMOUT_A_CTRL                 ((0x0024  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMOUT_B_CTRL                 ((0x0025  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_TDMOUT_C_CTRL                 ((0x0026  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_SPDIFIN_CTRL                  ((0x0027  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_SPDIFOUT_CTRL                 ((0x0028  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_RESAMPLEA_CTRL                ((0x0029  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_LOCKER_CTRL                   ((0x002a  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_PDMIN_CTRL0                   ((0x002b  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_PDMIN_CTRL1                   ((0x002c  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_SPDIFOUT_B_CTRL               ((0x002d  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_RESAMPLEB_CTRL                ((0x002e  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_SPDIFIN_LB_CTRL               ((0x002f  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_EQDRC_CTRL0                   ((0x0030  << 2) + 0xfe330000)
#define EE_AUDIO_VAD_CLK_CTRL                      ((0x0031  << 2) + 0xfe330000)
#define EE_AUDIO_EARCTX_CMDC_CLK_CTRL              ((0x0032  << 2) + 0xfe330000)
#define EE_AUDIO_EARCTX_DMAC_CLK_CTRL              ((0x0033  << 2) + 0xfe330000)
#define EE_AUDIO_EARCRX_CMDC_CLK_CTRL              ((0x0034  << 2) + 0xfe330000)
#define EE_AUDIO_EARCRX_DMAC_CLK_CTRL              ((0x0035  << 2) + 0xfe330000)
#define EE_AUDIO_CLK_LOCKERB_CTRL                  ((0x0036  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CTRL0                     ((0x0040  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CTRL1                     ((0x0041  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_START_ADDR                ((0x0042  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_FINISH_ADDR               ((0x0043  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_INT_ADDR                  ((0x0044  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_STATUS1                   ((0x0045  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_STATUS2                   ((0x0046  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_START_ADDRB               ((0x0047  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_FINISH_ADDRB              ((0x0048  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_INIT_ADDR                 ((0x0049  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CTRL2                     ((0x004a  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CTRL0                     ((0x0050  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CTRL1                     ((0x0051  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_START_ADDR                ((0x0052  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_FINISH_ADDR               ((0x0053  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_INT_ADDR                  ((0x0054  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_STATUS1                   ((0x0055  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_STATUS2                   ((0x0056  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_START_ADDRB               ((0x0057  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_FINISH_ADDRB              ((0x0058  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_INIT_ADDR                 ((0x0059  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CTRL2                     ((0x005a  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CTRL0                     ((0x0060  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CTRL1                     ((0x0061  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_START_ADDR                ((0x0062  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_FINISH_ADDR               ((0x0063  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_INT_ADDR                  ((0x0064  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_STATUS1                   ((0x0065  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_STATUS2                   ((0x0066  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_START_ADDRB               ((0x0067  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_FINISH_ADDRB              ((0x0068  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_INIT_ADDR                 ((0x0069  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CTRL2                     ((0x006a  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_CTRL0                     ((0x0070  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_CTRL1                     ((0x0071  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_START_ADDR                ((0x0072  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_FINISH_ADDR               ((0x0073  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_INT_ADDR                  ((0x0074  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_STATUS1                   ((0x0075  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_STATUS2                   ((0x0076  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_START_ADDRB               ((0x0077  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_FINISH_ADDRB              ((0x0078  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_INIT_ADDR                 ((0x0079  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_A_CTRL2                     ((0x007a  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_CTRL0                     ((0x0080  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_CTRL1                     ((0x0081  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_START_ADDR                ((0x0082  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_FINISH_ADDR               ((0x0083  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_INT_ADDR                  ((0x0084  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_STATUS1                   ((0x0085  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_STATUS2                   ((0x0086  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_START_ADDRB               ((0x0087  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_FINISH_ADDRB              ((0x0088  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_INIT_ADDR                 ((0x0089  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_B_CTRL2                     ((0x008a  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_CTRL0                     ((0x0090  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_CTRL1                     ((0x0091  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_START_ADDR                ((0x0092  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_FINISH_ADDR               ((0x0093  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_INT_ADDR                  ((0x0094  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_STATUS1                   ((0x0095  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_STATUS2                   ((0x0096  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_START_ADDRB               ((0x0097  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_FINISH_ADDRB              ((0x0098  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_INIT_ADDR                 ((0x0099  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_C_CTRL2                     ((0x009a  << 2) + 0xfe330000)
#define EE_AUDIO_ARB_CTRL0                         ((0x00a0  << 2) + 0xfe330000)
#define EE_AUDIO_ARB_CTRL1                         ((0x00a1  << 2) + 0xfe330000)
#define EE_AUDIO_ARB_STS                           ((0x00a8  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CTRL0                        ((0x00b0  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CTRL1                        ((0x00b1  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CTRL2                        ((0x00b2  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CTRL3                        ((0x00b3  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_DAT_CH_ID0                   ((0x00b4  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_DAT_CH_ID1                   ((0x00b5  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_DAT_CH_ID2                   ((0x00b6  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_DAT_CH_ID3                   ((0x00b7  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_LB_CH_ID0                    ((0x00b8  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_LB_CH_ID1                    ((0x00b9  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_LB_CH_ID2                    ((0x00ba  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_LB_CH_ID3                    ((0x00bb  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_STS                          ((0x00bc  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CHSYNC_CTRL_INSERT           ((0x00bd  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CHSYNC_CTRL_ORIG             ((0x00be  << 2) + 0xfe330000)
#define EE_AUDIO_LB_A_CTRL4                        ((0x00bf  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_CTRL                      ((0x00c0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_SWAP0                     ((0x00c1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK0                     ((0x00c2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK1                     ((0x00c3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK2                     ((0x00c4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK3                     ((0x00c5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_STAT                      ((0x00c6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE_VAL                  ((0x00c7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE0                     ((0x00c8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE1                     ((0x00c9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE2                     ((0x00ca  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE3                     ((0x00cb  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_CTRL                      ((0x00d0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_SWAP0                     ((0x00d1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK0                     ((0x00d2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK1                     ((0x00d3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK2                     ((0x00d4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK3                     ((0x00d5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_STAT                      ((0x00d6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE_VAL                  ((0x00d7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE0                     ((0x00d8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE1                     ((0x00d9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE2                     ((0x00da  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE3                     ((0x00db  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_CTRL                      ((0x00e0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_SWAP0                     ((0x00e1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK0                     ((0x00e2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK1                     ((0x00e3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK2                     ((0x00e4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK3                     ((0x00e5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_STAT                      ((0x00e6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE_VAL                  ((0x00e7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE0                     ((0x00e8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE1                     ((0x00e9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE2                     ((0x00ea  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE3                     ((0x00eb  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_CTRL                     ((0x00f0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_SWAP0                    ((0x00f1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK0                    ((0x00f2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK1                    ((0x00f3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK2                    ((0x00f4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK3                    ((0x00f5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_STAT                     ((0x00f6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE_VAL                 ((0x00f7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE0                    ((0x00f8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE1                    ((0x00f9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE2                    ((0x00fa  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE3                    ((0x00fb  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL0                     ((0x0100  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL1                     ((0x0101  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL2                     ((0x0102  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL3                     ((0x0103  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL4                     ((0x0104  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL5                     ((0x0105  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL6                     ((0x0106  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_STAT0                     ((0x0107  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_STAT1                     ((0x0108  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_STAT2                     ((0x0109  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_MUTE_VAL                  ((0x010a  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_CTRL7                     ((0x010b  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_CTRL0                   ((0x0110  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_CTRL1                   ((0x0111  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_CTRL2                   ((0x0112  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_CTRL3                   ((0x0113  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_COEF0                   ((0x0114  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_COEF1                   ((0x0115  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_COEF2                   ((0x0116  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_COEF3                   ((0x0117  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_COEF4                   ((0x0118  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEA_STATUS1                 ((0x0119  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_STAT                     ((0x0120  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN0                    ((0x0121  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN1                    ((0x0122  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CTRL0                    ((0x0123  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CTRL1                    ((0x0124  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_PREAMB                   ((0x0125  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_SWAP                     ((0x0126  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS0                   ((0x0127  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS1                   ((0x0128  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS2                   ((0x0129  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS3                   ((0x012a  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS4                   ((0x012b  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS5                   ((0x012c  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS6                   ((0x012d  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS7                   ((0x012e  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS8                   ((0x012f  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTS9                   ((0x0130  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTSA                   ((0x0131  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_CHSTSB                   ((0x0132  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_MUTE_VAL                 ((0x0133  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN2                    ((0x0134  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN3                    ((0x0135  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN_EN                  ((0x0136  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_GAIN_CTRL                ((0x0137  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_CTRL0                    ((0x0140  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_CTRL1                    ((0x0141  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_SWAP0                    ((0x0142  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK0                    ((0x0143  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK1                    ((0x0144  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK2                    ((0x0145  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK3                    ((0x0146  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_STAT                     ((0x0147  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN0                    ((0x0148  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN1                    ((0x0149  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE_VAL                 ((0x014a  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE0                    ((0x014b  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE1                    ((0x014c  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE2                    ((0x014d  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE3                    ((0x014e  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK_VAL                 ((0x014f  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_CTRL0                    ((0x0150  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_CTRL1                    ((0x0151  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_SWAP0                    ((0x0152  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK0                    ((0x0153  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK1                    ((0x0154  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK2                    ((0x0155  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK3                    ((0x0156  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_STAT                     ((0x0157  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN0                    ((0x0158  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN1                    ((0x0159  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE_VAL                 ((0x015a  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE0                    ((0x015b  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE1                    ((0x015c  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE2                    ((0x015d  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE3                    ((0x015e  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK_VAL                 ((0x015f  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_CTRL0                    ((0x0160  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_CTRL1                    ((0x0161  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_SWAP0                    ((0x0162  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK0                    ((0x0163  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK1                    ((0x0164  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK2                    ((0x0165  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK3                    ((0x0166  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_STAT                     ((0x0167  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN0                    ((0x0168  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN1                    ((0x0169  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE_VAL                 ((0x016a  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE0                    ((0x016b  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE1                    ((0x016c  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE2                    ((0x016d  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE3                    ((0x016e  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK_VAL                 ((0x016f  << 2) + 0xfe330000)
//`define EE_AUDIO_POW_DET_CTRL0          10'h180
//`define EE_AUDIO_POW_DET_CTRL1          10'h181
//`define EE_AUDIO_POW_DET_TH_HI          10'h182
//`define EE_AUDIO_POW_DET_TH_LO          10'h183
//`define EE_AUDIO_POW_DET_VALUE          10'h184
#define EE_AUDIO_SECURITY_CTRL0                    ((0x0190  << 2) + 0xfe330000)
#define EE_AUDIO_SECURITY_CTRL1                    ((0x0191  << 2) + 0xfe330000)
#define EE_AUDIO_SECURITY_CTRL2                    ((0x0192  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_STAT                   ((0x01a0  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN0                  ((0x01a1  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN1                  ((0x01a2  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CTRL0                  ((0x01a3  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CTRL1                  ((0x01a4  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_PREAMB                 ((0x01a5  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_SWAP                   ((0x01a6  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS0                 ((0x01a7  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS1                 ((0x01a8  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS2                 ((0x01a9  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS3                 ((0x01aa  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS4                 ((0x01ab  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS5                 ((0x01ac  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS6                 ((0x01ad  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS7                 ((0x01ae  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS8                 ((0x01af  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTS9                 ((0x01b0  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTSA                 ((0x01b1  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_CHSTSB                 ((0x01b2  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_MUTE_VAL               ((0x01b3  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN2                  ((0x01b4  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN3                  ((0x01b5  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN_EN                ((0x01b6  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFOUT_B_GAIN_CTRL              ((0x01b7  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_CTRL0                       ((0x01c0  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_CTRL1                       ((0x01c1  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_START_ADDR                  ((0x01c2  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_FINISH_ADDR                 ((0x01c3  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_INT_ADDR                    ((0x01c4  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_STATUS1                     ((0x01c5  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_STATUS2                     ((0x01c6  << 2) + 0xfe330000)
#define EE_AUDIO_TORAM_INIT_ADDR                   ((0x01c7  << 2) + 0xfe330000)
#define EE_AUDIO_TOACODEC_CTRL0                    ((0x01d0  << 2) + 0xfe330000)
#define EE_AUDIO_TOHDMITX_CTRL0                    ((0x01d1  << 2) + 0xfe330000)
#define EE_AUDIO_TOVAD_CTRL0                       ((0x01d2  << 2) + 0xfe330000)
#define EE_AUDIO_FRATV_CTRL0                       ((0x01d3  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_CTRL0                   ((0x01e0  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_CTRL1                   ((0x01e1  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_CTRL2                   ((0x01e2  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_CTRL3                   ((0x01e3  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_COEF0                   ((0x01e4  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_COEF1                   ((0x01e5  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_COEF2                   ((0x01e6  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_COEF3                   ((0x01e7  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_COEF4                   ((0x01e8  << 2) + 0xfe330000)
#define EE_AUDIO_RESAMPLEB_STATUS1                 ((0x01e9  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_CTRL0                  ((0x01f0  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_CTRL1                  ((0x01f1  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_CTRL6                  ((0x01f6  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_STAT0                  ((0x01f7  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_STAT1                  ((0x01f8  << 2) + 0xfe330000)
#define EE_AUDIO_SPDIFIN_LB_MUTE_VAL               ((0x01fa  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL0                    ((0x0200  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL1                    ((0x0201  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL2                    ((0x0202  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL3                    ((0x0203  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL4                    ((0x0204  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL5                    ((0x0205  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL6                    ((0x0206  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_CTRL7                    ((0x0207  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_STAT0                    ((0x020a  << 2) + 0xfe330000)
#define EE_AUDIO_FRHDMIRX_STAT1                    ((0x020b  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CTRL0                     ((0x0210  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CTRL1                     ((0x0211  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_START_ADDR                ((0x0212  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_FINISH_ADDR               ((0x0213  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_INT_ADDR                  ((0x0214  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_STATUS1                   ((0x0215  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_STATUS2                   ((0x0216  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_START_ADDRB               ((0x0217  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_FINISH_ADDRB              ((0x0218  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_INIT_ADDR                 ((0x0219  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CTRL2                     ((0x021a  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_CTRL0                     ((0x0220  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_CTRL1                     ((0x0221  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_START_ADDR                ((0x0222  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_FINISH_ADDR               ((0x0223  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_INT_ADDR                  ((0x0224  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_STATUS1                   ((0x0225  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_STATUS2                   ((0x0226  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_START_ADDRB               ((0x0227  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_FINISH_ADDRB              ((0x0228  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_INIT_ADDR                 ((0x0229  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_D_CTRL2                     ((0x022a  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CTRL0                        ((0x0230  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CTRL1                        ((0x0231  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CTRL2                        ((0x0232  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CTRL3                        ((0x0233  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_DAT_CH_ID0                   ((0x0234  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_DAT_CH_ID1                   ((0x0235  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_DAT_CH_ID2                   ((0x0236  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_DAT_CH_ID3                   ((0x0237  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_LB_CH_ID0                    ((0x0238  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_LB_CH_ID1                    ((0x0239  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_LB_CH_ID2                    ((0x023a  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_LB_CH_ID3                    ((0x023b  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_STS                          ((0x023c  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CHSYNC_CTRL_INSERT           ((0x023d  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CHSYNC_CTRL_ORIG             ((0x023e  << 2) + 0xfe330000)
#define EE_AUDIO_LB_B_CTRL4                        ((0x023f  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CTRL0                     ((0x0240  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CTRL1                     ((0x0241  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_START_ADDR                ((0x0242  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_FINISH_ADDR               ((0x0243  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_INT_ADDR                  ((0x0244  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_STATUS1                   ((0x0245  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_STATUS2                   ((0x0246  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_START_ADDRB               ((0x0247  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_FINISH_ADDRB              ((0x0248  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_INIT_ADDR                 ((0x0249  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CTRL2                     ((0x024a  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_CTRL0                     ((0x0250  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_CTRL1                     ((0x0251  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_START_ADDR                ((0x0252  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_FINISH_ADDR               ((0x0253  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_INT_ADDR                  ((0x0254  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_STATUS1                   ((0x0255  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_STATUS2                   ((0x0256  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_START_ADDRB               ((0x0257  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_FINISH_ADDRB              ((0x0258  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_INIT_ADDR                 ((0x0259  << 2) + 0xfe330000)
#define EE_AUDIO_FRDDR_E_CTRL2                     ((0x025a  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_SWAP1                     ((0x0260  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK4                     ((0x0261  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK5                     ((0x0262  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK6                     ((0x0263  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MASK7                     ((0x0264  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE4                     ((0x0265  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE5                     ((0x0266  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE6                     ((0x0267  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_A_MUTE7                     ((0x0268  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_SWAP1                     ((0x0270  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK4                     ((0x0271  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK5                     ((0x0272  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK6                     ((0x0273  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MASK7                     ((0x0274  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE4                     ((0x0275  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE5                     ((0x0276  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE6                     ((0x0277  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_B_MUTE7                     ((0x0278  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_SWAP1                     ((0x0280  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK4                     ((0x0281  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK5                     ((0x0282  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK6                     ((0x0283  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MASK7                     ((0x0284  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE4                     ((0x0285  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE5                     ((0x0286  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE6                     ((0x0287  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_C_MUTE7                     ((0x0288  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_SWAP1                    ((0x0290  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK4                    ((0x0291  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK5                    ((0x0292  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK6                    ((0x0293  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MASK7                    ((0x0294  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE4                    ((0x0295  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE5                    ((0x0296  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE6                    ((0x0297  << 2) + 0xfe330000)
#define EE_AUDIO_TDMIN_LB_MUTE7                    ((0x0298  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_CTRL2                    ((0x02a0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_SWAP1                    ((0x02a1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN2                    ((0x02a2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN3                    ((0x02a3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK4                    ((0x02a4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK5                    ((0x02a5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK6                    ((0x02a6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MASK7                    ((0x02a7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE4                    ((0x02a8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE5                    ((0x02a9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE6                    ((0x02aa  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_MUTE7                    ((0x02ab  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN_EN                  ((0x02ac  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_A_GAIN_CTRL                ((0x02ad  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_CTRL2                    ((0x02b0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_SWAP1                    ((0x02b1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN2                    ((0x02b2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN3                    ((0x02b3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK4                    ((0x02b4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK5                    ((0x02b5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK6                    ((0x02b6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MASK7                    ((0x02b7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE4                    ((0x02b8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE5                    ((0x02b9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE6                    ((0x02ba  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_MUTE7                    ((0x02bb  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN_EN                  ((0x02bc  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_B_GAIN_CTRL                ((0x02bd  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_CTRL2                    ((0x02c0  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_SWAP1                    ((0x02c1  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN2                    ((0x02c2  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN3                    ((0x02c3  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK4                    ((0x02c4  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK5                    ((0x02c5  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK6                    ((0x02c6  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MASK7                    ((0x02c7  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE4                    ((0x02c8  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE5                    ((0x02c9  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE6                    ((0x02ca  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_MUTE7                    ((0x02cb  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN_EN                  ((0x02cc  << 2) + 0xfe330000)
#define EE_AUDIO_TDMOUT_C_GAIN_CTRL                ((0x02cd  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID0                 ((0x0300  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID1                 ((0x0301  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID2                 ((0x0302  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID3                 ((0x0303  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID4                 ((0x0304  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID5                 ((0x0305  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID6                 ((0x0306  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHNUM_ID7                 ((0x0307  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_A_CHSYNC_CTRL               ((0x030f  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID0                 ((0x0310  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID1                 ((0x0311  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID2                 ((0x0312  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID3                 ((0x0313  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID4                 ((0x0314  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID5                 ((0x0315  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID6                 ((0x0316  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHNUM_ID7                 ((0x0317  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_B_CHSYNC_CTRL               ((0x031f  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID0                 ((0x0320  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID1                 ((0x0321  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID2                 ((0x0322  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID3                 ((0x0323  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID4                 ((0x0324  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID5                 ((0x0325  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID6                 ((0x0326  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHNUM_ID7                 ((0x0327  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_C_CHSYNC_CTRL               ((0x032f  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID0                 ((0x0330  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID1                 ((0x0331  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID2                 ((0x0332  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID3                 ((0x0333  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID4                 ((0x0334  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID5                 ((0x0335  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID6                 ((0x0336  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHNUM_ID7                 ((0x0337  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_D_CHSYNC_CTRL               ((0x033f  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID0                 ((0x0340  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID1                 ((0x0341  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID2                 ((0x0342  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID3                 ((0x0343  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID4                 ((0x0344  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID5                 ((0x0345  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID6                 ((0x0346  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHNUM_ID7                 ((0x0347  << 2) + 0xfe330000)
#define EE_AUDIO_TODDR_E_CHSYNC_CTRL               ((0x034f  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID0                 ((0x0350  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID1                 ((0x0351  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID2                 ((0x0352  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID3                 ((0x0353  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID4                 ((0x0354  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID5                 ((0x0355  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID6                 ((0x0356  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHNUM_ID7                 ((0x0357  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_CHSYNC_MASK                 ((0x035e  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_A_CHSYNC_CTRL               ((0x035f  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID0                 ((0x0360  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID1                 ((0x0361  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID2                 ((0x0362  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID3                 ((0x0363  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID4                 ((0x0364  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID5                 ((0x0365  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID6                 ((0x0366  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHNUM_ID7                 ((0x0367  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_B_CHSYNC_CTRL               ((0x036f  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID0                 ((0x0370  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID1                 ((0x0371  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID2                 ((0x0372  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID3                 ((0x0373  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID4                 ((0x0374  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID5                 ((0x0375  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID6                 ((0x0376  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHNUM_ID7                 ((0x0377  << 2) + 0xfe330000)
#define EE_AUDIO_RSAMP_C_CHSYNC_CTRL               ((0x037f  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_STS0                ((0x0380  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_STS1                ((0x0381  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_MASK0               ((0x0382  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_MASK1               ((0x0383  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_MODE0               ((0x0384  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_MODE1               ((0x0385  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_CLR0                ((0x0386  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_CLR1                ((0x0387  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_INV0                ((0x0388  << 2) + 0xfe330000)
#define EE_AUDIO_EXCEPTION_IRQ_INV1                ((0x0389  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL0                     ((0x0390  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL1                     ((0x0391  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL2                     ((0x0392  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL3                     ((0x0393  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL4                     ((0x0394  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL5                     ((0x0395  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL6                     ((0x0396  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL7                     ((0x0397  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL8                     ((0x0398  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRL9                     ((0x0399  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLA                     ((0x039a  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLB                     ((0x039b  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLC                     ((0x039c  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLD                     ((0x039d  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLE                     ((0x039e  << 2) + 0xfe330000)
#define EE_AUDIO_DAT_PAD_CTRLF                     ((0x039f  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_PAD_CTRL0                    ((0x03a0  << 2) + 0xfe330000)
#define EE_AUDIO_MCLK_PAD_CTRL1                    ((0x03a1  << 2) + 0xfe330000)
#define EE_AUDIO_SCLK_PAD_CTRL0                    ((0x03a2  << 2) + 0xfe330000)
#define EE_AUDIO_LRCLK_PAD_CTRL0                   ((0x03a3  << 2) + 0xfe330000)
//========================================================================
//  PDM - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe331000
// -----------------------------------------------
#define PDM_CTRL                                   ((0x0000  << 2) + 0xfe331000)
  //bit 31:   PDM enable.
  //bit 30:   invert the PDM_DCLK.
  //bit 29:   output mode:  1: 24bits. 0: 32 bits.
  //bit 28:   bypass mode. 1: bypass all filter. directly output the PDM input to DDR. 0: normal mode.
  //bit 27~9: not used.
  //bit 16:.   PDM Asynchronous FIFO soft reset.  write 1 to soft reset AFIFO.
  //bit 15:8   PDM channel reset.  0: to reset each PDM channel.  1: normal mode.
  //bit 7:0.  PDM channel enable. each bit for one channel.
#define PDM_HCIC_CTRL1                             ((0x0001  << 2) + 0xfe331000)
  //bit 31      hcic filter enable.  1 use sinc filter. 0 bypass input to output.
  //bit 29:24.  hcic final gain shift parameter.
  //bit 23:16   hcic final gain multiplier.
  //bit 8:4     hcic  down sample rate.
  //bit 3:0     hcic  stage number. must be between 3 to 9.
#define PDM_HCIC_CTRL2                             ((0x0002  << 2) + 0xfe331000)
  //Not used.
#define PDM_F1_CTRL                                ((0x0003  << 2) + 0xfe331000)
  //bit 31 .   filter 1 enable.
  //bit 16:15. f1 round mode.  2'b00 : sign bit at bit 49.  28bits output [49:22] round at bit 21. 32bits output [49:18]. 24bits output [49:26]
         //                    2'b01 : sign bit at bit 50.  28bits output [50:23] round at bit 22. 32bits output [49:18]. 24bits output [49:26]
         //                    2'b10 : sign bit at bit 51.  28bits output [51:24] round at bit 23 32bits output [49:18]. 24bits output [49:26].
  //bit 15:12. filter 1 down sample rate.
  //bit 8:0.   filter 1 stage number.
#define PDM_F2_CTRL                                ((0x0004  << 2) + 0xfe331000)
  //bit 31 .   filter 2 enable.
  //bit 16:15. f2 round mode.  2'b00 : round at bit 21. 2'b01 : round at bit 22.  2'b10 : round at bit 23.
  //bit 15:12. filter 2 down sample rate.
  //bit 8:0.   filter 2 stage number.
#define PDM_F3_CTRL                                ((0x0005  << 2) + 0xfe331000)
  //bit 31 .   filter 3 enable.
  //bit 16:15. f3 round mode.  2'b00 : round at bit 21. 2'b01 : round at bit 22.  2'b10 : round at bit 23.
  //bit 15:12. filter 3 down sample rate.
  //bit 8:0.   filter 3 stage number.
#define PDM_HPF_CTRL                               ((0x0006  << 2) + 0xfe331000)
  //bit 31  High pass filter enable.
  //bit 20:16 high pass filter shift steps. 6~19 steps.
  //bit 15:0 high pass filter output factor.
#define PDM_CHAN_CTRL                              ((0x0007  << 2) + 0xfe331000)
  //bit 31:24.  chan3 data sample pointer vs edge of the PDM_DCLK.
  //bit 23:16   chan2 data sample pointer vs edge of the PDM_DCLK.
  //bit 15:8.   chan1 data sample pointer vs edge of the PDM_DCLK.
  //bit 7:0     chan0 data sample pointer vs edge of the PDM_DCLK.
#define PDM_CHAN_CTRL1                             ((0x0008  << 2) + 0xfe331000)
  //bit 31:24.  chan7 data sample pointer vs edge of the PDM_DCLK.
  //bit 23:16   chan6 data sample pointer vs edge of the PDM_DCLK.
  //bit 15:8.   chan5 data sample pointer vs edge of the PDM_DCLK.
  //bit 7:0     chan4 data sample pointer vs edge of the PDM_DCLK.
#define PDM_COEFF_ADDR                             ((0x0009  << 2) + 0xfe331000)
  // address of the write/read of coeff data.
#define PDM_COEFF_DATA                             ((0x000a  << 2) + 0xfe331000)
  //write/read data to coeff memory.
#define PDM_CLKG_CTRL                              ((0x000b  << 2) + 0xfe331000)
  // auto clock gating control.  1: disable the clock gating function. the clock will awlays enabled. 0 : use RTL auto clock gating.
  //31:7 not used.
  //bit 6  filt_ctrl module auto clock gating control.
  //bit 5  sinc fifo module auto clock gating control.
  //bit 4  filter module auto clock gating control.
  //bit 3  apb module auto clock gating control.
  //bit 2  coeff memory module auto clock gating control.
  //bit 1  each channel module auto clock gating control.
  //bit 0 cts_pdm_clk   auto clock gating control.
#define PDM_STS                                    ((0x000c  << 2) + 0xfe331000)
//bit 1  HPF filter output overflow.  means the PCLK is too slow.
//bit 0  HCIC filter output overflow. means the CTS_PDM_CLK is too slow. can't finished the filter function.
#define PDM_MUTE_VALUE                             ((0x000d  << 2) + 0xfe331000)
#define PDM_MASK_NUM                               ((0x000e  << 2) + 0xfe331000)
#define PDM_CHAN_CTRL2                             ((0x000f  << 2) + 0xfe331000)
  //bit 7:0    second sample and start FSM point vs rise edge of PDM_DCLK
//========================================================================
//  EQ DRC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe332000
// -----------------------------------------------
#define AED_COEF_RAM_CNTL                          ((0x0000  << 2) + 0xfe332000)
#define AED_COEF_RAM_DATA                          ((0x0001  << 2) + 0xfe332000)
#define AED_EQ_EN                                  ((0x0002  << 2) + 0xfe332000)
#define AED_EQ_TAP_CNTL                            ((0x0003  << 2) + 0xfe332000)
#define AED_EQ_VOLUME                              ((0x0004  << 2) + 0xfe332000)
#define AED_EQ_VOLUME_SLEW_CNT                     ((0x0005  << 2) + 0xfe332000)
#define AED_MUTE                                   ((0x0006  << 2) + 0xfe332000)
#define AED_DRC_CNTL                               ((0x0007  << 2) + 0xfe332000)
#define AED_DRC_RMS_COEF0                          ((0x0008  << 2) + 0xfe332000)
#define AED_DRC_RMS_COEF1                          ((0x0009  << 2) + 0xfe332000)
#define AED_DRC_THD0                               ((0x000a  << 2) + 0xfe332000)
#define AED_DRC_THD1                               ((0x000b  << 2) + 0xfe332000)
#define AED_DRC_THD2                               ((0x000c  << 2) + 0xfe332000)
#define AED_DRC_THD3                               ((0x000d  << 2) + 0xfe332000)
#define AED_DRC_THD4                               ((0x000e  << 2) + 0xfe332000)
#define AED_DRC_K0                                 ((0x000f  << 2) + 0xfe332000)
#define AED_DRC_K1                                 ((0x0010  << 2) + 0xfe332000)
#define AED_DRC_K2                                 ((0x0011  << 2) + 0xfe332000)
#define AED_DRC_K3                                 ((0x0012  << 2) + 0xfe332000)
#define AED_DRC_K4                                 ((0x0013  << 2) + 0xfe332000)
#define AED_DRC_K5                                 ((0x0014  << 2) + 0xfe332000)
#define AED_DRC_THD_OUT0                           ((0x0015  << 2) + 0xfe332000)
#define AED_DRC_THD_OUT1                           ((0x0016  << 2) + 0xfe332000)
#define AED_DRC_THD_OUT2                           ((0x0017  << 2) + 0xfe332000)
#define AED_DRC_THD_OUT3                           ((0x0018  << 2) + 0xfe332000)
#define AED_DRC_OFFSET                             ((0x0019  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF00                     ((0x001a  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF01                     ((0x001b  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF10                     ((0x001c  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF11                     ((0x001d  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF20                     ((0x001e  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF21                     ((0x001f  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF30                     ((0x0020  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF31                     ((0x0021  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF40                     ((0x0022  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF41                     ((0x0023  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF50                     ((0x0024  << 2) + 0xfe332000)
#define AED_DRC_RELEASE_COEF51                     ((0x0025  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF00                      ((0x0026  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF01                      ((0x0027  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF10                      ((0x0028  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF11                      ((0x0029  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF20                      ((0x002a  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF21                      ((0x002b  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF30                      ((0x002c  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF31                      ((0x002d  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF40                      ((0x002e  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF41                      ((0x002f  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF50                      ((0x0030  << 2) + 0xfe332000)
#define AED_DRC_ATTACK_COEF51                      ((0x0031  << 2) + 0xfe332000)
#define AED_DRC_LOOPBACK_CNTL                      ((0x0032  << 2) + 0xfe332000)
#define AED_MDRC_CNTL                              ((0x0033  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF00                        ((0x0034  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF01                        ((0x0035  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF00                    ((0x0036  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF01                    ((0x0037  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF00                     ((0x0038  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF01                     ((0x0039  << 2) + 0xfe332000)
#define AED_MDRC_THD0                              ((0x003a  << 2) + 0xfe332000)
#define AED_MDRC_K0                                ((0x003b  << 2) + 0xfe332000)
#define AED_MDRC_LOW_GAIN                          ((0x003c  << 2) + 0xfe332000)
#define AED_MDRC_OFFSET0                           ((0x003d  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF10                        ((0x003e  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF11                        ((0x003f  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF10                    ((0x0040  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF11                    ((0x0041  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF10                     ((0x0042  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF11                     ((0x0043  << 2) + 0xfe332000)
#define AED_MDRC_THD1                              ((0x0044  << 2) + 0xfe332000)
#define AED_MDRC_K1                                ((0x0045  << 2) + 0xfe332000)
#define AED_MDRC_OFFSET1                           ((0x0046  << 2) + 0xfe332000)
#define AED_MDRC_MID_GAIN                          ((0x0047  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF20                        ((0x0048  << 2) + 0xfe332000)
#define AED_MDRC_RMS_COEF21                        ((0x0049  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF20                    ((0x004a  << 2) + 0xfe332000)
#define AED_MDRC_RELEASE_COEF21                    ((0x004b  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF20                     ((0x004c  << 2) + 0xfe332000)
#define AED_MDRC_ATTACK_COEF21                     ((0x004d  << 2) + 0xfe332000)
#define AED_MDRC_THD2                              ((0x004e  << 2) + 0xfe332000)
#define AED_MDRC_K2                                ((0x004f  << 2) + 0xfe332000)
#define AED_MDRC_OFFSET2                           ((0x0050  << 2) + 0xfe332000)
#define AED_MDRC_HIGH_GAIN                         ((0x0051  << 2) + 0xfe332000)
#define AED_ED_CNTL                                ((0x0052  << 2) + 0xfe332000)
#define AED_DC_EN                                  ((0x0053  << 2) + 0xfe332000)
#define AED_ND_LOW_THD                             ((0x0054  << 2) + 0xfe332000)
#define AED_ND_HIGH_THD                            ((0x0055  << 2) + 0xfe332000)
#define AED_ND_CNT_THD                             ((0x0056  << 2) + 0xfe332000)
#define AED_ND_SUM_NUM                             ((0x0057  << 2) + 0xfe332000)
#define AED_ND_CZ_NUM                              ((0x0058  << 2) + 0xfe332000)
#define AED_ND_SUM_THD0                            ((0x0059  << 2) + 0xfe332000)
#define AED_ND_SUM_THD1                            ((0x005a  << 2) + 0xfe332000)
#define AED_ND_CZ_THD0                             ((0x005b  << 2) + 0xfe332000)
#define AED_ND_CZ_THD1                             ((0x005c  << 2) + 0xfe332000)
#define AED_ND_COND_CNTL                           ((0x005d  << 2) + 0xfe332000)
#define AED_ND_RELEASE_COEF0                       ((0x005e  << 2) + 0xfe332000)
#define AED_ND_RELEASE_COEF1                       ((0x005f  << 2) + 0xfe332000)
#define AED_ND_ATTACK_COEF0                        ((0x0060  << 2) + 0xfe332000)
#define AED_ND_ATTACK_COEF1                        ((0x0061  << 2) + 0xfe332000)
#define AED_ND_CNTL                                ((0x0062  << 2) + 0xfe332000)
#define AED_MIX0_LL                                ((0x0063  << 2) + 0xfe332000)
#define AED_MIX0_RL                                ((0x0064  << 2) + 0xfe332000)
#define AED_MIX0_LR                                ((0x0065  << 2) + 0xfe332000)
#define AED_MIX0_RR                                ((0x0066  << 2) + 0xfe332000)
#define AED_CLIP_THD                               ((0x0067  << 2) + 0xfe332000)
#define AED_CH1_ND_SUM_OUT                         ((0x0068  << 2) + 0xfe332000)
#define AED_CH2_ND_SUM_OUT                         ((0x0069  << 2) + 0xfe332000)
#define AED_CH1_ND_CZ_OUT                          ((0x006a  << 2) + 0xfe332000)
#define AED_CH2_ND_CZ_OUT                          ((0x006b  << 2) + 0xfe332000)
#define AED_NOISE_STATUS                           ((0x006c  << 2) + 0xfe332000)
#define AED_POW_CURRENT_S0                         ((0x006d  << 2) + 0xfe332000)
#define AED_POW_CURRENT_S1                         ((0x006e  << 2) + 0xfe332000)
#define AED_POW_CURRENT_S2                         ((0x006f  << 2) + 0xfe332000)
#define AED_POW_OUT0                               ((0x0070  << 2) + 0xfe332000)
#define AED_POW_OUT1                               ((0x0071  << 2) + 0xfe332000)
#define AED_POW_OUT2                               ((0x0072  << 2) + 0xfe332000)
#define AED_POW_ADJ_INDEX0                         ((0x0073  << 2) + 0xfe332000)
#define AED_POW_ADJ_INDEX1                         ((0x0074  << 2) + 0xfe332000)
#define AED_POW_ADJ_INDEX2                         ((0x0075  << 2) + 0xfe332000)
#define AED_DRC_GAIN_INDEX0                        ((0x0076  << 2) + 0xfe332000)
#define AED_DRC_GAIN_INDEX1                        ((0x0077  << 2) + 0xfe332000)
#define AED_DRC_GAIN_INDEX2                        ((0x0078  << 2) + 0xfe332000)
#define AED_CH1_VOLUME_STATE                       ((0x0079  << 2) + 0xfe332000)
#define AED_CH2_VOLUME_STATE                       ((0x007a  << 2) + 0xfe332000)
#define AED_CH1_VOLUME_GAIN                        ((0x007b  << 2) + 0xfe332000)
#define AED_CH2_VOLUME_GAIN                        ((0x007c  << 2) + 0xfe332000)
#define AED_FULL_POW_CURRENT                       ((0x007d  << 2) + 0xfe332000)
#define AED_FULL_POW_OUT                           ((0x007e  << 2) + 0xfe332000)
#define AED_FULL_POW_ADJ                           ((0x007f  << 2) + 0xfe332000)
#define AED_FULL_DRC_GAIN                          ((0x0080  << 2) + 0xfe332000)
#define AED_MASTER_VOLUME_STATE                    ((0x0081  << 2) + 0xfe332000)
#define AED_MASTER_VOLUME_GAIN                     ((0x0082  << 2) + 0xfe332000)
#define AED_TOP_CTL0                               ((0x0083  << 2) + 0xfe332000)
#define AED_TOP_CTL1                               ((0x0084  << 2) + 0xfe332000)
#define AED_TOP_CTL2                               ((0x0085  << 2) + 0xfe332000)
#define AED_TOP_ST0                                ((0x0086  << 2) + 0xfe332000)
#define AED_TOP_ST1                                ((0x0087  << 2) + 0xfe332000)
//`define   AED_EQDRC_DYNAMIC_CNTL           10'h90
//`define   AED_COEF_RAM_CNTL_B              10'h91
//`define   AED_COEF_RAM_DATA_B              10'h92
//`define   AED_DRC_RMS_COEF0_B              10'h93
//`define   AED_DRC_RMS_COEF1_B              10'h94
//`define   AED_DRC_THD0_B                   10'h95
//`define   AED_DRC_THD1_B                   10'h96
//`define   AED_DRC_THD2_B                   10'h97
//`define   AED_DRC_THD3_B                   10'h98
//`define   AED_DRC_THD4_B                   10'h99
//`define   AED_DRC_K0_B                     10'h9a
//`define   AED_DRC_K1_B                     10'h9b
//`define   AED_DRC_K2_B                     10'h9c
//`define   AED_DRC_K3_B                     10'h9d
//`define   AED_DRC_K4_B                     10'h9e
//`define   AED_DRC_K5_B                     10'h9f
//`define   AED_DRC_THD_OUT0_B               10'ha0
//`define   AED_DRC_THD_OUT1_B               10'ha1
//`define   AED_DRC_THD_OUT2_B               10'ha2
//`define   AED_DRC_THD_OUT3_B               10'ha3
//`define   AED_DRC_OFFSET_B                 10'ha4
//`define   AED_DRC_RELEASE_COEF00_B         10'ha5
//`define   AED_DRC_RELEASE_COEF01_B         10'ha6
//`define   AED_DRC_RELEASE_COEF10_B         10'ha7
//`define   AED_DRC_RELEASE_COEF11_B         10'ha8
//`define   AED_DRC_RELEASE_COEF20_B         10'ha9
//`define   AED_DRC_RELEASE_COEF21_B         10'haa
//`define   AED_DRC_RELEASE_COEF30_B         10'hab
//`define   AED_DRC_RELEASE_COEF31_B         10'hac
//`define   AED_DRC_RELEASE_COEF40_B         10'had
//`define   AED_DRC_RELEASE_COEF41_B         10'hae
//`define   AED_DRC_RELEASE_COEF50_B         10'haf
//`define   AED_DRC_RELEASE_COEF51_B         10'hb0
//`define   AED_DRC_ATTACK_COEF00_B          10'hb1
//`define   AED_DRC_ATTACK_COEF01_B          10'hb2
//`define   AED_DRC_ATTACK_COEF10_B          10'hb3
//`define   AED_DRC_ATTACK_COEF11_B          10'hb4
//`define   AED_DRC_ATTACK_COEF20_B          10'hb5
//`define   AED_DRC_ATTACK_COEF21_B          10'hb6
//`define   AED_DRC_ATTACK_COEF30_B          10'hb7
//`define   AED_DRC_ATTACK_COEF31_B          10'hb8
//`define   AED_DRC_ATTACK_COEF40_B          10'hb9
//`define   AED_DRC_ATTACK_COEF41_B          10'hba
//`define   AED_DRC_ATTACK_COEF50_B          10'hbb
//`define   AED_DRC_ATTACK_COEF51_B          10'hbc
//`define   AED_MDRC_RMS_COEF00_B            10'hbd
//`define   AED_MDRC_RMS_COEF01_B            10'hbe
//`define   AED_MDRC_RMS_COEF10_B            10'hbf
//`define   AED_MDRC_RMS_COEF11_B            10'hc0
//`define   AED_MDRC_RMS_COEF20_B            10'hc1
//`define   AED_MDRC_RMS_COEF21_B            10'hc2
//`define   AED_MDRC_RELEASE_COEF00_B        10'hc3
//`define   AED_MDRC_RELEASE_COEF01_B        10'hc4
//`define   AED_MDRC_RELEASE_COEF10_B        10'hc5
//`define   AED_MDRC_RELEASE_COEF11_B        10'hc6
//`define   AED_MDRC_RELEASE_COEF20_B        10'hc7
//`define   AED_MDRC_RELEASE_COEF21_B        10'hc8
//`define   AED_MDRC_ATTACK_COEF00_B         10'hc9
//`define   AED_MDRC_ATTACK_COEF01_B         10'hca
//`define   AED_MDRC_ATTACK_COEF10_B         10'hcb
//`define   AED_MDRC_ATTACK_COEF11_B         10'hcc
//`define   AED_MDRC_ATTACK_COEF20_B         10'hcd
//`define   AED_MDRC_ATTACK_COEF21_B         10'hce
//`define   AED_MDRC_THD0_B                  10'hcf
//`define   AED_MDRC_THD1_B                  10'hd0
//`define   AED_MDRC_THD2_B                  10'hd1
//`define   AED_MDRC_K0_B                    10'hd2
//`define   AED_MDRC_K1_B                    10'hd3
//`define   AED_MDRC_K2_B                    10'hd4
//`define   AED_MDRC_OFFSET0_B               10'hd5
//`define   AED_MDRC_OFFSET1_B               10'hd6
//`define   AED_MDRC_OFFSET2_B               10'hd7
//`define   AED_MDRC_LOW_GAIN_B              10'hd8
//`define   AED_MDRC_MID_GAIN_B              10'hd9
//`define   AED_MDRC_HIGH_GAIN_B             10'hda
//`define   AED_DRC_CNTL_B                   10'hdb
//`define   AED_DRC_LOOPBACK_CNTL_B          10'hdc
//`define   AED_MDRC_CNTL_B                  10'hdd
//`define   AED_STATUS_REG                   10'hde
//========================================================================
//  AUDIO locker - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe331400
// -----------------------------------------------
#define AUD_LOCK_EN                                ((0x0000  << 2) + 0xfe331400)
#define AUD_LOCK_SW_RESET                          ((0x0001  << 2) + 0xfe331400)
#define AUD_LOCK_SW_LATCH                          ((0x0002  << 2) + 0xfe331400)
#define AUD_LOCK_HW_LATCH                          ((0x0003  << 2) + 0xfe331400)
#define AUD_LOCK_REFCLK_SRC                        ((0x0004  << 2) + 0xfe331400)
#define AUD_LOCK_REFCLK_LAT_INT                    ((0x0005  << 2) + 0xfe331400)
#define AUD_LOCK_IMCLK_LAT_INT                     ((0x0006  << 2) + 0xfe331400)
#define AUD_LOCK_OMCLK_LAT_INT                     ((0x0007  << 2) + 0xfe331400)
#define AUD_LOCK_REFCLK_DS_INT                     ((0x0008  << 2) + 0xfe331400)
#define AUD_LOCK_IMCLK_DS_INT                      ((0x0009  << 2) + 0xfe331400)
#define AUD_LOCK_OMCLK_DS_INT                      ((0x000a  << 2) + 0xfe331400)
#define AUD_LOCK_INT_CLR                           ((0x000b  << 2) + 0xfe331400)
#define AUD_LOCK_GCLK_CTRL                         ((0x000c  << 2) + 0xfe331400)
#define AUD_LOCK_INT_CTRL                          ((0x000d  << 2) + 0xfe331400)
#define RO_REF2IMCLK_CNT_L                         ((0x0010  << 2) + 0xfe331400)
#define RO_REF2IMCLK_CNT_H                         ((0x0011  << 2) + 0xfe331400)
#define RO_REF2OMCLK_CNT_L                         ((0x0012  << 2) + 0xfe331400)
#define RO_REF2OMCLK_CNT_H                         ((0x0013  << 2) + 0xfe331400)
#define RO_IMCLK2REF_CNT_L                         ((0x0014  << 2) + 0xfe331400)
#define RO_IMCLK2REF_CNT_H                         ((0x0015  << 2) + 0xfe331400)
#define RO_OMCLK2REF_CNT_L                         ((0x0016  << 2) + 0xfe331400)
#define RO_OMCLK2REF_CNT_H                         ((0x0017  << 2) + 0xfe331400)
#define RO_REFCLK_PKG_CNT                          ((0x0018  << 2) + 0xfe331400)
#define RO_IMCLK_PKG_CNT                           ((0x0019  << 2) + 0xfe331400)
#define RO_OMCLK_PKG_CNT                           ((0x001a  << 2) + 0xfe331400)
#define RO_AUD_LOCK_INT_STATUS                     ((0x001b  << 2) + 0xfe331400)
//========================================================================
//  AUDIO lockerB - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe334400
// -----------------------------------------------
#define AUD_LOCKB_EN                               ((0x0000  << 2) + 0xfe334400)
#define AUD_LOCKB_SW_RESET                         ((0x0001  << 2) + 0xfe334400)
#define AUD_LOCKB_SW_LATCH                         ((0x0002  << 2) + 0xfe334400)
#define AUD_LOCKB_HW_LATCH                         ((0x0003  << 2) + 0xfe334400)
#define AUD_LOCKB_REFCLK_SRC                       ((0x0004  << 2) + 0xfe334400)
#define AUD_LOCKB_REFCLK_LAT_INT                   ((0x0005  << 2) + 0xfe334400)
#define AUD_LOCKB_IMCLK_LAT_INT                    ((0x0006  << 2) + 0xfe334400)
#define AUD_LOCKB_OMCLK_LAT_INT                    ((0x0007  << 2) + 0xfe334400)
#define AUD_LOCKB_REFCLK_DS_INT                    ((0x0008  << 2) + 0xfe334400)
#define AUD_LOCKB_IMCLK_DS_INT                     ((0x0009  << 2) + 0xfe334400)
#define AUD_LOCKB_OMCLK_DS_INT                     ((0x000a  << 2) + 0xfe334400)
#define AUD_LOCKB_INT_CLR                          ((0x000b  << 2) + 0xfe334400)
#define AUD_LOCKB_GCLK_CTRL                        ((0x000c  << 2) + 0xfe334400)
#define AUD_LOCKB_INT_CTRL                         ((0x000d  << 2) + 0xfe334400)
#define ROB_REF2IMCLK_CNT_L                        ((0x0010  << 2) + 0xfe334400)
#define ROB_REF2IMCLK_CNT_H                        ((0x0011  << 2) + 0xfe334400)
#define ROB_REF2OMCLK_CNT_L                        ((0x0012  << 2) + 0xfe334400)
#define ROB_REF2OMCLK_CNT_H                        ((0x0013  << 2) + 0xfe334400)
#define ROB_IMCLK2REF_CNT_L                        ((0x0014  << 2) + 0xfe334400)
#define ROB_IMCLK2REF_CNT_H                        ((0x0015  << 2) + 0xfe334400)
#define ROB_OMCLK2REF_CNT_L                        ((0x0016  << 2) + 0xfe334400)
#define ROB_OMCLK2REF_CNT_H                        ((0x0017  << 2) + 0xfe334400)
#define ROB_REFCLK_PKG_CNT                         ((0x0018  << 2) + 0xfe334400)
#define ROB_IMCLK_PKG_CNT                          ((0x0019  << 2) + 0xfe334400)
#define ROB_OMCLK_PKG_CNT                          ((0x001a  << 2) + 0xfe334400)
#define ROB_AUD_LOCK_INT_STATUS                    ((0x001b  << 2) + 0xfe334400)
//========================================================================
//  AUDIO VAD - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe331800
// -----------------------------------------------
//
// Reading file:  VAD_REG.h
//
#define VAD_TOP_CTRL0                              ((0x0000  << 2) + 0xfe331800)
#define VAD_TOP_CTRL1                              ((0x0001  << 2) + 0xfe331800)
#define VAD_TOP_CTRL2                              ((0x0002  << 2) + 0xfe331800)
#define VAD_FIR_CTRL                               ((0x0003  << 2) + 0xfe331800)
#define VAD_FIR_EMP                                ((0x0004  << 2) + 0xfe331800)
#define VAD_FIR_COEF0                              ((0x0005  << 2) + 0xfe331800)
#define VAD_FIR_COEF1                              ((0x0006  << 2) + 0xfe331800)
#define VAD_FIR_COEF2                              ((0x0007  << 2) + 0xfe331800)
#define VAD_FIR_COEF3                              ((0x0008  << 2) + 0xfe331800)
#define VAD_FIR_COEF4                              ((0x0009  << 2) + 0xfe331800)
#define VAD_FIR_COEF5                              ((0x000a  << 2) + 0xfe331800)
#define VAD_FIR_COEF6                              ((0x000b  << 2) + 0xfe331800)
#define VAD_FIR_COEF7                              ((0x000c  << 2) + 0xfe331800)
#define VAD_FIR_COEF8                              ((0x000d  << 2) + 0xfe331800)
#define VAD_FIR_COEF9                              ((0x000e  << 2) + 0xfe331800)
#define VAD_FIR_COEF10                             ((0x000f  << 2) + 0xfe331800)
#define VAD_FIR_COEF11                             ((0x0010  << 2) + 0xfe331800)
#define VAD_FIR_COEF12                             ((0x0011  << 2) + 0xfe331800)
#define VAD_FRAME_CTRL0                            ((0x0012  << 2) + 0xfe331800)
#define VAD_FRAME_CTRL1                            ((0x0013  << 2) + 0xfe331800)
#define VAD_FRAME_CTRL2                            ((0x0014  << 2) + 0xfe331800)
#define VAD_CEP_CTRL0                              ((0x0015  << 2) + 0xfe331800)
#define VAD_CEP_CTRL1                              ((0x0016  << 2) + 0xfe331800)
#define VAD_CEP_CTRL2                              ((0x0017  << 2) + 0xfe331800)
#define VAD_CEP_CTRL3                              ((0x0018  << 2) + 0xfe331800)
#define VAD_CEP_CTRL4                              ((0x0019  << 2) + 0xfe331800)
#define VAD_CEP_CTRL5                              ((0x001a  << 2) + 0xfe331800)
#define VAD_DEC_CTRL                               ((0x001b  << 2) + 0xfe331800)
#define VAD_TOP_STS0                               ((0x001c  << 2) + 0xfe331800)
#define VAD_TOP_STS1                               ((0x001d  << 2) + 0xfe331800)
#define VAD_TOP_STS2                               ((0x001e  << 2) + 0xfe331800)
#define VAD_FIR_STS0                               ((0x001f  << 2) + 0xfe331800)
#define VAD_FIR_STS1                               ((0x0020  << 2) + 0xfe331800)
#define VAD_POW_STS0                               ((0x0021  << 2) + 0xfe331800)
#define VAD_POW_STS1                               ((0x0022  << 2) + 0xfe331800)
#define VAD_POW_STS2                               ((0x0023  << 2) + 0xfe331800)
#define VAD_FFT_STS0                               ((0x0024  << 2) + 0xfe331800)
#define VAD_FFT_STS1                               ((0x0025  << 2) + 0xfe331800)
#define VAD_SPE_STS0                               ((0x0026  << 2) + 0xfe331800)
#define VAD_SPE_STS1                               ((0x0027  << 2) + 0xfe331800)
#define VAD_SPE_STS2                               ((0x0028  << 2) + 0xfe331800)
#define VAD_SPE_STS3                               ((0x0029  << 2) + 0xfe331800)
#define VAD_DEC_STS0                               ((0x002a  << 2) + 0xfe331800)
#define VAD_DEC_STS1                               ((0x002b  << 2) + 0xfe331800)
#define VAD_LUT_CTRL                               ((0x002c  << 2) + 0xfe331800)
#define VAD_LUT_WR                                 ((0x002d  << 2) + 0xfe331800)
#define VAD_LUT_RD                                 ((0x002e  << 2) + 0xfe331800)
#define VAD_IN_SEL0                                ((0x002f  << 2) + 0xfe331800)
#define VAD_IN_SEL1                                ((0x0030  << 2) + 0xfe331800)
#define VAD_TO_DDR                                 ((0x0031  << 2) + 0xfe331800)
#define VAD_SYNC_CTRL0                             ((0x0032  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID0                         ((0x0033  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID1                         ((0x0034  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID2                         ((0x0035  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID3                         ((0x0036  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID4                         ((0x0037  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID5                         ((0x0038  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID6                         ((0x0039  << 2) + 0xfe331800)
#define VAD_SYNC_CHNUM_ID7                         ((0x003a  << 2) + 0xfe331800)
//
// Closing file:  VAD_REG.h
//
//========================================================================
//  AUDIO RESAMPLEA - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe331c00
// -----------------------------------------------
//
// Reading file:  RESAMPLE.h
//
#define AUDIO_RSAMP_CTRL0                          ((0x0000  << 2) + 0xfe331c00)
//Bit   31:3      reserved
//Bit   2         reg_lock_rst      //unsigned  , default =0;
//Bit   1         reg_rsamp_rst     //unsigned  , default =0;
//Bit   0         reg_sw_rst        //unsigned  , default =0;
#define AUDIO_RSAMP_CTRL1                          ((0x0001  << 2) + 0xfe331c00)
//Bit   31:27      reg_in_lsb        //unsigned  , default =0;
//Bit   26         reg_watchdog_en   //unsigned  , default =0;
//Bit   25         reg_rsamp_rst_sel //unsigned  , default =0;
//Bit   24         reg_module_bypas  //unsigned  , default =0;
//Bit   23:18      reg_gclk_ctrl     //unsigned  , default =0;
//Bit   17:13      reg_in_msb        //unsigned  , default =23;
//Bit   12         reg_output_en     //unsigned  , default =0;
//Bit   11         reg_rsamp_en      //unsigned  , default =0;
//Bit   10         reg_filt_en       //unsigned  , default =0;
//Bit   9          reg_post_en       //unsigned  , default =0;
//Bit   8          reg_inp_mux_mode  //unsigned  , default =0;
//Bit   7:5        reserved          //unsigned  , default =2;
//Bit   4:0        reg_inp_mux       //unsigned  , default =0;
#define AUDIO_RSAMP_CTRL2                          ((0x0002  << 2) + 0xfe331c00)
//Bit 31:30    reserved              //unsigned  , default =0;
//Bit 29:24    reg_chx_size          //unsigned  , default =2;
//Bit 23:18    reserved              //unsigned  , default =0;
//Bit 17:16    reg_scl_step          //unsigned  , default =0; 0: 1/1  1: 1/2  2: 1/4
//Bit 15:8     reg_filt_tap          //unsigned  , default =63;
//Bit 7:0      reg_intp_tap          //unsigned  , default =63;
#define AUDIO_RSAMP_PHSINIT                        ((0x0003  << 2) + 0xfe331c00)
//Bit   31:28      reserved          //unsigned  , default = 0;
//Bit   27:0       reg_init_phs      //unsigned  , default = 0;
#define AUDIO_RSAMP_PHSSTEP                        ((0x0004  << 2) + 0xfe331c00)
//Bit   31         reserved          //unsigned  , default = 0;
//Bit   30:0       reg_rsamp_step    //unsigned  , default = 134217728;//'h800_0000
#define AUDIO_RSAMP_SHIFT                          ((0x0005  << 2) + 0xfe331c00)
//Bit   31:24       reg_rsft_iir    //unsigned  , default = 23;
//Bit   23:16       reg_rsft_blnd   //unsigned  , default = 21;
//Bit   15:8        reg_rsft_sinc   //unsigned  , default = 31;
//Bit   7:0         reg_rsft_aa     //unsigned  , default = 31;
#define AUDIO_RSAMP_ADJ_CTRL0                      ((0x0006  << 2) + 0xfe331c00)
//Bit   31:7        reserved                //unsigned
//Bit   6           reg_lock_vld_sel        //unsigned , default = 0;
//Bit   5           reg_loop_dif_clr_en     //unsigned , default = 0;
//Bit   4           reg_aout_force_en       //unsigned , default = 0;
//Bit   3           reserved                //unsigned
//Bit   2           reg_rsamp_adj_out_inv   //unsigned , default = 0;
//Bit   1           reg_rsamp_adj_force_en  //unsigned , default = 0;
//Bit   0           reg_rsamp_adj_en        //unsigned , default = 0;
#define AUDIO_RSAMP_ADJ_CTRL1                      ((0x0007  << 2) + 0xfe331c00)
//Bit   31:16       reg_rsamp_adj_odet_step     //unsigned , default = 8;
//Bit   15:0        reg_rsamp_adj_kmax          //unsigned , default = 32768;
#define AUDIO_RSAMP_ADJ_SFT                        ((0x0008  << 2) + 0xfe331c00)
//Bit   31:30       reserved                //unsigned , default = 0;
//Bit   29          reg_rsamp_adj_dif_sel   //unsigned , default = 0;
//Bit   28:24       reg_rsamp_adj_ki        //unsigned , default = 9;
//Bit   23:21       reserved                //unsigned , default = 0;
//Bit   20:16       reg_rsamp_adj_kp        //unsigned , default = 1;
//Bit   15:13       reserved                //unsigned , default = 0;
//Bit   12:8        reg_rsamp_adj_ki_sft    //unsigned , default = 6;
//Bit   7:6         reserved                //unsigned , default = 0;
//Bit   5:0         reg_rsamp_adj_out_sft   //unsigned , default = 12;
#define AUDIO_RSAMP_ADJ_IDET_LEN                   ((0x0009  << 2) + 0xfe331c00)
//Bit   31:0       reg_rsamp_adj_idet_len       //unsigned , default = 10000;
#define AUDIO_RSAMP_ADJ_FORCE                      ((0x000a  << 2) + 0xfe331c00)
//Bit   31:0       reg_rsamp_adj_force_err      //signed , default = 8;
#define AUDIO_RSAMP_ADJ_KI_FORCE                   ((0x000b  << 2) + 0xfe331c00)
//Bit   31:0       reg_rsamp_adj_ki_force //signed , default = 0;
#define AUDIO_RSAMP_WATCHDOG_THRD                  ((0x000c  << 2) + 0xfe331c00)
//Bit   31:0       reg_watchdog_thrd      //signed , default = 32'h1000;
#define AUDIO_RSAMP_DBG_INFO                       ((0x000d  << 2) + 0xfe331c00)
//Bit   31:16      reg_aout_force_hi        //unsigned , default = 0;
//Bit   15:7       reserved                 //unsigned , default = 0;
//Bit   6          reg_rsamp_dbgcnt_clr     //unsigned , default = 0;
//Bit   5          reg_rsamp_dbgcnt_vldsel  //unsigned , default = 0;
//Bit   4          reg_rsamp_dbgcnt_en      //unsigned , default = 0;
//Bit   3          reserved                 //unsigned , default = 0;
//Bit   2:0        reg_watchdog_rstsel      //unsigned , default = 4;
#define AUDIO_RSAMP_AOUT_FORCE                     ((0x000e  << 2) + 0xfe331c00)
//Bit   31:0       reg_aout_force_lo        //unsigned , default = 0;
#define AUDIO_RSAMP_IRQ_CTRL                       ((0x000f  << 2) + 0xfe331c00)
//Bit   31:16      reg_irq_thrd             //unsigned , default = 0;
//Bit   15:12      reserved                 //unsigned , default = 0;
//Bit   11:8       reg_irq_sel              //unsigned , default = 0;
//Bit   7:4        reg_irq_clr              //unsigned , default = 0;
//Bit   3:0        reg_irq_en               //unsigned , default = 0;
#define AUDIO_RSAMP_RO_STATUS                      ((0x0010  << 2) + 0xfe331c00)
//Bit   31:0       ro_rsamp_stat  //{din_chx_chk_err,is_idle_st,rsamp_fifo_over_cnt[7:0]}
#define AUDIO_RSAMP_RO_ADJ_FREQ                    ((0x0011  << 2) + 0xfe331c00)
//Bit   31:0       ro_rsamp_adj_freq
#define AUDIO_RSAMP_RO_ADJ_DIFF_BAK                ((0x0012  << 2) + 0xfe331c00)
//Bit   31:0       ro_det_diff_bak
#define AUDIO_RSAMP_RO_ADJ_DIFF_DLT                ((0x0013  << 2) + 0xfe331c00)
//Bit   31:0       ro_det_diff_dlt
#define AUDIO_RSAMP_RO_ADJ_PHS_ERR                 ((0x0014  << 2) + 0xfe331c00)
//Bit   31:0       ro_det_phase_err
#define AUDIO_RSAMP_RO_ADJ_KI_OUT                  ((0x0015  << 2) + 0xfe331c00)
//Bit   31:0       ro_rsamp_ki_out
#define AUDIO_RSAMP_RO_IN_CNT                      ((0x0016  << 2) + 0xfe331c00)
//Bit   31:0       ro_rsamp_in_cnt
#define AUDIO_RSAMP_RO_OUT_CNT                     ((0x0017  << 2) + 0xfe331c00)
//Bit   31:0       ro_rsamp_out_cnt
#define AUDIO_RSAMP_RO_ADJ_PHS_ERR_VAR             ((0x0018  << 2) + 0xfe331c00)
//Bit   31:0       ro_det_phase_err_var
#define AUDIO_RSAMP_POST_COEF0                     ((0x0020  << 2) + 0xfe331c00)
//Bit   31:0       reg_post_coef0 //signed  , default = 0;
#define AUDIO_RSAMP_POST_COEF1                     ((0x0021  << 2) + 0xfe331c00)
//Bit   31:0       reg_post_coef1 //signed  , default = 0;
#define AUDIO_RSAMP_POST_COEF2                     ((0x0022  << 2) + 0xfe331c00)
//Bit   31:0       reg_post_coef2 //signed  , default = 0;
#define AUDIO_RSAMP_POST_COEF3                     ((0x0023  << 2) + 0xfe331c00)
//Bit   31:0       reg_post_coef3 //signed  , default = 0;
#define AUDIO_RSAMP_POST_COEF4                     ((0x0024  << 2) + 0xfe331c00)
//Bit   31:0       reg_post_coef4 //signed  , default = 0;
#define AUDIO_RSAMP_AA_COEF_ADDR                   ((0x0030  << 2) + 0xfe331c00)
//Bit   31:0       reg_aa_coef_addr     //unsigned, default = 0;
#define AUDIO_RSAMP_AA_COEF_DATA                   ((0x0031  << 2) + 0xfe331c00)
//Bit   31:0       reg_aa_coef_data     //signed  , default = 0;
#define AUDIO_RSAMP_SINC_COEF_ADDR                 ((0x0040  << 2) + 0xfe331c00)
//Bit   31:0       reg_sinc_coef_addr   //unsigned, default = 0;
#define AUDIO_RSAMP_SINC_COEF_DATA                 ((0x0041  << 2) + 0xfe331c00)
//Bit   31:0       reg_sinc_coef_data   //signed  , default = 0;
//
// Closing file:  RESAMPLE.h
//
//========================================================================
//  AUDIO EARCTX_CMDC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe333000
// -----------------------------------------------
//
// Reading file:  earc_tx_cmdc.h
//
#define EARC_TX_CMDC_TOP_CTRL0                     ((0x0030  << 2) + 0xfe333000)
//Bit   31   ,      idle2_int          unsigned, default = 0, 1: enable
//Bit   30   ,      idle1_int            unsigned, default = 0, 1: enable
//Bit   29   ,      disc2_int            unsigned, default = 0, 1: enable
//Bit   28   ,      disc1_int            unsigned, default = 0, 1: enable
//Bit   27   ,      earc_int             unsigned, default = 0, 1: enable
//Bit   26   ,      hb_status_int        unsigned, default = 0, 1: enable
//Bit   25   ,      losthb_int           unsigned, default = 0, 1: enable
//Bit   24   ,      timeout_int          unsigned, default = 0, 1: enable
//Bit   23   ,      status_ch_int        unsigned, default = 0, 1: enable
//Bit   22   ,      int_recv_finished  unsigned, default = 0, 1: enable
//Bit   21   ,      int_rdata          unsigned, default = 0, 1: enable
//Bit   20   ,      int_recv_nack       unsigned, default = 0, 1: enable
//Bit   19   ,      int_recv_norsp     unsigned, default = 0, 1: enable
//Bit   18   ,      int_recv_unexp     unsigned, default = 0, 1: enable
//Bit   17   ,      int_recv_data       unsigned, default = 0, 1: enable
//Bit   16   ,      int_recv_ack       unsigned, default = 0, 1: enable
//Bit   15   ,      int_recv_ecc_err   unsigned, default = 0, 1: enable
//Bit   14   ,      int_recv_packet    unsigned, default = 0, 1: enable
//Bit   13:0 ,      reserved
#define EARC_TX_CMDC_TOP_CTRL1                     ((0x0031  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_top_ctrl1     //unsigned, RW, default = 0,
#define EARC_TX_CMDC_TOP_CTRL2                     ((0x0032  << 2) + 0xfe333000)
//Bit   31   ,     reset_idle2_int              unsigned, default = 0, 1: enable
//Bit   30   ,     reset_idle1_int            unsigned, default = 0, 1: enable
//Bit   29   ,     reset_disc2_int            unsigned, default = 0, 1: enable
//Bit   28   ,     reset_disc1_int            unsigned, default = 0, 1: enable
//Bit   27   ,     reset_earc_int             unsigned, default = 0, 1: enable
//Bit   26   ,     reset_hb_status_int        unsigned, default = 0, 1: enable
//Bit   25   ,     reset_losthb_int           unsigned, default = 0, 1: enable
//Bit   24   ,     reset_timeout_int          unsigned, default = 0, 1: enable
//Bit   23   ,     reset_status_ch_int        unsigned, default = 0, 1: enable
//Bit   22   ,     reset_int_recv_finished        unsigned, default = 0, 1: enable
//Bit   21   ,     reset_int_rdata              unsigned, default = 0, 1: enable
//Bit   20   ,     reset_int_recv_nack       unsigned, default = 0, 1: enable
//Bit   19   ,     reset_int_recv_norsp         unsigned, default = 0, 1: enable
//Bit   18   ,     reset_int_recv_unexp         unsigned, default = 0, 1: enable
//Bit   17   ,     reset_int_recv_data       unsigned, default = 0, 1: enable
//Bit   16   ,     reset_int_recv_ack       unsigned, default = 0, 1: enable
//Bit   15   ,     reset_int_recv_ecc_err       unsigned, default = 0, 1: enable
//Bit   14   ,     reset_int_recv_packet        unsigned, default = 0, 1: enable
//Bit 13:0   ,     reserved
#define EARC_TX_CMDC_TIMER_CTRL0                   ((0x0033  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_timer_ctrl0   //unsigned, RW, default = 0,
#define EARC_TX_CMDC_TIMER_CTRL1                   ((0x0034  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_timer_ctrl1  //unsigned, RW, default = 0,
#define EARC_TX_CMDC_TIMER_CTRL2                   ((0x0035  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_timer_ctrl2  //unsigned, RW, default = 0,
#define EARC_TX_CMDC_TIMER_CTRL3                   ((0x0036  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_timer_ctrl3  //unsigned, RW, default = 0,
#define EARC_TX_CMDC_VSM_CTRL0                     ((0x0037  << 2) + 0xfe333000)
//Bit      31,      sw_state_update         unsigned, default = 0,  XX
//Bit      30:28,   sw_state                 unsigned, default = 0,  XX
//Bit      27,      arc_initiated             unsigned, default = 0,  XX
//Bit      26,      arc_terminated             unsigned, default = 0,  XX
//Bit      25,      arc_enable                 unsigned, default = 1,  XX
//Bit      24,      man_hpd                 unsigned, default = 0,  XX
//Bit      23:22,   hpd_sel                 unsigned, default = 0,  XX
//Bit      21:20,   hpd_sel_earc            unsigned, default = 0,  XX
//Bit      19,      comma_cnt_rst           unsigned, default = 0,  XX
//Bit      18,      timeout_status_rst      unsigned, default = 0,  XX
//Bit      17,      losthb_status_rst       unsigned, default = 0,  XX
//Bit      16,      force_rst               unsigned, default = 0,  XX
//Bit      15,      auto_state_en           unsigned, default = 0,  XX
//Bit      14,      cmdc_state_en             unsigned, default = 0,  XX
//Bit      13,      noack_repeat_en            unsigned, default = 0,  XX
//Bit    12:0,      reserved
#define EARC_TX_CMDC_VSM_CTRL1                     ((0x0038  << 2) + 0xfe333000)
//Bit    31:9,      reserved
//Bit       8,      cntl_hpd_sel            unsigned, default = 0, 0:sel hd_hpd,1:sel hdmirx_hpd
//Bit     7:0,      comma_cnt_th            unsigned, default = 0, should bigger than 3 and small than 10
#define EARC_TX_CMDC_VSM_CTRL2                     ((0x0039  << 2) + 0xfe333000)
//Bit    31:12,      max_count_th          unsigned, default = 0,  disc1 hpd_val timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  disc1 hpd_val timing
//Bit      6:4,      time_sel              unsigned, default = 0,  disc1 hpd_val timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  disc1 hpd_val timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  disc1 hpd_val timing
#define EARC_TX_CMDC_VSM_CTRL3                     ((0x003a  << 2) + 0xfe333000)
//Bit    31:12,      max_count_th          unsigned, default = 0,  disc2 heartbeat act timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  disc2 heartbeat act timing
//Bit      6:4,      time_sel              unsigned, default = 0,  disc2 heartbeat act timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  disc2 heartbeat act timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  disc2 heartbeat act timing
#define EARC_TX_CMDC_VSM_CTRL4                     ((0x003b  << 2) + 0xfe333000)
//Bit    31:12,      max_count_th          unsigned, default = 0,  in disc2, no heartbeat ack timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  in disc2, no heartbeat ack timing
//Bit      6:4,      time_sel              unsigned, default = 0,  in disc2, no heartbeat ack timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  in disc2, no heartbeat ack timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  in disc2, no heartbeat ack timing
#define EARC_TX_CMDC_VSM_CTRL5                     ((0x003c  << 2) + 0xfe333000)
//Bit    31:12,      max_count_th          unsigned, default = 0,  in disc1 and disc2 timing out
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  in disc1 and disc2 timing out
//Bit      6:4,      time_sel              unsigned, default = 0,  in disc1 and disc2 timing out
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  in disc1 and disc2 timing out
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  in disc1 and disc2 timing out
#define EARC_TX_CMDC_VSM_CTRL6                     ((0x003d  << 2) + 0xfe333000)
//Bit    31:12,      max_count_th          unsigned, default = 0,  in earc heartbeat act timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  in earc heartbeat act timing
//Bit      6:4,      time_sel              unsigned, default = 0,  in earc heartbeat act timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  in earc heartbeat act timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  in earc heartbeat act timing
#define EARC_TX_CMDC_VSM_CTRL7                     ((0x003e  << 2) + 0xfe333000)
//Bit    31:16,      reserved
//Bit     15:8,      status_soft_val       unsigned, default = 0,  in earc heartbeat det timing
//Bit        7,      reg_soft_rst          unsigned, default = 0,  in earc heartbeat det timing
//Bit        6,      status_rst            unsigned, default = 0,  in earc heartbeat det timing
//Bit      5:4,      reserved
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  in earc heartbeat det timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  in earc heartbeat det timing
#define EARC_TX_CMDC_VSM_CTRL8                     ((0x003f  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_vsm_ctrl8        //unsigned, RW, default = 0,
#define EARC_TX_CMDC_VSM_CTRL9                     ((0x0041  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_vsm_ctrl9        //unsigned, RW, default = 0
#define EARC_TX_CMDC_SENDER_CTRL0                  ((0x0042  << 2) + 0xfe333000)
//Bit      31:2,     sender_ctrl0                 unsigned,  default = 0,
//Bit      1,        hb_chg_conf_auto             unsigned,  default = 1,
//Bit      0,        hb_chg_auto                  unsigned,  default = 0,
#define EARC_TX_CMDC_PACKET_CTRL0                  ((0x0043  << 2) + 0xfe333000)
//Bit        31,      packet_mode_enable          unsigned, default = 0,  packet control
//Bit        30,      free_enable                 unsigned, default = 0,  packet control
//Bit        29,      soft_rst                    unsigned, default = 0,  packet control
//Bit     28:24,      tx_ready_threshold          unsigned, default = 0,  packet control
//Bit     23:20,      reserved
//Bit      19:8,      send_pre_threshold          unsigned, default = 0,  packet control
//Bit       7:6,      reserved
//Bit         5,      state_auto_en               unsigned, default = 0, packet control
//Bit         4,      sw_state_update_en          unsigned, default = 0,  packet control
//Bit       3:0,      sw_state_value              unsigned, default = 0,  packet control
#define EARC_TX_CMDC_PACKET_CTRL1                  ((0x0044  << 2) + 0xfe333000)
//Bit        31,      ecc_endian                  unsigned, default = 0,  send
//Bit        30,      pre_start_value             unsigned, default = 0,  send
//Bit     29:21,      reserved
//Bit     20:16,      post_threshold              unsigned, default = 0,  send
//Bit     15:14,      reserved
//Bit      13:8,      pre_threshold               unsigned, default = 0,  XX
//Bit       7:0,      post_flag                   unsigned, default = 0,  XX
#define EARC_TX_CMDC_PACKET_CTRL2                  ((0x0045  << 2) + 0xfe333000)
//Bit      31:0,      pre_flag                    unsigned, default = 0,  XX
#define EARC_TX_CMDC_PACKET_CTRL3                  ((0x0046  << 2) + 0xfe333000)
//Bit      31,       recv_en                      unsigned, default = 0,  XX
//Bit      30,       recv_parity_mask             unsigned, default = 0,  XX
//Bit      29,       recv_timeout_en              unsigned, default = 0,  XX
//Bit      28,       bch_ecc_en                   unsigned, default = 0, xx
//Bit     27:16,     reserved
//Bit      15:0,     recv_timeout_threshold       unsigned, default = 0,  XX
#define EARC_TX_CMDC_PACKET_CTRL4                  ((0x0047  << 2) + 0xfe333000)
//Bit     31:20,     reserved
//Bit      19:0,     recv_packet_head             unsigned, default = 0,  XX
#define EARC_TX_CMDC_PACKET_CTRL5                  ((0x0048  << 2) + 0xfe333000)
//Bit     31:20,     reserved
//Bit      19:0,     recv_packet_head_mask        unsigned, default = 0,  XX
#define EARC_TX_CMDC_PACKET_CTRL6                  ((0x0049  << 2) + 0xfe333000)
//Bit     31:20,     recv_pre_threshold          unsigned, default = 0,  packet control
//Bit      19:7,     reserved
//Bit         6,     recv_finished_int            unsigned, default = 0,  XX
//Bit         5,     recv_ecc_err_int             unsigned, default = 0,  XX
//Bit         4,     recv_ack_int                 unsigned, default = 0,  XX
//Bit         3,     recv_data_int                unsigned, default = 0,  XX
//Bit         2,     recv_unexp_int               unsigned, default = 0,  XX
//Bit         1,     recv_norsp_int               unsigned, default = 0,  XX
//Bit         0,     recv_nack_int                unsigned, default = 0,  XX
#define EARC_TX_CMDC_BIPHASE_CTRL0                 ((0x004a  << 2) + 0xfe333000)
//Bit     31:24,     reserved
//Bit     23:16,     ack delay threshold           unsigned, default = 0, xx
//Bit     15:10,     reserved
//Bit         9,     send_ack_en                   unsigned, default = 0,  xx
//Bit         8,     sq_val_en                     unsigned, default = 0,  XX
//Bit         7,     biphase_send_soft_rst         unsigned, default = 0,  XX
//Bit         6,     comma_soft_rst                unsigned, default = 0,  XX
//Bit         5,     fifo_rst                      unsigned, default = 0,  XX
//Bit         4,     receiver_no_sender            unsigned, default = 0,  XX
//Bit         3,     sender_free                   unsigned, default = 0,  XX
//Bit         2,     receiver_send                 unsigned, default = 0,  XX
//Bit         1,     receiver_earc                 unsigned, default = 0,  XX
//Bit         0,     receiver_free                 unsigned, default = 0,  XX
#define EARC_TX_CMDC_BIPHASE_CTRL1                 ((0x004b  << 2) + 0xfe333000)
//Bit     31:16,     reserved
//Bit        15,     ack_enable                    unsigned, default = 0,  send
//Bit      14:8,     reserved
//Bit       7:0,     wait_threshold before ack     unsigned, default = 0,  send
#define EARC_TX_CMDC_BIPHASE_CTRL2                 ((0x004c  << 2) + 0xfe333000)
//Bit        31,     comma_detection_enable        unsigned, default = 0, comma detection
//Bit        30,     manual_reset_enable           unsigned, default = 0, manual reset select, 1: manual
//Bit        29,     manual_reset_value            unsigned, default = 0, manual reset control
//Bit     28:16,     reserved
//Bit      15:0,     comma_detection_threshold     unsigned, default = 0,
#define EARC_TX_CMDC_BIPHASE_CTRL3                 ((0x004d  << 2) + 0xfe333000)
//Bit      31:0,     cmdc_biphase_ctrl3            unsigned, default = 0,
#define EARC_TX_CMDC_DEVICE_ID_CTRL                ((0x004e  << 2) + 0xfe333000)
//Bit        31,     apb_write                     unsigned, default = 0, apb bus wr/read
//Bit        30,     apb_read                      unsigned, default = 0, apb bus wr/read
//Bit        29,     apb_rw_done                  unsigned, default = 0, apb bus wr/read
//Bit        28,     apb_rw_reset                 unsigned, default = 0, apb bus wr/read
//Bit     27:17,     reserved
//Bit        16,     hpb_rst_enable               unsigned, default = 1, hpd rst enable
//Bit      15:8,     apb_rwid                    unsigned, default = 0, apb bus wr/read
//Bit       7:0,     apbrw_start_addr            unsigned, default = 0, apb bus wr/read
#define EARC_TX_CMDC_DEVICE_WDATA                  ((0x004f  << 2) + 0xfe333000)
//Bit      31:8,     reserved
//Bit       7:0,     apb_write_data                unsigned, default = 0, apb bus wr/read
#define EARC_TX_CMDC_DEVICE_RDATA                  ((0x0050  << 2) + 0xfe333000)
//Bit      31:8,     reserved
//Bit       7:0,     apb_read_data                 unsigned, default = 0, apb bus wr/read
#define EARC_TX_CMDC_MASTER_CTRL                   ((0x0051  << 2) + 0xfe333000)
//Bit        31,     master_cmd_rw                 unsigned, default = 0, 1 write 0 read
//Bit        30,     master_hb_ignore              unsigned, default =0, 0:wait hb issued before pkt cmd, 1: pkt cmd issued immediately
//Bit        29,     master_idle                   unsigned, default = 0, master status
//Bit        28,     master_cmd_soft_rst           unsigned, default= 0,
//Bit     27:24,     hb_cmd_cal_th                 unsigned, default= 0,
//Bit     23:16,     master_cmd_count              unsigned, default = 0, cmd count -1
//Bit      15:8,     master_cmd_id                 unsigned, default = 0,
//Bit       7:0,     master_cmd_address            unsigned, default = 0,
#define EARC_TX_ANA_CTRL0                          ((0x0052  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl0       //unsigned, RW, default = 0,
#define EARC_TX_ANA_CTRL1                          ((0x0053  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl1       //unsigned, RW, default = 0,
#define EARC_TX_ANA_CTRL2                          ((0x0054  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl2       //unsigned, RW, default = 0,
#define EARC_TX_ANA_CTRL3                          ((0x0055  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl3       //unsigned, RW, default = 0,
#define EARC_TX_ANA_CTRL4                          ((0x0056  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl4       //unsigned, RW, default = 0,
#define EARC_TX_ANA_CTRL5                          ((0x0057  << 2) + 0xfe333000)
//Bit      31:0,      reg_earctx_ana_ctrl5       //unsigned, RW, default = 0,
#define EARC_TX_ANA_STAT0                          ((0x0058  << 2) + 0xfe333000)
//Bit      31:0,     ro_ANA_status0              //unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS0                       ((0x0059  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status0              //unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS1                       ((0x005a  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status1              ///unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS2                       ((0x005b  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status2              ///unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS3                       ((0x005c  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status3              ///unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS4                       ((0x005d  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status4              ///unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS5                       ((0x005e  << 2) + 0xfe333000)
//Bit      31:0,     ro_cmdc_status5              ///unsigned, RO, default = 0,
#define EARC_TX_CMDC_STATUS6                       ((0x005f  << 2) + 0xfe333000)
//Bit   31   ,     ro_idle2_int            unsigned, RO, default = 0
//Bit   30   ,     ro_idle1_int            unsigned, RO, default = 0
//Bit   29   ,     ro_disc2_int            unsigned, RO, default = 0
//Bit   28   ,     ro_disc1_int            unsigned, RO, default = 0
//Bit   27   ,     ro_earc_int             unsigned, RO, default = 0
//Bit   26   ,     ro_hb_status_int        unsigned, RO, default = 0
//Bit   25   ,     ro_losthb_int           unsigned, RO, default = 0
//Bit   24   ,     ro_timeout_int          unsigned, RO, default = 0
//Bit   23   ,     ro_status_ch_int        unsigned, RO, default = 0
//Bit   22   ,     ro_int_recv_finished    unsigned, RO, default = 0
//Bit   21   ,     ro_int_rdata            unsigned, RO, default = 0
//Bit   20   ,     ro_int_recv_nack        unsigned, RO, default = 0
//Bit   19   ,     ro_int_recv_norsp       unsigned, RO, default = 0
//Bit   18   ,     ro_int_recv_unexp       unsigned, RO, default = 0
//Bit   17   ,     ro_int_recv_data        unsigned, RO, default = 0
//Bit   16   ,     ro_int_recv_ack         unsigned, RO, default = 0
//Bit   15   ,     ro_int_recv_ecc_err     unsigned, RO, default = 0
//Bit   14   ,     ro_int_recv_packet      unsigned, RO, default = 0
//Bit 13:0   ,     reserved
//
// Closing file:  earc_tx_cmdc.h
//
//========================================================================
//  AUDIO EARCTX_DMAC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe333400
// -----------------------------------------------
//
// Reading file:  earctx_dmac.h
//
#define EARCTX_DMAC_TOP_CTRL0                      ((0x0000  << 2) + 0xfe333400)
//Bit 31,       reg_top_reg_sync             ,default = 0,Bit 3:0 sync to clk10m,pluse auto clear
//Bit 30,       reg_top_soft_rst             ,default = 0
//Bit 29:26,    reserved
//Bit 25:24,    reg_debug_mux                ,default = 0
//Bit 23:21,    reserved
//Bit 20,       reg_slow_sync_scan_reg       ,default = 0
//Bit 19,       reg_fe_sf_scan_reg           ,default = 0
//Bit 18,       reg_fe_slow_sync_scan_reg    ,default = 0
//Bit 17,       reg_top_sf_scan_reg          ,default = 0
//Bit 16,       reg_top_slow_sync_scan_reg   ,default = 0
//Bit 15:4,     reserved
//Bit 3,        reg_spdif_tx_en_force        ,default = 0,spdif_tx_en force enable
//Bit 2,        reg_spdif_tx_en_force_value  ,default = 0,spdif_tx_en force value
//Bit 1,        reg_dmac_tx_en_force         ,default = 0,dmac_tx_en force enable
//Bit 0,        reg_dmac_tx_en_force_value   ,default = 0,dmac_tx_en force value
#define EARCTX_MUTE_VAL                            ((0x0001  << 2) + 0xfe333400)
//Bit 31:0,     reg_spdif_mute_val     ,default = 0,when biahpase encode mute,the channel value,with reg_mute_l/reg_mute_r
#define EARCTX_SPDIFOUT_GAIN0                      ((0x0002  << 2) + 0xfe333400)
//Bit 31:24,    reg_gain_ch3     ,default = 0,channel 3 gain
//Bit 23:16,    reg_gain_ch2     ,default = 0,channel 2 gain
//Bit 15:8,     reg_gain_ch1     ,default = 0,channel 1 gain
//Bit 7:0,      reg_gain_ch0     ,default = 0,channel 0 gain
#define EARCTX_SPDIFOUT_GAIN1                      ((0x0003  << 2) + 0xfe333400)
//Bit 31:24,    reg_gain_ch7     ,default = 0,channel 7 gain
//Bit 23:16,    reg_gain_ch6     ,default = 0,channel 6 gain
//Bit 15:8,     reg_gain_ch5     ,default = 0,channel 5 gain
//Bit 7:0,      reg_gain_ch4     ,default = 0,channel 4 gain
#define EARCTX_SPDIFOUT_CTRL0                      ((0x0004  << 2) + 0xfe333400)
//Bit 31,     reg_work_start      ,default = 0,biphase work start,pluse
//Bit 30,     reg_work_clr        ,default = 0,biphase work clear,pluse
//Bit 29,     reg_rst_afifo_out_n ,default = 0,afifo out reset
//Bit 28,     reg_rst_afifo_in_n  ,default = 0,afifo in reset
//Bit 27,     reg_hold_for_tdm    ,default = 0,add delay to mathc TDM out when share buff
//Bit 26,     reg_userdata_sel    ,default = 0,user Bit select : 0 from reg_userdata_set 1 from data[29]
//Bit 25,     reg_userdata_set    ,default = 0
//Bit 24,     reg_chdata_sel      ,default = 0,0 :from reg_chstst 1 from data[30]
//Bit 23,     reserved
//Bit 22,     reg_mute_l          ,default = 0,r channel mute ,with reg_mute_val
//Bit 21,     reg_mute_r          ,default = 0,l channel mute ,with reg_mute_val
//Bit 20,     reg_data_sel        ,default = 0,0 data from 31Bit 1 data from 27bit
//Bit 19,     reg_out_msb_first   ,default = 0,0 lsb first 1 msb first
//Bit 18,     reg_valid_sel       ,default = 0,biphase encode valid Bit value sel : 0 from data 1 from reg_valid_set
//Bit 17,     reg_valid_set       ,default = 0,biphase encode valid Bit value
//Bit 16,     reg_mute_hold_init_en  ,default = 0,when c_mute_hold_last_err_corrt valid,clear work enable, initial biphase encode
//Bit 15:12,  reserved
//Bit 0,      reg_parity_mask     ,default = 0,Bit 0 is initial parity value
#define EARCTX_SPDIFOUT_CTRL1                      ((0x0005  << 2) + 0xfe333400)
//Bit 31,     reg_eq_drc_sel      ,default = 0,set 1 select eq_drc data
//Bit 30,     reg_keep_req_ddr_init ,default = 0,reg_keep_req_ddr_init
//Bit 29:28,  reserved
//Bit 27,     reg_gain_en         ,default = 0,gain enable
//Bit 26:24,  reg_frddr_sel       ,default = 0,from ddr select
//Bit 23:16,  reg_wait_cnt        ,default = 0,wait some time when enable set to 1
//Bit 15:13,  reserved
//Bit 12:8,   reg_frddr_msb       ,default = 0,msb position of data
//Bit 7,      reg_force_start     ,default = 0,set 1 no need ack from frddr to transmit channel status
//Bit 6:4,    reg_frddr_type      ,default = 0
//Bit 3:0,    reserved
#define EARCTX_SPDIFOUT_PREAMB                     ((0x0006  << 2) + 0xfe333400)
//Bit 31,     reg_premable_Z_set      ,default = 0,user 8'b11101000 1 user 7:0
//Bit 30,     reg_premable_Y_set      ,default = 0,user 8'b11100100 1 user 15:8
//Bit 29,     reg_premable_X_set      ,default = 0,user 8'b11100010 1 user 23:16
//Bit 28:24,  reserved
//Bit 23:16,  reg_premable_X_value    ,default = 0
//Bit 15:8,   reg_premable_Y_value    ,default = 0
//Bit 7:0,    reg_premable_Z_value    ,default = 0
#define EARCTX_SPDIFOUT_SWAP                       ((0x0007  << 2) + 0xfe333400)
//Bit 31:16,  reg_hold_cnt        ,default = 0,hold start cnt ,valid when reg_hold_for_tdm set 1
//Bit 15,     reg_init_send_en    ,default = 0,send 01 sequence some times after initial done from frddr set
//Bit 14:0,   reg_init_send_cnt   ,default = 0,send 01 sequence time ,valid when reg_init_send_en set 1
#define EARCTX_ERR_CORRT_CTRL0                     ((0x0008  << 2) + 0xfe333400)
//Bit 31:24,  reserved
//Bit 23,     reg_bch_in_reverse       ,default = 0,bch input data generate in 24it data reverse
//Bit 22,     reg_bch_out_ecc_reverse  ,default = 0,bch output ecc  reverse
//Bit 21,     reg_bch_out_data_reverse ,default = 0,bch output data reverse
//Bit 20,     reg_bch_out_ecc_msb      ,default = 0,bch output ecc position
//Bit 19:17,  reserved
//Bit 16,     reg_ubit_fifo_init_n,default = 0,fifo in  initial
//Bit 15:14,  reserved
//Bit 13:12,  reg_gain_shift      ,default = 0,gain x 1/2/4/8
//Bit 11,     reg_mix_lr          ,default = 0,l/r mix
//Bit 10:8,   reg_spdifout_r_sel  ,default = 0,r channel select
//Bit 7,      reserved
//Bit 6:4,    reg_spdifout_l_sel  ,default = 0,l channel select
//Bit 3:0,    reg_iu_interval     ,default = 0,iu transmit interval
#define EARCTX_ERR_CORRT_CTRL1                     ((0x0009  << 2) + 0xfe333400)
//Bit 31,     reg_ubit_fifo_wr    ,default = 0,iu data write enable,pluse,auto clr in reg.v
//Bit 30:8,   reserved
//Bit 7:0,    reg_ubit_fifo_wdata ,default = 0,iu data
#define EARCTX_ERR_CORRT_CTRL2                     ((0x000a  << 2) + 0xfe333400)
//Bit 31,     reg_mute_clear       ,default = 0,mute clear,pluse,auto clr in reg.v
//Bit 30,     reg_mute_start       ,default = 0,mute start,pluse,auto clr in reg.v
//Bit 29:28,  reserved
//Bit 27:16,  reg_mute_block_num   ,default = 0,mute block number
//Bit 15:8,   reg_mute_ch_Bit      ,default = 0,mute Bit at channel statue which bit
//Bit 7:3,    reserved
//Bit 2,      reg_mute_data_sel    ,default = 0,mute data sel: 0 data 1 reg_mute_data_value
//Bit 1:0,    reg_mute_mode        ,default = 0,0:always mute 1:mute block number and dis mute 2:mute block number and hold bus
#define EARCTX_ERR_CORRT_CTRL3                     ((0x000b  << 2) + 0xfe333400)
//Bit 31:30,  reserved
//Bit 29,     reg_bch_en           ,default = 0,bch generate enable
//Bit 28:24,  reg_bch_msb          ,default = 0,bch data msb position in audio data
//Bit 23:0,   reg_mute_data_value  ,default = 0,mute value,only for audio data part
#define EARCTX_ERR_CORRT_CTRL4                     ((0x000c  << 2) + 0xfe333400)
//Bit 31,    reg_ubit_fifo_lr_swap        ,default = 0,//user Bit lr swap
//Bit 30,    reg_ubit_fifo_lr_same        ,default = 0,//l/r channel use same Bit user bit
//Bit 29:25, reg_data_msb                 ,default = 0,audio data msb postion in input data
//Bit 24,    reg_data_rsv                 ,default = 0,audio data msb/lsb
//Bit 23,    reg_ubit_value               ,default = 0,user Bit value
//Bit 22,    reg_vbit_value               ,default = 0,valid Bit value
//Bit 21,    reg_data_sel                 ,default = 0,//data sel: 0 data 1 reg_mute_data_value
//Bit 20:19, reg_ubit_sel                 ,default = 0,//userBit sel: 0 data 1 reg_value 2 fifo data
//Bit 18,    reg_vbit_sel                 ,default = 0,//validBit sel: 0 data 1 reg_value
//Bit 17,    reg_chst_sel                 ,default = 0,//channel status sel: 0 data 1 reg_value
//Bit 16,    reg_ubit_fifo_less_irq_en    ,default = 0,fifo_less_thd irq enable
//Bit 15:8,  reg_ubit_fifo_start_thd      ,default = 0,start transmit iu after fifo level greater than this value
//Bit 7:0,   reg_ubit_fifo_less_thd       ,default = 0,generate irq,when fifo level less than this value
#define EARCTX_ERR_CORRT_STAT0                     ((0x000d  << 2) + 0xfe333400)
//Bit 31:0,  ro_err_corrt_stat0          ,default = 0,
#define EARCTX_SPDIFOUT_CHSTS0                     ((0x000e  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[31:0]
#define EARCTX_SPDIFOUT_CHSTS1                     ((0x000f  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[63:32]
#define EARCTX_SPDIFOUT_CHSTS2                     ((0x0010  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[95:64]
#define EARCTX_SPDIFOUT_CHSTS3                     ((0x0011  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[127:96]
#define EARCTX_SPDIFOUT_CHSTS4                     ((0x0012  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[159:128]
#define EARCTX_SPDIFOUT_CHSTS5                     ((0x0013  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_a_status         ,default =0,channel A status[191:160]
#define EARCTX_SPDIFOUT_CHSTS6                     ((0x0014  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[31:0]
#define EARCTX_SPDIFOUT_CHSTS7                     ((0x0015  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[63:32]
#define EARCTX_SPDIFOUT_CHSTS8                     ((0x0016  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[95:64]
#define EARCTX_SPDIFOUT_CHSTS9                     ((0x0017  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[127:96]
#define EARCTX_SPDIFOUT_CHSTSA                     ((0x0018  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[159:128]
#define EARCTX_SPDIFOUT_CHSTSB                     ((0x0019  << 2) + 0xfe333400)
//Bit 31:0,  reg_changel_b_status         ,default =0,channel B status[191:160]
#define EARCTX_FE_CTRL0                            ((0x001a  << 2) + 0xfe333400)
//Bit 31,    reg_mute_hold_clr      ,default = 0,clear mute hold statues,pluse, auto clr
//Bit 30,    reg_work_enable        ,default = 0,wore enable
//Bit 29,    reg_dmac_invt          ,default = 0,fe out invent
//Bit 28,    reg_hold_time_en       ,default = 0,hold min time enable
//Bit 27,    reg_hold_soft_clr_en   ,default = 0,0 auto clear hold at next valid 1 clear hold with reg_mute_hold_clr
//Bit 26:24, reg_hold_time_tick_sel ,default = 0,hold min time tick select
//Bit 23:0,  reg_hold_min_time      ,default = 0,hold min time
#define EARCTX_FE_STAT0                            ((0x001b  << 2) + 0xfe333400)
//Bit 31:0,  ro_fe_stat0          ,default = 0,
#define EARCTX_SPDIFOUT_STAT                       ((0x001c  << 2) + 0xfe333400)
//Bit 31:0,  ro_spdifout_stat     ,default = 0,
#define EARCTX_SPDIFOUT_CTRL2                      ((0x001d  << 2) + 0xfe333400)
//Bit 31:28,  reserved
//Bit 27:16,  reg_clr_by_init      ,default = 0,reg_clr_by_init
//Bit 15:0 ,  reg_mask             ,default = 0,reg_mask
#define EARCTX_SPDIFOUT_GAIN2                      ((0x001e  << 2) + 0xfe333400)
//Bit 31:0,  spdifout_gain2        ,default = 0,spdifout gain2
#define EARCTX_SPDIFOUT_GAIN3                      ((0x001f  << 2) + 0xfe333400)
//Bit 31:0,  spdifout_gain3        ,default = 0,spdifout gain3
#define EARCTX_SPDIFOUT_GAIN4                      ((0x0020  << 2) + 0xfe333400)
//Bit 31:0,  spdifout_gain4        ,default = 0,spdifout gain4
#define EARCTX_SPDIFOUT_GAIN5                      ((0x0021  << 2) + 0xfe333400)
//Bit 31:0,  spdifout_gain5        ,default = 0,spdifout gain5
//
//
// Closing file:  earctx_dmac.h
//
//========================================================================
//  AUDIO EARCTX_TOP  - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xff603600
// -----------------------------------------------
//
// Reading file:  earctx_top.h
//
#define EARCTX_TOP_CTRL0                           ((0x0000  << 2) + 0xff603600)
//Bit   31:18,   reserved
//Bit   17:16,   reg_earctx_debug_mux     unsigned, default = 0, debug mux
//Bit   15,      reg_slow_sync_scan_reg   unsigned, default = 0, reg_slow_sync_scan_reg
//Bit   14:12,   reserved
//Bit   11,      reg_hdmi_hpd_invt        unsigned, default = 0, hdmi_hpd invent
//Bit   10,      reg_hdmi_hpd_value       unsigned, default = 0, hdmi_hpd mux = 3,register value
//Bit   9:8,     reg_hdmi_hpd_mux         unsigned, default = 0, hdmi_hpd mux
//Bit   7,       reg_earctx_hd_hpd_invt   unsigned, default = 0, earctx_hd_hdp invent
//Bit   6,       reg_earctx_hd_hpd_value  unsigned, default = 0, earctx_hd_hdp mux = 3,register value
//Bit   5:4,     reg_earctx_hd_hdp_mux    unsigned, default = 0, earctx_hd_hdp mux
//Bit   3:2,     reserved
//Bit   1,       reg_earctx_force_mode_en unsigned, default = 0, force mode enale
//Bit   0,       reg_earctx_force_mode    unsigned, default = 0, force mode value
#define EARCTX_DMAC_INT_MASK                       ((0x0001  << 2) + 0xff603600)
//Bit   31:6,  reserved
//Bit   5:0,   reg_dmac_int_mask             unsigned, default = 0, dmac int mask
#define EARCTX_DMAC_INT_PENDING                    ((0x0002  << 2) + 0xff603600)
//Bit   31:6,  reserved
//Bit   5:0,   reg_dmac_int_mask             unsigned, default = 0, dmac int pending,read only
#define EARCTX_CMDC_INT_MASK                       ((0x0003  << 2) + 0xff603600)
//Bit   31:18,  reserved
//Bit   17:0,   reg_cmdc_int_mask             unsigned, default = 0, cmdc int mask
#define EARCTX_CMDC_INT_PENDING                    ((0x0004  << 2) + 0xff603600)
//Bit   31:18,  reserved
//Bit   17:0,   reg_cmdc_int_mask             unsigned, default = 0, cmdc int pending,read only
#define EARCTX_ANA_CTRL0                           ((0x0005  << 2) + 0xff603600)
//Bit   31:0,   reg_earctx_ana_ctrl0          unsigned, default = 0
#define EARCTX_ANA_CTRL1                           ((0x0006  << 2) + 0xff603600)
//Bit   31:0,   reg_earctx_ana_ctrl0          unsigned, default = 0
#define EARCTX_ANA_CTRL2                           ((0x0007  << 2) + 0xff603600)
//Bit   31:0,   reg_earctx_ana_ctrl0          unsigned, default = 0
#define EARCTX_ANA_STAT0                           ((0x0008  << 2) + 0xff603600)
//Bit   31:0,   reg_earctx_ana_ctrl0          unsigned, default = 0
//
// Closing file:  earctx_top.h
//
//========================================================================
//  AUDIO EARCRX_CMDC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe333800
// -----------------------------------------------
//
// Reading file:  earc_rx_cmdc.h
//
#define EARC_RX_CMDC_TOP_CTRL0                     ((0x0000  << 2) + 0xfe333800)
//Bit   31   ,     idle2_int                 unsigned, default = 0, 1: enable
//Bit   30   ,     idle1_int     	         unsigned, default = 0, 1: enable
//Bit   29   ,     disc2_int     	         unsigned, default = 0, 1: enable
//Bit   28   ,     disc1_int     	         unsigned, default = 0, 1: enable
//Bit   27   ,     earc_int      	         unsigned, default = 0, 1: enable
//Bit   26   ,     hb_status_int 	         unsigned, default = 0, 1: enable
//Bit   25   ,     losthb_int    	         unsigned, default = 0, 1: enable
//Bit   24   ,     timeout_int   	         unsigned, default = 0, 1: enable
//Bit   23   ,     status_ch_int 	         unsigned, default = 0, 1: enable
//Bit   22   ,     int_rec_invalid_id        unsigned, default = 0, 1: enable
//Bit   21   ,     int_rec_invalid_offset    unsigned, default = 0, 1: enable
//Bit   20   ,     int_rec_unexp             unsigned, default = 0, 1: enable
//Bit   19   ,     int_rec_ecc_err           unsigned, default = 0, 1: enable
//Bit   18   ,     int_rec_parity_err        unsigned, default = 0, 1: enable
//Bit   17   ,     int_recv_packet           unsigned, default = 0, 1: enable
//Bit   16   ,     int_rec_time_out          unsigned, default = 0, 1: enable
//Bit   15   ,     cmdc_debug0               unsigned, default = 0, 1: enable
//Bit   14   ,     cmdc_debug1               unsigned, default = 0, 1: enable
//Bit   13   ,     cmdc_debug2               unsigned, default = 0, 1: enable
//Bit   12:7 ,     reserved
//Bit    6   ,     mute_select               unsigned, default = 0, 1: use bit5, 0: earc off
//Bit    5   ,     mute_contrl               unsigned, default = 0, value of manul mute control
//Bit    4:0 ,     reserved
#define EARC_RX_CMDC_TOP_CTRL1                     ((0x0001  << 2) + 0xfe333800)
//Bit      31:13,  reserved
//Bit      12:8,   reg_scan_reg             unsigned, RW, default = 0,
//Bit      7:5,    reserved
//Bit      4:0,    reg_top_soft_rst         unsigned, RW, default = 0,
#define EARC_RX_CMDC_TOP_CTRL2                     ((0x0002  << 2) + 0xfe333800)
//Bit      31,         reset_idle2_int                unsigned, default =0
//Bit      30,         reset_idle1_int                unsigned, default =0
//Bit      29,         reset_disc2_int                unsigned, default =0
//Bit      28,         reset_disc1_int                unsigned, default =0
//Bit      27,         reset_earc_int                 unsigned, default =0
//Bit      26,         reset_hb_status_int            unsigned, default =0
//Bit      25,         reset_losthb_int               unsigned, default =0
//Bit      24,         reset_timeout_int              unsigned, default =0
//Bit      23,         reset_status_ch_int            unsigned, default =0
//Bit      22,         reset_int_rec_invalid_id       unsigned, default =0
//Bit      21,         reset_int_rec_invalid_offset   unsigned, default =0
//Bit      20,         reset_int_rec_unexp            unsigned, default =0
//Bit      19,         reset_int_rec_ecc_err          unsigned, default =0
//Bit      18,         reset_int_rec_parity_err       unsigned, default =0
//Bit      17,         reset_int_recv_packet          unsigned, default =0
//Bit      16,         reset_int_rec_time_out         unsigned, default =0
//Bit      15:0,       reserved
#define EARC_RX_CMDC_TIMER_CTRL0                   ((0x0003  << 2) + 0xfe333800)
//Bit      31:0,   ro_cmdc_status0         unsigned, RO, default = 0,
#define EARC_RX_CMDC_TIMER_CTRL1                   ((0x0004  << 2) + 0xfe333800)
//Bit      31:0,   ro_cmdc_status0         unsigned, RO, default = 0,
#define EARC_RX_CMDC_TIMER_CTRL2                   ((0x0005  << 2) + 0xfe333800)
//Bit      31:0,    ro_cmdc_status0         unsigned, RO, default = 0,
#define EARC_RX_CMDC_TIMER_CTRL3                   ((0x0006  << 2) + 0xfe333800)
//Bit      31:0,    ro_cmdc_status0         unsigned, RO, default = 0,
#define EARC_RX_CMDC_VSM_CTRL0                     ((0x0007  << 2) + 0xfe333800)
//Bit      31,      sw_state_update         unsigned, default = 0,  XX
//Bit      30:28,   sw_state 		        unsigned, default = 0,  XX
//Bit      27,      arc_initiated 	        unsigned, default = 0,  XX
//Bit      26,      arc_terminated 	        unsigned, default = 0,  XX
//Bit      25,      arc_enable 		        unsigned, default = 0,  XX
//Bit      24,      man_hpd 		        unsigned, default = 0,  XX
//Bit      23:22,   hpd_sel 		        unsigned, default = 0,  XX
//Bit      21:20,   hpd_sel_earc            unsigned, default = 0,  XX
//Bit      19,      comma_cnt_rst           unsigned, default = 0,  XX
//Bit      18,      timeout_status_rst      unsigned, default = 0,  XX
//Bit      17,      losthb_status_rst       unsigned, default = 0,  XX
//Bit      16,      force_rst               unsigned, default = 0,  XX
//Bit      15,      auto_state              unsigned, default = 0,  XX
//Bit      14,      cmdc_state_en 	        unsigned, default = 0,  XX
//Bit    13:0,      reserved
#define EARC_RX_CMDC_VSM_CTRL1                     ((0x0008  << 2) + 0xfe333800)
//Bit    31:12,      max_count_th          unsigned, default = 0,  idle done timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  idle done timing
//Bit      6:4,      time_sel              unsigned, default = 0,  idle done timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  idle done timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  idle done timing
#define EARC_RX_CMDC_VSM_CTRL2                     ((0x0009  << 2) + 0xfe333800)
//Bit    31:12,      max_count_th          unsigned, default = 0,  comma off done timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  comma off done timing
//Bit      6:4,      time_sel              unsigned, default = 0,  comma off done timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  comma off done timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  comma off done timing
#define EARC_RX_CMDC_VSM_CTRL3                     ((0x000a  << 2) + 0xfe333800)
//Bit    31:12,      max_count_th          unsigned, default = 0,  earc_time out timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  earc_time out timing
//Bit      6:4,      time_sel              unsigned, default = 0,  earc_time out timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  earc_time out timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  earc_time out timing
#define EARC_RX_CMDC_VSM_CTRL4                     ((0x000b  << 2) + 0xfe333800)
//Bit    31:12,      max_count_th          unsigned, default = 0,  heartbeat lost timing
//Bit     11:8,      reserved
//Bit        7,      reg_soft_rst          unsigned, default = 0,  heartbeat lost timing
//Bit      6:4,      time_sel              unsigned, default = 0,  heartbeat lost timing
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  heartbeat lost timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  heartbeat lost timing
#define EARC_RX_CMDC_VSM_CTRL5                     ((0x000c  << 2) + 0xfe333800)
//Bit    31:16,      reserved
//Bit     15:8,      status_soft           unsigned, default = 0,  in earc heartbeat det timing
//Bit        7,      reg_soft_rst          unsigned, default = 0,  in earc heartbeat det timing
//Bit        6,      status_rst            unsigned, default = 0,  in earc heartbeat det timing
//Bit      5:4,      reserved
//Bit      3:2,      soft_rst_sel          unsigned, default = 0,  in earc heartbeat det timing
//Bit      1:0,      enable_ctrl           unsigned, default = 0,  in earc heartbeat det timing
#define EARC_RX_CMDC_VSM_CTRL6                     ((0x000d  << 2) + 0xfe333800)
//Bit    31:17,      reserved
//Bit        16,     cntl_hpd_sel          unsigned, default = 0,  in earc heartbeat det timing
//Bit      15:4,     cntl_hpd_valid_width  unsigned, default = 0,  in earc heartbeat det timing
//Bit      3:0,      cntl_hpd_glitch_width unsigned, default = 0,  in earc heartbeat det timing
#define EARC_RX_CMDC_VSM_CTRL7                     ((0x000e  << 2) + 0xfe333800)
//Bit      31:0,     vsm_ctrl7             unsigned,  default = 0,
#define EARC_RX_CMDC_VSM_CTRL8                     ((0x000f  << 2) + 0xfe333800)
//Bit      31:0,     vsm_ctrl8             unsigned,  default = 0,
#define EARC_RX_CMDC_VSM_CTRL9                     ((0x0010  << 2) + 0xfe333800)
//Bit      31:0,     vsm_ctrl9             unsigned,  default = 0,
#define EARC_RX_CMDC_SENDER_CTRL0                  ((0x0011  << 2) + 0xfe333800)
//Bit      31:2,     reserved
//Bit      1,        hb_chg_conf_auto          unsigned,  default = 0,
//Bit      0,        hb_chg_auto               unsigned,  default = 1,
#define EARC_RX_CMDC_PACKET_CTRL0                  ((0x0012  << 2) + 0xfe333800)
//Bit        31,      packet_mode_enable          unsigned, default = 0,  packet control
//Bit        30,      free_enable                 unsigned, default = 0,  packet control
//Bit        29,      soft_rst_man                unsigned, default = 0,  packet control
//Bit     28:24,      ready_th                    unsigned, default = 0,  packet control
//Bit     23:20,      reserved
//Bit      19:8,      send_pre_th                 unsigned, default = 0,  packet control
//Bit       7:5,      reserved
//Bit         4,      sw_state_update             unsigned, default = 0,  packet control
//Bit       3:0,      sw_state                    unsigned, default = 0,  packet control
#define EARC_RX_CMDC_PACKET_CTRL1                  ((0x0013  << 2) + 0xfe333800)
//Bit        31,      ecc_endian                  unsigned, default = 0,  send
//Bit        30,      pre_reg_st                  unsigned, default = 0,  send
//Bit     29:21,      reserved
//Bit     20:16,      post_th                     unsigned, default = 0,  send
//Bit     15:14,      reserved
//Bit      13:8,      pre_th                      unsigned, default = 0,
//Bit       7:0,      post_flag                   unsigned, default = 0,
#define EARC_RX_CMDC_PACKET_CTRL2                  ((0x0014  << 2) + 0xfe333800)
//Bit      31:0,      pre_flag                    unsigned, default = 0,  X
#define EARC_RX_CMDC_PACKET_CTRL3                  ((0x0015  << 2) + 0xfe333800)
//Bit      31,       cmdc_en                      unsigned, default = 0,  XX
//Bit      30,       cmdc_parity_mask             unsigned, default = 0,  XX
//Bit      29,       imeout_en                    unsigned, default = 0,  XX
//Bit      28,       ecc_check_en                 unsigned, default = 0,  XX
//Bit      27,       rev_debug_en                 unsigned, default = 0,  XX
//Bit     26:16,     reserved
//Bit      15:0,     timeout_th                   unsigned, default = 0,  X
#define EARC_RX_CMDC_PACKET_CTRL4                  ((0x0016  << 2) + 0xfe333800)
//Bit      31,       ack_ignore                   unsigned, default = 0,  XX
//Bit      30,       cmdc_tail_check_mask         unsigned, default = 0,  XX
//Bit     29:20,     reserved
//Bit      19:0,     cmdc_packet_head             unsigned, default = 0,  XX
#define EARC_RX_CMDC_PACKET_CTRL5                  ((0x0017  << 2) + 0xfe333800)
//Bit     31:24,     rev_debug_mask               unsigned, default = 0,  XX
//Bit     23:20,     reserved
//Bit      19:0,     cmdc_packet_head_mask        unsigned, default = 0,  XX
#define EARC_RX_CMDC_PACKET_CTRL6                  ((0x0018  << 2) + 0xfe333800)
//Bit     31:20,     recv_pre_threshold          unsigned, default = 0,  packet control
//Bit      19:9,     reserved
//Bit         8,     rec_packet_d                 unsigned, default = 0,  XX
//Bit         7,     rec_parity_err_cnt		      unsigned, default = 0,  XX
//Bit         6,     rec_ecc_err_cnt		      unsigned, default = 0,  XX
//Bit         5,     rec_unexp_cnt			      unsigned, default = 0,  XX
//Bit         4,     rec_invalid_offset_cnt	      unsigned, default = 0,  XX
//Bit         3,     rec_invalid_id_cnt		      unsigned, default = 0,  XX
//Bit         2,     rec_timeout_cnt		      unsigned, default = 0,  XX
//Bit         1,     rec_w_cnt				      unsigned, default = 0,  XX
//Bit         0,     rec_r_cnt				      unsigned, default = 0,  X
#define EARC_RX_CMDC_BIPHASE_CTRL0                 ((0x0019  << 2) + 0xfe333800)
//Bit     31:24,     reg_tns                       unsigned, default = 7, xx
//Bit     23:16,     delay_th                      unsigned, default = 0, xx
//Bit     15:10,     reserved
//Bit         9,     send_ack_en                   unsigned, default = 0,  xx
//Bit         8,     sq_val_en                     unsigned, default = 0,  XX
//Bit         7,     biphase_send_soft_rst         unsigned, default = 0,  XX
//Bit         6,     comma_soft_rst                unsigned, default = 0,  XX
//Bit         5,     fifo_rst                      unsigned, default = 0,  XX
//Bit         4,     receiver_no_sender            unsigned, default = 0,  XX
//Bit         3,     sender_free                   unsigned, default = 0,  XX
//Bit         2,     receiver_send                 unsigned, default = 0,  XX
//Bit         1,     receiver_earc                 unsigned, default = 0,  XX
//Bit         0,     receiver_free                 unsigned, default = 0,  XX
#define EARC_RX_CMDC_BIPHASE_CTRL1                 ((0x001a  << 2) + 0xfe333800)
//Bit     31:16,     reserved
//Bit        15,     ack_val_en                      unsigned, default = 0,  send
//Bit      14:8,     reserved
//Bit       7:0,     width                        unsigned, default = 0,  send
#define EARC_RX_CMDC_BIPHASE_CTRL2                 ((0x001b  << 2) + 0xfe333800)
//Bit      31,        ack_val_en                  unsigned, default = 0,  send
//Bit      30:20,     reserved
//Bit       19:16,    ack_rate                   unsigned, default = 0,  comma send
//Bit       15:0,     width                         unsigned, default = 0,  comma sen
#define EARC_RX_CMDC_BIPHASE_CTRL3                 ((0x001c  << 2) + 0xfe333800)
//Bit      31:0,     biphase_ctrl3                 unsigned, default = 0,
#define EARC_RX_CMDC_DEVICE_ID_CTRL                ((0x001d  << 2) + 0xfe333800)
//Bit        31,     apb_write                     unsigned, default = 0, apb bus wr/read
//Bit        30,     apb_read                      unsigned, default = 0, apb bus wr/read
//Bit        29,     apb_w_r_done                  unsigned, default = 0, apb bus wr/read
//Bit        28,     apb_w_r_reset                 unsigned, default = 0, apb bus wr/read
//Bit     27:16,     reserved
//Bit      15:8,     apb_w_r_id                    unsigned, default = 0, apb bus wr/read
//Bit       7:0,     apb_w_r_start_addr            unsigned, default = 0, apb bus wr/read
#define EARC_RX_CMDC_DEVICE_WDATA                  ((0x001e  << 2) + 0xfe333800)
//Bit      31:8,     reserved
//Bit       7:0,     apb_write_data                unsigned, default = 0, apb bus wr/rea
#define EARC_RX_CMDC_DEVICE_RDATA                  ((0x001f  << 2) + 0xfe333800)
//Bit      31:8,     reserved
//Bit       7:0,     apb_read_data                 unsigned, default = 0, apb bus wr/rea
#define EARC_RX_ANA_CTRL0                          ((0x0020  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl0                     unsigned, default = 0,
#define EARC_RX_ANA_CTRL1                          ((0x0021  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl1                     unsigned, default = 0,
#define EARC_RX_ANA_CTRL2                          ((0x0022  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl2                     unsigned, default = 0,
#define EARC_RX_ANA_CTRL3                          ((0x0023  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl3                     unsigned, default = 0,
#define EARC_RX_ANA_CTRL4                          ((0x0024  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl4                     unsigned, default = 0,
#define EARC_RX_ANA_CTRL5                          ((0x0025  << 2) + 0xfe333800)
//Bit      31:0,     ana_ctrl5                     unsigned, default = 0,
#define EARC_RX_ANA_STAT0                          ((0x0026  << 2) + 0xfe333800)
//Bit      31:0,     ro_ANA_status0              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS0                       ((0x0027  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status0              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS1                       ((0x0028  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status1              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS2                       ((0x0029  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status2              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS3                       ((0x002a  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status3              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS4                       ((0x002b  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status4              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS5                       ((0x002c  << 2) + 0xfe333800)
//Bit      31:0,     ro_cmdc_status5              unsigned, RO, default = 0,
#define EARC_RX_CMDC_STATUS6                       ((0x002d  << 2) + 0xfe333800)
//Bit      31,         ro_idle2_int                unsigned, RO, default =0
//Bit      30,         ro_idle1_int                unsigned, RO, default =0
//Bit      29,         ro_disc2_int                unsigned, RO, default =0
//Bit      28,         ro_disc1_int                unsigned, RO, default =0
//Bit      27,         ro_earc_int                 unsigned, RO, default =0
//Bit      26,         ro_hb_status_int            unsigned, RO, default =0
//Bit      25,         ro_losthb_int               unsigned, RO, default =0
//Bit      24,         ro_timeout_int              unsigned, RO, default =0
//Bit      23,         ro_status_ch_int            unsigned, RO, default =0
//Bit      22,         ro_int_rec_invalid_id       unsigned, RO, default =0
//Bit      21,         ro_int_rec_invalid_offset   unsigned, RO, default =0
//Bit      20,         ro_int_rec_unexp            unsigned, RO, default =0
//Bit      19,         ro_int_rec_ecc_err          unsigned, RO, default =0
//Bit      18,         ro_int_rec_parity_err       unsigned, RO, default =0
//Bit      17,         ro_int_recv_packet          unsigned, RO, default =0
//Bit      16,         ro_int_rec_time_out         unsigned, RO, default =0
//Bit      15:0,       reserved
//
// Closing file:  earc_rx_cmdc.h
//
//========================================================================
//  AUDIO EARCRX_DMAC - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe333c00
// -----------------------------------------------
//
// Reading file:  earcrx_dmac.h
//
#define EARCRX_DMAC_TOP_CTRL0                      ((0x0000  << 2) + 0xfe333c00)
//Bit   31,     reg_top_work_en               unsigned, default = 0, top work enable
//Bit   30,     reg_top_soft_rst              unsigned, default = 0, top soft reset
//Bit   29:23,  reserved
//Bit   22:20,  reg_dmac_debug_sel            unsigned, default = 0, dmac debug select
//Bit   19:18,  reserved
//Bit   17,     reg_dmac_valid_sel            unsigned, default = 0, dmac sync without clk
//Bit   16,     reg_dmac_without_clk          unsigned, default = 0, dmac sync without clk
//Bit   15,     reg_sf_sync_scan_reg          unsigned, default = 0, rst_n soft reset scan reg
//Bit   14,     reserved
//Bit   13,     reg_slow_sync_scan_reg        unsigned, default = 0, rst_n sync clk_slow scan reg
//Bit   12,     reg_a_sync_scan_reg           unsigned, default = 0, rst_n sync clk_analog scan reg
//Bit   11,     reg_slow_auto_gate            unsigned, default = 0, clk_slow auto gate
//Bit   10,     reg_a_auto_gate               unsigned, default = 0, clk_analog auto gate
//Bit   9:0,    reserved
#define EARCRX_DMAC_SYNC_CTRL0                     ((0x0001  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, dmac sync module work enable
//Bit   30,     reg_rst_afifo_out_n           unsigned, default = 0, afifo out reset
//Bit   29,     reg_rst_afifo_in_n            unsigned, default = 0, afifo in reset
//Bit   28:17,  reserved
//Bit   16,     reg_ana_buf_data_sel_en       unsigned, default = 0, data from analog delay enable
//Bit   15,     reserved
//Bit   14:12,  reg_ana_buf_data_sel          unsigned, default = 0, delay cycles
//Bit   11,     reserved
//Bit   10:8,   reg_ana_clr_cnt               unsigned, default = 0, valid last how many 0 will clear
//Bit   7,      reserved
//Bit   6:4,    reg_ana_set_cnt               unsigned, default = 0, valid last how may 1 will set
//Bit   3:1,    reserved
//Bit   0,      reg_dmacin_phase              unsigned, default = 0, dmac data invert
#define EARCRX_DMAC_SYNC_STAT0                     ((0x0002  << 2) + 0xfe333c00)
//Bit   31:0,   reg_dmac_sync_stat0           unsigned, default = 0
#define EARCRX_SPDIFIN_SAMPLE_CTRL0                ((0x0003  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, spdif in sample enable
//Bit   30,     reg_spdifin_phase             unsigned, default = 0, spdif in invert
//Bit   29,     reg_debug_en                  unsigned, default = 0, debug single enable
//Bit   28,     reg_width_sel                 unsigned, default = 0, 0 detect by max_width 1 detect by min_width
//Bit   27:23,  reserved
//Bit   22:20,  reg_sample_mode               unsigned, default = 0, value
//Bit   19:0,   reg_base_timer                unsigned, default = 0, base timer to detect sample mode change
#define EARCRX_SPDIFIN_SAMPLE_CTRL1                ((0x0004  << 2) + 0xfe333c00)
//Bit   31,     reg_force_sample_mode         unsigned, default = 0, 0 auto detect sample mode 1 force a fixed sample mode with reg_sample_mode
//Bit   30,     reserved
//Bit   29:20,  reg_sample_mode0_timer_th     unsigned, default = 0, mode0 threathold time
//Bit   19:10,  reg_sample_mode1_timer_th     unsigned, default = 0, mode1 threathold time
//Bit   9:0,    reg_sample_mode2_timer_th     unsigned, default = 0, mode2 threathold time
#define EARCRX_SPDIFIN_SAMPLE_CTRL2                ((0x0005  << 2) + 0xfe333c00)
//Bit   31:30,  reserved
//Bit   29:20,  reg_sample_mode3_timer_th     unsigned, default = 0, mode3 threathold time
//Bit   19:10,  reg_sample_mode4_timer_th     unsigned, default = 0, mode4 threathold time
//Bit   9:0,    reg_sample_mode5_timer_th     unsigned, default = 0, mode5 threathold time
#define EARCRX_SPDIFIN_SAMPLE_CTRL3                ((0x0006  << 2) + 0xfe333c00)
//Bit   31:24,  reg_sample_mode0_timer        unsigned, default = 0, mode0 sample time
//Bit   23:16,  reg_sample_mode1_timer        unsigned, default = 0, mode1 sample time
//Bit   15:8,   reg_sample_mode2_timer        unsigned, default = 0, mode2 sample time
//Bit   7:0,    reg_sample_mode3_timer        unsigned, default = 0, mode3 sample time
#define EARCRX_SPDIFIN_SAMPLE_CTRL4                ((0x0007  << 2) + 0xfe333c00)
//Bit   31:24,  reg_sample_mode4_timer        unsigned, default = 0, mode4 sample time
//Bit   23:16,  reg_sample_mode5_timer        unsigned, default = 0, mode5 sample time
//Bit   15:8,   reg_sample_mode6_timer        unsigned, default = 0, mode6 sample time
//Bit   7:0,    reserved
#define EARCRX_SPDIFIN_SAMPLE_CTRL5                ((0x0008  << 2) + 0xfe333c00)
//Bit   31,     reg_sq_filt_en                unsigned, default = 0, dmac_sqout filter enable
//Bit   30,     reg_spdif_sqout_phase         unsigned, default = 0, dmac_sqout invert
//Bit   29:27,  reg_filter_tick_sel           unsigned, default = 0, dmac_sqout filter tick select
//Bit   26:24,  reg_filter_sel                unsigned, default = 0, dmac_sqout filter select
//Bit   23:20,  reserved
//Bit   19:0,   reg_sq_filt_timer             unsigned, default = 0, dmac_sqout filter tick
#define EARCRX_SPDIFIN_SAMPLE_STAT0                ((0x0009  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_sample_stat0      unsigned, default = 0
#define EARCRX_SPDIFIN_SAMPLE_STAT1                ((0x000a  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_sample_stat1      unsigned, default = 0
#define EARCRX_SPDIFIN_MUTE_VAL                    ((0x000b  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_mute_val          unsigned, default = 0, spdif in mute value
#define EARCRX_SPDIFIN_CTRL0                       ((0x000c  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, spdifin wore enable
//Bit   30,     reg_chnum_sel                 unsigned, default = 0, 0 ch_num = 0~383  1 ch_num = 0~1
//Bit   29:28,  reserved
//Bit   27,     reg_debug_en                  unsigned, default = 0, debug enable
//Bit   26,     reg_chnum_en                  unsigned, default = 0, star add ch_cnt to ch_num
//Bit   25,     reg_findpapb_en               unsigned, default = 0, papb check enalbe
//Bit   24,     reg_nonpcm2pcm_en             unsigned, default = 0, nonpcm2pcm_th enable
//Bit   23:12,  reg_nonpcm2pcm_th             unsigned, default = 0, if long time didn't detect PaPb again,will generate irq
//Bit   11:8,   reg_ch_status_sel             unsigned, default = 0, for stat1/stat2
//Bit   7,      reg_mute_l                    unsigned, default = 0, mute channel l
//Bit   6,      reg_mute_r                    unsigned, default = 0, mute channel r
//Bit   5:4,    reserved
//Bit   3,      reg_check_valid               unsigned, default = 0, valid check enable
//Bit   2,      reg_check_parity              unsigned, default = 0, parity check enable
//Bit   1,      reg_invert_data               unsigned, default = 0, spdif data invert
//Bit   0,      reserved
#define EARCRX_SPDIFIN_CTRL1                       ((0x000d  << 2) + 0xfe333c00)
//Bit   31:24,  reserved
//Bit   31:24,  reg_clr_internal_sts          unsigned, default = 0, internal irq status clear
//Bit   23:12,  reg_mute_block_check_thd      unsigned, default = 0, mute block check time thd
//Bit   11:9,   reg_mute_block_check_tick_sel unsigned, default = 0, mute block check tick sel
//Bit   8,      reg_papb_ext_sync             unsigned, default = 0, ext 0 sync check for papb
//Bit   7:0,    reg_papb_ext_mask             unsigned, default = 0, sync 0 mask
#define EARCRX_SPDIFIN_CTRL2                       ((0x000e  << 2) + 0xfe333c00)
//Bit   31:24,  reg_mute_bit                   unsigned, default = 0, mute bit in channel st
//Bit   23:19,  reg_mute_block_num             unsigned, default = 0, mute min block number to declare
//Bit   18,     reg_mute_lr_ch_sel             unsigned, default = 0, mute bit in channel st L or R
//Bit   17,     reg_mute_block_check_en        unsigned, default = 0, mute block number check enable
//Bit   16,     reg_earc_cps_chst_clr_en       unsigned, default = 0, auto clear compress mode when channel status not compress
//Bit   15,     reg_earc_cps_nonpcm2pcm_clr_en unsigned, default = 0, auto clear compress mode when nonpcm2pcm
//Bit   14,     reg_earc_auto                  unsigned, default = 0, auto change earc/arc
//Bit   13,     reg_earcin_papb_lr             unsigned, default = 0, user l or r channle status to check papb
//Bit   12,     reg_earcin_check_papb          unsigned, default = 0, 0:data valid after 1 block;1: in 1st block if exit papb ,data valid after papb
//Bit   11,     reg_earcin_start_papb          unsigned, default = 0, start write toddr 1:from papb check,0 from preamble Z,valid when reg_earcin_check_papb set
//Bit   10,     reg_formatchange_auto_rst      unsigned, default = 0, auto reset will detect format change
//Bit   9,      reg_earcin_cpsb_pcpd_sel      unsigned, default = 0, compress B pcpd select : 1:next 4th subframe data 0:next sub frame data
//Bit   8:4,    reg_earc_papb_msb             unsigned, default = 0, papb msb position in data
//Bit   3,      reg_earcin_spdif_force        unsigned, default = 0, when in arc mode,spdif on force enable
//Bit   2,      reg_earcin_spdif_force_set    unsigned, default = 0, force value
//Bit   1,      reg_earcin_mode_force         unsigned, default = 0, earc mode force enable
//Bit   0,      reg_earcin_mode_force_set     unsigned, default = 0, force value
#define EARCRX_SPDIFIN_CTRL3                       ((0x000f  << 2) + 0xfe333c00)
//Bit   31:16,  reg_earc_pa_value             unsigned, default = 0, earc mode pa value
//Bit   15:0,   reg_earc_pb_value             unsigned, default = 0, earc mode pb value
#define EARCRX_SPDIFIN_STAT0                       ((0x0010  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_stat0             unsigned, default = 0
#define EARCRX_SPDIFIN_STAT1                       ((0x0011  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_stat1             unsigned, default = 0
#define EARCRX_SPDIFIN_STAT2                       ((0x0012  << 2) + 0xfe333c00)
//Bit   31:0,   reg_spdifin_stat2             unsigned, default = 0
#define EARCRX_DMAC_UBIT_CTRL0                     ((0x0013  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, dmac user bit decode enable
//Bit   30:24,  reg_iu_sync                   unsigned, default = 0, iu sync value
//Bit   23:16,  reg_fifo_thd                  unsigned, default = 0, generate irq when fifo level pass some threshold
//Bit   15,     reg_max_dist_en               unsigned, default = 0, max distance bewteen IUs to set lost
//Bit   14,     reg_iu_sync_en                unsigned, default = 0, iu sync code enable 0 : all iu to fifo 1 only sync iu packet to fifo
//Bit   13:12,  reg_user_lr                   unsigned, default = 0, 00 off 01 use l channel userbit 10 use r channel userbit 11 user lr channel userbit
//Bit   11:8,   reg_max_dist                  unsigned, default = 0, max distance bewteen IUs value
//Bit   7,      reg_fifo_thd_en               unsigned, default = 0, fifo_thd irq enable
//Bit   6,      reg_fifo_lost_init_en         unsigned, default = 0, when lost,initial fifo
//Bit   5,      reg_fifo_init                 unsigned, default = 0, fifo initial
//Bit   4:0,    reg_data_bit                  unsigned, default = 0, user bit position in data
#define EARCRX_IU_RDATA                            ((0x0014  << 2) + 0xfe333c00)
//Bit   31:8,   reserved
//Bit   7:0,    i_iu_rdata                    unsigned, default = 0, iu data,read only
#define EARCRX_DMAC_UBIT_STAT0                     ((0x0015  << 2) + 0xfe333c00)
//Bit   31:0,   reg_dmac_ubit_stat0           unsigned, default = 0
#define EARCRX_ERR_CORRECT_CTRL0                   ((0x0016  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, err correct work enable
//Bit   30,     reserved
//Bit   29,     reg_rst_afifo_out_n           unsigned, default = 0, reset afifo out side
//Bit   28,     reg_rst_afifo_in_n            unsigned, default = 0, reset afifo in side
//Bit   27,     reg_lr_check                  unsigned, default = 0, enable lr_check
//Bit   26:7,   reserved
//Bit   6,      reg_bchout_data_ml            unsigned, default = 0, bch output 16bit data msb is 27 or 19
//Bit   5,      reg_bchout_data_rsv           unsigned, default = 0, bch output data revers
//Bit   4,      reg_bchin_ecc_ml              unsigned, default = 0, bch input ecc msb/lsb
//Bit   3,      reg_bchin_ecc_rsv             unsigned, default = 0, bch input ecc revers
//Bit   2,      reg_bchin_data_rsv            unsigned, default = 0, bch input data revers
//Bit   1,      reg_force_set                 unsigned, default = 0, 0 off 1 compress audio mode
//Bit   0,      reg_force_en                  unsigned, default = 0, force work mode enable
#define EARCRX_ERR_CORRECT_STAT0                   ((0x0017  << 2) + 0xfe333c00)
//Bit   31:0,   reg_err_correct_stat0         unsigned, default = 0
#define EARCRX_ANA_RST_CTRL0                       ((0x0018  << 2) + 0xfe333c00)
//Bit   31,     reg_work_enable               unsigned, default = 0, analog reset check work enable
//Bit   30,     reg_ana_rst_sf_en             unsigned, default = 0, analog reset from register enable
//Bit   29,     reg_ana_rst_sf                unsigned, default = 0, soft reset value
//Bit   28,     reserved
//Bit   27:23,  reg_new_format_pos_num        unsigned, default = 0, when new format data in, hold reset after N posedge
//Bit   22:20,  reg_dmacrx_div2_thd_tick_sel  unsigned, default = 0, earcrx_div2 hold threshold tick select
//Bit   19:0,   reg_earcrx_div2_thd           unsigned, default = 0, earcrx_div2 hold threshold
#define EARCRX_ANA_RST_CTRL1                       ((0x0019  << 2) + 0xfe333c00)
//Bit   31,     reg_dmacrx_data_filt_en       unsigned, default = 0, filter enable
//Bit   30:28,  reg_dmacrx_data_filter_sel    unsigned, default = 0, filter select
//Bit   27:25,  reg_dmacrx_data_tick_sel      unsigned, default = 0, filter tick sel
//Bit   24:16,  reg_dmacrx_data_time          unsigned, default = 0, filter tick time
//Bit   15,     reg_dmacrx_sqout_filt_en      unsigned, default = 0, filter enable
//Bit   14:12,  reg_dmacrx_sqout_filter_sel   unsigned, default = 0, filter select
//Bit   11:9,   reg_dmacrx_sqout_tick_sel     unsigned, default = 0, filter tick sel
//Bit   8:0,    reg_dmacrx_sqout_time         unsigned, default = 0, filter tick time
#define EARCRX_SPDIFIN_CTRL4                       ((0x0020  << 2) + 0xfe333c00)
//Bit   31,     reserved
//Bit   30,     reg_add_ch_r                        unsigned, default = 0, reg_add_ch_r
//Bit   29,     reg_bc_val0_en                      unsigned, default = 0, reg_bc_val0_en
//Bit   28:20,  reg_stable_mask                     unsigned, default = 0, reg_stable_mask
//Bit   19:16,  reg_stable_zcnt                     unsigned, default = 0, reg_stable_zcnt
//Bit   15:0 ,  reserved
#define EARCRX_SPDIFIN_CTRL5                       ((0x0021  << 2) + 0xfe333c00)
//Bit   31,     reg_st_timeout_sts_clr              unsigned, default = 0, reg_st_timeout_sts_clr
//Bit   30:28,  reserved
//Bit   27:16,  reg_st_timeout_check_thd            unsigned, default = 0, reg_st_timeout_check_thd
//Bit   15,     reserved
//Bit   14:12,  reg_st_timeout_check_tick_sel       unsigned, default = 0, reg_st_timeout_check_tick_sel
//Bit   11,     reg_st_timeout_check_en             unsigned, default = 0, reg_st_timeout_check_en
//Bit   10:9,   reserved
//Bit   8:0,    reg_stable_int_mask                 unsigned, default = 0, reg_stable_int_mask
#define EARCRX_SPDIFIN_CTRL6                       ((0x0022  << 2) + 0xfe333c00)
//Bit   31:17,  reserved
//Bit   16,     reg_check_time_en                   unsigned, default = 0, reg_check_time_en
//Bit   15:0,   reg_check_time_thd                  unsigned, default = 0, reg_check_time_thd
#define EARCRX_DMAC_SYNC_CTRL1                     ((0x0023  << 2) + 0xfe333c00)
//Bit   31:19,  reserved
//Bit   18,     reg_auto_neg_int_en                 unsigned, default = 0, reg_auto_neg_int_en
//Bit   17,     reg_auto_stable_clr                 unsigned, default = 0, reg_auto_stable_clr
//Bit   16,     reg_auto_stable_en                  unsigned, default = 0, reg_auto_stable_en
//Bit   15:0,   reg_auto_stable_thd                 unsigned, default = 0, reg_auto_stable_thd
#define EARCRX_SPDIFIN_SAMPLE_CTRL6                ((0x0024  << 2) + 0xfe333c00)
//Bit   31:18,  reserved
//Bit   17,     reg_hold_tri_sample                 unsigned, default = 0, reg_hold_tri_sample
//Bit   16,     reg_sample_mode_filter_en           unsigned, default = 0, reg_sample_mode_filter_en
//Bit   15:8,   reg_stable_cyc_min                  unsigned, default = 0, reg_stable_cyc_min
//Bit   7:0,    reg_stable_cyc_max                  unsigned, default = 0, reg_stable_cyc_max
#define EARCRX_DMAC_SYNC_CTRL2                     ((0x0025  << 2) + 0xfe333c00)
//Bit   31,     reg_unstable_t0_err_clr             unsigned, default = 0, reg_unstable_t0_err_clr
//Bit   30:20,  reserved
//Bit   19,     reg_unstable_t0_check_en            unsigned, default = 0, reg_unstable_t0_check_en
//Bit   18:16,  reg_unstable_t0_tick_sel            unsigned, default = 0, reg_unstable_t0_tick_sel
//Bit   15:0,   reg_unstable_t0_thd                 unsigned, default = 0, reg_unstable_t0_thd
#define EARCRX_DMAC_SYNC_CTRL3                     ((0x0026  << 2) + 0xfe333c00)
//Bit   31,     reg_unstable_t1_err_clr             unsigned, default = 0, reg_unstable_t1_err_clr
//Bit   30:20,  reserved
//Bit   19,     reg_unstable_t1_check_en            unsigned, default = 0, reg_unstable_t1_check_en
//Bit   18:16,  reg_unstable_t1_tick_sel            unsigned, default = 0, reg_unstable_t1_tick_sel
//Bit   15:0,   reg_unstable_t1_thd                 unsigned, default = 0, reg_unstable_t1_thd
#define EARCRX_DMAC_SYNC_CTRL4                     ((0x0027  << 2) + 0xfe333c00)
//Bit   31,     reg_unstable_t2_err_clr             unsigned, default = 0, reg_unstable_t2_err_clr
//Bit   30:20,  reserved
//Bit   19,     reg_unstable_t2_check_en            unsigned, default = 0, reg_unstable_t2_check_en
//Bit   18:16,  reg_unstable_t2_tick_sel            unsigned, default = 0, reg_unstable_t2_tick_sel
//Bit   15:0,   reg_unstable_t2_thd                 unsigned, default = 0, reg_unstable_t2_thd
#define EARCRX_DMAC_SYNC_STAT1                     ((0x0028  << 2) + 0xfe333c00)
//Bit   31:0,   reg_dmac_sync_stat1           unsigned, default = 0
#define EARCRX_DMAC_SYNC_STAT2                     ((0x0029  << 2) + 0xfe333c00)
//Bit   31:0,   reg_dmac_sync_stat2           unsigned, default = 0
#define EARCRX_DMAC_SYNC_STAT3                     ((0x002a  << 2) + 0xfe333c00)
//Bit   31:0,   reg_dmac_sync_stat3           unsigned, default = 0
//
// Closing file:  earcrx_dmac.h
//
//========================================================================
//  AUDIO EARCRX_TOP  - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe333e00
// -----------------------------------------------
//
// Reading file:  earcrx_top.h
//
#define EARCRX_TOP_CTRL0                           ((0x0000  << 2) + 0xfe333e00)
//Bit   31:10,  reserved
//Bit   9:8,    reg_top_debug_sel             unsigned, default = 0, top debug select
//Bit   7,      reg_spdif_rx_en_force         unsigned, default = 0, force spdif_rx_en to reg_spdif_rx_en_force_value
//Bit   6,      reg_spdif_rx_en_force_value   unsigned, default = 0, value
//Bit   5,      reg_spdif_rx_sqen_force       unsigned, default = 0, force spdif_rx_sqen to reg_spdif_rx_sqe
//Bit   4,      reg_spdif_rx_sqen_force_value unsigned, default = 0, value
//Bit   3,      reg_dmacrx_en_force           unsigned, default = 0, force dmacrx_en to reg_dmacrx_en_force_value
//Bit   2,      reg_dmacrx_en_force_value     unsigned, default = 0, value
//Bit   1,      reg_dmacrx_sqen_force         unsigned, default = 0, force dmacrx_sqen to reg_dmacrx_sqen_force_value
//Bit   0,      reg_dmacrx_sqen_force_value   unsigned, default = 0, value
#define EARCRX_DMAC_INT_MASK                       ((0x0001  << 2) + 0xfe333e00)
//Bit   31:30,  reserved
//Bit   29:0,   reg_dmac_int_mask             unsigned, default = 0, dmac int mask
#define EARCRX_DMAC_INT_PENDING                    ((0x0002  << 2) + 0xfe333e00)
//Bit   31:30,  reserved
//Bit   29:0,   reg_dmac_int_mask             unsigned, default = 0, dmac int pending,read only
#define EARCRX_CMDC_INT_MASK                       ((0x0003  << 2) + 0xfe333e00)
//Bit   31:16,  reserved
//Bit   15:0,   reg_cmdc_int_mask             unsigned, default = 0, cmdc int mask
#define EARCRX_CMDC_INT_PENDING                    ((0x0004  << 2) + 0xfe333e00)
//Bit   31:18,  reserved
//Bit   17:0,   reg_cmdc_int_mask             unsigned, default = 0, cmdc int pending,read only
#define EARCRX_ANA_CTRL0                           ((0x0005  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_ANA_CTRL1                           ((0x0006  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_ANA_STAT0                           ((0x0007  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_PLL_CTRL0                           ((0x0008  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_PLL_CTRL1                           ((0x0009  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_PLL_CTRL2                           ((0x000a  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_PLL_CTRL3                           ((0x000b  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
#define EARCRX_PLL_STAT0                           ((0x000c  << 2) + 0xfe333e00)
//Bit   31:0,   reg_earcrx_ana_ctrl0          unsigned, default = 0
//
// Closing file:  earcrx_top.h
//
//========================================================================
//  AUDIO RESAMPLEB - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe334000
// -----------------------------------------------
//
// Reading file:  RESAMPLEB.h
//
#define AUDIO_RSAMPB_CTRL0                         ((0x0000  << 2) + 0xfe334000)
//Bit   31:3      reserved
//Bit   2         reg_lock_rst      //unsigned  , default =0;
//Bit   1         reg_rsamp_rst     //unsigned  , default =0;
//Bit   0         reg_sw_rst        //unsigned  , default =0;
#define AUDIO_RSAMPB_CTRL1                         ((0x0001  << 2) + 0xfe334000)
//Bit   31:27      reserved          //unsigned  , default =0;
//Bit   26         reg_watchdog_en   //unsigned  , default =0;
//Bit   25         reg_rsamp_rst_sel //unsigned  , default =0;
//Bit   24         reg_module_bypas  //unsigned  , default =0;
//Bit   23:18      reg_gclk_ctrl     //unsigned  , default =0;
//Bit   17:13      reg_in_msb        //unsigned  , default =23;
//Bit   12         reg_output_en     //unsigned  , default =0;
//Bit   11         reg_rsamp_en      //unsigned  , default =0;
//Bit   10         reg_filt_en       //unsigned  , default =0;
//Bit   9          reg_post_en       //unsigned  , default =0;
//Bit   8          reg_inp_mux_mode  //unsigned  , default =0;
//Bit   7:4        reserved          //unsigned  , default =2;
//Bit   3:0        reg_inp_mux       //unsigned  , default =0;
#define AUDIO_RSAMPB_CTRL2                         ((0x0002  << 2) + 0xfe334000)
//Bit 31:30    reserved              //unsigned  , default =0;
//Bit 29:24    reg_chx_size          //unsigned  , default =2;
//Bit 23:18    reserved              //unsigned  , default =0;
//Bit 17:16    reg_scl_step          //unsigned  , default =0; 0: 1/1  1: 1/2  2: 1/4
//Bit 15:8     reg_filt_tap          //unsigned  , default =63;
//Bit 7:0      reg_intp_tap          //unsigned  , default =63;
#define AUDIO_RSAMPB_PHSINIT                       ((0x0003  << 2) + 0xfe334000)
//Bit   31:28      reserved          //unsigned  , default = 0;
//Bit   27:0       reg_init_phs      //unsigned  , default = 0;
#define AUDIO_RSAMPB_PHSSTEP                       ((0x0004  << 2) + 0xfe334000)
//Bit   31         reserved          //unsigned  , default = 0;
//Bit   30:0       reg_rsamp_step    //unsigned  , default = 134217728;//'h800_0000
#define AUDIO_RSAMPB_SHIFT                         ((0x0005  << 2) + 0xfe334000)
//Bit   31:24       reg_rsft_iir    //unsigned  , default = 23;
//Bit   23:16       reg_rsft_blnd   //unsigned  , default = 21;
//Bit   15:8        reg_rsft_sinc   //unsigned  , default = 31;
//Bit   7:0         reg_rsft_aa     //unsigned  , default = 31;
#define AUDIO_RSAMPB_ADJ_CTRL0                     ((0x0006  << 2) + 0xfe334000)
//Bit   31:3        reserved                //unsigned
//Bit   2           reg_rsamp_adj_out_inv   //unsigned , default = 0;
//Bit   1           reg_rsamp_adj_force_en  //unsigned , default = 0;
//Bit   0           reg_rsamp_adj_en        //unsigned , default = 0;
#define AUDIO_RSAMPB_ADJ_CTRL1                     ((0x0007  << 2) + 0xfe334000)
//Bit   31:16       reg_rsamp_adj_odet_step     //unsigned , default = 8;
//Bit   15:0        reg_rsamp_adj_kmax          //unsigned , default = 32768;
#define AUDIO_RSAMPB_ADJ_SFT                       ((0x0008  << 2) + 0xfe334000)
//Bit   31:30       reserved                //unsigned , default = 0;
//Bit   29          reg_rsamp_adj_dif_sel   //unsigned , default = 0;
//Bit   28:24       reg_rsamp_adj_ki        //unsigned , default = 9;
//Bit   23:21       reserved                //unsigned , default = 0;
//Bit   20:16       reg_rsamp_adj_kp        //unsigned , default = 1;
//Bit   15:13       reserved                //unsigned , default = 0;
//Bit   12:8        reg_rsamp_adj_ki_sft    //unsigned , default = 6;
//Bit   7:6         reserved                //unsigned , default = 0;
//Bit   5:0         reg_rsamp_adj_out_sft   //unsigned , default = 12;
#define AUDIO_RSAMPB_ADJ_IDET_LEN                  ((0x0009  << 2) + 0xfe334000)
//Bit   31:0       reg_rsamp_adj_idet_len       //unsigned , default = 10000;
#define AUDIO_RSAMPB_ADJ_FORCE                     ((0x000a  << 2) + 0xfe334000)
//Bit   31:0       reg_rsamp_adj_force_err      //signed , default = 8;
#define AUDIO_RSAMPB_ADJ_KI_FORCE                  ((0x000b  << 2) + 0xfe334000)
//Bit   31:0       reg_rsamp_adj_ki_force //signed , default = 0;
#define AUDIO_RSAMPB_WATCHDOG_THRD                 ((0x000c  << 2) + 0xfe334000)
//Bit   31:0       reg_watchdog_thrd      //signed , default = 32'h1000;
#define AUDIO_RSAMPB_RO_STATUS                     ((0x0010  << 2) + 0xfe334000)
//Bit   31:0       ro_rsamp_stat  //{din_chx_chk_err,is_idle_st,rsamp_fifo_over_cnt[7:0]}
#define AUDIO_RSAMPB_RO_ADJ_FREQ                   ((0x0011  << 2) + 0xfe334000)
//Bit   31:0       ro_rsamp_adj_freq
#define AUDIO_RSAMPB_RO_ADJ_DIFF_BAK               ((0x0012  << 2) + 0xfe334000)
//Bit   31:0       ro_det_diff_bak
#define AUDIO_RSAMPB_RO_ADJ_DIFF_DLT               ((0x0013  << 2) + 0xfe334000)
//Bit   31:0       ro_det_diff_dlt
#define AUDIO_RSAMPB_RO_ADJ_PHS_ERR                ((0x0014  << 2) + 0xfe334000)
//Bit   31:0       ro_det_phase_err
#define AUDIO_RSAMPB_RO_ADJ_KI_OUT                 ((0x0015  << 2) + 0xfe334000)
//Bit   31:0       ro_rsamp_ki_out
#define AUDIO_RSAMPB_RO_IN_CNT                     ((0x0016  << 2) + 0xfe334000)
//Bit   31:0       ro_rsamp_in_cnt
#define AUDIO_RSAMPB_RO_OUT_CNT                    ((0x0017  << 2) + 0xfe334000)
//Bit   31:0       ro_rsamp_out_cnt
#define AUDIO_RSAMPB_RO_ADJ_PHS_ERR_VAR            ((0x0018  << 2) + 0xfe334000)
//Bit   31:0       ro_det_phase_err_var
#define AUDIO_RSAMPB_POST_COEF0                    ((0x0020  << 2) + 0xfe334000)
//Bit   31:0       reg_post_coef0 //signed  , default = 0;
#define AUDIO_RSAMPB_POST_COEF1                    ((0x0021  << 2) + 0xfe334000)
//Bit   31:0       reg_post_coef1 //signed  , default = 0;
#define AUDIO_RSAMPB_POST_COEF2                    ((0x0022  << 2) + 0xfe334000)
//Bit   31:0       reg_post_coef2 //signed  , default = 0;
#define AUDIO_RSAMPB_POST_COEF3                    ((0x0023  << 2) + 0xfe334000)
//Bit   31:0       reg_post_coef3 //signed  , default = 0;
#define AUDIO_RSAMPB_POST_COEF4                    ((0x0024  << 2) + 0xfe334000)
//Bit   31:0       reg_post_coef4 //signed  , default = 0;
#define AUDIO_RSAMPB_AA_COEF_ADDR                  ((0x0030  << 2) + 0xfe334000)
//Bit   31:0       reg_aa_coef_addr     //unsigned, default = 0;
#define AUDIO_RSAMPB_AA_COEF_DATA                  ((0x0031  << 2) + 0xfe334000)
//Bit   31:0       reg_aa_coef_data     //signed  , default = 0;
#define AUDIO_RSAMPB_SINC_COEF_ADDR                ((0x0040  << 2) + 0xfe334000)
//Bit   31:0       reg_sinc_coef_addr   //unsigned, default = 0;
#define AUDIO_RSAMPB_SINC_COEF_DATA                ((0x0041  << 2) + 0xfe334000)
//Bit   31:0       reg_sinc_coef_data   //signed  , default = 0;
//
// Closing file:  RESAMPLEB.h
//
//
// Closing file:  REG_LIST_AUDIO_RTL.h
//
//
// Reading file:  REG_LIST_DSP_RTL.h
//
// synopsys translate_off
// synopsys translate_on
//========================================================================
//  DSPA - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe340000
// -----------------------------------------------
#define DSP_CFG0                                   ((0x0000  << 2) + 0xfe340000)
#define DSP_CFG1                                   ((0x0001  << 2) + 0xfe340000)
#define DSP_CFG2                                   ((0x0002  << 2) + 0xfe340000)
#define DSP_IMPWIRE                                ((0x0003  << 2) + 0xfe340000)
#define DSP_RESET_VEC                              ((0x0004  << 2) + 0xfe340000)
#define DSP_SEC_CFG0                               ((0x0006  << 2) + 0xfe340000)
#define DSP_SEC_CFG1                               ((0x0007  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL0                              ((0x0010  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL1                              ((0x0011  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL2                              ((0x0012  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL3                              ((0x0013  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL4                              ((0x0014  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL5                              ((0x0015  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL6                              ((0x0016  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL7                              ((0x0017  << 2) + 0xfe340000)
#define DSP_IRQ_CTRL8                              ((0x0018  << 2) + 0xfe340000)
#define DSP_IRQ_STS                                ((0x001f  << 2) + 0xfe340000)
#define DSP_REMAP0                                 ((0x0020  << 2) + 0xfe340000)
#define DSP_REMAP1                                 ((0x0021  << 2) + 0xfe340000)
#define DSP_REMAP2                                 ((0x0022  << 2) + 0xfe340000)
#define DSP_STS0                                   ((0x0040  << 2) + 0xfe340000)
#define DSP_STS1                                   ((0x0041  << 2) + 0xfe340000)
#define DSP_STS2                                   ((0x0042  << 2) + 0xfe340000)
#define DSP_STS3                                   ((0x0043  << 2) + 0xfe340000)
#define DSP_STS4                                   ((0x0044  << 2) + 0xfe340000)
#define DSP_STS5                                   ((0x0045  << 2) + 0xfe340000)
#define DSP_QIF_CTRL                               ((0x0080  << 2) + 0xfe340000)
#define DSP_QIF_STS                                ((0x0081  << 2) + 0xfe340000)
#define DSP_WRFIFO_TOCPUA                          ((0x0082  << 2) + 0xfe340000)
#define DSP_WRFIFO_TOCPUB                          ((0x0083  << 2) + 0xfe340000)
#define DSP_WRFIFO_TODSP                           ((0x0084  << 2) + 0xfe340000)
#define DSP_RDFIFO_FRCPUA                          ((0x0088  << 2) + 0xfe340000)
#define DSP_RDFIFO_FRCPUB                          ((0x0089  << 2) + 0xfe340000)
#define DSP_RDFIFO_FRDSP                           ((0x008a  << 2) + 0xfe340000)
//========================================================================
//  DSPB - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe350000
// -----------------------------------------------
#define DSPB_CFG0                                  ((0x0000  << 2) + 0xfe350000)
#define DSPB_CFG1                                  ((0x0001  << 2) + 0xfe350000)
#define DSPB_CFG2                                  ((0x0002  << 2) + 0xfe350000)
#define DSPB_IMPWIRE                               ((0x0003  << 2) + 0xfe350000)
#define DSPB_RESET_VEC                             ((0x0004  << 2) + 0xfe350000)
#define DSPB_SEC_CFG0                              ((0x0006  << 2) + 0xfe350000)
#define DSPB_SEC_CFG1                              ((0x0007  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL0                             ((0x0010  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL1                             ((0x0011  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL2                             ((0x0012  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL3                             ((0x0013  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL4                             ((0x0014  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL5                             ((0x0015  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL6                             ((0x0016  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL7                             ((0x0017  << 2) + 0xfe350000)
#define DSPB_IRQ_CTRL8                             ((0x0018  << 2) + 0xfe350000)
#define DSPB_IRQ_STS                               ((0x001f  << 2) + 0xfe350000)
#define DSPB_REMAP0                                ((0x0020  << 2) + 0xfe350000)
#define DSPB_REMAP1                                ((0x0021  << 2) + 0xfe350000)
#define DSPB_REMAP2                                ((0x0022  << 2) + 0xfe350000)
#define DSPB_STS0                                  ((0x0040  << 2) + 0xfe350000)
#define DSPB_STS1                                  ((0x0041  << 2) + 0xfe350000)
#define DSPB_STS2                                  ((0x0042  << 2) + 0xfe350000)
#define DSPB_STS3                                  ((0x0043  << 2) + 0xfe350000)
#define DSPB_STS4                                  ((0x0044  << 2) + 0xfe350000)
#define DSPB_STS5                                  ((0x0045  << 2) + 0xfe350000)
#define DSPB_QIF_CTRL                              ((0x0080  << 2) + 0xfe350000)
#define DSPB_QIF_STS                               ((0x0081  << 2) + 0xfe350000)
#define DSPB_WRFIFO_TOCPUA                         ((0x0082  << 2) + 0xfe350000)
#define DSPB_WRFIFO_TOCPUB                         ((0x0083  << 2) + 0xfe350000)
#define DSPB_WRFIFO_TODSP                          ((0x0084  << 2) + 0xfe350000)
#define DSPB_RDFIFO_FRCPUA                         ((0x0088  << 2) + 0xfe350000)
#define DSPB_RDFIFO_FRCPUB                         ((0x0089  << 2) + 0xfe350000)
#define DSPB_RDFIFO_FRDSP                          ((0x008a  << 2) + 0xfe350000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  REG_LIST_DSP_RTL.h
//
//
// Reading file:  REG_LIST_SECURITY_RTL.h
//
//
//***************************************************************************
// Title:      REG_LIST_SECURITY_RTL.h
//
// Author:     shan.luan
//
// Created:    23:09:44 28/02/2020
//
// Description:
//
// Note:
//
// History:
//
//***************************************************************************
//========================================================================
//  TS_DEMUX_REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe444000
// -----------------------------------------------
#define RCH_READY_CHANNEL_0                        ((0x0000  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_1                        ((0x0008  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_2                        ((0x0010  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_3                        ((0x0018  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_4                        ((0x0020  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_5                        ((0x0028  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_6                        ((0x0030  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_7                        ((0x0038  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_8                        ((0x0040  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_9                        ((0x0048  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_10                       ((0x0050  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_11                       ((0x0058  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_12                       ((0x0060  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_13                       ((0x0068  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_14                       ((0x0070  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_15                       ((0x0078  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_16                       ((0x0080  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_17                       ((0x0088  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_18                       ((0x0090  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_19                       ((0x0098  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_20                       ((0x00a0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_21                       ((0x00a8  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_22                       ((0x00b0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_23                       ((0x00b8  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_24                       ((0x00c0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_25                       ((0x00c8  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_26                       ((0x00d0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_27                       ((0x00d8  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_28                       ((0x00e0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_29                       ((0x00e8  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_30                       ((0x00f0  << 2) + 0xfe444000)
#define RCH_READY_CHANNEL_31                       ((0x00f8  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_0                       ((0x0001  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_1                       ((0x0009  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_2                       ((0x0011  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_3                       ((0x0019  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_4                       ((0x0021  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_5                       ((0x0029  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_6                       ((0x0031  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_7                       ((0x0039  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_8                       ((0x0041  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_9                       ((0x0049  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_10                      ((0x0051  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_11                      ((0x0059  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_12                      ((0x0061  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_13                      ((0x0069  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_14                      ((0x0071  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_15                      ((0x0079  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_16                      ((0x0081  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_17                      ((0x0089  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_18                      ((0x0091  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_19                      ((0x0099  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_20                      ((0x00a1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_21                      ((0x00a9  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_22                      ((0x00b1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_23                      ((0x00b9  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_24                      ((0x00c1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_25                      ((0x00c9  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_26                      ((0x00d1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_27                      ((0x00d9  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_28                      ((0x00e1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_29                      ((0x00e9  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_30                      ((0x00f1  << 2) + 0xfe444000)
#define RCH_STATUS_CHANNEL_31                      ((0x00f9  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_0                          ((0x0002  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_1                          ((0x000a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_2                          ((0x0012  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_3                          ((0x001a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_4                          ((0x0022  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_5                          ((0x002a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_6                          ((0x0032  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_7                          ((0x003a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_8                          ((0x0042  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_9                          ((0x004a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_10                         ((0x0052  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_11                         ((0x005a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_12                         ((0x0062  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_13                         ((0x006a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_14                         ((0x0072  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_15                         ((0x007a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_16                         ((0x0082  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_17                         ((0x008a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_18                         ((0x0092  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_19                         ((0x009a  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_20                         ((0x00a2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_21                         ((0x00aa  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_22                         ((0x00b2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_23                         ((0x00ba  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_24                         ((0x00c2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_25                         ((0x00ca  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_26                         ((0x00d2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_27                         ((0x00da  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_28                         ((0x00e2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_29                         ((0x00ea  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_30                         ((0x00f2  << 2) + 0xfe444000)
#define RCH_CFG_CHANNEL_31                         ((0x00fa  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_0                         ((0x0003  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_1                         ((0x000b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_2                         ((0x0013  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_3                         ((0x001b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_4                         ((0x0023  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_5                         ((0x002b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_6                         ((0x0033  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_7                         ((0x003b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_8                         ((0x0043  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_9                         ((0x004b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_10                        ((0x0053  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_11                        ((0x005b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_12                        ((0x0063  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_13                        ((0x006b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_14                        ((0x0073  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_15                        ((0x007b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_16                        ((0x0083  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_17                        ((0x008b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_18                        ((0x0093  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_19                        ((0x009b  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_20                        ((0x00a3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_21                        ((0x00ab  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_22                        ((0x00b3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_23                        ((0x00bb  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_24                        ((0x00c3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_25                        ((0x00cb  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_26                        ((0x00d3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_27                        ((0x00db  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_28                        ((0x00e3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_29                        ((0x00eb  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_30                        ((0x00f3  << 2) + 0xfe444000)
#define RCH_ADDR_CHANNEL_31                        ((0x00fb  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_0                          ((0x0004  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_1                          ((0x000c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_2                          ((0x0014  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_3                          ((0x001c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_4                          ((0x0024  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_5                          ((0x002c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_6                          ((0x0034  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_7                          ((0x003c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_8                          ((0x0044  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_9                          ((0x004c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_10                         ((0x0054  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_11                         ((0x005c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_12                         ((0x0064  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_13                         ((0x006c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_14                         ((0x0074  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_15                         ((0x007c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_16                         ((0x0084  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_17                         ((0x008c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_18                         ((0x0094  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_19                         ((0x009c  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_20                         ((0x00a4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_21                         ((0x00ac  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_22                         ((0x00b4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_23                         ((0x00bc  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_24                         ((0x00c4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_25                         ((0x00cc  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_26                         ((0x00d4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_27                         ((0x00dc  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_28                         ((0x00e4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_29                         ((0x00ec  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_30                         ((0x00f4  << 2) + 0xfe444000)
#define RCH_LEN_CHANNEL_31                         ((0x00fc  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_0                       ((0x0005  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_1                       ((0x000d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_2                       ((0x0015  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_3                       ((0x001d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_4                       ((0x0025  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_5                       ((0x002d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_6                       ((0x0035  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_7                       ((0x003d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_8                       ((0x0045  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_9                       ((0x004d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_10                      ((0x0055  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_11                      ((0x005d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_12                      ((0x0065  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_13                      ((0x006d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_14                      ((0x0075  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_15                      ((0x007d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_16                      ((0x0085  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_17                      ((0x008d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_18                      ((0x0095  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_19                      ((0x009d  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_20                      ((0x00a5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_21                      ((0x00ad  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_22                      ((0x00b5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_23                      ((0x00bd  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_24                      ((0x00c5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_25                      ((0x00cd  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_26                      ((0x00d5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_27                      ((0x00dd  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_28                      ((0x00e5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_29                      ((0x00ed  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_30                      ((0x00f5  << 2) + 0xfe444000)
#define RCH_RD_LEN_CHANNEL_31                      ((0x00fd  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_0                          ((0x0006  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_1                          ((0x000e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_2                          ((0x0016  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_3                          ((0x001e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_4                          ((0x0026  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_5                          ((0x002e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_6                          ((0x0036  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_7                          ((0x003e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_8                          ((0x0046  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_9                          ((0x004e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_10                         ((0x0056  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_11                         ((0x005e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_12                         ((0x0066  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_13                         ((0x006e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_14                         ((0x0076  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_15                         ((0x007e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_16                         ((0x0086  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_17                         ((0x008e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_18                         ((0x0096  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_19                         ((0x009e  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_20                         ((0x00a6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_21                         ((0x00ae  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_22                         ((0x00b6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_23                         ((0x00be  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_24                         ((0x00c6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_25                         ((0x00ce  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_26                         ((0x00d6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_27                         ((0x00de  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_28                         ((0x00e6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_29                         ((0x00ee  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_30                         ((0x00f6  << 2) + 0xfe444000)
#define RCH_PTR_CHANNEL_31                         ((0x00fe  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_0              ((0x0007  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_1              ((0x000f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_2              ((0x0017  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_3              ((0x001f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_4              ((0x0027  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_5              ((0x002f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_6              ((0x0037  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_7              ((0x003f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_8              ((0x0047  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_9              ((0x004f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_10             ((0x0057  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_11             ((0x005f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_12             ((0x0067  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_13             ((0x006f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_14             ((0x0077  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_15             ((0x007f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_16             ((0x0087  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_17             ((0x008f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_18             ((0x0097  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_19             ((0x009f  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_20             ((0x00a7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_21             ((0x00af  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_22             ((0x00b7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_23             ((0x00bf  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_24             ((0x00c7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_25             ((0x00cf  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_26             ((0x00d7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_27             ((0x00df  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_28             ((0x00e7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_29             ((0x00ef  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_30             ((0x00f7  << 2) + 0xfe444000)
#define RCH_PKT_SYNC_STATUS_CHANNEL_31             ((0x00ff  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_0                        ((0x0400  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_1                        ((0x0408  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_2                        ((0x0410  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_3                        ((0x0418  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_4                        ((0x0420  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_5                        ((0x0428  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_6                        ((0x0430  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_7                        ((0x0438  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_8                        ((0x0440  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_9                        ((0x0448  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_10                       ((0x0450  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_11                       ((0x0458  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_12                       ((0x0460  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_13                       ((0x0468  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_14                       ((0x0470  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_15                       ((0x0478  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_16                       ((0x0480  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_17                       ((0x0488  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_18                       ((0x0490  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_19                       ((0x0498  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_20                       ((0x04a0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_21                       ((0x04a8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_22                       ((0x04b0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_23                       ((0x04b8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_24                       ((0x04c0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_25                       ((0x04c8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_26                       ((0x04d0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_27                       ((0x04d8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_28                       ((0x04e0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_29                       ((0x04e8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_30                       ((0x04f0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_31                       ((0x04f8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_32                       ((0x0500  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_33                       ((0x0508  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_34                       ((0x0510  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_35                       ((0x0518  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_36                       ((0x0520  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_37                       ((0x0528  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_38                       ((0x0530  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_39                       ((0x0538  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_40                       ((0x0540  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_41                       ((0x0548  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_42                       ((0x0550  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_43                       ((0x0558  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_44                       ((0x0560  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_45                       ((0x0568  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_46                       ((0x0570  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_47                       ((0x0578  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_48                       ((0x0580  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_49                       ((0x0588  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_50                       ((0x0590  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_51                       ((0x0598  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_52                       ((0x05a0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_53                       ((0x05a8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_54                       ((0x05b0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_55                       ((0x05b8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_56                       ((0x05c0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_57                       ((0x05c8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_58                       ((0x05d0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_59                       ((0x05d8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_60                       ((0x05e0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_61                       ((0x05e8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_62                       ((0x05f0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_63                       ((0x05f8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_64                       ((0x0600  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_65                       ((0x0608  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_66                       ((0x0610  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_67                       ((0x0618  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_68                       ((0x0620  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_69                       ((0x0628  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_70                       ((0x0630  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_71                       ((0x0638  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_72                       ((0x0640  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_73                       ((0x0648  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_74                       ((0x0650  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_75                       ((0x0658  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_76                       ((0x0660  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_77                       ((0x0668  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_78                       ((0x0670  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_79                       ((0x0678  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_80                       ((0x0680  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_81                       ((0x0688  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_82                       ((0x0690  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_83                       ((0x0698  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_84                       ((0x06a0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_85                       ((0x06a8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_86                       ((0x06b0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_87                       ((0x06b8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_88                       ((0x06c0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_89                       ((0x06c8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_90                       ((0x06d0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_91                       ((0x06d8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_92                       ((0x06e0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_93                       ((0x06e8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_94                       ((0x06f0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_95                       ((0x06f8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_96                       ((0x0700  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_97                       ((0x0708  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_98                       ((0x0710  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_99                       ((0x0718  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_100                      ((0x0720  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_101                      ((0x0728  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_102                      ((0x0730  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_103                      ((0x0738  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_104                      ((0x0740  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_105                      ((0x0748  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_106                      ((0x0750  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_107                      ((0x0758  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_108                      ((0x0760  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_109                      ((0x0768  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_110                      ((0x0770  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_111                      ((0x0778  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_112                      ((0x0780  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_113                      ((0x0788  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_114                      ((0x0790  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_115                      ((0x0798  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_116                      ((0x07a0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_117                      ((0x07a8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_118                      ((0x07b0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_119                      ((0x07b8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_120                      ((0x07c0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_121                      ((0x07c8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_122                      ((0x07d0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_123                      ((0x07d8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_124                      ((0x07e0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_125                      ((0x07e8  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_126                      ((0x07f0  << 2) + 0xfe444000)
#define WCH_READY_CHANNEL_127                      ((0x07f8  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_0                        ((0x0401  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_1                        ((0x0409  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_2                        ((0x0411  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_3                        ((0x0419  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_4                        ((0x0421  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_5                        ((0x0429  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_6                        ((0x0431  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_7                        ((0x0439  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_8                        ((0x0441  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_9                        ((0x0449  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_10                       ((0x0451  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_11                       ((0x0459  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_12                       ((0x0461  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_13                       ((0x0469  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_14                       ((0x0471  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_15                       ((0x0479  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_16                       ((0x0481  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_17                       ((0x0489  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_18                       ((0x0491  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_19                       ((0x0499  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_20                       ((0x04a1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_21                       ((0x04a9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_22                       ((0x04b1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_23                       ((0x04b9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_24                       ((0x04c1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_25                       ((0x04c9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_26                       ((0x04d1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_27                       ((0x04d9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_28                       ((0x04e1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_29                       ((0x04e9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_30                       ((0x04f1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_31                       ((0x04f9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_32                       ((0x0501  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_33                       ((0x0509  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_34                       ((0x0511  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_35                       ((0x0519  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_36                       ((0x0521  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_37                       ((0x0529  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_38                       ((0x0531  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_39                       ((0x0539  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_40                       ((0x0541  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_41                       ((0x0549  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_42                       ((0x0551  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_43                       ((0x0559  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_44                       ((0x0561  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_45                       ((0x0569  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_46                       ((0x0571  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_47                       ((0x0579  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_48                       ((0x0581  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_49                       ((0x0589  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_50                       ((0x0591  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_51                       ((0x0599  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_52                       ((0x05a1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_53                       ((0x05a9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_54                       ((0x05b1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_55                       ((0x05b9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_56                       ((0x05c1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_57                       ((0x05c9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_58                       ((0x05d1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_59                       ((0x05d9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_60                       ((0x05e1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_61                       ((0x05e9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_62                       ((0x05f1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_63                       ((0x05f9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_64                       ((0x0601  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_65                       ((0x0609  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_66                       ((0x0611  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_67                       ((0x0619  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_68                       ((0x0621  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_69                       ((0x0629  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_70                       ((0x0631  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_71                       ((0x0639  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_72                       ((0x0641  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_73                       ((0x0649  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_74                       ((0x0651  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_75                       ((0x0659  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_76                       ((0x0661  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_77                       ((0x0669  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_78                       ((0x0671  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_79                       ((0x0679  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_80                       ((0x0681  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_81                       ((0x0689  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_82                       ((0x0691  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_83                       ((0x0699  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_84                       ((0x06a1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_85                       ((0x06a9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_86                       ((0x06b1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_87                       ((0x06b9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_88                       ((0x06c1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_89                       ((0x06c9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_90                       ((0x06d1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_91                       ((0x06d9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_92                       ((0x06e1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_93                       ((0x06e9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_94                       ((0x06f1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_95                       ((0x06f9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_96                       ((0x0701  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_97                       ((0x0709  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_98                       ((0x0711  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_99                       ((0x0719  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_100                      ((0x0721  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_101                      ((0x0729  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_102                      ((0x0731  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_103                      ((0x0739  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_104                      ((0x0741  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_105                      ((0x0749  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_106                      ((0x0751  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_107                      ((0x0759  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_108                      ((0x0761  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_109                      ((0x0769  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_110                      ((0x0771  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_111                      ((0x0779  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_112                      ((0x0781  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_113                      ((0x0789  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_114                      ((0x0791  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_115                      ((0x0799  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_116                      ((0x07a1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_117                      ((0x07a9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_118                      ((0x07b1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_119                      ((0x07b9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_120                      ((0x07c1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_121                      ((0x07c9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_122                      ((0x07d1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_123                      ((0x07d9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_124                      ((0x07e1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_125                      ((0x07e9  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_126                      ((0x07f1  << 2) + 0xfe444000)
#define WCH_DEBUG_CHANNEL_127                      ((0x07f9  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_0                          ((0x0402  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_1                          ((0x040a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_2                          ((0x0412  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_3                          ((0x041a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_4                          ((0x0422  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_5                          ((0x042a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_6                          ((0x0432  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_7                          ((0x043a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_8                          ((0x0442  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_9                          ((0x044a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_10                         ((0x0452  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_11                         ((0x045a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_12                         ((0x0462  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_13                         ((0x046a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_14                         ((0x0472  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_15                         ((0x047a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_16                         ((0x0482  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_17                         ((0x048a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_18                         ((0x0492  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_19                         ((0x049a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_20                         ((0x04a2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_21                         ((0x04aa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_22                         ((0x04b2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_23                         ((0x04ba  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_24                         ((0x04c2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_25                         ((0x04ca  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_26                         ((0x04d2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_27                         ((0x04da  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_28                         ((0x04e2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_29                         ((0x04ea  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_30                         ((0x04f2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_31                         ((0x04fa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_32                         ((0x0502  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_33                         ((0x050a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_34                         ((0x0512  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_35                         ((0x051a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_36                         ((0x0522  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_37                         ((0x052a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_38                         ((0x0532  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_39                         ((0x053a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_40                         ((0x0542  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_41                         ((0x054a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_42                         ((0x0552  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_43                         ((0x055a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_44                         ((0x0562  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_45                         ((0x056a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_46                         ((0x0572  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_47                         ((0x057a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_48                         ((0x0582  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_49                         ((0x058a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_50                         ((0x0592  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_51                         ((0x059a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_52                         ((0x05a2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_53                         ((0x05aa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_54                         ((0x05b2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_55                         ((0x05ba  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_56                         ((0x05c2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_57                         ((0x05ca  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_58                         ((0x05d2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_59                         ((0x05da  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_60                         ((0x05e2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_61                         ((0x05ea  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_62                         ((0x05f2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_63                         ((0x05fa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_64                         ((0x0602  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_65                         ((0x060a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_66                         ((0x0612  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_67                         ((0x061a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_68                         ((0x0622  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_69                         ((0x062a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_70                         ((0x0632  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_71                         ((0x063a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_72                         ((0x0642  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_73                         ((0x064a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_74                         ((0x0652  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_75                         ((0x065a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_76                         ((0x0662  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_77                         ((0x066a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_78                         ((0x0672  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_79                         ((0x067a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_80                         ((0x0682  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_81                         ((0x068a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_82                         ((0x0692  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_83                         ((0x069a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_84                         ((0x06a2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_85                         ((0x06aa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_86                         ((0x06b2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_87                         ((0x06ba  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_88                         ((0x06c2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_89                         ((0x06ca  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_90                         ((0x06d2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_91                         ((0x06da  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_92                         ((0x06e2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_93                         ((0x06ea  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_94                         ((0x06f2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_95                         ((0x06fa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_96                         ((0x0702  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_97                         ((0x070a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_98                         ((0x0712  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_99                         ((0x071a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_100                        ((0x0722  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_101                        ((0x072a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_102                        ((0x0732  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_103                        ((0x073a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_104                        ((0x0742  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_105                        ((0x074a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_106                        ((0x0752  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_107                        ((0x075a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_108                        ((0x0762  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_109                        ((0x076a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_110                        ((0x0772  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_111                        ((0x077a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_112                        ((0x0782  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_113                        ((0x078a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_114                        ((0x0792  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_115                        ((0x079a  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_116                        ((0x07a2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_117                        ((0x07aa  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_118                        ((0x07b2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_119                        ((0x07ba  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_120                        ((0x07c2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_121                        ((0x07ca  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_122                        ((0x07d2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_123                        ((0x07da  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_124                        ((0x07e2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_125                        ((0x07ea  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_126                        ((0x07f2  << 2) + 0xfe444000)
#define WCH_CFG_CHANNEL_127                        ((0x07fa  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_0                         ((0x0403  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_1                         ((0x040b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_2                         ((0x0413  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_3                         ((0x041b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_4                         ((0x0423  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_5                         ((0x042b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_6                         ((0x0433  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_7                         ((0x043b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_8                         ((0x0443  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_9                         ((0x044b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_10                        ((0x0453  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_11                        ((0x045b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_12                        ((0x0463  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_13                        ((0x046b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_14                        ((0x0473  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_15                        ((0x047b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_16                        ((0x0483  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_17                        ((0x048b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_18                        ((0x0493  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_19                        ((0x049b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_20                        ((0x04a3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_21                        ((0x04ab  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_22                        ((0x04b3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_23                        ((0x04bb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_24                        ((0x04c3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_25                        ((0x04cb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_26                        ((0x04d3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_27                        ((0x04db  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_28                        ((0x04e3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_29                        ((0x04eb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_30                        ((0x04f3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_31                        ((0x04fb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_32                        ((0x0503  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_33                        ((0x050b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_34                        ((0x0513  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_35                        ((0x051b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_36                        ((0x0523  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_37                        ((0x052b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_38                        ((0x0533  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_39                        ((0x053b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_40                        ((0x0543  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_41                        ((0x054b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_42                        ((0x0553  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_43                        ((0x055b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_44                        ((0x0563  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_45                        ((0x056b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_46                        ((0x0573  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_47                        ((0x057b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_48                        ((0x0583  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_49                        ((0x058b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_50                        ((0x0593  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_51                        ((0x059b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_52                        ((0x05a3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_53                        ((0x05ab  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_54                        ((0x05b3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_55                        ((0x05bb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_56                        ((0x05c3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_57                        ((0x05cb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_58                        ((0x05d3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_59                        ((0x05db  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_60                        ((0x05e3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_61                        ((0x05eb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_62                        ((0x05f3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_63                        ((0x05fb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_64                        ((0x0603  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_65                        ((0x060b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_66                        ((0x0613  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_67                        ((0x061b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_68                        ((0x0623  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_69                        ((0x062b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_70                        ((0x0633  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_71                        ((0x063b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_72                        ((0x0643  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_73                        ((0x064b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_74                        ((0x0653  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_75                        ((0x065b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_76                        ((0x0663  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_77                        ((0x066b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_78                        ((0x0673  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_79                        ((0x067b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_80                        ((0x0683  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_81                        ((0x068b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_82                        ((0x0693  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_83                        ((0x069b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_84                        ((0x06a3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_85                        ((0x06ab  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_86                        ((0x06b3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_87                        ((0x06bb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_88                        ((0x06c3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_89                        ((0x06cb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_90                        ((0x06d3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_91                        ((0x06db  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_92                        ((0x06e3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_93                        ((0x06eb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_94                        ((0x06f3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_95                        ((0x06fb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_96                        ((0x0703  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_97                        ((0x070b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_98                        ((0x0713  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_99                        ((0x071b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_100                       ((0x0723  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_101                       ((0x072b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_102                       ((0x0733  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_103                       ((0x073b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_104                       ((0x0743  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_105                       ((0x074b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_106                       ((0x0753  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_107                       ((0x075b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_108                       ((0x0763  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_109                       ((0x076b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_110                       ((0x0773  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_111                       ((0x077b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_112                       ((0x0783  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_113                       ((0x078b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_114                       ((0x0793  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_115                       ((0x079b  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_116                       ((0x07a3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_117                       ((0x07ab  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_118                       ((0x07b3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_119                       ((0x07bb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_120                       ((0x07c3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_121                       ((0x07cb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_122                       ((0x07d3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_123                       ((0x07db  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_124                       ((0x07e3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_125                       ((0x07eb  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_126                       ((0x07f3  << 2) + 0xfe444000)
#define WCH_ADDR_CHANNEL_127                       ((0x07fb  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_0                          ((0x0404  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_1                          ((0x040c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_2                          ((0x0414  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_3                          ((0x041c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_4                          ((0x0424  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_5                          ((0x042c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_6                          ((0x0434  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_7                          ((0x043c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_8                          ((0x0444  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_9                          ((0x044c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_10                         ((0x0454  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_11                         ((0x045c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_12                         ((0x0464  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_13                         ((0x046c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_14                         ((0x0474  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_15                         ((0x047c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_16                         ((0x0484  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_17                         ((0x048c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_18                         ((0x0494  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_19                         ((0x049c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_20                         ((0x04a4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_21                         ((0x04ac  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_22                         ((0x04b4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_23                         ((0x04bc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_24                         ((0x04c4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_25                         ((0x04cc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_26                         ((0x04d4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_27                         ((0x04dc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_28                         ((0x04e4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_29                         ((0x04ec  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_30                         ((0x04f4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_31                         ((0x04fc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_32                         ((0x0504  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_33                         ((0x050c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_34                         ((0x0514  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_35                         ((0x051c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_36                         ((0x0524  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_37                         ((0x052c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_38                         ((0x0534  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_39                         ((0x053c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_40                         ((0x0544  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_41                         ((0x054c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_42                         ((0x0554  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_43                         ((0x055c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_44                         ((0x0564  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_45                         ((0x056c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_46                         ((0x0574  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_47                         ((0x057c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_48                         ((0x0584  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_49                         ((0x058c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_50                         ((0x0594  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_51                         ((0x059c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_52                         ((0x05a4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_53                         ((0x05ac  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_54                         ((0x05b4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_55                         ((0x05bc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_56                         ((0x05c4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_57                         ((0x05cc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_58                         ((0x05d4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_59                         ((0x05dc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_60                         ((0x05e4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_61                         ((0x05ec  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_62                         ((0x05f4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_63                         ((0x05fc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_64                         ((0x0604  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_65                         ((0x060c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_66                         ((0x0614  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_67                         ((0x061c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_68                         ((0x0624  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_69                         ((0x062c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_70                         ((0x0634  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_71                         ((0x063c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_72                         ((0x0644  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_73                         ((0x064c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_74                         ((0x0654  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_75                         ((0x065c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_76                         ((0x0664  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_77                         ((0x066c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_78                         ((0x0674  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_79                         ((0x067c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_80                         ((0x0684  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_81                         ((0x068c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_82                         ((0x0694  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_83                         ((0x069c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_84                         ((0x06a4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_85                         ((0x06ac  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_86                         ((0x06b4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_87                         ((0x06bc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_88                         ((0x06c4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_89                         ((0x06cc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_90                         ((0x06d4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_91                         ((0x06dc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_92                         ((0x06e4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_93                         ((0x06ec  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_94                         ((0x06f4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_95                         ((0x06fc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_96                         ((0x0704  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_97                         ((0x070c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_98                         ((0x0714  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_99                         ((0x071c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_100                        ((0x0724  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_101                        ((0x072c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_102                        ((0x0734  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_103                        ((0x073c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_104                        ((0x0744  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_105                        ((0x074c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_106                        ((0x0754  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_107                        ((0x075c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_108                        ((0x0764  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_109                        ((0x076c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_110                        ((0x0774  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_111                        ((0x077c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_112                        ((0x0784  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_113                        ((0x078c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_114                        ((0x0794  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_115                        ((0x079c  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_116                        ((0x07a4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_117                        ((0x07ac  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_118                        ((0x07b4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_119                        ((0x07bc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_120                        ((0x07c4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_121                        ((0x07cc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_122                        ((0x07d4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_123                        ((0x07dc  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_124                        ((0x07e4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_125                        ((0x07ec  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_126                        ((0x07f4  << 2) + 0xfe444000)
#define WCH_LEN_CHANNEL_127                        ((0x07fc  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_0                       ((0x0405  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_1                       ((0x040d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_2                       ((0x0415  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_3                       ((0x041d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_4                       ((0x0425  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_5                       ((0x042d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_6                       ((0x0435  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_7                       ((0x043d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_8                       ((0x0445  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_9                       ((0x044d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_10                      ((0x0455  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_11                      ((0x045d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_12                      ((0x0465  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_13                      ((0x046d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_14                      ((0x0475  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_15                      ((0x047d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_16                      ((0x0485  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_17                      ((0x048d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_18                      ((0x0495  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_19                      ((0x049d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_20                      ((0x04a5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_21                      ((0x04ad  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_22                      ((0x04b5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_23                      ((0x04bd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_24                      ((0x04c5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_25                      ((0x04cd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_26                      ((0x04d5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_27                      ((0x04dd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_28                      ((0x04e5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_29                      ((0x04ed  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_30                      ((0x04f5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_31                      ((0x04fd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_32                      ((0x0505  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_33                      ((0x050d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_34                      ((0x0515  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_35                      ((0x051d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_36                      ((0x0525  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_37                      ((0x052d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_38                      ((0x0535  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_39                      ((0x053d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_40                      ((0x0545  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_41                      ((0x054d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_42                      ((0x0555  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_43                      ((0x055d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_44                      ((0x0565  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_45                      ((0x056d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_46                      ((0x0575  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_47                      ((0x057d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_48                      ((0x0585  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_49                      ((0x058d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_50                      ((0x0595  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_51                      ((0x059d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_52                      ((0x05a5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_53                      ((0x05ad  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_54                      ((0x05b5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_55                      ((0x05bd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_56                      ((0x05c5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_57                      ((0x05cd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_58                      ((0x05d5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_59                      ((0x05dd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_60                      ((0x05e5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_61                      ((0x05ed  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_62                      ((0x05f5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_63                      ((0x05fd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_64                      ((0x0605  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_65                      ((0x060d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_66                      ((0x0615  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_67                      ((0x061d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_68                      ((0x0625  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_69                      ((0x062d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_70                      ((0x0635  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_71                      ((0x063d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_72                      ((0x0645  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_73                      ((0x064d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_74                      ((0x0655  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_75                      ((0x065d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_76                      ((0x0665  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_77                      ((0x066d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_78                      ((0x0675  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_79                      ((0x067d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_80                      ((0x0685  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_81                      ((0x068d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_82                      ((0x0695  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_83                      ((0x069d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_84                      ((0x06a5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_85                      ((0x06ad  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_86                      ((0x06b5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_87                      ((0x06bd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_88                      ((0x06c5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_89                      ((0x06cd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_90                      ((0x06d5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_91                      ((0x06dd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_92                      ((0x06e5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_93                      ((0x06ed  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_94                      ((0x06f5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_95                      ((0x06fd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_96                      ((0x0705  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_97                      ((0x070d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_98                      ((0x0715  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_99                      ((0x071d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_100                     ((0x0725  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_101                     ((0x072d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_102                     ((0x0735  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_103                     ((0x073d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_104                     ((0x0745  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_105                     ((0x074d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_106                     ((0x0755  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_107                     ((0x075d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_108                     ((0x0765  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_109                     ((0x076d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_110                     ((0x0775  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_111                     ((0x077d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_112                     ((0x0785  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_113                     ((0x078d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_114                     ((0x0795  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_115                     ((0x079d  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_116                     ((0x07a5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_117                     ((0x07ad  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_118                     ((0x07b5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_119                     ((0x07bd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_120                     ((0x07c5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_121                     ((0x07cd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_122                     ((0x07d5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_123                     ((0x07dd  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_124                     ((0x07e5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_125                     ((0x07ed  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_126                     ((0x07f5  << 2) + 0xfe444000)
#define WCH_WR_LEN_CHANNEL_127                     ((0x07fd  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_0                          ((0x0406  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_1                          ((0x040e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_2                          ((0x0416  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_3                          ((0x041e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_4                          ((0x0426  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_5                          ((0x042e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_6                          ((0x0436  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_7                          ((0x043e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_8                          ((0x0446  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_9                          ((0x044e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_10                         ((0x0456  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_11                         ((0x045e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_12                         ((0x0466  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_13                         ((0x046e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_14                         ((0x0476  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_15                         ((0x047e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_16                         ((0x0486  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_17                         ((0x048e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_18                         ((0x0496  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_19                         ((0x049e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_20                         ((0x04a6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_21                         ((0x04ae  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_22                         ((0x04b6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_23                         ((0x04be  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_24                         ((0x04c6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_25                         ((0x04ce  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_26                         ((0x04d6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_27                         ((0x04de  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_28                         ((0x04e6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_29                         ((0x04ee  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_30                         ((0x04f6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_31                         ((0x04fe  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_32                         ((0x0506  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_33                         ((0x050e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_34                         ((0x0516  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_35                         ((0x051e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_36                         ((0x0526  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_37                         ((0x052e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_38                         ((0x0536  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_39                         ((0x053e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_40                         ((0x0546  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_41                         ((0x054e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_42                         ((0x0556  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_43                         ((0x055e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_44                         ((0x0566  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_45                         ((0x056e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_46                         ((0x0576  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_47                         ((0x057e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_48                         ((0x0586  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_49                         ((0x058e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_50                         ((0x0596  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_51                         ((0x059e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_52                         ((0x05a6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_53                         ((0x05ae  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_54                         ((0x05b6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_55                         ((0x05be  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_56                         ((0x05c6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_57                         ((0x05ce  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_58                         ((0x05d6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_59                         ((0x05de  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_60                         ((0x05e6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_61                         ((0x05ee  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_62                         ((0x05f6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_63                         ((0x05fe  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_64                         ((0x0606  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_65                         ((0x060e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_66                         ((0x0616  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_67                         ((0x061e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_68                         ((0x0626  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_69                         ((0x062e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_70                         ((0x0636  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_71                         ((0x063e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_72                         ((0x0646  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_73                         ((0x064e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_74                         ((0x0656  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_75                         ((0x065e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_76                         ((0x0666  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_77                         ((0x066e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_78                         ((0x0676  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_79                         ((0x067e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_80                         ((0x0686  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_81                         ((0x068e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_82                         ((0x0696  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_83                         ((0x069e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_84                         ((0x06a6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_85                         ((0x06ae  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_86                         ((0x06b6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_87                         ((0x06be  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_88                         ((0x06c6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_89                         ((0x06ce  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_90                         ((0x06d6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_91                         ((0x06de  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_92                         ((0x06e6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_93                         ((0x06ee  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_94                         ((0x06f6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_95                         ((0x06fe  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_96                         ((0x0706  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_97                         ((0x070e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_98                         ((0x0716  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_99                         ((0x071e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_100                        ((0x0726  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_101                        ((0x072e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_102                        ((0x0736  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_103                        ((0x073e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_104                        ((0x0746  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_105                        ((0x074e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_106                        ((0x0756  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_107                        ((0x075e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_108                        ((0x0766  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_109                        ((0x076e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_110                        ((0x0776  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_111                        ((0x077e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_112                        ((0x0786  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_113                        ((0x078e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_114                        ((0x0796  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_115                        ((0x079e  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_116                        ((0x07a6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_117                        ((0x07ae  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_118                        ((0x07b6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_119                        ((0x07be  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_120                        ((0x07c6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_121                        ((0x07ce  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_122                        ((0x07d6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_123                        ((0x07de  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_124                        ((0x07e6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_125                        ((0x07ee  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_126                        ((0x07f6  << 2) + 0xfe444000)
#define WCH_PTR_CHANNEL_127                        ((0x07fe  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_0                         ((0x0407  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_1                         ((0x040f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_2                         ((0x0417  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_3                         ((0x041f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_4                         ((0x0427  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_5                         ((0x042f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_6                         ((0x0437  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_7                         ((0x043f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_8                         ((0x0447  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_9                         ((0x044f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_10                        ((0x0457  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_11                        ((0x045f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_12                        ((0x0467  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_13                        ((0x046f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_14                        ((0x0477  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_15                        ((0x047f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_16                        ((0x0487  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_17                        ((0x048f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_18                        ((0x0497  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_19                        ((0x049f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_20                        ((0x04a7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_21                        ((0x04af  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_22                        ((0x04b7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_23                        ((0x04bf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_24                        ((0x04c7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_25                        ((0x04cf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_26                        ((0x04d7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_27                        ((0x04df  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_28                        ((0x04e7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_29                        ((0x04ef  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_30                        ((0x04f7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_31                        ((0x04ff  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_32                        ((0x0507  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_33                        ((0x050f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_34                        ((0x0517  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_35                        ((0x051f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_36                        ((0x0527  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_37                        ((0x052f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_38                        ((0x0537  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_39                        ((0x053f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_40                        ((0x0547  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_41                        ((0x054f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_42                        ((0x0557  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_43                        ((0x055f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_44                        ((0x0567  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_45                        ((0x056f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_46                        ((0x0577  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_47                        ((0x057f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_48                        ((0x0587  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_49                        ((0x058f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_50                        ((0x0597  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_51                        ((0x059f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_52                        ((0x05a7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_53                        ((0x05af  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_54                        ((0x05b7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_55                        ((0x05bf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_56                        ((0x05c7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_57                        ((0x05cf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_58                        ((0x05d7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_59                        ((0x05df  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_60                        ((0x05e7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_61                        ((0x05ef  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_62                        ((0x05f7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_63                        ((0x05ff  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_64                        ((0x0607  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_65                        ((0x060f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_66                        ((0x0617  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_67                        ((0x061f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_68                        ((0x0627  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_69                        ((0x062f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_70                        ((0x0637  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_71                        ((0x063f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_72                        ((0x0647  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_73                        ((0x064f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_74                        ((0x0657  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_75                        ((0x065f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_76                        ((0x0667  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_77                        ((0x066f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_78                        ((0x0677  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_79                        ((0x067f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_80                        ((0x0687  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_81                        ((0x068f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_82                        ((0x0697  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_83                        ((0x069f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_84                        ((0x06a7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_85                        ((0x06af  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_86                        ((0x06b7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_87                        ((0x06bf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_88                        ((0x06c7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_89                        ((0x06cf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_90                        ((0x06d7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_91                        ((0x06df  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_92                        ((0x06e7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_93                        ((0x06ef  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_94                        ((0x06f7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_95                        ((0x06ff  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_96                        ((0x0707  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_97                        ((0x070f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_98                        ((0x0717  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_99                        ((0x071f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_100                       ((0x0727  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_101                       ((0x072f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_102                       ((0x0737  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_103                       ((0x073f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_104                       ((0x0747  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_105                       ((0x074f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_106                       ((0x0757  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_107                       ((0x075f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_108                       ((0x0767  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_109                       ((0x076f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_110                       ((0x0777  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_111                       ((0x077f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_112                       ((0x0787  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_113                       ((0x078f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_114                       ((0x0797  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_115                       ((0x079f  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_116                       ((0x07a7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_117                       ((0x07af  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_118                       ((0x07b7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_119                       ((0x07bf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_120                       ((0x07c7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_121                       ((0x07cf  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_122                       ((0x07d7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_123                       ((0x07df  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_124                       ((0x07e7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_125                       ((0x07ef  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_126                       ((0x07f7  << 2) + 0xfe444000)
#define WCMD_CNT_CHANNEL_127                       ((0x07ff  << 2) + 0xfe444000)
#define DMX_RDMA_INT_MASK                          ((0x0800  << 2) + 0xfe444000)
#define DMX_WDMA_INT_MASK_0                        ((0x0801  << 2) + 0xfe444000)
#define DMX_WDMA_INT_MASK_1                        ((0x0802  << 2) + 0xfe444000)
#define DMX_WDMA_INT_MASK_2                        ((0x0803  << 2) + 0xfe444000)
#define DMX_WDMA_INT_MASK_3                        ((0x0804  << 2) + 0xfe444000)
#define DMX_CLEAN_W_BATCH_0                        ((0x0805  << 2) + 0xfe444000)
#define DMX_CLEAN_W_BATCH_1                        ((0x0806  << 2) + 0xfe444000)
#define DMX_CLEAN_W_BATCH_2                        ((0x0807  << 2) + 0xfe444000)
#define DMX_CLEAN_W_BATCH_3                        ((0x0808  << 2) + 0xfe444000)
#define DMX_CLEAN_RDMA                             ((0x0809  << 2) + 0xfe444000)
#define DMX_CLEAN_WDMA_0                           ((0x080a  << 2) + 0xfe444000)
#define DMX_CLEAN_WDMA_1                           ((0x080b  << 2) + 0xfe444000)
#define DMX_CLEAN_WDMA_2                           ((0x080c  << 2) + 0xfe444000)
#define DMX_CLEAN_WDMA_3                           ((0x080d  << 2) + 0xfe444000)
#define DMX_RDMA_ACTIVE                            ((0x080e  << 2) + 0xfe444000)
#define DMX_WDMA_ACTIVE_0                          ((0x080f  << 2) + 0xfe444000)
#define DMX_WDMA_ACTIVE_1                          ((0x0810  << 2) + 0xfe444000)
#define DMX_WDMA_ACTIVE_2                          ((0x0811  << 2) + 0xfe444000)
#define DMX_WDMA_ACTIVE_3                          ((0x0812  << 2) + 0xfe444000)
#define DMX_DMA_RDONE                              ((0x0813  << 2) + 0xfe444000)
#define DMX_DMA_WDONE_0                            ((0x0814  << 2) + 0xfe444000)
#define DMX_DMA_WDONE_1                            ((0x0815  << 2) + 0xfe444000)
#define DMX_DMA_WDONE_2                            ((0x0816  << 2) + 0xfe444000)
#define DMX_DMA_WDONE_3                            ((0x0817  << 2) + 0xfe444000)
#define DMX_RDES_ERR                               ((0x0818  << 2) + 0xfe444000)
#define DMX_RDES_LEN_ERR                           ((0x0819  << 2) + 0xfe444000)
#define DMX_WDES_ERR_0                             ((0x081a  << 2) + 0xfe444000)
#define DMX_WDES_ERR_1                             ((0x081b  << 2) + 0xfe444000)
#define DMX_WDES_ERR_2                             ((0x081c  << 2) + 0xfe444000)
#define DMX_WDES_ERR_3                             ((0x081d  << 2) + 0xfe444000)
#define DMX_DMA_BATCH_END_0                        ((0x081e  << 2) + 0xfe444000)
#define DMX_DMA_BATCH_END_1                        ((0x081f  << 2) + 0xfe444000)
#define DMX_DMA_BATCH_END_2                        ((0x0820  << 2) + 0xfe444000)
#define DMX_DMA_BATCH_END_3                        ((0x0821  << 2) + 0xfe444000)
#define DMX_WDES_EOC_DONE_0                        ((0x0822  << 2) + 0xfe444000)
#define DMX_WDES_EOC_DONE_1                        ((0x0823  << 2) + 0xfe444000)
#define DMX_WDES_EOC_DONE_2                        ((0x0824  << 2) + 0xfe444000)
#define DMX_WDES_EOC_DONE_3                        ((0x0825  << 2) + 0xfe444000)
#define DMX_WCH_RESP_ERR0                          ((0x0826  << 2) + 0xfe444000)
#define DMX_WCH_RESP_ERR1                          ((0x0827  << 2) + 0xfe444000)
#define DMX_WCH_RESP_ERR2                          ((0x0828  << 2) + 0xfe444000)
#define DMX_WCH_RESP_ERR3                          ((0x0829  << 2) + 0xfe444000)
#define DMX_UPDT_PKT_SYNC                          ((0x0830  << 2) + 0xfe444000)
#define DMX_RCHN_CFG                               ((0x0831  << 2) + 0xfe444000)
#define DMX_WCHN_CFG                               ((0x0832  << 2) + 0xfe444000)
#define DMX_MEM_PD_CRTL                            ((0x0833  << 2) + 0xfe444000)
#define DMX_DMA_BUS_CFG                            ((0x0834  << 2) + 0xfe444000)
#define DMX_DMA_GMW_CFG                            ((0x0835  << 2) + 0xfe444000)
#define DMX_DMA_GMR_CFG                            ((0x0836  << 2) + 0xfe444000)
//========================================================================
//  TS OUTPUT REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe442c00
// -----------------------------------------------
#define TS_OUTPUT_PID_RDY                          ((0x0000  << 2) + 0xfe442c00)
#define TS_OUTPUT_TEE_LOCK                         ((0x0001  << 2) + 0xfe442c00)
#define TS_OUTPUT_PID_CFG                          ((0x0002  << 2) + 0xfe442c00)
#define TS_OUTPUT_PID_DAT                          ((0x0003  << 2) + 0xfe442c00)
#define TS_OUTPUT_OUT_CFG                          ((0x0004  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_0                  ((0x0010  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_1                  ((0x0011  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_2                  ((0x0012  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_3                  ((0x0013  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_4                  ((0x0014  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_5                  ((0x0015  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_6                  ((0x0016  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_7                  ((0x0017  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_8                  ((0x0018  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_9                  ((0x0019  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_10                 ((0x001a  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_11                 ((0x001b  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_12                 ((0x001c  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_13                 ((0x001d  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_14                 ((0x001e  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_TAB_ENTRY_15                 ((0x001f  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_0_1                      ((0x0020  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_2_3                      ((0x0021  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_4_5                      ((0x0022  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_6_7                      ((0x0023  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_8_9                      ((0x0024  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_10_11                    ((0x0025  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_12_13                    ((0x0026  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_14_15                    ((0x0027  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_16_17                    ((0x0028  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_18_19                    ((0x0029  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_20_21                    ((0x002a  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_22_23                    ((0x002b  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_24_25                    ((0x002c  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_26_27                    ((0x002d  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_28_29                    ((0x002e  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_30_31                    ((0x002f  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_32_33                    ((0x0030  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_34_35                    ((0x0031  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_36_37                    ((0x0032  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_38_39                    ((0x0033  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_40_41                    ((0x0034  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_42_43                    ((0x0035  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_44_45                    ((0x0036  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_46_47                    ((0x0037  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_48_49                    ((0x0038  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_50_51                    ((0x0039  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_52_53                    ((0x003a  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_54_55                    ((0x003b  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_56_57                    ((0x003c  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_58_59                    ((0x003d  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_60_61                    ((0x003e  << 2) + 0xfe442c00)
#define TS_OUTPUT_SID_TAB_62_63                    ((0x003f  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_0                         ((0x0040  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_1                         ((0x0041  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_2                         ((0x0042  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_3                         ((0x0043  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_4                         ((0x0044  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_5                         ((0x0045  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_6                         ((0x0046  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_7                         ((0x0047  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_8                         ((0x0048  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_9                         ((0x0049  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_10                        ((0x004a  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_11                        ((0x004b  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_12                        ((0x004c  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_13                        ((0x004d  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_14                        ((0x004e  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_15                        ((0x004f  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_16                        ((0x0050  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_17                        ((0x0051  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_18                        ((0x0052  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_19                        ((0x0053  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_20                        ((0x0054  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_21                        ((0x0055  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_22                        ((0x0056  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_23                        ((0x0057  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_24                        ((0x0058  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_25                        ((0x0059  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_26                        ((0x005a  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_27                        ((0x005b  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_28                        ((0x005c  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_29                        ((0x005d  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_30                        ((0x005e  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_31                        ((0x005f  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_32                        ((0x0060  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_33                        ((0x0061  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_34                        ((0x0062  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_35                        ((0x0063  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_36                        ((0x0064  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_37                        ((0x0065  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_38                        ((0x0066  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_39                        ((0x0067  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_40                        ((0x0068  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_41                        ((0x0069  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_42                        ((0x006a  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_43                        ((0x006b  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_44                        ((0x006c  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_45                        ((0x006d  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_46                        ((0x006e  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_47                        ((0x006f  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_48                        ((0x0070  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_49                        ((0x0071  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_50                        ((0x0072  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_51                        ((0x0073  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_52                        ((0x0074  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_53                        ((0x0075  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_54                        ((0x0076  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_55                        ((0x0077  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_56                        ((0x0078  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_57                        ((0x0079  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_58                        ((0x007a  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_59                        ((0x007b  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_60                        ((0x007c  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_61                        ((0x007d  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_62                        ((0x007e  << 2) + 0xfe442c00)
#define TS_OUTPUT_ES_TAB_63                        ((0x007f  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_0                    ((0x0080  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_0                    ((0x0081  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_1                    ((0x0082  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_1                    ((0x0083  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_2                    ((0x0084  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_2                    ((0x0085  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_3                    ((0x0086  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_3                    ((0x0087  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_4                    ((0x0088  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_4                    ((0x0089  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_5                    ((0x008a  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_5                    ((0x008b  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_6                    ((0x008c  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_6                    ((0x008d  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_7                    ((0x008e  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_7                    ((0x008f  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_8                    ((0x0090  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_8                    ((0x0091  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_9                    ((0x0092  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_9                    ((0x0093  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_10                   ((0x0094  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_10                   ((0x0095  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_11                   ((0x0096  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_11                   ((0x0097  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_12                   ((0x0098  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_12                   ((0x0099  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_13                   ((0x009a  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_13                   ((0x009b  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_14                   ((0x009c  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_14                   ((0x009d  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_LSB_15                   ((0x009e  << 2) + 0xfe442c00)
#define TS_OUTPUT_PCR_REG_MSB_15                   ((0x009f  << 2) + 0xfe442c00)
//========================================================================
//  TSD DESC AES REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe442000
// -----------------------------------------------
#define TSD_PID_RDY                                ((0x0000  << 2) + 0xfe442000)
#define TSD_TEE_LOCK                               ((0x0001  << 2) + 0xfe442000)
#define TSD_PID_STS                                ((0x0003  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_0                        ((0x0004  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_0                        ((0x0005  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_1                        ((0x0006  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_1                        ((0x0007  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_2                        ((0x0008  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_2                        ((0x0009  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_3                        ((0x000a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_3                        ((0x000b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_4                        ((0x000c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_4                        ((0x000d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_5                        ((0x000e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_5                        ((0x000f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_6                        ((0x0010  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_6                        ((0x0011  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_7                        ((0x0012  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_7                        ((0x0013  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_8                        ((0x0014  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_8                        ((0x0015  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_9                        ((0x0016  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_9                        ((0x0017  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_10                       ((0x0018  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_10                       ((0x0019  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_11                       ((0x001a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_11                       ((0x001b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_12                       ((0x001c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_12                       ((0x001d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_13                       ((0x001e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_13                       ((0x001f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_14                       ((0x0020  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_14                       ((0x0021  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_15                       ((0x0022  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_15                       ((0x0023  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_16                       ((0x0024  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_16                       ((0x0025  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_17                       ((0x0026  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_17                       ((0x0027  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_18                       ((0x0028  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_18                       ((0x0029  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_19                       ((0x002a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_19                       ((0x002b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_20                       ((0x002c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_20                       ((0x002d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_21                       ((0x002e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_21                       ((0x002f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_22                       ((0x0030  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_22                       ((0x0031  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_23                       ((0x0032  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_23                       ((0x0033  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_24                       ((0x0034  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_24                       ((0x0035  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_25                       ((0x0036  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_25                       ((0x0037  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_26                       ((0x0038  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_26                       ((0x0039  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_27                       ((0x003a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_27                       ((0x003b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_28                       ((0x003c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_28                       ((0x003d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_29                       ((0x003e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_29                       ((0x003f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_30                       ((0x0040  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_30                       ((0x0041  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_31                       ((0x0042  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_31                       ((0x0043  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_32                       ((0x0044  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_32                       ((0x0045  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_33                       ((0x0046  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_33                       ((0x0047  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_34                       ((0x0048  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_34                       ((0x0049  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_35                       ((0x004a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_35                       ((0x004b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_36                       ((0x004c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_36                       ((0x004d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_37                       ((0x004e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_37                       ((0x004f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_38                       ((0x0050  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_38                       ((0x0051  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_39                       ((0x0052  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_39                       ((0x0053  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_40                       ((0x0054  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_40                       ((0x0055  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_41                       ((0x0056  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_41                       ((0x0057  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_42                       ((0x0058  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_42                       ((0x0059  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_43                       ((0x005a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_43                       ((0x005b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_44                       ((0x005c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_44                       ((0x005d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_45                       ((0x005e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_45                       ((0x005f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_46                       ((0x0060  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_46                       ((0x0061  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_47                       ((0x0062  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_47                       ((0x0063  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_48                       ((0x0064  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_48                       ((0x0065  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_49                       ((0x0066  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_49                       ((0x0067  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_50                       ((0x0068  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_50                       ((0x0069  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_51                       ((0x006a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_51                       ((0x006b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_52                       ((0x006c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_52                       ((0x006d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_53                       ((0x006e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_53                       ((0x006f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_54                       ((0x0070  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_54                       ((0x0071  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_55                       ((0x0072  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_55                       ((0x0073  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_56                       ((0x0074  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_56                       ((0x0075  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_57                       ((0x0076  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_57                       ((0x0077  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_58                       ((0x0078  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_58                       ((0x0079  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_59                       ((0x007a  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_59                       ((0x007b  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_60                       ((0x007c  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_60                       ((0x007d  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_61                       ((0x007e  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_61                       ((0x007f  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_62                       ((0x0080  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_62                       ((0x0081  << 2) + 0xfe442000)
#define TSD_PID_TABLE_LSB_63                       ((0x0082  << 2) + 0xfe442000)
#define TSD_PID_TABLE_MSB_63                       ((0x0083  << 2) + 0xfe442000)
//========================================================================
// SECURE TOP REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440300
// -----------------------------------------------
#define SEC_TOP_CFG_LOCKABLE                       ((0x0000  << 2) + 0xfe440300)
#define SEC_TOP_CFG_LOCK                           ((0x0001  << 2) + 0xfe440300)
#define SEC_TOP_CFG_WTO                            ((0x0002  << 2) + 0xfe440300)
#define SEC_TOP_N2_GENOUT                          ((0x0003  << 2) + 0xfe440300)
#define SEC_TOP_CFG_REG                            ((0x0004  << 2) + 0xfe440300)
#define SEC_TOP_NSK_CTRL                           ((0x0005  << 2) + 0xfe440300)
#define SEC_TOP_AKL_STS                            ((0x0006  << 2) + 0xfe440300)
#define SEC_TOP_ND_STATUS                          ((0x0007  << 2) + 0xfe440300)
#define SEC_TOP_CFG_DEMUX                          ((0x0008  << 2) + 0xfe440300)
#define SEC_TOP_CFG_DIF                            ((0x000c  << 2) + 0xfe440300)
#define SEC_TOP_NSK_HASH0                          ((0x0010  << 2) + 0xfe440300)
#define SEC_TOP_NSK_HASH1                          ((0x0011  << 2) + 0xfe440300)
#define SEC_TOP_NSK_HASH2                          ((0x0012  << 2) + 0xfe440300)
#define SEC_TOP_NSK_HASH3                          ((0x0013  << 2) + 0xfe440300)
#define SEC_TOP_PATH0_CTRL                         ((0x0028  << 2) + 0xfe440300)
#define SEC_TOP_PATH1_CTRL                         ((0x0029  << 2) + 0xfe440300)
#define SEC_TOP_PATH2_CTRL                         ((0x002a  << 2) + 0xfe440300)
#define SEC_TOP_PATH3_CTRL                         ((0x002b  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_PKT_CFG0                     ((0x002c  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_PKT_CFG1                     ((0x002d  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_PKT_CFG2                     ((0x002e  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_PKT_CFG3                     ((0x002f  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_FIFO_CFG0                    ((0x0030  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_FIFO_CFG1                    ((0x0031  << 2) + 0xfe440300)
#define SEC_TOP_TS_O_PATH_CTRL                     ((0x0032  << 2) + 0xfe440300)
#define SEC_TOP_CLEAN_DEMOD_INT                    ((0x0033  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_INT_MASK                     ((0x0034  << 2) + 0xfe440300)
#define SEC_TOP_DEMOD_INT_STATUS                   ((0x0035  << 2) + 0xfe440300)
#define SEC_TOP_TS_CHN0_ERR_STATUS                 ((0x0036  << 2) + 0xfe440300)
#define SEC_TOP_TS_CHN1_ERR_STATUS                 ((0x0037  << 2) + 0xfe440300)
#define SEC_TOP_TS_CHN2_ERR_STATUS                 ((0x0038  << 2) + 0xfe440300)
#define SEC_TOP_TS_CHN3_ERR_STATUS                 ((0x0039  << 2) + 0xfe440300)
//========================================================================
// TSE DESC AES REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe442800
// -----------------------------------------------
#define TSE_PID_RDY                                ((0x0000  << 2) + 0xfe442800)
#define TSE_TEE_LOCK                               ((0x0001  << 2) + 0xfe442800)
#define TSE_PID_STS                                ((0x0003  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_0                        ((0x0004  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_0                        ((0x0005  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_1                        ((0x0006  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_1                        ((0x0007  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_2                        ((0x0008  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_2                        ((0x0009  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_3                        ((0x000a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_3                        ((0x000b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_4                        ((0x000c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_4                        ((0x000d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_5                        ((0x000e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_5                        ((0x000f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_6                        ((0x0010  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_6                        ((0x0011  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_7                        ((0x0012  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_7                        ((0x0013  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_8                        ((0x0014  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_8                        ((0x0015  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_9                        ((0x0016  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_9                        ((0x0017  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_10                       ((0x0018  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_10                       ((0x0019  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_11                       ((0x001a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_11                       ((0x001b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_12                       ((0x001c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_12                       ((0x001d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_13                       ((0x001e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_13                       ((0x001f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_14                       ((0x0020  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_14                       ((0x0021  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_15                       ((0x0022  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_15                       ((0x0023  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_16                       ((0x0024  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_16                       ((0x0025  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_17                       ((0x0026  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_17                       ((0x0027  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_18                       ((0x0028  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_18                       ((0x0029  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_19                       ((0x002a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_19                       ((0x002b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_20                       ((0x002c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_20                       ((0x002d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_21                       ((0x002e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_21                       ((0x002f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_22                       ((0x0030  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_22                       ((0x0031  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_23                       ((0x0032  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_23                       ((0x0033  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_24                       ((0x0034  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_24                       ((0x0035  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_25                       ((0x0036  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_25                       ((0x0037  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_26                       ((0x0038  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_26                       ((0x0039  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_27                       ((0x003a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_27                       ((0x003b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_28                       ((0x003c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_28                       ((0x003d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_29                       ((0x003e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_29                       ((0x003f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_30                       ((0x0040  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_30                       ((0x0041  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_31                       ((0x0042  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_31                       ((0x0043  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_32                       ((0x0044  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_32                       ((0x0045  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_33                       ((0x0046  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_33                       ((0x0047  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_34                       ((0x0048  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_34                       ((0x0049  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_35                       ((0x004a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_35                       ((0x004b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_36                       ((0x004c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_36                       ((0x004d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_37                       ((0x004e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_37                       ((0x004f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_38                       ((0x0050  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_38                       ((0x0051  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_39                       ((0x0052  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_39                       ((0x0053  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_40                       ((0x0054  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_40                       ((0x0055  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_41                       ((0x0056  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_41                       ((0x0057  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_42                       ((0x0058  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_42                       ((0x0059  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_43                       ((0x005a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_43                       ((0x005b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_44                       ((0x005c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_44                       ((0x005d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_45                       ((0x005e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_45                       ((0x005f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_46                       ((0x0060  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_46                       ((0x0061  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_47                       ((0x0062  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_47                       ((0x0063  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_48                       ((0x0064  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_48                       ((0x0065  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_49                       ((0x0066  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_49                       ((0x0067  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_50                       ((0x0068  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_50                       ((0x0069  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_51                       ((0x006a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_51                       ((0x006b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_52                       ((0x006c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_52                       ((0x006d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_53                       ((0x006e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_53                       ((0x006f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_54                       ((0x0070  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_54                       ((0x0071  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_55                       ((0x0072  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_55                       ((0x0073  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_56                       ((0x0074  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_56                       ((0x0075  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_57                       ((0x0076  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_57                       ((0x0077  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_58                       ((0x0078  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_58                       ((0x0079  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_59                       ((0x007a  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_59                       ((0x007b  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_60                       ((0x007c  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_60                       ((0x007d  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_61                       ((0x007e  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_61                       ((0x007f  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_62                       ((0x0080  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_62                       ((0x0081  << 2) + 0xfe442800)
#define TSE_PID_TABLE_LSB_63                       ((0x0082  << 2) + 0xfe442800)
#define TSE_PID_TABLE_MSB_63                       ((0x0083  << 2) + 0xfe442800)
//========================================================================
// TSN DESC REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe442400
// -----------------------------------------------
#define TSN_PID_RDY                                ((0x0000  << 2) + 0xfe442400)
#define TSN_TEE_LOCK                               ((0x0001  << 2) + 0xfe442400)
#define TSN_PID_STS                                ((0x0003  << 2) + 0xfe442400)
#define TSN_PID_TABLE_0                            ((0x0004  << 2) + 0xfe442400)
#define TSN_PID_TABLE_1                            ((0x0005  << 2) + 0xfe442400)
#define TSN_PID_TABLE_2                            ((0x0006  << 2) + 0xfe442400)
#define TSN_PID_TABLE_3                            ((0x0007  << 2) + 0xfe442400)
#define TSN_PID_TABLE_4                            ((0x0008  << 2) + 0xfe442400)
#define TSN_PID_TABLE_5                            ((0x0009  << 2) + 0xfe442400)
#define TSN_PID_TABLE_6                            ((0x000a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_7                            ((0x000b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_8                            ((0x000c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_9                            ((0x000d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_10                           ((0x000e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_11                           ((0x000f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_12                           ((0x0010  << 2) + 0xfe442400)
#define TSN_PID_TABLE_13                           ((0x0011  << 2) + 0xfe442400)
#define TSN_PID_TABLE_14                           ((0x0012  << 2) + 0xfe442400)
#define TSN_PID_TABLE_15                           ((0x0013  << 2) + 0xfe442400)
#define TSN_PID_TABLE_16                           ((0x0014  << 2) + 0xfe442400)
#define TSN_PID_TABLE_17                           ((0x0015  << 2) + 0xfe442400)
#define TSN_PID_TABLE_18                           ((0x0016  << 2) + 0xfe442400)
#define TSN_PID_TABLE_19                           ((0x0017  << 2) + 0xfe442400)
#define TSN_PID_TABLE_20                           ((0x0018  << 2) + 0xfe442400)
#define TSN_PID_TABLE_21                           ((0x0019  << 2) + 0xfe442400)
#define TSN_PID_TABLE_22                           ((0x001a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_23                           ((0x001b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_24                           ((0x001c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_25                           ((0x001d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_26                           ((0x001e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_27                           ((0x001f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_28                           ((0x0020  << 2) + 0xfe442400)
#define TSN_PID_TABLE_29                           ((0x0021  << 2) + 0xfe442400)
#define TSN_PID_TABLE_30                           ((0x0022  << 2) + 0xfe442400)
#define TSN_PID_TABLE_31                           ((0x0023  << 2) + 0xfe442400)
#define TSN_PID_TABLE_32                           ((0x0024  << 2) + 0xfe442400)
#define TSN_PID_TABLE_33                           ((0x0025  << 2) + 0xfe442400)
#define TSN_PID_TABLE_34                           ((0x0026  << 2) + 0xfe442400)
#define TSN_PID_TABLE_35                           ((0x0027  << 2) + 0xfe442400)
#define TSN_PID_TABLE_36                           ((0x0028  << 2) + 0xfe442400)
#define TSN_PID_TABLE_37                           ((0x0029  << 2) + 0xfe442400)
#define TSN_PID_TABLE_38                           ((0x002a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_39                           ((0x002b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_40                           ((0x002c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_41                           ((0x002d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_42                           ((0x002e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_43                           ((0x002f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_44                           ((0x0030  << 2) + 0xfe442400)
#define TSN_PID_TABLE_45                           ((0x0031  << 2) + 0xfe442400)
#define TSN_PID_TABLE_46                           ((0x0032  << 2) + 0xfe442400)
#define TSN_PID_TABLE_47                           ((0x0033  << 2) + 0xfe442400)
#define TSN_PID_TABLE_48                           ((0x0034  << 2) + 0xfe442400)
#define TSN_PID_TABLE_49                           ((0x0035  << 2) + 0xfe442400)
#define TSN_PID_TABLE_50                           ((0x0036  << 2) + 0xfe442400)
#define TSN_PID_TABLE_51                           ((0x0037  << 2) + 0xfe442400)
#define TSN_PID_TABLE_52                           ((0x0038  << 2) + 0xfe442400)
#define TSN_PID_TABLE_53                           ((0x0039  << 2) + 0xfe442400)
#define TSN_PID_TABLE_54                           ((0x003a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_55                           ((0x003b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_56                           ((0x003c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_57                           ((0x003d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_58                           ((0x003e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_59                           ((0x003f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_60                           ((0x0040  << 2) + 0xfe442400)
#define TSN_PID_TABLE_61                           ((0x0041  << 2) + 0xfe442400)
#define TSN_PID_TABLE_62                           ((0x0042  << 2) + 0xfe442400)
#define TSN_PID_TABLE_63                           ((0x0043  << 2) + 0xfe442400)
#define TSN_PID_TABLE_64                           ((0x0044  << 2) + 0xfe442400)
#define TSN_PID_TABLE_65                           ((0x0045  << 2) + 0xfe442400)
#define TSN_PID_TABLE_66                           ((0x0046  << 2) + 0xfe442400)
#define TSN_PID_TABLE_67                           ((0x0047  << 2) + 0xfe442400)
#define TSN_PID_TABLE_68                           ((0x0048  << 2) + 0xfe442400)
#define TSN_PID_TABLE_69                           ((0x0049  << 2) + 0xfe442400)
#define TSN_PID_TABLE_70                           ((0x004a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_71                           ((0x004b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_72                           ((0x004c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_73                           ((0x004d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_74                           ((0x004e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_75                           ((0x004f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_76                           ((0x0050  << 2) + 0xfe442400)
#define TSN_PID_TABLE_77                           ((0x0051  << 2) + 0xfe442400)
#define TSN_PID_TABLE_78                           ((0x0052  << 2) + 0xfe442400)
#define TSN_PID_TABLE_79                           ((0x0053  << 2) + 0xfe442400)
#define TSN_PID_TABLE_80                           ((0x0054  << 2) + 0xfe442400)
#define TSN_PID_TABLE_81                           ((0x0055  << 2) + 0xfe442400)
#define TSN_PID_TABLE_82                           ((0x0056  << 2) + 0xfe442400)
#define TSN_PID_TABLE_83                           ((0x0057  << 2) + 0xfe442400)
#define TSN_PID_TABLE_84                           ((0x0058  << 2) + 0xfe442400)
#define TSN_PID_TABLE_85                           ((0x0059  << 2) + 0xfe442400)
#define TSN_PID_TABLE_86                           ((0x005a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_87                           ((0x005b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_88                           ((0x005c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_89                           ((0x005d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_90                           ((0x005e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_91                           ((0x005f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_92                           ((0x0060  << 2) + 0xfe442400)
#define TSN_PID_TABLE_93                           ((0x0061  << 2) + 0xfe442400)
#define TSN_PID_TABLE_94                           ((0x0062  << 2) + 0xfe442400)
#define TSN_PID_TABLE_95                           ((0x0063  << 2) + 0xfe442400)
#define TSN_PID_TABLE_96                           ((0x0064  << 2) + 0xfe442400)
#define TSN_PID_TABLE_97                           ((0x0065  << 2) + 0xfe442400)
#define TSN_PID_TABLE_98                           ((0x0066  << 2) + 0xfe442400)
#define TSN_PID_TABLE_99                           ((0x0067  << 2) + 0xfe442400)
#define TSN_PID_TABLE_100                          ((0x0068  << 2) + 0xfe442400)
#define TSN_PID_TABLE_101                          ((0x0069  << 2) + 0xfe442400)
#define TSN_PID_TABLE_102                          ((0x006a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_103                          ((0x006b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_104                          ((0x006c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_105                          ((0x006d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_106                          ((0x006e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_107                          ((0x006f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_108                          ((0x0070  << 2) + 0xfe442400)
#define TSN_PID_TABLE_109                          ((0x0071  << 2) + 0xfe442400)
#define TSN_PID_TABLE_110                          ((0x0072  << 2) + 0xfe442400)
#define TSN_PID_TABLE_111                          ((0x0073  << 2) + 0xfe442400)
#define TSN_PID_TABLE_112                          ((0x0074  << 2) + 0xfe442400)
#define TSN_PID_TABLE_113                          ((0x0075  << 2) + 0xfe442400)
#define TSN_PID_TABLE_114                          ((0x0076  << 2) + 0xfe442400)
#define TSN_PID_TABLE_115                          ((0x0077  << 2) + 0xfe442400)
#define TSN_PID_TABLE_116                          ((0x0078  << 2) + 0xfe442400)
#define TSN_PID_TABLE_117                          ((0x0079  << 2) + 0xfe442400)
#define TSN_PID_TABLE_118                          ((0x007a  << 2) + 0xfe442400)
#define TSN_PID_TABLE_119                          ((0x007b  << 2) + 0xfe442400)
#define TSN_PID_TABLE_120                          ((0x007c  << 2) + 0xfe442400)
#define TSN_PID_TABLE_121                          ((0x007d  << 2) + 0xfe442400)
#define TSN_PID_TABLE_122                          ((0x007e  << 2) + 0xfe442400)
#define TSN_PID_TABLE_123                          ((0x007f  << 2) + 0xfe442400)
#define TSN_PID_TABLE_124                          ((0x0080  << 2) + 0xfe442400)
#define TSN_PID_TABLE_125                          ((0x0081  << 2) + 0xfe442400)
#define TSN_PID_TABLE_126                          ((0x0082  << 2) + 0xfe442400)
#define TSN_PID_TABLE_127                          ((0x0083  << 2) + 0xfe442400)
//========================================================================
// RNG REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440700
// -----------------------------------------------
#define RNG_TEE_READY                              ((0x0000  << 2) + 0xfe440700)
#define RNG_TEE_LOCK                               ((0x0001  << 2) + 0xfe440700)
#define RNG_TEE_CFG                                ((0x0002  << 2) + 0xfe440700)
#define RNG_TEE_NIST_OUT                           ((0x0003  << 2) + 0xfe440700)
#define RNG_TEE_OUT0                               ((0x0004  << 2) + 0xfe440700)
#define RNG_TEE_OUT1                               ((0x0005  << 2) + 0xfe440700)
#define RNG_TEE_OUT2                               ((0x0006  << 2) + 0xfe440700)
#define RNG_TEE_OUT3                               ((0x0007  << 2) + 0xfe440700)
#define RNG_CFG_RING                               ((0x0010  << 2) + 0xfe440700)
#define RNG_CFG_RESEED                             ((0x0011  << 2) + 0xfe440700)
#define RNG_CFG_HEALTH                             ((0x0012  << 2) + 0xfe440700)
#define RNG_CFG_MISC                               ((0x0013  << 2) + 0xfe440700)
#define RNG_REE_READY                              ((0x0020  << 2) + 0xfe440700)
#define RNG_REE_DEBUG                              ((0x0021  << 2) + 0xfe440700)
#define RNG_REE_CFG                                ((0x0022  << 2) + 0xfe440700)
#define RNG_REE_OUT0                               ((0x0024  << 2) + 0xfe440700)
#define RNG_REE_OUT1                               ((0x0025  << 2) + 0xfe440700)
#define RNG_REE_OUT2                               ((0x0026  << 2) + 0xfe440700)
#define RNG_REE_OUT3                               ((0x0027  << 2) + 0xfe440700)
//========================================================================
// OTP REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440000
// -----------------------------------------------
#define OTP_TEE_RDY                                ((0x0000  << 2) + 0xfe440000)
#define OTP_TEE_DEBUG                              ((0x0001  << 2) + 0xfe440000)
#define OTP_TEE_CFG                                ((0x0002  << 2) + 0xfe440000)
#define OTP_TEE_WR_DAT                             ((0x0004  << 2) + 0xfe440000)
#define OTP_TEE_RD_DAT                             ((0x0008  << 2) + 0xfe440000)
#define OTP_LIC                                    ((0x0010  << 2) + 0xfe440000)
#define OTP_AML_ID_L                               ((0x0020  << 2) + 0xfe440000)
#define OTP_AML_ID_H                               ((0x0021  << 2) + 0xfe440000)
#define OTP_ACGK_ID_L                              ((0x0022  << 2) + 0xfe440000)
#define OTP_ACGK_ID_H                              ((0x0023  << 2) + 0xfe440000)
#define OTP_DVGK_ID_L                              ((0x0024  << 2) + 0xfe440000)
#define OTP_DVGK_ID_H                              ((0x0025  << 2) + 0xfe440000)
#define OTP_DVUK_ID_L                              ((0x0026  << 2) + 0xfe440000)
#define OTP_DVUK_ID_H                              ((0x0027  << 2) + 0xfe440000)
#define OTP_DGPK_ID_L                              ((0x0028  << 2) + 0xfe440000)
#define OTP_DGPK_ID_H                              ((0x0029  << 2) + 0xfe440000)
#define OTP_SECPU_ID_L                             ((0x002a  << 2) + 0xfe440000)
#define OTP_SECPU_ID_H                             ((0x002b  << 2) + 0xfe440000)
#define OTP_ETSI012_ID_L                           ((0x002c  << 2) + 0xfe440000)
#define OTP_ETSI012_ID_H                           ((0x002d  << 2) + 0xfe440000)
#define OTP_ETSI3_ID_L                             ((0x002e  << 2) + 0xfe440000)
#define OTP_ETSI3_ID_H                             ((0x002f  << 2) + 0xfe440000)
#define OTP_MSR_ID_L                               ((0x0030  << 2) + 0xfe440000)
#define OTP_MSR_ID_H                               ((0x0031  << 2) + 0xfe440000)
#define OTP_VO_ID_L                                ((0x0032  << 2) + 0xfe440000)
#define OTP_VO_ID_H                                ((0x0033  << 2) + 0xfe440000)
#define OTP_NUID_ID_L                              ((0x0034  << 2) + 0xfe440000)
#define OTP_NUID_ID_H                              ((0x0035  << 2) + 0xfe440000)
#define OTP_CONAX_ID_L                             ((0x0036  << 2) + 0xfe440000)
#define OTP_CONAX_ID_H                             ((0x0037  << 2) + 0xfe440000)
#define OTP_NSK_ID_L                               ((0x0038  << 2) + 0xfe440000)
#define OTP_NSK_ID_H                               ((0x0039  << 2) + 0xfe440000)
#define OTP_REE_RDY                                ((0x0040  << 2) + 0xfe440000)
#define OTP_REE_DEBUG                              ((0x0041  << 2) + 0xfe440000)
#define OTP_REE_CFG                                ((0x0042  << 2) + 0xfe440000)
#define OTP_MRK_CHKNUM                             ((0x0043  << 2) + 0xfe440000)
#define OTP_REE_RD_DAT                             ((0x0048  << 2) + 0xfe440000)


#define OTP_LIC00                                  (OTP_LIC + 0x00)
#define OTP_LIC01                                  (OTP_LIC + 0x04)
#define OTP_LIC02                                  (OTP_LIC + 0x08)
#define OTP_LIC03                                  (OTP_LIC + 0x0C)

#define OTP_LIC10                                  (OTP_LIC + 0x10)
#define OTP_LIC11                                  (OTP_LIC + 0x14)
#define OTP_LIC12                                  (OTP_LIC + 0x18)
#define OTP_LIC13                                  (OTP_LIC + 0x1C)

#define OTP_LIC20                                  (OTP_LIC + 0x20)
#define OTP_LIC21                                  (OTP_LIC + 0x24)
#define OTP_LIC22                                  (OTP_LIC + 0x28)
#define OTP_LIC23                                  (OTP_LIC + 0x2C)

#define OTP_LIC30                                  (OTP_LIC + 0x30)
#define OTP_LIC31                                  (OTP_LIC + 0x34)
#define OTP_LIC32                                  (OTP_LIC + 0x38)
#define OTP_LIC33                                  (OTP_LIC + 0x3C)

#define OTP_LIC0                                   (OTP_LIC00)

//========================================================================
// KL REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440200
// -----------------------------------------------
#define MKL_TEE_RDY                                ((0x0000  << 2) + 0xfe440200)
#define MKL_TEE_DEBUG                              ((0x0001  << 2) + 0xfe440200)
#define MKL_TEE_CFG                                ((0x0002  << 2) + 0xfe440200)
#define MKL_TEE_CMD                                ((0x0003  << 2) + 0xfe440200)
#define MKL_TEE_EK                                 ((0x0004  << 2) + 0xfe440200)
#define MKL_TEE_CR_0                               ((0x001c  << 2) + 0xfe440200)
#define MKL_TEE_CR_1                               ((0x001d  << 2) + 0xfe440200)
#define MKL_TEE_CR_2                               ((0x001e  << 2) + 0xfe440200)
#define MKL_TEE_CR_3                               ((0x001f  << 2) + 0xfe440200)
#define MKL_REE_RDY                                ((0x0020  << 2) + 0xfe440200)
#define MKL_REE_DEBUG                              ((0x0021  << 2) + 0xfe440200)
#define MKL_REE_CFG                                ((0x0022  << 2) + 0xfe440200)
#define MKL_REE_CMD                                ((0x0023  << 2) + 0xfe440200)
#define MKL_REE_EK                                 ((0x0024  << 2) + 0xfe440200)
//========================================================================
// DMA REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440400
// -----------------------------------------------
#define DMA_CORE_DSC_0                             ((0x0000  << 2) + 0xfe440400)
#define DMA_CORE_DSC_1                             ((0x0001  << 2) + 0xfe440400)
#define DMA_CORE_DSC_2                             ((0x0002  << 2) + 0xfe440400)
#define DMA_CORE_DSC_3                             ((0x0003  << 2) + 0xfe440400)
#define DMA_CORE_DSC_4                             ((0x0004  << 2) + 0xfe440400)
#define DMA_CORE_DSC_5                             ((0x0005  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_0                         ((0x0008  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_1                         ((0x0009  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_2                         ((0x000a  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_3                         ((0x000b  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_4                         ((0x000c  << 2) + 0xfe440400)
#define DMA_CORE_IRQ_STS_5                         ((0x000d  << 2) + 0xfe440400)
#define DMA_CORE_CFG_REG                           ((0x0010  << 2) + 0xfe440400)
#define DMA_CORE_CFG_SEC_LSB                       ((0x0011  << 2) + 0xfe440400)
#define DMA_CORE_CFG_SEC_MSB                       ((0x0012  << 2) + 0xfe440400)
//========================================================================
// KT REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440500
// -----------------------------------------------
#define KT_TEE_RDY                                 ((0x0000  << 2) + 0xfe440500)
#define KT_TEE_RDY2                                ((0x0001  << 2) + 0xfe440500)
#define KT_TEE_CFG                                 ((0x0002  << 2) + 0xfe440500)
#define KT_TEE_STS                                 ((0x0003  << 2) + 0xfe440500)
#define KT_TEE_KEY0                                ((0x0004  << 2) + 0xfe440500)
#define KT_TEE_KEY1                                ((0x0005  << 2) + 0xfe440500)
#define KT_TEE_KEY2                                ((0x0006  << 2) + 0xfe440500)
#define KT_TEE_KEY3                                ((0x0007  << 2) + 0xfe440500)
#define KT_REE_RDY                                 ((0x0020  << 2) + 0xfe440500)
#define KT_REE_RDY2                                ((0x0021  << 2) + 0xfe440500)
#define KT_REE_CFG                                 ((0x0022  << 2) + 0xfe440500)
#define KT_REE_STS                                 ((0x0023  << 2) + 0xfe440500)
#define KT_REE_KEY0                                ((0x0024  << 2) + 0xfe440500)
#define KT_REE_KEY1                                ((0x0025  << 2) + 0xfe440500)
#define KT_REE_KEY2                                ((0x0026  << 2) + 0xfe440500)
#define KT_REE_KEY3                                ((0x0027  << 2) + 0xfe440500)
//========================================================================
// CERT REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe440600
// -----------------------------------------------
//========================================================================
// SP REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe441000
// -----------------------------------------------
//ree domain
#define REE_SCPU2REE_CSR_ADDR                      ((0x0300  << 2) + 0xfe441000)
#define REE_SCPU2REE_DATA_ST_ADDR                  ((0x0380  << 2) + 0xfe441000)
#define REE_SCPU2REE_DATA_ED_ADDR                  ((0x039f  << 2) + 0xfe441000)
#define REE_REE2SCPU_CSR_ADDR                      ((0x0200  << 2) + 0xfe441000)
#define REE_REE2SCPU_DATA_ST_ADDR                  ((0x0280  << 2) + 0xfe441000)
#define REE_REE2SCPU_DATA_ED_ADDR                  ((0x029f  << 2) + 0xfe441000)
//tee domain
#define TEE_SCPU2TEE_CSR_ADDR                      ((0x0100  << 2) + 0xfe441000)
#define TEE_SCPU2TEE_DATA_ST_ADDR                  ((0x0180  << 2) + 0xfe441000)
#define TEE_SCPU2TEE_DATA_ED_ADDR                  ((0x019f  << 2) + 0xfe441000)
#define TEE_TEE2SCPU_CSR_ADDR                      ((0x0000  << 2) + 0xfe441000)
#define TEE_TEE2SCPU_DATA_ST_ADDR                  ((0x0080  << 2) + 0xfe441000)
#define TEE_TEE2SCPU_DATA_ED_ADDR                  ((0x009f  << 2) + 0xfe441000)
//========================================================================
// NSK REG - Registers
//========================================================================
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe450000
// -----------------------------------------------
//
// Closing file:  REG_LIST_SECURITY_RTL.h
//
//
// Reading file:  REG_LIST_DEMUX_RTL.h
//
// synopsys translate_off
// synopsys translate_on
// -----------------------------------------------
// REG_BASE:  REGISTER_BASE_ADDR = 0xfe034000
// -----------------------------------------------
// There are two instantiations under one CBUS slave.  Each CBUS slave can support
// 256 registers.  Each demux is allocated 128 registers so set the offset in
// the middle
// Copy this define but don't add a base address
#define SECOND_DEMUX_OFFSET_0  0x50
#define THIRD_DEMUX_OFFSET_0   0xa0
//========================================================================
//  STB TOP Registers				    (8'hf0 - 8'hf7)
//========================================================================
// Bit 5:4 -- fec_sel_demux_2
// Bit 3:2 -- fec_sel_demux_1
// Bit 1:0 -- fec_sel_demux_0
#define TS_TOP_CONFIG1                             ((0x004f  << 2) + 0xfe034000)
// Bit 31:24 -- file_m2ts_skip_bytes_hiu1
// Bit 23:22 -- reserved
// Bit 21 -- ts_hiu_enable_hiu1
// Bit 20:16 -- fec_clk_div_hiu1
// Bit 15:8 -- TS_package_length_sub_1_hiu1 (default : 187)
// Bit 7:0 -- fec_sync_byte_hiu1 (default : 0x47)
#define TS_HIU1_CONFIG                             ((0x004e  << 2) + 0xfe034000)
//bit[1:0]--   stb_recorder2_sel
#define STB_RECORDER2_CNTL                         ((0x00ee  << 2) + 0xfe034000)
// bit [11]--   s2p2_disable
// bit [10:7]-- s2p2_clk_div
// bit [6:0]--  fec_serial_control_2
#define STB_S2P2_CONFIG                            ((0x00ef  << 2) + 0xfe034000)
// bit 30:28 -- ciplus_o_sel
// bit 27:26 -- ciplus_i_sel
// bit 25 -- use FAIL fro TS2
// bit 24 -- use FAIL fro TS1
// bit 23 -- use FAIL fro TS0
// bit 22 -- invert fec_error for S2P1
// bit 21 -- invert fec_data for S2P1
// bit 20 -- invert fec_sync for S2P1
// bit 19 -- invert fec_valid for S2P1
// bit 18 -- invert fec_clk for S2P1
// bit 17:16 -- fec_s_sel for S2P1  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
// Bit 15 -- enable_des_pl_clk
// Bit 14 -- ts_out_select[3]
// Bit 13 --  use FAIL for TS3
// Bit 12:10 -- ts_out_select[2:0], 0-TS0, 1-TS1, 2-TS2, 3-TS3, 4-S2P2, 5-S2P1, 6-S2P0, 7-File, 8-File1
// bit 9:8 -- des_i_sel 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 - reserved
// bit 7 -- enable_des_pl
// bit 6 -- invert fec_error for S2P0
// bit 5 -- invert fec_data for S2P0
// bit 4 -- invert fec_sync for S2P0
// bit 3 -- invert fec_valid for S2P0
// bit 2 -- invert fec_clk for S2P0
// bit 1:0 -- fec_s_sel for S2P0  00 - select TS0, 01 -- select TS1, 10 -- select TS2, 11 - reserved
#define STB_TOP_CONFIG                             ((0x00f0  << 2) + 0xfe034000)
// 31:28 - s2p1_clk_div
// 27:24 - s2p0_clk_div
// 23    - s2p1_disable
// 22    - s2p0_disable
// 21    - Reserved
// 20 -- TS_OUT_error_INVERT
// 19 -- TS_OUT_data_INVERT
// 18 -- TS_OUT_sync_INVERT
// 17 -- TS_OUT_valid_INVERT
// 16 -- TS_OUT_clk_INVERT
// 15:8 -- TS_package_length_sub_1 (default : 187)
//  7:0 -- fec_sync_byte (default : 0x47)
#define TS_TOP_CONFIG                              ((0x00f1  << 2) + 0xfe034000)
// Bit 25:24 -- transport_scrambling_control_odd_2 // should be 3
// Bit 23:16 -- file_m2ts_skip_bytes
// Bit 15:8 -- des_out_dly
// Bit 7:6 -- transport_scrambling_control_odd // should be 3
// Bit 5 -- ts_hiu_enable
// Bit 4:0 -- fec_clk_div
#define TS_FILE_CONFIG                             ((0x00f2  << 2) + 0xfe034000)
// Bit 19:14 -- des_2 ts pl state   -- Read Only
// Bit 13:8 -- des ts pl state   -- Read Only
// Bit 3:0 PID index to 8 PID to get key-set
// auto increase after TS_PL_PID_DATA read/write
#define TS_PL_PID_INDEX                            ((0x00f3  << 2) + 0xfe034000)
// Bit 13 -- PID match disble
// Bit 12:0 -- PID
#define TS_PL_PID_DATA                             ((0x00f4  << 2) + 0xfe034000)
#define COMM_DESC_KEY0                             ((0x00f5  << 2) + 0xfe034000)
#define COMM_DESC_KEY1                             ((0x00f6  << 2) + 0xfe034000)
#define COMM_DESC_KEY_RW                           ((0x00f7  << 2) + 0xfe034000)
// CI+ Register defines
// Bits[31:0] of the key
#define CIPLUS_KEY0                                ((0x00f8  << 2) + 0xfe034000)
// Bits[63:32] of the key
#define CIPLUS_KEY1                                ((0x00f9  << 2) + 0xfe034000)
// Bits[95:64] of the key
#define CIPLUS_KEY2                                ((0x00fa  << 2) + 0xfe034000)
// Bits[127:96] of the key
#define CIPLUS_KEY3                                ((0x00fb  << 2) + 0xfe034000)
// bit[5] write AES IV B value
// bit[4] write AES IV A value
// bit[3] write AES B key
// bit[2] write AES A key
// bit[1] write DES B key
// bit[0] write DES A key
#define CIPLUS_KEY_WR                              ((0x00fc  << 2) + 0xfe034000)
// [15:8]   TS out delay.  This controls the rate at which the CIplus module drives TS out
// [3]      General enable for the ciplus module
// [2]      AES CBC disable (default should be 0 to enable AES CBC)
// [1]      AES Enable
// [0]      DES Enable
#define CIPLUS_CONFIG                              ((0x00fd  << 2) + 0xfe034000)
// bit[31:28] AES IV endian
// bit[27:24] AES message out endian
// bit[23:20] AES message in endian
// bit[19:16] AES key endian
// bit[15:11]  unused
// bit[10:8]  DES message out endian
// bit[6:4]   DES message in endian
// bit[2:0]   DES key endian
#define CIPLUS_ENDIAN                              ((0x00fe  << 2) + 0xfe034000)
// bit 15:8 - des_out_dly_2
// bit   7 - reserved
// Bit   6-- enable_des_pl_clk_2
// bit   5 - enable_des_pl_2
// bit 4:2 -- use_des_2  bit[2] -- demux0, bit[3] -- demux1, bit[4] -- demux2
// bit 1:0 -- des_i_sel_2 00 -- select_fec_0, 01 -- select_fec_1, 10 -- select_fec_2, 11 - reserved
#define COMM_DESC_2_CTL                            ((0x00ff  << 2) + 0xfe034000)
//
// NOTE:  Don't process the demux registers using the standard create_headers.... perl script.
//        Instead, since the demux has multiple instances (and many registers) use a separate
//        script to create a separate stb_define.h for C-code.
//========================================================================
//  STB Registers				    (8'h00 - 8'h4f)
//
//========================================================================
// STB registers are 8'h0x
// Bit 15:0 -- version number : 0x0002  (v0.01)
// Bit 16 -- fec_select[3]
// Bit 15 -- fec_core_select 1 - select descramble output
// Bit 14:12 -  fec_select[2:0] 0-TS0, 1-TS1, 2-TS2, 3-TS3, 4-S2P2, 5-S2P1, 6-S2P0, 7-File, 8-File1
// Bit 11 -- FEC_CLK
// Bit 10 -- SOP
// Bit 9 -- D_VALID
// Bit 8 -- D_FAIL
// Bit 7:0 -- D_DATA 7:0
// bit 31 -- enable_free_clk_fec_data_valid
// bit 30 -- enable_free_clk_stb_reg
// bit 29 -- always_use_pes_package_length
// bit 28 -- disable_pre_incomplete_section_fix
// bit 27 -- pointer_field_multi_pre_en
// bit 26 -- ignore_pre_incomplete_section
// bit 25 -- video2_enable
// bit 24:22 -- video2_type
// bit 21 -- do_not_trust_pes_package_length
// bit 20 (bit 4) -- Bypass use recoder path
// bit 19 (bit 3) -- clear_PID_continuity_counter_valid
// bit 18 (bit 2) -- Disable Splicing
// bit 17 (bit 1) -- Insert PES_STRONG_SYNC in Audio PES
// bit 16 (bit 0) -- Insert PES_STRONG_SYNC in Video PES
// Bit 15 - do not trust section length
// Bit 14 - om cmd push even zero
// Bit 13 - set_buff_ready_even_not_busy
// Bit 12 - SUB, OTHER PES interrupt at beginning of PES
// Bit 11 - discard_av_package -- for ts_recorder use only
// Bit 10 - ts_recorder_select  0:after PID filter 1:before PID filter
// Bit 9 - ts_recorder_enable
// Bit 8 - (table_id == 0xff) means section_end
// Bit 7 - do not send uncomplete section
// Bit 6 - do not discard duplicate package
// Bit 5 - search SOP when transport_error_indicator
// Bit 4 - stb demux enable
// Bit 3 - do not reset state machine on SOP
// Bit 2 - search SOP when error happened ( when ignore_fail_n_sop, will have this case)
// Bit 1 - do not use SOP input ( check FEC sync byte instead )
// Bit 0 - ignore fec_error bit when non sop ( check error on SOP only)
// bit 15:8 demux package length - 1 ( default : 187 )
// bit 7:0 default is 0x47
// bit 31:16 -- filter memory write data hi[31:16]
// bit 15:0 -- filter memory write data low [15:0]
// bit 31:24 -- advanced setting hi
// bit 23:16 -- advanced setting low
// bit 15 -- filter memory write data request
// bit 7:0 -- filter memory write addr
// bit 13:8 demux state  -- read only
// bit 7:4 -- maxnum section filter compare address
// bit 3:0 -- maxnum PID filter compare address
// bit 15 - transport_error_indicator
// bit 14 - payload_unit_start_indicator
// bit 13 - transport_priority
// bit 12:0 - PID
// bit 7:6 transport_scrambling_control
// bit 5:4 adaptation_field_control
// bit 3:0 continuity_counter
// bit 15:12 -- om_cmd_count (read only)
// bit  11:9 -- overflow_count // bit  11:9 -- om_cmd_wr_ptr (read only)
// bit   8:6 -- om_overwrite_count // bit   8:6 -- om_cmd_rd_ptr (read only)
// bit   5:3 -- type_stb_om_w_rd (read only)
// bit     2 -- unit_start_stb_om_w_rd (read only)
// bit     1 -- om_cmd_overflow (read only)
// bit     0 -- om_cmd_pending (read)
// bit     0 -- om_cmd_read_finished (write)
// bit 15:9 // bit 14:8 -- count_stb_om_w_rd  (read only)
// bit 8:0  // bit  7:0 -- start_stb_om_wa_rd (read only)
// bit 11:0 -- offset for section data
// bit 31:16 -- base address for section buffer group 0 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 1 (*0x400 to get real address)
// bit 31:16 -- ba2e address for section buffer group 2 (*0x400 to get real address)
// bit 15:0 -- base address for section buffer group 3 (*0x400 to get real address)
// bit 3:0 -- section buffer size for group 0 (bit used,  for example, 10 means 1K)
// bit 7:4 -- section buffer size for group 1
// bit 11:8 -- section buffer size for group 2
// bit 15:12 -- section buffer size for group 3
// section buffer busy status for buff 31:0 ( Read Only )
// section buffer write status for buff 31:0 -- Read
// clear buffer status ( buff READY and BUSY ) -- write
// bit 4:0 -- SEC_BUFFER_INDEX   RW
// bit 12:8 -- SEC_BUFFER_NUMBER for the INDEX buffer  Read_Only
// bit 14 -- output_section_buffer_valid
// bit 15 -- section_reset_busy (Read Only)
// bit 9:5 -- BYPASS PID number
// bit 4:0 -- PCR PID number
// bit 15:0 -- stream_id filter bit enable
// bit 7:0 -- stream_id filter target
// bit 12 -- PCR_EN
// bit 11:0 -- PCR90K_DIV
// bit 31:0 -- PCR[31:0] R/W
// bit 31:0 -- VPTS[31:0] R/W
// bit 31:0 -- VDTS[31:0] R/W
// bit 31:0 -- APTS[31:0] R/W
// bit 31:0 -- SPTS[31:0] R/W
// read -- status, write 1 clear status
// bit 15 -- SUB_PTS[32]
// bit 14 -- AUDIO_PTS[32]
// bit 13 -- VIDEO_DTS[32]
// bit 12 -- VIDEO_PTS[32]
// bit 3 -- sub_pts_ready
// bit 2 -- audio_pts_ready
// bit 1 -- video_dts_ready
// bit 0 -- video_pts_ready
// bit 3:0 --
//  0 -- adaptation_field_length[7:0], adaption_field_byte_1[7:0]
//  1 -- stream_id[7:0], pes_header_bytes_left[7:0]
//  2 -- pes_package_bytes_left[15:0]
//  3 -- pes_ctr_byte[7:0], pes_flag_byte[7:0]
//
// read only
// bit[31] -- no_match_record_en
// bit[30:16] - reserved
// default : 0x807f
// bit 15:9  -- MAX OM DMA COUNT  (default: 0x40)
// bit 8:0   -- LAST ADDR OF OM ADDR (default: 127)
// 15:0  WRITE 1 CLEAR to clear interrupt source
//12 -- INPUT_TIME_OUT
//11 -- PCR_ready
//10 -- audio_splicing_point
// 9 -- video_splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// Bit 5:3 - demux om write endian control for bypass
// Bit 2:0 - demux om write endian control for section
// When Bit 31 - 1 write will indicate all type use separate endian (Write Only)
// Bit 23:21 - demux om write endian control for OTHER_PES_PACKET
// Bit 20:18 - demux om write endian control for SCR_ONLY_PACKET
// Bit 17:15 - demux om write endian control for SUB_PACKET
// Bit 14:12 - demux om write endian control for AUDIO_PACKET
// Bit 11:9  - demux om write endian control for VIDEO_PACKET
//
// When Bit 31 - 0 write will indicate all type else use Bit 8:6
// Bit 8:6 - demux om write endian control for else
// Bit 10:9 -- sel DPTS_wr_ptr: 00 from parserA ; 01 from parserB
// Bit 8:7 -- use hi_bsf interface: 01 sel hiu0; 10 sel hiu1
// Bit 6:2 - Reserved
// Bit 1 - enable_halt_ts_hiu_fix
// Bit 0 - enable_halt_ts_hiu
// bit 15:0 -- base address for section buffer start (*0x10000 to get real base)
// bit 11 -- mask bit for OTHER_PES_AHB_DMA_EN
// bit 10 -- mask bit for SUB_AHB_DMA_EN
// bit 9 -- mask bit for BYPASS_AHB_DMA_EN
// bit 8 -- mask bit for SECTION_AHB_DMA_EN
// bit 7 -- mask bit for recoder stream
// bit 6:0 -- mask bit for each type
// bit 31:0 -- vb_wr_ptr for video PDTS
// bit 31:0 -- ab_wr_ptr for audio PDTS
// bit 20:0 -- SB_WRITE_PTR (sb_wr_ptr << 3 == byte write position)
// bit 19:0 -- SB_START (sb_start << 12 == byte address);
// bit 20:0 -- SB_SIZE (sb_size << 3 == byte size, 16M maximun)
// bit 31:0 -- sb_wr_ptr for sub PES
// bit 31:16 -- ob_wr_ptr for other PES
// bit 20:0 -- OB_WRITE_PTR (ob_wr_ptr << 3 == byte write position)
// bit 19:0 -- OB_START (ob_start << 12 == byte address);
// bit 20:0 -- OB_SIZE (ob_size << 3 == byte size, 16M maximun)
// bit 31:0 -- ob_wr_ptr for sub PES
// 15:0  DEMUX interrupt MASK
// 9 -- splicing_point
// 8 -- other_PES_int
// 7 -- sub_PES_int
// 6 -- discontinuity
// 5 -- duplicated_pack_found
// 4 -- New PDTS ready
// 3 -- om_cmd_buffer ready for access
// 2 -- section buffer ready
// 1 -- transport_error_indicator
// 0 -- TS ERROR PIN
// 31:16 VIDEO PID filter data
//15 -- splicing VIDEO PID change enable
//14:10 -- VIDEO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 31:16 AUDIO PID filter data
//15 -- splicing AUDIO PID change enable
//14:10 -- AUDIO PID FILTER ADDRESS
// 9 -- PES splicing active (Read Only)
// 8 -- splicing active (Read Only)
// 7:0  splicing countdown (Read Only)
// 23:16 M2TS_SKIP_BYTES
// 15:8 LAST TS PACKAGE BYTE COUNT (Read Only)
// 7:0  PACKAGE BYTE COUNT (Read Only)
// 15:0 2 bytes strong sync add to PES
// bit 15 -- stb_om_ren
// bit 14:11 -- reserved
// bit  10:0 -- OM_DATA_RD_ADDR
// bit 15:0 -- OM_DATA_RD
// AUTO STOP SETTING for 32 channels
// 4-nbits per channel
// when write
// bit 3 -- set section active
// bit 2:0 -- auto stop after count (0 means never stop)
// when read
// bit 3 -- current active status (1 - active, 0 - stopped )
// bit 2:0 -- count down to auto stop
// section 31:24
// section 23:16
// section 15:8
// section 7:0
// bit 31:0 reset channel status - each bit reset each channel
// read -- 32 channel status
// bit 4 -- video_stamp_use_dts
// bit 3 -- audio_stamp_sync_1_en
// bit 2 -- audio_stamp_insert_en
// bit 1 -- video_stamp_sync_1_en
// bit 0 -- video_stamp_insert_en
// Write : Bit[4:0] secter filter number for reset
// Read  : select according to output_section_buffer_valid :
//         per bit per section buffer valid status
//         or section_buffer_ignore
// bit[31:0] - channel_reset_timeout_disable
// bit[31] - no_match_reset_timeout_disable
// bit[30:0] input_time_out_int_cnt (0 -- means disable) Wr-setting, Rd-count
// bit[31:0] - channel_packet_count_disable
// bit[31] - no_match_packet_count_disable
// bit[30:0] input_packet_count
// bit[31:0] channel_record_enable
// bit[31:0] channel_process_enable
// bit[31:24] small_sec_size ((n+1) * 256 Bytes)
// bit[23:16] small_sec_rd_ptr
// bit[15:8]  small_sec_wr_ptr
// bit[7:2]   reserved
// bit[1] small_sec_wr_ptr_wr_enable
// bit[0] small_section_enable
// bit[31:0] small_sec_start_addr
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  REG_LIST_DEMUX_RTL.h
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./REG_LIST_RTL.h
//
//
// Reading file:  ./vcbus_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
//===========================================================================
//
// Reading file:  rdma_regs.h
//
//===========================================================================
// RDMA registers 0x00 - 0xff
//===========================================================================
// -----------------------------------------------
// REG_BASE:  RDMA_VCBUS_BASE = 0x11
// -----------------------------------------------
// Bit 31: 0 RW AHB start address for manual start DMA
#define RDMA_AHB_START_ADDR_MAN                    ((0x1100  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for manual start DMA
#define RDMA_AHB_END_ADDR_MAN                      ((0x1101  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 1
#define RDMA_AHB_START_ADDR_1                      ((0x1102  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 1
#define RDMA_AHB_END_ADDR_1                        ((0x1103  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 2
#define RDMA_AHB_START_ADDR_2                      ((0x1104  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 2
#define RDMA_AHB_END_ADDR_2                        ((0x1105  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 3
#define RDMA_AHB_START_ADDR_3                      ((0x1106  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 3
#define RDMA_AHB_END_ADDR_3                        ((0x1107  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 4
#define RDMA_AHB_START_ADDR_4                      ((0x1108  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 4
#define RDMA_AHB_END_ADDR_4                        ((0x1109  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 5
#define RDMA_AHB_START_ADDR_5                      ((0x110a  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 5
#define RDMA_AHB_END_ADDR_5                        ((0x110b  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 6
#define RDMA_AHB_START_ADDR_6                      ((0x110c  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 6
#define RDMA_AHB_END_ADDR_6                        ((0x110d  << 2) + 0xff000000)
// Bit 31: 0 RW AHB start address for auto start source 7
#define RDMA_AHB_START_ADDR_7                      ((0x110e  << 2) + 0xff000000)
// Bit 31: 0 RW AHB end address for auto start source 7
#define RDMA_AHB_END_ADDR_7                        ((0x110f  << 2) + 0xff000000)
// Auto start DMA control:
// Bit 31:24 RW ctrl_enable_int_3. Interrupt inputs enable mask for source 3.
// Bit 23:16 RW ctrl_enable_int_2. Interrupt inputs enable mask for source 2.
// Bit 15: 8 RW ctrl_enable_int_1. Interrupt inputs enable mask for source 1.
// Bit     7 RW ctrl_cbus_write_3. Register read/write mode for auto-start 3. 1=Register write; 0=Register read.
// Bit     6 RW ctrl_cbus_write_3. Register read/write mode for auto-start 2. 1=Register write; 0=Register read.
// Bit     5 RW ctrl_cbus_write_3. Register read/write mode for auto-start 1. 1=Register write; 0=Register read.
// Bit     4 R  Rsrv.
// Bit     3 RW ctrl_cbus_addr_incr_3. 1=Incremental register access for auto-start 3; 0=Non-incremental (individual) register access.
// Bit     2 RW ctrl_cbus_addr_incr_2. 1=Incremental register access for auto-start 2; 0=Non-incremental (individual) register access.
// Bit     1 RW ctrl_cbus_addr_incr_1. 1=Incremental register access for auto-start 1; 0=Non-incremental (individual) register access.
// Bit     0 R  Rsrv.
#define RDMA_ACCESS_AUTO                           ((0x1110  << 2) + 0xff000000)
#define RDMA_ACCESS_AUTO2                          ((0x1111  << 2) + 0xff000000)
// Manual start DMA control:
// Bit 31: 3 R  Rsrv.
// Bit     2 RW ctrl_cbus_write_man. Register read/write mode for manual-start. 1=Register write; 0=Register read.
// Bit     1 RW ctrl_cbus_addr_incr_man. 1=Incremental register access for manual-start; 0=Non-incremental (individual) register access.
// Bit     0 W  ctrl_start_man. Write 1 to this bit to manual-start DMA. This bit always read back 0.
#define RDMA_ACCESS_MAN                            ((0x1113  << 2) + 0xff000000)
// RDMA general control:
// Bit 31:25 R  Rsrv.
// Bit    24 W  ctrl_clr_rdma_done_int. Write 1 to reset rdma_int level to 0. No need to clear this bit.
// Bit 23:19 R  Rsrv.
// Bit 18:13 R  Rsrv.
// Bit 12: 7 R  Rsrv.
// Bit     6 RW ctrl_ddr_urgent.
// Bit  5: 4 RW ctrl_ahb_wr_burst_size. 0=ABH write request burst size 16;
//                                      1=ABH write request burst size 24;
//                                      2=ABH write request burst size 32;
//                                      3=ABH write request burst size 48.
// Bit  3: 2 RW ctrl_ahb_rd_burst_size. 0=ABH read request burst size 16;
//                                      1=ABH read request burst size 24;
//                                      2=ABH read request burst size 32;
//                                      3=ABH read request burst size 48.
// Bit     1 RW ctrl_sw_reset. 1=Reset RDMA logic except register.
// Bit     0 RW ctrl_free_clk_enable. 0=Default, Enable clock gating. 1=No clock gating, enable free clock.
#define RDMA_CTRL                                  ((0x1114  << 2) + 0xff000000)
// Read only.
// Bit 31:29 R  Rsrv.
// Bit    28 R  rdma_done_int.
// Bit 27:25 R  Rsrv.
// Bit 24:18 R  ahb_wrfifo_cnt. FIFO for buffering CBus read data to be sent to AHB
// Bit 17:11 R  ahb_rdfifo_cnt. FIFO for buffering data read from AHB.
// Bit 10: 8 R  ddr_req_st. =0 -- Idle; !=0 -- AHB interfacing ongoing.
// Bit  7: 4 R  curr_req. Latest requests that is being/been serviced. E.g. 0000=Idle; 0010=Latest serviced request is Req 1.
// Bit  3: 0 R  req_latch. Requests that are yet to be serviced. E.g. 0000=No request; 0001=Req 0 waiting; 1100=Req 2 and 3 waiting.
#define RDMA_STATUS                                ((0x1115  << 2) + 0xff000000)
#define RDMA_STATUS2                               ((0x1116  << 2) + 0xff000000)
#define RDMA_STATUS3                               ((0x1117  << 2) + 0xff000000)
#define RDMA_ACCESS_AUTO4                          ((0x1118  << 2) + 0xff000000)
#define RDMA_SRAM_CNTL                             ((0x1120  << 2) + 0xff000000)
#define RDMA_SRAM_REGADDR                          ((0x1121  << 2) + 0xff000000)
#define RDMA_SRAM_REGDATA                          ((0x1122  << 2) + 0xff000000)
#define RDMA_AUTO_SRC1_SEL                         ((0x1123  << 2) + 0xff000000)
#define RDMA_AUTO_SRC2_SEL                         ((0x1124  << 2) + 0xff000000)
#define RDMA_AUTO_SRC3_SEL                         ((0x1125  << 2) + 0xff000000)
#define RDMA_AUTO_SRC4_SEL                         ((0x1126  << 2) + 0xff000000)
#define RDMA_AUTO_SRC5_SEL                         ((0x1127  << 2) + 0xff000000)
#define RDMA_AUTO_SRC6_SEL                         ((0x1128  << 2) + 0xff000000)
#define RDMA_AUTO_SRC7_SEL                         ((0x1129  << 2) + 0xff000000)
//
// Closing file:  rdma_regs.h
//
//
// Reading file:  vpu_vdin0_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// REG_BASE:  VDIN0_VCBUS_BASE = 0x12
// -----------------------------------------------
//
// Reading file:  vpu_vdin_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
#define VDIN_SCALE_COEF_IDX                        ((0x1200  << 2) + 0xff000000)
#define VDIN_SCALE_COEF                            ((0x1201  << 2) + 0xff000000)
//bit 31,   mpeg_to_vdin_sel, 0: mpeg source to NR directly, 1: mpeg source pass through here
//bit 30,   mpeg_field info which can be written by software
//Bit 29,   force go_field, pulse signal
//Bit 28,   force go_line, pulse signal
//Bit 27,   enable mpeg_go_field input signal
//Bit 26:20, hold lines
//Bit 19,   delay go_field function enable
//Bit 18:12, delay go_field line number
//Bit 11:10, component2 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 9:8, component1 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 7:6, component0 output switch, 00: select component0 in, 01: select component1 in, 10: select component2 in
//Bit 5,   input window selection function enable
//Bit 4, enable VDIN common data input, otherwise there will be no video data input
//Bit 3:0 vdin selection, 1: mpeg_in from dram, 2: bt656 input, 3: component input, 4: tvdecoder input, 5: hdmi rx input, 6: digital video input, 7: loopback from Viu1, 8: MIPI.
#define VDIN_COM_CTRL0                             ((0x1202  << 2) + 0xff000000)
//Bit 28:16 active_max_pix_cnt, readonly
//Bit 12:0  active_max_pix_cnt_shadow, readonly
#define VDIN_ACTIVE_MAX_PIX_CNT_STATUS             ((0x1203  << 2) + 0xff000000)
//Bit 28:16 go_line_cnt, readonly
//Bit 12:0  active_line_cnt, readonly
#define VDIN_LCNT_STATUS                           ((0x1204  << 2) + 0xff000000)
//Readonly
//Bit [14:3] lfifo_buf_cnt
//Bit 2, vdin_direct_done status
//Bit 1, vdin_nr_done status
//Bit 0, field
#define VDIN_COM_STATUS0                           ((0x1205  << 2) + 0xff000000)
//Readonly
//Bit 31, vdi4 fifo overflow
//Bit 29:24, vdi3_asfifo_cnt
//Bit 23, vdi3 fifo overflow
//Bit 21:16, vdi3_asfifo_cnt
//Bit 15, vdi2 fifo overflow
//Bit 13:8, vdi2_asfifo_cnt
//Bit 7, vdi1 fifo overflow
//Bit 5:0, vdi1_asfifo_cnt
#define VDIN_COM_STATUS1                           ((0x1206  << 2) + 0xff000000)
//Bit 28:16 go_line_cnt_shadow, readonly
//Bit 12:0  active_line_cnt_shadow, readonly
#define VDIN_LCNT_SHADOW_STATUS                    ((0x1207  << 2) + 0xff000000)
//each 8bit asfifo_ctrl is following:
//Bit 7, DE  enable
//Bit 6, go field enable
//Bit 5, go line enable
//Bit 4, if true, negative active input vsync
//Bit 3, if true, negative active input hsync
//Bit 2, vsync soft reset fifo enable
//Bit 1, overflow status clear
//Bit 0 asfifo soft reset, level signal
//Bit 7:0 vdi1 asfifo_ctrl
//Bit 23:16 vdi2 asfifo_ctrl
#define VDIN_ASFIFO_CTRL0                          ((0x1208  << 2) + 0xff000000)
//Bit 7:0 vdi3 asfifo_ctrl
//Bit 23:16 vdi4 asfifo_ctrl
#define VDIN_ASFIFO_CTRL1                          ((0x1209  << 2) + 0xff000000)
//Bit 28:16 input width minus 1, after the window function
//Bit 12:0  output width minus 1
#define VDIN_WIDTHM1I_WIDTHM1O                     ((0x120a  << 2) + 0xff000000)
//Bit 20:17 prehsc_mode, bit 3:2, prehsc odd line interp mode, bit 1:0, prehsc even line interp mode,
//           each 2bit, 00: pix0+pix1/2, average, 01: pix1, 10: pix0
//Bit 16:15 sp422_mode, special mode for the component1 and component2, 00: normal case, 01: 32 64 32, 10: 0 64 64 0, 11: 16 96 16
//Bit 14:8, hsc_ini_pixi_ptr, signed data, only useful when short_lineo_en is true
//Bit 7, prehsc_en
//Bit 6, hsc_en,
//Bit 5, hsc_short_lineo_en, short line output enable
//Bit 4, hsc_nearest_en
//Bit 3, hsc_phase0_always_en
//Bit 2:0, hsc_bank_length
#define VDIN_SC_MISC_CTRL                          ((0x120b  << 2) + 0xff000000)
//Bit 28:24, integer portion
//Bit 23:0, fraction portion
#define VDIN_HSC_PHASE_STEP                        ((0x120c  << 2) + 0xff000000)
//Bit 30:29    hscale rpt_p0_num
//Bit 28:24    hscale ini_rcv_num
//Bit 23:0     hscale ini_phase
#define VDIN_HSC_INI_CTRL                          ((0x120d  << 2) + 0xff000000)
//Read only
//Bit 23, vdi7 fifo overflow
//Bit 21:16, vdi7_asfifo_cnt
//Bit 15, vdi6 fifo overflow
//Bit 13:8, vdi6_asfifo_cnt
//Bit 7, vdi5 fifo overflow
//Bit 5:0, vdi5_asfifo_cnt
#define VDIN_COM_STATUS2                           ((0x120e  << 2) + 0xff000000)
//Bit 25:16 asfifo decimate control
//Bit 25, if true, decimation counter sync with first valid DE in the field,
//otherwise the decimation counter is not sync with external signal
//Bit 24, decimation de enable
//Bit 23:20, decimation phase, which counter value use to decimate,
//Bit 19:16, decimation number, 0: not decimation, 1: decimation 2, 2: decimation 3 ....
//Bit 7:0 vdi5 asfifo_ctrl
#define VDIN_ASFIFO_CTRL2                          ((0x120f  << 2) + 0xff000000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VDIN_MATRIX_CTRL                           ((0x1210  << 2) + 0xff000000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VDIN_MATRIX_COEF00_01                      ((0x1211  << 2) + 0xff000000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VDIN_MATRIX_COEF02_10                      ((0x1212  << 2) + 0xff000000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VDIN_MATRIX_COEF11_12                      ((0x1213  << 2) + 0xff000000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VDIN_MATRIX_COEF20_21                      ((0x1214  << 2) + 0xff000000)
//BIt 18:16 conv_rs
//Bit 12:0  coef22
#define VDIN_MATRIX_COEF22                         ((0x1215  << 2) + 0xff000000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VDIN_MATRIX_OFFSET0_1                      ((0x1216  << 2) + 0xff000000)
//Bit 10:0  offset2
#define VDIN_MATRIX_OFFSET2                        ((0x1217  << 2) + 0xff000000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VDIN_MATRIX_PRE_OFFSET0_1                  ((0x1218  << 2) + 0xff000000)
//Bit 10:0  pre_offset2
#define VDIN_MATRIX_PRE_OFFSET2                    ((0x1219  << 2) + 0xff000000)
//12:0 lfifo_buf_size
#define VDIN_LFIFO_CTRL                            ((0x121a  << 2) + 0xff000000)
#define VDIN_COM_GCLK_CTRL                         ((0x121b  << 2) + 0xff000000)
//12:0 VDIN input interface width minus 1, before the window function, after the de decimation
#define VDIN_INTF_WIDTHM1                          ((0x121c  << 2) + 0xff000000)
//Bit 15          //default== 0, urgent_ctrl_en
//Bit 14          //default== 0, urgent_wr, if true for write buffer
//Bit 13          //default== 0, out_inv_en
//Bit 12          //default == 0, urgent_ini_value
//Bit 11:6        //default == 0, up_th  up threshold
//Bit 5:0         //default == 0, dn_th  dn threshold
#define VDIN_LFIFO_URG_CTRL                        ((0x121e  << 2) + 0xff000000)
//Bit 8, 1: discard data before line fifo, 0: normal mode
//Bit 7:0 Write chroma canvas address
#define VDIN_WR_CTRL2                              ((0x121f  << 2) + 0xff000000)
//Bit 31:30 hconv_mode, Applicable only to bit[13:12]=0 or 2. 0: Output every even pixels' CbCr;
//                                                            1: Output every odd pixels' CbCr;
//                                                            2: Output an average value per even&odd pair of pixels;
//                                                            3: Output all CbCr. (This does NOT apply to bit[13:12]=0 -- 4:2:2 mode.)
//Bit 29 no_clk_gate: disable vid_wr_mif clock gating function.
//Bit 28 clear write response counter in the vdin write memory interface
//Bit 27 eol_sel, 1: use eol as the line end indication, 0: use width as line end indication in the vdin write memory interface
//Bit 26 vcp_nr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 25 vcp_wr_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 24 vcp_in_en. Only used in VDIN0. NOT used in VDIN1.
//Bit 23 vdin frame reset enble, if true, it will provide frame reset during go_field(vsync) to the modules after that
//Bit 22 vdin line fifo soft reset enable, meaning, if true line fifo will reset during go_field (vsync)
//Bit 21 vdin direct write done status clear bit
//Bit 20 vdin NR write done status clear bit
//Bit 18 swap_cbcr. Applicable only to bit[13:12]=2. 0: Output CbCr (NV12); 1: Output CrCb (NV21).
//Bit 17:16 vconv_mode, Applicable only to bit[13:12]=2. 0: Output every even lines' CbCr;
//                                                       1: Output every odd lines' CbCr;
//                                                       2: Reserved;
//                                                       3: Output all CbCr.
//Bit 13:12 vdin write format, 0: 4:2:2 to luma canvas, 1: 4:4:4 to luma canvas,
//                             2: Y to luma canvas, CbCr to chroma canvas. For NV12/21, also define Bit 31:30, 17:16, and bit 18.
//Bit 11 vdin write canvas double buffer enable, means the canvas address will be latched by vsync before using
//Bit 10 1: disable ctrl_reg write pulse which will reset internal counter. when bit 11 is 1, this bit should be 1.
//Bit 9 vdin write request urgent
//Bit 8 vdin write request enable
//Bit 7:0 Write luma canvas address
#define VDIN_WR_CTRL                               ((0x1220  << 2) + 0xff000000)
//Bit 29, if true, horizontal reverse
//Bit 28:16 start
//Bit 12:0  end
#define VDIN_WR_H_START_END                        ((0x1221  << 2) + 0xff000000)
//Bit 29, if true, vertical reverse
//Bit 28:16 start
//Bit 15:13 field mode,  0 frame mode, 4 for field mode botton field, 5 for field mode top field, , 6 for blank line mode
//Bit 12:0  end
#define VDIN_WR_V_START_END                        ((0x1222  << 2) + 0xff000000)
//Bit 24:20, integer portion
//Bit 19:0, fraction portion
#define VDIN_VSC_PHASE_STEP                        ((0x1223  << 2) + 0xff000000)
//Bit 23, vsc_en, vertical scaler enable
//Bit 22  if true, repeat last line while scaling, otherwise use the dummy data to extend the input picture
//Bit 21 vsc_phase0_always_en, when scale up, you have to set it to 1
//Bit 20:16 ini skip_line_num
//Bit 15:0 vscaler ini_phase
#define VDIN_VSC_INI_CTRL                          ((0x1224  << 2) + 0xff000000)
//Bit 28:16, vshrink input height minus 1
//Bit 12:0, scaler input height minus 1
#define VDIN_SCIN_HEIGHTM1                         ((0x1225  << 2) + 0xff000000)
//Bit 23:16, dummy component 0
//Bit 15:8, dummy component 1
//Bit 7:0, dummy component 2
#define VDIN_DUMMY_DATA                            ((0x1226  << 2) + 0xff000000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VDIN_MATRIX_PROBE_COLOR                    ((0x1228  << 2) + 0xff000000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VDIN_MATRIX_HL_COLOR                       ((0x1229  << 2) + 0xff000000)
//28:16 probe x, postion
//12:0  probe y, position
#define VDIN_MATRIX_PROBE_POS                      ((0x122a  << 2) + 0xff000000)
#define VDIN_CHROMA_ADDR_PORT                      ((0x122b  << 2) + 0xff000000)
#define VDIN_CHROMA_DATA_PORT                      ((0x122c  << 2) + 0xff000000)
//
#define VDIN_CM_BRI_CON_CTRL                       ((0x122d  << 2) + 0xff000000)
//Bit 17  clk_cyc_cnt_clr, if true, clear this register
//Bit 16 if true, use vpu clock to count one line, otherwise use actually hsync to count line_cnt
//Bit 15:0   line width using vpu clk
#define VDIN_GO_LINE_CTRL                          ((0x122f  << 2) + 0xff000000)
//Bit 31:24 hist_pix_white_th, larger than this th is counted as white pixel
//Bit 23:16 hist_pix_black_th, less than this th is counted as black pixel
//Bit 11    hist_34bin_only,   34 bin only mode, including white/black
//Bit 10:9  ldim_stts_din_sel, 00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 8     ldim_stts_en
//Bit 6:5   hist_dnlp_low   the real pixels in each bins got by VDIN_DNLP_HISTXX should multiple with 2^(dnlp_low+3)
//Bit 3:2   hist_din_sel    the source used for hist statistics.  00: from matrix0 dout,  01: from vsc_dout, 10: from matrix1 dout, 11: form matrix1 din
//Bit 1     hist_win_en     1'b0: hist used for full picture; 1'b1: hist used for pixels within hist window
//Bit 0     hist_spl_en     1'b0: disable hist readback; 1'b1: enable hist readback
#define VDIN_HIST_CTRL                             ((0x1230  << 2) + 0xff000000)
//Bit 28:16 hist_hstart  horizontal start value to define hist window
//Bit 12:0  hist_hend    horizontal end value to define hist window
#define VDIN_HIST_H_START_END                      ((0x1231  << 2) + 0xff000000)
//Bit 28:16 hist_vstart  vertical start value to define hist window
//Bit 12:0  hist_vend    vertical end value to define hist window
#define VDIN_HIST_V_START_END                      ((0x1232  << 2) + 0xff000000)
//Bit 15:8  hist_max    maximum value
//Bit 7:0   hist_min    minimum value
//read only
#define VDIN_HIST_MAX_MIN                          ((0x1233  << 2) + 0xff000000)
//Bit 31:0  hist_spl_rd
//counts for the total luma value
//read only
#define VDIN_HIST_SPL_VAL                          ((0x1234  << 2) + 0xff000000)
//Bit 21:0  hist_spl_pixel_count
//counts for the total calculated pixels
//read only
#define VDIN_HIST_SPL_PIX_CNT                      ((0x1235  << 2) + 0xff000000)
//Bit 31:0  hist_chroma_sum
//counts for the total chroma value
//read only
#define VDIN_HIST_CHROMA_SUM                       ((0x1236  << 2) + 0xff000000)
//Bit 31:16 higher hist bin
//Bit 15:0  lower hist bin
//0-255 are split to 64 bins evenly, and VDIN_DNLP_HISTXX
//are the statistic number of pixels that within each bin.
//VDIN_DNLP_HIST00[15:0]  counts for the first  bin
//VDIN_DNLP_HIST00[31:16] counts for the second bin
//VDIN_DNLP_HIST01[15:0]  counts for the third  bin
//VDIN_DNLP_HIST01[31:16] counts for the fourth bin
//etc...
//read only
#define VDIN_DNLP_HIST00                           ((0x1237  << 2) + 0xff000000)
#define VDIN_DNLP_HIST01                           ((0x1238  << 2) + 0xff000000)
#define VDIN_DNLP_HIST02                           ((0x1239  << 2) + 0xff000000)
#define VDIN_DNLP_HIST03                           ((0x123a  << 2) + 0xff000000)
#define VDIN_DNLP_HIST04                           ((0x123b  << 2) + 0xff000000)
#define VDIN_DNLP_HIST05                           ((0x123c  << 2) + 0xff000000)
#define VDIN_DNLP_HIST06                           ((0x123d  << 2) + 0xff000000)
#define VDIN_DNLP_HIST07                           ((0x123e  << 2) + 0xff000000)
#define VDIN_DNLP_HIST08                           ((0x123f  << 2) + 0xff000000)
#define VDIN_DNLP_HIST09                           ((0x1240  << 2) + 0xff000000)
#define VDIN_DNLP_HIST10                           ((0x1241  << 2) + 0xff000000)
#define VDIN_DNLP_HIST11                           ((0x1242  << 2) + 0xff000000)
#define VDIN_DNLP_HIST12                           ((0x1243  << 2) + 0xff000000)
#define VDIN_DNLP_HIST13                           ((0x1244  << 2) + 0xff000000)
#define VDIN_DNLP_HIST14                           ((0x1245  << 2) + 0xff000000)
#define VDIN_DNLP_HIST15                           ((0x1246  << 2) + 0xff000000)
#define VDIN_DNLP_HIST16                           ((0x1247  << 2) + 0xff000000)
#define VDIN_DNLP_HIST17                           ((0x1248  << 2) + 0xff000000)
#define VDIN_DNLP_HIST18                           ((0x1249  << 2) + 0xff000000)
#define VDIN_DNLP_HIST19                           ((0x124a  << 2) + 0xff000000)
#define VDIN_DNLP_HIST20                           ((0x124b  << 2) + 0xff000000)
#define VDIN_DNLP_HIST21                           ((0x124c  << 2) + 0xff000000)
#define VDIN_DNLP_HIST22                           ((0x124d  << 2) + 0xff000000)
#define VDIN_DNLP_HIST23                           ((0x124e  << 2) + 0xff000000)
#define VDIN_DNLP_HIST24                           ((0x124f  << 2) + 0xff000000)
#define VDIN_DNLP_HIST25                           ((0x1250  << 2) + 0xff000000)
#define VDIN_DNLP_HIST26                           ((0x1251  << 2) + 0xff000000)
#define VDIN_DNLP_HIST27                           ((0x1252  << 2) + 0xff000000)
#define VDIN_DNLP_HIST28                           ((0x1253  << 2) + 0xff000000)
#define VDIN_DNLP_HIST29                           ((0x1254  << 2) + 0xff000000)
#define VDIN_DNLP_HIST30                           ((0x1255  << 2) + 0xff000000)
#define VDIN_DNLP_HIST31                           ((0x1256  << 2) + 0xff000000)
//Bit 31, local dimming statistic enable
//Bit 28, eol enable
//Bit 27:25, vertical line overlap number for max finding
//Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//Bit 15, 1: region read index auto increase per read to VDIN_LDIM_STTS_HIST_READ_REGION
//Bit 6:0, region read index
//`define VDIN_LDIM_STTS_HIST_REGION_IDX       8'h57
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
//`define VDIN_LDIM_STTS_HIST_SET_REGION       8'h58
//REGION STATISTIC DATA READ OUT PORT, bit 29:20 max_comp2, bit 19:10 max_comp1, bit 9:0 max_comp0
//`define VDIN_LDIM_STTS_HIST_READ_REGION      8'h59
//Bit 18, reset bit, high active
//Bit 17, if true, widen hs/vs pulse
//Bit 16  vsync total counter always accumulating enable
//Bit 14:12, select hs/vs of video input channel to measure, 0: no selection, 1: vdi1, 2: vid2, 3: vid3, 4:vid4, 5:vdi5, 6:vid6, 7:vdi7, 8: vdi8
//Bit 11:4, vsync_span, define how many vsync span need to measure
//Bit 2:0  meas_hs_index, index to select which HS counter/range
#define VDIN_MEAS_CTRL0                            ((0x125a  << 2) + 0xff000000)
//Read only
//19:16     meas_ind_total_count_n, every number of sync_span vsyncs, this count add 1
//15:0      high bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_HI                      ((0x125b  << 2) + 0xff000000)
//Read only
//31:0, low bit portion of vsync total counter
#define VDIN_MEAS_VS_COUNT_LO                      ((0x125c  << 2) + 0xff000000)
//according to the meas_hs_index in register VDIN_MEAS_CTRL0
//meas_hs_index == 0, first hs range
//meas_hs_index == 1, second hs range
//meas_hs_index == 2, third hs range
//meas_hs_index == 3, fourth hs range
//bit 28:16 count_start
//bit 12:0 count_end
#define VDIN_MEAS_HS_RANGE                         ((0x125d  << 2) + 0xff000000)
//Read only
//according to the meas_hs_index in register VDIN_MEAS_CTRL0,
//meas_hs_index == 0, first range hs counter,
//meas_hs_index == 1, second range hs coutner
//meas_hs_index == 2, third range hs coutner
//meas_hs_index == 3, fourth range hs coutner
//23:0
#define VDIN_MEAS_HS_COUNT                         ((0x125e  << 2) + 0xff000000)
//Bit 8      white_enable
//Bit 7:0    blkbar_white_level
#define VDIN_BLKBAR_CTRL1                          ((0x125f  << 2) + 0xff000000)
// Bit 31:24 blkbar_black_level    threshold to judge a black point
// Bit 23:21 Reserved
// Bit 20:8  blkbar_hwidth         left and right region width
// Bit 7:5   blkbar_comp_sel       select yin or uin or vin to be the valid input
// Bit 4     blkbar_sw_statistic_en enable software statistic of each block black points number
// Bit 3     blkbar_det_en
// Bit 2:1   blkbar_din_sel
// bit blkbar_det_top_en
#define VDIN_BLKBAR_CTRL0                          ((0x1260  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_hstart.        Left region start
// Bit 15:13 Reserved
// Bit 12:0  blkbar_hend.          Right region end
#define VDIN_BLKBAR_H_START_END                    ((0x1261  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_vstart
// Bit 15:13 Reserved
// Bit 12:0  blkbar_vend
#define VDIN_BLKBAR_V_START_END                    ((0x1262  << 2) + 0xff000000)
// Bit 31:20 Reserved
// Bit 19:0  blkbar_cnt_threshold. threshold to judge whether a block is totally black
#define VDIN_BLKBAR_CNT_THRESHOLD                  ((0x1263  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 blkbar_row_th1.       //threshold of the top blackbar
// Bit 15:13 Reserved
// bit 12:0  blkbar_row_th2        //threshold of the bottom blackbar
#define VDIN_BLKBAR_ROW_TH1_TH2                    ((0x1264  << 2) + 0xff000000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_left_start. horizontal start of the left region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_left_end.   horizontal end of the left region in the current searching
#define VDIN_BLKBAR_IND_LEFT_START_END             ((0x1265  << 2) + 0xff000000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_ind_right_start.horizontal start of the right region in the current searching
// Bit 15:13 Reserved
// Bit 12:0  blkbar_ind_right_end.  horizontal end of the right region in the current searching
#define VDIN_BLKBAR_IND_RIGHT_START_END            ((0x1266  << 2) + 0xff000000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left1_cnt.  Black pixel counter. left part of the left region
#define VDIN_BLKBAR_IND_LEFT1_CNT                  ((0x1267  << 2) + 0xff000000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_left2_cnt.  Black pixel counter. right part of the left region
#define VDIN_BLKBAR_IND_LEFT2_CNT                  ((0x1268  << 2) + 0xff000000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right1_cnt. Black pixel counter. left part of the right region
#define VDIN_BLKBAR_IND_RIGHT1_CNT                 ((0x1269  << 2) + 0xff000000)
//Readonly
// Bit 31:20 Reserved
// Bit 19:0  blkbar_ind_right2_cnt. Black pixel counter. right part of the right region
#define VDIN_BLKBAR_IND_RIGHT2_CNT                 ((0x126a  << 2) + 0xff000000)
//Readonly
// Bit 31:30 reserved
// Bit 29    blkbar_ind_black_det_done. LEFT/RIGHT Black detection done
// Bit 28:16 blkbar_top_pos.            Top black bar position
// Bit 15:13 Reserved.
// Bit 12:0  blkbar_bot_pos.            Bottom black bar position
#define VDIN_BLKBAR_STATUS0                        ((0x126b  << 2) + 0xff000000)
//Readonly
// Bit 31:29 Reserved
// Bit 28:16 blkbar_left_pos.       Left black bar position
// Bit 15:13 Reserved
// Bit 12:0  blkbar_right_pos.      Right black bar position
#define VDIN_BLKBAR_STATUS1                        ((0x126c  << 2) + 0xff000000)
//Bit 28:16 input window H start
//Bit 12:0  input window H end
#define VDIN_WIN_H_START_END                       ((0x126d  << 2) + 0xff000000)
//Bit 28:16 input window H start
//Bit 12:0  input window V start
#define VDIN_WIN_V_START_END                       ((0x126e  << 2) + 0xff000000)
//Bit 23:16 vdi8 asfifo_ctrl
//Bit 15:8 vdi7 asfifo_ctrl
//Bit 7:0 vdi6 asfifo_ctrl
#define VDIN_ASFIFO_CTRL3                          ((0x126f  << 2) + 0xff000000)
//Bit 3:2 vshrk_clk2_ctrl
//Bit 1:0 vshrk_clk1_ctrl
#define VDIN_COM_GCLK_CTRL2                        ((0x1270  << 2) + 0xff000000)
//Bit 27 vshrk_en
//Bit 26:25 vshrk_mode
//Bit 24 vshrk_lpf_mode
//Bit 23:0 vshrk_dummy
#define VDIN_VSHRK_CTRL                            ((0x1271  << 2) + 0xff000000)
#define VDIN_DNLP_HIST32                           ((0x1272  << 2) + 0xff000000)
//Read only
//Bit 7, vdi9 fifo overflow
//Bit 5:0, vdi9_asfifo_cnt
#define VDIN_COM_STATUS3                           ((0x1273  << 2) + 0xff000000)
#define VDIN_SYNC_MASK                             ((0x1274  << 2) + 0xff000000)
//Bit 7:0,  hsync_mask_num
//Bit 15:8, vsync_mask_num
//Bit 16,   hsync_mask_enable
//Bit 17,   vsync_mask_num
//dolby vdin
#define VDIN_DOLBY_DSC_CTRL0                       ((0x1275  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_CTRL1                       ((0x1276  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_CTRL2                       ((0x1277  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_CTRL3                       ((0x1278  << 2) + 0xff000000)
#define VDIN_DOLBY_AXI_CTRL0                       ((0x1279  << 2) + 0xff000000)
#define VDIN_DOLBY_AXI_CTRL1                       ((0x127a  << 2) + 0xff000000)
#define VDIN_DOLBY_AXI_CTRL2                       ((0x127b  << 2) + 0xff000000)
#define VDIN_DOLBY_AXI_CTRL3                       ((0x127c  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_STATUS0                     ((0x127d  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_STATUS1                     ((0x127e  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_STATUS2                     ((0x127f  << 2) + 0xff000000)
#define VDIN_DOLBY_DSC_STATUS3                     ((0x121d  << 2) + 0xff000000)
//hdr2 0x80 - -0xc0
#define VDIN_HDR2_CTRL                             ((0x1280  << 2) + 0xff000000)
#define VDIN_HDR2_CLK_GATE                         ((0x1281  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF00_01                ((0x1282  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF02_10                ((0x1283  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF11_12                ((0x1284  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF20_21                ((0x1285  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF22                   ((0x1286  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF30_31                ((0x1287  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF32_40                ((0x1288  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_COEF41_42                ((0x1289  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_OFFSET0_1                ((0x128a  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_OFFSET2                  ((0x128b  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_PRE_OFFSET0_1            ((0x128c  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_PRE_OFFSET2              ((0x128d  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF00_01                ((0x128e  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF02_10                ((0x128f  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF11_12                ((0x1290  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF20_21                ((0x1291  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF22                   ((0x1292  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF30_31                ((0x1293  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF32_40                ((0x1294  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_COEF41_42                ((0x1295  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_OFFSET0_1                ((0x1296  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_OFFSET2                  ((0x1297  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_PRE_OFFSET0_1            ((0x1298  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_PRE_OFFSET2              ((0x1299  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_CLIP                     ((0x129a  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_CLIP                     ((0x129b  << 2) + 0xff000000)
#define VDIN_HDR2_CGAIN_OFFT                       ((0x129c  << 2) + 0xff000000)
#define VDIN_EOTF_LUT_ADDR_PORT                    ((0x129e  << 2) + 0xff000000)
#define VDIN_EOTF_LUT_DATA_PORT                    ((0x129f  << 2) + 0xff000000)
#define VDIN_OETF_LUT_ADDR_PORT                    ((0x12a0  << 2) + 0xff000000)
#define VDIN_OETF_LUT_DATA_PORT                    ((0x12a1  << 2) + 0xff000000)
#define VDIN_CGAIN_LUT_ADDR_PORT                   ((0x12a2  << 2) + 0xff000000)
#define VDIN_CGAIN_LUT_DATA_PORT                   ((0x12a3  << 2) + 0xff000000)
#define VDIN_HDR2_CGAIN_COEF0                      ((0x12a4  << 2) + 0xff000000)
#define VDIN_HDR2_CGAIN_COEF1                      ((0x12a5  << 2) + 0xff000000)
#define VDIN_OGAIN_LUT_ADDR_PORT                   ((0x12a6  << 2) + 0xff000000)
#define VDIN_OGAIN_LUT_DATA_PORT                   ((0x12a7  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_CTRL                        ((0x12a8  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_ALPHA0                      ((0x12a9  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_ALPHA1                      ((0x12aa  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_BETA0                       ((0x12ab  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_BETA1                       ((0x12ac  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_BETA2                       ((0x12ad  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_COEF0                       ((0x12ae  << 2) + 0xff000000)
#define VDIN_HDR2_ADPS_COEF1                       ((0x12af  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_CTRL                        ((0x12b0  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_COEF0                       ((0x12b1  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_COEF1                       ((0x12b2  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_COEF2                       ((0x12b3  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_COEF3                       ((0x12b4  << 2) + 0xff000000)
#define VDIN_HDR2_GMUT_COEF4                       ((0x12b5  << 2) + 0xff000000)
#define VDIN_HDR2_PIPE_CTRL1                       ((0x12b6  << 2) + 0xff000000)
#define VDIN_HDR2_PIPE_CTRL2                       ((0x12b7  << 2) + 0xff000000)
#define VDIN_HDR2_PIPE_CTRL3                       ((0x12b8  << 2) + 0xff000000)
#define VDIN_HDR2_PROC_WIN1                        ((0x12b9  << 2) + 0xff000000)
#define VDIN_HDR2_PROC_WIN2                        ((0x12ba  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXI_EN_CTRL                  ((0x12bb  << 2) + 0xff000000)
#define VDIN_HDR2_MATRIXO_EN_CTRL                  ((0x12bc  << 2) + 0xff000000)
#define VDIN_HDR2_HIST_CTRL                        ((0x12bd  << 2) + 0xff000000)
#define VDIN_HDR2_HIST_H_START_END                 ((0x12be  << 2) + 0xff000000)
#define VDIN_HDR2_HIST_V_START_END                 ((0x12bf  << 2) + 0xff000000)
#define VDIN_HDR2_HIST_RD                          ((0x129d  << 2) + 0xff000000)
#define VDIN_WRARB_MODE                            ((0x12c0  << 2) + 0xff000000)
#define VDIN_WRARB_REQEN_SLV                       ((0x12c1  << 2) + 0xff000000)
#define VDIN_WRARB_WEIGH0_SLV                      ((0x12c2  << 2) + 0xff000000)
#define VDIN_WRARB_WEIGH1_SLV                      ((0x12c3  << 2) + 0xff000000)
#define VDIN_RDWR_ARB_STATUS                       ((0x12c4  << 2) + 0xff000000)
#define VDIN_ARB_DBG_CTRL                          ((0x12c5  << 2) + 0xff000000)
#define VDIN_ARB_DBG_STAT                          ((0x12c6  << 2) + 0xff000000)
#define VDIN_DBG_AXI_CMD_CNT                       ((0x12c7  << 2) + 0xff000000)
#define VDIN_DBG_AXI_DAT_CNT                       ((0x12c8  << 2) + 0xff000000)
#define VDIN_CRC_CTRL                              ((0x12c9  << 2) + 0xff000000)
#define VDIN_RO_CRC                                ((0x12ca  << 2) + 0xff000000)
#define VDIN_LINE_INT                              ((0x12cb  << 2) + 0xff000000)
#define VDIN_WR_URGENT_CTRL                        ((0x1257  << 2) + 0xff000000)
#define VDIN_RO_WRMIF_STATUS                       ((0x1258  << 2) + 0xff000000)
//for vdin dolby descramble start
#define VDIN_DSC_CTRL                              ((0x12d0  << 2) + 0xff000000)
//Bit   31:10     reserved
//Bit   9:4       reg_dithout_switch  ,uns, default = 36;//{2'h2,2'h1,2'h0}
//Bit   3,        reg_detunnel_en     ,uns, default = 1;
//Bit   2,        reg_detunnel_u_start,uns, default = 0;
//Bit   1,        reg_vdin_dith_en    ,uns, default = 1;
//Bit   0,        reg_descramble_en   ,uns, default = 1;
#define VDIN_CFMT_CTRL                             ((0x12d1  << 2) + 0xff000000)
//Bit 31:9  reserved
//Bit 8     reg_chfmt_rpt_pix          uns, default = 0    ; //  if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 7:4   reg_chfmt_ini_phase        uns, default = 0    ; //  horizontal formatter initial phase
//Bit 3     reg_chfmt_rpt_p0_en        uns, default = 0    ; //  horizontal formatter repeat pixel 0 enable
//Bit 2:1   reg_chfmt_yc_ratio         uns, default = 1    ; //  horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 0     reg_chfmt_en               uns, default = 1    ; //  horizontal formatter enable
#define VDIN_CFMT_W                                ((0x12d2  << 2) + 0xff000000)
//Bit 31:29 reserved
//Bit 28:16 reg_chfmt_w                uns, default = 1920   ;horizontal formatter width
//Bit 15:13 reserved
//Bit 12:0  reg_cvfmt_w                uns, default = 960    ;vertical formatter width
#define VDIN_SCB_CTRL0                             ((0x12d3  << 2) + 0xff000000)
//Bit   31:12   reserved
//Bit   11      reg_444c422_gofield_en     uns, default = 1;
//Bit   10      reg_tunnel_en              uns, default = 1;
//Bit   9:4     reg_tunnel_outswitch       uns, default = 36;//{2'h2,2'h1,2'h0}
//Bit   3:2     reg_444c422_mode           uns, default = 0; //0:left 1:right 2,3:avg
//Bit   1       reg_444c422_bypass         uns, default = 0; 1:bypass
//Bit   0       reserved                   //pulse for frm_en
#define VDIN_SCB_CTRL1                             ((0x12d4  << 2) + 0xff000000)
//Bit 31:29 reserved
//Bit 28:16 reg_444c422_hsize    uns, default = 1920   ;horizontal size
//Bit 15:13 reserved
//Bit 12:0  reg_444c422_vsize    uns, default = 960    ;vertical size
#define VDIN_DSC_HSIZE                             ((0x12d5  << 2) + 0xff000000)
//Bit 31:29 reserved
//Bit 28:16 reg_detunnel_hsize uns, default = 1920   ;
//Bit 15:13 reserved
//Bit 12:0  reg_dither_hsize   uns, default = 1920   ;
#define VDIN_DSC_DETUNNEL_SEL                      ((0x12d6  << 2) + 0xff000000)
//Bit 31:18 reserved
//Bit 17:0  reg_detunnel_sel   uns, default = 34658;  //{3'h1,3'h0,3'h3  ,3'h5,3'h4,3'h2}
#define VDIN_DSC_TUNNEL_SEL                        ((0x12d7  << 2) + 0xff000000)
//Bit 31:18 reserved
//Bit 17:0  reg_tunnel_sel   uns, default = 69868;  //= {3'h2,3'h1  ,3'h0,3'h3  ,3'h5,3'h4};
#define VDIN_HDR2_SIZE                             ((0x12d8  << 2) + 0xff000000)
#define VDIN_VSHRK_SIZE_M1                         ((0x12d9  << 2) + 0xff000000)
//dither
#define VDIN_DITH_CTRL                             ((0x12e0  << 2) + 0xff000000)
#define VDIN_DITH_LUT_1                            ((0x12e1  << 2) + 0xff000000)
#define VDIN_DITH_LUT_2                            ((0x12e2  << 2) + 0xff000000)
#define VDIN_DITH_LUT_3                            ((0x12e3  << 2) + 0xff000000)
#define VDIN_DITH_LUT_4                            ((0x12e4  << 2) + 0xff000000)
#define VDIN_DITH_LUT_5                            ((0x12e5  << 2) + 0xff000000)
#define VDIN_DITH_LUT_6                            ((0x12e6  << 2) + 0xff000000)
#define VDIN_DITH_LUT_7                            ((0x12e7  << 2) + 0xff000000)
#define VDIN_DITH_LUT_8                            ((0x12e8  << 2) + 0xff000000)
#define VDIN_DITH_LUT_9                            ((0x12e9  << 2) + 0xff000000)
#define VDIN_DITH_LUT_10                           ((0x12ea  << 2) + 0xff000000)
#define VDIN_DITH_LUT_11                           ((0x12eb  << 2) + 0xff000000)
#define VDIN_DITH_LUT_12                           ((0x12ec  << 2) + 0xff000000)
//for vdin dolby descramble end
#define VDIN_HSK_CTRL                              ((0x12ef  << 2) + 0xff000000)
//Bit   31:23    reserved
//Bit   22:16    reg_hsk_size  ,uns, default = 4;
//Bit   15:13    reserved
//Bit   12:0     reg_frm_hsize ,uns, default = 1920;
#define VDIN_HSK_COEF_0                            ((0x12f0  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef00  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_1                            ((0x12f1  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef01  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_2                            ((0x12f2  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef02  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_3                            ((0x12f3  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef03  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_4                            ((0x12f4  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef04  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_5                            ((0x12f5  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef05  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_6                            ((0x12f6  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef06  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_7                            ((0x12f7  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef07  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_8                            ((0x12f8  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef08  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_9                            ((0x12f9  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef09  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_A                            ((0x12fa  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef10  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_B                            ((0x12fb  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef11  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
//
#define VDIN_HSK_COEF_C                            ((0x12fc  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef12  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_D                            ((0x12fd  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef13  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_E                            ((0x12fe  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef14  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
#define VDIN_HSK_COEF_F                            ((0x12ff  << 2) + 0xff000000)
//Bit  31:0   reg_hsk_coef15  ,uns, default = 0;//[29:24] [21:16] [13:8] [5:0] is used
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin_regs.h
//

//8'h72 occupied by histogram 32
//VDIN0        8'h00 - 8'h7f
#define VDIN0_SCALE_COEF_IDX                    (VDIN_SCALE_COEF_IDX               )
#define VDIN0_SCALE_COEF                        (VDIN_SCALE_COEF                   )
#define VDIN0_COM_CTRL0                         (VDIN_COM_CTRL0                    )
#define VDIN0_ACTIVE_MAX_PIX_CNT_STATUS         (VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN0_LCNT_STATUS                       (VDIN_LCNT_STATUS                  )
#define VDIN0_COM_STATUS0                       (VDIN_COM_STATUS0                  )
#define VDIN0_COM_STATUS1                       (VDIN_COM_STATUS1                  )
#define VDIN0_LCNT_SHADOW_STATUS                (VDIN_LCNT_SHADOW_STATUS           )
#define VDIN0_ASFIFO_CTRL0                      (VDIN_ASFIFO_CTRL0                 )
#define VDIN0_ASFIFO_CTRL1                      (VDIN_ASFIFO_CTRL1                 )
#define VDIN0_WIDTHM1I_WIDTHM1O                 (VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN0_SC_MISC_CTRL                      (VDIN_SC_MISC_CTRL                 )
#define VDIN0_HSC_PHASE_STEP                    (VDIN_HSC_PHASE_STEP               )
#define VDIN0_HSC_INI_CTRL                      (VDIN_HSC_INI_CTRL                 )
#define VDIN0_COM_STATUS2                       (VDIN_COM_STATUS2                  )
#define VDIN0_COM_STATUS3                       (VDIN_COM_STATUS3                  )
#define VDIN0_ASFIFO_CTRL2                      (VDIN_ASFIFO_CTRL2                 )
#define VDIN0_MATRIX_CTRL                       (VDIN_MATRIX_CTRL                  )
#define VDIN0_MATRIX_COEF00_01                  (VDIN_MATRIX_COEF00_01             )
#define VDIN0_MATRIX_COEF02_10                  (VDIN_MATRIX_COEF02_10             )
#define VDIN0_MATRIX_COEF11_12                  (VDIN_MATRIX_COEF11_12             )
#define VDIN0_MATRIX_COEF20_21                  (VDIN_MATRIX_COEF20_21             )
#define VDIN0_MATRIX_COEF22                     (VDIN_MATRIX_COEF22                )
#define VDIN0_MATRIX_OFFSET0_1                  (VDIN_MATRIX_OFFSET0_1             )
#define VDIN0_MATRIX_OFFSET2                    (VDIN_MATRIX_OFFSET2               )
#define VDIN0_MATRIX_PRE_OFFSET0_1              (VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN0_MATRIX_PRE_OFFSET2                (VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN0_LFIFO_CTRL                        (VDIN_LFIFO_CTRL                   )
#define VDIN0_COM_GCLK_CTRL                     (VDIN_COM_GCLK_CTRL                )
#define VDIN0_INTF_WIDTHM1                      (VDIN_INTF_WIDTHM1                 )
#define VDIN0_WR_CTRL2                          (VDIN_WR_CTRL2                     )
#define VDIN0_WR_CTRL                           (VDIN_WR_CTRL                      )
#define VDIN0_WR_H_START_END                    (VDIN_WR_H_START_END               )
#define VDIN0_WR_V_START_END                    (VDIN_WR_V_START_END               )
#define VDIN0_VSC_PHASE_STEP                    (VDIN_VSC_PHASE_STEP               )
#define VDIN0_VSC_INI_CTRL                      (VDIN_VSC_INI_CTRL                 )
#define VDIN0_SCIN_HEIGHTM1                     (VDIN_SCIN_HEIGHTM1                )
#define VDIN0_DUMMY_DATA                        (VDIN_DUMMY_DATA                   )
#define VDIN0_MATRIX_PROBE_COLOR                (VDIN_MATRIX_PROBE_COLOR           )
#define VDIN0_MATRIX_HL_COLOR                   (VDIN_MATRIX_HL_COLOR              )
#define VDIN0_MATRIX_PROBE_POS                  (VDIN_MATRIX_PROBE_POS             )
#define VDIN0_CHROMA_ADDR_PORT                  (VDIN_CHROMA_ADDR_PORT             )
#define VDIN0_CHROMA_DATA_PORT                  (VDIN_CHROMA_DATA_PORT             )
#define VDIN0_CM_BRI_CON_CTRL                   (VDIN_CM_BRI_CON_CTRL              )
#define VDIN0_GO_LINE_CTRL                      (VDIN_GO_LINE_CTRL                 )
#define VDIN0_HIST_CTRL                         (VDIN_HIST_CTRL                    )
#define VDIN0_HIST_H_START_END                  (VDIN_HIST_H_START_END             )
#define VDIN0_HIST_V_START_END                  (VDIN_HIST_V_START_END             )
#define VDIN0_HIST_MAX_MIN                      (VDIN_HIST_MAX_MIN                 )
#define VDIN0_HIST_SPL_VAL                      (VDIN_HIST_SPL_VAL                 )
#define VDIN0_HIST_SPL_PIX_CNT                  (VDIN_HIST_SPL_PIX_CNT             )
#define VDIN0_HIST_CHROMA_SUM                   (VDIN_HIST_CHROMA_SUM              )
#define VDIN0_DNLP_HIST00                       (VDIN_DNLP_HIST00                  )
#define VDIN0_DNLP_HIST01                       (VDIN_DNLP_HIST01                  )
#define VDIN0_DNLP_HIST02                       (VDIN_DNLP_HIST02                  )
#define VDIN0_DNLP_HIST03                       (VDIN_DNLP_HIST03                  )
#define VDIN0_DNLP_HIST04                       (VDIN_DNLP_HIST04                  )
#define VDIN0_DNLP_HIST05                       (VDIN_DNLP_HIST05                  )
#define VDIN0_DNLP_HIST06                       (VDIN_DNLP_HIST06                  )
#define VDIN0_DNLP_HIST07                       (VDIN_DNLP_HIST07                  )
#define VDIN0_DNLP_HIST08                       (VDIN_DNLP_HIST08                  )
#define VDIN0_DNLP_HIST09                       (VDIN_DNLP_HIST09                  )
#define VDIN0_DNLP_HIST10                       (VDIN_DNLP_HIST10                  )
#define VDIN0_DNLP_HIST11                       (VDIN_DNLP_HIST11                  )
#define VDIN0_DNLP_HIST12                       (VDIN_DNLP_HIST12                  )
#define VDIN0_DNLP_HIST13                       (VDIN_DNLP_HIST13                  )
#define VDIN0_DNLP_HIST14                       (VDIN_DNLP_HIST14                  )
#define VDIN0_DNLP_HIST15                       (VDIN_DNLP_HIST15                  )
#define VDIN0_DNLP_HIST16                       (VDIN_DNLP_HIST16                  )
#define VDIN0_DNLP_HIST17                       (VDIN_DNLP_HIST17                  )
#define VDIN0_DNLP_HIST18                       (VDIN_DNLP_HIST18                  )
#define VDIN0_DNLP_HIST19                       (VDIN_DNLP_HIST19                  )
#define VDIN0_DNLP_HIST20                       (VDIN_DNLP_HIST20                  )
#define VDIN0_DNLP_HIST21                       (VDIN_DNLP_HIST21                  )
#define VDIN0_DNLP_HIST22                       (VDIN_DNLP_HIST22                  )
#define VDIN0_DNLP_HIST23                       (VDIN_DNLP_HIST23                  )
#define VDIN0_DNLP_HIST24                       (VDIN_DNLP_HIST24                  )
#define VDIN0_DNLP_HIST25                       (VDIN_DNLP_HIST25                  )
#define VDIN0_DNLP_HIST26                       (VDIN_DNLP_HIST26                  )
#define VDIN0_DNLP_HIST27                       (VDIN_DNLP_HIST27                  )
#define VDIN0_DNLP_HIST28                       (VDIN_DNLP_HIST28                  )
#define VDIN0_DNLP_HIST29                       (VDIN_DNLP_HIST29                  )
#define VDIN0_DNLP_HIST30                       (VDIN_DNLP_HIST30                  )
#define VDIN0_DNLP_HIST31                       (VDIN_DNLP_HIST31                  )
#define VDIN0_DNLP_HIST32                       (VDIN_DNLP_HIST32                  )
#define VDIN0_MEAS_CTRL0                        (VDIN_MEAS_CTRL0                   )
#define VDIN0_MEAS_VS_COUNT_HI                  (VDIN_MEAS_VS_COUNT_HI             )
#define VDIN0_MEAS_VS_COUNT_LO                  (VDIN_MEAS_VS_COUNT_LO             )
#define VDIN0_MEAS_HS_RANGE                     (VDIN_MEAS_HS_RANGE                )
#define VDIN0_MEAS_HS_COUNT                     (VDIN_MEAS_HS_COUNT                )
#define VDIN0_BLKBAR_CTRL1                      (VDIN_BLKBAR_CTRL1                 )
#define VDIN0_BLKBAR_CTRL0                      (VDIN_BLKBAR_CTRL0                 )
#define VDIN0_BLKBAR_H_START_END                (VDIN_BLKBAR_H_START_END           )
#define VDIN0_BLKBAR_V_START_END                (VDIN_BLKBAR_V_START_END           )
#define VDIN0_BLKBAR_CNT_THRESHOLD              (VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN0_BLKBAR_ROW_TH1_TH2                (VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN0_BLKBAR_IND_LEFT_START_END         (VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN0_BLKBAR_IND_RIGHT_START_END        (VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN0_BLKBAR_IND_LEFT1_CNT              (VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN0_BLKBAR_IND_LEFT2_CNT              (VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN0_BLKBAR_IND_RIGHT1_CNT             (VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN0_BLKBAR_IND_RIGHT2_CNT             (VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN0_BLKBAR_STATUS0                    (VDIN_BLKBAR_STATUS0               )
#define VDIN0_BLKBAR_STATUS1                    (VDIN_BLKBAR_STATUS1               )
#define VDIN0_WIN_H_START_END                   (VDIN_WIN_H_START_END              )
#define VDIN0_WIN_V_START_END                   (VDIN_WIN_V_START_END              )
#define VDIN0_ASFIFO_CTRL3                      (VDIN_ASFIFO_CTRL3                 )
#define VDIN0_LFIFO_URG_CTRL                    (VDIN_LFIFO_URG_CTRL               )
#define VDIN0_COM_GCLK_CTRL2                    (VDIN_COM_GCLK_CTRL2               )
#define VDIN0_VSHRK_CTRL                        (VDIN_VSHRK_CTRL                   )
#define VDIN0_SYNC_MASK                         (VDIN_SYNC_MASK                    )
#define VDIN0_DOLBY_DSC_CTRL0                   (VDIN_DOLBY_DSC_CTRL0  )
#define VDIN0_DOLBY_DSC_CTRL1                   (VDIN_DOLBY_DSC_CTRL1  )
#define VDIN0_DOLBY_DSC_CTRL2                   (VDIN_DOLBY_DSC_CTRL2  )
#define VDIN0_DOLBY_DSC_CTRL3                   (VDIN_DOLBY_DSC_CTRL3  )
#define VDIN0_DOLBY_AXI_CTRL0                   (VDIN_DOLBY_AXI_CTRL0  )
#define VDIN0_DOLBY_AXI_CTRL1                   (VDIN_DOLBY_AXI_CTRL1  )
#define VDIN0_DOLBY_AXI_CTRL2                   (VDIN_DOLBY_AXI_CTRL2  )
#define VDIN0_DOLBY_AXI_CTRL3                   (VDIN_DOLBY_AXI_CTRL3  )
#define VDIN0_DOLBY_DSC_STATUS0                 (VDIN_DOLBY_DSC_STATUS0)
#define VDIN0_DOLBY_DSC_STATUS1                 (VDIN_DOLBY_DSC_STATUS1)
#define VDIN0_DOLBY_DSC_STATUS2                 (VDIN_DOLBY_DSC_STATUS2)
#define VDIN0_DOLBY_DSC_STATUS3                 (VDIN_DOLBY_DSC_STATUS3)
#define VDIN0_HDR2_CTRL                           VDIN_HDR2_CTRL
#define VDIN0_HDR2_CLK_GATE                       VDIN_HDR2_CLK_GATE
#define VDIN0_HDR2_MATRIXI_COEF00_01              VDIN_HDR2_MATRIXI_COEF00_01
#define VDIN0_HDR2_MATRIXI_COEF02_10              VDIN_HDR2_MATRIXI_COEF02_10
#define VDIN0_HDR2_MATRIXI_COEF11_12              VDIN_HDR2_MATRIXI_COEF11_12
#define VDIN0_HDR2_MATRIXI_COEF20_21              VDIN_HDR2_MATRIXI_COEF20_21
#define VDIN0_HDR2_MATRIXI_COEF22                 VDIN_HDR2_MATRIXI_COEF22
#define VDIN0_HDR2_MATRIXI_COEF30_31              VDIN_HDR2_MATRIXI_COEF30_31
#define VDIN0_HDR2_MATRIXI_COEF32_40              VDIN_HDR2_MATRIXI_COEF32_40
#define VDIN0_HDR2_MATRIXI_COEF41_42              VDIN_HDR2_MATRIXI_COEF41_42
#define VDIN0_HDR2_MATRIXI_OFFSET0_1              VDIN_HDR2_MATRIXI_OFFSET0_1
#define VDIN0_HDR2_MATRIXI_OFFSET2                VDIN_HDR2_MATRIXI_OFFSET2
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET0_1          VDIN_HDR2_MATRIXI_PRE_OFFSET0_1
#define VDIN0_HDR2_MATRIXI_PRE_OFFSET2            VDIN_HDR2_MATRIXI_PRE_OFFSET2
#define VDIN0_HDR2_MATRIXO_COEF00_01              VDIN_HDR2_MATRIXO_COEF00_01
#define VDIN0_HDR2_MATRIXO_COEF02_10              VDIN_HDR2_MATRIXO_COEF02_10
#define VDIN0_HDR2_MATRIXO_COEF11_12              VDIN_HDR2_MATRIXO_COEF11_12
#define VDIN0_HDR2_MATRIXO_COEF20_21              VDIN_HDR2_MATRIXO_COEF20_21
#define VDIN0_HDR2_MATRIXO_COEF22                 VDIN_HDR2_MATRIXO_COEF22
#define VDIN0_HDR2_MATRIXO_COEF30_31              VDIN_HDR2_MATRIXO_COEF30_31
#define VDIN0_HDR2_MATRIXO_COEF32_40              VDIN_HDR2_MATRIXO_COEF32_40
#define VDIN0_HDR2_MATRIXO_COEF41_42              VDIN_HDR2_MATRIXO_COEF41_42
#define VDIN0_HDR2_MATRIXO_OFFSET0_1              VDIN_HDR2_MATRIXO_OFFSET0_1
#define VDIN0_HDR2_MATRIXO_OFFSET2                VDIN_HDR2_MATRIXO_OFFSET2
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET0_1          VDIN_HDR2_MATRIXO_PRE_OFFSET0_1
#define VDIN0_HDR2_MATRIXO_PRE_OFFSET2            VDIN_HDR2_MATRIXO_PRE_OFFSET2
#define VDIN0_HDR2_MATRIXI_CLIP                   VDIN_HDR2_MATRIXI_CLIP
#define VDIN0_HDR2_MATRIXO_CLIP                   VDIN_HDR2_MATRIXO_CLIP
#define VDIN0_HDR2_CGAIN_OFFT                     VDIN_HDR2_CGAIN_OFFT
#define VDIN0_EOTF_LUT_ADDR_PORT                  VDIN_EOTF_LUT_ADDR_PORT
#define VDIN0_EOTF_LUT_DATA_PORT                  VDIN_EOTF_LUT_DATA_PORT
#define VDIN0_OETF_LUT_ADDR_PORT                  VDIN_OETF_LUT_ADDR_PORT
#define VDIN0_OETF_LUT_DATA_PORT                  VDIN_OETF_LUT_DATA_PORT
#define VDIN0_OGAIN_LUT_ADDR_PORT                 VDIN_OGAIN_LUT_ADDR_PORT
#define VDIN0_OGAIN_LUT_DATA_PORT                 VDIN_OGAIN_LUT_DATA_PORT
#define VDIN0_CGAIN_LUT_ADDR_PORT                 VDIN_CGAIN_LUT_ADDR_PORT
#define VDIN0_CGAIN_LUT_DATA_PORT                 VDIN_CGAIN_LUT_DATA_PORT
#define VDIN0_HDR2_CGAIN_COEF0                    VDIN_HDR2_CGAIN_COEF0
#define VDIN0_HDR2_CGAIN_COEF1                    VDIN_HDR2_CGAIN_COEF1
#define VDIN0_HDR2_ADPS_CTRL                      VDIN_HDR2_ADPS_CTRL
#define VDIN0_HDR2_ADPS_ALPHA0                    VDIN_HDR2_ADPS_ALPHA0
#define VDIN0_HDR2_ADPS_ALPHA1                    VDIN_HDR2_ADPS_ALPHA1
#define VDIN0_HDR2_ADPS_BETA0                     VDIN_HDR2_ADPS_BETA0
#define VDIN0_HDR2_ADPS_BETA1                     VDIN_HDR2_ADPS_BETA1
#define VDIN0_HDR2_ADPS_BETA2                     VDIN_HDR2_ADPS_BETA2
#define VDIN0_HDR2_ADPS_COEF0                     VDIN_HDR2_ADPS_COEF0
#define VDIN0_HDR2_ADPS_COEF1                     VDIN_HDR2_ADPS_COEF1
#define VDIN0_HDR2_GMUT_CTRL                      VDIN_HDR2_GMUT_CTRL
#define VDIN0_HDR2_GMUT_COEF0                     VDIN_HDR2_GMUT_COEF0
#define VDIN0_HDR2_GMUT_COEF1                     VDIN_HDR2_GMUT_COEF1
#define VDIN0_HDR2_GMUT_COEF2                     VDIN_HDR2_GMUT_COEF2
#define VDIN0_HDR2_GMUT_COEF3                     VDIN_HDR2_GMUT_COEF3
#define VDIN0_HDR2_GMUT_COEF4                     VDIN_HDR2_GMUT_COEF4
#define VDIN0_HDR2_PIPE_CTRL1                     VDIN_HDR2_PIPE_CTRL1
#define VDIN0_HDR2_PIPE_CTRL2                     VDIN_HDR2_PIPE_CTRL2
#define VDIN0_HDR2_PIPE_CTRL3                     VDIN_HDR2_PIPE_CTRL3
#define VDIN0_HDR2_PROC_WIN1                      VDIN_HDR2_PROC_WIN1
#define VDIN0_HDR2_PROC_WIN2                      VDIN_HDR2_PROC_WIN2
#define VDIN0_HDR2_MATRIXI_EN_CTRL                VDIN_HDR2_MATRIXI_EN_CTRL
#define VDIN0_HDR2_MATRIXO_EN_CTRL                VDIN_HDR2_MATRIXO_EN_CTRL
#define VDIN0_HDR2_HIST_CTRL                      VDIN_HDR2_HIST_CTRL
#define VDIN0_HDR2_HIST_H_START_END               VDIN_HDR2_HIST_H_START_END
#define VDIN0_HDR2_HIST_V_START_END               VDIN_HDR2_HIST_V_START_END
#define VDIN0_HDR2_HIST_RD                        VDIN_HDR2_HIST_RD


#define VDIN0_CRC_CTRL                     (VDIN_CRC_CTRL)
#define VDIN0_RO_CRC                       (VDIN_RO_CRC  )
#define VDIN0_LINE_INT                     (VDIN_LINE_INT)
#define VDIN0_WR_URGENT_CTRL               (VDIN_WR_URGENT_CTRL)
#define VDIN0_RO_WRMIF_STATUS              (VDIN_RO_WRMIF_STATUS)

#define VDIN0_DSC_CTRL                      VDIN_DSC_CTRL
#define VDIN0_CFMT_CTRL                     VDIN_CFMT_CTRL
#define VDIN0_CFMT_W                        VDIN_CFMT_W
#define VDIN0_SCB_CTRL0                     VDIN_SCB_CTRL0
#define VDIN0_SCB_CTRL1                     VDIN_SCB_CTRL1
#define VDIN0_DSC_HSIZE                     VDIN_DSC_HSIZE
#define VDIN0_DSC_DETUNNEL_SEL              VDIN_DSC_DETUNNEL_SEL
#define VDIN0_DSC_TUNNEL_SEL                VDIN_DSC_TUNNEL_SEL
#define VDIN0_DITH_CTRL                     VDIN_DITH_CTRL
#define VDIN0_DITH_LUT_1                    VDIN_DITH_LUT_1
#define VDIN0_DITH_LUT_2                    VDIN_DITH_LUT_2
#define VDIN0_DITH_LUT_3                    VDIN_DITH_LUT_3
#define VDIN0_DITH_LUT_4                    VDIN_DITH_LUT_4
#define VDIN0_DITH_LUT_5                    VDIN_DITH_LUT_5
#define VDIN0_DITH_LUT_6                    VDIN_DITH_LUT_6
#define VDIN0_DITH_LUT_7                    VDIN_DITH_LUT_7
#define VDIN0_DITH_LUT_8                    VDIN_DITH_LUT_8
#define VDIN0_DITH_LUT_9                    VDIN_DITH_LUT_9
#define VDIN0_DITH_LUT_10                   VDIN_DITH_LUT_10
#define VDIN0_DITH_LUT_11                   VDIN_DITH_LUT_11
#define VDIN0_DITH_LUT_12                   VDIN_DITH_LUT_12

#define VDIN0_HSK_CTRL                      VDIN_HSK_CTRL
#define VDIN0_HSK_COEF_0                    VDIN_HSK_COEF_0
#define VDIN0_HSK_COEF_1                    VDIN_HSK_COEF_1
#define VDIN0_HSK_COEF_2                    VDIN_HSK_COEF_2
#define VDIN0_HSK_COEF_3                    VDIN_HSK_COEF_3
#define VDIN0_HSK_COEF_4                    VDIN_HSK_COEF_4
#define VDIN0_HSK_COEF_5                    VDIN_HSK_COEF_5
#define VDIN0_HSK_COEF_6                    VDIN_HSK_COEF_6
#define VDIN0_HSK_COEF_7                    VDIN_HSK_COEF_7
#define VDIN0_HSK_COEF_8                    VDIN_HSK_COEF_8
#define VDIN0_HSK_COEF_9                    VDIN_HSK_COEF_9
#define VDIN0_HSK_COEF_A                    VDIN_HSK_COEF_A
#define VDIN0_HSK_COEF_B                    VDIN_HSK_COEF_B
#define VDIN0_HSK_COEF_C                    VDIN_HSK_COEF_C
#define VDIN0_HSK_COEF_D                    VDIN_HSK_COEF_D
#define VDIN0_HSK_COEF_E                    VDIN_HSK_COEF_E
#define VDIN0_HSK_COEF_F                    VDIN_HSK_COEF_F

#define VDIN0_HDR2_SIZE                     VDIN_HDR2_SIZE
#define VDIN0_VSHRK_SIZE_M1                 VDIN_VSHRK_SIZE_M1

// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin0_regs.h
//
//
// Reading file:  vpu_vdin1_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// VDIN
//===========================================================================
// -----------------------------------------------
// REG_BASE:  VDIN1_VCBUS_BASE = 0x13
// -----------------------------------------------
#define  VDIN1_OFFSET   (0x100)
// `include "vpu_vdin_regs.h"
//8'h72 occupied by histogram 32
//VDIN1        8'h00 - 8'h7f
#define VDIN1_SCALE_COEF_IDX                    ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF_IDX               )
#define VDIN1_SCALE_COEF                        ((VDIN1_OFFSET << 2) + VDIN_SCALE_COEF                   )
#define VDIN1_COM_CTRL0                         ((VDIN1_OFFSET << 2) + VDIN_COM_CTRL0                    )
#define VDIN1_ACTIVE_MAX_PIX_CNT_STATUS         ((VDIN1_OFFSET << 2) + VDIN_ACTIVE_MAX_PIX_CNT_STATUS    )
#define VDIN1_LCNT_STATUS                       ((VDIN1_OFFSET << 2) + VDIN_LCNT_STATUS                  )
#define VDIN1_COM_STATUS0                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS0                  )
#define VDIN1_COM_STATUS1                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS1                  )
#define VDIN1_LCNT_SHADOW_STATUS                ((VDIN1_OFFSET << 2) + VDIN_LCNT_SHADOW_STATUS           )
#define VDIN1_ASFIFO_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL0                 )
#define VDIN1_ASFIFO_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL1                 )
#define VDIN1_WIDTHM1I_WIDTHM1O                 ((VDIN1_OFFSET << 2) + VDIN_WIDTHM1I_WIDTHM1O            )
#define VDIN1_SC_MISC_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_SC_MISC_CTRL                 )
#define VDIN1_HSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_HSC_PHASE_STEP               )
#define VDIN1_HSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_HSC_INI_CTRL                 )
#define VDIN1_COM_STATUS2                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS2                  )
#define VDIN1_COM_STATUS3                       ((VDIN1_OFFSET << 2) + VDIN_COM_STATUS3                  )
#define VDIN1_ASFIFO_CTRL2                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL2                 )
#define VDIN1_MATRIX_CTRL                       ((VDIN1_OFFSET << 2) + VDIN_MATRIX_CTRL                  )
#define VDIN1_MATRIX_COEF00_01                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF00_01             )
#define VDIN1_MATRIX_COEF02_10                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF02_10             )
#define VDIN1_MATRIX_COEF11_12                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF11_12             )
#define VDIN1_MATRIX_COEF20_21                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF20_21             )
#define VDIN1_MATRIX_COEF22                     ((VDIN1_OFFSET << 2) + VDIN_MATRIX_COEF22                )
#define VDIN1_MATRIX_OFFSET0_1                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET0_1             )
#define VDIN1_MATRIX_OFFSET2                    ((VDIN1_OFFSET << 2) + VDIN_MATRIX_OFFSET2               )
#define VDIN1_MATRIX_PRE_OFFSET0_1              ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET0_1         )
#define VDIN1_MATRIX_PRE_OFFSET2                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PRE_OFFSET2           )
#define VDIN1_LFIFO_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_LFIFO_CTRL                   )
#define VDIN1_COM_GCLK_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL                )
#define VDIN1_INTF_WIDTHM1                      ((VDIN1_OFFSET << 2) + VDIN_INTF_WIDTHM1                 )
#define VDIN1_WR_CTRL2                          ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL2                     )
#define VDIN1_WR_CTRL                           ((VDIN1_OFFSET << 2) + VDIN_WR_CTRL                      )
#define VDIN1_WR_H_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_H_START_END               )
#define VDIN1_WR_V_START_END                    ((VDIN1_OFFSET << 2) + VDIN_WR_V_START_END               )
#define VDIN1_VSC_PHASE_STEP                    ((VDIN1_OFFSET << 2) + VDIN_VSC_PHASE_STEP               )
#define VDIN1_VSC_INI_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_VSC_INI_CTRL                 )
#define VDIN1_SCIN_HEIGHTM1                     ((VDIN1_OFFSET << 2) + VDIN_SCIN_HEIGHTM1                )
#define VDIN1_DUMMY_DATA                        ((VDIN1_OFFSET << 2) + VDIN_DUMMY_DATA                   )
#define VDIN1_MATRIX_PROBE_COLOR                ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_COLOR           )
#define VDIN1_MATRIX_HL_COLOR                   ((VDIN1_OFFSET << 2) + VDIN_MATRIX_HL_COLOR              )
#define VDIN1_MATRIX_PROBE_POS                  ((VDIN1_OFFSET << 2) + VDIN_MATRIX_PROBE_POS             )
#define VDIN1_CHROMA_ADDR_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_ADDR_PORT             )
#define VDIN1_CHROMA_DATA_PORT                  ((VDIN1_OFFSET << 2) + VDIN_CHROMA_DATA_PORT             )
#define VDIN1_CM_BRI_CON_CTRL                   ((VDIN1_OFFSET << 2) + VDIN_CM_BRI_CON_CTRL              )
#define VDIN1_GO_LINE_CTRL                      ((VDIN1_OFFSET << 2) + VDIN_GO_LINE_CTRL                 )
#define VDIN1_HIST_CTRL                         ((VDIN1_OFFSET << 2) + VDIN_HIST_CTRL                    )
#define VDIN1_HIST_H_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_H_START_END             )
#define VDIN1_HIST_V_START_END                  ((VDIN1_OFFSET << 2) + VDIN_HIST_V_START_END             )
#define VDIN1_HIST_MAX_MIN                      ((VDIN1_OFFSET << 2) + VDIN_HIST_MAX_MIN                 )
#define VDIN1_HIST_SPL_VAL                      ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_VAL                 )
#define VDIN1_HIST_SPL_PIX_CNT                  ((VDIN1_OFFSET << 2) + VDIN_HIST_SPL_PIX_CNT             )
#define VDIN1_HIST_CHROMA_SUM                   ((VDIN1_OFFSET << 2) + VDIN_HIST_CHROMA_SUM              )
#define VDIN1_DNLP_HIST00                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST00                  )
#define VDIN1_DNLP_HIST01                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST01                  )
#define VDIN1_DNLP_HIST02                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST02                  )
#define VDIN1_DNLP_HIST03                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST03                  )
#define VDIN1_DNLP_HIST04                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST04                  )
#define VDIN1_DNLP_HIST05                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST05                  )
#define VDIN1_DNLP_HIST06                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST06                  )
#define VDIN1_DNLP_HIST07                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST07                  )
#define VDIN1_DNLP_HIST08                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST08                  )
#define VDIN1_DNLP_HIST09                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST09                  )
#define VDIN1_DNLP_HIST10                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST10                  )
#define VDIN1_DNLP_HIST11                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST11                  )
#define VDIN1_DNLP_HIST12                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST12                  )
#define VDIN1_DNLP_HIST13                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST13                  )
#define VDIN1_DNLP_HIST14                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST14                  )
#define VDIN1_DNLP_HIST15                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST15                  )
#define VDIN1_DNLP_HIST16                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST16                  )
#define VDIN1_DNLP_HIST17                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST17                  )
#define VDIN1_DNLP_HIST18                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST18                  )
#define VDIN1_DNLP_HIST19                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST19                  )
#define VDIN1_DNLP_HIST20                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST20                  )
#define VDIN1_DNLP_HIST21                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST21                  )
#define VDIN1_DNLP_HIST22                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST22                  )
#define VDIN1_DNLP_HIST23                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST23                  )
#define VDIN1_DNLP_HIST24                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST24                  )
#define VDIN1_DNLP_HIST25                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST25                  )
#define VDIN1_DNLP_HIST26                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST26                  )
#define VDIN1_DNLP_HIST27                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST27                  )
#define VDIN1_DNLP_HIST28                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST28                  )
#define VDIN1_DNLP_HIST29                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST29                  )
#define VDIN1_DNLP_HIST30                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST30                  )
#define VDIN1_DNLP_HIST31                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST31                  )
#define VDIN1_DNLP_HIST32                       ((VDIN1_OFFSET << 2) + VDIN_DNLP_HIST32                  )
#define VDIN1_MEAS_CTRL0                        ((VDIN1_OFFSET << 2) + VDIN_MEAS_CTRL0                   )
#define VDIN1_MEAS_VS_COUNT_HI                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_HI             )
#define VDIN1_MEAS_VS_COUNT_LO                  ((VDIN1_OFFSET << 2) + VDIN_MEAS_VS_COUNT_LO             )
#define VDIN1_MEAS_HS_RANGE                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_RANGE                )
#define VDIN1_MEAS_HS_COUNT                     ((VDIN1_OFFSET << 2) + VDIN_MEAS_HS_COUNT                )
#define VDIN1_BLKBAR_CTRL1                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL1                 )
#define VDIN1_BLKBAR_CTRL0                      ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CTRL0                 )
#define VDIN1_BLKBAR_H_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_H_START_END           )
#define VDIN1_BLKBAR_V_START_END                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_V_START_END           )
#define VDIN1_BLKBAR_CNT_THRESHOLD              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_CNT_THRESHOLD         )
#define VDIN1_BLKBAR_ROW_TH1_TH2                ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_ROW_TH1_TH2           )
#define VDIN1_BLKBAR_IND_LEFT_START_END         ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT_START_END    )
#define VDIN1_BLKBAR_IND_RIGHT_START_END        ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT_START_END   )
#define VDIN1_BLKBAR_IND_LEFT1_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT1_CNT         )
#define VDIN1_BLKBAR_IND_LEFT2_CNT              ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_LEFT2_CNT         )
#define VDIN1_BLKBAR_IND_RIGHT1_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT1_CNT        )
#define VDIN1_BLKBAR_IND_RIGHT2_CNT             ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_IND_RIGHT2_CNT        )
#define VDIN1_BLKBAR_STATUS0                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS0               )
#define VDIN1_BLKBAR_STATUS1                    ((VDIN1_OFFSET << 2) + VDIN_BLKBAR_STATUS1               )
#define VDIN1_WIN_H_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_H_START_END              )
#define VDIN1_WIN_V_START_END                   ((VDIN1_OFFSET << 2) + VDIN_WIN_V_START_END              )
#define VDIN1_ASFIFO_CTRL3                      ((VDIN1_OFFSET << 2) + VDIN_ASFIFO_CTRL3                 )
#define VDIN1_LFIFO_URG_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_LFIFO_URG_CTRL               )
#define VDIN1_COM_GCLK_CTRL2                    ((VDIN1_OFFSET << 2) + VDIN_COM_GCLK_CTRL2               )
#define VDIN1_VSHRK_CTRL                        ((VDIN1_OFFSET << 2) + VDIN_VSHRK_CTRL                   )
#define VDIN1_SYNC_MASK                         ((VDIN1_OFFSET << 2) + VDIN_SYNC_MASK                    )
#define VDIN1_DOLBY_DSC_CTRL0                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL0  )
#define VDIN1_DOLBY_DSC_CTRL1                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL1  )
#define VDIN1_DOLBY_DSC_CTRL2                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL2  )
#define VDIN1_DOLBY_DSC_CTRL3                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_CTRL3  )
#define VDIN1_DOLBY_AXI_CTRL0                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL0  )
#define VDIN1_DOLBY_AXI_CTRL1                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL1  )
#define VDIN1_DOLBY_AXI_CTRL2                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL2  )
#define VDIN1_DOLBY_AXI_CTRL3                   ((VDIN1_OFFSET << 2) + VDIN_DOLBY_AXI_CTRL3  )
#define VDIN1_DOLBY_DSC_STATUS0                 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS0)
#define VDIN1_DOLBY_DSC_STATUS1                 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS1)
#define VDIN1_DOLBY_DSC_STATUS2                 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS2)
#define VDIN1_DOLBY_DSC_STATUS3                 ((VDIN1_OFFSET << 2) + VDIN_DOLBY_DSC_STATUS3)

#define VDIN1_HDR2_CTRL                         ((VDIN1_OFFSET << 2) + VDIN_HDR2_CTRL                   )
#define VDIN1_HDR2_CLK_GATE                     ((VDIN1_OFFSET << 2) + VDIN_HDR2_CLK_GATE               )
#define VDIN1_HDR2_MATRIXI_COEF00_01            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF00_01      )
#define VDIN1_HDR2_MATRIXI_COEF02_10            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF02_10      )
#define VDIN1_HDR2_MATRIXI_COEF11_12            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF11_12      )
#define VDIN1_HDR2_MATRIXI_COEF20_21            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF20_21      )
#define VDIN1_HDR2_MATRIXI_COEF22               ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF22         )
#define VDIN1_HDR2_MATRIXI_COEF30_31            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF30_31      )
#define VDIN1_HDR2_MATRIXI_COEF32_40            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF32_40      )
#define VDIN1_HDR2_MATRIXI_COEF41_42            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_COEF41_42      )
#define VDIN1_HDR2_MATRIXI_OFFSET0_1            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_OFFSET0_1      )
#define VDIN1_HDR2_MATRIXI_OFFSET2              ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_OFFSET2        )
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET0_1        ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_PRE_OFFSET0_1  )
#define VDIN1_HDR2_MATRIXI_PRE_OFFSET2          ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_PRE_OFFSET2    )
#define VDIN1_HDR2_MATRIXO_COEF00_01            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF00_01      )
#define VDIN1_HDR2_MATRIXO_COEF02_10            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF02_10      )
#define VDIN1_HDR2_MATRIXO_COEF11_12            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF11_12      )
#define VDIN1_HDR2_MATRIXO_COEF20_21            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF20_21      )
#define VDIN1_HDR2_MATRIXO_COEF22               ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF22         )
#define VDIN1_HDR2_MATRIXO_COEF30_31            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF30_31      )
#define VDIN1_HDR2_MATRIXO_COEF32_40            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF32_40      )
#define VDIN1_HDR2_MATRIXO_COEF41_42            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_COEF41_42      )
#define VDIN1_HDR2_MATRIXO_OFFSET0_1            ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_OFFSET0_1      )
#define VDIN1_HDR2_MATRIXO_OFFSET2              ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_OFFSET2        )
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET0_1        ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_PRE_OFFSET0_1  )
#define VDIN1_HDR2_MATRIXO_PRE_OFFSET2          ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_PRE_OFFSET2    )
#define VDIN1_HDR2_MATRIXI_CLIP                 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_CLIP           )
#define VDIN1_HDR2_MATRIXO_CLIP                 ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_CLIP           )
#define VDIN1_HDR2_CGAIN_OFFT                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_OFFT             )
#define VDIN1_EOTF_LUT_ADDR_PORT                ((VDIN1_OFFSET << 2) + VDIN_EOTF_LUT_ADDR_PORT          )
#define VDIN1_EOTF_LUT_DATA_PORT                ((VDIN1_OFFSET << 2) + VDIN_EOTF_LUT_DATA_PORT          )
#define VDIN1_OETF_LUT_ADDR_PORT                ((VDIN1_OFFSET << 2) + VDIN_OETF_LUT_ADDR_PORT          )
#define VDIN1_OETF_LUT_DATA_PORT                ((VDIN1_OFFSET << 2) + VDIN_OETF_LUT_DATA_PORT          )
#define VDIN1_OGAIN_LUT_ADDR_PORT               ((VDIN1_OFFSET << 2) + VDIN_OGAIN_LUT_ADDR_PORT         )
#define VDIN1_OGAIN_LUT_DATA_PORT               ((VDIN1_OFFSET << 2) + VDIN_OGAIN_LUT_DATA_PORT         )
#define VDIN1_CGAIN_LUT_ADDR_PORT               ((VDIN1_OFFSET << 2) + VDIN_CGAIN_LUT_ADDR_PORT         )
#define VDIN1_CGAIN_LUT_DATA_PORT               ((VDIN1_OFFSET << 2) + VDIN_CGAIN_LUT_DATA_PORT         )
#define VDIN1_HDR2_CGAIN_COEF0                  ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_COEF0            )
#define VDIN1_HDR2_CGAIN_COEF1                  ((VDIN1_OFFSET << 2) + VDIN_HDR2_CGAIN_COEF1            )
#define VDIN1_HDR2_ADPS_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_CTRL              )
#define VDIN1_HDR2_ADPS_ALPHA0                  ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_ALPHA0            )
#define VDIN1_HDR2_ADPS_ALPHA1                  ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_ALPHA1            )
#define VDIN1_HDR2_ADPS_BETA0                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA0             )
#define VDIN1_HDR2_ADPS_BETA1                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA1             )
#define VDIN1_HDR2_ADPS_BETA2                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_BETA2             )
#define VDIN1_HDR2_ADPS_COEF0                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_COEF0             )
#define VDIN1_HDR2_ADPS_COEF1                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_ADPS_COEF1             )
#define VDIN1_HDR2_GMUT_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_CTRL              )
#define VDIN1_HDR2_GMUT_COEF0                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF0             )
#define VDIN1_HDR2_GMUT_COEF1                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF1             )
#define VDIN1_HDR2_GMUT_COEF2                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF2             )
#define VDIN1_HDR2_GMUT_COEF3                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF3             )
#define VDIN1_HDR2_GMUT_COEF4                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_GMUT_COEF4             )
#define VDIN1_HDR2_PIPE_CTRL1                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL1 )
#define VDIN1_HDR2_PIPE_CTRL2                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL2 )
#define VDIN1_HDR2_PIPE_CTRL3                   ((VDIN1_OFFSET << 2) + VDIN_HDR2_PIPE_CTRL3 )
#define VDIN1_HDR2_PROC_WIN1                    ((VDIN1_OFFSET << 2) + VDIN_HDR2_PROC_WIN1  )
#define VDIN1_HDR2_PROC_WIN2                    ((VDIN1_OFFSET << 2) + VDIN_HDR2_PROC_WIN2  )
#define VDIN1_HDR2_MATRIXI_EN_CTRL              ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXI_EN_CTRL  )
#define VDIN1_HDR2_MATRIXO_EN_CTRL              ((VDIN1_OFFSET << 2) + VDIN_HDR2_MATRIXO_EN_CTRL  )
#define VDIN1_HDR2_HIST_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_CTRL        )
#define VDIN1_HDR2_HIST_H_START_END             ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_H_START_END )
#define VDIN1_HDR2_HIST_V_START_END             ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_V_START_END )
#define VDIN1_HDR2_HIST_RD                      ((VDIN1_OFFSET << 2) + VDIN_HDR2_HIST_RD          )



#define VDIN1_CRC_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_CRC_CTRL)
#define VDIN1_RO_CRC                       ((VDIN1_OFFSET << 2) + VDIN_RO_CRC  )
#define VDIN1_LINE_INT                     ((VDIN1_OFFSET << 2) + VDIN_LINE_INT)
#define VDIN1_WR_URGENT_CTRL               ((VDIN1_OFFSET << 2) + VDIN_WR_URGENT_CTRL)
#define VDIN1_RO_WRMIF_STATUS              ((VDIN1_OFFSET << 2) + VDIN_RO_WRMIF_STATUS)

#define VDIN1_DSC_CTRL                     ((VDIN1_OFFSET << 2) + VDIN_DSC_CTRL    )
#define VDIN1_CFMT_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_CFMT_CTRL   )
#define VDIN1_CFMT_W                       ((VDIN1_OFFSET << 2) + VDIN_CFMT_W      )
#define VDIN1_SCB_CTRL0                    ((VDIN1_OFFSET << 2) + VDIN_SCB_CTRL0   )
#define VDIN1_SCB_CTRL1                    ((VDIN1_OFFSET << 2) + VDIN_SCB_CTRL1   )
#define VDIN1_DSC_HSIZE                    ((VDIN1_OFFSET << 2) + VDIN_DSC_HSIZE   )
#define VDIN1_DSC_DETUNNEL_SEL             ((VDIN1_OFFSET << 2) + VDIN_DSC_DETUNNEL_SEL)
#define VDIN1_DSC_TUNNEL_SEL               ((VDIN1_OFFSET << 2) + VDIN_DSC_TUNNEL_SEL)
#define VDIN1_DITH_CTRL                    ((VDIN1_OFFSET << 2) + VDIN_DITH_CTRL   )
#define VDIN1_DITH_LUT_1                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_1  )
#define VDIN1_DITH_LUT_2                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_2  )
#define VDIN1_DITH_LUT_3                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_3  )
#define VDIN1_DITH_LUT_4                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_4  )
#define VDIN1_DITH_LUT_5                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_5  )
#define VDIN1_DITH_LUT_6                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_6  )
#define VDIN1_DITH_LUT_7                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_7  )
#define VDIN1_DITH_LUT_8                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_8  )
#define VDIN1_DITH_LUT_9                   ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_9  )
#define VDIN1_DITH_LUT_10                  ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_10 )
#define VDIN1_DITH_LUT_11                  ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_11 )
#define VDIN1_DITH_LUT_12                  ((VDIN1_OFFSET << 2) + VDIN_DITH_LUT_12 )

#define VDIN1_HSK_CTRL                     ((VDIN1_OFFSET << 2) +  VDIN_HSK_CTRL   )
#define VDIN1_HSK_COEF_0                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_0 )
#define VDIN1_HSK_COEF_1                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_1 )
#define VDIN1_HSK_COEF_2                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_2 )
#define VDIN1_HSK_COEF_3                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_3 )
#define VDIN1_HSK_COEF_4                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_4 )
#define VDIN1_HSK_COEF_5                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_5 )
#define VDIN1_HSK_COEF_6                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_6 )
#define VDIN1_HSK_COEF_7                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_7 )
#define VDIN1_HSK_COEF_8                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_8 )
#define VDIN1_HSK_COEF_9                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_9 )
#define VDIN1_HSK_COEF_A                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_A )
#define VDIN1_HSK_COEF_B                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_B )
#define VDIN1_HSK_COEF_C                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_C )
#define VDIN1_HSK_COEF_D                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_D )
#define VDIN1_HSK_COEF_E                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_E )
#define VDIN1_HSK_COEF_F                   ((VDIN1_OFFSET << 2) +  VDIN_HSK_COEF_F )

#define VDIN1_HDR2_SIZE                    ((VDIN1_OFFSET << 2) +  VDIN_HDR2_SIZE    )
#define VDIN1_VSHRK_SIZE_M1                ((VDIN1_OFFSET << 2) +  VDIN_VSHRK_SIZE_M1)



// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_vdin1_regs.h
//
//
// Reading file:  lcd_regs.h
//
// -----------------------------------------------
// REG_BASE:  LCD_VCBUS_BASE = 0x14
// -----------------------------------------------
//========================================================================
//LCD DRV     12'h480~12'h4ef
//=======================================================================
#define L_GAMMA_CNTL_PORT                          ((0x1400  << 2) + 0xff000000)
#define L_GAMMA_DATA_PORT                          ((0x1401  << 2) + 0xff000000)
#define L_GAMMA_ADDR_PORT                          ((0x1402  << 2) + 0xff000000)
#define L_GAMMA_VCOM_HSWITCH_ADDR                  ((0x1403  << 2) + 0xff000000)
#define L_RGB_BASE_ADDR                            ((0x1405  << 2) + 0xff000000)
#define L_RGB_COEFF_ADDR                           ((0x1406  << 2) + 0xff000000)
#define L_POL_CNTL_ADDR                            ((0x1407  << 2) + 0xff000000)
#define L_DITH_CNTL_ADDR                           ((0x1408  << 2) + 0xff000000)
#define L_GAMMA_PROBE_CTRL                         ((0x1409  << 2) + 0xff000000)
//read only
#define L_GAMMA_PROBE_COLOR_L                      ((0x140a  << 2) + 0xff000000)
#define L_GAMMA_PROBE_COLOR_H                      ((0x140b  << 2) + 0xff000000)
#define L_GAMMA_PROBE_HL_COLOR                     ((0x140c  << 2) + 0xff000000)
#define L_GAMMA_PROBE_POS_X                        ((0x140d  << 2) + 0xff000000)
#define L_GAMMA_PROBE_POS_Y                        ((0x140e  << 2) + 0xff000000)
#define L_STH1_HS_ADDR                             ((0x1410  << 2) + 0xff000000)
#define L_STH1_HE_ADDR                             ((0x1411  << 2) + 0xff000000)
#define L_STH1_VS_ADDR                             ((0x1412  << 2) + 0xff000000)
#define L_STH1_VE_ADDR                             ((0x1413  << 2) + 0xff000000)
#define L_STH2_HS_ADDR                             ((0x1414  << 2) + 0xff000000)
#define L_STH2_HE_ADDR                             ((0x1415  << 2) + 0xff000000)
#define L_STH2_VS_ADDR                             ((0x1416  << 2) + 0xff000000)
#define L_STH2_VE_ADDR                             ((0x1417  << 2) + 0xff000000)
#define L_OEH_HS_ADDR                              ((0x1418  << 2) + 0xff000000)
#define L_OEH_HE_ADDR                              ((0x1419  << 2) + 0xff000000)
#define L_OEH_VS_ADDR                              ((0x141a  << 2) + 0xff000000)
#define L_OEH_VE_ADDR                              ((0x141b  << 2) + 0xff000000)
#define L_VCOM_HSWITCH_ADDR                        ((0x141c  << 2) + 0xff000000)
#define L_VCOM_VS_ADDR                             ((0x141d  << 2) + 0xff000000)
#define L_VCOM_VE_ADDR                             ((0x141e  << 2) + 0xff000000)
#define L_CPV1_HS_ADDR                             ((0x141f  << 2) + 0xff000000)
#define L_CPV1_HE_ADDR                             ((0x1420  << 2) + 0xff000000)
#define L_CPV1_VS_ADDR                             ((0x1421  << 2) + 0xff000000)
#define L_CPV1_VE_ADDR                             ((0x1422  << 2) + 0xff000000)
#define L_CPV2_HS_ADDR                             ((0x1423  << 2) + 0xff000000)
#define L_CPV2_HE_ADDR                             ((0x1424  << 2) + 0xff000000)
#define L_CPV2_VS_ADDR                             ((0x1425  << 2) + 0xff000000)
#define L_CPV2_VE_ADDR                             ((0x1426  << 2) + 0xff000000)
#define L_STV1_HS_ADDR                             ((0x1427  << 2) + 0xff000000)
#define L_STV1_HE_ADDR                             ((0x1428  << 2) + 0xff000000)
#define L_STV1_VS_ADDR                             ((0x1429  << 2) + 0xff000000)
#define L_STV1_VE_ADDR                             ((0x142a  << 2) + 0xff000000)
#define L_STV2_HS_ADDR                             ((0x142b  << 2) + 0xff000000)
#define L_STV2_HE_ADDR                             ((0x142c  << 2) + 0xff000000)
#define L_STV2_VS_ADDR                             ((0x142d  << 2) + 0xff000000)
#define L_STV2_VE_ADDR                             ((0x142e  << 2) + 0xff000000)
#define L_OEV1_HS_ADDR                             ((0x142f  << 2) + 0xff000000)
#define L_OEV1_HE_ADDR                             ((0x1430  << 2) + 0xff000000)
#define L_OEV1_VS_ADDR                             ((0x1431  << 2) + 0xff000000)
#define L_OEV1_VE_ADDR                             ((0x1432  << 2) + 0xff000000)
#define L_OEV2_HS_ADDR                             ((0x1433  << 2) + 0xff000000)
#define L_OEV2_HE_ADDR                             ((0x1434  << 2) + 0xff000000)
#define L_OEV2_VS_ADDR                             ((0x1435  << 2) + 0xff000000)
#define L_OEV2_VE_ADDR                             ((0x1436  << 2) + 0xff000000)
#define L_OEV3_HS_ADDR                             ((0x1437  << 2) + 0xff000000)
#define L_OEV3_HE_ADDR                             ((0x1438  << 2) + 0xff000000)
#define L_OEV3_VS_ADDR                             ((0x1439  << 2) + 0xff000000)
#define L_OEV3_VE_ADDR                             ((0x143a  << 2) + 0xff000000)
#define L_LCD_PWR_ADDR                             ((0x143b  << 2) + 0xff000000)
#define L_LCD_PWM0_LO_ADDR                         ((0x143c  << 2) + 0xff000000)
#define L_LCD_PWM0_HI_ADDR                         ((0x143d  << 2) + 0xff000000)
#define L_LCD_PWM1_LO_ADDR                         ((0x143e  << 2) + 0xff000000)
#define L_LCD_PWM1_HI_ADDR                         ((0x143f  << 2) + 0xff000000)
#define L_INV_CNT_ADDR                             ((0x1440  << 2) + 0xff000000)
#define L_TCON_MISC_SEL_ADDR                       ((0x1441  << 2) + 0xff000000)
#define L_DUAL_PORT_CNTL_ADDR                      ((0x1442  << 2) + 0xff000000)
#define MLVDS_CLK_CTL1_HI                          ((0x1443  << 2) + 0xff000000)
#define MLVDS_CLK_CTL1_LO                          ((0x1444  << 2) + 0xff000000)
//  [31:30] enable mlvds clocks
//  [24]    mlvds_clk_half_delay       24 // Bit 0
//  [23:0]  mlvds_clk_pattern           0 // Bit 23:0
#define L_TCON_DOUBLE_CTL                          ((0x1449  << 2) + 0xff000000)
#define L_TCON_PATTERN_HI                          ((0x144a  << 2) + 0xff000000)
#define L_TCON_PATTERN_LO                          ((0x144b  << 2) + 0xff000000)
#define LDIM_BL_ADDR_PORT                          ((0x144e  << 2) + 0xff000000)
#define LDIM_BL_DATA_PORT                          ((0x144f  << 2) + 0xff000000)
#define L_DE_HS_ADDR                               ((0x1451  << 2) + 0xff000000)
#define L_DE_HE_ADDR                               ((0x1452  << 2) + 0xff000000)
#define L_DE_VS_ADDR                               ((0x1453  << 2) + 0xff000000)
#define L_DE_VE_ADDR                               ((0x1454  << 2) + 0xff000000)
#define L_HSYNC_HS_ADDR                            ((0x1455  << 2) + 0xff000000)
#define L_HSYNC_HE_ADDR                            ((0x1456  << 2) + 0xff000000)
#define L_HSYNC_VS_ADDR                            ((0x1457  << 2) + 0xff000000)
#define L_HSYNC_VE_ADDR                            ((0x1458  << 2) + 0xff000000)
#define L_VSYNC_HS_ADDR                            ((0x1459  << 2) + 0xff000000)
#define L_VSYNC_HE_ADDR                            ((0x145a  << 2) + 0xff000000)
#define L_VSYNC_VS_ADDR                            ((0x145b  << 2) + 0xff000000)
#define L_VSYNC_VE_ADDR                            ((0x145c  << 2) + 0xff000000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define L_LCD_MCU_CTL                              ((0x145d  << 2) + 0xff000000)
//**************************************************************************
//*  Dual port mLVDS registers
//**************************************************************************
// bit 3 - enable_u_dual_mlvds_dp_clk
// bit 2 - enable_u_map_mlvds_r_clk
// bit 1 - enable_u_map_mlvds_l_clk
// bit 0 - dual_mlvds_en
//`define DUAL_MLVDS_CTL                8'h60
// bit[12:0] - dual_mlvds_line_start
//`define DUAL_MLVDS_LINE_START         8'h61
// bit[12:0] - dual_mlvds_line_end
//`define DUAL_MLVDS_LINE_END           8'h62
// bit[12:0] - dual_mlvds_w_pixel_start_l
//`define DUAL_MLVDS_PIXEL_W_START_L    8'h63
// bit[12:0] - dual_mlvds_w_pixel_end_l
//`define DUAL_MLVDS_PIXEL_W_END_L      8'h64
// bit[12:0] - dual_mlvds_w_pixel_start_r
//`define DUAL_MLVDS_PIXEL_W_START_R    8'h65
// bit[12:0] - dual_mlvds_w_pixel_end_r
//`define DUAL_MLVDS_PIXEL_W_END_R      8'h66
// bit[12:0] - dual_mlvds_r_pixel_start_l
//`define DUAL_MLVDS_PIXEL_R_START_L    8'h67
// bit[12:0] - dual_mlvds_r_pixel_cnt_l
//`define DUAL_MLVDS_PIXEL_R_CNT_L      8'h68
// bit[12:0] - dual_mlvds_r_pixel_start_r
//`define DUAL_MLVDS_PIXEL_R_START_R    8'h69
// bit[12:0] - dual_mlvds_r_pixel_cnt_r
//`define DUAL_MLVDS_PIXEL_R_CNT_R      8'h6a
// bit[15]   - v_inversion_en
// bit[12:0] - v_inversion_pixel
//`define V_INVERSION_PIXEL             8'h70
// bit[15]   - v_inversion_sync_en
// bit[12:0] - v_inversion_line
//`define V_INVERSION_LINE              8'h71
// bit[15:12]  - v_loop_r
// bit[11:10]  - v_pattern_1_r
// bit[9:8]    - v_pattern_0_r
// bit[7:4]    - v_loop_l
// bit[3:2]    - v_pattern_1_l
// bit[1:0]    - v_pattern_0_l
//`define V_INVERSION_CONTROL           8'h72
//`define MLVDS2_CONTROL           8'h74
   #define     mLVDS2_RESERVED  15    // 15
   #define     mLVDS2_double_pattern  14    // 14
   #define     mLVDS2_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS2_dual_gate  7
   #define     mLVDS2_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS2_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS2_msb_first  4
   #define     mLVDS2_PORT_SWAP  3
   #define     mLVDS2_MLSB_SWAP  2
   #define     mLVDS2_PN_SWAP    1
   #define     mLVDS2_en         0
//`define MLVDS2_CONFIG_HI         8'h75
//`define MLVDS2_CONFIG_LO         8'h76
   #define     mLVDS2_reset_offset         29 // Bit 31:29
   #define     mLVDS2_reset_length         23 // Bit 28:23
   #define     mLVDS2_config_reserved      20 // Bit 22:20
   #define     mLVDS2_reset_start_bit12    19 // Bit 19
   #define     mLVDS2_data_write_toggle    18
   #define     mLVDS2_data_write_ini       17
   #define     mLVDS2_data_latch_1_toggle  16
   #define     mLVDS2_data_latch_1_ini     15
   #define     mLVDS2_data_latch_0_toggle  14
   #define     mLVDS2_data_latch_0_ini     13
   #define     mLVDS2_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS2_reset_start           0 // Bit 11:0
//`define MLVDS2_DUAL_GATE_WR_START        8'h77
//   `define     mlvds2_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_WR_END          8'h78
//   `define     mlvds2_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_RD_START        8'h79
//   `define     mlvds2_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS2_DUAL_GATE_RD_END          8'h7a
//   `define     mlvds2_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS2_SECOND_RESET_CTL          8'h7b
//   `define     mLVDS2_2nd_reset_start       0 // Bit 12:0
//
//`define MLVDS2_DUAL_GATE_CTL_HI        8'h7c
//`define MLVDS2_DUAL_GATE_CTL_LO        8'h7d
//   `define     mlvds2_tcon_field_en        24 // Bit 7:0
//   `define     mlvds2_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds2_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds2_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds2_scan_mode_even       12 // Bit 3:0
//   `define     mlvds2_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS2_RESET_CONFIG_HI         8'h7e
//`define MLVDS2_RESET_CONFIG_LO         8'h7f
//   `define     mLVDS2_reset_range_enable   31 // Bit 0
//   `define     mLVDS2_reset_range_inv      30 // Bit 0
//   `define     mLVDS2_reset_config_res1    29 // Bit 0
//   `define     mLVDS2_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS2_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS2_reset_range_line_1    0 // Bit 11:0
//
//**************************************************************************
//*  Vbyone registers  (Note: no MinLVDS in G9tv, share the register)
//**************************************************************************
#define VBO_CTRL_L                                 ((0x1460  << 2) + 0xff000000)
#define VBO_CTRL_H                                 ((0x1461  << 2) + 0xff000000)
#define VBO_SOFT_RST                               ((0x1462  << 2) + 0xff000000)
#define VBO_LANES                                  ((0x1463  << 2) + 0xff000000)
#define VBO_VIN_CTRL                               ((0x1464  << 2) + 0xff000000)
#define VBO_ACT_VSIZE                              ((0x1465  << 2) + 0xff000000)
#define VBO_REGION_00                              ((0x1466  << 2) + 0xff000000)
#define VBO_REGION_01                              ((0x1467  << 2) + 0xff000000)
#define VBO_REGION_02                              ((0x1468  << 2) + 0xff000000)
#define VBO_REGION_03                              ((0x1469  << 2) + 0xff000000)
#define VBO_VBK_CTRL_0                             ((0x146a  << 2) + 0xff000000)
#define VBO_VBK_CTRL_1                             ((0x146b  << 2) + 0xff000000)
#define VBO_HBK_CTRL                               ((0x146c  << 2) + 0xff000000)
#define VBO_PXL_CTRL                               ((0x146d  << 2) + 0xff000000)
#define VBO_LANE_SKEW_L                            ((0x146e  << 2) + 0xff000000)
#define VBO_LANE_SKEW_H                            ((0x146f  << 2) + 0xff000000)
#define VBO_GCLK_LANE_L                            ((0x1470  << 2) + 0xff000000)
#define VBO_GCLK_LANE_H                            ((0x1471  << 2) + 0xff000000)
#define VBO_GCLK_MAIN                              ((0x1472  << 2) + 0xff000000)
#define VBO_STATUS_L                               ((0x1473  << 2) + 0xff000000)
#define VBO_STATUS_H                               ((0x1474  << 2) + 0xff000000)
#define VBO_LANE_OUTPUT                            ((0x1475  << 2) + 0xff000000)
#define LCD_PORT_SWAP                              ((0x1476  << 2) + 0xff000000)
#define VBO_TMCHK_THRD_L                           ((0x1478  << 2) + 0xff000000)
#define VBO_TMCHK_THRD_H                           ((0x1479  << 2) + 0xff000000)
#define VBO_FSM_HOLDER_L                           ((0x147a  << 2) + 0xff000000)
#define VBO_FSM_HOLDER_H                           ((0x147b  << 2) + 0xff000000)
#define VBO_INTR_STATE_CTRL                        ((0x147c  << 2) + 0xff000000)
#define VBO_INTR_UNMASK                            ((0x147d  << 2) + 0xff000000)
#define VBO_TMCHK_HSYNC_STATE_L                    ((0x147e  << 2) + 0xff000000)
#define VBO_TMCHK_HSYNC_STATE_H                    ((0x147f  << 2) + 0xff000000)
#define VBO_TMCHK_VSYNC_STATE_L                    ((0x14f4  << 2) + 0xff000000)
#define VBO_TMCHK_VSYNC_STATE_H                    ((0x14f5  << 2) + 0xff000000)
#define VBO_TMCHK_VDE_STATE_L                      ((0x14f6  << 2) + 0xff000000)
#define VBO_TMCHK_VDE_STATE_H                      ((0x14f7  << 2) + 0xff000000)
#define VBO_INTR_STATE                             ((0x14f8  << 2) + 0xff000000)
#define VBO_INFILTER_CTRL                          ((0x14f9  << 2) + 0xff000000)
#define VBO_INSGN_CTRL                             ((0x14fa  << 2) + 0xff000000)
#define VBO_INFILTER_CTRL_H                        ((0x1477  << 2) + 0xff000000)
//**************************************************************************
//*  NOTE::    When Programming the Gamma, please turn off the IRQ service *
//**************************************************************************
#define GAMMA_CNTL_PORT                            ((0x1480  << 2) + 0xff000000)
   #define  GAMMA_VCOM_POL    7     //RW
   #define  GAMMA_RVS_OUT     6     //RW
   #define  ADR_RDY           5     //Read Only
   #define  WR_RDY            4     //Read Only
   #define  RD_RDY            3     //Read Only
   #define  GAMMA_TR          2     //RW
   #define  GAMMA_SET         1     //RW
   #define  GAMMA_EN          0     //RW
#define GAMMA_DATA_PORT                            ((0x1481  << 2) + 0xff000000)
#define GAMMA_ADDR_PORT                            ((0x1482  << 2) + 0xff000000)
   #define  H_RD              12
   #define  H_AUTO_INC        11
   #define  H_SEL_R           10
   #define  H_SEL_G           9
   #define  H_SEL_B           8
   #define  HADR_MSB          7            //7:0
   #define  HADR              0            //7:0
#define GAMMA_VCOM_HSWITCH_ADDR                    ((0x1483  << 2) + 0xff000000)
#define RGB_BASE_ADDR                              ((0x1485  << 2) + 0xff000000)
#define RGB_COEFF_ADDR                             ((0x1486  << 2) + 0xff000000)
#define POL_CNTL_ADDR                              ((0x1487  << 2) + 0xff000000)
   #define   DCLK_SEL             14    //FOR DCLK OUTPUT
   #define   TCON_VSYNC_SEL_DVI   11    //FOR RGB format DVI output
   #define   TCON_HSYNC_SEL_DVI   10    //FOR RGB format DVI output
   #define   TCON_DE_SEL_DVI      9     //FOR RGB format DVI output
   #define   CPH3_POL         8
   #define   CPH2_POL         7
   #define   CPH1_POL         6
   #define   TCON_DE_SEL      5
   #define   TCON_VS_SEL      4
   #define   TCON_HS_SEL      3
   #define   DE_POL           2
   #define   VS_POL           1
   #define   HS_POL           0
#define DITH_CNTL_ADDR                             ((0x1488  << 2) + 0xff000000)
   #define  DITH10_EN         10
   #define  DITH8_EN          9
   #define  DITH_MD           8
   #define  DITH10_CNTL_MSB   7          //7:4
   #define  DITH10_CNTL       4          //7:4
   #define  DITH8_CNTL_MSB    3          //3:0
   #define  DITH8_CNTL        0          //3:0
//Bit 1 highlight_en
//Bit 0 probe_en
#define GAMMA_PROBE_CTRL                           ((0x1489  << 2) + 0xff000000)
//read only
//Bit [15:0]  probe_color[15:0]
#define GAMMA_PROBE_COLOR_L                        ((0x148a  << 2) + 0xff000000)
//Read only
//Bit 15: if true valid probed color
//Bit [13:0]  probe_color[29:16]
#define GAMMA_PROBE_COLOR_H                        ((0x148b  << 2) + 0xff000000)
//bit 15:0, 5:6:5 color
#define GAMMA_PROBE_HL_COLOR                       ((0x148c  << 2) + 0xff000000)
//12:0 pos_x
#define GAMMA_PROBE_POS_X                          ((0x148d  << 2) + 0xff000000)
//12:0 pos_y
#define GAMMA_PROBE_POS_Y                          ((0x148e  << 2) + 0xff000000)
#define STH1_HS_ADDR                               ((0x1490  << 2) + 0xff000000)
#define STH1_HE_ADDR                               ((0x1491  << 2) + 0xff000000)
#define STH1_VS_ADDR                               ((0x1492  << 2) + 0xff000000)
#define STH1_VE_ADDR                               ((0x1493  << 2) + 0xff000000)
#define STH2_HS_ADDR                               ((0x1494  << 2) + 0xff000000)
#define STH2_HE_ADDR                               ((0x1495  << 2) + 0xff000000)
#define STH2_VS_ADDR                               ((0x1496  << 2) + 0xff000000)
#define STH2_VE_ADDR                               ((0x1497  << 2) + 0xff000000)
#define OEH_HS_ADDR                                ((0x1498  << 2) + 0xff000000)
#define OEH_HE_ADDR                                ((0x1499  << 2) + 0xff000000)
#define OEH_VS_ADDR                                ((0x149a  << 2) + 0xff000000)
#define OEH_VE_ADDR                                ((0x149b  << 2) + 0xff000000)
#define VCOM_HSWITCH_ADDR                          ((0x149c  << 2) + 0xff000000)
#define VCOM_VS_ADDR                               ((0x149d  << 2) + 0xff000000)
#define VCOM_VE_ADDR                               ((0x149e  << 2) + 0xff000000)
#define CPV1_HS_ADDR                               ((0x149f  << 2) + 0xff000000)
#define CPV1_HE_ADDR                               ((0x14a0  << 2) + 0xff000000)
#define CPV1_VS_ADDR                               ((0x14a1  << 2) + 0xff000000)
#define CPV1_VE_ADDR                               ((0x14a2  << 2) + 0xff000000)
#define CPV2_HS_ADDR                               ((0x14a3  << 2) + 0xff000000)
#define CPV2_HE_ADDR                               ((0x14a4  << 2) + 0xff000000)
#define CPV2_VS_ADDR                               ((0x14a5  << 2) + 0xff000000)
#define CPV2_VE_ADDR                               ((0x14a6  << 2) + 0xff000000)
#define STV1_HS_ADDR                               ((0x14a7  << 2) + 0xff000000)
#define STV1_HE_ADDR                               ((0x14a8  << 2) + 0xff000000)
#define STV1_VS_ADDR                               ((0x14a9  << 2) + 0xff000000)
#define STV1_VE_ADDR                               ((0x14aa  << 2) + 0xff000000)
#define STV2_HS_ADDR                               ((0x14ab  << 2) + 0xff000000)
#define STV2_HE_ADDR                               ((0x14ac  << 2) + 0xff000000)
#define STV2_VS_ADDR                               ((0x14ad  << 2) + 0xff000000)
#define STV2_VE_ADDR                               ((0x14ae  << 2) + 0xff000000)
#define OEV1_HS_ADDR                               ((0x14af  << 2) + 0xff000000)
#define OEV1_HE_ADDR                               ((0x14b0  << 2) + 0xff000000)
#define OEV1_VS_ADDR                               ((0x14b1  << 2) + 0xff000000)
#define OEV1_VE_ADDR                               ((0x14b2  << 2) + 0xff000000)
#define OEV2_HS_ADDR                               ((0x14b3  << 2) + 0xff000000)
#define OEV2_HE_ADDR                               ((0x14b4  << 2) + 0xff000000)
#define OEV2_VS_ADDR                               ((0x14b5  << 2) + 0xff000000)
#define OEV2_VE_ADDR                               ((0x14b6  << 2) + 0xff000000)
#define OEV3_HS_ADDR                               ((0x14b7  << 2) + 0xff000000)
#define OEV3_HE_ADDR                               ((0x14b8  << 2) + 0xff000000)
#define OEV3_VS_ADDR                               ((0x14b9  << 2) + 0xff000000)
#define OEV3_VE_ADDR                               ((0x14ba  << 2) + 0xff000000)
#define LCD_PWR_ADDR                               ((0x14bb  << 2) + 0xff000000)
   #define      LCD_VDD        5
   #define      LCD_VBL        4
   #define      LCD_GPI_MSB    3
   #define      LCD_GPIO       0
#define LCD_PWM0_LO_ADDR                           ((0x14bc  << 2) + 0xff000000)
#define LCD_PWM0_HI_ADDR                           ((0x14bd  << 2) + 0xff000000)
#define LCD_PWM1_LO_ADDR                           ((0x14be  << 2) + 0xff000000)
#define LCD_PWM1_HI_ADDR                           ((0x14bf  << 2) + 0xff000000)
#define INV_CNT_ADDR                               ((0x14c0  << 2) + 0xff000000)
   #define     INV_EN          4
   #define     INV_CNT_MSB     3
   #define     INV_CNT         0
#define TCON_MISC_SEL_ADDR                         ((0x14c1  << 2) + 0xff000000)
   #define     STH2_SEL        12
   #define     STH1_SEL        11
   #define     OEH_SEL         10
   #define     VCOM_SEL         9
   #define     DB_LINE_SW       8
   #define     CPV2_SEL         7
   #define     CPV1_SEL         6
   #define     STV2_SEL         5
   #define     STV1_SEL         4
   #define     OEV_UNITE        3
   #define     OEV3_SEL         2
   #define     OEV2_SEL         1
   #define     OEV1_SEL         0
#define DUAL_PORT_CNTL_ADDR                        ((0x14c2  << 2) + 0xff000000)
   #define     OUTPUT_YUV       15
   #define     DUAL_IDF         12   // 14:12
   #define     DUAL_ISF         9    // 11:9
   #define     LCD_ANALOG_SEL_CPH3   8
   #define     LCD_ANALOG_3PHI_CLK_SEL   7
   #define     LCD_LVDS_SEL54   6
   #define     LCD_LVDS_SEL27   5
   #define     LCD_TTL_SEL      4
   #define     DUAL_LVDC_EN     3
   #define     PORT_SWP         2
   #define     RGB_SWP          1
   #define     BIT_SWP          0
#define MLVDS_CONTROL                              ((0x14c3  << 2) + 0xff000000)
   #define     mLVDS_RESERVED  15    // 15
   #define     mLVDS_double_pattern  14    // 14
   #define     mLVDS_ins_reset  8    // 13:8  // each channel has one bit
   #define     mLVDS_dual_gate  7
   #define     mLVDS_bit_num    6    // 0-6Bits, 1-8Bits
   #define     mLVDS_pair_num   5    // 0-3Pairs, 1-6Pairs
   #define     mLVDS_msb_first  4
   #define     mLVDS_PORT_SWAP  3
   #define     mLVDS_MLSB_SWAP  2
   #define     mLVDS_PN_SWAP    1
   #define     mLVDS_en         0
#define MLVDS_RESET_PATTERN_HI                     ((0x14c4  << 2) + 0xff000000)
#define MLVDS_RESET_PATTERN_LO                     ((0x14c5  << 2) + 0xff000000)
   #define     mLVDS_reset_pattern  0 // Bit 47:16
#define MLVDS_RESET_PATTERN_EXT                    ((0x14c6  << 2) + 0xff000000)
   #define     mLVDS_reset_pattern_ext  0 // Bit 15:0
#define MLVDS_CONFIG_HI                            ((0x14c7  << 2) + 0xff000000)
#define MLVDS_CONFIG_LO                            ((0x14c8  << 2) + 0xff000000)
   #define     mLVDS_reset_offset         29 // Bit 31:29
   #define     mLVDS_reset_length         23 // Bit 28:23
   #define     mLVDS_config_reserved      20 // Bit 22:20
   #define     mLVDS_reset_start_bit12    19 // Bit 19
   #define     mLVDS_data_write_toggle    18
   #define     mLVDS_data_write_ini       17
   #define     mLVDS_data_latch_1_toggle  16
   #define     mLVDS_data_latch_1_ini     15
   #define     mLVDS_data_latch_0_toggle  14
   #define     mLVDS_data_latch_0_ini     13
   #define     mLVDS_reset_1_select       12 // 0 - same as reset_0, 1 - 1 clock delay of reset_0
   #define     mLVDS_reset_start           0 // Bit 11:0
#define TCON_DOUBLE_CTL                            ((0x14c9  << 2) + 0xff000000)
   #define     tcon_double_ini          8 // Bit 7:0
   #define     tcon_double_inv          0 // Bit 7:0
#define TCON_PATTERN_HI                            ((0x14ca  << 2) + 0xff000000)
#define TCON_PATTERN_LO                            ((0x14cb  << 2) + 0xff000000)
   #define     tcon_pattern_loop_data     16 // Bit 15:0
   #define     tcon_pattern_loop_start    12 // Bit 3:0
   #define     tcon_pattern_loop_end       8 // Bit 3:0
   #define     tcon_pattern_enable         0 // Bit 7:0
#define TCON_CONTROL_HI                            ((0x14cc  << 2) + 0xff000000)
#define TCON_CONTROL_LO                            ((0x14cd  << 2) + 0xff000000)
   #define     tcon_pclk_enable           26 // Bit 5:0 (enable pclk on TCON channel 7 to 2)
   #define     tcon_pclk_div              24 // Bit 1:0 (control phy clock divide 2,4,6,8)
   #define     tcon_delay                  0 // Bit 23:0 (3 bit for each channel)
#define LVDS_BLANK_DATA_HI                         ((0x14ce  << 2) + 0xff000000)
#define LVDS_BLANK_DATA_LO                         ((0x14cf  << 2) + 0xff000000)
   #define     LVDS_blank_data_reserved 30  // 31:30
   #define     LVDS_blank_data_r        20  // 29:20
   #define     LVDS_blank_data_g        10  // 19:10
   #define     LVDS_blank_data_b         0  //  9:0
#define LVDS_PACK_CNTL_ADDR                        ((0x14d0  << 2) + 0xff000000)
   #define     LVDS_USE_TCON    7
   #define     LVDS_DUAL        6
   #define     PN_SWP           5
   #define     LSB_FIRST        4
   #define     LVDS_RESV        3
   #define     ODD_EVEN_SWP     2
   #define     LVDS_REPACK      0
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN7-TCON4)
// Bit 11:0 -- de_hs(old tcon) second offset_hs (new tcon)
#define DE_HS_ADDR                                 ((0x14d1  << 2) + 0xff000000)
// New from M3 :
// Bit 15:12 -- Enable OFFSET Double Generate(TOCN3-TCON0)
#define DE_HE_ADDR                                 ((0x14d2  << 2) + 0xff000000)
#define DE_VS_ADDR                                 ((0x14d3  << 2) + 0xff000000)
#define DE_VE_ADDR                                 ((0x14d4  << 2) + 0xff000000)
#define HSYNC_HS_ADDR                              ((0x14d5  << 2) + 0xff000000)
#define HSYNC_HE_ADDR                              ((0x14d6  << 2) + 0xff000000)
#define HSYNC_VS_ADDR                              ((0x14d7  << 2) + 0xff000000)
#define HSYNC_VE_ADDR                              ((0x14d8  << 2) + 0xff000000)
#define VSYNC_HS_ADDR                              ((0x14d9  << 2) + 0xff000000)
#define VSYNC_HE_ADDR                              ((0x14da  << 2) + 0xff000000)
#define VSYNC_VS_ADDR                              ((0x14db  << 2) + 0xff000000)
#define VSYNC_VE_ADDR                              ((0x14dc  << 2) + 0xff000000)
// bit 8 -- vfifo_mcu_enable
// bit 7 -- halt_vs_de
// bit 6 -- R8G8B8_format
// bit 5 -- R6G6B6_format (round to 6 bits)
// bit 4 -- R5G6B5_format
// bit 3 -- dac_dith_sel
// bit 2 -- lcd_mcu_enable_de     -- ReadOnly
// bit 1 -- lcd_mcu_enable_vsync  -- ReadOnly
// bit 0 -- lcd_mcu_enable
#define LCD_MCU_CTL                                ((0x14dd  << 2) + 0xff000000)
// ReadOnly
//   R5G6B5 when R5G6B5_format
//   G8R8   when R8G8B8_format
//   G5R10  Other
#define LCD_MCU_DATA_0                             ((0x14de  << 2) + 0xff000000)
// ReadOnly
//   G8B8   when R8G8B8_format
//   G5B10  Other
#define LCD_MCU_DATA_1                             ((0x14df  << 2) + 0xff000000)
// LVDS
#define LVDS_GEN_CNTL                              ((0x14e0  << 2) + 0xff000000)
//`define LVDS_PHY_CNTL0          8'he1
//`define LVDS_PHY_CNTL1          8'he2
//`define LVDS_PHY_CNTL2          8'he3
//`define LVDS_PHY_CNTL3          8'he4
//`define LVDS_PHY_CNTL4          8'he5
//`define LVDS_PHY_CNTL5          8'he6
#define LVDS_SRG_TEST                              ((0x14e8  << 2) + 0xff000000)
#define LVDS_BIST_MUX0                             ((0x14e9  << 2) + 0xff000000)
#define LVDS_BIST_MUX1                             ((0x14ea  << 2) + 0xff000000)
#define LVDS_BIST_FIXED0                           ((0x14eb  << 2) + 0xff000000)
#define LVDS_BIST_FIXED1                           ((0x14ec  << 2) + 0xff000000)
#define LVDS_BIST_CNTL0                            ((0x14ed  << 2) + 0xff000000)
#define LVDS_CLKB_CLKA                             ((0x14ee  << 2) + 0xff000000)
#define LVDS_PHY_CLK_CNTL                          ((0x14ef  << 2) + 0xff000000)
#define LVDS_SER_EN                                ((0x14f0  << 2) + 0xff000000)
//`define LVDS_PHY_CNTL6        8'hf1
//`define LVDS_PHY_CNTL7        8'hf2
//`define LVDS_PHY_CNTL8        8'hf3
#define LVDS_CH_SWAP0                              ((0x14e1  << 2) + 0xff000000)
#define LVDS_CH_SWAP1                              ((0x14e2  << 2) + 0xff000000)
#define LVDS_CH_SWAP2                              ((0x14e3  << 2) + 0xff000000)
//`define MLVDS_CLK_CTL0_HI        8'hf4
//`define MLVDS_CLK_CTL0_LO        8'hf5
//   `define     mlvds_clk_pattern_reserved 31 // Bit 31
//   `define     mpclk_dly                  28 // Bit 2:0
//   `define     mpclk_div                  26 // Bit 1:0 (control phy clock divide 2,4,6,8)
//   `define     use_mpclk                  25 // Bit 0
//   `define     mlvds_clk_half_delay       24 // Bit 0
//   `define     mlvds_clk_pattern           0 // Bit 23:0
//`define MLVDS_DUAL_GATE_WR_START        8'hf6
//   `define     mlvds_dual_gate_wr_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_WR_END          8'hf7
//   `define     mlvds_dual_gate_wr_end      0 // Bit 12:0
//
//`define MLVDS_DUAL_GATE_RD_START        8'hf8
//   `define     mlvds_dual_gate_rd_start    0 // Bit 12:0
//`define MLVDS_DUAL_GATE_RD_END          8'hf9
//   `define     mlvds_dual_gate_rd_end      0 // Bit 12:0
//`define MLVDS_SECOND_RESET_CTL          8'hfa
//   `define     mLVDS_2nd_reset_start       0 // Bit 12:0
//
#define MLVDS_DUAL_GATE_CTL_HI                     ((0x14fb  << 2) + 0xff000000)
#define MLVDS_DUAL_GATE_CTL_LO                     ((0x14fc  << 2) + 0xff000000)
//   `define     mlvds_tcon_field_en        24 // Bit 7:0
//   `define     mlvds_dual_gate_reserved   21 // Bit 2:0
//   `define     mlvds_scan_mode_start_line_bit12 20 // Bit 0
//   `define     mlvds_scan_mode_odd        16 // Bit 3:0
//   `define     mlvds_scan_mode_even       12 // Bit 3:0
//   `define     mlvds_scan_mode_start_line  0 // Bit 11:0
//
//`define MLVDS_RESET_CONFIG_HI         8'hfd
//`define MLVDS_RESET_CONFIG_LO         8'hfe
//   `define     mLVDS_reset_range_enable   31 // Bit 0
//   `define     mLVDS_reset_range_inv      30 // Bit 0
//   `define     mLVDS_reset_config_res1    29 // Bit 0
//   `define     mLVDS_reset_range_line_0   16 // Bit 11:0
//   `define     mLVDS_reset_config_res3    13 // Bit 2:0
//   `define     mLVDS_reset_range_line_1    0 // Bit 11:0
//===============================================================
//LCD DRIVER BASE   END
//===============================================================
//
// Closing file:  lcd_regs.h
//
//
// Reading file:  vpu_mad_regs.h
//
//DEINTERLACE module start from 8'h90 end to 8'hff
// -----------------------------------------------
// REG_BASE:  MAD_VCBUS_BASE = 0x17
// -----------------------------------------------
#define DI_PRE_CTRL                                ((0x1700  << 2) + 0xff000000)
// bit 31,      cbus_pre_frame_rst
// bit 30,      cbus_pre_soft_rst
// bit 29,      pre_field_num
// bit 27:26,   mode_444c422
// bit 25,      di_cont_read_en
// bit 24:23,   mode_422c444
// bit 22,      mtn_after_nr
// bit 21:16,   pre_hold_fifo_lines
// bit 15,      nr_wr_by
// bit 14,      use_vdin_go_line
// bit 13,      di_prevdin_en
// bit 12,      di_pre_viu_link
// bit 11,      di_pre_repeat
// bit 10,      di_pre_drop_1st
// bit  9,      di_buf2_en
// bit  8,      di_chan2_en
// bit  7,      prenr_hist_en
// bit  6,      chan2_hist_en
// bit  5,      hist_check_en
// bit  4,      check_after_nr
// bit  3,      check222p_en
// bit  2,      check322p_en
// bit  1,      mtn_en
// bit  0,      nr_en
#define DI_POST_CTRL                               ((0x1701  << 2) + 0xff000000)
// bit 31,      cbus_post_frame_rst
// bit 30,      cbus_post_soft_rst
// bit 29,      post_field_num
// bit 21:16,   post_hold_fifo_lines
// bit 13,      prepost_link
// bit 12,      di_post_viu_link
// bit 11,      di_post_repeat
// bit 10,      di_post_drop_1st
// bit  9,      mif0_to_vpp_en
// bit  8,      di_vpp_out_en
// bit  7,      di_wr_bk_en
// bit  6,      di_mux_en
// bit  5,      di_blend_en
// bit  4,      di_mtnp_read_en
// bit  3,      di_mtn_buf_en
// bit  2,      di_ei_en
// bit  1,      di_buf1_en
// bit  0,      di_buf0_en
#define DI_POST_SIZE                               ((0x1702  << 2) + 0xff000000)
//bit 31:29,    diwr_field_mode     field mode,  0 frame mode, 4 for field mode botton field, 5 for field mode top field, , 6 for blank line mode
//bit 28:16,    vsize1post
//bit 12:0,     hsize1post
#define DI_PRE_SIZE                                ((0x1703  << 2) + 0xff000000)
//bit 31:29,    nrwr_field_mode     field mode,  0 frame mode, 4 for field mode botton field, 5 for field mode top field, , 6 for blank line mode
//bit 28:16,    vsize1pre
//bit 12:0,     hsize1pre
#define DI_EI_CTRL0                                ((0x1704  << 2) + 0xff000000)
//bit 23:16,    ei0_filter[2:+]  abs_diff_left>filter && ...right>filter && ...top>filter && ...bot>filter -> filter
//bit 15:8,     ei0_threshold[2:+]
//bit 3,        ei0_vertical
//bit 2,        ei0_bpscf2
//bit 1,        ei0_bpsfar1
#define DI_EI_CTRL1                                ((0x1705  << 2) + 0xff000000)
//bit 31:24,    ei0_diff
//bit 23:16,    ei0_angle45
//bit 15:8,     ei0_peak
//bit 7:0,      ei0_cross
#define DI_EI_CTRL2                                ((0x1706  << 2) + 0xff000000)
//bit 31:24,    ei0_close2
//bit 23:16,    ei0_close1
//bit 15:8,     ei0_far2
//bit 7:0,      ei0_far1
//`define DI_NR_CTRL0               8'h07
//bit 26,       nr_cue_en
//bit 25,       nr2_en
#define DI_NR_CTRL1                                ((0x1708  << 2) + 0xff000000)
//bit 31:30,    mot_p1txtcore_mode
//bit 29:24,    mot_p1txtcore_clmt
//bit 21:16,    mot_p1txtcore_ylmt
//bit 15:8,     mot_p1txtcore_crate
//bit 7:0,      mot_p1txtcore_yrate
#define DI_NR_CTRL2                                ((0x1709  << 2) + 0xff000000)
//bit 29:24,    mot_curtxtcore_clmt
//bit 21:16,    mot_curtxtcore_ylmt
//bit 15:8,     mot_curtxtcore_crate
//bit 7:0,      mot_curtxtcore_yrate
//`define DI_NR_CTRL3               8'h0a
//no use
//`define DI_MTN_CTRL               8'h0b
//`define DI_CANVAS_URGENT0         8'h0a
//`define DI_CANVAS_URGENT1         8'h0b
#define DI_MTN_CTRL1                               ((0x170c  << 2) + 0xff000000)
//bit 11:8,		mtn_paramtnthd
//bit 7:0,      mtn_parafltthd
#define DI_BLEND_CTRL                              ((0x170d  << 2) + 0xff000000)
//bit 31,      blend_1_en
//bit 30,      blend_mtn_lpf
//bit 28,      post_mb_en
//bit 27,      blend_mtn3p_max
//bit 26,      blend_mtn3p_min
//bit 25,      blend_mtn3p_ave
//bit 24,      blend_mtn3p_maxtb
//bit 23,      blend_mtn_flt_en
//bit 22,      blend_data_flt_en
//bit 21:20,   blend_top_mode
//bit 19,      blend_reg3_enable
//bit 18,      blend_reg2_enable
//bit 17,      blend_reg1_enable
//bit 16,      blend_reg0_enable
//bit 15:14,   blend_reg3_mode
//bit 13:12,   blend_reg2_mode
//bit 11:10,   blend_reg1_mode
//bit 9:8,     blend_reg0_mode
//bit 7:0,     kdeint
//`define DI_BLEND_CTRL1            8'h0e
//no use
//`define DI_CANVAS_URGENT2         8'h0e
//`define DI_BLEND_CTRL2            8'h0f
//no use
#define DI_ARB_CTRL                                ((0x170f  << 2) + 0xff000000)
//bit 31:26,			di_arb_thd1
//bit 25:20,			di_arb_thd0
//bit 19,			di_arb_tid_mode
//bit 18,			di_arb_arb_mode
//bit 17,			di_arb_acq_en
//bit 16,			di_arb_disable_clk
//bit 15:0,			di_arb_req_en
#define DI_BLEND_REG0_X                            ((0x1710  << 2) + 0xff000000)
//bit 27:16,   blend_reg0_startx
//bit 11:0,    blend_reg0_endx
#define DI_BLEND_REG0_Y                            ((0x1711  << 2) + 0xff000000)
#define DI_BLEND_REG1_X                            ((0x1712  << 2) + 0xff000000)
#define DI_BLEND_REG1_Y                            ((0x1713  << 2) + 0xff000000)
#define DI_BLEND_REG2_X                            ((0x1714  << 2) + 0xff000000)
#define DI_BLEND_REG2_Y                            ((0x1715  << 2) + 0xff000000)
#define DI_BLEND_REG3_X                            ((0x1716  << 2) + 0xff000000)
#define DI_BLEND_REG3_Y                            ((0x1717  << 2) + 0xff000000)
#define DI_CLKG_CTRL                               ((0x1718  << 2) + 0xff000000)
//bit 31:24,   pre_gclk_ctrl     no clk gate control. if ==1, module clk is not gated (always on). [3] for pulldown,[2] for mtn_1,[1] for mtn_0,[0] for nr
//bit 23:16,   post_gclk_ctrl    no clk gate control. [4] for ei_1, [3] for ei_0,[2] for ei_top, [1] for blend_1, [0] for blend_0
//bit 1,       di_gate_all       clk shut down. if ==1 , all di clock shut down
//bit 0,       di_no_clk_gate    no clk gate control.     if di_gated_all==0 and di_no_clk_gate ==1, all di clock is always working.
#define DI_EI_CTRL3                                ((0x1719  << 2) + 0xff000000)
//bit 31,      reg_ei_1
//bit 30,      reg_demon_en
//bit 26:24,   reg_demon_mux
//bit 23:20,   reg_right_win
//bit 19:16,   reg_left_win
//bit 7:4,     reg_ei_sadm_quatize_margin
//bit 1:0,     reg_ei_sad_relative_mode
#define DI_EI_CTRL4                                ((0x171a  << 2) + 0xff000000)
//bit 29,      reg_ei_caldrt_ambliike2_biasvertical
//bit 28:24,   reg_ei_caldrt_addxla2list_drtmax
//bit 22:20,   reg_ei_caldrt_addxla2list_signm0th
//bit 19,      reg_ei_caldrt_addxla2list_mode
//bit 18:16,   reg_ei_signm_sad_cor_rate
//bit 15:12,   reg_ei_signm_sadi_cor_rate
//bit 11:6,    reg_ei_signm_sadi_cor_ofst
//bit 5:0,     reg_ei_signm_sad_ofst
#define DI_EI_CTRL5                                ((0x171b  << 2) + 0xff000000)
//bit 30:28,   reg_ei_caldrt_cnflcctchk_frcverthrd
//bit 26:24,   reg_ei_caldrt_cnflctchk_mg
//bit 23:22,   reg_ei_caldrt_cnflctchk_ws
//bit 21,      reg_ei_caldrt_cnflctchk_en
//bit 20,      reg_ei_caldrt_verfrc_final_en
//bit 19,      reg_ei_caldrt_verfrc_retimflt_en
//bit 18:16,   reg_ei_caldrt_verftc_eithratemth
//bit 15,      reg_ei_caldrt_verfrc_retiming_en
//bit 14:12,   reg_ei_caldrt_verfrc_bothratemth
//bit 11:9,    reg_ei_caldrt_ver_thrd
//bit 8:4,     reg_ei_caldrt_addxla2list_drtmin
//bit 3:0,     reg_ei_caldrt_addxla2list_drtlimit
#define DI_EI_CTRL6                                ((0x171c  << 2) + 0xff000000)
//bit 31:24,   reg_ei_caldrt_abext_sad12thhig
//bit 23:16,   reg_ei_caldrt_abext_sad00thlow
//bit 15:8,    reg_ei_caldrt_abext_sad12thlow
//bit 6:4,     reg_ei_caldrt_abext_ratemth
//bit 2:0,     reg_ei_caldrt_abext_drtthrd
#define DI_EI_CTRL7                                ((0x171d  << 2) + 0xff000000)
//bit 29,      reg_ei_caldrt_xlanopeak_codien
//bit 28:24,   reg_ei_caldrt_xlanopeak_drtmax
//bit 23,      reg_ei_caldrt_xlanopeak_en
//bit 28:24,   reg_ei_caldrt_abext_monotrnd_alpha
//bit 28:24,   reg_ei_caldrt_abext_mononum12_thrd
//bit 28:24,   reg_ei_caldrt_abext_mononum00_thrd
//bit 28:24,   reg_ei_caldrt_abext_sad00rate
//bit 28:24,   reg_ei_caldrt_abext_sad12rate
//bit 28:24,   reg_ei_caldrt_abext_sad00thhig
#define DI_EI_CTRL8                                ((0x171e  << 2) + 0xff000000)
//bit 30:28,   reg_ei_assign_headtail_magin
//bit 26:24,   reg_ei_retime_lastcurpncnfltchk_mode
//bit 22:21,   reg_ei_retime_lastcurpncnfltchk_drtth
//bit 20,      reg_ei_caldrt_histchk_cnfid
//bit 19:16,   reg_ei_caldrt_histchk_thrd
//bit 15,      reg_ei_caldrt_histchk_abext
//bit 14,      reg_ei_caldrt_histchk_npen
//bit 13:11,   reg_ei_caldrt_amblike2_drtmg
//bit 10:8,    reg_ei_caldrt_amblike2_valmg
//bit 7:4,     reg_ei_caldrt_amblike2_alpha
//bit 3:0,     reg_ei_caldrt_amblike2_drtth
#define DI_EI_CTRL9                                ((0x171f  << 2) + 0xff000000)
//bit 31:28,   reg_ei_caldrt_hcnfcheck_frcvert_xla_th3
//bit 27,      reg_ei_caldrt_hcnfcheck_frcvert_xla_en
//bit 26:24,   reg_ei_caldrt_conf_drtth
//bit 23:20,   reg_ei_caldrt_conf_absdrtth
//bit 19:18,   reg_ei_caldrt_abcheck_mode1
//bit 17:16,   reg_ei_caldrt_abcheck_mode0
//bit 15:12,   reg_ei_caldrt_abcheck_drth1
//bit 11:8,    reg_ei_caldrt_abcheck_drth0
//bit 6:4,     reg_ei_caldrt_abpnchk1_th
//bit 1,       reg_ei_caldrt_abpnchk1_en
//bit 0,       reg_ei_caldrt_abpnchk0_en
// DEINTERLACE mode check.
#define DI_MC_REG0_X                               ((0x1720  << 2) + 0xff000000)
//bit 27:16,   mc_reg0_start_x
//bit 11:0,    mc_reg0_end_x
#define DI_MC_REG0_Y                               ((0x1721  << 2) + 0xff000000)
#define DI_MC_REG1_X                               ((0x1722  << 2) + 0xff000000)
#define DI_MC_REG1_Y                               ((0x1723  << 2) + 0xff000000)
#define DI_MC_REG2_X                               ((0x1724  << 2) + 0xff000000)
#define DI_MC_REG2_Y                               ((0x1725  << 2) + 0xff000000)
#define DI_MC_REG3_X                               ((0x1726  << 2) + 0xff000000)
#define DI_MC_REG3_Y                               ((0x1727  << 2) + 0xff000000)
#define DI_MC_REG4_X                               ((0x1728  << 2) + 0xff000000)
#define DI_MC_REG4_Y                               ((0x1729  << 2) + 0xff000000)
#define DI_MC_32LVL0                               ((0x172a  << 2) + 0xff000000)
//bit 31:24,   mc_reg2_32lvl
//bit 23:16,   mc_reg1_32lvl
//bit 15:8,    mc_reg0_32lvl
//bit 7:0,     field_32lvl
#define DI_MC_32LVL1                               ((0x172b  << 2) + 0xff000000)
//bit 15:8,    mc_reg3_32lvl
//bit 7:0,     mc_reg4_32lvl
#define DI_MC_22LVL0                               ((0x172c  << 2) + 0xff000000)
//bit 31:16,   mc_reg0_22lvl
//bit 15:0,    field_22lvl
#define DI_MC_22LVL1                               ((0x172d  << 2) + 0xff000000)
//bit 31:16,   mc_reg2_22lvl
//bit 15:0,    mc_reg1_22lvl
#define DI_MC_22LVL2                               ((0x172e  << 2) + 0xff000000)
//bit 31:16,   mc_reg4_22lvl
//bit 15:0,    mc_reg3_22lvl
#define DI_MC_CTRL                                 ((0x172f  << 2) + 0xff000000)
//bit 4,       mc_reg4_en
//bit 3,       mc_reg3_en
//bit 2,       mc_reg2_en
//bit 1,       mc_reg1_en
//bit 0,       mc_reg0_en
#define DI_INTR_CTRL                               ((0x1730  << 2) + 0xff000000)
#define DI_INFO_ADDR                               ((0x1731  << 2) + 0xff000000)
#define DI_INFO_DATA                               ((0x1732  << 2) + 0xff000000)
#define DI_PRE_HOLD                                ((0x1733  << 2) + 0xff000000)
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//     `define DET3D_MOTN_CFG                8'h34
//     //Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
//     //Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and Chroma:
//     //                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//     //Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//     //Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion Detection.
//
//     `define DET3D_CB_CFG                  8'h35
//     //Bit 7:4,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-horizontal or vertical combing detection.
//     //Bit 3:0,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for horizontal or vertical combing detection.
//
//     `define DET3D_SPLT_CFG                8'h36
//     //Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//     //                                      The smaller of this value, the easier of the split line detected.
//     //Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//     //                                      The smaller of this value, the more samples will be added to the estimation.
//
//     `define DET3D_HV_MUTE                 8'h37
//     //Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//     //Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//     //Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//     //Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//     //Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
//
//     `define DET3D_MAT_STA_P1M1            8'h38
//     //Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//     //Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//     //Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//     //Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
//
//     `define DET3D_MAT_STA_P1TH            8'h39
//     //Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (48)
//
//     `define DET3D_MAT_STA_M1TH            8'h3a
//     //Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//     //Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//     //Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (64)
//
//     `define DET3D_MAT_STA_RSFT            8'h3b
//     //Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//     //Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//     //                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//
//     `define DET3D_MAT_SYMTC_TH            8'h3c
//     //Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//     //Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//     //Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//     //Bit 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB or LR symmetric.
//
//     `define DET3D_RO_DET_CB_HOR           8'h3d
//     //Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
//
//     `define DET3D_RO_DET_CB_VER           8'h3e
//     //Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//     //Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
//
//     `define DET3D_RO_SPLT_HT              8'h3f
//     //Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal for top half picture
//     //Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position estimation for top half picture
//     //Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//
//     //// DET 3D REG DEFINE END ////
#define DI_MTN_1_CTRL1                             ((0x1740  << 2) + 0xff000000)
//bit 31,      mtn_1_en
//bit 30,      mtn_init
//bit 29,      di2nr_txt_en
//bit 28,      reserved
//bit 27:24,   mtn_def
//bit 23:16,   mtn_adp_yc
//bit 15:8,    mtn_adp_2c
//bit 7:0,     mtn_adp_2y
#define DI_MTN_1_CTRL2                             ((0x1741  << 2) + 0xff000000)
//bit 31:24,   mtn_ykinter
//bit 23:16,   mtn_ckinter
//bit 15:8,    mtn_ykintra
//bit  7:0,    mtn_ckintra
#define DI_MTN_1_CTRL3                             ((0x1742  << 2) + 0xff000000)
//bit 31:24,   mtn_tyrate
//bit 23:16,   mtn_tcrate
//bit 15: 8,   mtn_mxcmby
//bit  7: 0,   mtn_mxcmbc
#define DI_MTN_1_CTRL4                             ((0x1743  << 2) + 0xff000000)
//bit 31:24,   mtn_tcorey
//bit 23:16,   mtn_tcorec
//bit 15: 8,   mtn_minth
//bit  7: 0,   mtn_maxth
#define DI_MTN_1_CTRL5                             ((0x1744  << 2) + 0xff000000)
//bit 31:28,   mtn_m1b_extend
//bit 27:24,   mtn_m1b_errod
//bit 21:20,   mtn_mot_txt_mode
//bit 19:18,   mtn_replace_cbyy
//bit 17:16,   mtn_replace_ybyc
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
//// NR2 REG DEFINE BEGIN////
#define NR2_MET_NM_CTRL                            ((0x1745  << 2) + 0xff000000)
//Bit 28,	   reg_NM_reset	          Reset to the status of the Loop filter.
//Bit 27:24,   reg_NM_calc_length	  Length mode of the Noise measurement sample number for statistics.
//                                    0:  256 samples;    1: 512 samples;    2: 1024 samples;   ¡­X: 2^(8+x) samples
//Bit 23:20,   reg_NM_inc_step	      Loop filter input gain increase step.
//Bit 19:16,   reg_NM_dec_step	      Loop filter input gain decrease step.
//Bit 15:8,	   reg_NM_YHPmot_thrd	  Luma channel HP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 7:0,	   reg_NM_CHPmot_thrd	  Chroma channel HP portion motion for condition of pixels included in Chroma Noise measurement.
#define NR2_MET_NM_YCTRL                           ((0x1746  << 2) + 0xff000000)
//Bit 31:28,   reg_NM_YPLL_target	      Target rate of NM_Ynoise_thrd to mean of the Luma Noise
//Bit 27:24,   reg_NM_YLPmot_thrd	      Luma channel LP portion motion for condition of pixels included in Luma Noise measurement.
//Bit 23:16,   reg_NM_YHPmot_thrd_min	  Minimum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 15:8,	   reg_NM_YHPmot_thrd_max	  Maximum threshold for Luma channel HP portion motion to decide whether the pixel will be included in Luma noise measurement.
//Bit 7:0,	   reg_NM_Ylock_rate	      Rate to decide whether the Luma noise measurement is lock or not.
#define NR2_MET_NM_CCTRL                           ((0x1747  << 2) + 0xff000000)
//Bit 31:28,	reg_NM_CPLL_target	     Target rate of NM_Cnoise_thrd to mean of the Chroma Noise
//Bit 27:24,	reg_NM_CLPmot_thrd	     Chroma channel LP portion motion for condition of pixels included in Chroma Noise measurement.
//Bit 23:16,	reg_NM_CHPmot_thrd_min	 Minimum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 15:8,	    reg_NM_CHPmot_thrd_max	 Maximum threshold for Chroma channel HP portion motion to decide whether the pixel will be included in Chroma noise measurement.
//Bit 7:0,	    reg_NM_Clock_rate	     Rate to decide whether the Chroma noise measurement is lock or not;
#define NR2_MET_NM_TNR                             ((0x1748  << 2) + 0xff000000)
//Bit 25,	    ro_NM_TNR_Ylock	         Read-only register to tell ifLuma channel noise measurement is locked or not.
//Bit 24,	    ro_NM_TNR_Clock	         Read-only register to tell if Chroma channel noise measurement is locked or not.
//Bit 23:12,	ro_NM_TNR_Ylevel	     Read-only register to give Luma channel noise level. It was 16x of pixel difference in 8 bits of YHPmot.
//Bit 11:0,	ro_NM_TNR_Clevel	         Read-only register to give Chroma channel noise level. It was 16x of pixel difference in 8 bits of CHPmot.
#define NR2_MET_NMFRM_TNR_YLEV                     ((0x1749  << 2) + 0xff000000)
//Bit 28:0,	ro_NMFrm_TNR_Ylevel	         Frame based Read-only register to give Luma channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_YCNT                     ((0x174a  << 2) + 0xff000000)
//Bit 23:0,	ro_NMFrm_TNR_Ycount	         Number ofLuma channel pixels included in Frame/Field based noise level measurement.
#define NR2_MET_NMFRM_TNR_CLEV                     ((0x174b  << 2) + 0xff000000)
//Bit 28:0,	ro_NMFrm_TNR_Clevel	         Frame based Read-only register to give Chroma channel noise level within one frame/field.
#define NR2_MET_NMFRM_TNR_CCNT                     ((0x174c  << 2) + 0xff000000)
//Bit 23:0,	ro_NMFrm_TNR_Ccount	         Number of Chroma channel pixels included in Frame/Field based noise level measurement.
#define NR2_3DEN_MODE                              ((0x174d  << 2) + 0xff000000)
//Bit 6:4,	Blend_3dnr_en_r
//Bit 2:0,	Blend_3dnr_en_l
//   `define NR2_IIR_CTRL                8'h4e
//   //Bit 15:14, reg_LP_IIR_8bit_mode	LP IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 13:12, reg_LP_IIR_mute_mode	Mode for the LP IIR mute,
//   //Bit 11:8,	 reg_LP_IIR_mute_thrd	Threshold of LP IIR mute to avoid ghost:
//   //Bit 7:6,	 reg_HP_IIR_8bit_mode	IIR membitwidth mode:0: 10bits will be store in memory;1: 9bits will be store in memory;
//   //                                  2: 8bits will be store in memory;3: 7bits will be store in memory;
//   //Bit 5:4,	reg_HP_IIR_mute_mode	Mode for theLP IIR mute
//   //Bit 3:0,	reg_HP_IIR_mute_thrd	Threshold of HP IIR mute to avoid ghost
//   //
#define NR2_SW_EN                                  ((0x174f  << 2) + 0xff000000)
//Bit 17:8,	Clk_gate_ctrl
//Bit 7,	Cfr_enable
//Bit 5,	Det3d_en
//Bit 4,	Nr2_proc_en
//Bit 0,	Nr2_sw_en
#define NR2_FRM_SIZE                               ((0x1750  << 2) + 0xff000000)
//Bit 27:16,  Frm_heigh	Frame/field height
//Bit 11: 0,  Frm_width	Frame/field width
//   `define NR2_SNR_SAD_CFG             8'h51
//   //Bit 12,	reg_MATNR_SNR_SAD_CenRPL	U1, Enable signal for Current pixel position SAD to be replaced by SAD_min.0: do not replace Current pixel position SAD by SAD_min;1: do replacements
//   //Bit 11:8,	reg_MATNR_SNR_SAD_coring	Coring value of the intra-frame SAD. sum = (sum - reg_MATNR_SNR_SAD_coring);sum = (sum<0) ? 0: (sum>255)? 255: sum;
//   //Bit 6:5,	reg_MATNR_SNR_SAD_WinMod	Unsigned, Intra-frame SAD matching window mode:0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//   //Bit 4:0,	Sad_coef_num	            Sad coeffient
//
//   `define NR2_MATNR_SNR_OS            8'h52
//   //Bit 7:4,	reg_MATNR_SNR_COS	    SNR Filter overshoot control margin for UV channel (X2 to u10 scale)
//   //Bit 3:0,	reg_MATNR_SNR_YOS	    SNR Filter overshoot control margin for luma channel (X2 to u10 scale)
//
//   `define NR2_MATNR_SNR_NRM_CFG       8'h53
//   //Bit 23:16,	reg_MATNR_SNR_NRM_ofst	Edge based SNR boosting normalization offset to SAD_max ;
//   //Bit 15:8,	    reg_MATNR_SNR_NRM_max	Edge based SNR boosting normalization Max value
//   //Bit 7:0,	    reg_MATNR_SNR_NRM_min	Edge based SNR boosting normalization Min value
//
//   `define NR2_MATNR_SNR_NRM_GAIN      8'h54
//   //Bit 15:8,	reg_MATNR_SNR_NRM_Cgain	Edge based SNR boosting normalization Gain for Chrm channel (norm 32 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_NRM_Ygain	Edge based SNR boosting normalization Gain for Luma channel (norm 32 as 1)
//
//   `define NR2_MATNR_SNR_LPF_CFG       8'h55
//   //Bit 23:16,reg_MATNR_SNRLPF_SADmaxTH	U8,  Threshold to SADmax to use TNRLPF to replace SNRLPF. i.e.if (SAD_max<reg_MATNR_SNRLPF_SADmaxTH) SNRLPF_yuv[k] = TNRLPF_yuv[k];
//   //Bit 13:11,reg_MATNR_SNRLPF_Cmode	    LPF based SNR filtering mode on CHRM channel:
//   //                                      0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;  5 : CurLPF3x3_yuv[];  6: CurLPF3o3_yuv[]  7: CurLPF3x5_yuv[]
//   //Bit 10:8,	reg_MATNR_SNRLPF_Ymode	    LPF based SNR filtering mode on LUMA channel:
//   //                                      0: gradient LPF //Bit [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8;3: gradient LPF [5 4 4 3]/16;
//   //                                      4: TNRLPF;               5 : CurLPF3x3_yuv[];       6: CurLPF3o3_yuv[]         7: CurLPF3x5_yuv[]
//   //Bit 7:4,	reg_MATNR_SNRLPF_SADmin3TH	Offset threshold to SAD_min to Discard SAD_min3 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//   //Bit 3:0,	reg_MATNR_SNRLPF_SADmin2TH	Offset threshold to SAD_min to Discard SAD_min2 corresponding pixel in LPF SNR filtering. (X8 to u8 scale)
//
//   `define NR2_MATNR_SNR_USF_GAIN      8'h56
//   //Bit 15:8,	reg_MATNR_SNR_USF_Cgain	    Un-sharp (HP) compensate back Chrm portion gain, (norm 64 as 1)
//   //Bit 7:0,	reg_MATNR_SNR_USF_Ygain	    Un-sharp (HP) compensate back Luma portion gain, (norm 64 as 1)
//
//   `define NR2_MATNR_SNR_EDGE2B        8'h57
//   //Bit 15:8,	reg_MATNR_SNR_Edge2Beta_ofst	U8,  Offset for Beta based on Edge.
//   //Bit 7:0,	reg_MATNR_SNR_Edge2Beta_gain	U8.  Gain to SAD_min for Beta based on Edge. (norm 16 as 1)
//
//   `define NR2_MATNR_BETA_EGAIN        8'h58
//   //Bit 15:8,	reg_MATNR_CBeta_Egain	U8,  Gain to Edge based Beta for Chrm channel. (normalized to 32 as 1)
//   //Bit 7:0,	reg_MATNR_YBeta_Egain	U8,  Gain to Edge based Beta for Luma channel. (normalized to 32 as 1)
//
//   `define NR2_MATNR_BETA_BRT          8'h59
//   //Bit 31:28,	reg_MATNR_beta_BRT_limt_hi	U4,  Beta adjustment based on Brightness high side Limit. (X16 to u8 scale)
//   //Bit 27:24,	reg_MATNR_beta_BRT_slop_hi	U4,  Beta adjustment based on Brightness high side slope. Normalized to 16 as 1
//   //Bit 23:16,	reg_MATNR_beta_BRT_thrd_hi	U8,  Beta adjustment based on Brightness high threshold.(u8 scale)
//   //Bit 15:12,	reg_MATNR_beta_BRT_limt_lo	U4,  Beta adjustment based on Brightness low side Limit. (X16 to u8 scale)
//   //Bit 11:8,	    reg_MATNR_beta_BRT_slop_lo	U4,  Beta adjustment based on Brightness low side slope. Normalized to 16 as 1
//   //Bit 7:0,	    reg_MATNR_beta_BRT_thrd_lo	U8,  Beta adjustment based on Brightness low threshold.(u8 scale)
//   `define NR2_MATNR_XBETA_CFG         8'h5a
//   //Bit 19:18,	reg_MATNR_CBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Chrm channel;
//   //Bit 17:16,	reg_MATNR_YBeta_use_mode	U2,  Beta options (mux) from beta_motion and beta_edge for Luma channel;
//   //Bit 15: 8,	reg_MATNR_CBeta_Ofst	    U8,  Offset to Beta for Chrm channel.(after beta_edge and beta_motion mux)
//   //Bit  7: 0,	reg_MATNR_YBeta_Ofst	    U8,  Offset to Beta for Luma channel.(after beta_edge and beta_motion mux)
//   `define NR2_MATNR_YBETA_SCL         8'h5b
//   //Bit 31:24,	reg_MATNR_YBeta_scale_min	U8,  Final step Beta scale low limit for Luma channel;
//   //Bit 23:16,	reg_MATNR_YBeta_scale_max	U8,  Final step Beta scale high limit for Luma channe;
//   //Bit 15: 8,	reg_MATNR_YBeta_scale_gain	U8,  Final step Beta scale Gain for Luma channel (normalized 32 to 1);
//   //Bit 7 : 0,	reg_MATNR_YBeta_scale_ofst	S8,  Final step Beta scale offset for Luma channel ;
//   `define NR2_MATNR_CBETA_SCL         8'h5c
//   //Bit 31:24,	reg_MATNR_CBeta_scale_min	Final step Beta scale low limit for Chrm channel.Similar to Y
//   //Bit 23:16,	reg_MATNR_CBeta_scale_max	U8,  Final step Beta scale high limit for Chrm channel.Similar to Y
//   //Bit 15: 8,	reg_MATNR_CBeta_scale_gain	U8,  Final step Beta scale Gain for Chrm channel Similar to Y
//   //Bit  7: 0,	reg_MATNR_CBeta_scale_ofst	S8,  Final step Beta scale offset for Chrm channel Similar to Y
//   `define NR2_SNR_MASK                8'h5d
//   //Bit 20:0, 	SAD_MSK	                    Valid signal in the 3x7 SAD surface
//   `define NR2_SAD2NORM_LUT0           8'h5e
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_3	SAD convert normal LUT node 3
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_2	SAD convert normal LUT node 2
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_1	SAD convert normal LUT node 1
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_0	SAD convert normal LUT node 0
//   `define NR2_SAD2NORM_LUT1           8'h5f
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_7	SAD convert normal LUT node 7
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_6	SAD convert normal LUT node 6
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_5	SAD convert normal LUT node 5
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_4	SAD convert normal LUT node 4
//   `define NR2_SAD2NORM_LUT2           8'h60
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_11	SAD convert normal LUT node 11
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_10	SAD convert normal LUT node 10
//   //Bit 15: 8,	reg_MATNR_SAD2Norm_LUT_9	SAD convert normal LUT node 9
//   //Bit  7: 0,	reg_MATNR_SAD2Norm_LUT_8	SAD convert normal LUT node 8
//   `define NR2_SAD2NORM_LUT3           8'h61
//   //Bit 31:24,	reg_MATNR_SAD2Norm_LUT_15	SAD convert normal LUT node 15
//   //Bit 23:16,	reg_MATNR_SAD2Norm_LUT_14	SAD convert normal LUT node 14
//   //Bit 15:8,	reg_MATNR_SAD2Norm_LUT_13	SAD convert normal LUT node 13
//   //Bit 7:0,	reg_MATNR_SAD2Norm_LUT_12	SAD convert normal LUT node 12
//   `define NR2_EDGE2BETA_LUT0          8'h62
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_3	Edge convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_2	Edge convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_1	Edge convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_0	Edge convert beta LUT node 0
//   `define NR2_EDGE2BETA_LUT1          8'h63
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_7	Edge convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_6	Edge convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_5	Edge convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_4	Edge convert beta LUT node 4
//   `define NR2_EDGE2BETA_LUT2          8'h64
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_11	Edge convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_10	Edge convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_9	Edge convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_8	Edge convert beta LUT node 8
//   `define NR2_EDGE2BETA_LUT3          8'h65
//   //Bit 31:24,	reg_MATNR_Edge2Beta_LUT_15	Edge convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Edge2Beta_LUT_14	Edge convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Edge2Beta_LUT_13	Edge convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Edge2Beta_LUT_12	Edge convert beta LUT node 12
//   `define NR2_MOTION2BETA_LUT0        8'h66
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_3	Motion convert beta LUT node 3
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_2	Motion convert beta LUT node 2
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_1	Motion convert beta LUT node 1
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_0	Motion convert beta LUT node 0
//   `define NR2_MOTION2BETA_LUT1        8'h67
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_7	Motion convert beta LUT node 7
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_6	Motion convert beta LUT node 6
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_5	Motion convert beta LUT node 5
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_4	Motion convert beta LUT node 4
//   `define NR2_MOTION2BETA_LUT2        8'h68
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_11	Motion convert beta LUT node 11
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_10	Motion convert beta LUT node 10
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_9	Motion convert beta LUT node 9
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_8	Motion convert beta LUT node 8
//   `define NR2_MOTION2BETA_LUT3        8'h69
//   //Bit 31:24,	reg_MATNR_Mot2Beta_LUT_15	Motion convert beta LUT node 15
//   //Bit 23:16,	reg_MATNR_Mot2Beta_LUT_14	Motion convert beta LUT node 14
//   //Bit 15: 8,	reg_MATNR_Mot2Beta_LUT_13	Motion convert beta LUT node 13
//   //Bit  7: 0,	reg_MATNR_Mot2Beta_LUT_12	Motion convert beta LUT node 12
//    `define NR2_MATNR_MTN_CRTL          8'h6a
//    //Bit 25:24,	reg_MATNR_Vmtn_use_mode	    Motion_yuvV channel motion selection mode:0: Vmot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 21:20,	reg_MATNR_Umtn_use_mode	    Motion_yuvU channel motion selection mode:0:Umot;1:Ymot/2 + (Umot+Vmot)/4; 2:Ymot/2 + max(Umot,Vmot)/2; 3: max(Ymot,Umot, Vmot)
//    //Bit 17:16,	reg_MATNR_Ymtn_use_mode	    Motion_yuvLuma channel motion selection mode:0:  Ymot, 1: Ymot/2 + (Umot+Vmot)/4; 2: Ymot/2 + max(Umot,Vmot)/2; 3:  max(Ymot,Umot, Vmot)
//    //Bit 13:12,	reg_MATNR_mtn_txt_mode	    Texture detection mode for adaptive coring of HP motion
//    //Bit  9: 8,	reg_MATNR_mtn_cor_mode	    Coring selection mode based on texture detection;
//    //Bit  6: 4,	reg_MATNR_mtn_hpf_mode	    video mode of current and previous frame/field for MotHPF_yuv[k] calculation:
//    //Bit  2: 0,	reg_MATNR_mtn_lpf_mode	    LPF video mode of current and previous frame/field for MotLPF_yuv[k] calculation:
//    `define NR2_MATNR_MTN_CRTL2         8'h6b
//    //Bit 18:16,	reg_MATNR_iir_BS_Ymode	    IIR TNR filter Band split filter mode for Luma LPF result generation (Cur and Prev);
//    //Bit 15: 8,	reg_MATNR_mtnb_alpLP_Cgain	Scale of motion_brthp_uv to motion_brtlp_uv, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_alpLP_Ygain	Scale of motion_brthp_y to motion_brtlp_y, normalized to 32 as 1
//    `define NR2_MATNR_MTN_COR           8'h6c
//    //Bit 15:12,	reg_MATNR_mtn_cor_Cofst	    Coring Offset for Chroma Motion.
//    //Bit 11: 8,	reg_MATNR_mtn_cor_Cgain	    Gain to texture based coring for Chroma Motion. Normalized to 16 as 1
//    //Bit  7: 4,	reg_MATNR_mtn_cor_Yofst	    Coring Offset for Luma Motion.
//    //Bit  3: 0,	reg_MATNR_mtn_cor_Ygain	    Gain to texture based coring for Luma Motion. Normalized to 16 as 1
//    `define NR2_MATNR_MTN_GAIN          8'h6d
//    //Bit 31:24,	reg_MATNR_mtn_hp_Cgain	Gain to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//    //Bit 23:16,	reg_MATNR_mtn_hp_Ygain	Gain to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//    //Bit 15: 8,	reg_MATNR_mtn_lp_Cgain	Gain to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//    //Bit  7: 0,	reg_MATNR_mtn_lp_Ygain	Gain to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
//    `define NR2_MATNR_DEGHOST           8'h6e
//    //Bit 8,	reg_MATNR_DeGhost_En	Enable signal for DeGhost function:0: disable; 1: enable
//    //Bit 7:4,	reg_MATNR_DeGhost_COS	DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//    //Bit 3:0,	reg_MATNR_DeGhost_YOS	DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
//
//    `define NR2_MATNR_ALPHALP_LUT0      8'h6f
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_3	    Matnr low-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_2	    Matnr low-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_1	    Matnr low-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_0	    Matnr low-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHALP_LUT1      8'h70
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_7	    Matnr low-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_6	    Matnr low-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_5	    Matnr low-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_4	    Matnr low-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHALP_LUT2      8'h71
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_11	Matnr low-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_10	Matnr low-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_9	    Matnr low-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_8	    Matnr low-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHALP_LUT3      8'h72
//    //Bit 31:24,	reg_MATNR_AlphaLP_LUT_15	Matnr low-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaLP_LUT_14	Matnr low-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaLP_LUT_13	Matnr low-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaLP_LUT_12	Matnr low-pass filter alpha LUT node 12
//    `define NR2_MATNR_ALPHAHP_LUT0      8'h73
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_3	    Matnr high-pass filter alpha LUT node 3
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_2	    Matnr high-pass filter alpha LUT node 2
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_1	    Matnr high-pass filter alpha LUT node 1
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_0	    Matnr high-pass filter alpha LUT node 0
//    `define NR2_MATNR_ALPHAHP_LUT1      8'h74
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_7	    Matnr high-pass filter alpha LUT node 7
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_6	    Matnr high-pass filter alpha LUT node 6
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_5	    Matnr high-pass filter alpha LUT node 5
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_4	    Matnr high-pass filter alpha LUT node 4
//    `define NR2_MATNR_ALPHAHP_LUT2      8'h75
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_11	Matnr high-pass filter alpha LUT node 11
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_10	Matnr high-pass filter alpha LUT node 10
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_9	    Matnr high-pass filter alpha LUT node 9
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_8	    Matnr high-pass filter alpha LUT node 8
//    `define NR2_MATNR_ALPHAHP_LUT3      8'h76
//    //Bit 31:24,	reg_MATNR_AlphaHP_LUT_15	Matnr high-pass filter alpha LUT node 15
//    //Bit 23:16,	reg_MATNR_AlphaHP_LUT_14	Matnr high-pass filter alpha LUT node 14
//    //Bit 15: 8,	reg_MATNR_AlphaHP_LUT_13	Matnr high-pass filter alpha LUT node 13
//    //Bit  7: 0,	reg_MATNR_AlphaHP_LUT_12	Matnr high-pass filter alpha LUT node 12
//
//    `define NR2_MATNR_MTNB_BRT          8'h77
//    //Bit 31:28,	reg_MATNR_mtnb_BRT_limt_hi	Motion adjustment based on Brightness high side Limit. (X16 to u8 scale)
//    //Bit 27:24,	reg_MATNR_mtnb_BRT_slop_hi	Motion adjustment based on Brightness high side slope. Normalized to 16 as 1
//    //Bit 23:16,	reg_MATNR_mtnb_BRT_thrd_hi	Motion adjustment based on Brightness high threshold.(u8 scale)
//    //Bit 15:12,	reg_MATNR_mtnb_BRT_limt_lo	Motion adjustment based on Brightness low side Limit. (X16 to u8 scale)
//    //Bit 11: 8,	reg_MATNR_mtnb_BRT_slop_lo	Motion adjustment based on Brightness low side slope. Normalized to 16 as 1
//    //Bit  7: 0,	reg_MATNR_mtnb_BRT_thrd_lo	Motion adjustment based on Brightness low threshold.(u8 scale)
// 0x51 - 0x69 | 0x4e | 0x6a - 0x77
//
// Reading file:  vpu_nr2_regs.h
//
// synopsys translate_off
// synopsys translate_on
//========== nr2_snr_regs register begin ==========//
#define NR2_SNR_SAD_CFG                            ((0x1751  << 2) + 0xff000000)
//Bit 31:13        reserved
//Bit 12           reg_matnr_snr_sad_cenrpl       // unsigned , default = 1
//Bit 11: 8        reg_matnr_snr_sad_coring       // unsigned , default = 3
//Bit  7            reserved
//Bit  6: 5        reg_matnr_snr_sad_winmod       // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
//Bit  4: 0        sad_coef_num                      // unsigned , default = 1     0: 1x1; 1: [1 1 1] 2: [1 2 1]; 3: [1 2 2 2 1];
#define NR2_MATNR_SNR_OS                           ((0x1752  << 2) + 0xff000000)
//Bit 31: 8        reserved
//Bit  7: 4        reg_matnr_snr_cos              // unsigned , default = 8
//Bit  3: 0        reg_matnr_snr_yos              // unsigned , default = 13
#define NR2_MATNR_SNR_NRM_CFG                      ((0x1753  << 2) + 0xff000000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snr_nrm_ofst         // signed , default = 64
//Bit 15: 8        reg_matnr_snr_nrm_max          // unsigned , default = 255
//Bit  7: 0        reg_matnr_snr_nrm_min          // unsigned , default = 0
#define NR2_MATNR_SNR_NRM_GAIN                     ((0x1754  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_nrm_cgain        // unsigned , default = 0     norm 32
//Bit  7: 0        reg_matnr_snr_nrm_ygain        // unsigned , default = 32    norm 32
#define NR2_MATNR_SNR_LPF_CFG                      ((0x1755  << 2) + 0xff000000)
//Bit 31:24        reserved
//Bit 23:16        reg_matnr_snrlpf_sadmaxth      // unsigned , default = 12
//Bit 15:14        reserved
//Bit 13:11        reg_matnr_snrlpf_cmode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit 10: 8        reg_matnr_snrlpf_ymode         // unsigned , default = 2     0: gradient LPF [1 1]/2, 1: gradient LPF [2 1 1]/4; 2: gradient LPF [3 3 2]/8; 3: gradient LPF [5 5 4 3]/16;
//Bit  7: 4        reg_matnr_snrlpf_sadmin3th     // unsigned , default = 6     X8
//Bit  3: 0        reg_matnr_snrlpf_sadmin2th     // unsigned , default = 4     X8
#define NR2_MATNR_SNR_USF_GAIN                     ((0x1756  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_usf_cgain        // unsigned , default = 0     norm 64
//Bit  7: 0        reg_matnr_snr_usf_ygain        // unsigned , default = 0     norm 64
#define NR2_MATNR_SNR_EDGE2B                       ((0x1757  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_snr_edge2beta_ofst   // unsigned , default = 128
//Bit  7: 0        reg_matnr_snr_edge2beta_gain   // unsigned , default = 16
#define NR2_MATNR_BETA_EGAIN                       ((0x1758  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15: 8        reg_matnr_cbeta_egain          // unsigned , default = 32    normalized to 32
//Bit  7: 0        reg_matnr_ybeta_egain          // unsigned , default = 32    normalized to 32
#define NR2_MATNR_BETA_BRT                         ((0x1759  << 2) + 0xff000000)
//Bit 31:28        reg_matnr_beta_brt_limt_hi     // unsigned , default = 0
//Bit 27:24        reg_matnr_beta_brt_slop_hi     // unsigned , default = 0
//Bit 23:16        reg_matnr_beta_brt_thrd_hi     // unsigned , default = 160
//Bit 15:12        reg_matnr_beta_brt_limt_lo     // unsigned , default = 6
//Bit 11: 8        reg_matnr_beta_brt_slop_lo     // unsigned , default = 6
//Bit  7: 0        reg_matnr_beta_brt_thrd_lo     // unsigned , default = 100
#define NR2_MATNR_XBETA_CFG                        ((0x175a  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_cbeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2
//Bit 17:16        reg_matnr_ybeta_use_mode       // unsigned , default = 0     0: beta_motion; 1: beta_edge; 2: min(beta_mot,beta_edge); 3: (beta_mot + beta_edge)/2;
//Bit 15: 8        reg_matnr_cbeta_ofst           // unsigned , default = 0
//Bit  7: 0        reg_matnr_ybeta_ofst           // unsigned , default = 0
#define NR2_MATNR_YBETA_SCL                        ((0x175b  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_ybeta_scale_min      // unsigned , default = 60
//Bit 23:16        reg_matnr_ybeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_ybeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_ybeta_scale_ofst     // signed , default = 0
#define NR2_MATNR_CBETA_SCL                        ((0x175c  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_cbeta_scale_min      // unsigned , default = 0
//Bit 23:16        reg_matnr_cbeta_scale_max      // unsigned , default = 255
//Bit 15: 8        reg_matnr_cbeta_scale_gain     // unsigned , default = 32    normalized 32 to 1.0
//Bit  7: 0        reg_matnr_cbeta_scale_ofst     // signed , default = 0
#define NR2_SNR_MASK                               ((0x175d  << 2) + 0xff000000)
//Bit 31:21        reserved
//Bit 20: 0        sad_msk                        // unsigned , default = 0x0f9f3e
#define NR2_SAD2NORM_LUT0                          ((0x175e  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_sad2norm_lut3      // unsigned , default = 114
//Bit 23:16        reg_matnr_sad2norm_lut2      // unsigned , default = 146
//Bit 15: 8        reg_matnr_sad2norm_lut1      // unsigned , default = 171
//Bit  7: 0        reg_matnr_sad2norm_lut0      // unsigned , default = 205
#define NR2_SAD2NORM_LUT1                          ((0x175f  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_sad2norm_lut7      // unsigned , default = 28
//Bit 23:16        reg_matnr_sad2norm_lut6      // unsigned , default = 35
//Bit 15: 8        reg_matnr_sad2norm_lut5      // unsigned , default = 49
//Bit  7: 0        reg_matnr_sad2norm_lut4      // unsigned , default = 79
#define NR2_SAD2NORM_LUT2                          ((0x1760  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_sad2norm_lut11     // unsigned , default = 15
//Bit 23:16        reg_matnr_sad2norm_lut10     // unsigned , default = 17
//Bit 15: 8        reg_matnr_sad2norm_lut9      // unsigned , default = 19
//Bit  7: 0        reg_matnr_sad2norm_lut8      // unsigned , default = 23
#define NR2_SAD2NORM_LUT3                          ((0x1761  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_sad2norm_lut15     // unsigned , default = 8
//Bit 23:16        reg_matnr_sad2norm_lut14     // unsigned , default = 9
//Bit 15: 8        reg_matnr_sad2norm_lut13     // unsigned , default = 10
//Bit  7: 0        reg_matnr_sad2norm_lut12     // unsigned , default = 12
#define NR2_EDGE2BETA_LUT0                         ((0x1762  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_edge2beta_lut3    // unsigned , default = 128
//Bit 23:16        reg_matnr_edge2beta_lut2    // unsigned , default = 160
//Bit 15: 8        reg_matnr_edge2beta_lut1    // unsigned , default = 224
//Bit  7: 0        reg_matnr_edge2beta_lut0    // unsigned , default = 255
#define NR2_EDGE2BETA_LUT1                         ((0x1763  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_edge2beta_lut7    // unsigned , default = 4
//Bit 23:16        reg_matnr_edge2beta_lut6    // unsigned , default = 16
//Bit 15: 8        reg_matnr_edge2beta_lut5    // unsigned , default = 32
//Bit  7: 0        reg_matnr_edge2beta_lut4    // unsigned , default = 80
#define NR2_EDGE2BETA_LUT2                         ((0x1764  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_edge2beta_lut11    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut10    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut9    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut8    // unsigned , default = 2
#define NR2_EDGE2BETA_LUT3                         ((0x1765  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_edge2beta_lut15    // unsigned , default = 0
//Bit 23:16        reg_matnr_edge2beta_lut14    // unsigned , default = 0
//Bit 15: 8        reg_matnr_edge2beta_lut13    // unsigned , default = 0
//Bit  7: 0        reg_matnr_edge2beta_lut12    // unsigned , default = 0
#define NR2_MOTION2BETA_LUT0                       ((0x1766  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_mot2beta_lut3     // unsigned , default = 32
//Bit 23:16        reg_matnr_mot2beta_lut2     // unsigned , default = 16
//Bit 15: 8        reg_matnr_mot2beta_lut1     // unsigned , default = 4
//Bit  7: 0        reg_matnr_mot2beta_lut0     // unsigned , default = 0
#define NR2_MOTION2BETA_LUT1                       ((0x1767  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_mot2beta_lut7     // unsigned , default = 196
//Bit 23:16        reg_matnr_mot2beta_lut6     // unsigned , default = 128
//Bit 15: 8        reg_matnr_mot2beta_lut5     // unsigned , default = 64
//Bit  7: 0        reg_matnr_mot2beta_lut4     // unsigned , default = 48
#define NR2_MOTION2BETA_LUT2                       ((0x1768  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_mot2beta_lut11     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut10     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut9     // unsigned , default = 240
//Bit  7: 0        reg_matnr_mot2beta_lut8     // unsigned , default = 224
#define NR2_MOTION2BETA_LUT3                       ((0x1769  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_mot2beta_lut15     // unsigned , default = 255
//Bit 23:16        reg_matnr_mot2beta_lut14     // unsigned , default = 255
//Bit 15: 8        reg_matnr_mot2beta_lut13     // unsigned , default = 255
//Bit  7: 0        reg_matnr_mot2beta_lut12     // unsigned , default = 255
//========== nr2_snr_regs register end ==========//
//========== nr2_tnr_regs register begin ==========//
#define NR2_IIR_CTRL                               ((0x174e  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15:14        reg_lp_iir_8bit_mode      // unsigned , default = 0  10bits; 1: 9bits; 2: 8bits 3: 7bits
//Bit 13:12        reg_hp_iir_mute_mode      // unsigned , default = 0
//Bit 11: 8        reg_hp_iir_mute_thrd      // unsigned , default = 0
//Bit  7: 6        reg_hp_iir_8bit_mode      // unsigned , default = 0
//Bit  5: 4        reg_lp_iir_mute_mode      // unsigned , default = 0
//Bit  3: 0        reg_lp_iir_mute_thrd      // unsigned , default = 0
#define NR2_MATNR_MTN_CRTL                         ((0x176a  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19:18        reg_matnr_vmtn_use_mode   // unsigned , default = 0  0- Vmot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 17:16        reg_matnr_umtn_use_mode   // unsigned , default = 0  0- Umot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 15:14        reg_matnr_ymtn_use_mode   // unsigned , default = 0  0- Ymot, 1- Ymot/2 + (Umot+Vmot)/4; 2- Ymot/2 + max(Umot,Vmot)/2; 3- max(Ymot,Umot, Vmot)
//Bit 13:12        reg_matnr_mtn_txt_mode    // unsigned , default = 1
//Bit 11            reserved
//Bit 10: 8        reg_matnr_mtn_cor_mode    // unsigned , default = 1  changes)
//Bit  7: 4        reg_matnr_mtn_hpf_mode    // unsigned , default = 8  extend to u4 for nr4, 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6:3x3 SAD, 7: 5x3 SAD, 8-15: drt adaptive
//Bit  3            reserved
//Bit  2: 0        reg_matnr_mtn_lpf_mode    // unsigned , default = 6  0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5, 6,7: drt adaptive
#define NR2_MATNR_MTN_CRTL2                        ((0x176b  << 2) + 0xff000000)
//Bit 31:19        reserved
//Bit 18:16        reg_matnr_iir_bs_ymode      // unsigned , default = 6  LPF~~ 0- 1x1; 1: 1x3; 2: 1x5; 3: 3x3; 4: 3o3; 5: 3x5; 6/7: 0
//Bit 15: 8        reg_matnr_mtnb_alplp_cgain  // unsigned , default = 64  to 32
//Bit  7: 0        reg_matnr_mtnb_alplp_ygain  // unsigned , default = 64  to 32
#define NR2_MATNR_MTN_COR                          ((0x176c  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15:12        reg_matnr_mtn_cor_cofst   // unsigned , default = 3  Offset for Chroma Motion.
//Bit 11: 8        reg_matnr_mtn_cor_cgain   // unsigned , default = 3  to texture based coring for Chroma Motion. Normalized to 16 as 1
//Bit  7: 4        reg_matnr_mtn_cor_yofst   // unsigned , default = 3  Offset for Luma Motion.
//Bit  3: 0        reg_matnr_mtn_cor_ygain   // unsigned , default = 3  to texture based coring for Luma Motion. Normalized to 16 as 1
#define NR2_MATNR_MTN_GAIN                         ((0x176d  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_mtn_hp_cgain    // unsigned , default = 64  to MotHPF_yuv[k] Chrm channel for motion calculation, normalized to 64 as 1
//Bit 23:16        reg_matnr_mtn_hp_ygain    // unsigned , default = 64  to MotHPF_yuv[k] Luma channel for motion calculation, normalized to 64 as 1
//Bit 15: 8        reg_matnr_mtn_lp_cgain    // unsigned , default = 64  to MotLPF_yuv[k] Chrm channel for motion calculation, normalized to 32 as 1
//Bit  7: 0        reg_matnr_mtn_lp_ygain    // unsigned , default = 64  to MotLPF_yuv[k] Luma channel for motion calculation, normalized to 32 as 1
#define NR2_MATNR_DEGHOST                          ((0x176e  << 2) + 0xff000000)
//Bit 31            reserved
//Bit 30:28        reg_matnr_deghost_mode    // unsigned , default = 0  0:old_deghost; 1:soft_denoise & strong_deghost; 2:strong_denoise & soft_deghost; 3:strong_denoise & strong_deghost
//Bit 27:25        reserved
//Bit 24:20        reg_matnr_deghost_ygain   // unsigned , default = 4
//Bit 19:17        reserved
//Bit 16:12        reg_matnr_deghost_cgain   // unsigned , default = 4
//Bit 11: 9        reserved
//Bit  8           reg_matnr_deghost_en      // unsigned , default = 1  0: disable; 1: enable Enable signal for DeGhost function:0: disable; 1: enable
//Bit  7: 4        reg_matnr_deghost_cos     // unsigned , default = 3  DeGhost Overshoot margin for UV channel, (X2 to u10 scale)
//Bit  3: 0        reg_matnr_deghost_yos     // unsigned , default = 3  DeGhost Overshoot margin for Luma channel, (X2 to u10 scale)
#define NR2_MATNR_ALPHALP_LUT0                     ((0x176f  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphalp_lut3    // unsigned , default = 64  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut2    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut1    // unsigned , default = 128  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut0    // unsigned , default = 128  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT1                     ((0x1770  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphalp_lut7    // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut6    // unsigned , default = 128  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut5    // unsigned , default = 80  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut4    // unsigned , default = 64  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT2                     ((0x1771  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphalp_lut11   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut10   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut9    // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut8    // unsigned , default = 255  low-pass filter alpha LUT
#define NR2_MATNR_ALPHALP_LUT3                     ((0x1772  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphalp_lut15   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphalp_lut14   // unsigned , default = 255  low-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphalp_lut13   // unsigned , default = 255  low-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphalp_lut12   // unsigned , default = 255  low-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT0                     ((0x1773  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphahp_lut3    // unsigned , default = 64  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut2    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut1    // unsigned , default = 128  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut0    // unsigned , default = 128  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT1                     ((0x1774  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphahp_lut7    // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut6    // unsigned , default = 128  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut5    // unsigned , default = 80  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut4    // unsigned , default = 64  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT2                     ((0x1775  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphahp_lut11   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut10   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut9    // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut8    // unsigned , default = 255  high-pass filter alpha LUT
#define NR2_MATNR_ALPHAHP_LUT3                     ((0x1776  << 2) + 0xff000000)
//Bit 31:24        reg_matnr_alphahp_lut15   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 23:16        reg_matnr_alphahp_lut14   // unsigned , default = 255  high-pass filter alpha LUT
//Bit 15: 8        reg_matnr_alphahp_lut13   // unsigned , default = 255  high-pass filter alpha LUT
//Bit  7: 0        reg_matnr_alphahp_lut12   // unsigned , default = 255  high-pass filter alpha LUT
#define NR2_MATNR_MTNB_BRT                         ((0x1777  << 2) + 0xff000000)
//Bit 31:28        reg_matnr_mtnb_brt_limt_hi  // unsigned , default = 0
//Bit 27:24        reg_matnr_mtnb_brt_slop_hi  // unsigned , default = 0
//Bit 23:16        reg_matnr_mtnb_brt_thrd_hi  // unsigned , default = 160
//Bit 15:12        reg_matnr_mtnb_brt_limt_lo  // unsigned , default = 6
//Bit 11: 8        reg_matnr_mtnb_brt_slop_lo  // unsigned , default = 6
//Bit  7: 0        reg_matnr_mtnb_brt_thrd_lo  // unsigned , default = 100
//========== nr2_tnr_regs register end ==========//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  vpu_nr2_regs.h
//
//
// Reading file:  nr2_cue_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define NR2_CUE_MODE                               ((0x1778  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19           reg_cue2_isabv_org_invert1  // unsigned , default = 0
//Bit 18           reg_cue2_valid_condition    // unsigned , default = 1
//Bit 17:16        reg_cue2_orgline_flt_sel    // unsigned , default = 1
//Bit 15:12        reg_cue2_orgline_flt_alph   // unsigned , default = 4
//Bit 11           reg_cue2_isabv_org_invert   // unsigned , default = 0
//Bit 10           reg_cue2_iscur_org_invert   // unsigned , default = 0
//Bit  9           reg_cue_enable_r	          // unsigned , default = 1  right half frame enable
//Bit  8           reg_cue_enable_l            // unsigned , default = 1  left half frame enable
//Bit  7            reserved
//Bit  6: 4        reg_cue_con_rplc_mode       // unsigned , default = 7  pixel chroma replace mode;
//Bit  3: 0        reg_cue_chrm_flt_mode       // unsigned , default = 5  improvement filter mode,
#define NR2_CUE_CON_MOT_TH                         ((0x1779  << 2) + 0xff000000)
//Bit 31:24        reg_cue_con_cmot_thrd2	   // unsigned , default = 20  Detection threshold of up/down two rows,  Chroma channel in Chroma Up-sampling Error (CUE) Detection (tighter).
//Bit 23:16        reg_cue_con_ymot_thrd2	   // unsigned , default = 20  Detection threshold of up/mid/down three rows,  Luma channel in Chroma Up-sampling Error (CUE) Detection (tighter).
//Bit 15: 8        reg_cue_con_cmot_thrd	      // unsigned , default = 20  Detection threshold of up/down two rows, Chroma channel in Chroma Up-sampling Error (CUE) Detection.
//Bit  7: 0        reg_cue_con_ymot_thrd	      // unsigned , default = 20  Detection threshold of up/mid/down three rows, Luma channel in Chroma Up-sampling Error (CUE) Detection.
#define NR2_CUE_CON_DIF0                           ((0x177a  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15: 8        reg_cue_con_difp1_thrd	   // unsigned , default = 20  field Intra-Field top/below line chroma difference threshold,
//Bit  7: 0        reg_cue_con_difcur_thrd	  // unsigned , default = 0  Field/Frame Intra-Field up/down line chroma difference threshold,
#define NR2_CUE_CON_DIF1                           ((0x177b  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19:16        reg_cue_con_rate0	         // unsigned , default = 8  Krate to decide CUE by relationship between CUE_diflG and CUE_difEG
//Bit 15: 8        reg_cue_con_difeg_thrd	   // unsigned , default = 0  to the difference between current Field/Frame middle line to down line color channel(CUE_difEG).
//Bit  7: 0        reg_cue_con_diflg_thrd	   // unsigned , default = 100  to the difference between P1 field top line to current Field/Frame down line color channel (CUE_diflG).
#define NR2_CUE_CON_DIF2                           ((0x177c  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19:16        reg_cue_con_rate1	        // unsigned , default = 8  Krate to decide CUE by relationship between CUE_difnC and CUE_difEC
//Bit 15: 8        reg_cue_con_difec_thrd    // unsigned , default = 0  to the difference between current Field/Frame middle line to up line color channel(CUE_difEC).
//Bit  7: 0        reg_cue_con_difnc_thrd    // unsigned , default = 100  to the difference between P1 field bot line to current Field/Frame up line color channel (CUE_difnC).
#define NR2_CUE_CON_DIF3                           ((0x177d  << 2) + 0xff000000)
//Bit 31:20        reserved
//Bit 19:16        reg_cue_con_rate2	        // unsigned , default = 8  Krate to decide CUE by relationship between CUE_difP1 and CUE_difEP1
//Bit 15: 8        reg_cue_con_difep1_thrd   // unsigned , default = 10  top/below line to current field/frame middle line chroma difference (CUE_difEP1) threshold.
//Bit  7: 0        reg_cue_con_difp1_thrd2   // unsigned , default = 10  field Intra-Field top/below line chroma difference threshold (tighter),
#define NR2_CUE_PRG_DIF                            ((0x177e  << 2) + 0xff000000)
//Bit 31:21        reserved
//Bit 20           reg_cue_prg_enable	       // unsigned , default = 0  bit for progressive video CUE detection.If interlace input video,
//Bit 19:16        reg_cue_prg_rate	         // unsigned , default = 4  Krate to decide CUE by relationship between CUE_difCur and (CUE_difEC+CUE_difEG)
//Bit 15: 8        reg_cue_prg_difceg_thrd   // unsigned , default = 40  Frame Intra-Field up-mid and mid-down line chroma difference threshold for progressive video CUE detection,
//Bit  7: 0        reg_cue_prg_difcur_thrd   // unsigned , default = 30  Frame Intra-Field up/down line chroma difference threshold,
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  nr2_cue_regs.h
//
#define NR2_CONV_MODE                              ((0x177f  << 2) + 0xff000000)
//Bit 3:2,	Conv_c444_mode	The format convert mode about 422 to 444 when data read out line buffer
//Bit 1:0,	Conv_c422_mode	the format convert mode about 444 to 422 when data write to line buffer
//// NR2 REG DEFINE END ////
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f | 8'h80~8'h8f | 0x9a-0x9b
//
// Reading file:  vpu_det3d_regs.h
//
//// DET 3D REG DEFINE BEGIN ////
//// 8'h34~8'h3f
//// DET 3D REG DEFINE END ////
#define DET3D_MOTN_CFG                             ((0x1734  << 2) + 0xff000000)
//Bit 16,	reg_det3d_intr_en	        Det3d interrupt enable
//Bit 9:8,	reg_Det3D_Motion_Mode	    U2  Different mode for Motion Calculation of Luma and Chroma:
//                                      0: MotY, 1: (2*MotY + (MotU + MotV))/4; 2: Max(MotY, MotU,MotV); 3:Max(MotY, (MotU+MotV)/2)
//Bit 7:4,	reg_Det3D_Motion_Core_Rate	U4  K Rate to Edge (HV) details for coring of Motion Calculations, normalized to 32
//Bit 3:0,	reg_Det3D_Motion_Core_Thrd	U4  2X: static coring value for Motion Detection.
#define DET3D_CB_CFG                               ((0x1735  << 2) + 0xff000000)
//Bit 7:4,	reg_Det3D_ChessBd_HV_ofst	U4,  Noise immune offset for horizontal or vertical combing detection.
//Bit 3:0,	reg_Det3D_ChessBd_NHV_ofst	U4,  Noise immune offset for NON-horizontal or vertical combing detection.
#define DET3D_SPLT_CFG                             ((0x1736  << 2) + 0xff000000)
//Bit 7:4,	reg_Det3D_SplitValid_ratio	U4,  Ratio between max_value and the avg_value of the edge mapping for split line valid detection.
//                                      The smaller of this value, the easier of the split line detected.
//Bit 3:0,	reg_Det3D_AvgIdx_ratio	    U4,  Ratio to the avg_value of the edge mapping for split line position estimation.
//                                      The smaller of this value, the more samples will be added to the estimation.
#define DET3D_HV_MUTE                              ((0x1737  << 2) + 0xff000000)
//Bit 23:20, reg_Det3D_Edge_Ver_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Top and Bottom border part.
//Bit 19:16, reg_Det3D_Edge_Hor_Mute	U4  X2: Horizontal pixels to be mute from H/V Edge calculation Left and right border part.
//Bit 15:12, reg_Det3D_ChessBd_Ver_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 11:8,	 reg_Det3D_ChessBd_Hor_Mute	U4  X2: Horizontal pixels to be mute from ChessBoard statistics calculation in middle part
//Bit 7:4,	 reg_Det3D_STA8X8_Ver_Mute	U4  1X: Vertical pixels to be mute from 8x8 statistics calculation in each block.
//Bit 3:0,	 reg_Det3D_STA8X8_Hor_Mute	U4  1X: Horizontal pixels to be mute from 8x8 statistics calculation in each block.
#define DET3D_MAT_STA_P1M1                         ((0x1738  << 2) + 0xff000000)
//Bit 31:24, reg_Det3D_STA8X8_P1_K0_R8	U8  SAD to SAI ratio to decide P1, normalized to 256 (0.8)
//Bit 23:16, reg_Det3D_STA8X8_P1_K1_R7	U8  SAD to ENG ratio to decide P1, normalized to 128 (0.5)
//Bit 15:8,	 reg_Det3D_STA8X8_M1_K0_R6	U8  SAD to SAI ratio to decide M1, normalized to 64  (1.1)
//Bit 7:0,	 reg_Det3D_STA8X8_M1_K1_R6	U8  SAD to ENG ratio to decide M1, normalized to 64  (0.8)
#define DET3D_MAT_STA_P1TH                         ((0x1739  << 2) + 0xff000000)
//Bit 23:16, reg_Det3D_STAYUV_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (100)
//Bit 15:8,	 reg_Det3D_STAEDG_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_P1_TH_L4	U8  SAD to ENG Thrd offset to decide P1, X16         (48)
#define DET3D_MAT_STA_M1TH                         ((0x173a  << 2) + 0xff000000)
//Bit 23:16, reg_Det3D_STAYUV_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (100)
//Bit 15:8,	 reg_Det3D_STAEDG_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (80)
//Bit 7:0,	 reg_Det3D_STAMOT_M1_TH_L4	U8  SAD to ENG Thrd offset to decide M1, X16         (64)
#define DET3D_MAT_STA_RSFT                         ((0x173b  << 2) + 0xff000000)
//Bit 5:4,	 reg_Det3D_STAYUV_RSHFT	    U2  YUV statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 3:2,	 reg_Det3D_STAEDG_RSHFT	    U2  Horizontal and Vertical Edge Statistics SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
//Bit 1:0,	 reg_Det3D_STAMOT_RSHFT	    U2  Motion SAD and SAI calculation result right shift bits to accommodate the 12bits clipping:
//                                      0: mainly for images <=720x480: 1: mainly for images <=1366x768: 2: mainly for images <=1920X1080: 2; 3: other higher resolutions
#define DET3D_MAT_SYMTC_TH                         ((0x173c  << 2) + 0xff000000)
//Bit 31:24, reg_Det3D_STALUM_symtc_Th	  U8  threshold to decide if the Luma statistics is TB or LR symmetric.
//Bit 23:16, reg_Det3D_STACHR_symtc_Th	  U8  threshold to decide if the Chroma (UV) statistics is TB or LR symmetric.
//Bit 15:8,	 reg_Det3D_STAEDG_symtc_Th	  U8  threshold to decide if the Horizontal and Vertical Edge statistics is TB or LR symmetric.
//Bit 7:0,	 reg_Det3D_STAMOT_symtc_Th	  U8  threshold to decide if the Motion statistics is TB or LR symmetric.
#define DET3D_RO_DET_CB_HOR                        ((0x173d  << 2) + 0xff000000)
//Bit 31:16, RO_Det3D_ChessBd_NHor_value    U16  X64: number of Pixels of Horizontally Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Hor_value	    U16  X64: number of Pixels of Horizontally Surely matching Chessboard pattern.
#define DET3D_RO_DET_CB_VER                        ((0x173e  << 2) + 0xff000000)
//Bit 31:16, RO_Det3D_ChessBd_NVer_value	U16  X64: number of Pixels of Vertically Surely NOT matching Chessboard pattern.
//Bit 15:0,	 RO_Det3D_ChessBd_Ver_value	    U16  X64: number of Pixels of Vertically Surely matching Chessboard pattern.
#define DET3D_RO_SPLT_HT                           ((0x173f  << 2) + 0xff000000)
//Bit 24,	 RO_Det3D_Split_HT_valid	U1  horizontal LR split border detected valid signal for top half picture
//Bit 20:16, RO_Det3D_Split_HT_pxnum	U5  number of pixels included for the LR split position estimation for top half picture
//Bit 9:0,	 RO_Det3D_Split_HT_idxX4	S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//// DET 3D REG DEFINE BEGIN ////
////  8'h80~8'h8f
#define DET3D_RO_SPLT_HB                           ((0x1780  << 2) + 0xff000000)
//Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VL                           ((0x1781  << 2) + 0xff000000)
//Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_SPLT_VR                           ((0x1782  << 2) + 0xff000000)
//Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal for top half picture
//Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
#define DET3D_RO_MAT_LUMA_LR                       ((0x1783  << 2) + 0xff000000)
//Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
#define DET3D_RO_MAT_LUMA_TB                       ((0x1784  << 2) + 0xff000000)
//Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision,
#define DET3D_RO_MAT_CHRU_LR                       ((0x1785  << 2) + 0xff000000)
//Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band (8bands vertically),
//Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
#define DET3D_RO_MAT_CHRU_TB                       ((0x1786  << 2) + 0xff000000)
//Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
#define DET3D_RO_MAT_CHRV_LR                       ((0x1787  << 2) + 0xff000000)
//Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
#define DET3D_RO_MAT_CHRV_TB                       ((0x1788  << 2) + 0xff000000)
//Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
#define DET3D_RO_MAT_HEDG_LR                       ((0x1789  << 2) + 0xff000000)
//Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
#define DET3D_RO_MAT_HEDG_TB                       ((0x178a  << 2) + 0xff000000)
//Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
#define DET3D_RO_MAT_VEDG_LR                       ((0x178b  << 2) + 0xff000000)
//Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
#define DET3D_RO_MAT_VEDG_TB                       ((0x178c  << 2) + 0xff000000)
//Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
#define DET3D_RO_MAT_MOTN_LR                       ((0x178d  << 2) + 0xff000000)
//Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band (8bands vertically)
//Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band (8bands vertically)
//Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
#define DET3D_RO_MAT_MOTN_TB                       ((0x178e  << 2) + 0xff000000)
//Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
#define DET3D_RO_FRM_MOTN                          ((0x178f  << 2) + 0xff000000)
//Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision in FW.
/// mat ram read enter addr
#define DET3D_RAMRD_ADDR_PORT                      ((0x179a  << 2) + 0xff000000)
#define DET3D_RAMRD_DATA_PORT                      ((0x179b  << 2) + 0xff000000)
//
// Closing file:  vpu_det3d_regs.h
//
//   `define DET3D_RO_SPLT_HB            8'h80
//   //Bit 24,	    RO_Det3D_Split_HB_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_HB_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_HB_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VL            8'h81
//   //Bit 24,	    RO_Det3D_Split_VL_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VL_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VL_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_SPLT_VR            8'h82
//   //Bit 24   ,	RO_Det3D_Split_VR_valid	    U1   horizontal LR split border detected valid signal for top half picture
//   //Bit 20:16,	RO_Det3D_Split_VR_pxnum	    U5   number of pixels included for the LR split position estimation for top half picture
//   //Bit  9: 0,	RO_Det3D_Split_VR_idxX4	    S10  X4: horizontal pixel shifts of LR split position to the (ColMax/2) for top half picture
//   `define DET3D_RO_MAT_LUMA_LR        8'h83
//   //Bit 15:0,	RO_Luma_LR_score	 S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //                               it can be -1/0/1:-1: most likely not LR symmetric 0: not sure 1: most likely LR symmetric
//   //Bit 7:0,	RO_Luma_LR_symtc	 U1*8  Luma statistics left right pure symmetric for each band (8bands vertically),
//   //                               it can be 0/1: 0: not sure 1: most likely LR is pure symmetric
//   //Bit 4:0,	RO_Luma_LR_sum	     S5  Total score of 8x8 Luma statistics for LR like decision,
//   //                               the larger this score, the more confidence that this is a LR 3D video. It is sum of  RO_Luma_LR_score[0~7]
//   `define DET3D_RO_MAT_LUMA_TB        8'h84
//   //Bit 15:0,	RO_Luma_TB_score	 S2*8  LUMA statistics Top/Bottom decision score for each band (8bands Horizontally),
//   //Bit 7:0,	RO_Luma_TB_symtc	 Luma statistics Top/Bottompure symmetric for each band (8bands Horizontally),
//   //Bit 4:0,	RO_Luma_TB_sum	     Total score of 8x8 Luma statistics for TB like decision,
//   `define DET3D_RO_MAT_CHRU_LR        8'h85
//   //Bit 15:0,	RO_ChrU_LR_score	S2*8  LUMA statistics left right decision score for each band (8bands vertically),
//   //Bit 7:0,	RO_ChrU_LR_symtc	CHRU statistics left right pure symmetric for each band (8bands vertically),
//   //Bit 4:0,	RO_ChrU_LR_sum	    Total score of 8x8 ChrU statistics for LR like decision,
//   `define DET3D_RO_MAT_CHRU_TB        8'h86
//   //Bit 15:0,	RO_ChrU_TB_score	S2*8  CHRU statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrU_TB_symtc	CHRU statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_ChrU_TB_sum	    Total score of 8x8 ChrU statistics for TB like decision
//   `define DET3D_RO_MAT_CHRV_LR        8'h87
//   //Bit 15:0,	RO_ChrV_LR_score	S2*8  CHRUstatistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_ChrV_LR_symtc	CHRV statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_ChrV_LR_sum	    Total score of 8x8 ChrV statistics for LR like decision
//   `define DET3D_RO_MAT_CHRV_TB        8'h88
//   //Bit 15:0,	RO_ChrV_TB_score	CHRV statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_ChrV_TB_symtc	CHRV statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_ChrV_TB_sum	    Total score of 8x8 ChrV statistics for TB like decision
//   `define DET3D_RO_MAT_HEDG_LR        8'h89
//   //Bit 15:0,	RO_Hedg_LR_score	Horizontal Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Hedg_LR_symtc	Horizontal Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Hedg_LR_sum	    Total score of 8x8 Hedg statistics for LR like decision
//   `define DET3D_RO_MAT_HEDG_TB        8'h8a
//   //Bit 15:0,	RO_Hedg_TB_score	Horizontal Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Hedg_TB_symtc	Horizontal Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Hedg_TB_sum	    Total score of 8x8 Hedg statistics for TB like decision
//   `define DET3D_RO_MAT_VEDG_LR        8'h8b
//   //Bit 15:0,	RO_Vedg_LR_score	Vertical Edge statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Vedg_LR_symtc	Vertical Edge statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Vedg_LR_sum	    Total score of 8x8 Vedg statistics for LR like decision
//   `define DET3D_RO_MAT_VEDG_TB        8'h8c
//   //Bit 15:0,	RO_Vedg_TB_score	Vertical Edge statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Vedg_TB_symtc	Vertical Edge statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Vedg_TB_sum	    Total score of 8x8 Vedg statistics for TB like decision
//   `define DET3D_RO_MAT_MOTN_LR        8'h8d
//   //Bit 15:0,	RO_Motn_LR_score	Motion statistics left right decision score for each band (8bands vertically)
//   //Bit 7:0,	RO_Motn_LR_symtc	Motion statistics left right pure symmetric for each band (8bands vertically)
//   //Bit 4:0,	RO_Motn_LR_sum	    Total score of 8x8 Motion statistics for LR like decision
//   `define DET3D_RO_MAT_MOTN_TB        8'h8e
//   //Bit 15:0,	RO_Motn_TB_score	Motion statistics Top/Bottom decision score for each band (8bands Horizontally)
//   //Bit 7:0,	RO_Motn_TB_symtc	Motion statistics Top/Bottompure symmetric for each band (8bands Horizontally)
//   //Bit 4:0,	RO_Motn_TB_sum	    Total score of 8x8 Motion statistics for TB like decision
//   `define DET3D_RO_FRM_MOTN           8'h8f
//   //Bit 15:0,	RO_Det3D_Frame_Motion	U16  frame based motion value sum for still image decision in FW.
#define DI_EI_CTRL10                               ((0x1793  << 2) + 0xff000000)
//bit 31:28,   reg_ei_caldrt_hstrrgchk_drtth
//bit 27:24,   reg_ei_caldrt_hstrrgchk_frcverthrd
//bit 23:20,   reg_ei_caldrt_hstrrgchk_mg
//bit 19,      reg_ei_caldrt_hstrrgchk_1sidnul
//bit 18,      reg_ei_caldrt_hstrrgchk_excpcnf
//bit 17:16,   reg_ei_caldrt_hstrrgchk_ws
//bit 15,      reg_ei_caldrt_hstrrgchk_en
//bit 14:13,   reg_ei_caldrt_hpncheck_mode
//bit 12,      reg_ei_caldrt_hpncheck_mute
//bit 11:9,    reg_ei_caldrt_hcnfcheck_mg2
//bit 8:6,     reg_ei_caldrt_hcnfcheck_mg1
//bit 5:4,     reg_ei_caldrt_hcnfcheck_mode
//bit 3:0,     reg_ei_caldrt_hcnfcheck_mg2
#define DI_NR_1_CTRL0                              ((0x1794  << 2) + 0xff000000)
#define DI_NR_1_CTRL1                              ((0x1795  << 2) + 0xff000000)
#define DI_NR_1_CTRL2                              ((0x1796  << 2) + 0xff000000)
#define DI_NR_1_CTRL3                              ((0x1797  << 2) + 0xff000000)
#define DI_EI_XWIN0                                ((0x1798  << 2) + 0xff000000)
//bit 27:16,   ei_xend0
//bit 11:0,    ei_xstart0
#define DI_EI_XWIN1                                ((0x1799  << 2) + 0xff000000)
/// mat ram read enter addr
//   `define DET3D_RAMRD_ADDR_PORT       8'h9a
//   `define DET3D_RAMRD_DATA_PORT       8'h9b
#define NR2_CFR_PARA_CFG0                          ((0x179c  << 2) + 0xff000000)
//Bit 8,	reg_CFR_CurDif_luma_mode	Current Field Top/Bot line Luma difference calculation mode
//Bit 7:6,	reg_MACFR_frm_phase	        U2  This will be a field based phase register that need to be set by FW phase to phase:
//                                      this will be calculated based on dbdr_phase of the specific line of this frame.
//                                      u1: dbdr_phase=1, center line is DB in current line;  dbdr_phase=2, center line is Dr in current line;
//Bit 5:4,	reg_CFR_CurDif_tran_mode	U2  Current Field Top/Bot line Luma/Chroma transition level calculation mode,
//Bit 3:2,	reg_CFR_alpha_mode	        U2  Alpha selection mode for CFR block from curAlp and motAlp i.e. 0: motAlp; 1: (motAlp+curAlp)/2; 2: min(motAlp,curAlp); 3: max(motAlp,curAlp);
//Bit 1:0,	reg_CFR_Motion_Luma_mode	U2  LumaMotion Calculation mode for MA-CFR. 0: top/bot Lumma motion;   1: middle Luma Motion 2: top/bot + middle motion; 3: max(top/tot motion, middle motion)
#define NR2_CFR_PARA_CFG1                          ((0x179d  << 2) + 0xff000000)
//Bit 23:16,	reg_CFR_alpha_gain	    gain to map muxed curAlp and motAlp to alpha that will be used for final blending.
//Bit 15: 8,	reg_CFR_Motion_ofst	    Offset to Motion to calculate the motAlp, e,g:motAlp= reg_CFR_Motion_ofst- Motion;This register can be seen as the level of motion that we consider it at moving.
//Bit  7: 0,	reg_CFR_CurDif_gain	    gain to CurDif to map to alpha, normalized to 32;
//// DET 3D REG DEFINE END ////
#define DI_EI_CTRL11                               ((0x179e  << 2) + 0xff000000)
//bit 30:29,   reg_ei_amb_detect_mode
//bit 28:24,   reg_ei_amb_detect_winth
//bit 23:21,   reg_ei_amb_decide_rppth
//bit 20:19,   reg_ei_retime_lastmappncnfltchk_drtth
//bit 18:16,   reg_ei_retime_lastmappncnfltchk_mode
//bit 15:14,   reg_ei_retime_lastmapvertfrcchk_mode
//bit 13:12,   reg_ei_retime_lastvertfrcchk_mode
//bit 11:8,    reg_ei_retime_lastpnchk_drtth
//bit 6,       reg_ei_retime_lastpnchk_en
//bit 5:4,     reg_ei_retime_mode
//bit 3,       reg_ei_retime_last_en
//bit 2,       reg_ei_retime_ab_en
//bit 1,       reg_ei_caldrt_hstrvertfrcchk_en
//bit 0,       reg_ei_caldrt_hstrrgchk_mode
#define DI_EI_CTRL12                               ((0x179f  << 2) + 0xff000000)
//bit 31:28,   reg_ei_drtdelay2_lmt
//bit 27:26,   reg_ei_drtdelay2_notver_lrwin
//bit 25:24,   reg_ei_drtdelay_mode
//bit 23,      reg_ei_drtdelay2_mode
//bit 22:20,   reg_ei_assign_xla_signm0th
//bit 19,      reg_ei_assign_pkbiasvert_en
//bit 18,      reg_ei_assign_xla_en
//bit 17:16,   reg_ei_assign_xla_mode
//bit 15:12,   reg_ei_assign_nlfilter_magin
//bit 11:8,    reg_ei_localsearch_maxrange
//bit 7:4,     reg_ei_xla_drtth
//bit 3:0,     reg_ei_flatmsad_thrd
//`define DI_DIWR_CANVAS      8'ha0
//`define DI_DIWR_URGENT      8'ha1
//`define DI_NRWR_CANVAS      8'ha2
//`define DI_NRWR_URGENT      8'ha7
//`define DI_CONTWR_X                8'ha0
//`define DI_CONTWR_Y                8'ha1
//`define DI_CONTWR_CTRL             8'ha2
//`define DI_CONTPRD_X               8'ha3
//`define DI_CONTPRD_Y               8'ha4
//`define DI_CONTP2RD_X              8'ha5
//`define DI_CONTP2RD_Y              8'ha6
#define DI_RO_PRE_FIELD_CNT0                       ((0x17a3  << 2) + 0xff000000)
#define DI_RO_PRE_FIELD_CNT1                       ((0x17a4  << 2) + 0xff000000)
#define DI_RO_POS_FRAME_CNT0                       ((0x17a5  << 2) + 0xff000000)
#define DI_RO_POS_FRAME_CNT1                       ((0x17a6  << 2) + 0xff000000)
//`define DI_CONTRD_CTRL             8'ha7
#define DI_EI_CTRL13                               ((0x17a8  << 2) + 0xff000000)
//bit 27:24,   reg_ei_int_drt2x_chrdrt_limit
//bit 23:20,   reg_ei_int_drt16x_core
//bit 19:16,   reg_ei_int_drtdelay2_notver_cancv
//bit 15:8,    reg_ei_int_drtdelay2_notver_sadth
//bit 7:0,     reg_ei_int_drtdelay2_vlddrt_sadth
#define DI_MTN_1_CTRL6                             ((0x17a9  << 2) + 0xff000000)
//bit 31:24,   mtn_m1b_extend
//bit 23:16,   mtn_m1b_errod
//bit 15: 8,   mtn_core_ykinter
//bit  7: 0,   mtn_core_ckinter
#define DI_MTN_1_CTRL7                             ((0x17aa  << 2) + 0xff000000)
//bit 31:24,   mtn_core_mxcmby
//bit 23:16,   mtn_core_mxcmbc
//bit 15: 8,   mtn_core_y
//bit  7: 0,   mtn_core_c
#define DI_MTN_1_CTRL8                             ((0x17ab  << 2) + 0xff000000)
//bit 31:24,   mtn_fcore_ykinter
//bit 23:16,   mtn_fcore_ckinter
//bit 15: 8,   mtn_fcore_ykintra
//bit  7: 0,   mtn_fcore_ckintra
#define DI_MTN_1_CTRL9                             ((0x17ac  << 2) + 0xff000000)
//bit 31:24,   mtn_fcore_2yrate
//bit 23:16,   mtn_fcore_2crate
//bit 15: 8,   mtn_fcore_y
//bit  7: 0,   mtn_fcore_c
#define DI_MTN_1_CTRL10                            ((0x17ad  << 2) + 0xff000000)
//bit 27:24,   mtn_motfld0
//bit 19:16,   mtn_stlfld0
//bit 11: 8,   mtn_motfld1
//bit  3: 0,   mtn_stlfld1
#define DI_MTN_1_CTRL11                            ((0x17ae  << 2) + 0xff000000)
//bit 27:24,   mtn_smotevn
//bit 20:16,   mtn_smotodd
//bit 11: 8,   mtn_sstlevn
//bit  4: 0,   mtn_sstlodd
#define DI_MTN_1_CTRL12                            ((0x17af  << 2) + 0xff000000)
//bit 31:24,   mtn_mgain
//bit 17:16,   mtn_mmode
//bit 15: 8,   mtn_sthrd
//bit  4: 0,   mtn_sgain
//`define DI_NRWR_X                 8'hc0
//`define DI_NRWR_Y                 8'hc1
//bit 31:30				nrwr_words_lim
//bit 29				nrwr_rev_y
//bit 28:16				nrwr_start_y
//bit 15				nrwr_ext_en
//bit 12:0				nrwr_end_y
//`define DI_NRWR_CTRL              8'hc2
//bit 31				pending_ddr_wrrsp_diwr
//bit 30				nrwr_reg_swap
//bit 29:26				nrwr_burst_lim
//bit 25				nrwr_canvas_syncen
//bit 24				nrwr_no_clk_gate
//bit 23:22				nrwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
					             //2:Y to luma , CBCR to chroma canvas ,for nv12/21; 3 : reserved
//bit 21:20				nrwr_hconv_mode
//bit 19:18				nrwr_vconv_mode
//bit 17				nrwr_swap_cbcr
//bit 16				nrwr_urgent
//bit 15:8				nrwr_canvas_index_chroma
//bit 7:0				nrwr_canvas_index_luma
//`define DI_MTNWR_X                8'hc3
//`define DI_MTNWR_Y                8'hc4
//`define DI_MTNWR_CTRL             8'hc5
#define DI_RO_CRC_NRWR                             ((0x17c0  << 2) + 0xff000000)
#define DI_RO_CRC_MTNWR                            ((0x17c1  << 2) + 0xff000000)
#define DI_RO_CRC_DEINT                            ((0x17c2  << 2) + 0xff000000)
#define DI_CRC_CHK0                                ((0x17c3  << 2) + 0xff000000)
#define DI_CRC_CHK1                                ((0x17c4  << 2) + 0xff000000)
//`define DI_DIWR_X                 8'hc6
//`define DI_DIWR_Y                 8'hc7
//bit 31:30				diwr_words_lim
//bit 29				diwr_rev_y
//bit 28:16				diwr_start_y
//bit 15				diwr_ext_en
//bit 12:0				diwr_end_y
//`define DI_DIWR_CTRL              8'hc8
//bit 31				pending_ddr_wrrsp_diwr
//bit 30				diwr_reg_swap
//bit 29:26				diwr_burst_lim
//bit 25				diwr_canvas_syncen
//bit 24				diwr_no_clk_gate
//bit 23:22				diwr_rgb_mode  0:422 to one canvas;1:4:4:4 to one canvas;
						     //2:Y to luma , CBCR to chroma canvas ,for nv12/21; 3 : reserved
//bit 21:20				diwr_hconv_mode
//bit 19:18				diwr_vconv_mode
//bit 17				diwr_swap_cbcr
//bit 16				diwr_urgent
//bit 15:8				diwr_canvas_index_chroma
//bit 7:0				diwr_canvas_index_luma
//`define DI_MTNCRD_X               8'hc9
//`define DI_MTNCRD_Y               8'hca
//`define DI_MTNPRD_X               8'hcb
//`define DI_MTNPRD_Y               8'hcc
//`define DI_MTNRD_CTRL             8'hcd
#define DI_TOP_PRE_CTRL                            ((0x17c5  << 2) + 0xff000000)
#define DI_TOP_POST_CTRL                           ((0x17c6  << 2) + 0xff000000)
#define DI_PRE_GL_CTRL                             ((0x17c7  << 2) + 0xff000000)
#define DI_PRE_GL_THD                              ((0x17c8  << 2) + 0xff000000)
#define DI_POST_GL_CTRL                            ((0x17c9  << 2) + 0xff000000)
#define DI_POST_GL_THD                             ((0x17ca  << 2) + 0xff000000)
#define DI_RO_PRE_DBG                              ((0x17cb  << 2) + 0xff000000)
#define DI_RO_POST_DBG                             ((0x17cc  << 2) + 0xff000000)
#define DI_TOP_CTRL                                ((0x17cd  << 2) + 0xff000000)
#define DI_AFBCD_GCLK0                             ((0x17ce  << 2) + 0xff000000)
#define DI_AFBCD_GCLK1                             ((0x17cf  << 2) + 0xff000000)
#define DI_RDMIF_DEPTH0                            ((0x17d0  << 2) + 0xff000000)
#define DI_RDMIF_DEPTH1                            ((0x17d1  << 2) + 0xff000000)
#define DI_RDMIF_DEPTH2                            ((0x17d2  << 2) + 0xff000000)
#define DI_TOP_CTRL1                               ((0x17d3  << 2) + 0xff000000)
#define DI_AFBCE0_HOLD_CTRL                        ((0x17d4  << 2) + 0xff000000)
#define DI_AFBCE1_HOLD_CTRL                        ((0x17d5  << 2) + 0xff000000)
// 0xe0 - 0xff
//
// Reading file:  di_pd_grad_reg.h
//
#define DI_PD_GRAD_CTRL                            ((0x17e0  << 2) + 0xff000000)
//Bit 31:12  reserved
//Bit 11:4   reg_fd_min_grad_th           // default 255 //u8, for cur/pre1 field. cur_min_grad_err > th, will be excluded of statistic
//Bit 3      reg_fd_min_grad_th_adjust_en // default 1   //u1, reg_fd_min_grad_err_th adjustment enable/disable
//Bit 2      reg_fd_err_grad_bf_flt_en    // default 1   //u1, 1:comput err_grad_sum before horizontal filtering; 0: ...after...; default=1;
//Bit 1      reg_fd_comb_field_sel        // default 0   //u1, comb consists of 2 field; 0: cur-pre; 1:pre-pre2;
//Bit 0      reg_fd_iscur_top_inver       // default 0   //u1, current field is top flag invert; 0 no invert, 1, invert
#define DI_PD_GRAD_TH_P                            ((0x17e1  << 2) + 0xff000000)
//Bit 31:24  reg_fd_min_grad_th_p0        //default 2     //u8,
//Bit 23:16  reg_fd_min_grad_th_p1        //default 4     //u8,
//Bit 15:8   reg_fd_min_grad_th_p2        //default 8     //u8,
//Bit 7:0    reg_fd_min_grad_th_p3        //default 12    //u8,
#define DI_PD_GRAD_TH_N                            ((0x17e2  << 2) + 0xff000000)
//Bit 31:24  reg_fd_min_grad_th_n0        //default 4     //u8,
//Bit 23:16  reg_fd_min_grad_th_n1        //default 8     //u8,
//Bit 15:8   reg_fd_min_grad_th_n2        //default 16    //u8,
//Bit 7:0    reg_fd_min_grad_th_n3        //default 32    //u8,
#define DI_PD_GRAD_GAIN_P                          ((0x17e3  << 2) + 0xff000000)
//Bit 31:29  reserved
//Bit 28:24  reg_fd_min_grad_gain_p0      //default 16    //u5,
//Bit 23:21  reserved
//Bit 20:16  reg_fd_min_grad_gain_p1      //default 16    //u5,
//Bit 15:13  reserved
//Bit 12:8   reg_fd_min_grad_gain_p2      //default 16    //u5,
//Bit 7:5    reserved
//Bit 4:0    reg_fd_min_grad_gain_p3      //default 16    //u5,
#define DI_PD_GRAD_GAIN_N                          ((0x17e4  << 2) + 0xff000000)
//Bit 31:29  reserved
//Bit 28:24  reg_fd_min_grad_gain_n0      //default 12    //u5,
//Bit 23:21  reserved
//Bit 20:16  reg_fd_min_grad_gain_n1      //default 12    //u5,
//Bit 15:13  reserved
//Bit 12:8   reg_fd_min_grad_gain_n2      //default 14    //u5,
//Bit 7:5    reserved
//Bit 4:0    reg_fd_min_grad_gain_n3      //default 15    //u5,
#define DI_PD_RO_SUM_P_WIN0                        ((0x17e5  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p0
#define DI_PD_RO_SUM_P_WIN1                        ((0x17e6  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p1
#define DI_PD_RO_SUM_P_WIN2                        ((0x17e7  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p2
#define DI_PD_RO_SUM_P_WIN3                        ((0x17e8  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p3
#define DI_PD_RO_SUM_P_WIN4                        ((0x17e9  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p4
#define DI_PD_RO_SUM_N_WIN0                        ((0x17ea  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n0
#define DI_PD_RO_SUM_N_WIN1                        ((0x17eb  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n1
#define DI_PD_RO_SUM_N_WIN2                        ((0x17ec  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n2
#define DI_PD_RO_SUM_N_WIN3                        ((0x17ed  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n3
#define DI_PD_RO_SUM_N_WIN4                        ((0x17ee  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n4
#define DI_PD_RO_CNT_P_WIN0                        ((0x17ef  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p0
#define DI_PD_RO_CNT_P_WIN1                        ((0x17f0  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p1
#define DI_PD_RO_CNT_P_WIN2                        ((0x17f1  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p2
#define DI_PD_RO_CNT_P_WIN3                        ((0x17f2  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p3
#define DI_PD_RO_CNT_P_WIN4                        ((0x17f3  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p4
#define DI_PD_RO_CNT_N_WIN0                        ((0x17f4  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n0
#define DI_PD_RO_CNT_N_WIN1                        ((0x17f5  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n1
#define DI_PD_RO_CNT_N_WIN2                        ((0x17f6  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n2
#define DI_PD_RO_CNT_N_WIN3                        ((0x17f7  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n3
#define DI_PD_RO_CNT_N_WIN4                        ((0x17f8  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n4
#define DI_PD_RO_SUM_P                             ((0x17f9  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_p_glb
#define DI_PD_RO_SUM_N                             ((0x17fa  << 2) + 0xff000000)
//Bit 31:0   ro_fd_err_grad_sum_n_glb
#define DI_PD_RO_CNT_P                             ((0x17fb  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_p_glb
#define DI_PD_RO_CNT_N                             ((0x17fc  << 2) + 0xff000000)
//Bit 31:21  reserved
//Bit 20:0   ro_fd_err_grad_cnt_n_glb
//
// Closing file:  di_pd_grad_reg.h
//
//`define DI_INP_GEN_REG            8'hce
//`define DI_INP_CANVAS0            8'hcf
//`define DI_INP_LUMA_X0            8'hd0
//`define DI_INP_LUMA_Y0            8'hd1
//`define DI_INP_CHROMA_X0          8'hd2
//`define DI_INP_CHROMA_Y0          8'hd3
//`define DI_INP_RPT_LOOP           8'hd4
//`define DI_INP_LUMA0_RPT_PAT      8'hd5
//`define DI_INP_CHROMA0_RPT_PAT    8'hd6
//`define DI_INP_DUMMY_PIXEL        8'hd7
//`define DI_INP_LUMA_FIFO_SIZE     8'hd8
//`define DI_INP_RANGE_MAP_Y        8'hba
//`define DI_INP_RANGE_MAP_CB       8'hbb
//`define DI_INP_RANGE_MAP_CR       8'hbc
//`define DI_INP_GEN_REG2           8'h91
//
//`define DI_INP_FMT_CTRL           8'hd9
//`define DI_INP_FMT_W              8'hda
////
//`define DI_MEM_GEN_REG            8'hdb
//`define DI_MEM_CANVAS0            8'hdc
//`define DI_MEM_LUMA_X0            8'hdd
//`define DI_MEM_LUMA_Y0            8'hde
//`define DI_MEM_CHROMA_X0          8'hdf
//`define DI_MEM_CHROMA_Y0          8'he0
//`define DI_MEM_RPT_LOOP           8'he1
//`define DI_MEM_LUMA0_RPT_PAT      8'he2
//`define DI_MEM_CHROMA0_RPT_PAT    8'he3
//`define DI_MEM_DUMMY_PIXEL        8'he4
//`define DI_MEM_LUMA_FIFO_SIZE     8'he5
//`define DI_MEM_RANGE_MAP_Y        8'hbd
//`define DI_MEM_RANGE_MAP_CB       8'hbe
//`define DI_MEM_RANGE_MAP_CR       8'hbf
//`define DI_MEM_GEN_REG2           8'h92
//
//`define DI_MEM_FMT_CTRL           8'he6
//`define DI_MEM_FMT_W              8'he7
//
//`define DI_IF1_GEN_REG            8'he8
//`define DI_IF1_CANVAS0            8'he9
//`define DI_IF1_LUMA_X0            8'hea
//`define DI_IF1_LUMA_Y0            8'heb
//`define DI_IF1_CHROMA_X0          8'hec
//`define DI_IF1_CHROMA_Y0          8'hed
//`define DI_IF1_RPT_LOOP           8'hee
//`define DI_IF1_LUMA0_RPT_PAT      8'hef
//`define DI_IF1_CHROMA0_RPT_PAT    8'hf0
//`define DI_IF1_DUMMY_PIXEL        8'hf1
//`define DI_IF1_LUMA_FIFO_SIZE     8'hf2
//`define DI_IF1_RANGE_MAP_Y        8'hfc
//`define DI_IF1_RANGE_MAP_CB       8'hfd
//`define DI_IF1_RANGE_MAP_CR       8'hfe
//`define DI_IF1_GEN_REG2           8'h90
//
//`define DI_IF1_FMT_CTRL           8'hf3
//`define DI_IF1_FMT_W              8'hf4
//
//
//`define DI_CHAN2_GEN_REG          8'hf5
//`define DI_CHAN2_CANVAS0          8'hf6
//`define DI_CHAN2_LUMA_X0          8'hf7
//`define DI_CHAN2_LUMA_Y0          8'hf8
//`define DI_CHAN2_CHROMA_X0        8'hf9
//`define DI_CHAN2_CHROMA_Y0        8'hfa
//`define DI_CHAN2_RPT_LOOP         8'hfb
//`define DI_CHAN2_LUMA0_RPT_PAT    8'hb0
//`define DI_CHAN2_CHROMA0_RPT_PAT  8'hb1
//`define DI_CHAN2_DUMMY_PIXEL      8'hb2
//`define DI_CHAN2_LUMA_FIFO_SIZE   8'hb3
//`define DI_CHAN2_RANGE_MAP_Y      8'hb4
//`define DI_CHAN2_RANGE_MAP_CB     8'hb5
//`define DI_CHAN2_RANGE_MAP_CR     8'hb6
//`define DI_CHAN2_GEN_REG2         8'hb7
//`define DI_CHAN2_FMT_CTRL         8'hb8
//`define DI_CHAN2_FMT_W            8'hb9
//
// Closing file:  vpu_mad_regs.h
//
// -----------------------------------------------
// REG_BASE:  MADD_VCBUS_BASE = 0x18
// -----------------------------------------------
//
// Reading file:  di_dolby_regs.h
//
// synopsys translate_off
// synopsys translate_on
#define DOLBY_CORE1C_REG_START                     ((0x1800  << 2) + 0xff000000)
#define DOLBY_CORE1C_CLKGATE_CTRL                  ((0x18f2  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL0                    ((0x18f3  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL1                    ((0x18f4  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL2                    ((0x18f5  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL3                    ((0x18f6  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL4                    ((0x18f7  << 2) + 0xff000000)
#define DOLBY_CORE1C_SWAP_CTRL5                    ((0x18f8  << 2) + 0xff000000)
#define DOLBY_CORE1C_DMA_CTRL                      ((0x18f9  << 2) + 0xff000000)
#define DOLBY_CORE1C_DMA_STATUS                    ((0x18fa  << 2) + 0xff000000)
#define DOLBY_CORE1C_STATUS0                       ((0x18fb  << 2) + 0xff000000)
#define DOLBY_CORE1C_STATUS1                       ((0x18fc  << 2) + 0xff000000)
#define DOLBY_CORE1C_STATUS2                       ((0x18fd  << 2) + 0xff000000)
#define DOLBY_CORE1C_STATUS3                       ((0x18fe  << 2) + 0xff000000)
#define DOLBY_CORE1C_DMA_PORT                      ((0x18ff  << 2) + 0xff000000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  di_dolby_regs.h
//
//`include "di_inp_afbc_dec_regs.h"
//`include "di_mem_afbc_dec_regs.h"
//`include "fgrain_di_regs.h"
// -----------------------------------------------
// REG_BASE:  VPP2_VCBUS_BASE = 0x19
// -----------------------------------------------
//`include "vpp2_regs.h"
//
// Reading file:  vregs_clk2.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xaff
//===========================================================================
// -----------------------------------------------
// REG_BASE:  VIU_VCBUS_BASE = 0x1a
// -----------------------------------------------
#define VIU_ADDR_START                             ((0x1a00  << 2) + 0xff000000)
#define VIU_ADDR_END                               ((0x1aff  << 2) + 0xff000000)
//`define TRACE_REG 8'ff
//------------------------------------------------------------------------------
// VIU top-level registers
//------------------------------------------------------------------------------
// Bit  0 RW, osd1_reset
// Bit  1 RW, osd2_reset
// Bit  2 RW, vd1_reset
// Bit  3 RW, vd1_fmt_reset
// Bit  4 RW, vd2_reset
// Bit  5 RW, vd2_fmt_reset
// Bit  6 RW, di_dsr1to2_reset
// Bit  7 RW, vpp_reset
// Bit  8 RW, di_if1_reset
// Bit  9 RW, di_if1_fmt_reset
// Bit 10 RW, di_inp_reset
// Bit 11 RW, di_inp_fmt_reset
// Bit 12 RW, di_mem_reset
// Bit 13 RW, di_mem_fmt_reset
// Bit 14 RW, di_nr_wr_mif_reset
// Bit 15 RW, dein_wr_mif_reset
// Bit 16 RW, di_chan2_mif_reset
// Bit 17 RW, di_mtn_wr_mif_reset
// Bit 18 RW, di_mtn_rd_mif_reset
// Bit 19 RW, di_mad_reset
// Bit 20 RW, vdin0_reset
// Bit 21 RW, vdin1_reset
// Bit 22 RW, nrin_mux_reset
// Bit 23 RW, vdin0_wr_reset
// Bit 24 RW, vdin1_wr_reset
// Bit 25 RW, reserved
// Bit 26 RW, d2d3_reset
// Bit 27 RW, di_cont_wr_mif_reset
// Bit 28 RW, di_cont_rd_mif_reset
#define VIU_SW_RESET                               ((0x1a01  << 2) + 0xff000000)
#define VIU_SW_RESET0                              ((0x1a02  << 2) + 0xff000000)
// Bit 0 RW, software reset for mcvecrd_mif
// Bit 1 RW, software reset for mcinfowr_mif
// Bit 2 RW, software reset for mcinford_mif
#define VIU_SECURE_REG                             ((0x1a04  << 2) + 0xff000000)
// Bit 0 RW, dolby core1_tv secure w and r
// Bit 1 RW, dolby core2 secure w and r
// Bit 2 RW, dolby core3 secure w and r
// Bit 3 RW, for osd1 secure read
// Bit 4 RW, for osd2 secure read
#define DOLBY_INT_STAT                             ((0x1a05  << 2) + 0xff000000)
// todo
//bit 15:12 osdbld_gclk_ctrl 3:2 regclk ctrl 1:0 blending clk control
//bit 8 if true, vsync interrup is generate only field == 0
//bit 7:0 fix_disable
#define VIU_MISC_CTRL0                             ((0x1a06  << 2) + 0xff000000)
#define VIU_MISC_CTRL1                             ((0x1a07  << 2) + 0xff000000)
// Bit 15:14  mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[5:4]
// Bit 12     osd1_afbcd_axi_mux        0 : use the osd mif as input; 1 : use afbcd as input
// Bit 11:8   mali_afbcd_gclk_ctrl      mali_afbcd clock gate control[3:0]
// Bit  7:2   vd2_afbcd_gclk_ctrl       vd2_afbcd clock gate control
// Bit  1     vpp_vd2_din_sel           0: vpp vd2 sel the mif input; 1: vpp vd2 sel the dos afbcd
// Bit  0     vd2_afbcd_out_sel         0: vd2_afbcd output to vpp; 1 : vd2_afbcd output to di inp
#define VIU_SECURE_DUMMY                           ((0x1a08  << 2) + 0xff000000)
#define VIU_SECURE_ST_RO                           ((0x1a09  << 2) + 0xff000000)
// Bit 31:30 vdin0 dout splitter, bit 0 turns on vdin0 to old path, bit 1 turns on vdin0 to d2d3_intf vdin0 input path
// Bit 29:28 vdin1 dout splitter, bit 0 turns on vdin1 to old path, bit 1 turns on vdin1 to d2d3_intf vdin1 input path
// Bit 27:26 NR write dout splitter, bit 0 turns on NR write to old path, bit 1 turns on NR WR to d2d3_intf NR WR input path
// Bit 23 if true, turn on clk_d2d3_reg (register clock)
// Bit 22 if true, turn on clk_d2d3
// Bit 21 reg_v1_go_line
// Bit 20 reg_v1_go_field
// Bit 19 reg_v0_go_field
// Bit 18:16 v1_gofld_sel, 000: display go_field/go_line, 001: DI pre_frame_rst/go_line, 010: vdin0 go_field/go_line,
//011: vdin1 go_field/go_line, otherwise: force go_field by reg_v1_go_field(bit20), force go_line by reg_v1_go_line(bit21)
// Bit 15:13 v0_gofld_sel, 000: display go_field, 001: DI pre_frame_rst, 010: vdin0 go_field, 011: vdin1 go_field, otherwise: force go_field by
// reg_v0_go_field(bit19)
// Bit 12:6 hole_lines for d2d3 depth read interface
// Bit 5:4 d2d3_v1_sel, 2'b01: video display read interface(DI or vd1 format output), 2'b10: scale output, otherwise nothing as v1
// Bit 3 use_vdin_eol, if true, use vdin eol as the v0_eol, otherwise using length to get the v0_eol
// Bit 2:0  d2d3_v0_sel  001: vdin0, 010: vdin1, 011: NRW, 100: video display read interface(DI or vd1 format output), 101: vpp scale output
//
// `define D2D3_INTF_CTRL0                 8'h09
#define VD1_AFBCD0_MISC_CTRL                       ((0x1a0a  << 2) + 0xff000000)
#define VD2_AFBCD1_MISC_CTRL                       ((0x1a0b  << 2) + 0xff000000)
#define DOLBY_PATH_CTRL                            ((0x1a0c  << 2) + 0xff000000)
#define WR_BACK_MISC_CTRL                          ((0x1a0d  << 2) + 0xff000000)
#define OSD_PATH_MISC_CTRL                         ((0x1a0e  << 2) + 0xff000000)
#define MALI_AFBCD_TOP_CTRL                        ((0x1a0f  << 2) + 0xff000000)
#define VIU_DATA_SEC                               ((0x1a50  << 2) + 0xff000000)
#define VIU_FRM_CTRL                               ((0x1a51  << 2) + 0xff000000)
#define VIU_RDMIF_DEPTH                            ((0x1a52  << 2) + 0xff000000)
//------------------------------------------------------------------------------
// OSD1 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit 10: 9 Reserved for control signals
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD1_CTRL_STAT                         ((0x1a10  << 2) + 0xff000000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    RW, osd_dpath_sel   0-osd1 mif 1-vpu mali afbcd
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD1_CTRL_STAT2                        ((0x1a2d  << 2) + 0xff000000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD1_COLOR_ADDR                        ((0x1a11  << 2) + 0xff000000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_COLOR                             ((0x1a12  << 2) + 0xff000000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD1_TCOLOR_AG0                        ((0x1a17  << 2) + 0xff000000)
#define VIU_OSD1_TCOLOR_AG1                        ((0x1a18  << 2) + 0xff000000)
#define VIU_OSD1_TCOLOR_AG2                        ((0x1a19  << 2) + 0xff000000)
#define VIU_OSD1_TCOLOR_AG3                        ((0x1a1a  << 2) + 0xff000000)
// Bit 31:30 Reserved
// Bit    29 RW, y_rev: 0=normal read, 1=reverse read in Y direction
// Bit    28 RW, x_rev: 0=normal read, 1=reverse read in X direction
// Bit 27:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD1_BLK0_CFG_W0                       ((0x1a1b  << 2) + 0xff000000)
#define VIU_OSD1_BLK1_CFG_W0                       ((0x1a1f  << 2) + 0xff000000)
#define VIU_OSD1_BLK2_CFG_W0                       ((0x1a23  << 2) + 0xff000000)
#define VIU_OSD1_BLK3_CFG_W0                       ((0x1a27  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD1_BLK0_CFG_W1                       ((0x1a1c  << 2) + 0xff000000)
#define VIU_OSD1_BLK1_CFG_W1                       ((0x1a20  << 2) + 0xff000000)
#define VIU_OSD1_BLK2_CFG_W1                       ((0x1a24  << 2) + 0xff000000)
#define VIU_OSD1_BLK3_CFG_W1                       ((0x1a28  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD1_BLK0_CFG_W2                       ((0x1a1d  << 2) + 0xff000000)
#define VIU_OSD1_BLK1_CFG_W2                       ((0x1a21  << 2) + 0xff000000)
#define VIU_OSD1_BLK2_CFG_W2                       ((0x1a25  << 2) + 0xff000000)
#define VIU_OSD1_BLK3_CFG_W2                       ((0x1a29  << 2) + 0xff000000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD1_BLK0_CFG_W3                       ((0x1a1e  << 2) + 0xff000000)
#define VIU_OSD1_BLK1_CFG_W3                       ((0x1a22  << 2) + 0xff000000)
#define VIU_OSD1_BLK2_CFG_W3                       ((0x1a26  << 2) + 0xff000000)
#define VIU_OSD1_BLK3_CFG_W3                       ((0x1a2a  << 2) + 0xff000000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD1_BLK0_CFG_W4                       ((0x1a13  << 2) + 0xff000000)
#define VIU_OSD1_BLK1_CFG_W4                       ((0x1a14  << 2) + 0xff000000)
#define VIU_OSD1_BLK2_CFG_W4                       ((0x1a15  << 2) + 0xff000000)
#define VIU_OSD1_BLK3_CFG_W4                       ((0x1a16  << 2) + 0xff000000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD1_FIFO_CTRL_STAT                    ((0x1a2b  << 2) + 0xff000000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD1_TEST_RDDATA                       ((0x1a2c  << 2) + 0xff000000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD1_PROT_CTRL                         ((0x1a2e  << 2) + 0xff000000)
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VIU_OSD1_MATRIX_CTRL                       ((0x1a90  << 2) + 0xff000000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD1_MATRIX_COEF00_01                  ((0x1a91  << 2) + 0xff000000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD1_MATRIX_COEF02_10                  ((0x1a92  << 2) + 0xff000000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD1_MATRIX_COEF11_12                  ((0x1a93  << 2) + 0xff000000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD1_MATRIX_COEF20_21                  ((0x1a94  << 2) + 0xff000000)
//Bit 31:30    mat_clmod
//Bit 18:16    mat_convrs
//Bit 12:0     mat_coef42
#define VIU_OSD1_MATRIX_COLMOD_COEF42              ((0x1a95  << 2) + 0xff000000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VIU_OSD1_MATRIX_OFFSET0_1                  ((0x1a96  << 2) + 0xff000000)
//Bit 10:0  offset2
#define VIU_OSD1_MATRIX_OFFSET2                    ((0x1a97  << 2) + 0xff000000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VIU_OSD1_MATRIX_PRE_OFFSET0_1              ((0x1a98  << 2) + 0xff000000)
//Bit 10:0  pre_offset2
#define VIU_OSD1_MATRIX_PRE_OFFSET2                ((0x1a99  << 2) + 0xff000000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VIU_OSD1_MATRIX_PROBE_COLOR                ((0x1a9a  << 2) + 0xff000000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VIU_OSD1_MATRIX_HL_COLOR                   ((0x1a9b  << 2) + 0xff000000)
//28:16 probe x, postion
//12:0  probe y, position
#define VIU_OSD1_MATRIX_PROBE_POS                  ((0x1a9c  << 2) + 0xff000000)
//Bit 28:16 coef22
//Bit 12:0  coef30
#define VIU_OSD1_MATRIX_COEF22_30                  ((0x1a9d  << 2) + 0xff000000)
//Bit 28:16 coef31
//Bit 12:0  coef32
#define VIU_OSD1_MATRIX_COEF31_32                  ((0x1a9e  << 2) + 0xff000000)
//Bit 28:16 coef40
//Bit 12:0  coef41
#define VIU_OSD1_MATRIX_COEF40_41                  ((0x1a9f  << 2) + 0xff000000)
//Bit 31:27 for all [31] for all eotf enable,[30] for matrix3x3 enable, [29:27] for eotf_ch0~3
//Bit 17:6  for clock gating
//Bit 5:4   pscale_mode ch2
//Bit 3:2   pscale_mode ch1
//Bit 1:0   pscale_mode ch0
#define VIU_OSD1_EOTF_CTL                          ((0x1ad4  << 2) + 0xff000000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD1_EOTF_COEF00_01                    ((0x1ad5  << 2) + 0xff000000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD1_EOTF_COEF02_10                    ((0x1ad6  << 2) + 0xff000000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD1_EOTF_COEF11_12                    ((0x1ad7  << 2) + 0xff000000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD1_EOTF_COEF20_21                    ((0x1ad8  << 2) + 0xff000000)
//Bit 28:16 coef22
//Bit   2:0 coef_rs
#define VIU_OSD1_EOTF_COEF22_RS                    ((0x1ad9  << 2) + 0xff000000)
#define VIU_OSD1_EOTF_LUT_ADDR_PORT                ((0x1ada  << 2) + 0xff000000)
#define VIU_OSD1_EOTF_LUT_DATA_PORT                ((0x1adb  << 2) + 0xff000000)
//Bit 31:29  for OETF ch0~ch2
//Bit 21:12  for clock gating
//Bit 11:8   for oetf_scl_ch2
//Bit  7:4   for oetf_scl_ch1
//Bit  3:0   for oetf_scl_ch0
#define VIU_OSD1_OETF_CTL                          ((0x1adc  << 2) + 0xff000000)
#define VIU_OSD1_OETF_LUT_ADDR_PORT                ((0x1add  << 2) + 0xff000000)
#define VIU_OSD1_OETF_LUT_DATA_PORT                ((0x1ade  << 2) + 0xff000000)
#define VIU_OSD1_OETF_3X3_OFST_0                   ((0x1aa0  << 2) + 0xff000000)
#define VIU_OSD1_OETF_3X3_OFST_1                   ((0x1aa1  << 2) + 0xff000000)
//------------------------------------------------------------------------------
// OSD2 registers
//------------------------------------------------------------------------------
// Bit    31 Reserved
// Bit    30 RW, enable_free_clk: 1=use free-running clock to drive logic;
//                                0=use gated clock for low power.
// Bit    29 R, test_rd_dsr
// Bit    28 R, osd_done
// Bit 27:24 R, osd_blk_mode
// Bit 23:22 R, osd_blk_ptr
// Bit    21 R, osd_enable
//
// Bit 20:12 RW, global_alpha
// Bit    11 RW, test_rd_en
// Bit    10 RW, hl2_en
// Bit     9 RW, hl1_en
// Bit  8: 5 RW, ctrl_mtch_y
// Bit     4 RW, ctrl_422to444
// Bit  3: 0 RW, osd_blk_enable. Bit 0 to enable block 0: 1=enable, 0=disable;
//                               Bit 1 to enable block 1, and so on.
#define VIU_OSD2_CTRL_STAT                         ((0x1a30  << 2) + 0xff000000)
// Bit 31:26 Reserved
// Bit 25:16 R, fifo_count
// Bit 15    Reserved
// Bit 14    RW, replaced_alpha_en
// Bit 13: 6 RW, replaced_alpha
// Bit  5: 4 RW, hold_fifo_lines[6:5]
// Bit     3 RW, rgb2yuv_full_range
// Bit     2 RW, alpha_9b_mode
// Bit     1 RW, reserved
// Bit     0 RW, color_expand_mode
#define VIU_OSD2_CTRL_STAT2                        ((0x1a4d  << 2) + 0xff000000)
// Bit 31: 9 Reserved
// Bit     8 RW, 0 = Write LUT, 1 = Read LUT
// Bit  7: 0 RW, lut_addr
#define VIU_OSD2_COLOR_ADDR                        ((0x1a31  << 2) + 0xff000000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_COLOR                             ((0x1a32  << 2) + 0xff000000)
// Bit 31:28 Reserved
// Bit 27:16 RW, hl[1-2]_h/v_start
// Bit 15:12 Reserved
// Bit 11: 0 RW, hl[1-2]_h/v_end
#define VIU_OSD2_HL1_H_START_END                   ((0x1a33  << 2) + 0xff000000)
#define VIU_OSD2_HL1_V_START_END                   ((0x1a34  << 2) + 0xff000000)
#define VIU_OSD2_HL2_H_START_END                   ((0x1a35  << 2) + 0xff000000)
#define VIU_OSD2_HL2_V_START_END                   ((0x1a36  << 2) + 0xff000000)
// Bit 31:24 RW, Y or R
// Bit 23:16 RW, Cb or G
// Bit 15: 8 RW, Cr or B
// Bit  7: 0 RW, Alpha
#define VIU_OSD2_TCOLOR_AG0                        ((0x1a37  << 2) + 0xff000000)
#define VIU_OSD2_TCOLOR_AG1                        ((0x1a38  << 2) + 0xff000000)
#define VIU_OSD2_TCOLOR_AG2                        ((0x1a39  << 2) + 0xff000000)
#define VIU_OSD2_TCOLOR_AG3                        ((0x1a3a  << 2) + 0xff000000)
// Bit 31:24 Reserved
// Bit 23:16 RW, tbl_addr
// Bit    15 RW, little_endian: 0=big endian, 1=little endian
// Bit    14 RW, rpt_y
// Bit 13:12 RW, interp_ctrl. 0x=No interpolation; 10=Interpolate with previous
//                            pixel; 11=Interpolate with the average value
//                            between previous and next pixel.
// Bit 11: 8 RW, osd_blk_mode
// Bit     7 RW, rgb_en
// Bit     6 RW, tc_alpha_en
// Bit  5: 2 RW, color_matrix
// Bit     1 RW, interlace_en
// Bit     0 RW, interlace_sel_odd
#define VIU_OSD2_BLK0_CFG_W0                       ((0x1a3b  << 2) + 0xff000000)
#define VIU_OSD2_BLK1_CFG_W0                       ((0x1a3f  << 2) + 0xff000000)
#define VIU_OSD2_BLK2_CFG_W0                       ((0x1a43  << 2) + 0xff000000)
#define VIU_OSD2_BLK3_CFG_W0                       ((0x1a47  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 RW, x_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, x_start
#define VIU_OSD2_BLK0_CFG_W1                       ((0x1a3c  << 2) + 0xff000000)
#define VIU_OSD2_BLK1_CFG_W1                       ((0x1a40  << 2) + 0xff000000)
#define VIU_OSD2_BLK2_CFG_W1                       ((0x1a44  << 2) + 0xff000000)
#define VIU_OSD2_BLK3_CFG_W1                       ((0x1a48  << 2) + 0xff000000)
// Bit 31:29 Reserved
// Bit 28:16 RW, y_end
// Bit 15:13 Reserved
// Bit 12: 0 RW, y_start
#define VIU_OSD2_BLK0_CFG_W2                       ((0x1a3d  << 2) + 0xff000000)
#define VIU_OSD2_BLK1_CFG_W2                       ((0x1a41  << 2) + 0xff000000)
#define VIU_OSD2_BLK2_CFG_W2                       ((0x1a45  << 2) + 0xff000000)
#define VIU_OSD2_BLK3_CFG_W2                       ((0x1a49  << 2) + 0xff000000)
// Bit 31:28 Reserved
// Bit 27:16 RW, h_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, h_start
#define VIU_OSD2_BLK0_CFG_W3                       ((0x1a3e  << 2) + 0xff000000)
#define VIU_OSD2_BLK1_CFG_W3                       ((0x1a42  << 2) + 0xff000000)
#define VIU_OSD2_BLK2_CFG_W3                       ((0x1a46  << 2) + 0xff000000)
#define VIU_OSD2_BLK3_CFG_W3                       ((0x1a4a  << 2) + 0xff000000)
// Bit 31:28 Reserved
// Bit 27:16 RW, v_end
// Bit 15:12 Reserved
// Bit 11: 0 RW, v_start
#define VIU_OSD2_BLK0_CFG_W4                       ((0x1a64  << 2) + 0xff000000)
#define VIU_OSD2_BLK1_CFG_W4                       ((0x1a65  << 2) + 0xff000000)
#define VIU_OSD2_BLK2_CFG_W4                       ((0x1a66  << 2) + 0xff000000)
#define VIU_OSD2_BLK3_CFG_W4                       ((0x1a67  << 2) + 0xff000000)
// Bit    31 RW, burst_len_sel[2] of [2:0]
// Bit    30 RW, byte_swap: In addition to endian control, further define
//               whether to swap upper and lower byte within a 16-bit mem word.
//               0=No swap; 1=Swap data[15:0] to be {data[7:0], data[15:8]}
// Bit    29 RW, div_swap : swap the 2 64bits words in 128 bit word
// Bit 28:24 RW, fifo_lim : when osd fifo is small than the fifo_lim*16, closed the rq port of osd_rd_mif
// Bit 23:22 RW, fifo_ctrl: 00 : for 1 word in 1 burst , 01 : for  2words in 1burst, 10: for 4words in 1burst, 11: reserved
// Bit 21:20 R,  fifo_st. 0=IDLE, 1=FILL, 2=ABORT
// Bit    19 R,  fifo_overflow
//
// Bit 18:12 RW, fifo_depth_val, max value=64: set actual fifo depth to fifo_depth_val*8.
// Bit 11:10 RW, burst_len_sel[1:0] of [2:0]. 0=24(default), 1=32, 2=48, 3=64, 4=96, 5=128.
// Bit  9: 5 RW, hold_fifo_lines[4:0]
// Bit     4 RW, clear_err: one pulse to clear fifo_overflow
// Bit     3 RW, fifo_sync_rst
// Bit  2: 1 RW, endian
// Bit     0 RW, urgent
#define VIU_OSD2_FIFO_CTRL_STAT                    ((0x1a4b  << 2) + 0xff000000)
// Bit 31:24 R, Y or R
// Bit 23:16 R, Cb or G
// Bit 15: 8 R, Cr or B
// Bit  7: 0 R, Output Alpha[8:1]
#define VIU_OSD2_TEST_RDDATA                       ((0x1a4c  << 2) + 0xff000000)
// Bit    15 RW, prot_en: 1=Borrow PROT's FIFO storage, either for rotate or non-rotate.
// Bit 12: 0 RW, effective FIFO size when prot_en=1.
#define VIU_OSD2_PROT_CTRL                         ((0x1a4e  << 2) + 0xff000000)
//     //todo add comment
#define LDIM_STTS_GCLK_CTRL0                       ((0x1ac0  << 2) + 0xff000000)
#define LDIM_STTS_CTRL0                            ((0x1ac1  << 2) + 0xff000000)
#define LDIM_STTS_WIDTHM1_HEIGHTM1                 ((0x1ac2  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_COEF00_01                 ((0x1ac3  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_COEF02_10                 ((0x1ac4  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_COEF11_12                 ((0x1ac5  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_COEF20_21                 ((0x1ac6  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_COEF22                    ((0x1ac7  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_OFFSET0_1                 ((0x1ac8  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_OFFSET2                   ((0x1ac9  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_PRE_OFFSET0_1             ((0x1aca  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_PRE_OFFSET2               ((0x1acb  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_HL_COLOR                  ((0x1acc  << 2) + 0xff000000)
#define LDIM_STTS_MATRIX_PROBE_POS                 ((0x1acd  << 2) + 0xff000000)
//
//     //read only
#define LDIM_STTS_MATRIX_PROBE_COLOR               ((0x1ace  << 2) + 0xff000000)
//
//     //Bit 31, local dimming statistic enable
//     //Bit 29, 1: output region histogram 16bit 0:output region histogram 20bit
//     //Bit 28, eol enable
//     //Bit 27:25, vertical line overlap number for max finding
//     //Bit 24:22, horizontal pixel overlap number, 0: 17 pix, 1: 9 pix, 2: 5 pix, 3: 3 pix, 4: 0 pix
//     //Bit 20, 1,2,1 low pass filter enable before max/hist statistic
//     //Bit 19:16, region H/V position index, refer to VDIN_LDIM_STTS_HIST_SET_REGION
//     //Bit 15:14, 1: region read index auto increase per block read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 2: region read index auto increase per read finished to VDIN_LDIM_STTS_HIST_READ_REGION
//     //			 0/3: disable read index self increase
//     //Bit 13:8, region read sub index, which mux the hist & max-finding result to cbus port, refer to LDIM_STTS_HIST_READ_REGION
//     //Bit 6:0, region read index
#define LDIM_STTS_HIST_REGION_IDX                  ((0x1ad0  << 2) + 0xff000000)
//Bit 28:0, if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h0: read/write hvstart0
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h1: read/write hend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h2: read/write vend01
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h3: read/write hend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h4: read/write vend23
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h5: read/write hend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h6: read/write vend45
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'd7: read/write hend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h8: read/write vend67
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'h9: read/write hend89
//			if VDIN_LDIM_STTS_HIST_REGION_IDX[19:16] == 5'ha: read/write vend89
//     //hvstart0, Bit 28:16 row0 vstart, Bit 12:0 col0 hstart
//     //hend01, Bit 28:16 col1 hend, Bit 12:0 col0 hend
//     //vend01, Bit 28:16 row1 vend, Bit 12:0 row0 vend
//     //hend23, Bit 28:16 col3 hend, Bit 12:0 col2 hend
//     //vend23, Bit 28:16 row3 vend, Bit 12:0 row2 vend
//     //hend45, Bit 28:16 col5 hend, Bit 12:0 col4 hend
//     //vend45, Bit 28:16 row5 vend, Bit 12:0 row4 vend
//     //hend67, Bit 28:16 col7 hend, Bit 12:0 col6 hend
//     //vend67, Bit 28:16 row7 vend, Bit 12:0 row6 vend
//     //hend89, Bit 28:16 col9 hend, Bit 12:0 col8 hend
//     //vend89, Bit 28:16 row9 vend, Bit 12:0 row8 vend
#define LDIM_STTS_HIST_SET_REGION                  ((0x1ad1  << 2) + 0xff000000)
//
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, comp0_hist0}, {max_comp1, comp0_hist1}, {max_comp0, comp0_hist2},
//     //										   comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 1, that is output hist with 16bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 0, that is output 16hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //										   comp0_hist3 ... comp2_hist16
//     //if LDIM_STTS_HIST_REGION_IDX[29] == 0, that is output hist with 20bit data.
//     //if LDIM_STTS_HIST_REGION_IDX[21] == 1, that is output 32hist bins in comp 0.
//     //output sequence as rd_sub_idx from 0~47: {max_comp2, max_comp1, max_comp0}, comp0_hist0, comp0_hist1, comp0_hist2
//     //										   comp0_hist3 ...comp0_hist31 ... comp1_hist16
//
#define LDIM_STTS_HIST_READ_REGION                 ((0x1ad2  << 2) + 0xff000000)
#define LDIM_STTS_HIST_START_RD_REGION             ((0x1ad3  << 2) + 0xff000000)
#define LDIM_STTS_PCTL_TH                          ((0x1aaf  << 2) + 0xff000000)
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di if1 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di if1 luma path
//     `define DI_IF1_URGENT_CTRL						8'ha3
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di inp chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di inp luma path
//     `define DI_INP_URGENT_CTRL						8'ha4
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di mem chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di mem luma path
//     `define DI_MEM_URGENT_CTRL						8'ha5
//     //bit15, auto enable; bit14, canvas write mode ;7:4, high threshold ;3:0 , low threshold  for di chan2 chroma path
//     //bit31, auto enable; bit30, canvas write mode ;23:20, high threshold ;19:16 , low threshold  for di chan2 luma path
//     `define DI_CHAN2_URGENT_CTRL					8'ha6
//OSD blending output horizontal start and end
//Bit 28:16 start
//Bit 12:0 end
//OSD blending output vertical start and end
//Bit 28:16 start
//Bit 12:0 end
#define OSD_BLEND_GEN_CTRL0                        ((0x1aab  << 2) + 0xff000000)
//Bit 31:23 const_out_alpha
//Bit 22:14 const_op_alpha
//Bit 13 if true, OSD2 foreground otherwise OSD1 foreground
//Bit 12  OSD BLENDing enable
//Bit 9:8 alpha_op_sel 00: output alpha use osd1_alpha, 01: use osd2_alpha, else use const_out_alpha
//Bit 5:4 color_op_sel 00: use osd1_alpha, 01: use osd2_alpha, else use const_op_alpha
//Bit 1  OSD2 enable
//Bit 0  OSD1 enable
#define OSD_BLEND_GEN_CTRL1                        ((0x1aac  << 2) + 0xff000000)
//Bit 31    osd1_alpha_premult, if true, osd1 alpha is premultiplied
//Bit 30    osd2_alpha_premult, if true, osd2 alpha is premultiplied
//Bit 23:16 osd blending hold lines
//Bit 13:0  osd blending h_size
#define OSD_BLEND_DUMMY_DATA                       ((0x1aad  << 2) + 0xff000000)
//Bit 29:20   Y/R
//Bit 19:10   CB/G
//Bit 9:0     Cr/B
#define OSD_BLEND_CURRENT_XY                       ((0x1aae  << 2) + 0xff000000)
//Bit 28:16 current_x
//Bit 12:0 current_y
//Bit 7,  highlight_en
//Bit 6   probe_post, if true, probe pixel data after matrix, otherwise probe pixel data before matrix
//Bit 5:4  probe_sel, 00: select matrix 0, 01: select matrix 1,  otherwise select nothing
//Bit 3:2, matrix coef idx selection, 00: select mat0, 01: select mat1, otherwise slect nothing
//Bit 1   mat1 conversion matrix enable
//Bit 0   mat0 conversion matrix enable
#define VIU_OSD2_MATRIX_CTRL                       ((0x1ab0  << 2) + 0xff000000)
//Bit 28:16 coef00
//Bit 12:0  coef01
#define VIU_OSD2_MATRIX_COEF00_01                  ((0x1ab1  << 2) + 0xff000000)
//Bit 28:16 coef02
//Bit 12:0  coef10
#define VIU_OSD2_MATRIX_COEF02_10                  ((0x1ab2  << 2) + 0xff000000)
//Bit 28:16 coef11
//Bit 12:0  coef12
#define VIU_OSD2_MATRIX_COEF11_12                  ((0x1ab3  << 2) + 0xff000000)
//Bit 28:16 coef20
//Bit 12:0  coef21
#define VIU_OSD2_MATRIX_COEF20_21                  ((0x1ab4  << 2) + 0xff000000)
#define VIU_OSD2_MATRIX_COEF22                     ((0x1ab5  << 2) + 0xff000000)
//Bit 26:16 offset0
//Bit 10:0  offset1
#define VIU_OSD2_MATRIX_OFFSET0_1                  ((0x1ab6  << 2) + 0xff000000)
//Bit 10:0  offset2
#define VIU_OSD2_MATRIX_OFFSET2                    ((0x1ab7  << 2) + 0xff000000)
//Bit 26:16 pre_offset0
//Bit 10:0  pre_offset1
#define VIU_OSD2_MATRIX_PRE_OFFSET0_1              ((0x1ab8  << 2) + 0xff000000)
//Bit 10:0  pre_offset2
#define VIU_OSD2_MATRIX_PRE_OFFSET2                ((0x1ab9  << 2) + 0xff000000)
//Read only
//Bit 29:20 component 0
//Bit 19:10 component 1
//Bit 9:0 component 2
#define VIU_OSD2_MATRIX_PROBE_COLOR                ((0x1aba  << 2) + 0xff000000)
//Bit 23:16 component 0
//Bit 15:8  component 1
//Bit 7:0 component 2
#define VIU_OSD2_MATRIX_HL_COLOR                   ((0x1abb  << 2) + 0xff000000)
//28:16 probe x, postion
//12:0  probe y, position
#define VIU_OSD2_MATRIX_PROBE_POS                  ((0x1abc  << 2) + 0xff000000)
////add for OSD1/2 mali_unpack
#define VIU_OSD1_MALI_UNPACK_CTRL                  ((0x1a2f  << 2) + 0xff000000)
//`define VIU_OSD1_MALI_UNPACK_CTRL         8'h4f //todo
//`define VIU_OSD1_MALI_UNPACK_CTRL         8'haf //todo
#define VIU_OSD2_MALI_UNPACK_CTRL                  ((0x1abd  << 2) + 0xff000000)
//`define VIU_OSD2_MATRIX_HL_COLOR          8'hbe
//`define VIU_OSD2_MATRIX_PROBE_POS         8'hbf
//can use 8'hdf 8'hcf
#define VIU_OSD1_DIMM_CTRL                         ((0x1adf  << 2) + 0xff000000)
#define VIU_OSD2_DIMM_CTRL                         ((0x1acf  << 2) + 0xff000000)
#define VIU_GCLK_CTRL                              ((0x1a4f  << 2) + 0xff000000)
//the segment of afbc dec is 8'he0-8'hfe
//`define AFBC_DEC_OFFSET   8'he0
//
// Reading file:  afbc_dec_regs.h
//
// synopsys translate_off
// synopsys translate_on
////===============================////
//// reg
////===============================////
#define AFBC_ENABLE                                ((0x1ae0  << 2) + 0xff000000)
//Bit   31:29,    reserved
//Bit   28:23,    reg_gclk_ctrl_core     unsigned, default = 0
//Bit   22,       reg_fmt_size_sw_mode   unsigned, default = 0, 0:hw mode 1:sw mode for format size
//Bit   21,       reg_addr_link_en  unsigned, default = 1, 1:enable
//Bit   20,       reg_fmt444_comb   unsigned, default = 0, 0: 444 8bit uncomb
//Bit   19,       reg_dos_uncomp_mode   unsigned  , default = 0
//Bit   18:16,    soft_rst          unsigned  , default = 4
//Bit   15:14,    reserved
//Bit   13:12,    ddr_blk_size      unsigned  , default = 1
//Bit   11:9,     cmd_blk_size      unsigned  , default = 3
//Bit   8,        dec_enable        unsigned  , default = 0
//Bit   7:2,      reserved
//Bit   1,        head_len_sel      unsigned  , default = 1
//Bit   0,        dec_frm_start     unsigned  , default = 0
#define AFBC_MODE                                  ((0x1ae1  << 2) + 0xff000000)
//Bit   31:30,    reserved
//Bit   29,       ddr_sz_mode       uns, default = 0 , 0: fixed block ddr size 1 : unfixed block ddr size;
//Bit   28,       blk_mem_mode      uns, default = 0 , 0: fixed 16x128 size; 1 : fixed 12x128 size
//Bit   27:26,    rev_mode          uns, default = 0 , reverse mode
//Bit   25:24,    mif_urgent        uns, default = 3 , info mif and data mif urgent
//Bit   23,       reserved
//Bit   22:16,    hold_line_num     uns, default = 4 ,
//Bit   15:14,    burst_len         uns, default = 2, 0: burst1 1:burst2 2:burst4
//Bit   13:8,     compbits_yuv      uns, default = 0 ,
//                                  bit 1:0,: y  component bitwidth : 00-8bit 01-9bit 10-10bit 11-12bit
//                                  bit 3:2,: u  component bitwidth : 00-8bit 01-9bit 10-10bit 11-12bit
//                                  bit 5:4,: v  component bitwidth : 00-8bit 01-9bit 10-10bit 11-12bit
//Bit   7:6,      vert_skip_y       uns, default = 0 , luma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   5:4,      horz_skip_y       uns, default = 0 , luma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   3:2,      vert_skip_uv      uns, default = 0 , chroma vert skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
//Bit   1:0,      horz_skip_uv      uns, default = 0 , chroma horz skip mode : 00-y0y1, 01-y0, 10-y1, 11-(y0+y1)/2
#define AFBC_SIZE_IN                               ((0x1ae2  << 2) + 0xff000000)
//Bit   31:29,    reserved
//Bit   28:16     hsize_in          uns, default = 1920 , pic horz size in  unit: pixel
//Bit   15:13,    reserved
//Bit   12:0,     vsize_in          uns, default = 1080 , pic vert size in  unit: pixel
#define AFBC_DEC_DEF_COLOR                         ((0x1ae3  << 2) + 0xff000000)
//Bit   31:30,   reserved
//Bit   29:20,   def_color_y        uns, default = 255, afbc dec y default setting value
//Bit   19:10,   def_color_u        uns, default = 128, afbc dec u default setting value
//Bit    9: 0,   def_color_v        uns, default = 128, afbc dec v default setting value
#define AFBC_CONV_CTRL                             ((0x1ae4  << 2) + 0xff000000)
//Bit   31:14,   reserved
//Bit   13:12,   fmt_mode            uns, default = 2, 0:yuv444 1:yuv422 2:yuv420
//Bit   11: 0,   conv_lbuf_len       uns, default = 256, unit=16 pixel need to set = 2^n
#define AFBC_LBUF_DEPTH                            ((0x1ae5  << 2) + 0xff000000)
//Bit   31:28,   reserved
//Bit   27:16,   dec_lbuf_depth      uns, default = 128; // unit= 8 pixel
//Bit   15:12,   reserved
//Bit   11:0,    mif_lbuf_depth      uns, default = 128;
#define AFBC_HEAD_BADDR                            ((0x1ae6  << 2) + 0xff000000)
//Bit   31:0,   mif_info_baddr      uns, default = 32'h0;
#define AFBC_BODY_BADDR                            ((0x1ae7  << 2) + 0xff000000)
//Bit   31:0,   mif_data_baddr      uns, default = 32'h00010000;
#define AFBC_SIZE_OUT                              ((0x1ae8  << 2) + 0xff000000)
//Bit   31:29,   reserved
//Bit   28:16,   hsize_out           uns, default = 1920    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   vsize_out           uns, default = 1080 ; // unit: 1 pixel
#define AFBC_OUT_YSCOPE                            ((0x1ae9  << 2) + 0xff000000)
//Bit   31:29,   reserved
//Bit   28:16,   out_vert_bgn        uns, default = 0    ; // unit: 1 pixel
//Bit   15:13,   reserved
//Bit    12:0,   out_vert_end        uns, default = 1079 ; // unit: 1 pixel
#define AFBC_STAT                                  ((0x1aea  << 2) + 0xff000000)
//Bit   31:0,   ro_dbg_top_info      uns,
#define AFBC_VD_CFMT_CTRL                          ((0x1aeb  << 2) + 0xff000000)
//Bit 31    cfmt_gclk_bit_dis      uns, default = 0    ; //  it true, disable clock, otherwise enable clock
//Bit 30    cfmt_soft_rst_bit      uns, default = 0    ; //  soft rst bit
//Bit 29    reserved
//Bit 28    chfmt_rpt_pix          uns, default = 0    ; //  if true, horizontal formatter use repeating to generate pixel, otherwise use bilinear interpolation
//Bit 27:24 chfmt_ini_phase        uns, default = 0    ; //  horizontal formatter initial phase
//Bit 23    chfmt_rpt_p0_en        uns, default = 0    ; //  horizontal formatter repeat pixel 0 enable
//Bit 22:21 chfmt_yc_ratio         uns, default = 0    ; //  horizontal Y/C ratio, 00: 1:1, 01: 2:1, 10: 4:1
//Bit 20    chfmt_en               uns, default = 0    ; //  horizontal formatter enable
//Bit 19    cvfmt_phase0_always_en uns, default = 0    ; //if true, always use phase0 while vertical formater, meaning always
//          repeat data, no interpolation
//Bit 18    cvfmt_rpt_last_dis     uns, default = 0    ; //if true, disable vertical formatter chroma repeat last line
//Bit 17    cvfmt_phase0_nrpt_en   uns, default = 0    ; //vertical formatter dont need repeat line on phase0, 1: enable, 0: disable
//Bit 16    cvfmt_rpt_line0_en     uns, default = 0    ; //vertical formatter repeat line 0 enable
//Bit 15:12 cvfmt_skip_line_num    uns, default = 0    ; //vertical formatter skip line num at the beginning
//Bit 11:8  cvfmt_ini_phase        uns, default = 0    ; //vertical formatter initial phase
//Bit 7:1   cvfmt_phase_step       uns, default = 0    ; //vertical formatter phase step (3.4)
//Bit 0     cvfmt_en               uns, default = 0    ; //vertical formatter enable
#define AFBC_VD_CFMT_W                             ((0x1aec  << 2) + 0xff000000)
//Bit 31:29 reserved
//Bit 28:16 chfmt_w                uns, default = 0    ;horizontal formatter width
//Bit 15:13 reserved
//Bit 12:0  cvfmt_w                uns, default = 0    ;vertical formatter width
#define AFBC_MIF_HOR_SCOPE                         ((0x1aed  << 2) + 0xff000000)
//Bit   31:26,   reserved
//Bit   25:16,   mif_blk_bgn_h        uns, default = 0  ; // unit: 32 pixel/block hor
//Bit   15:10,   reserved
//Bit    9: 0,   mif_blk_end_h        uns, default = 59 ; // unit: 32 pixel/block hor
#define AFBC_MIF_VER_SCOPE                         ((0x1aee  << 2) + 0xff000000)
//Bit   31:28,   reserved
//Bit   27:16,   mif_blk_bgn_v        uns, default = 0  ; // unit: 32 pixel/block ver
//Bit   15:12,   reserved
//Bit   11: 0,   mif_blk_end_v        uns, default = 269; // unit: 32 pixel/block ver
#define AFBC_PIXEL_HOR_SCOPE                       ((0x1aef  << 2) + 0xff000000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_h        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_h        uns, default = 1919 ; // unit: pixel
#define AFBC_PIXEL_VER_SCOPE                       ((0x1af0  << 2) + 0xff000000)
//Bit   31:29,   reserved
//Bit   28:16,   dec_pixel_bgn_v        uns, default = 0  ; // unit: pixel
//Bit   15:13,   reserved
//Bit   12: 0,   dec_pixel_end_v        uns, default = 1079 ; // unit: pixel
#define AFBC_VD_CFMT_H                             ((0x1af1  << 2) + 0xff000000)
//Bit 31:13,    reserved
//Bit 12:0      cfmt_h  uns, default = 142  ; //vertical formatter height
#define AFBCDEC_IQUANT_ENABLE                      ((0x1af2  << 2) + 0xff000000)
//Bit 31:12        reserved
//Bit  11          reg_quant_expand_en_1  //unsigned, RW, enable for quantization value expansion
//Bit  10          reg_quant_expand_en_0  //unsigned, RW, enable for quantization value expansion
//Bit  9: 8        reg_bcleav_ofst               //signed ,  RW, default = 0  bcleave ofset to get lower range, especially under lossy, for v1/v2, x=0 is equivalent, default = -1;
//Bit  7: 5        reserved
//Bit  4           reg_quant_enable_1        // unsigned ,    RW, default = 0  enable for quant to get some lossy
//Bit  3: 1        reserved
//Bit  0           reg_quant_enable_0        // unsigned ,    RW, default = 0  enable for quant to get some lossy
#define AFBCDEC_IQUANT_LUT_1                       ((0x1af3  << 2) + 0xff000000)
//Bit 31           reserved
//Bit 30:28        reg_iquant_yclut_0_11     // unsigned ,    RW, default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 27           reserved
//Bit 26:24        reg_iquant_yclut_0_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 23           reserved
//Bit 22:20        reg_iquant_yclut_0_9      // unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 19           reserved
//Bit 18:16        reg_iquant_yclut_0_8      // unsigned ,    RW, default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 15           reserved
//Bit 14:12        reg_iquant_yclut_0_7      // unsigned ,    RW, default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 11           reserved
//Bit 10: 8        reg_iquant_yclut_0_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  7           reserved
//Bit  6: 4        reg_iquant_yclut_0_5      // unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  3           reserved
//Bit  2: 0        reg_iquant_yclut_0_4      // unsigned ,    RW, default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_2                       ((0x1af4  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15           reserved
//Bit 14:12        reg_iquant_yclut_0_3      // unsigned ,    RW, default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 11           reserved
//Bit 10: 8        reg_iquant_yclut_0_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  7           reserved
//Bit  6: 4        reg_iquant_yclut_0_1      // unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  3           reserved
//Bit  2: 0        reg_iquant_yclut_0_0      // unsigned ,    RW, default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_3                       ((0x1af5  << 2) + 0xff000000)
//Bit 31           reserved
//Bit 30:28        reg_iquant_yclut_1_11     // unsigned ,    RW, default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 27           reserved
//Bit 26:24        reg_iquant_yclut_1_10     // unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 23           reserved
//Bit 22:20        reg_iquant_yclut_1_9      // unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 19           reserved
//Bit 18:16        reg_iquant_yclut_1_8      // unsigned ,    RW, default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 15           reserved
//Bit 14:12        reg_iquant_yclut_1_7      // unsigned ,    RW, default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 11           reserved
//Bit 10: 8        reg_iquant_yclut_1_6      // unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  7           reserved
//Bit  6: 4        reg_iquant_yclut_1_5      // unsigned ,    RW, default = 5  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  3           reserved
//Bit  2: 0        reg_iquant_yclut_1_4      // unsigned ,    RW, default = 4  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
#define AFBCDEC_IQUANT_LUT_4                       ((0x1af6  << 2) + 0xff000000)
//Bit 31:16        reserved
//Bit 15           reserved
//Bit 14:12        reg_iquant_yclut_1_3      // unsigned ,    RW, default = 3  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit 11           reserved
//Bit 10: 8        reg_iquant_yclut_1_2      // unsigned ,    RW, default = 2  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  7           reserved
//Bit  6: 4        reg_iquant_yclut_1_1      // unsigned ,    RW, default = 1  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
//Bit  3           reserved
//Bit  2: 0        reg_iquant_yclut_1_0      // unsigned ,    RW, default = 0  quantization lut for mintree leavs, iquant=2^lut(bc_leav_q+1)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  afbc_dec_regs.h
//
//
// Closing file:  vregs_clk2.h
//
//
// Reading file:  venc_regs.h
//
//===========================================================================
// Video Interface Registers    0xa00 - 0xbff
//===========================================================================
// -----------------------------------------------
// REG_BASE:  VENC_VCBUS_BASE = 0x1b
// -----------------------------------------------
// bit 15:8 -- vfifo2vd_vd_sel
// bit 0 -- vfifo2vd_en
#define ENCP_VFIFO2VD_CTL                          ((0x1b58  << 2) + 0xff000000)
// bit 12:0 -- vfifo2vd_pixel_start
#define ENCP_VFIFO2VD_PIXEL_START                  ((0x1b59  << 2) + 0xff000000)
// bit 12:00 -- vfifo2vd_pixel_end
#define ENCP_VFIFO2VD_PIXEL_END                    ((0x1b5a  << 2) + 0xff000000)
// bit 10:0 -- vfifo2vd_line_top_start
#define ENCP_VFIFO2VD_LINE_TOP_START               ((0x1b5b  << 2) + 0xff000000)
// bit 10:00 -- vfifo2vd_line_top_end
#define ENCP_VFIFO2VD_LINE_TOP_END                 ((0x1b5c  << 2) + 0xff000000)
// bit 10:00 -- vfifo2vd_line_bot_start
#define ENCP_VFIFO2VD_LINE_BOT_START               ((0x1b5d  << 2) + 0xff000000)
// bit 10:00 -- vfifo2vd_line_bot_end
#define ENCP_VFIFO2VD_LINE_BOT_END                 ((0x1b5e  << 2) + 0xff000000)
// Route the hsync and vsync signals round the chip. There are three
// sources and users of these signals: VIU, internal video encoder, and
// the pins on the chip. Some muxing is still being done in the VIU. It
// was not moved to the venc module so that the same exact VIU code could
// be used both in Twister and Twister2000.
// Bit 2: venc_sync_source (1=>pins, 0=>viu)
// Bit 1: viu_sync_source (1=>pins, 0=>venc)
// Bit 0: vpins_sync_source (1=>venc, 0=>viu)
#define VENC_SYNC_ROUTE                            ((0x1b60  << 2) + 0xff000000)
		//			 encoder address space is assigned
		//			 to the video encoder interface status
		//			 register
#define VENC_VIDEO_EXSRC                           ((0x1b61  << 2) + 0xff000000)
#define VENC_DVI_SETTING                           ((0x1b62  << 2) + 0xff000000)
#define VENC_C656_CTRL                             ((0x1b63  << 2) + 0xff000000)
#define VENC_UPSAMPLE_CTRL0                        ((0x1b64  << 2) + 0xff000000)
#define VENC_UPSAMPLE_CTRL1                        ((0x1b65  << 2) + 0xff000000)
#define VENC_UPSAMPLE_CTRL2                        ((0x1b66  << 2) + 0xff000000)
// Invert control for tcon output
// bit[15:14] -- vsync, hsync,
// bit[13:0] --  oev3, oev2, cpv2, cph3, cph2, cph1, oeh, vcom, stv2, stv1, cpv1, oev1, sth1, sth2
#define TCON_INVERT_CTL                            ((0x1b67  << 2) + 0xff000000)
#define VENC_VIDEO_PROG_MODE                       ((0x1b68  << 2) + 0xff000000)
//---- Venc pixel/line info
#define VENC_ENCI_LINE                             ((0x1b69  << 2) + 0xff000000)
#define VENC_ENCI_PIXEL                            ((0x1b6a  << 2) + 0xff000000)
#define VENC_ENCP_LINE                             ((0x1b6b  << 2) + 0xff000000)
#define VENC_ENCP_PIXEL                            ((0x1b6c  << 2) + 0xff000000)
//---- Status
#define VENC_STATA                                 ((0x1b6d  << 2) + 0xff000000)
//---- Interrupt setting
#define VENC_INTCTRL                               ((0x1b6e  << 2) + 0xff000000)
#define VENC_INTFLAG                               ((0x1b6f  << 2) + 0xff000000)
//--------- Video test configuration
#define VENC_VIDEO_TST_EN                          ((0x1b70  << 2) + 0xff000000)
#define VENC_VIDEO_TST_MDSEL                       ((0x1b71  << 2) + 0xff000000)
#define VENC_VIDEO_TST_Y                           ((0x1b72  << 2) + 0xff000000)
#define VENC_VIDEO_TST_CB                          ((0x1b73  << 2) + 0xff000000)
#define VENC_VIDEO_TST_CR                          ((0x1b74  << 2) + 0xff000000)
#define VENC_VIDEO_TST_CLRBAR_STRT                 ((0x1b75  << 2) + 0xff000000)
#define VENC_VIDEO_TST_CLRBAR_WIDTH                ((0x1b76  << 2) + 0xff000000)
#define VENC_VIDEO_TST_VDCNT_STSET                 ((0x1b77  << 2) + 0xff000000)
//----- Video dac setting
#define VENC_VDAC_DACSEL0                          ((0x1b78  << 2) + 0xff000000)
#define VENC_VDAC_DACSEL1                          ((0x1b79  << 2) + 0xff000000)
#define VENC_VDAC_DACSEL2                          ((0x1b7a  << 2) + 0xff000000)
#define VENC_VDAC_DACSEL3                          ((0x1b7b  << 2) + 0xff000000)
#define VENC_VDAC_DACSEL4                          ((0x1b7c  << 2) + 0xff000000)
#define VENC_VDAC_DACSEL5                          ((0x1b7d  << 2) + 0xff000000)
#define VENC_VDAC_SETTING                          ((0x1b7e  << 2) + 0xff000000)
#define VENC_VDAC_TST_VAL                          ((0x1b7f  << 2) + 0xff000000)
#define VENC_VDAC_DAC0_GAINCTRL                    ((0x1bf0  << 2) + 0xff000000)
#define VENC_VDAC_DAC0_OFFSET                      ((0x1bf1  << 2) + 0xff000000)
#define VENC_VDAC_DAC1_GAINCTRL                    ((0x1bf2  << 2) + 0xff000000)
#define VENC_VDAC_DAC1_OFFSET                      ((0x1bf3  << 2) + 0xff000000)
#define VENC_VDAC_DAC2_GAINCTRL                    ((0x1bf4  << 2) + 0xff000000)
#define VENC_VDAC_DAC2_OFFSET                      ((0x1bf5  << 2) + 0xff000000)
#define VENC_VDAC_DAC3_GAINCTRL                    ((0x1bf6  << 2) + 0xff000000)
#define VENC_VDAC_DAC3_OFFSET                      ((0x1bf7  << 2) + 0xff000000)
#define VENC_VDAC_DAC4_GAINCTRL                    ((0x1bf8  << 2) + 0xff000000)
#define VENC_VDAC_DAC4_OFFSET                      ((0x1bf9  << 2) + 0xff000000)
#define VENC_VDAC_DAC5_GAINCTRL                    ((0x1bfa  << 2) + 0xff000000)
#define VENC_VDAC_DAC5_OFFSET                      ((0x1bfb  << 2) + 0xff000000)
#define VENC_VDAC_FIFO_CTRL                        ((0x1bfc  << 2) + 0xff000000)
#define ENCL_TCON_INVERT_CTL                       ((0x1bfd  << 2) + 0xff000000)
//
// Closing file:  venc_regs.h
//
//
// Reading file:  enc480p_regs.h
//
// synopsys translate_off
// synopsys translate_on
//===========================================================================
// Video Encoder 480p Registers    0xb80 - 0xbef
//===========================================================================
//-------- Video basic setting
#define ENCP_VIDEO_EN                              ((0x1b80  << 2) + 0xff000000)
#define ENCP_VIDEO_SYNC_MODE                       ((0x1b81  << 2) + 0xff000000)
#define ENCP_MACV_EN                               ((0x1b82  << 2) + 0xff000000)
#define ENCP_VIDEO_Y_SCL                           ((0x1b83  << 2) + 0xff000000)
#define ENCP_VIDEO_PB_SCL                          ((0x1b84  << 2) + 0xff000000)
#define ENCP_VIDEO_PR_SCL                          ((0x1b85  << 2) + 0xff000000)
#define ENCP_VIDEO_SYNC_SCL                        ((0x1b86  << 2) + 0xff000000)
#define ENCP_VIDEO_MACV_SCL                        ((0x1b87  << 2) + 0xff000000)
#define ENCP_VIDEO_Y_OFFST                         ((0x1b88  << 2) + 0xff000000)
#define ENCP_VIDEO_PB_OFFST                        ((0x1b89  << 2) + 0xff000000)
#define ENCP_VIDEO_PR_OFFST                        ((0x1b8a  << 2) + 0xff000000)
#define ENCP_VIDEO_SYNC_OFFST                      ((0x1b8b  << 2) + 0xff000000)
#define ENCP_VIDEO_MACV_OFFST                      ((0x1b8c  << 2) + 0xff000000)
//----- Video mode
#define ENCP_VIDEO_MODE                            ((0x1b8d  << 2) + 0xff000000)
#define ENCP_VIDEO_MODE_ADV                        ((0x1b8e  << 2) + 0xff000000)
//--------------- Debug pins
#define ENCP_DBG_PX_RST                            ((0x1b90  << 2) + 0xff000000)
#define ENCP_DBG_LN_RST                            ((0x1b91  << 2) + 0xff000000)
#define ENCP_DBG_PX_INT                            ((0x1b92  << 2) + 0xff000000)
#define ENCP_DBG_LN_INT                            ((0x1b93  << 2) + 0xff000000)
//----------- Video Advanced setting
#define ENCP_VIDEO_YFP1_HTIME                      ((0x1b94  << 2) + 0xff000000)
#define ENCP_VIDEO_YFP2_HTIME                      ((0x1b95  << 2) + 0xff000000)
#define ENCP_VIDEO_YC_DLY                          ((0x1b96  << 2) + 0xff000000)
#define ENCP_VIDEO_MAX_PXCNT                       ((0x1b97  << 2) + 0xff000000)
#define ENCP_VIDEO_HSPULS_BEGIN                    ((0x1b98  << 2) + 0xff000000)
#define ENCP_VIDEO_HSPULS_END                      ((0x1b99  << 2) + 0xff000000)
#define ENCP_VIDEO_HSPULS_SWITCH                   ((0x1b9a  << 2) + 0xff000000)
#define ENCP_VIDEO_VSPULS_BEGIN                    ((0x1b9b  << 2) + 0xff000000)
#define ENCP_VIDEO_VSPULS_END                      ((0x1b9c  << 2) + 0xff000000)
#define ENCP_VIDEO_VSPULS_BLINE                    ((0x1b9d  << 2) + 0xff000000)
#define ENCP_VIDEO_VSPULS_ELINE                    ((0x1b9e  << 2) + 0xff000000)
#define ENCP_VIDEO_EQPULS_BEGIN                    ((0x1b9f  << 2) + 0xff000000)
#define ENCP_VIDEO_EQPULS_END                      ((0x1ba0  << 2) + 0xff000000)
#define ENCP_VIDEO_EQPULS_BLINE                    ((0x1ba1  << 2) + 0xff000000)
#define ENCP_VIDEO_EQPULS_ELINE                    ((0x1ba2  << 2) + 0xff000000)
#define ENCP_VIDEO_HAVON_END                       ((0x1ba3  << 2) + 0xff000000)
#define ENCP_VIDEO_HAVON_BEGIN                     ((0x1ba4  << 2) + 0xff000000)
#define ENCP_VIDEO_VAVON_ELINE                     ((0x1baf  << 2) + 0xff000000)
#define ENCP_VIDEO_VAVON_BLINE                     ((0x1ba6  << 2) + 0xff000000)
#define ENCP_VIDEO_HSO_BEGIN                       ((0x1ba7  << 2) + 0xff000000)
#define ENCP_VIDEO_HSO_END                         ((0x1ba8  << 2) + 0xff000000)
#define ENCP_VIDEO_VSO_BEGIN                       ((0x1ba9  << 2) + 0xff000000)
#define ENCP_VIDEO_VSO_END                         ((0x1baa  << 2) + 0xff000000)
#define ENCP_VIDEO_VSO_BLINE                       ((0x1bab  << 2) + 0xff000000)
#define ENCP_VIDEO_VSO_ELINE                       ((0x1bac  << 2) + 0xff000000)
#define ENCP_VIDEO_SYNC_WAVE_CURVE                 ((0x1bad  << 2) + 0xff000000)
#define ENCP_VIDEO_MAX_LNCNT                       ((0x1bae  << 2) + 0xff000000)
#define ENCP_VIDEO_SY_VAL                          ((0x1bb0  << 2) + 0xff000000)
#define ENCP_VIDEO_SY2_VAL                         ((0x1bb1  << 2) + 0xff000000)
#define ENCP_VIDEO_BLANKY_VAL                      ((0x1bb2  << 2) + 0xff000000)
#define ENCP_VIDEO_BLANKPB_VAL                     ((0x1bb3  << 2) + 0xff000000)
#define ENCP_VIDEO_BLANKPR_VAL                     ((0x1bb4  << 2) + 0xff000000)
#define ENCP_VIDEO_HOFFST                          ((0x1bb5  << 2) + 0xff000000)
#define ENCP_VIDEO_VOFFST                          ((0x1bb6  << 2) + 0xff000000)
#define ENCP_VIDEO_RGB_CTRL                        ((0x1bb7  << 2) + 0xff000000)
#define ENCP_VIDEO_FILT_CTRL                       ((0x1bb8  << 2) + 0xff000000)
#define ENCP_VIDEO_OFLD_VPEQ_OFST                  ((0x1bb9  << 2) + 0xff000000)
#define ENCP_VIDEO_OFLD_VOAV_OFST                  ((0x1bba  << 2) + 0xff000000)
#define ENCP_VIDEO_MATRIX_CB                       ((0x1bbb  << 2) + 0xff000000)
#define ENCP_VIDEO_MATRIX_CR                       ((0x1bbc  << 2) + 0xff000000)
#define ENCP_VIDEO_RGBIN_CTRL                      ((0x1bbd  << 2) + 0xff000000)
//------------------Macrovision advanced setting
#define ENCP_MACV_BLANKY_VAL                       ((0x1bc0  << 2) + 0xff000000)
#define ENCP_MACV_MAXY_VAL                         ((0x1bc1  << 2) + 0xff000000)
#define ENCP_MACV_1ST_PSSYNC_STRT                  ((0x1bc2  << 2) + 0xff000000)
#define ENCP_MACV_PSSYNC_STRT                      ((0x1bc3  << 2) + 0xff000000)
#define ENCP_MACV_AGC_STRT                         ((0x1bc4  << 2) + 0xff000000)
#define ENCP_MACV_AGC_END                          ((0x1bc5  << 2) + 0xff000000)
#define ENCP_MACV_WAVE_END                         ((0x1bc6  << 2) + 0xff000000)
#define ENCP_MACV_STRTLINE                         ((0x1bc7  << 2) + 0xff000000)
#define ENCP_MACV_ENDLINE                          ((0x1bc8  << 2) + 0xff000000)
#define ENCP_MACV_TS_CNT_MAX_L                     ((0x1bc9  << 2) + 0xff000000)
#define ENCP_MACV_TS_CNT_MAX_H                     ((0x1bca  << 2) + 0xff000000)
#define ENCP_MACV_TIME_DOWN                        ((0x1bcb  << 2) + 0xff000000)
#define ENCP_MACV_TIME_LO                          ((0x1bcc  << 2) + 0xff000000)
#define ENCP_MACV_TIME_UP                          ((0x1bcd  << 2) + 0xff000000)
#define ENCP_MACV_TIME_RST                         ((0x1bce  << 2) + 0xff000000)
//---------------- VBI control -------------------
#define ENCP_VBI_CTRL                              ((0x1bd0  << 2) + 0xff000000)
#define ENCP_VBI_SETTING                           ((0x1bd1  << 2) + 0xff000000)
#define ENCP_VBI_BEGIN                             ((0x1bd2  << 2) + 0xff000000)
#define ENCP_VBI_WIDTH                             ((0x1bd3  << 2) + 0xff000000)
#define ENCP_VBI_HVAL                              ((0x1bd4  << 2) + 0xff000000)
#define ENCP_VBI_DATA0                             ((0x1bd5  << 2) + 0xff000000)
#define ENCP_VBI_DATA1                             ((0x1bd6  << 2) + 0xff000000)
//----------------C656 OUT Control------------- Grant
#define C656_HS_ST                                 ((0x1be0  << 2) + 0xff000000)
#define C656_HS_ED                                 ((0x1be1  << 2) + 0xff000000)
#define C656_VS_LNST_E                             ((0x1be2  << 2) + 0xff000000)
#define C656_VS_LNST_O                             ((0x1be3  << 2) + 0xff000000)
#define C656_VS_LNED_E                             ((0x1be4  << 2) + 0xff000000)
#define C656_VS_LNED_O                             ((0x1be5  << 2) + 0xff000000)
#define C656_FS_LNST                               ((0x1be6  << 2) + 0xff000000)
#define C656_FS_LNED                               ((0x1be7  << 2) + 0xff000000)
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  enc480p_regs.h
//
//
// Reading file:  enci_regs.h
//
//===========================================================================
// Video Interface Registers    0xb00 - 0xb57
//===========================================================================
#define ENCI_VIDEO_MODE                            ((0x1b00  << 2) + 0xff000000)
#define ENCI_VIDEO_MODE_ADV                        ((0x1b01  << 2) + 0xff000000)
#define ENCI_VIDEO_FSC_ADJ                         ((0x1b02  << 2) + 0xff000000)
#define ENCI_VIDEO_BRIGHT                          ((0x1b03  << 2) + 0xff000000)
#define ENCI_VIDEO_CONT                            ((0x1b04  << 2) + 0xff000000)
#define ENCI_VIDEO_SAT                             ((0x1b05  << 2) + 0xff000000)
#define ENCI_VIDEO_HUE                             ((0x1b06  << 2) + 0xff000000)
#define ENCI_VIDEO_SCH                             ((0x1b07  << 2) + 0xff000000)
#define ENCI_SYNC_MODE                             ((0x1b08  << 2) + 0xff000000)
#define ENCI_SYNC_CTRL                             ((0x1b09  << 2) + 0xff000000)
#define ENCI_SYNC_HSO_BEGIN                        ((0x1b0a  << 2) + 0xff000000)
#define ENCI_SYNC_HSO_END                          ((0x1b0b  << 2) + 0xff000000)
#define ENCI_SYNC_VSO_EVN                          ((0x1b0c  << 2) + 0xff000000)
#define ENCI_SYNC_VSO_ODD                          ((0x1b0d  << 2) + 0xff000000)
#define ENCI_SYNC_VSO_EVNLN                        ((0x1b0e  << 2) + 0xff000000)
#define ENCI_SYNC_VSO_ODDLN                        ((0x1b0f  << 2) + 0xff000000)
#define ENCI_SYNC_HOFFST                           ((0x1b10  << 2) + 0xff000000)
#define ENCI_SYNC_VOFFST                           ((0x1b11  << 2) + 0xff000000)
#define ENCI_SYNC_ADJ                              ((0x1b12  << 2) + 0xff000000)
#define ENCI_RGB_SETTING                           ((0x1b13  << 2) + 0xff000000)
//`define	ENCI_CMPN_MATRIX_CB		8'h14
//`define	ENCI_CMPN_MATRIX_CR		8'h15
#define ENCI_DE_H_BEGIN                            ((0x1b16  << 2) + 0xff000000)
#define ENCI_DE_H_END                              ((0x1b17  << 2) + 0xff000000)
#define ENCI_DE_V_BEGIN_EVEN                       ((0x1b18  << 2) + 0xff000000)
#define ENCI_DE_V_END_EVEN                         ((0x1b19  << 2) + 0xff000000)
#define ENCI_DE_V_BEGIN_ODD                        ((0x1b1a  << 2) + 0xff000000)
#define ENCI_DE_V_END_ODD                          ((0x1b1b  << 2) + 0xff000000)
#define ENCI_VBI_SETTING                           ((0x1b20  << 2) + 0xff000000)
#define ENCI_VBI_CCDT_EVN                          ((0x1b21  << 2) + 0xff000000)
#define ENCI_VBI_CCDT_ODD                          ((0x1b22  << 2) + 0xff000000)
#define ENCI_VBI_CC525_LN                          ((0x1b23  << 2) + 0xff000000)
#define ENCI_VBI_CC625_LN                          ((0x1b24  << 2) + 0xff000000)
#define ENCI_VBI_WSSDT                             ((0x1b25  << 2) + 0xff000000)
#define ENCI_VBI_WSS_LN                            ((0x1b26  << 2) + 0xff000000)
#define ENCI_VBI_CGMSDT_L                          ((0x1b27  << 2) + 0xff000000)
#define ENCI_VBI_CGMSDT_H                          ((0x1b28  << 2) + 0xff000000)
#define ENCI_VBI_CGMS_LN                           ((0x1b29  << 2) + 0xff000000)
#define ENCI_VBI_TTX_HTIME                         ((0x1b2a  << 2) + 0xff000000)
#define ENCI_VBI_TTX_LN                            ((0x1b2b  << 2) + 0xff000000)
#define ENCI_VBI_TTXDT0                            ((0x1b2c  << 2) + 0xff000000)
#define ENCI_VBI_TTXDT1                            ((0x1b2d  << 2) + 0xff000000)
#define ENCI_VBI_TTXDT2                            ((0x1b2e  << 2) + 0xff000000)
#define ENCI_VBI_TTXDT3                            ((0x1b2f  << 2) + 0xff000000)
#define ENCI_MACV_N0                               ((0x1b30  << 2) + 0xff000000)
#define ENCI_MACV_N1                               ((0x1b31  << 2) + 0xff000000)
#define ENCI_MACV_N2                               ((0x1b32  << 2) + 0xff000000)
#define ENCI_MACV_N3                               ((0x1b33  << 2) + 0xff000000)
#define ENCI_MACV_N4                               ((0x1b34  << 2) + 0xff000000)
#define ENCI_MACV_N5                               ((0x1b35  << 2) + 0xff000000)
#define ENCI_MACV_N6                               ((0x1b36  << 2) + 0xff000000)
#define ENCI_MACV_N7                               ((0x1b37  << 2) + 0xff000000)
#define ENCI_MACV_N8                               ((0x1b38  << 2) + 0xff000000)
#define ENCI_MACV_N9                               ((0x1b39  << 2) + 0xff000000)
#define ENCI_MACV_N10         