#ifndef __AT24EXT_H
#define __AT24EXT_H

#include <linux/string.h>
#include <linux/amlogic/media/vout/lcd/lcd_unifykey.h>
#include "at24common.h"

const unsigned int SN_OFFSET = 0U;
const unsigned int SN_LEN = 16U; // 预留区间： [0~31]
const unsigned int MAC_OFFSET = 31U;
const unsigned int MAC_LEN = 17U;

char *key_sn = "usid";
char *key_mac = "mac";

static void align_at24c02_and_unifykey(struct at24_data *at24, unsigned offset, char* key, unsigned int len)
{
    char at24c02_args[128];
    char unifykey_args[128];
    bool is_at24_valid = false;
    bool is_unifykey_valid = false;
    int i;
    pr_info("at24ext: Call at24ext_probe: %s, %d\n",  key, len);

    at24_read(at24, offset, at24c02_args, len);
    key_unify_read(get_ukdev(), key, unifykey_args, len, &len);

    is_at24_valid = strlen(at24c02_args) == len;
    is_unifykey_valid = strlen(unifykey_args) == len;
    pr_info("at24ext:  at24c02_args(%d-%d-%d):%s, unifykey_args(%d-%d-%d): %s, match: %d .\n",
            sizeof(at24c02_args), strlen(at24c02_args), is_at24_valid, at24c02_args,
            sizeof(unifykey_args), strlen(unifykey_args), is_unifykey_valid, unifykey_args,
            strcasecmp(at24c02_args, unifykey_args));

    for(i = len - 1; i >= 0; i--) {
        if ((int)at24c02_args[i] == 255) {
            is_at24_valid = false;
            pr_err("at24ext: exist invalid value: %d.\n", i);
            break;
        }
    }

    if (!is_at24_valid && !is_unifykey_valid) {
        pr_err("at24ext: key is not exist.");
        return;
    }

    if (is_at24_valid && is_unifykey_valid) {
        if (strcasecmp(at24c02_args, unifykey_args) == 0) {
            pr_info("at24ext: Is equal, Ignore align key.");
            return;
        }
    }

    if (is_unifykey_valid) {
        pr_info("at24ext: Need update at24c02.");
        at24_write(at24, offset, unifykey_args, len);
        return;
    }

    pr_info("at24ext: Need update Unifykey.");
    key_unify_write(get_ukdev(), key, at24c02_args, len);
}

int at24ext_probe(struct i2c_client *client, struct at24_data *at24)
{
    align_at24c02_and_unifykey(at24, SN_OFFSET, key_sn, SN_LEN);
    align_at24c02_and_unifykey(at24, MAC_OFFSET, key_mac, MAC_LEN);

    return 0;
}

#endif