#ifndef _NTP8918_H
#define _NTP8918_H

struct ntp8918_reg_eq {
    unsigned char reg;
    unsigned int def;
};

struct ntp8918_reg_default {
    unsigned char reg;
    unsigned char def;
};

unsigned int ntp8918_reset_pin;

struct ntp8918_reg_default ntp8918_reg_defaults[] = {
    { 0x0c, 0x00},
    { 0x00, 0x00},
    { 0x01, 0x00},
    { 0x02, 0x00},
    { 0x03, 0x4e},
    { 0x04, 0x4e},
    { 0x05, 0x4e},
    { 0x06, 0x4e},
    { 0x0e, 0x15},
    { 0x0f, 0x15},
    { 0x10, 0x07},
    { 0x11, 0x07},
    { 0x12, 0x55},
    { 0x13, 0x55},
    { 0x14, 0x05},
    { 0x15, 0x05},
    { 0x19, 0x00},
    { 0x20, 0xaf},
    { 0x21, 0x01},
    { 0x22, 0xaf},
    { 0x23, 0x01},
    { 0x2a, 0x2e},
    { 0x2b, 0x01},
    { 0x26, 0xae},
    { 0x27, 0x41},
    { 0x24, 0x00},
    { 0x25, 0x0a},
    { 0x4d, 0x0a},
    { 0x4e, 0x0a},
    { 0x4f, 0x0a},
    { 0x2d, 0x0a},
    { 0x07, 0x00},
    { 0x0c, 0xff},
    { 0x16, 0x00},
    { 0x17, 0xb8},
    { 0x18, 0xb8},
    { 0x3c, 0x55},
    { 0x41, 0x12},
    { 0x62, 0x00},
    { 0x63, 0x05},
    { 0x3E, 0x01},  //set AMP-Lout
    { 0x3F, 0x1a},  //set AMP-Lout
    { 0x0c, 0x00},
};

struct ntp8918_reg_default ntp8918_standardMode_section0[] = {
	{ 0x0B, 0x01 },
	{ 0x0C, 0x00 },
	{ 0x33, 0x03 },
	{ 0x34, 0x03 },
	{ 0x35, 0x06 },
	{ 0x0B, 0x01 },
	{ 0x02, 0x00 },
	{ 0x7E, 0x03 },
};
struct ntp8918_reg_eq ntp8918_standardMode_section1[] = { //DRC Coefficients
	{ 0x32, 0x096A3AFA },
	{ 0x33, 0x096A3AFA },
	{ 0x34, 0x20000000 },
	{ 0x35, 0x107C5714 },
	{ 0x36, 0x20000000 },
	{ 0x37, 0x0257D806 },
	{ 0x38, 0x0357D806 },
	{ 0x39, 0x0257D806 },
	{ 0x3A, 0x117E24D1 },
	{ 0x3B, 0x10FC5720 },
	{ 0x3C, 0x107E2B8A },
	{ 0x3D, 0x10FE2B8A },
	{ 0x3E, 0x20000000 },
	{ 0x3F, 0x107C5714 },
	{ 0x40, 0x20000000 },
	{ 0x41, 0x107E2831 },
	{ 0x42, 0x11FE2831 },
	{ 0x43, 0x107E2831 },
	{ 0x44, 0x117E24D1 },
	{ 0x45, 0x10FC5720 },
	{ 0x46, 0x11000000 },
	{ 0x47, 0x20000000 },
	{ 0x48, 0x20000000 },
	{ 0x49, 0x20000000 },
	{ 0x4A, 0x20000000 },
	{ 0x4B, 0x11000000 },
	{ 0x4C, 0x20000000 },
	{ 0x4D, 0x20000000 },
	{ 0x4E, 0x20000000 },
	{ 0x4F, 0x20000000 },
};
struct ntp8918_reg_default ntp8918_standardMode_section2[] = {
	{ 0x7E, 0x00 },
	{ 0x33, 0x00 },
	{ 0x20, 0xA8 },
	{ 0x21, 0x01 },
	{ 0x22, 0xA8 },
	{ 0x23, 0x01 },
	{ 0x26, 0xA8 },
	{ 0x27, 0x41 },
	{ 0x2A, 0x6A },
	{ 0x2B, 0x01 },
	{ 0x29, 0x11 },
	{ 0x2C, 0x00 },
	{ 0x17, 0xB1 },
	{ 0x18, 0xB1 },
	{ 0x43, 0x02 },
	{ 0x3C, 0x73 },
	{ 0x33, 0x03 },
	{ 0x7E, 0x03 },
};
struct ntp8918_reg_eq ntp8918_standardMode_section3[] = { // BQ Coefficients
	{ 0x00, 0x107EECD9 },
	{ 0x01, 0x11FEECD9 },
	{ 0x02, 0x107EECD9 },
	{ 0x03, 0x117EEC48 },
	{ 0x04, 0x10FDDAD4 },
	{ 0x05, 0x107F3EFB },
	{ 0x06, 0x11FF3EFB },
	{ 0x07, 0x107F3EFB },
	{ 0x08, 0x117F3E6A },
	{ 0x09, 0x10FE7F19 },
	{ 0x0A, 0x11001528 },
	{ 0x0B, 0x11FF5A8F },
	{ 0x0C, 0x107E8ED5 },
	{ 0x0D, 0x117F5A8F },
	{ 0x0E, 0x10FEB926 },
	{ 0x0F, 0x1100E659 },
	{ 0x10, 0x11F8CF70 },
	{ 0x11, 0x10704CC2 },
	{ 0x12, 0x1178CF70 },
	{ 0x13, 0x10F21975 },
	{ 0x14, 0x1100AEA5 },
	{ 0x15, 0x11EA46BB },
	{ 0x16, 0x10684592 },
	{ 0x17, 0x116A46BB },
	{ 0x18, 0x10E9A2DB },
	{ 0x19, 0x107F298D },
	{ 0x1A, 0x11FE4C80 },
	{ 0x1B, 0x107D7A9B },
	{ 0x1C, 0x117E4C80 },
	{ 0x1D, 0x10FCA428 },
	{ 0x1E, 0x11000EFF },
	{ 0x1F, 0x11FF8B24 },
	{ 0x20, 0x107EFA50 },
	{ 0x21, 0x117F8B24 },
	{ 0x22, 0x10FF184F },
	{ 0x23, 0x11004A08 },
	{ 0x24, 0x11FE8E27 },
	{ 0x25, 0x107C9E21 },
	{ 0x26, 0x117E8E27 },
	{ 0x27, 0x10FD3231 },
	{ 0x28, 0x107EC95A },
	{ 0x29, 0x11F9AA8B },
	{ 0x2A, 0x107569D3 },
	{ 0x2B, 0x1179AA8B },
	{ 0x2C, 0x10F4332D },
	{ 0x2D, 0x110024BB },
	{ 0x2E, 0x11FDAE04 },
	{ 0x2F, 0x107B3F17 },
	{ 0x30, 0x117DAE04 },
	{ 0x31, 0x10FB888E },
	{ 0x5C, 0x107B0384 },
	{ 0x5D, 0x11E5C603 },
	{ 0x5E, 0x10547FA7 },
	{ 0x5F, 0x1165C603 },
	{ 0x60, 0x10CF832B },
	{ 0x61, 0x114A0197 },
	{ 0x62, 0x12C6B581 },
	{ 0x63, 0x1143CADE },
	{ 0x64, 0x117AAEFF },
	{ 0x65, 0x10F620E3 },
	{ 0x66, 0x1073334A },
	{ 0x67, 0x11B186D3 },
	{ 0x68, 0x1010553B },
	{ 0x69, 0x113186D3 },
	{ 0x6A, 0x10838885 },
	{ 0x6B, 0x110487A3 },
	{ 0x6C, 0x11ADECCE },
	{ 0x6D, 0x104B04CC },
	{ 0x6E, 0x112DECCE },
	{ 0x6F, 0x10D41411 },
	{ 0x70, 0x1112DA27 },
	{ 0x71, 0x0FFBF6FC },
	{ 0x72, 0x0E0E03A4 },
	{ 0x73, 0x0F7BF6FC },
	{ 0x74, 0x0F926A6D },
	{ 0x75, 0x1100457F },
	{ 0x76, 0x11FF0FA1 },
	{ 0x77, 0x107D99C0 },
	{ 0x78, 0x117F0FA1 },
	{ 0x79, 0x10FE24BD },
};
struct ntp8918_reg_default ntp8918_standardMode_section4[] = {
	{ 0x7E, 0x08 },
};
struct ntp8918_reg_eq ntp8918_standardMode_section5[] = { // APEQ Coefficients
	{ 0x00, 0x10000000 },
	{ 0x01, 0x10000000 },
	{ 0x02, 0x10000000 },
	{ 0x03, 0x10000000 },
	{ 0x04, 0x10000000 },
	{ 0x05, 0x10000000 },
	{ 0x06, 0x11000000 },
	{ 0x07, 0x11000000 },
	{ 0x08, 0x11000000 },
	{ 0x09, 0x11000000 },
	{ 0x0A, 0x11000000 },
	{ 0x0B, 0x11000000 },
	{ 0x0C, 0x11000000 },
	{ 0x0D, 0x11000000 },
	{ 0x0E, 0x11000000 },
	{ 0x0F, 0x11000000 },
	{ 0x10, 0x11000000 },
	{ 0x11, 0x11000000 },
	{ 0x12, 0x20000000 },
	{ 0x13, 0x20000000 },
	{ 0x14, 0x20000000 },
	{ 0x15, 0x20000000 },
	{ 0x16, 0x20000000 },
	{ 0x17, 0x20000000 },
	{ 0x1F, 0x11000000 },
	{ 0x20, 0x11000000 },
	{ 0x21, 0x11000000 },
	{ 0x22, 0x11000000 },
	{ 0x23, 0x11000000 },
	{ 0x24, 0x11000000 },
};
struct ntp8918_reg_default ntp8918_standardMode_section6[] = {
	{ 0x7E, 0x00 },
	{ 0x33, 0x00 },
	{ 0x19, 0x04 },
	{ 0x1A, 0x00 },
	{ 0x1B, 0x00 },
	{ 0x1C, 0x00 },
	{ 0x1D, 0x00 },
	{ 0x1E, 0x00 },
	{ 0x1F, 0x00 },
	{ 0x0E, 0x15 },
	{ 0x0F, 0x15 },
	{ 0x10, 0x07 },
	{ 0x11, 0x07 },
	{ 0x12, 0x55 },
	{ 0x13, 0x55 },
	{ 0x14, 0xF5 },
	{ 0x15, 0xF5 },
	{ 0x68, 0x60 },
	{ 0x24, 0x80 },
	{ 0x25, 0x28 },
	{ 0x4D, 0x28 },
	{ 0x4E, 0x28 },
	{ 0x4F, 0x1E },
	{ 0x2D, 0x0A },
	{ 0x07, 0xF1 },
};
struct ntp8918_reg_default ntp8918_standardMode_section7[] = {
	{ 0x00, 0x00 },
	{ 0x01, 0x00 },
	{ 0x38, 0x0B },
	{ 0x41, 0x1A },
	{ 0x44, 0x0E },
	{ 0x76, 0x70 },
	{ 0x03, 0x36 },
	{ 0x04, 0x36 },
	{ 0x05, 0x36 },
	{ 0x06, 0x36 },
	{ 0x3E, 0x01 },
	{ 0x3F, 0x1A },
};
struct ntp8918_reg_default ntp8918_standardMode_section8[] = {
	{ 0x3D, 0x00 },
	{ 0x0C, 0xFF },
	{ 0x16, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
};

#endif

