/*
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/tlv.h>
#include <linux/i2c-dev.h>
#include <linux/of_gpio.h>
#include <linux/gpio.h>
#include <linux/device.h>
#include <linux/regulator/consumer.h>
#include <linux/amlogic/media/vout/lcd/lcd_unifykey.h>
#include "ntp8918.h"

struct i2c_client *ntp8918_client = NULL;

int codec_model = 0;
EXPORT_SYMBOL(codec_model);

static int ntp_i2c_write_4Byte(unsigned char reg, unsigned int val)
{
	unsigned char data[4] = {(val>>24)&0xff, (val>>16)&0xff, (val>>8)&0xff, val&0xff};
	return i2c_smbus_write_i2c_block_data(ntp8918_client, reg, 4, data);
}

static int ntp_i2c_write_Byte(unsigned char reg, unsigned char val)
{
	return i2c_smbus_write_byte_data(ntp8918_client, reg, val);
}

typedef enum ntp8918_music_mode {
	STANDARDMODE = 0,
	MOVIEMODE = 1,
	MUSICMOODE =2
} musicMode;

void ntp8918_vol_val(int val){
	if(val == 0){
		ntp_i2c_write_Byte(0x0c, 0x00);
	}else {
		ntp_i2c_write_Byte(0x0c, 0xff);
	}
}
EXPORT_SYMBOL(ntp8918_vol_val);

int ntp8918_music_mode(musicMode inputMode)
{
	int i;

	if(inputMode == STANDARDMODE) {
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section0); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section0[i].reg, ntp8918_standardMode_section0[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section1); i++) {
			ntp_i2c_write_4Byte(ntp8918_standardMode_section1[i].reg, ntp8918_standardMode_section1[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section2); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section2[i].reg, ntp8918_standardMode_section2[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section3); i++) {
			ntp_i2c_write_4Byte(ntp8918_standardMode_section3[i].reg, ntp8918_standardMode_section3[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section4); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section4[i].reg, ntp8918_standardMode_section4[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section5); i++) {
			ntp_i2c_write_4Byte(ntp8918_standardMode_section5[i].reg, ntp8918_standardMode_section5[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section6); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section6[i].reg, ntp8918_standardMode_section6[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section7); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section7[i].reg, ntp8918_standardMode_section7[i].def);
		};
		for (i=0; i<ARRAY_SIZE(ntp8918_standardMode_section8); i++) {
			ntp_i2c_write_Byte(ntp8918_standardMode_section8[i].reg, ntp8918_standardMode_section8[i].def);
		};
	}

	ntp_i2c_write_Byte(0x0c, 0xff);
	return 0;
}
EXPORT_SYMBOL(ntp8918_music_mode);

static int enable_ntp8918(struct device_node *np)
{
    int ret = 0;

    ntp8918_reset_pin = of_get_named_gpio_flags(np, "reset_pin", 0, NULL);
    if (ntp8918_reset_pin < 0) {
        pr_err("%s fail to get reset pin from dts!\n", __func__);
        ret = -1;
    } else {
		pr_err("%s pdata->reset_pin = %d!\n", __func__,
                ntp8918_reset_pin);
    }
    gpio_request(ntp8918_reset_pin, "ntp8918_reset");

    gpio_direction_output(ntp8918_reset_pin, 1);
	mdelay(100);
	gpio_direction_output(ntp8918_reset_pin, 0);
	mdelay(100);
	gpio_direction_output(ntp8918_reset_pin, 1);
	mdelay(100);

	pr_err("power off end\n");

    return ret;
}

int ntp8918_i2c_probe(struct i2c_client *i2c, const struct i2c_device_id *id)
{
	int i = 0, ret = 0, ntp8918_music_mode_cur = 0, key_len = 32;
	unsigned char tbuf[32] = {0x00};
	char *key_name = "misc_data";
	unsigned int real = 32;

	pr_err("func = %s, line = %d\n", __func__, __LINE__);	

	ntp8918_client = i2c;

	enable_ntp8918(i2c->dev.of_node);

	for (i=0; i<ARRAY_SIZE(ntp8918_reg_defaults); i++) {
		ret = ntp_i2c_write_Byte(ntp8918_reg_defaults[i].reg, ntp8918_reg_defaults[i].def);
		if(ret != 0) {
			gpio_direction_output(ntp8918_reset_pin, 0);
			pr_err("codec init failed\n");
			codec_model = 0;
			return -1;
		}
	}

	ret = key_unify_read(get_ukdev(), key_name, tbuf, key_len, &real);
	//music mode
	if(ret || tbuf[4] != 0x83 || (tbuf[5] != 0 && tbuf[5] != 1 && tbuf[5] != 2)) {
		ntp8918_music_mode_cur = 0;
	}else
		ntp8918_music_mode_cur = tbuf[5];

	ntp8918_music_mode(ntp8918_music_mode_cur);

	codec_model = 1;

	return 0;
}

static void ntp8918_i2c_shutdown(struct i2c_client *client)
{
    printk("%s %d\n", __func__, __LINE__);
    ntp8918_vol_val(0);
    mdelay(1);
    gpio_direction_output(ntp8918_reset_pin, 0);
    mdelay(5);
}

static const struct i2c_device_id ntp8918_i2c_id[] = {
    { "ntp8918", 0 },
    {}
};

static const struct of_device_id ntp8918_of_id[] = {
    { .compatible = "NTP, ntp8918", },
	{}
};
MODULE_DEVICE_TABLE(of, ntp8918_of_id);

static int ntp8918_codec_platform_remove(struct i2c_client *client)
{
	kfree(ntp8918_client);
	return 0;
}

static struct i2c_driver ntp8918_i2c_driver = {
    .probe = ntp8918_i2c_probe,
    .shutdown = ntp8918_i2c_shutdown,
	.remove = ntp8918_codec_platform_remove,
    .id_table = ntp8918_i2c_id,
    .driver = {
        .name = "ntp8918",
        .of_match_table = ntp8918_of_id,
        .owner = THIS_MODULE,
    },
};

module_i2c_driver(ntp8918_i2c_driver);

MODULE_DESCRIPTION("ntp8918 control driver");
MODULE_AUTHOR("Jixin, luly.zhu@ji-xintech.com.");
MODULE_LICENSE("GPL v2");
