/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _ACM8625_H
#define _ACM8625_H

#include <linux/regmap.h>
//ACME REG Begin
static const int acm8625_reset[][2] = {
  //  initialization acm8625 script
{ 0x00, 0x00 },
{ 0x04, 0x00 },
{ 0xfc, 0x86 },
{ 0xfd, 0x25 },
{ 0xfe, 0x15 },
{ 0x00, 0x01 },
{ 0x02, 0x20 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },

};

static const int  acm8625_init_sequence[][2] = {
//acm8625 audio processing related registers
#ifdef DEBUG
//  EQ
//  EQ1 - left
{ 0x00, 0x06 },
{ 0xb0, 0x07 },
{ 0xb1, 0xf6 },
{ 0xb2, 0xcc },
{ 0xb3, 0xb3 },
{ 0xb4, 0xf0 },
{ 0xb5, 0x12 },
{ 0xb6, 0x66 },
{ 0xb7, 0x9b },
{ 0xb8, 0x07 },
{ 0xb9, 0xf6 },
{ 0xba, 0xcc },
{ 0xbb, 0xb3 },
{ 0xbc, 0x0f },
{ 0xbd, 0xed },
{ 0xbe, 0x8b },
{ 0xbf, 0xdf },
{ 0xc0, 0xf8 },
{ 0xc1, 0x12 },
{ 0xc2, 0x59 },
{ 0xc3, 0x14 },
//  EQ1 - right
{ 0x00, 0x07 },
{ 0xe0, 0x07 },
{ 0xe1, 0xf6 },
{ 0xe2, 0xcc },
{ 0xe3, 0xb3 },
{ 0xe4, 0xf0 },
{ 0xe5, 0x12 },
{ 0xe6, 0x66 },
{ 0xe7, 0x9b },
{ 0xe8, 0x07 },
{ 0xe9, 0xf6 },
{ 0xea, 0xcc },
{ 0xeb, 0xb3 },
{ 0xec, 0x0f },
{ 0xed, 0xed },
{ 0xee, 0x8b },
{ 0xef, 0xdf },
{ 0xf0, 0xf8 },
{ 0xf1, 0x12 },
{ 0xf2, 0x59 },
{ 0xf3, 0x14 },
//  EQ2 - left
{ 0x00, 0x06 },
{ 0xc4, 0x07 },
{ 0xc5, 0xf6 },
{ 0xc6, 0xcc },
{ 0xc7, 0xb3 },
{ 0xc8, 0xf0 },
{ 0xc9, 0x12 },
{ 0xca, 0x66 },
{ 0xcb, 0x9b },
{ 0xcc, 0x07 },
{ 0xcd, 0xf6 },
{ 0xce, 0xcc },
{ 0xcf, 0xb3 },
{ 0xd0, 0x0f },
{ 0xd1, 0xed },
{ 0xd2, 0x8b },
{ 0xd3, 0xdf },
{ 0xd4, 0xf8 },
{ 0xd5, 0x12 },
{ 0xd6, 0x59 },
{ 0xd7, 0x14 },
//  EQ2 - right
{ 0x00, 0x07 },
{ 0xf4, 0x07 },
{ 0xf5, 0xf6 },
{ 0xf6, 0xcc },
{ 0xf7, 0xb3 },
{ 0xf8, 0xf0 },
{ 0xf9, 0x12 },
{ 0xfa, 0x66 },
{ 0xfb, 0x9b },
{ 0xfc, 0x07 },
{ 0xfd, 0xf6 },
{ 0xfe, 0xcc },
{ 0xff, 0xb3 },
{ 0x00, 0x08 },
{ 0x04, 0x0f },
{ 0x05, 0xed },
{ 0x06, 0x8b },
{ 0x07, 0xdf },
{ 0x08, 0xf8 },
{ 0x09, 0x12 },
{ 0x0a, 0x59 },
{ 0x0b, 0x14 },
//  EQ3 - left
{ 0x00, 0x06 },
{ 0xd8, 0x07 },
{ 0xd9, 0xba },
{ 0xda, 0x89 },
{ 0xdb, 0x86 },
{ 0xdc, 0xf1 },
{ 0xdd, 0x9f },
{ 0xde, 0xb0 },
{ 0xdf, 0x82 },
{ 0xe0, 0x06 },
{ 0xe1, 0xed },
{ 0xe2, 0xdf },
{ 0xe3, 0xf7 },
{ 0xe4, 0x0e },
{ 0xe5, 0x60 },
{ 0xe6, 0x4f },
{ 0xe7, 0x7e },
{ 0xe8, 0xf9 },
{ 0xe9, 0x57 },
{ 0xea, 0x96 },
{ 0xeb, 0x83 },
//  EQ3 - right
{ 0x00, 0x08 },
{ 0x0c, 0x07 },
{ 0x0d, 0xba },
{ 0x0e, 0x89 },
{ 0x0f, 0x86 },
{ 0x10, 0xf1 },
{ 0x11, 0x9f },
{ 0x12, 0xb0 },
{ 0x13, 0x82 },
{ 0x14, 0x06 },
{ 0x15, 0xed },
{ 0x16, 0xdf },
{ 0x17, 0xf7 },
{ 0x18, 0x0e },
{ 0x19, 0x60 },
{ 0x1a, 0x4f },
{ 0x1b, 0x7e },
{ 0x1c, 0xf9 },
{ 0x1d, 0x57 },
{ 0x1e, 0x96 },
{ 0x1f, 0x83 },
//  EQ4 - left
{ 0x00, 0x06 },
{ 0xec, 0x06 },
{ 0xed, 0x29 },
{ 0xee, 0x3c },
{ 0xef, 0xa7 },
{ 0xf0, 0xfa },
{ 0xf1, 0x23 },
{ 0xf2, 0xc0 },
{ 0xf3, 0x21 },
{ 0xf4, 0x02 },
{ 0xf5, 0x12 },
{ 0xf6, 0x71 },
{ 0xf7, 0x12 },
{ 0xf8, 0x08 },
{ 0xf9, 0xc4 },
{ 0xfa, 0x73 },
{ 0xfb, 0xd1 },
{ 0xfc, 0xfc },
{ 0xfd, 0xdc },
{ 0xfe, 0x1e },
{ 0xff, 0x55 },
//  EQ4 - right
{ 0x00, 0x08 },
{ 0x20, 0x06 },
{ 0x21, 0x29 },
{ 0x22, 0x3c },
{ 0x23, 0xa7 },
{ 0x24, 0xfa },
{ 0x25, 0x23 },
{ 0x26, 0xc0 },
{ 0x27, 0x21 },
{ 0x28, 0x02 },
{ 0x29, 0x12 },
{ 0x2a, 0x71 },
{ 0x2b, 0x12 },
{ 0x2c, 0x08 },
{ 0x2d, 0xc4 },
{ 0x2e, 0x73 },
{ 0x2f, 0xd1 },
{ 0x30, 0xfc },
{ 0x31, 0xdc },
{ 0x32, 0x1e },
{ 0x33, 0x55 },
//  EQ5 - left
{ 0x00, 0x07 },
{ 0x04, 0x07 },
{ 0x05, 0xf9 },
{ 0x06, 0x1b },
{ 0x07, 0xd5 },
{ 0x08, 0xf0 },
{ 0x09, 0x39 },
{ 0x0a, 0x45 },
{ 0x0b, 0x3c },
{ 0x0c, 0x07 },
{ 0x0d, 0xcf },
{ 0x0e, 0xc8 },
{ 0x0f, 0xcd },
{ 0x10, 0x0f },
{ 0x11, 0xc6 },
{ 0x12, 0xba },
{ 0x13, 0xc4 },
{ 0x14, 0xf8 },
{ 0x15, 0x37 },
{ 0x16, 0x1b },
{ 0x17, 0x5e },
//  EQ5 - right
{ 0x00, 0x08 },
{ 0x34, 0x07 },
{ 0x35, 0xf9 },
{ 0x36, 0x1b },
{ 0x37, 0xd5 },
{ 0x38, 0xf0 },
{ 0x39, 0x39 },
{ 0x3a, 0x45 },
{ 0x3b, 0x3c },
{ 0x3c, 0x07 },
{ 0x3d, 0xcf },
{ 0x3e, 0xc8 },
{ 0x3f, 0xcd },
{ 0x40, 0x0f },
{ 0x41, 0xc6 },
{ 0x42, 0xba },
{ 0x43, 0xc4 },
{ 0x44, 0xf8 },
{ 0x45, 0x37 },
{ 0x46, 0x1b },
{ 0x47, 0x5e },
//  EQ6 - left
{ 0x00, 0x07 },
{ 0x18, 0x07 },
{ 0x19, 0xec },
{ 0x1a, 0xe1 },
{ 0x1b, 0xdd },
{ 0x1c, 0xf0 },
{ 0x1d, 0x8b },
{ 0x1e, 0x68 },
{ 0x1f, 0x96 },
{ 0x20, 0x07 },
{ 0x21, 0x90 },
{ 0x22, 0x32 },
{ 0x23, 0xe0 },
{ 0x24, 0x0f },
{ 0x25, 0x74 },
{ 0x26, 0x97 },
{ 0x27, 0x6a },
{ 0x28, 0xf8 },
{ 0x29, 0x82 },
{ 0x2a, 0xeb },
{ 0x2b, 0x43 },
//  EQ6 - right
{ 0x00, 0x08 },
{ 0x48, 0x07 },
{ 0x49, 0xec },
{ 0x4a, 0xe1 },
{ 0x4b, 0xdd },
{ 0x4c, 0xf0 },
{ 0x4d, 0x8b },
{ 0x4e, 0x68 },
{ 0x4f, 0x96 },
{ 0x50, 0x07 },
{ 0x51, 0x90 },
{ 0x52, 0x32 },
{ 0x53, 0xe0 },
{ 0x54, 0x0f },
{ 0x55, 0x74 },
{ 0x56, 0x97 },
{ 0x57, 0x6a },
{ 0x58, 0xf8 },
{ 0x59, 0x82 },
{ 0x5a, 0xeb },
{ 0x5b, 0x43 },
//  EQ7 - left
{ 0x00, 0x07 },
{ 0x2c, 0x06 },
{ 0x2d, 0xcb },
{ 0x2e, 0x03 },
{ 0x2f, 0x13 },
{ 0x30, 0xfb },
{ 0x31, 0x45 },
{ 0x32, 0x44 },
{ 0x33, 0xdf },
{ 0x34, 0x02 },
{ 0x35, 0xaa },
{ 0x36, 0x73 },
{ 0x37, 0x2e },
{ 0x38, 0x04 },
{ 0x39, 0xba },
{ 0x3a, 0xbb },
{ 0x3b, 0x21 },
{ 0x3c, 0xfe },
{ 0x3d, 0x8a },
{ 0x3e, 0x89 },
{ 0x3f, 0xbe },
//  EQ7 - right
{ 0x00, 0x08 },
{ 0x5c, 0x06 },
{ 0x5d, 0xcb },
{ 0x5e, 0x03 },
{ 0x5f, 0x13 },
{ 0x60, 0xfb },
{ 0x61, 0x45 },
{ 0x62, 0x44 },
{ 0x63, 0xdf },
{ 0x64, 0x02 },
{ 0x65, 0xaa },
{ 0x66, 0x73 },
{ 0x67, 0x2e },
{ 0x68, 0x04 },
{ 0x69, 0xba },
{ 0x6a, 0xbb },
{ 0x6b, 0x21 },
{ 0x6c, 0xfe },
{ 0x6d, 0x8a },
{ 0x6e, 0x89 },
{ 0x6f, 0xbe },
//  EQ8 - left
{ 0x00, 0x07 },
{ 0x40, 0x07 },
{ 0x41, 0x50 },
{ 0x42, 0x72 },
{ 0x43, 0x77 },
{ 0x44, 0xf4 },
{ 0x45, 0xfb },
{ 0x46, 0xb0 },
{ 0x47, 0xc5 },
{ 0x48, 0x04 },
{ 0x49, 0xf8 },
{ 0x4a, 0x28 },
{ 0x4b, 0x21 },
{ 0x4c, 0x0b },
{ 0x4d, 0x04 },
{ 0x4e, 0x4f },
{ 0x4f, 0x3b },
{ 0x50, 0xfb },
{ 0x51, 0xb7 },
{ 0x52, 0x65 },
{ 0x53, 0x69 },
//  EQ8 - right
{ 0x00, 0x08 },
{ 0x70, 0x07 },
{ 0x71, 0x50 },
{ 0x72, 0x72 },
{ 0x73, 0x77 },
{ 0x74, 0xf4 },
{ 0x75, 0xfb },
{ 0x76, 0xb0 },
{ 0x77, 0xc5 },
{ 0x78, 0x04 },
{ 0x79, 0xf8 },
{ 0x7a, 0x28 },
{ 0x7b, 0x21 },
{ 0x7c, 0x0b },
{ 0x7d, 0x04 },
{ 0x7e, 0x4f },
{ 0x7f, 0x3b },
{ 0x80, 0xfb },
{ 0x81, 0xb7 },
{ 0x82, 0x65 },
{ 0x83, 0x69 },
//  EQ9 - left
{ 0x00, 0x07 },
{ 0x54, 0x08 },
{ 0x55, 0x07 },
{ 0x56, 0x09 },
{ 0x57, 0x80 },
{ 0x58, 0xf0 },
{ 0x59, 0x0b },
{ 0x5a, 0x9d },
{ 0x5b, 0x5f },
{ 0x5c, 0x07 },
{ 0x5d, 0xed },
{ 0x5e, 0x99 },
{ 0x5f, 0xda },
{ 0x60, 0x0f },
{ 0x61, 0xf4 },
{ 0x62, 0x62 },
{ 0x63, 0xa1 },
{ 0x64, 0xf8 },
{ 0x65, 0x0b },
{ 0x66, 0x5c },
{ 0x67, 0xa6 },
//  EQ9 - right
{ 0x00, 0x08 },
{ 0x84, 0x08 },
{ 0x85, 0x07 },
{ 0x86, 0x09 },
{ 0x87, 0x80 },
{ 0x88, 0xf0 },
{ 0x89, 0x0b },
{ 0x8a, 0x9d },
{ 0x8b, 0x5f },
{ 0x8c, 0x07 },
{ 0x8d, 0xed },
{ 0x8e, 0x99 },
{ 0x8f, 0xda },
{ 0x90, 0x0f },
{ 0x91, 0xf4 },
{ 0x92, 0x62 },
{ 0x93, 0xa1 },
{ 0x94, 0xf8 },
{ 0x95, 0x0b },
{ 0x96, 0x5c },
{ 0x97, 0xa6 },
//  EQ10 - left
{ 0x00, 0x07 },
{ 0x68, 0x07 },
{ 0x69, 0xf6 },
{ 0x6a, 0xcc },
{ 0x6b, 0xb3 },
{ 0x6c, 0xf0 },
{ 0x6d, 0x12 },
{ 0x6e, 0x66 },
{ 0x6f, 0x9b },
{ 0x70, 0x07 },
{ 0x71, 0xf6 },
{ 0x72, 0xcc },
{ 0x73, 0xb3 },
{ 0x74, 0x0f },
{ 0x75, 0xed },
{ 0x76, 0x8b },
{ 0x77, 0xdf },
{ 0x78, 0xf8 },
{ 0x79, 0x12 },
{ 0x7a, 0x59 },
{ 0x7b, 0x14 },
//  EQ10 - right
{ 0x00, 0x08 },
{ 0x98, 0x07 },
{ 0x99, 0xf6 },
{ 0x9a, 0xcc },
{ 0x9b, 0xb3 },
{ 0x9c, 0xf0 },
{ 0x9d, 0x12 },
{ 0x9e, 0x66 },
{ 0x9f, 0x9b },
{ 0xa0, 0x07 },
{ 0xa1, 0xf6 },
{ 0xa2, 0xcc },
{ 0xa3, 0xb3 },
{ 0xa4, 0x0f },
{ 0xa5, 0xed },
{ 0xa6, 0x8b },
{ 0xa7, 0xdf },
{ 0xa8, 0xf8 },
{ 0xa9, 0x12 },
{ 0xaa, 0x59 },
{ 0xab, 0x14 },
//  EQ11 - left
{ 0x00, 0x07 },
{ 0x7c, 0x07 },
{ 0x7d, 0xe7 },
{ 0x7e, 0xaa },
{ 0x7f, 0xdf },
{ 0x80, 0xf0 },
{ 0x81, 0xd7 },
{ 0x82, 0xf3 },
{ 0x83, 0x47 },
{ 0x84, 0x07 },
{ 0x85, 0x55 },
{ 0x86, 0xc1 },
{ 0x87, 0x2f },
{ 0x88, 0x0f },
{ 0x89, 0x28 },
{ 0x8a, 0x0c },
{ 0x8b, 0xb9 },
{ 0x8c, 0xf8 },
{ 0x8d, 0xc2 },
{ 0x8e, 0x93 },
{ 0x8f, 0xf2 },
//  EQ11 - right
{ 0x00, 0x08 },
{ 0xac, 0x07 },
{ 0xad, 0xe7 },
{ 0xae, 0xaa },
{ 0xaf, 0xdf },
{ 0xb0, 0xf0 },
{ 0xb1, 0xd7 },
{ 0xb2, 0xf3 },
{ 0xb3, 0x47 },
{ 0xb4, 0x07 },
{ 0xb5, 0x55 },
{ 0xb6, 0xc1 },
{ 0xb7, 0x2f },
{ 0xb8, 0x0f },
{ 0xb9, 0x28 },
{ 0xba, 0x0c },
{ 0xbb, 0xb9 },
{ 0xbc, 0xf8 },
{ 0xbd, 0xc2 },
{ 0xbe, 0x93 },
{ 0xbf, 0xf2 },
//  EQ12 - left
{ 0x00, 0x07 },
{ 0x90, 0x09 },
{ 0x91, 0x5c },
{ 0x92, 0x41 },
{ 0x93, 0x53 },
{ 0x94, 0x03 },
{ 0x95, 0x99 },
{ 0x96, 0x5d },
{ 0x97, 0x89 },
{ 0x98, 0x00 },
{ 0x99, 0x0b },
{ 0x9a, 0x63 },
{ 0x9b, 0x7b },
{ 0x9c, 0xfc },
{ 0x9d, 0x66 },
{ 0x9e, 0xa2 },
{ 0x9f, 0x77 },
{ 0xa0, 0xfe },
{ 0xa1, 0x98 },
{ 0xa2, 0x5b },
{ 0xa3, 0x32 },
//  EQ12 - right
{ 0x00, 0x08 },
{ 0xc0, 0x09 },
{ 0xc1, 0x5c },
{ 0xc2, 0x41 },
{ 0xc3, 0x53 },
{ 0xc4, 0x03 },
{ 0xc5, 0x99 },
{ 0xc6, 0x5d },
{ 0xc7, 0x89 },
{ 0xc8, 0x00 },
{ 0xc9, 0x0b },
{ 0xca, 0x63 },
{ 0xcb, 0x7b },
{ 0xcc, 0xfc },
{ 0xcd, 0x66 },
{ 0xce, 0xa2 },
{ 0xcf, 0x77 },
{ 0xd0, 0xfe },
{ 0xd1, 0x98 },
{ 0xd2, 0x5b },
{ 0xd3, 0x32 },
//  Pre volume
{ 0x00, 0x04 },
{ 0x7c, 0x01 },
{ 0x7d, 0x68 },
{ 0x7e, 0xc0 },
{ 0x7f, 0xc6 },
{ 0x80, 0x01 },
{ 0x81, 0x68 },
{ 0x82, 0xc0 },
{ 0x83, 0xc6 },
//  DRC
//  DRC1_LowSettings
{ 0x00, 0x05 },
{ 0x30, 0x00 },
{ 0x31, 0x88 },
{ 0x32, 0x3f },
{ 0x33, 0xd1 },
{ 0x34, 0x00 },
{ 0x35, 0xe2 },
{ 0x36, 0xc4 },
{ 0x37, 0x6b },
{ 0x38, 0x00 },
{ 0x39, 0x01 },
{ 0x3a, 0x5d },
{ 0x3b, 0x85 },
{ 0x3c, 0x00 },
{ 0x3d, 0x00 },
{ 0x3e, 0x00 },
{ 0x3f, 0x00 },
{ 0x40, 0xff },
{ 0x41, 0xe8 },
{ 0x42, 0x35 },
{ 0x43, 0x4b },
{ 0x44, 0xff },
{ 0x45, 0x81 },
{ 0x46, 0x47 },
{ 0x47, 0xae },
{ 0x48, 0xfb },
{ 0x49, 0x19 },
{ 0x4a, 0xa3 },
{ 0x4b, 0xd5 },
{ 0x4c, 0xfd },
{ 0x4d, 0x55 },
{ 0x4e, 0x8b },
{ 0x4f, 0x09 },
{ 0x50, 0x00 },
{ 0x51, 0x6a },
{ 0x52, 0x4d },
{ 0x53, 0x3c },
{ 0x54, 0x00 },
{ 0x55, 0x00 },
{ 0x56, 0x00 },
{ 0x57, 0x00 },
{ 0xd0, 0x00 },
{ 0xd1, 0x80 },
{ 0xd2, 0x00 },
{ 0xd3, 0x00 },
//  DRC2_MidSettings
{ 0x58, 0x02 },
{ 0x59, 0xa3 },
{ 0x5a, 0x9a },
{ 0x5b, 0xcc },
{ 0x5c, 0x02 },
{ 0x5d, 0xa3 },
{ 0x5e, 0x9a },
{ 0x5f, 0xcc },
{ 0x60, 0x00 },
{ 0x61, 0x00 },
{ 0x62, 0xda },
{ 0x63, 0x73 },
{ 0x64, 0x00 },
{ 0x65, 0x00 },
{ 0x66, 0x00 },
{ 0x67, 0x00 },
{ 0x68, 0x00 },
{ 0x69, 0x00 },
{ 0x6a, 0x00 },
{ 0x6b, 0x00 },
{ 0x6c, 0xff },
{ 0x6d, 0x81 },
{ 0x6e, 0x47 },
{ 0x6f, 0xae },
{ 0x70, 0xfa },
{ 0x71, 0xaf },
{ 0x72, 0x56 },
{ 0x73, 0x99 },
{ 0x74, 0xfd },
{ 0x75, 0x55 },
{ 0x76, 0x8b },
{ 0x77, 0x09 },
{ 0x78, 0x00 },
{ 0x79, 0x00 },
{ 0x7a, 0x00 },
{ 0x7b, 0x00 },
{ 0x7c, 0x00 },
{ 0x7d, 0x00 },
{ 0x7e, 0x00 },
{ 0x7f, 0x00 },
{ 0xd4, 0x00 },
{ 0xd5, 0x80 },
{ 0xd6, 0x00 },
{ 0xd7, 0x00 },
//  DRC3_HighSettings
{ 0x80, 0x02 },
{ 0x81, 0xa3 },
{ 0x82, 0x9a },
{ 0x83, 0xcc },
{ 0x84, 0x02 },
{ 0x85, 0xa3 },
{ 0x86, 0x9a },
{ 0x87, 0xcc },
{ 0x88, 0x00 },
{ 0x89, 0x01 },
{ 0x8a, 0x5d },
{ 0x8b, 0x85 },
{ 0x8c, 0x00 },
{ 0x8d, 0x00 },
{ 0x8e, 0x00 },
{ 0x8f, 0x00 },
{ 0x90, 0x00 },
{ 0x91, 0x00 },
{ 0x92, 0x00 },
{ 0x93, 0x00 },
{ 0x94, 0xff },
{ 0x95, 0x81 },
{ 0x96, 0x47 },
{ 0x97, 0xae },
{ 0x98, 0xf9 },
{ 0x99, 0x06 },
{ 0x9a, 0x21 },
{ 0x9b, 0xa9 },
{ 0x9c, 0xfd },
{ 0x9d, 0x55 },
{ 0x9e, 0x8b },
{ 0x9f, 0x09 },
{ 0xa0, 0x00 },
{ 0xa1, 0x00 },
{ 0xa2, 0x00 },
{ 0xa3, 0x00 },
{ 0xa4, 0x00 },
{ 0xa5, 0x00 },
{ 0xa6, 0x00 },
{ 0xa7, 0x00 },
{ 0xd8, 0x00 },
{ 0xd9, 0x80 },
{ 0xda, 0x00 },
{ 0xdb, 0x00 },
{ 0x00, 0x04 },
{ 0x8c, 0x00 },
{ 0x8d, 0x0d },
{ 0x8e, 0xf5 },
{ 0x8f, 0x4f },
{ 0x90, 0x00 },
{ 0x91, 0x0d },
{ 0x92, 0xf5 },
{ 0x93, 0x4f },
{ 0x94, 0x00 },
{ 0x95, 0x0d },
{ 0x96, 0xf5 },
{ 0x97, 0x4f },
{ 0x98, 0x7c },
{ 0x99, 0x35 },
{ 0x9a, 0xb5 },
{ 0x9b, 0x7f },
{ 0x9c, 0x87 },
{ 0x9d, 0x5c },
{ 0x9e, 0xbf },
{ 0x9f, 0xc5 },
{ 0xa0, 0x00 },
{ 0xa1, 0x0d },
{ 0xa2, 0xf5 },
{ 0xa3, 0x4f },
{ 0xa4, 0x00 },
{ 0xa5, 0x0d },
{ 0xa6, 0xf5 },
{ 0xa7, 0x4f },
{ 0xa8, 0x00 },
{ 0xa9, 0x0d },
{ 0xaa, 0xf5 },
{ 0xab, 0x4f },
{ 0xac, 0x7c },
{ 0xad, 0x35 },
{ 0xae, 0xb5 },
{ 0xaf, 0x7f },
{ 0xb0, 0x87 },
{ 0xb1, 0x5c },
{ 0xb2, 0xbf },
{ 0xb3, 0xc5 },
{ 0xb4, 0x7c },
{ 0xb5, 0x43 },
{ 0xb6, 0xaa },
{ 0xb7, 0xce },
{ 0xb8, 0x83 },
{ 0xb9, 0xbc },
{ 0xba, 0x55 },
{ 0xbb, 0x32 },
{ 0xbc, 0x7c },
{ 0xbd, 0x43 },
{ 0xbe, 0xaa },
{ 0xbf, 0xce },
{ 0xc0, 0x7c },
{ 0xc1, 0x35 },
{ 0xc2, 0xb5 },
{ 0xc3, 0x7f },
{ 0xc4, 0x87 },
{ 0xc5, 0x5c },
{ 0xc6, 0xbf },
{ 0xc7, 0xc5 },
{ 0xc8, 0x7c },
{ 0xc9, 0x43 },
{ 0xca, 0xaa },
{ 0xcb, 0xce },
{ 0xcc, 0x83 },
{ 0xcd, 0xbc },
{ 0xce, 0x55 },
{ 0xcf, 0x32 },
{ 0xd0, 0x7c },
{ 0xd1, 0x43 },
{ 0xd2, 0xaa },
{ 0xd3, 0xce },
{ 0xd4, 0x7c },
{ 0xd5, 0x35 },
{ 0xd6, 0xb5 },
{ 0xd7, 0x7f },
{ 0xd8, 0x87 },
{ 0xd9, 0x5c },
{ 0xda, 0xbf },
{ 0xdb, 0xc5 },
{ 0xdc, 0x0c },
{ 0xdd, 0x7f },
{ 0xde, 0x2c },
{ 0xdf, 0xcd },
{ 0xe0, 0x0c },
{ 0xe1, 0x7f },
{ 0xe2, 0x2c },
{ 0xe3, 0xcd },
{ 0xe4, 0x0c },
{ 0xe5, 0x7f },
{ 0xe6, 0x2c },
{ 0xe7, 0xcd },
{ 0xe8, 0x3c },
{ 0xe9, 0x56 },
{ 0xea, 0xfb },
{ 0xeb, 0xbc },
{ 0xec, 0xd5 },
{ 0xed, 0x55 },
{ 0xee, 0x55 },
{ 0xef, 0x55 },
{ 0xf0, 0x0c },
{ 0xf1, 0x7f },
{ 0xf2, 0x2c },
{ 0xf3, 0xcd },
{ 0xf4, 0x0c },
{ 0xf5, 0x7f },
{ 0xf6, 0x2c },
{ 0xf7, 0xcd },
{ 0xf8, 0x0c },
{ 0xf9, 0x7f },
{ 0xfa, 0x2c },
{ 0xfb, 0xcd },
{ 0xfc, 0x3c },
{ 0xfd, 0x56 },
{ 0xfe, 0xfb },
{ 0xff, 0xbc },
{ 0x00, 0x05 },
{ 0x04, 0xd5 },
{ 0x05, 0x55 },
{ 0x06, 0x55 },
{ 0x07, 0x55 },
{ 0x08, 0x48 },
{ 0x09, 0xd6 },
{ 0x0a, 0x28 },
{ 0x0b, 0x89 },
{ 0x0c, 0xb7 },
{ 0x0d, 0x29 },
{ 0x0e, 0xd7 },
{ 0x0f, 0x77 },
{ 0x10, 0x48 },
{ 0x11, 0xd6 },
{ 0x12, 0x28 },
{ 0x13, 0x89 },
{ 0x14, 0x3c },
{ 0x15, 0x56 },
{ 0x16, 0xfb },
{ 0x17, 0xbc },
{ 0x18, 0xd5 },
{ 0x19, 0x55 },
{ 0x1a, 0x55 },
{ 0x1b, 0x55 },
{ 0x1c, 0x48 },
{ 0x1d, 0xd6 },
{ 0x1e, 0x28 },
{ 0x1f, 0x89 },
{ 0x20, 0xb7 },
{ 0x21, 0x29 },
{ 0x22, 0xd7 },
{ 0x23, 0x77 },
{ 0x24, 0x48 },
{ 0x25, 0xd6 },
{ 0x26, 0x28 },
{ 0x27, 0x89 },
{ 0x28, 0x3c },
{ 0x29, 0x56 },
{ 0x2a, 0xfb },
{ 0x2b, 0xbc },
{ 0x2c, 0xd5 },
{ 0x2d, 0x55 },
{ 0x2e, 0x55 },
{ 0x2f, 0x55 },
//  AGL
{ 0xf4, 0x03 },
{ 0xf5, 0x2d },
{ 0xf6, 0xac },
{ 0xf7, 0x4d },
{ 0xf8, 0x00 },
{ 0xf9, 0x00 },
{ 0xfa, 0x9d },
{ 0xfb, 0x49 },
{ 0xfc, 0x00 },
{ 0xfd, 0x37 },
{ 0xfe, 0xd7 },
{ 0xff, 0x96 },
{ 0xf8, 0x00 },
{ 0xf9, 0x00 },
{ 0xfa, 0x9d },
{ 0xfb, 0x49 },
{ 0xfc, 0x00 },
{ 0xfd, 0x37 },
{ 0xfe, 0xd7 },
{ 0xff, 0x96 },
{ 0x00, 0x06 },
{ 0x04, 0x04 },
{ 0x05, 0xc1 },
{ 0x06, 0xff },
{ 0x07, 0x93 },
{ 0x08, 0x7b },
{ 0x09, 0x3e },
{ 0x0a, 0x00 },
{ 0x0b, 0x6d },
#endif

//  input mixer
{ 0x00, 0x04 },
{ 0x2c, 0xff },
{ 0x2d, 0x80 },
{ 0x2e, 0x00 },
{ 0x2f, 0x00 },
{ 0x20, 0xff },
{ 0x21, 0x80 },
{ 0x22, 0x00 },
{ 0x23, 0x00 },
//  acm8625 ClassD Control Registers
{ 0x00, 0x01 },
{ 0x01, 0x07 },
{ 0x00, 0x00 },
{ 0x11, 0x0b },
{ 0x03, 0x01 },
{ 0x01, 0x80 },
{ 0x04, 0x02 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x00 },
{ 0x00, 0x03 },
{ 0x14, 0x26 },
{ 0x15, 0x26 },
{ 0x16, 0x30 },
{ 0x00, 0x00 },
{ 0x04, 0x03 },
};

//ACME Reg End

struct acm8625_platform_data {
	int reset_pin;
};

#endif
