/* SPDX-License-Identifier: GPL-2.0 */

/*
 * PDM hw coeff parameters
 *
 * Copyright (C) 2019 Amlogic,inc
 *
 */

#ifndef __PDM_HW_COEFF_H__
#define __PDM_HW_COEFF_H__

/* LPF coefficient
 * For filter 1 and filter 3, it's only relative with coefficient mode
 * For filter 2, it's only relative with osr and hcic stage number
 */

static const int lpf2_osr64[]  = {
	0x00050a, 0xfff004, 0x0002c1, 0x003c12, 0xffa818,
	0xffc87d, 0x010aef, 0xff5223, 0xfebd93, 0x028f41,
	0xff5c0e, 0xfc63f8, 0x055f81, 0x000000, 0xf478a0,
	0x11c5e3, 0x2ea74d, 0x11c5e3, 0xf478a0, 0x000000,
	0x055f81, 0xfc63f8, 0xff5c0e, 0x028f41, 0xfebd93,
	0xff5223, 0x010aef, 0xffc87d, 0xffa818, 0x003c12,
	0x0002c1, 0xfff004, 0x00050a,
};

static const int lpf2_osr96[]  = {
	0x00050a, 0xfff004, 0x0002c1, 0x003c12, 0xffa818,
	0xffc87d, 0x010aef, 0xff5223, 0xfebd93, 0x028f41,
	0xff5c0e, 0xfc63f8, 0x055f81, 0x000000, 0xf478a0,
	0x11c5e3, 0x2ea74d, 0x11c5e3, 0xf478a0, 0x000000,
	0x055f81, 0xfc63f8, 0xff5c0e, 0x028f41, 0xfebd93,
	0xff5223, 0x010aef, 0xffc87d, 0xffa818, 0x003c12,
	0x0002c1, 0xfff004, 0x00050a
};

static const int lpf2_osr128[]  = {
	0x00050b, 0xfff002, 0x0002c6, 0x003c15, 0xffa7fc,
	0xffc899, 0x010b29, 0xff518f, 0xfebd98, 0x02909c,
	0xff5ab8, 0xfc6254, 0x0563b2, 0x000000, 0xf46f16,
	0x11c6a2, 0x2eb45a, 0x11c6a2, 0xf46f16, 0x000000,
	0x0563b2, 0xfc6254, 0xff5ab8, 0x02909c, 0xfebd98,
	0xff518f, 0x010b29, 0xffc899, 0xffa7fc, 0x003c15,
	0x0002c6, 0xfff002, 0x00050b
};

static const int lpf2_osr192[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f7,
	0xffc89f, 0x010b35, 0xff516f, 0xfebd9a, 0x0290e8,
	0xff5a6d, 0xfc61f8, 0x05649b, 0x000000, 0xf46d02,
	0x11c6cc, 0x2eb731, 0x11c6cc, 0xf46d02, 0x000000,
	0x05649b, 0xfc61f8, 0xff5a6d, 0x0290e8, 0xfebd9a,
	0xff516f, 0x010b35, 0xffc89f, 0xffa7f7, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf2_osr256[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f6,
	0xffc8a0, 0x010b37, 0xff516a, 0xfebd9a, 0x0290f4,
	0xff5a62, 0xfc61ea, 0x0564bf, 0x000000, 0xf46cb0,
	0x11c6d2, 0x2eb7a1, 0x11c6d2, 0xf46cb0, 0x000000,
	0x0564bf, 0xfc61ea, 0xff5a62, 0x0290f4, 0xfebd9a,
	0xff516a, 0x010b37, 0xffc8a0, 0xffa7f6, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf2_osr384[] = {
	0x00050b, 0xfff002, 0x0002c7, 0x003c16, 0xffa7f6,
	0xffc8a0, 0x010b37, 0xff516a, 0xfebd9a, 0x0290f4,
	0xff5a62, 0xfc61ea, 0x0564bf, 0x000000, 0xf46cb0,
	0x11c6d2, 0x2eb7a1, 0x11c6d2, 0xf46cb0, 0x000000,
	0x0564bf, 0xfc61ea, 0xff5a62, 0x0290f4, 0xfebd9a,
	0xff516a, 0x010b37, 0xffc8a0, 0xffa7f6, 0x003c16,
	0x0002c7, 0xfff002, 0x00050b
};

static const int lpf1_mode0[] = {
	0x000006, 0x000002, 0xffffeb, 0xffffbe, 0xffff8a,
	0xffff76, 0xffffb4, 0x00006b, 0x000187, 0x0002a7,
	0x00031d, 0x00022c, 0xffff6b, 0xfffb35, 0xfff6e7,
	0xfff4aa, 0xfff6b8, 0xfffe3f, 0x000a43, 0x00172a,
	0x001f54, 0x001cfd, 0x000ce4, 0xfff0d0, 0xffd098,
	0xffb8cd, 0xffb6b8, 0xffd2b1, 0x000adb, 0x0050ad,
	0x008b46, 0x009ee9, 0x0077e0, 0x001506, 0xff8d7a,
	0xff0dc4, 0xfecb6c, 0xfef1b8, 0xff8da0, 0x0080db,
	0x0182b7, 0x0231a8, 0x023283, 0x0154bd, 0xffaf64,
	0xfdab1a, 0xfbf20a, 0xfb46e9, 0xfc4cb4, 0xff4f72,
	0x041fa5, 0x0a0e12, 0x100c37, 0x14eab3, 0x17a4fe,
	0x17a4fe, 0x14eab3, 0x100c37, 0x0a0e12, 0x041fa5,
	0xff4f72, 0xfc4cb4, 0xfb46e9, 0xfbf20a, 0xfdab1a,
	0xffaf64, 0x0154bd, 0x023283, 0x0231a8, 0x0182b7,
	0x0080db, 0xff8da0, 0xfef1b8, 0xfecb6c, 0xff0dc4,
	0xff8d7a, 0x001506, 0x0077e0, 0x009ee9, 0x008b46,
	0x0050ad, 0x000adb, 0xffd2b1, 0xffb6b8, 0xffb8cd,
	0xffd098, 0xfff0d0, 0x000ce4, 0x001cfd, 0x001f54,
	0x00172a, 0x000a43, 0xfffe3f, 0xfff6b8, 0xfff4aa,
	0xfff6e7, 0xfffb35, 0xffff6b, 0x00022c, 0x00031d,
	0x0002a7, 0x000187, 0x00006b, 0xffffb4, 0xffff76,
	0xffff8a, 0xffffbe, 0xffffeb, 0x000002, 0x000006,
};

static const int lpf3_mode0[] = {
	0x000007, 0x000000, 0xffffe8, 0x000000, 0x000038,
	0x000000, 0xffff94, 0x000000, 0x0000c0, 0x000000,
	0xfffec1, 0x000000, 0x0001f7, 0x000000, 0xfffd05,
	0x000000, 0x000460, 0x000000, 0xfff9c1, 0x000000,
	0x0008b7, 0x000000, 0xfff416, 0x000000, 0x000fff,
	0x000000, 0xffeadc, 0x000000, 0x001b8a, 0x000000,
	0xffdc97, 0x000000, 0x002d01, 0x000000, 0xffc767,
	0x000000, 0x00467f, 0x000000, 0xffa8f1, 0x000000,
	0x006ab0, 0x000000, 0xff7e26, 0x000000, 0x009d20,
	0x000000, 0xff42ce, 0x000000, 0x00e2f1, 0x000000,
	0xfef07e, 0x000000, 0x014470, 0x000000, 0xfe7c1b,
	0x000000, 0x01d10f, 0x000000, 0xfdcf39, 0x000000,
	0x02aaeb, 0x000000, 0xfcb2e7, 0x000000, 0x04311d,
	0x000000, 0xfa719c, 0x000000, 0x07f53f, 0x000000,
	0xf288b5, 0x000000, 0x28b482, 0x3fffff, 0x28b482,
	0x000000, 0xf288b5, 0x000000, 0x07f53f, 0x000000,
	0xfa719c, 0x000000, 0x04311d, 0x000000, 0xfcb2e7,
	0x000000, 0x02aaeb, 0x000000, 0xfdcf39, 0x000000,
	0x01d10f, 0x000000, 0xfe7c1b, 0x000000, 0x014470,
	0x000000, 0xfef07e, 0x000000, 0x00e2f1, 0x000000,
	0xff42ce, 0x000000, 0x009d20, 0x000000, 0xff7e26,
	0x000000, 0x006ab0, 0x000000, 0xffa8f1, 0x000000,
	0x00467f, 0x000000, 0xffc767, 0x000000, 0x002d01,
	0x000000, 0xffdc97, 0x000000, 0x001b8a, 0x000000,
	0xffeadc, 0x000000, 0x000fff, 0x000000, 0xfff416,
	0x000000, 0x0008b7, 0x000000, 0xfff9c1, 0x000000,
	0x000460, 0x000000, 0xfffd05, 0x000000, 0x0001f7,
	0x000000, 0xfffec1, 0x000000, 0x0000c0, 0x000000,
	0xffff94, 0x000000, 0x000038, 0x000000, 0xffffe8,
	0x000000, 0x000007
};

static const int lpf1_mode1[] = {
	0x000014, 0xffffb2, 0xfffed9, 0xfffdce, 0xfffd45,
	0xfffe32, 0x000147, 0x000645, 0x000b86, 0x000e21,
	0x000ae3, 0x000000, 0xffeece, 0xffdca8, 0xffd212,
	0xffd7d1, 0xfff2a7, 0x001f4c, 0x0050c2, 0x0072aa,
	0x006ff1, 0x003c32, 0xffdc4e, 0xff6a18, 0xff0fef,
	0xfefbaf, 0xff4c40, 0x000000, 0x00ebc8, 0x01c077,
	0x02209e, 0x01c1a4, 0x008e60, 0xfebe52, 0xfcd690,
	0xfb8fa5, 0xfba498, 0xfd9812, 0x0181ce, 0x06f5f3,
	0x0d112f, 0x12a958, 0x169686, 0x18000e, 0x169686,
	0x12a958, 0x0d112f, 0x06f5f3, 0x0181ce, 0xfd9812,
	0xfba498, 0xfb8fa5, 0xfcd690, 0xfebe52, 0x008e60,
	0x01c1a4, 0x02209e, 0x01c077, 0x00ebc8, 0x000000,
	0xff4c40, 0xfefbaf, 0xff0fef, 0xff6a18, 0xffdc4e,
	0x003c32, 0x006ff1, 0x0072aa, 0x0050c2, 0x001f4c,
	0xfff2a7, 0xffd7d1, 0xffd212, 0xffdca8, 0xffeece,
	0x000000, 0x000ae3, 0x000e21, 0x000b86, 0x000645,
	0x000147, 0xfffe32, 0xfffd45, 0xfffdce, 0xfffed9,
	0xffffb2, 0x000014,
};

static const int lpf3_mode1[] = {
	0x000000, 0x000081, 0x000000, 0xfffedb, 0x000000,
	0x00022d, 0x000000, 0xfffc46, 0x000000, 0x0005f7,
	0x000000, 0xfff6eb, 0x000000, 0x000d4e, 0x000000,
	0xffed1e, 0x000000, 0x001a1c, 0x000000, 0xffdcb0,
	0x000000, 0x002ede, 0x000000, 0xffc2d1, 0x000000,
	0x004ebe, 0x000000, 0xff9beb, 0x000000, 0x007dd7,
	0x000000, 0xff633a, 0x000000, 0x00c1d2, 0x000000,
	0xff11d5, 0x000000, 0x012368, 0x000000, 0xfe9c45,
	0x000000, 0x01b252, 0x000000, 0xfdebf6, 0x000000,
	0x0290b8, 0x000000, 0xfcca0d, 0x000000, 0x041d7c,
	0x000000, 0xfa8152, 0x000000, 0x07e9c6, 0x000000,
	0xf28fb5, 0x000000, 0x28b216, 0x3fffde, 0x28b216,
	0x000000, 0xf28fb5, 0x000000, 0x07e9c6, 0x000000,
	0xfa8152, 0x000000, 0x041d7c, 0x000000, 0xfcca0d,
	0x000000, 0x0290b8, 0x000000, 0xfdebf6, 0x000000,
	0x01b252, 0x000000, 0xfe9c45, 0x000000, 0x012368,
	0x000000, 0xff11d5, 0x000000, 0x00c1d2, 0x000000,
	0xff633a, 0x000000, 0x007dd7, 0x000000, 0xff9beb,
	0x000000, 0x004ebe, 0x000000, 0xffc2d1, 0x000000,
	0x002ede, 0x000000, 0xffdcb0, 0x000000, 0x001a1c,
	0x000000, 0xffed1e, 0x000000, 0x000d4e, 0x000000,
	0xfff6eb, 0x000000, 0x0005f7, 0x000000, 0xfffc46,
	0x000000, 0x00022d, 0x000000, 0xfffedb, 0x000000,
	0x000081, 0x000000,
};

static const int lpf1_mode2[] = {
	0x000014, 0xffffb2, 0xfffed9, 0xfffdce, 0xfffd45,
	0xfffe32, 0x000147, 0x000645, 0x000b86, 0x000e21,
	0x000ae3, 0x000000, 0xffeece, 0xffdca8, 0xffd212,
	0xffd7d1, 0xfff2a7, 0x001f4c, 0x0050c2, 0x0072aa,
	0x006ff1, 0x003c32, 0xffdc4e, 0xff6a18, 0xff0fef,
	0xfefbaf, 0xff4c40, 0x000000, 0x00ebc8, 0x01c077,
	0x02209e, 0x01c1a4, 0x008e60, 0xfebe52, 0xfcd690,
	0xfb8fa5, 0xfba498, 0xfd9812, 0x0181ce, 0x06f5f3,
	0x0d112f, 0x12a958, 0x169686, 0x18000e, 0x169686,
	0x12a958, 0x0d112f, 0x06f5f3, 0x0181ce, 0xfd9812,
	0xfba498, 0xfb8fa5, 0xfcd690, 0xfebe52, 0x008e60,
	0x01c1a4, 0x02209e, 0x01c077, 0x00ebc8, 0x000000,
	0xff4c40, 0xfefbaf, 0xff0fef, 0xff6a18, 0xffdc4e,
	0x003c32, 0x006ff1, 0x0072aa, 0x0050c2, 0x001f4c,
	0xfff2a7, 0xffd7d1, 0xffd212, 0xffdca8, 0xffeece,
	0x000000, 0x000ae3, 0x000e21, 0x000b86, 0x000645,
	0x000147, 0xfffe32, 0xfffd45, 0xfffdce, 0xfffed9,
	0xffffb2, 0x000014
};

static const int lpf3_mode2[] = {
	0x00005e, 0xffff19, 0xfffe3e, 0x00030a, 0x0004de,
	0xfff899, 0xfff531, 0x000f4a, 0x001510, 0xffe39e,
	0xffda78, 0x0030d1, 0x003e97, 0xffb0c5, 0xff9cd2,
	0x007aec, 0x009706, 0xff47dd, 0xff20f2, 0x010cbd,
	0x01426b, 0xfe7e4e, 0xfe3340, 0x0226a1, 0x0293d1,
	0xfce4d3, 0xfc382d, 0x04ad05, 0x05ef42, 0xf82315,
	0xf4bde1, 0x130bdd, 0x399128, 0x399128, 0x130bdd,
	0xf4bde1, 0xf82315, 0x05ef42, 0x04ad05, 0xfc382d,
	0xfce4d3, 0x0293d1, 0x0226a1, 0xfe3340, 0xfe7e4e,
	0x01426b, 0x010cbd, 0xff20f2, 0xff47dd, 0x009706,
	0x007aec, 0xff9cd2, 0xffb0c5, 0x003e97, 0x0030d1,
	0xffda78, 0xffe39e, 0x001510, 0x000f4a, 0xfff531,
	0xfff899, 0x0004de, 0x00030a, 0xfffe3e, 0xffff19,
	0x00005e
};

static const int lpf1_mode3[] = {
	0x000000, 0xfffc12, 0xfff5cb, 0xfff022, 0xffeffa,
	0xfffa03, 0x000f84, 0x002b96, 0x00429d, 0x00455c,
	0x00277a, 0xffe762, 0xff93e1, 0xff4bc4, 0xff3567,
	0xff6f81, 0x000000, 0x00c850, 0x018619, 0x01e3e3,
	0x01972b, 0x008323, 0xfed332, 0xfd00e8, 0xfbbe66,
	0xfbc791, 0xfda631, 0x017bb2, 0x06e40b, 0x0cfe8e,
	0x129dfd, 0x1693d6, 0x18011b, 0x1693d6, 0x129dfd,
	0x0cfe8e, 0x06e40b, 0x017bb2, 0xfda631, 0xfbc791,
	0xfbbe66, 0xfd00e8, 0xfed332, 0x008323, 0x01972b,
	0x01e3e3, 0x018619, 0x00c850, 0x000000, 0xff6f81,
	0xff3567, 0xff4bc4, 0xff93e1, 0xffe762, 0x00277a,
	0x00455c, 0x00429d, 0x002b96, 0x000f84, 0xfffa03,
	0xffeffa, 0xfff022, 0xfff5cb, 0xfffc12, 0x000000,
};

static const int lpf3_mode3[] = {
	0x000000, 0xfff4f6, 0x000000, 0x001e36, 0x000000,
	0xffbfb6, 0x000000, 0x007789, 0x000000, 0xff3423,
	0x000000, 0x0147cc, 0x000000, 0xfe0523, 0x000000,
	0x02ffbb, 0x000000, 0xfb728b, 0x000000, 0x0732af,
	0x000000, 0xf301d5, 0x000000, 0x288c99, 0x40023d,
	0x288c99, 0x000000, 0xf301d5, 0x000000, 0x0732af,
	0x000000, 0xfb728b, 0x000000, 0x02ffbb, 0x000000,
	0xfe0523, 0x000000, 0x0147cc, 0x000000, 0xff3423,
	0x000000, 0x007789, 0x000000, 0xffbfb6, 0x000000,
	0x001e36, 0x000000, 0xfff4f6, 0x000000
};

static const int lpf1_mode4[] = {
	0xfff71d, 0xffd0ad, 0xffa4b6, 0xff8cdb, 0xffa5d4,
	0x000000, 0x009021, 0x012899, 0x0181ac, 0x0151f3,
	0x0070b6, 0xfef591, 0xfd46bc, 0xfc0b63, 0xfc00d4,
	0xfdbd02, 0x017215, 0x06c95c, 0x0ce665, 0x1295f9,
	0x169d63, 0x181214, 0x169d63, 0x1295f9, 0x0ce665,
	0x06c95c, 0x017215, 0xfdbd02, 0xfc00d4, 0xfc0b63,
	0xfd46bc, 0xfef591, 0x0070b6, 0x0151f3, 0x0181ac,
	0x012899, 0x009021, 0x000000, 0xffa5d4, 0xff8cdb,
	0xffa4b6, 0xffd0ad, 0xfff71d
};

static const int lpf3_mode4[] = {
	0xffd46b, 0xffb7a1, 0x006ded, 0x009ddb, 0xff25e9,
	0xfedaef, 0x018208, 0x01f591, 0xfd7972, 0xfcbff4,
	0x043527, 0x058a27, 0xf872cb, 0xf4f5a2, 0x12ef7c,
	0x399f1f, 0x399f1f, 0x12ef7c, 0xf4f5a2, 0xf872cb,
	0x058a27, 0x043527, 0xfcbff4, 0xfd7972, 0x01f591,
	0x018208, 0xfedaef, 0xff25e9, 0x009ddb, 0x006ded,
	0xffb7a1, 0xffd46b
};

#define NUM_PDM_GAIN_INDEX 49
#define NUM_PDM_OSR_INDEX 9

enum {
	PDM_OSR_384 = 0,
	PDM_OSR_192,
	PDM_OSR_128,
	PDM_OSR_96,
	PDM_OSR_64,
	PDM_OSR_56,
	PDM_OSR_48,
	PDM_OSR_40,
	PDM_OSR_32
};

/* min: 0 dB; max: 24 dB; step = 0.5 dB/step */
static const int pdm_gain_table[NUM_PDM_GAIN_INDEX][NUM_PDM_OSR_INDEX] = {
/* osr: 384,    192,    128,    96,     64,     56,     48,     40,     32 */
	{ 0x2778, 0x2078, 0x1c80, 0x1978, 0x1580, 0x1351, 0x1278, 0x106b, 0x0e80,}, // 0dB
	{ 0x277f, 0x207f, 0x1b44, 0x197f, 0x1444, 0x1356, 0x127f, 0x1071, 0x0d44,}, // 0.5dB
	{ 0x2643, 0x1f43, 0x1b48, 0x1843, 0x1448, 0x135b, 0x1143, 0x1078, 0x0d48,}, // 1dB
	{ 0x2647, 0x1f47, 0x1b4c, 0x1847, 0x144c, 0x1360, 0x1147, 0x107f, 0x0d4c,}, // 1.5dB
	{ 0x264c, 0x1f4c, 0x1b51, 0x184c, 0x1451, 0x1366, 0x114c, 0x0f43, 0x0d51,}, // 2dB
	{ 0x2650, 0x1f50, 0x1b55, 0x1850, 0x1455, 0x136c, 0x1150, 0x0f47, 0x0d55,}, // 2.5dB
	{ 0x2655, 0x1f55, 0x1b5a, 0x1855, 0x145a, 0x1372, 0x1155, 0x0f4c, 0x0d5a,}, // 3dB
	{ 0x265a, 0x1f5a, 0x1b60, 0x185a, 0x1460, 0x1379, 0x115a, 0x0f50, 0x0d60,}, // 3.5dB
	{ 0x265f, 0x1f5f, 0x1b65, 0x185f, 0x1465, 0x1240, 0x115f, 0x0f55, 0x0d65,}, // 4dB
	{ 0x2665, 0x1f65, 0x1b6b, 0x1865, 0x146b, 0x1244, 0x1165, 0x0f5a, 0x0d6b,}, // 4.5dB
	{ 0x266b, 0x1f6b, 0x1b72, 0x186b, 0x1472, 0x1248, 0x116b, 0x0f5f, 0x0d72,}, // 5dB
	{ 0x2671, 0x1f71, 0x1b79, 0x1871, 0x1479, 0x124c, 0x1171, 0x0f65, 0x0d79,}, // 5.5dB
	{ 0x2678, 0x1f78, 0x1b80, 0x1878, 0x1480, 0x1251, 0x1178, 0x0f6b, 0x0d80,}, // 6dB
	{ 0x267f, 0x1f7f, 0x1a44, 0x187f, 0x1344, 0x1256, 0x117f, 0x0f71, 0x0c44,}, // 6.5dB
	{ 0x2543, 0x1e43, 0x1a48, 0x1743, 0x1348, 0x125b, 0x1043, 0x0f78, 0x0c48,}, // 7dB
	{ 0x2547, 0x1e47, 0x1a4c, 0x1747, 0x134c, 0x1260, 0x1047, 0x0f7f, 0x0c4c,}, // 7.5dB
	{ 0x254b, 0x1e4b, 0x1a50, 0x174b, 0x1350, 0x1266, 0x104b, 0x0e43, 0x0c50,}, // 8dB
	{ 0x2550, 0x1e50, 0x1a55, 0x1750, 0x1355, 0x126c, 0x1050, 0x0e47, 0x0c55,}, // 8.5dB
	{ 0x2555, 0x1e55, 0x1a5a, 0x1755, 0x135a, 0x1272, 0x1055, 0x0e4b, 0x0c5a,}, // 9dB
	{ 0x255a, 0x1e5a, 0x1a60, 0x175a, 0x1360, 0x1279, 0x105a, 0x0e50, 0x0c60,}, // 9.5dB
	{ 0x255f, 0x1e5f, 0x1a65, 0x175f, 0x1365, 0x1140, 0x105f, 0x0e55, 0x0c65,}, // 10dB
	{ 0x2564, 0x1e64, 0x1a6b, 0x1764, 0x136b, 0x1144, 0x1064, 0x0e5a, 0x0c6b,}, // 10.5dB
	{ 0x256a, 0x1e6a, 0x1a72, 0x176a, 0x1372, 0x1148, 0x106a, 0x0e5f, 0x0c72,}, // 11dB
	{ 0x2571, 0x1e71, 0x1a78, 0x1771, 0x1378, 0x114c, 0x1071, 0x0e65, 0x0c78,}, // 11.5dB
	{ 0x2577, 0x1e77, 0x1a7f, 0x1777, 0x137f, 0x1151, 0x1077, 0x0e6a, 0x0c7f,}, // 12dB
	{ 0x257f, 0x1e7f, 0x1943, 0x177f, 0x1243, 0x1155, 0x107f, 0x0e71, 0x0b43,}, // 12.5dB
	{ 0x2443, 0x1d43, 0x1947, 0x1643, 0x1247, 0x115a, 0x0f43, 0x0e77, 0x0b47,}, // 13dB
	{ 0x2447, 0x1d47, 0x194c, 0x1647, 0x124c, 0x1160, 0x0f47, 0x0e7f, 0x0b4c,}, // 13.5dB
	{ 0x244b, 0x1d4b, 0x1950, 0x164b, 0x1250, 0x1165, 0x0f4b, 0x0d43, 0x0b50,}, // 14dB
	{ 0x2450, 0x1d50, 0x1955, 0x1650, 0x1255, 0x116c, 0x0f50, 0x0d47, 0x0b55,}, // 14.5dB
	{ 0x2454, 0x1d54, 0x195a, 0x1654, 0x125a, 0x1172, 0x0f54, 0x0d4b, 0x0b5a,}, // 15dB
	{ 0x2459, 0x1d59, 0x195f, 0x1659, 0x125f, 0x1179, 0x0f59, 0x0d50, 0x0b5f,}, // 15.5dB
	{ 0x245f, 0x1d5f, 0x1965, 0x165f, 0x1265, 0x1180, 0x0f5f, 0x0d54, 0x0b65,}, // 16dB
	{ 0x2464, 0x1d64, 0x196b, 0x1664, 0x126b, 0x1044, 0x0f64, 0x0d59, 0x0b6b,}, // 16.5dB
	{ 0x246a, 0x1d6a, 0x1971, 0x166a, 0x1271, 0x1048, 0x0f6a, 0x0d5f, 0x0b71,}, // 17dB
	{ 0x2470, 0x1d70, 0x1978, 0x1670, 0x1278, 0x104c, 0x0f70, 0x0d64, 0x0b78,}, // 17.5dB
	{ 0x2477, 0x1d77, 0x197f, 0x1677, 0x127f, 0x1050, 0x0f77, 0x0d6a, 0x0b7f,}, // 18dB
	{ 0x247e, 0x1d7e, 0x1843, 0x167e, 0x1143, 0x1055, 0x0f7e, 0x0d71, 0x0a43,}, // 18.5dB
	{ 0x2343, 0x1c43, 0x1847, 0x1543, 0x1147, 0x105a, 0x0e43, 0x0d77, 0x0a47,}, // 19dB
	{ 0x2347, 0x1c47, 0x184c, 0x1547, 0x114c, 0x1060, 0x0e47, 0x0d7e, 0x0a4c,}, // 19.5dB
	{ 0x234b, 0x1c4b, 0x1850, 0x154b, 0x1150, 0x1065, 0x0e4b, 0x0c43, 0x0a50,}, // 20dB
	{ 0x234f, 0x1c4f, 0x1855, 0x154f, 0x1155, 0x106b, 0x0e4f, 0x0c47, 0x0a55,}, // 20.5dB
	{ 0x2354, 0x1c54, 0x185a, 0x1554, 0x115a, 0x1072, 0x0e54, 0x0c4b, 0x0a5a,}, // 21dB
	{ 0x2359, 0x1c59, 0x185f, 0x1559, 0x115f, 0x1078, 0x0e59, 0x0c4f, 0x0a5f,}, // 21.5dB
	{ 0x235e, 0x1c5e, 0x1865, 0x155e, 0x1165, 0x107f, 0x0e5e, 0x0c54, 0x0a65,}, // 22dB
	{ 0x2364, 0x1c64, 0x186b, 0x1564, 0x116b, 0x0f44, 0x0e64, 0x0c59, 0x0a6b,}, // 22.5dB
	{ 0x236a, 0x1c6a, 0x1871, 0x156a, 0x1171, 0x0f48, 0x0e6a, 0x0c5e, 0x0a71,}, // 23dB
	{ 0x2370, 0x1c70, 0x1878, 0x1570, 0x1178, 0x0f4c, 0x0e70, 0x0c64, 0x0a78,}, // 23.5dB
	{ 0x2377, 0x1c77, 0x187f, 0x1577, 0x117f, 0x0f50, 0x0e77, 0x0c6a, 0x0a7f,}, // 24dB
};

#endif
