/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __C2_CLKC_H
#define __C2_CLKC_H

#define CLKID_FCLK_BASE				0
#define CLKID_FIXED_PLL				(CLKID_FCLK_BASE + 0)
#define CLKID_FCLK50M_DIV40			(CLKID_FCLK_BASE + 1)
#define CLKID_FCLK50M				(CLKID_FCLK_BASE + 2)
#define CLKID_FCLK_DIV2_DIV			(CLKID_FCLK_BASE + 3)
#define CLKID_FCLK_DIV2				(CLKID_FCLK_BASE + 4)
#define CLKID_FCLK_DIV2P5_DIV			(CLKID_FCLK_BASE + 5)
#define CLKID_FCLK_DIV2P5			(CLKID_FCLK_BASE + 6)
#define CLKID_FCLK_DIV3_DIV			(CLKID_FCLK_BASE + 7)
#define CLKID_FCLK_DIV3				(CLKID_FCLK_BASE + 8)
#define CLKID_FCLK_DIV4_DIV			(CLKID_FCLK_BASE + 9)
#define CLKID_FCLK_DIV4				(CLKID_FCLK_BASE + 10)
#define CLKID_FCLK_DIV5_DIV			(CLKID_FCLK_BASE + 11)
#define CLKID_FCLK_DIV5				(CLKID_FCLK_BASE + 12)
#define CLKID_FCLK_DIV7_DIV			(CLKID_FCLK_BASE + 13)
#define CLKID_FCLK_DIV7				(CLKID_FCLK_BASE + 14)

#define CLKID_GP_PLL_BASE                       (CLKID_FCLK_BASE + 15)
#define CLKID_GP_PLL_VCO			(CLKID_GP_PLL_BASE + 0)
#define CLKID_GP_PLL_OD1_DIV			(CLKID_GP_PLL_BASE + 1)
#define CLKID_GP_PLL_GATE1			(CLKID_GP_PLL_BASE + 2)
#define CLKID_GP_PLL_GATE2			(CLKID_GP_PLL_BASE + 3)
#define CLKID_GP_PLL_GATE3			(CLKID_GP_PLL_BASE + 4)
#define CLKID_GP_PLL				(CLKID_GP_PLL_BASE + 5)
#define CLKID_GP_PLL_OUT1_OD			(CLKID_GP_PLL_BASE + 6)
#define CLKID_GP_PLL_OUT2_OD			(CLKID_GP_PLL_BASE + 7)
#define CLKID_GP_PLL_OUT1_DIV2			(CLKID_GP_PLL_BASE + 8)
#define CLKID_GP_PLL_OUT2_DIV2			(CLKID_GP_PLL_BASE + 9)
#define CLKID_GP_PLL_MCLK1_MUX			(CLKID_GP_PLL_BASE + 10)
#define CLKID_GP_PLL_MCLK1_DIV			(CLKID_GP_PLL_BASE + 11)
#define CLKID_GP_PLL_MCLK1_GATE			(CLKID_GP_PLL_BASE + 12)
#define CLKID_GP_PLL_MCLK2_MUX			(CLKID_GP_PLL_BASE + 13)
#define CLKID_GP_PLL_MCLK2_DIV			(CLKID_GP_PLL_BASE + 14)
#define CLKID_GP_PLL_MCLK2_GATE			(CLKID_GP_PLL_BASE + 15)

#define CLKID_MIXED_BASE                        (CLKID_GP_PLL_BASE + 16)
#define CLKID_HIFI_PLL				(CLKID_MIXED_BASE + 0)
#define CLKID_SYS_PLL_VCO			(CLKID_MIXED_BASE + 1)
#define CLKID_SYS_PLL_GATE			(CLKID_MIXED_BASE + 2)
#define CLKID_SYS_PLL				(CLKID_MIXED_BASE + 3)

#define CLKID_SYS_B_SEL				(CLKID_MIXED_BASE + 4)
#define CLKID_SYS_B_DIV				(CLKID_MIXED_BASE + 5)
#define CLKID_SYS_B				(CLKID_MIXED_BASE + 6)
#define CLKID_SYS_A_SEL				(CLKID_MIXED_BASE + 7)
#define CLKID_SYS_A_DIV				(CLKID_MIXED_BASE + 8)
#define CLKID_SYS_A				(CLKID_MIXED_BASE + 9)
#define CLKID_SYS_CLK				(CLKID_MIXED_BASE + 10)
#define CLKID_AXI_A_SEL				(CLKID_MIXED_BASE + 11)
#define CLKID_AXI_A_DIV				(CLKID_MIXED_BASE + 12)
#define CLKID_AXI_A				(CLKID_MIXED_BASE + 13)
#define CLKID_AXI_B_SEL				(CLKID_MIXED_BASE + 14)
#define CLKID_AXI_B_DIV				(CLKID_MIXED_BASE + 15)
#define CLKID_AXI_B				(CLKID_MIXED_BASE + 16)
#define CLKID_AXI_CLK				(CLKID_MIXED_BASE + 17)

/* CPUCTRL_CLK_CTRL */
#define CLKID_CPU_BASE				(CLKID_MIXED_BASE + 18)
#define CLKID_CPU_DYN_CLK			(CLKID_CPU_BASE + 0)
#define CLKID_CPU_CLK				(CLKID_CPU_BASE + 1)
#define CLKID_AXI_CLK_FRCPU_DIV			(CLKID_CPU_BASE + 2)
#define CLKID_CTS_PCLK_DIV			(CLKID_CPU_BASE + 3)
#define CLKID_TRACE_CLK_DIV			(CLKID_CPU_BASE + 4)
#define CLKID_AXI_CLK_FRCPU_GATE		(CLKID_CPU_BASE + 5)
#define CLKID_CTS_PCLK_GATE			(CLKID_CPU_BASE + 6)
#define CLKID_TRACE_CLK_GATE			(CLKID_CPU_BASE + 7)

/* CLKTREE_SYS_OSCIN_CTRL gates*/
#define XTAL_BASE				(CLKID_CPU_BASE + 8)
#define CLKID_XTAL_CLKTREE			(XTAL_BASE + 0)
#define CLKID_XTAL_FIXPLL			(XTAL_BASE + 1)
#define CLKID_XTAL_DDRPLL			(XTAL_BASE + 2)
#define CLKID_XTAL_USB_CTRL			(XTAL_BASE + 3)
#define CLKID_XTAL_HIFIPLL			(XTAL_BASE + 4)
#define CLKID_XTAL_SYSPLL			(XTAL_BASE + 5)
#define CLKID_XTAL_DDS				(XTAL_BASE + 6)
#define CLKID_XTAL_ETHPLL			(XTAL_BASE + 7)
#define CLKID_XTAL_USBPHY			(XTAL_BASE + 8)
#define CLKID_XTAL_GPPLL			(XTAL_BASE + 9)
#define CLKID_XTAL_GPIOM10			(XTAL_BASE + 10)
#define CLKID_XTAL_GPIOM13			(XTAL_BASE + 11)
#define CLKID_XTAL_PAD_DS0			(XTAL_BASE + 12)
#define CLKID_XTAL_PAD_DS1			(XTAL_BASE + 13)
/* CLKTREE_SYS_CLK_EN0 gates*/
#define GATE_BASE0				(XTAL_BASE + 14)
#define CLKID_CLKTREE				(GATE_BASE0 + 0)
#define CLKID_RESET_CTRL			(GATE_BASE0 + 1)
#define CLKID_ANALOG_CTRL			(GATE_BASE0 + 2)
#define CLKID_PWR_CTRL				(GATE_BASE0 + 3)
#define CLKID_PAD_CTRL				(GATE_BASE0 + 4)
#define CLKID_SYS_CTRL				(GATE_BASE0 + 5)
#define CLKID_TEMP_SENSOR			(GATE_BASE0 + 6)
#define CLKID_AM2AXI_DIV			(GATE_BASE0 + 7)
#define CLKID_SPICC_B				(GATE_BASE0 + 8)
#define CLKID_SPICC_A				(GATE_BASE0 + 9)
#define CLKID_CLK_MSR				(GATE_BASE0 + 10)
#define CLKID_AUDIO				(GATE_BASE0 + 11)
#define CLKID_JTAG_CTRL				(GATE_BASE0 + 12)
#define CLKID_SARADC				(GATE_BASE0 + 13)
#define CLKID_PWM_EF				(GATE_BASE0 + 14)
#define CLKID_PWM_CD				(GATE_BASE0 + 15)
#define CLKID_PWM_AB				(GATE_BASE0 + 16)
#define CLKID_I2C_S				(GATE_BASE0 + 17)
#define CLKID_IR_CTRL				(GATE_BASE0 + 18)
#define CLKID_I2C_M_D				(GATE_BASE0 + 19)
#define CLKID_I2C_M_C				(GATE_BASE0 + 20)
#define CLKID_I2C_M_B				(GATE_BASE0 + 21)
#define CLKID_I2C_M_A				(GATE_BASE0 + 22)
#define CLKID_ACODEC				(GATE_BASE0 + 23)
#define CLKID_OTP				(GATE_BASE0 + 24)
#define CLKID_SYS_SD_EMMC_A			(GATE_BASE0 + 25)
#define CLKID_USB_PHY				(GATE_BASE0 + 26)
#define CLKID_USB_CTRL				(GATE_BASE0 + 27)
#define CLKID_SYS_DSPA				(GATE_BASE0 + 28)
#define CLKID_DMA				(GATE_BASE0 + 29)
/* CLKTREE_SYS_CLK_EN1 gates*/
#define GATE_BASE1				(GATE_BASE0 + 30)
#define CLKID_IRQ_CTRL				(GATE_BASE1 + 0)
#define CLKID_NIC				(GATE_BASE1 + 1)
#define CLKID_GIC				(GATE_BASE1 + 2)
#define CLKID_UART_C				(GATE_BASE1 + 3)
#define CLKID_UART_B				(GATE_BASE1 + 4)
#define CLKID_UART_A				(GATE_BASE1 + 5)
#define CLKID_MMC				(GATE_BASE1 + 6)
#define CLKID_RSA				(GATE_BASE1 + 7)
#define CLKID_SYS_CORESIGHT			(GATE_BASE1 + 8)
#define CLKID_CSI_PH1				(GATE_BASE1 + 9)
#define CLKID_CSI_PHY0				(GATE_BASE1 + 10)
#define CLKID_MIPI_ISP				(GATE_BASE1 + 11)
#define CLKID_CSI_DIG				(GATE_BASE1 + 12)
#define CLKID_SYS_G2ED				(GATE_BASE1 + 13)
#define CLKID_SYS_GDC				(GATE_BASE1 + 14)
#define CLKID_DOS_APB				(GATE_BASE1 + 15)
#define CLKID_SYS_NNA				(GATE_BASE1 + 16)
#define CLKID_SYS_ETH_MAC			(GATE_BASE1 + 17)
#define CLKID_SYS_ETH_MAC_DDR			(GATE_BASE1 + 18)
#define CLKID_SYS_UART_E			(GATE_BASE1 + 19)
#define CLKID_SYS_UART_D			(GATE_BASE1 + 20)
#define CLKID_SYS_PWM_IJ			(GATE_BASE1 + 21)
#define CLKID_SYS_PWM_GH			(GATE_BASE1 + 22)
#define CLKID_SYS_I2C_M_E			(GATE_BASE1 + 23)
#define CLKID_SYS_SD_EMMC_C			(GATE_BASE1 + 24)
#define CLKID_SYS_SD_EMMC_B			(GATE_BASE1 + 25)
#define CLKID_SYS_ROM				(GATE_BASE1 + 26)
#define CLKID_SYS_SPIFC				(GATE_BASE1 + 27)
#define CLKID_SYS_PROD_I2C			(GATE_BASE1 + 28)
#define CLKID_SYS_DOS				(GATE_BASE1 + 29)
#define CLKID_SYS_CPU_CTRL			(GATE_BASE1 + 30)
#define CLKID_SYS_RAMA				(GATE_BASE1 + 31)
#define CLKID_SYS_CAPU_SECPU			(GATE_BASE1 + 32)
#define CLKID_SYS_MAILBOX			(GATE_BASE1 + 33)
/* CLKTREE_AXI_CLK_EN gates */
#define GATE_BASE2				(GATE_BASE1 + 34)
#define CLKID_AM2AXI_VAD			(GATE_BASE2 + 0)
#define CLKID_AUDIO_VAD				(GATE_BASE2 + 1)
#define CLKID_AXI_DMC				(GATE_BASE2 + 2)
#define CLKID_AXI_RAMA				(GATE_BASE2 + 3)
#define CLKID_AXI_NIC				(GATE_BASE2 + 4)
#define CLKID_AXI_DMA				(GATE_BASE2 + 5)
#define CLKID_AXI_NIC_VAD			(GATE_BASE2 + 6)
#define CLKID_AXI_CAPU				(GATE_BASE2 + 7)
/* dsp clks */
#define DSP_BASE				(GATE_BASE2 + 8)
#define CLKID_DSPA_A_SEL			(DSP_BASE + 0)
#define CLKID_DSPA_A_DIV			(DSP_BASE + 1)
#define CLKID_DSPA_A				(DSP_BASE + 2)
#define CLKID_DSPA_B_SEL			(DSP_BASE + 3)
#define CLKID_DSPA_B_DIV			(DSP_BASE + 4)
#define CLKID_DSPA_B				(DSP_BASE + 5)
#define CLKID_DSPA_SEL				(DSP_BASE + 6)
#define CLKID_DSPA_EN_DSPA			(DSP_BASE + 7)
#define CLKID_DSPA_EN_NIC			(DSP_BASE + 8)
/* 32k: rtc and ceca clock */
#define RTC_32K_BASE				(DSP_BASE + 9)
#define CLKID_RTC_32K_CLKIN			(RTC_32K_BASE + 0)
#define CLKID_RTC_32K_DIV			(RTC_32K_BASE + 1)
#define CLKID_RTC_32K_XTAL			(RTC_32K_BASE + 2)
#define CLKID_RTC_32K_SEL			(RTC_32K_BASE + 3)
#define CLKID_RTC_CLK				(RTC_32K_BASE + 4)
/* 12m/24m/gen clks */
#define BASIC_BASE				(RTC_32K_BASE + 5)
#define CLKID_24M				(BASIC_BASE + 0)
#define CLKID_24M_DIV2				(BASIC_BASE + 1)
#define CLKID_12M				(BASIC_BASE + 2)
#define CLKID_DIV2_PRE				(BASIC_BASE + 3)
#define CLKID_FCLK_DIV2_DIVN			(BASIC_BASE + 4)
#define CLKID_GEN_SEL				(BASIC_BASE + 5)
#define CLKID_GEN_DIV				(BASIC_BASE + 6)
#define CLKID_GEN				(BASIC_BASE + 7)
#define CLKID_SARADC_SEL			(BASIC_BASE + 8)
#define CLKID_SARADC_DIV			(BASIC_BASE + 9)
#define CLKID_SARADC_GATE			(BASIC_BASE + 10)
#define CLKID_PWM_A_SEL				(BASIC_BASE + 11)
#define CLKID_PWM_A_DIV				(BASIC_BASE + 12)
#define CLKID_PWM_A				(BASIC_BASE + 13)
#define CLKID_PWM_B_SEL				(BASIC_BASE + 14)
#define CLKID_PWM_B_DIV				(BASIC_BASE + 15)
#define CLKID_PWM_B				(BASIC_BASE + 16)
#define CLKID_PWM_C_SEL				(BASIC_BASE + 17)
#define CLKID_PWM_C_DIV				(BASIC_BASE + 18)
#define CLKID_PWM_C				(BASIC_BASE + 19)
#define CLKID_PWM_D_SEL				(BASIC_BASE + 20)
#define CLKID_PWM_D_DIV				(BASIC_BASE + 21)
#define CLKID_PWM_D				(BASIC_BASE + 22)
#define CLKID_PWM_E_SEL				(BASIC_BASE + 23)
#define CLKID_PWM_E_DIV				(BASIC_BASE + 24)
#define CLKID_PWM_E				(BASIC_BASE + 25)
#define CLKID_PWM_F_SEL				(BASIC_BASE + 26)
#define CLKID_PWM_F_DIV				(BASIC_BASE + 27)
#define CLKID_PWM_F				(BASIC_BASE + 28)
#define CLKID_PWM_G_SEL				(BASIC_BASE + 29)
#define CLKID_PWM_G_DIV				(BASIC_BASE + 30)
#define CLKID_PWM_G				(BASIC_BASE + 31)
#define CLKID_PWM_H_SEL				(BASIC_BASE + 32)
#define CLKID_PWM_H_DIV				(BASIC_BASE + 33)
#define CLKID_PWM_H				(BASIC_BASE + 34)
#define CLKID_PWM_I_SEL				(BASIC_BASE + 35)
#define CLKID_PWM_I_DIV				(BASIC_BASE + 36)
#define CLKID_PWM_I				(BASIC_BASE + 37)
#define CLKID_PWM_J_SEL				(BASIC_BASE + 38)
#define CLKID_PWM_J_DIV				(BASIC_BASE + 39)
#define CLKID_PWM_J				(BASIC_BASE + 40)
#define CLKID_SPICC_A_SEL			(BASIC_BASE + 41)
#define CLKID_SPICC_A_DIV			(BASIC_BASE + 42)
#define CLKID_SPICC_A_GATE			(BASIC_BASE + 43)
#define CLKID_SPICC_A_MUX			(BASIC_BASE + 44)
#define CLKID_SPICC_B_SEL			(BASIC_BASE + 45)
#define CLKID_SPICC_B_DIV			(BASIC_BASE + 46)
#define CLKID_SPICC_B_GATE			(BASIC_BASE + 47)
#define CLKID_SPICC_B_MUX			(BASIC_BASE + 48)

#define CLKID_TS_DIV				(BASIC_BASE + 49)
#define CLKID_TS				(BASIC_BASE + 50)

#define BASIC_BASE2				(BASIC_BASE + 51)
#define CLKID_SPIFC_SEL				(BASIC_BASE2 + 0)
#define CLKID_SPIFC_DIV				(BASIC_BASE2 + 1)
#define CLKID_SPIFC_GATE			(BASIC_BASE2 + 2)
#define CLKID_SPIFC				(BASIC_BASE2 + 3)
#define CLKID_USB_BUS_SEL			(BASIC_BASE2 + 4)
#define CLKID_USB_BUS_DIV			(BASIC_BASE2 + 5)
#define CLKID_USB_BUS				(BASIC_BASE2 + 6)
#define CLKID_SD_EMMC_A_SEL			(BASIC_BASE2 + 7)
#define CLKID_SD_EMMC_A_DIV			(BASIC_BASE2 + 8)
#define CLKID_SD_EMMC_A_GATE			(BASIC_BASE2 + 9)
#define CLKID_SD_EMMC_A				(BASIC_BASE2 + 10)
#define CLKID_SD_EMMC_B_SEL			(BASIC_BASE2 + 11)
#define CLKID_SD_EMMC_B_DIV			(BASIC_BASE2 + 12)
#define CLKID_SD_EMMC_B_GATE			(BASIC_BASE2 + 13)
#define CLKID_SD_EMMC_B				(BASIC_BASE2 + 14)
#define CLKID_SD_EMMC_C_SEL			(BASIC_BASE2 + 15)
#define CLKID_SD_EMMC_C_DIV			(BASIC_BASE2 + 16)
#define CLKID_SD_EMMC_C_GATE			(BASIC_BASE2 + 17)
#define CLKID_SD_EMMC_C				(BASIC_BASE2 + 18)

/*mm clk*/

#define CLKID_MM_BASE0				(BASIC_BASE2 + 19)
#define CLKID_WAVE_A_SEL			(CLKID_MM_BASE0 + 0)
#define CLKID_WAVE_A_DIV			(CLKID_MM_BASE0 + 1)
#define CLKID_WAVE_A_CLK			(CLKID_MM_BASE0 + 2)
#define CLKID_WAVE_A_GATE			(CLKID_MM_BASE0 + 3)
#define CLKID_WAVE_B_SEL			(CLKID_MM_BASE0 + 4)
#define CLKID_WAVE_B_DIV			(CLKID_MM_BASE0 + 5)
#define CLKID_WAVE_B_CLK			(CLKID_MM_BASE0 + 6)
#define CLKID_WAVE_B_GATE			(CLKID_MM_BASE0 + 7)
#define CLKID_WAVE_C_SEL			(CLKID_MM_BASE0 + 8)
#define CLKID_WAVE_C_DIV			(CLKID_MM_BASE0 + 9)
#define CLKID_WAVE_C_CLK			(CLKID_MM_BASE0 + 10)
#define CLKID_WAVE_C_GATE			(CLKID_MM_BASE0 + 11)
#define CLKID_JPEG_SEL				(CLKID_MM_BASE0 + 12)
#define CLKID_JPEG_DIV				(CLKID_MM_BASE0 + 13)
#define CLKID_JPEG_CLK				(CLKID_MM_BASE0 + 14)
#define CLKID_JPEG_GATE				(CLKID_MM_BASE0 + 15)

#define CLKID_MM_BASE1				(CLKID_MM_BASE0 + 16)
#define CLKID_MIPI_CSI_PHY_SEL			(CLKID_MM_BASE1 + 0)
#define CLKID_MIPI_CSI_PHY_DIV			(CLKID_MM_BASE1 + 1)
#define CLKID_MIPI_CSI_PHY_CLK			(CLKID_MM_BASE1 + 2)
#define CLKID_MIPI_CSI_PHY_GATE			(CLKID_MM_BASE1 + 3)
#define CLKID_MIPI_ISP_SEL			(CLKID_MM_BASE1 + 4)
#define CLKID_MIPI_ISP_DIV			(CLKID_MM_BASE1 + 5)
#define CLKID_MIPI_ISP_CLK			(CLKID_MM_BASE1 + 6)
#define CLKID_MIPI_ISP_GATE			(CLKID_MM_BASE1 + 7)
#define CLKID_NNA_AXI_SEL			(CLKID_MM_BASE1 + 8)
#define CLKID_NNA_AXI_DIV			(CLKID_MM_BASE1 + 9)
#define CLKID_NNA_AXI_CLK			(CLKID_MM_BASE1 + 10)
#define CLKID_NNA_AXI_GATE			(CLKID_MM_BASE1 + 11)
#define CLKID_NNA_CORE_SEL			(CLKID_MM_BASE1 + 12)
#define CLKID_NNA_CORE_DIV			(CLKID_MM_BASE1 + 13)
#define CLKID_NNA_CORE_CLK			(CLKID_MM_BASE1 + 14)
#define CLKID_NNA_CORE_GATE			(CLKID_MM_BASE1 + 15)
#define CLKID_GDC_AXI_SEL			(CLKID_MM_BASE1 + 16)
#define CLKID_GDC_AXI_DIV			(CLKID_MM_BASE1 + 17)
#define CLKID_GDC_AXI_CLK			(CLKID_MM_BASE1 + 18)
#define CLKID_GDC_AXI_GATE			(CLKID_MM_BASE1 + 19)
#define CLKID_GDC_CORE_SEL			(CLKID_MM_BASE1 + 20)
#define CLKID_GDC_CORE_DIV			(CLKID_MM_BASE1 + 21)
#define CLKID_GDC_CORE_CLK			(CLKID_MM_BASE1 + 22)
#define CLKID_GDC_CORE_GATE			(CLKID_MM_BASE1 + 23)
#define CLKID_GE2D_SEL				(CLKID_MM_BASE1 + 24)
#define CLKID_GE2D_DIV				(CLKID_MM_BASE1 + 25)
#define CLKID_GE2D_CLK				(CLKID_MM_BASE1 + 26)
#define CLKID_GE2D_GATE				(CLKID_MM_BASE1 + 27)

#define CLKID_SECPU_BASE			(CLKID_MM_BASE1 + 28)
#define CLKID_SECPU_SEL				(CLKID_SECPU_BASE + 0)
#define CLKID_SECPU_DIV				(CLKID_SECPU_BASE + 1)
#define CLKID_SECPU_CLK				(CLKID_SECPU_BASE + 2)
#define CLKID_SECPU_GATE			(CLKID_SECPU_BASE + 3)

#define CLKID_END_BASE				(CLKID_SECPU_BASE + 4)
#endif /* __C2_CLKC_H */
