/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef EDP_TX_REG_H
#define EDP_TX_REG_H

#define EDP_TX_LINK_BW_SET					0x0000
#define EDP_TX_LINK_COUNT_SET					0x0004
#define EDP_TX_ENHANCED_FRAME_EN				0x0008
#define EDP_TX_TRAINING_PATTERN_SET				0x000c
#define EDP_TX_LINK_QUAL_PATTERN_SET				0x0010
#define EDP_TX_SCRAMBLING_DISABLE				0x0014
#define EDP_TX_DOWNSPREAD_CTRL					0x0018
#define EDP_TX_ALTERNATE_SCRAMBLER_RESET			0x001c
#define EDP_TX_PANEL_SELF_REFRESH				0x0020

#define EDP_TX_TRANSMITTER_OUTPUT_ENABLE			0x0080
#define EDP_TX_MAIN_STREAM_ENABLE				0x0084
#define EDP_TX_SECONDARY_STREAM_ENABLE				0x0088
#define EDP_TX_FORCE_SCRAMBLER_RESET				0x00c0
#define EDP_TX_USER_CONTROL_STATUS				0x00c4

#define EDP_TX_CORE_CAPABILITIES				0x00f8
#define EDP_TX_CORE_ID						0x00fc

#define EDP_TX_AUX_COMMAND					0x0100
#define EDP_TX_AUX_WRITE_FIFO					0x0104
#define EDP_TX_AUX_ADDRESS					0x0108
#define EDP_TX_AUX_CLOCK_DIVIDER				0x010c
#define EDP_TX_AUX_STATE					0x0130
#define EDP_TX_AUX_REPLY_DATA					0x0134
#define EDP_TX_AUX_REPLY_CODE					0x0138
#define EDP_TX_AUX_REPLY_COUNT					0x013c
#define EDP_TX_AUX_INTERRUPT_STATUS				0x0140
#define EDP_TX_AUX_INTERRUPT_MASK				0x0144
#define EDP_TX_AUX_REPLY_DATA_COUNT				0x0148
#define EDP_TX_AUX_TRANSFER_STATUS				0x014c
#define EDP_TX_AUX_REPLY_CLOCK_WIDTH				0x0150

#define EDP_TX_MAIN_STREAM_HTOTAL				0x0180
#define EDP_TX_MAIN_STREAM_VTOTAL				0x0184
#define EDP_TX_MAIN_STREAM_POLARITY				0x0188
#define EDP_TX_MAIN_STREAM_HSWIDTH				0x018c
#define EDP_TX_MAIN_STREAM_VSWIDTH				0x0190
#define EDP_TX_MAIN_STREAM_HRES					0x0194
#define EDP_TX_MAIN_STREAM_VRES					0x0198
#define EDP_TX_MAIN_STREAM_HSTART				0x019c
#define EDP_TX_MAIN_STREAM_VSTART				0x01a0
#define EDP_TX_MAIN_STREAM_MISC0				0x01a4
#define EDP_TX_MAIN_STREAM_MISC1				0x01a8
#define EDP_TX_MAIN_STREAM_M_VID				0x01ac
#define EDP_TX_MAIN_STREAM_TRANSFER_UNIT_SIZE			0x01b0
#define EDP_TX_MAIN_STREAM_N_VID				0x01b4
#define EDP_TX_MAIN_STREAM_USER_PIXEL_WIDTH			0x01b8
#define EDP_TX_MAIN_STREAM_DATA_COUNT_PER_LANE			0x01bc
#define EDP_TX_MAIN_STREAM_INTERLACED				0x01c0
#define EDP_TX_MAIN_STREAM_USER_SYNC_POLARITY			0x01c4

#define EDP_TX_PHY_RESET					0x0200
#define EDP_TX_PHY_PRE_EMPHASIS_LANE_0				0x0210
#define EDP_TX_PHY_PRE_EMPHASIS_LANE_1				0x0214
#define EDP_TX_PHY_PRE_EMPHASIS_LANE_2				0x0218
#define EDP_TX_PHY_PRE_EMPHASIS_LANE_3				0x021c
#define EDP_TX_PHY_VOLTAGE_DIFF_LANE_0				0x0220
#define EDP_TX_PHY_VOLTAGE_DIFF_LANE_1				0x0224
#define EDP_TX_PHY_VOLTAGE_DIFF_LANE_2				0x0228
#define EDP_TX_PHY_VOLTAGE_DIFF_LANE_3				0x022c
#define EDP_TX_PHY_TRANSMIT_PRBS7				0x0230
#define EDP_TX_PHY_POWER_DOWN					0x0238
#define EDP_TX_PHY_POST_EMPHASIS_LANE_0				0x0240
#define EDP_TX_PHY_POST_EMPHASIS_LANE_1				0x0244
#define EDP_TX_PHY_POST_EMPHASIS_LANE_2				0x024c
#define EDP_TX_PHY_POST_EMPHASIS_LANE_3				0x024c
#define EDP_TX_PHY_STATUS					0x0280

#define EDP_TX_HDCP_ENABLE					0x0400
#define EDP_TX_HDCP_KM_LOWER					0x0410
#define EDP_TX_HDCP_KM_UPPER					0x0414
#define EDP_TX_HDCP_AN_LOWER					0x0418
#define EDP_TX_HDCP_AN_UPPER					0x041c
#define EDP_TX_HDCP_AUTO_AN_VALUE_LOWER				0x0420
#define EDP_TX_HDCP_AUTO_AN_VALUE_UPPER				0x0424
#define EDP_TX_HDCP_STATUS					0x0428

/********************************************************************
 ******eDP sink device DPCD register's******
 ********************************************************************
 */
/*DPCD information*/
#define DPCD_DPCD_REV				0x0000
#define DPCD_MAX_LINK_RATE			0x0001
#define DPCD_MAX_LANE_COUNT			0x0002
#define DPCD_MAX_DOWNSPREAD			0x0003
#define DPCD_NORP				0x0004
#define DPCD_DOWNSTREAMPORT_PRESENT		0x0005
#define DPCD_MAIN_LINK_CHANNEL_CODING		0x0006
#define DPCD_NUM_DOWNSTREAM_PORTS		0x0007
#define DPCD_RECEIVE_PORT0_CAP_0		0x0008
#define DPCD_RECEIVE_PORT0_CAP_1		0x0009
#define DPCD_RECEIVE_PORT1_CAP_0		0x000A
#define DPCD_RECEIVE_PORT1_CAP_1		0x000B
#define DPCD_I2C_SPEED_CAP			0x000C
#define DPCD_eDP_CONFIGURATION_CAP		0x000D
#define DPCD_TRAINING_AUX_RD_INTERVAL		0x000E
#define DPCD_FAUX_CAP				0x0020
#define DPCD_MSTM_CAP				0x0021
#define DPCD_NUMBER_OF_AUDIO_ENDPOINTS		0x0022
#define DPCD_PSR_SUPPORT			0x0070
#define DPCD_PSR_CAPS				0x0071
#define DPCD_DETAILED_CAP_INFO_AVAILABLE	0x0080

#define DPCD_LINK_BW_SET			0x0100
#define DPCD_LANE_COUNT_SET			0x0101
#define DPCD_TRAINING_PATTERN_SET		0x0102
#define DPCD_TRAINING_LANE0_SET			0x0103
#define DPCD_TRAINING_LANE1_SET			0x0104
#define DPCD_TRAINING_LANE2_SET			0x0105
#define DPCD_TRAINING_LANE3_SET			0x0106
#define DPCD_DOWNSPREAD_CONTROL			0x0107
#define DPCD_MAIN_LINK_CODING_SET		0x0108
#define DPCD_I2C_SPEED_CONTROL_STATUS_BIT_MAP	0x0109
#define DPCD_eDP_CONFIGURATION_SET		0x010A
#define DPCD_LINK_QUAL_LANE0_SET		0x010B
#define DPCD_LINK_QUAL_LANE1_SET		0x010C
#define DPCD_LINK_QUAL_LANE2_SET		0x010D
#define DPCD_LINK_QUAL_LANE3_SET		0x010E
#define DPCD_TRAINING_LANE0_1_SET2		0x010F
#define DPCD_TRAINING_LANE2_3_SET2		0x0110

#define DPCD_FAUX_MODE_CTRL			0x0120

#define DPCD_SINK_COUNT				0x0200
#define DPCD_DEVICE_SERVICE_IRQ_VECTOR		0x0201
#define DPCD_LANE0_1_STATUS			0x0202
#define DPCD_LANE2_3_STATUS			0x0203
#define DPCD_LANE_ALIGN__STATUS_UPDATED		0x0204
#define DPCD_SINK_STATUS			0x0205
#define DPCD_ADJUST_REQUEST_LANE0_1		0x0206
#define DPCD_ADJUST_REQUEST_LANE2_3		0x0207
#define DPCD_TRAINING_SCORE_LANE0		0x0208
#define DPCD_TRAINING_SCORE_LANE1		0x0209
#define DPCD_TRAINING_SCORE_LANE2		0x020A
#define DPCD_TRAINING_SCORE_LANE3		0x020B

#define DPCD_SYMBOL_ERROR_COUNT_LANE0		0x0210
#define DPCD_SYMBOL_ERROR_COUNT_LANE0_		0x0211
#define DPCD_SYMBOL_ERROR_COUNT_LANE1		0x0212
#define DPCD_SYMBOL_ERROR_COUNT_LANE1_		0x0213
#define DPCD_SYMBOL_ERROR_COUNT_LANE2		0x0214
#define DPCD_SYMBOL_ERROR_COUNT_LANE2_		0x0215
#define DPCD_SYMBOL_ERROR_COUNT_LANE3		0x0216
#define DPCD_SYMBOL_ERROR_COUNT_LANE3_		0x0217
#define DPCD_TEST_REQUEST			0x0218
#define DPCD_TEST_LINK_RATE			0x0219
#define DPCD_TEST_LANE_COUNT			0x0220
#define DPCD_TEST_PATTERN			0x0221
#define DPCD_TEST_H_TOTAL_BITH			0x0222
#define DPCD_TEST_H_TOTAL_BITL			0x0223
#define DPCD_TEST_V_TOTAL_BITH			0x0224
#define DPCD_TEST_V_TOTAL_BITL			0x0225
#define DPCD_TEST_H_START_BITH			0x0226
#define DPCD_TEST_H_START_BITL			0x0227
#define DPCD_TEST_V_START_BITH			0x0228
#define DPCD_TEST_V_START_BITL			0x0229
#define DPCD_TEST_HSYNC_BITH			0x022A
#define DPCD_TEST_HSYNC_BITL			0x022B
#define DPCD_TEST_VSYNC_BITH			0x022C
#define DPCD_TEST_VSYNC_BITL			0x022D
#define DPCD_TEST_H_WIDTH_BITH			0x022E
#define DPCD_TEST_H_WIDTH_BITL			0x022F
#define DPCD_TEST_V_HEIGHT_BITH			0x0230
#define DPCD_TEST_V_HEIGHT_BITL			0x0231
#define DPCD_TEST_MISC_BITH			0x0232
#define DPCD_TEST_MISC_BITL			0x0233
#define DPCD_TEST_REFRESH_RATE_NUMERATOR	0x0234

#define DPCD_TEST_RESPONSE			0x0260
#define DPCD_TEST_EDID_CHECKSUM			0x0261

// Source Device-Specific Field 0x0303 - 0x003FF : Reserved for vendor-specific usage
#define DPCD_SOURCE_IEEE_OUI_0			0x0300 // Source IEEE OUI 7:0
#define DPCD_SOURCE_IEEE_OUI_1			0x0301 // Source IEEE OUI 15:8
#define DPCD_SOURCE_IEEE_OUI_2			0x0302 // Source IEEE OUI 23:16

// Sink Device-Specific Field    0x0403 - 0x004FF : Reserved for vendor-specific usage
#define DPCD_SINK_IEEE_OUT_0			0x0400 // Sink IEEE OUI 7:0
#define DPCD_SINK_IEEE_OUT_1			0x0401 // Sink IEEE OUI 15:8
#define DPCD_SINK_IEEE_OUT_2			0x0402 // Sink IEEE OUI 23:16

// Branch Device-Specific Field  0x0503 - 0x005FF : Reserved for vendor-specific usage
#define DPCD_BRANCH_DEVICE_IEEE_OUI_0		0x0500 // Branch Device IEEE OUI 7:0
#define DPCD_BRANCH_DEVICE_IEEE_OUI_1		0x0501 // Branch Device IEEE OUI 15:8
#define DPCD_BRANCH_DEVICE_IEEE_OUI_2		0x0502 // Branch Device IEEE OUI 23:16
#define DPCD_SET_POWER				0x0600 // Set Power

//HDCP field in DPCD
#define DPCD_HDCP_BKSV				0x68000
#define DPCD_HDCP_ROPRIME			0x68005
#define DPCD_HDCP_AKSV				0x68007
#define DPCD_HDCP_AN				0x6800c
#define DPCD_HDCP_VPRIME_H1			0x68014
#define DPCD_HDCP_VPRIME_H2			0x68018
#define DPCD_HDCP_VPRIME_H3			0x6801c
#define DPCD_HDCP_VPRIME_H4			0x68020
#define DPCD_HDCP_VPRIME_H5			0x68024
#define DPCD_HDCP_BCAPS				0x68028
#define DPCD_HDCP_BSTATUS			0x68029
#define DPCD_HDCP_BINFO				0x6802a
#define DPCD_HDCP_KSVFIFO			0x6802c
#define DPCD_HDCP_RESERVED			0x6803b
#define DPCD_HDCP_DEBUG				0x680c0

#endif
