// SPDX-License-Identifier: (GPL-2.0+ OR MIT)
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#include <linux/amlogic/media/vout/hdmitx_common/hdmitx_dev_common.h>
#include <linux/platform_device.h>
#include "../hdmitx21/hdmi_tx.h"

int hdmitx_dev_setup_vsif_packet(struct hdmitx_common *tx_comm,
	struct hdmitx_hw_common *tx_hw, enum vsif_type type, int on, void *param)
{
	u8 hb[3] = {0x81, 0x1, 0};
	u8 len = 0; /* hb[2] = len */
	u8 vsif_db[28] = {0}; /* to be fulfilled */
	u8 *db = &vsif_db[1]; /* to be fulfilled */
	u32 ieeeoui = 0;
	u32 vic = 0;

	if (type >= VT_MAX)
		return -EINVAL;

	switch (type) {
	case VT_DEFAULT:
		break;
	case VT_HDMI14_4K:
		ieeeoui = HDMI_IEEE_OUI;
		len = 5;
		hb[2] = len;
		db[0] = GET_OUI_BYTE0(ieeeoui);
		db[1] = GET_OUI_BYTE1(ieeeoui);
		db[2] = GET_OUI_BYTE2(ieeeoui);
		vic = hdmitx_edid_get_hdmi14_4k_vic(tx_comm->cur_VIC);
		if (vic > 0) {
			db[4] = vic & 0xf;
			db[3] = 0x20;
			tx_hw->cntlconfig(tx_hw, CONF_AVI_VIC, 0);
		} else {
			pr_info("skip vsif for non-4k mode.\n");
			return -EINVAL;
		}
		break;
	case VT_ALLM:
		ieeeoui = HDMI_FORUM_IEEE_OUI;
		len = 5;
		db[3] = 0x1; /* Fixed value */
		if (on) {
			db[4] |= 1 << 1; /* set bit1, ALLM_MODE */
			/*reset vic which may be reset by VT_HDMI14_4K.*/
			if (hdmitx_edid_get_hdmi14_4k_vic(tx_comm->cur_VIC) > 0)
				tx_hw->cntlconfig(tx_hw, CONF_AVI_VIC, tx_comm->cur_VIC);
		} else {
			db[4] &= ~(1 << 1); /* clear bit1, ALLM_MODE */
			/* 1.When the Source stops transmitting the HF-VSIF,
			 * the Sink shall interpret this as an indication
			 * that transmission offeatures described in this
			 * Infoframe has stopped
			 * 2.When a Source is utilizing the HF-VSIF for ALLM
			 * signaling only and indicates the Sink should
			 * revert fromow-latency Mode to its previous mode,
			 * the Source should send ALLM Mode = 0 to quickly
			 * and reliably request the change. If a Source
			 * indicates ALLM Mode = 0 in this manner , the
			 * Source should transmit an HF-VSIF with ALLM Mode = 0
			 * for at least 4 frames but for not more than 1 second.
			 */
			/* hdmi_vend_infoframe2_rawset(hb, vsif_db); */
			/* wait for 4frames ~ 1S, then stop send HF-VSIF */
			hdmi_vend_infoframe2_rawset(NULL, NULL);
		}
		break;
	default:
		break;
	}
	return 1;
}

