// SPDX-License-Identifier: (GPL-2.0+ OR MIT)
/*
 * drivers/amlogic/media/video_sink/video_reg_s5.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include <linux/amlogic/media/registers/register.h>
#include "vpp_regs_s5.h"
#include "video_reg_s5.h"
#include "video_reg_common.h"

struct vd_mif_reg_s vd_mif_reg_s5_array[MAX_VD_LAYER_S5] = {
	{
		S5_VD1_IF0_GEN_REG,
		S5_VD1_IF0_CANVAS0,
		S5_VD1_IF0_CANVAS1,
		S5_VD1_IF0_LUMA_X0,
		S5_VD1_IF0_LUMA_Y0,
		S5_VD1_IF0_CHROMA_X0,
		S5_VD1_IF0_CHROMA_Y0,
		S5_VD1_IF0_LUMA_X1,
		S5_VD1_IF0_LUMA_Y1,
		S5_VD1_IF0_CHROMA_X1,
		S5_VD1_IF0_CHROMA_Y1,
		S5_VD1_IF0_RPT_LOOP,
		S5_VD1_IF0_LUMA0_RPT_PAT,
		S5_VD1_IF0_CHROMA0_RPT_PAT,
		S5_VD1_IF0_LUMA1_RPT_PAT,
		S5_VD1_IF0_CHROMA1_RPT_PAT,
		S5_VD1_IF0_LUMA_PSEL,
		S5_VD1_IF0_CHROMA_PSEL,
		S5_VD1_IF0_LUMA_FIFO_SIZE,
		S5_VD1_IF0_GEN_REG2,
		S5_VD1_IF0_GEN_REG3,
		VIU_S5_VD1_FMT_CTRL,
		VIU_S5_VD1_FMT_W,
	},
	{
		S5_VD2_IF0_GEN_REG,
		S5_VD2_IF0_CANVAS0,
		S5_VD2_IF0_CANVAS1,
		S5_VD2_IF0_LUMA_X0,
		S5_VD2_IF0_LUMA_Y0,
		S5_VD2_IF0_CHROMA_X0,
		S5_VD2_IF0_CHROMA_Y0,
		S5_VD2_IF0_LUMA_X1,
		S5_VD2_IF0_LUMA_Y1,
		S5_VD2_IF0_CHROMA_X1,
		S5_VD2_IF0_CHROMA_Y1,
		S5_VD2_IF0_RPT_LOOP,
		S5_VD2_IF0_LUMA0_RPT_PAT,
		S5_VD2_IF0_CHROMA0_RPT_PAT,
		S5_VD2_IF0_LUMA1_RPT_PAT,
		S5_VD2_IF0_CHROMA1_RPT_PAT,
		S5_VD2_IF0_LUMA_PSEL,
		S5_VD2_IF0_CHROMA_PSEL,
		S5_VD2_IF0_LUMA_FIFO_SIZE,
		S5_VD2_IF0_GEN_REG2,
		S5_VD2_IF0_GEN_REG3,
		VIU_S5_VD2_FMT_CTRL,
		VIU_S5_VD2_FMT_W,
	},
	{
		S5_VD3_IF0_GEN_REG,
		S5_VD3_IF0_CANVAS0,
		S5_VD3_IF0_CANVAS1,
		S5_VD3_IF0_LUMA_X0,
		S5_VD3_IF0_LUMA_Y0,
		S5_VD3_IF0_CHROMA_X0,
		S5_VD3_IF0_CHROMA_Y0,
		S5_VD3_IF0_LUMA_X1,
		S5_VD3_IF0_LUMA_Y1,
		S5_VD3_IF0_CHROMA_X1,
		S5_VD3_IF0_CHROMA_Y1,
		S5_VD3_IF0_RPT_LOOP,
		S5_VD3_IF0_LUMA0_RPT_PAT,
		S5_VD3_IF0_CHROMA0_RPT_PAT,
		S5_VD3_IF0_LUMA1_RPT_PAT,
		S5_VD3_IF0_CHROMA1_RPT_PAT,
		S5_VD3_IF0_LUMA_PSEL,
		S5_VD3_IF0_CHROMA_PSEL,
		S5_VD3_IF0_LUMA_FIFO_SIZE,
		S5_VD3_IF0_GEN_REG2,
		S5_VD3_IF0_GEN_REG3,
		VIU_S5_VD3_FMT_CTRL,
		VIU_S5_VD3_FMT_W,
	},
	{
		S5_VD4_IF0_GEN_REG,
		S5_VD4_IF0_CANVAS0,
		S5_VD4_IF0_CANVAS1,
		S5_VD4_IF0_LUMA_X0,
		S5_VD4_IF0_LUMA_Y0,
		S5_VD4_IF0_CHROMA_X0,
		S5_VD4_IF0_CHROMA_Y0,
		S5_VD4_IF0_LUMA_X1,
		S5_VD4_IF0_LUMA_Y1,
		S5_VD4_IF0_CHROMA_X1,
		S5_VD4_IF0_CHROMA_Y1,
		S5_VD4_IF0_RPT_LOOP,
		S5_VD4_IF0_LUMA0_RPT_PAT,
		S5_VD4_IF0_CHROMA0_RPT_PAT,
		S5_VD4_IF0_LUMA1_RPT_PAT,
		S5_VD4_IF0_CHROMA1_RPT_PAT,
		S5_VD4_IF0_LUMA_PSEL,
		S5_VD4_IF0_CHROMA_PSEL,
		S5_VD4_IF0_LUMA_FIFO_SIZE,
		S5_VD4_IF0_GEN_REG2,
		S5_VD4_IF0_GEN_REG3,
		VIU_S5_VD4_FMT_CTRL,
		VIU_S5_VD4_FMT_W,
	},
	{
		S5_VD5_IF0_GEN_REG,
		S5_VD5_IF0_CANVAS0,
		S5_VD5_IF0_CANVAS1,
		S5_VD5_IF0_LUMA_X0,
		S5_VD5_IF0_LUMA_Y0,
		S5_VD5_IF0_CHROMA_X0,
		S5_VD5_IF0_CHROMA_Y0,
		S5_VD5_IF0_LUMA_X1,
		S5_VD5_IF0_LUMA_Y1,
		S5_VD5_IF0_CHROMA_X1,
		S5_VD5_IF0_CHROMA_Y1,
		S5_VD5_IF0_RPT_LOOP,
		S5_VD5_IF0_LUMA0_RPT_PAT,
		S5_VD5_IF0_CHROMA0_RPT_PAT,
		S5_VD5_IF0_LUMA1_RPT_PAT,
		S5_VD5_IF0_CHROMA1_RPT_PAT,
		S5_VD5_IF0_LUMA_PSEL,
		S5_VD5_IF0_CHROMA_PSEL,
		S5_VD5_IF0_LUMA_FIFO_SIZE,
		S5_VD5_IF0_GEN_REG2,
		S5_VD5_IF0_GEN_REG3,
		VIU_S5_VD5_FMT_CTRL,
		VIU_S5_VD5_FMT_W,
	}
};

struct vd_mif_linear_reg_s vd_mif_linear_reg_s5_array[MAX_VD_LAYER_S5] = {
	{
		S5_VD1_IF0_BADDR_Y,
		S5_VD1_IF0_BADDR_CB,
		S5_VD1_IF0_BADDR_CR,
		S5_VD1_IF0_STRIDE_0,
		S5_VD1_IF0_STRIDE_1,
		S5_VD1_IF0_BADDR_Y_F1,
		S5_VD1_IF0_BADDR_CB_F1,
		S5_VD1_IF0_BADDR_CR_F1,
		S5_VD1_IF0_STRIDE_0_F1,
		S5_VD1_IF0_STRIDE_1_F1,
	},
	{
		S5_VD2_IF0_BADDR_Y,
		S5_VD2_IF0_BADDR_CB,
		S5_VD2_IF0_BADDR_CR,
		S5_VD2_IF0_STRIDE_0,
		S5_VD2_IF0_STRIDE_1,
		S5_VD2_IF0_BADDR_Y_F1,
		S5_VD2_IF0_BADDR_CB_F1,
		S5_VD2_IF0_BADDR_CR_F1,
		S5_VD2_IF0_STRIDE_0_F1,
		S5_VD2_IF0_STRIDE_1_F1,
	},
	{
		S5_VD3_IF0_BADDR_Y,
		S5_VD3_IF0_BADDR_CB,
		S5_VD3_IF0_BADDR_CR,
		S5_VD3_IF0_STRIDE_0,
		S5_VD3_IF0_STRIDE_1,
		S5_VD3_IF0_BADDR_Y_F1,
		S5_VD3_IF0_BADDR_CB_F1,
		S5_VD3_IF0_BADDR_CR_F1,
		S5_VD3_IF0_STRIDE_0_F1,
		S5_VD3_IF0_STRIDE_1_F1,
	},
	{
		S5_VD4_IF0_BADDR_Y,
		S5_VD4_IF0_BADDR_CB,
		S5_VD4_IF0_BADDR_CR,
		S5_VD4_IF0_STRIDE_0,
		S5_VD4_IF0_STRIDE_1,
		S5_VD4_IF0_BADDR_Y_F1,
		S5_VD4_IF0_BADDR_CB_F1,
		S5_VD4_IF0_BADDR_CR_F1,
		S5_VD4_IF0_STRIDE_0_F1,
		S5_VD4_IF0_STRIDE_1_F1,
	},
	{
		S5_VD5_IF0_BADDR_Y,
		S5_VD5_IF0_BADDR_CB,
		S5_VD5_IF0_BADDR_CR,
		S5_VD5_IF0_STRIDE_0,
		S5_VD5_IF0_STRIDE_1,
		S5_VD5_IF0_BADDR_Y_F1,
		S5_VD5_IF0_BADDR_CB_F1,
		S5_VD5_IF0_BADDR_CR_F1,
		S5_VD5_IF0_STRIDE_0_F1,
		S5_VD5_IF0_STRIDE_1_F1,
	}
};

struct vd_afbc_reg_s vd_afbc_reg_s5_array[MAX_VD_LAYER_S5] = {
	{
		S5_VD1_AFBCDM_ENABLE,
		S5_VD1_AFBCDM_MODE,
		S5_VD1_AFBCDM_SIZE_IN,
		S5_VD1_AFBCDM_DEC_DEF_COLOR,
		S5_VD1_AFBCDM_CONV_CTRL,
		S5_VD1_AFBCDM_LBUF_DEPTH,
		S5_VD1_AFBCDM_HEAD_BADDR,
		S5_VD1_AFBCDM_BODY_BADDR,
		S5_VD1_AFBCDM_SIZE_OUT,
		S5_VD1_AFBCDM_OUT_YSCOPE,
		S5_VD1_AFBCDM_STAT,
		S5_VD1_AFBCDM_VD_CFMT_CTRL,
		S5_VD1_AFBCDM_VD_CFMT_W,
		S5_VD1_AFBCDM_MIF_HOR_SCOPE,
		S5_VD1_AFBCDM_MIF_VER_SCOPE,
		S5_VD1_AFBCDM_PIXEL_HOR_SCOPE,
		S5_VD1_AFBCDM_PIXEL_VER_SCOPE,
		S5_VD1_AFBCDM_VD_CFMT_H,
		S5_VD1_AFBCDM_IQUANT_ENABLE,
		S5_VD1_AFBCDM_IQUANT_LUT_1,
		S5_VD1_AFBCDM_IQUANT_LUT_2,
		S5_VD1_AFBCDM_IQUANT_LUT_3,
		S5_VD1_AFBCDM_IQUANT_LUT_4,
		S5_VD1_AFBCDM_VDTOP_CTRL0,
		VD1_AFBCDM_BURST_CTRL,
		VD1_AFBCDM_LOSS_CTRL,
	},
	{
		S5_VD2_AFBCDM_ENABLE,
		S5_VD2_AFBCDM_MODE,
		S5_VD2_AFBCDM_SIZE_IN,
		S5_VD2_AFBCDM_DEC_DEF_COLOR,
		S5_VD2_AFBCDM_CONV_CTRL,
		S5_VD2_AFBCDM_LBUF_DEPTH,
		S5_VD2_AFBCDM_HEAD_BADDR,
		S5_VD2_AFBCDM_BODY_BADDR,
		S5_VD2_AFBCDM_SIZE_OUT,
		S5_VD2_AFBCDM_OUT_YSCOPE,
		S5_VD2_AFBCDM_STAT,
		S5_VD2_AFBCDM_VD_CFMT_CTRL,
		S5_VD2_AFBCDM_VD_CFMT_W,
		S5_VD2_AFBCDM_MIF_HOR_SCOPE,
		S5_VD2_AFBCDM_MIF_VER_SCOPE,
		S5_VD2_AFBCDM_PIXEL_HOR_SCOPE,
		S5_VD2_AFBCDM_PIXEL_VER_SCOPE,
		S5_VD2_AFBCDM_VD_CFMT_H,
		S5_VD2_AFBCDM_IQUANT_ENABLE,
		S5_VD2_AFBCDM_IQUANT_LUT_1,
		S5_VD2_AFBCDM_IQUANT_LUT_2,
		S5_VD2_AFBCDM_IQUANT_LUT_3,
		S5_VD2_AFBCDM_IQUANT_LUT_4,
		S5_VD2_AFBCDM_VDTOP_CTRL0,
		VD2_AFBCDM_BURST_CTRL,
		VD2_AFBCDM_LOSS_CTRL,
	},
	{
		S5_VD3_AFBCDM_ENABLE,
		S5_VD3_AFBCDM_MODE,
		S5_VD3_AFBCDM_SIZE_IN,
		S5_VD3_AFBCDM_DEC_DEF_COLOR,
		S5_VD3_AFBCDM_CONV_CTRL,
		S5_VD3_AFBCDM_LBUF_DEPTH,
		S5_VD3_AFBCDM_HEAD_BADDR,
		S5_VD3_AFBCDM_BODY_BADDR,
		S5_VD3_AFBCDM_SIZE_OUT,
		S5_VD3_AFBCDM_OUT_YSCOPE,
		S5_VD3_AFBCDM_STAT,
		S5_VD3_AFBCDM_VD_CFMT_CTRL,
		S5_VD3_AFBCDM_VD_CFMT_W,
		S5_VD3_AFBCDM_MIF_HOR_SCOPE,
		S5_VD3_AFBCDM_MIF_VER_SCOPE,
		S5_VD3_AFBCDM_PIXEL_HOR_SCOPE,
		S5_VD3_AFBCDM_PIXEL_VER_SCOPE,
		S5_VD3_AFBCDM_VD_CFMT_H,
		S5_VD3_AFBCDM_IQUANT_ENABLE,
		S5_VD3_AFBCDM_IQUANT_LUT_1,
		S5_VD3_AFBCDM_IQUANT_LUT_2,
		S5_VD3_AFBCDM_IQUANT_LUT_3,
		S5_VD3_AFBCDM_IQUANT_LUT_4,
		S5_VD3_AFBCDM_VDTOP_CTRL0,
		VD3_AFBCDM_BURST_CTRL,
		VD3_AFBCDM_LOSS_CTRL,
	},
	{
		S5_VD4_AFBCDM_ENABLE,
		S5_VD4_AFBCDM_MODE,
		S5_VD4_AFBCDM_SIZE_IN,
		S5_VD4_AFBCDM_DEC_DEF_COLOR,
		S5_VD4_AFBCDM_CONV_CTRL,
		S5_VD4_AFBCDM_LBUF_DEPTH,
		S5_VD4_AFBCDM_HEAD_BADDR,
		S5_VD4_AFBCDM_BODY_BADDR,
		S5_VD4_AFBCDM_SIZE_OUT,
		S5_VD4_AFBCDM_OUT_YSCOPE,
		S5_VD4_AFBCDM_STAT,
		S5_VD4_AFBCDM_VD_CFMT_CTRL,
		S5_VD4_AFBCDM_VD_CFMT_W,
		S5_VD4_AFBCDM_MIF_HOR_SCOPE,
		S5_VD4_AFBCDM_MIF_VER_SCOPE,
		S5_VD4_AFBCDM_PIXEL_HOR_SCOPE,
		S5_VD4_AFBCDM_PIXEL_VER_SCOPE,
		S5_VD4_AFBCDM_VD_CFMT_H,
		S5_VD4_AFBCDM_IQUANT_ENABLE,
		S5_VD4_AFBCDM_IQUANT_LUT_1,
		S5_VD4_AFBCDM_IQUANT_LUT_2,
		S5_VD4_AFBCDM_IQUANT_LUT_3,
		S5_VD4_AFBCDM_IQUANT_LUT_4,
		S5_VD4_AFBCDM_VDTOP_CTRL0,
		VD4_AFBCDM_BURST_CTRL,
		VD4_AFBCDM_LOSS_CTRL,
	},
	{
		S5_VD5_AFBCDM_ENABLE,
		S5_VD5_AFBCDM_MODE,
		S5_VD5_AFBCDM_SIZE_IN,
		S5_VD5_AFBCDM_DEC_DEF_COLOR,
		S5_VD5_AFBCDM_CONV_CTRL,
		S5_VD5_AFBCDM_LBUF_DEPTH,
		S5_VD5_AFBCDM_HEAD_BADDR,
		S5_VD5_AFBCDM_BODY_BADDR,
		S5_VD5_AFBCDM_SIZE_OUT,
		S5_VD5_AFBCDM_OUT_YSCOPE,
		S5_VD5_AFBCDM_STAT,
		S5_VD5_AFBCDM_VD_CFMT_CTRL,
		S5_VD5_AFBCDM_VD_CFMT_W,
		S5_VD5_AFBCDM_MIF_HOR_SCOPE,
		S5_VD5_AFBCDM_MIF_VER_SCOPE,
		S5_VD5_AFBCDM_PIXEL_HOR_SCOPE,
		S5_VD5_AFBCDM_PIXEL_VER_SCOPE,
		S5_VD5_AFBCDM_VD_CFMT_H,
		S5_VD5_AFBCDM_IQUANT_ENABLE,
		S5_VD5_AFBCDM_IQUANT_LUT_1,
		S5_VD5_AFBCDM_IQUANT_LUT_2,
		S5_VD5_AFBCDM_IQUANT_LUT_3,
		S5_VD5_AFBCDM_IQUANT_LUT_4,
		S5_VD5_AFBCDM_VDTOP_CTRL0,
		VD5_AFBCDM_BURST_CTRL,
		VD5_AFBCDM_LOSS_CTRL,
	}
};

struct vd_fg_reg_s fg_reg_s5_array[MAX_VD_LAYER_S5] = {
	{
		S5_VD1_FGRAIN_CTRL,
		S5_VD1_FGRAIN_WIN_H,
		S5_VD1_FGRAIN_WIN_V,
		S5_VD1_FGRAIN_SLICE_WIN_H,
	},
	{
		S5_VD2_FGRAIN_CTRL,
		S5_VD2_FGRAIN_WIN_H,
		S5_VD2_FGRAIN_WIN_V,
		S5_VD1_FGRAIN_SLICE_WIN_H,
	},
	{
		S5_VD3_FGRAIN_CTRL,
		S5_VD3_FGRAIN_WIN_H,
		S5_VD3_FGRAIN_WIN_V,
		S5_VD3_FGRAIN_SLICE_WIN_H,
	},
	{
		S5_VD4_FGRAIN_CTRL,
		S5_VD4_FGRAIN_WIN_H,
		S5_VD4_FGRAIN_WIN_V,
		S5_VD4_FGRAIN_SLICE_WIN_H,
	},
	{
		S5_VD5_FGRAIN_CTRL,
		S5_VD5_FGRAIN_WIN_H,
		S5_VD5_FGRAIN_WIN_V,
		S5_VD5_FGRAIN_SLICE_WIN_H,
	}
};

struct vd_pps_reg_s pps_reg_s5_array[MAX_VD_LAYER_S5 + 1] = {
	{
		VPP_VD1_SCALE_COEF_IDX,
		VPP_VD1_SCALE_COEF,
		VPP_VD1_VSC_REGION12_STARTP,
		VPP_VD1_VSC_REGION34_STARTP,
		VPP_VD1_VSC_REGION4_ENDP,
		VPP_VD1_VSC_START_PHASE_STEP,
		VPP_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_VD1_VSC_PHASE_CTRL,
		VPP_VD1_VSC_INI_PHASE,
		VPP_VD1_HSC_REGION12_STARTP,
		VPP_VD1_HSC_REGION34_STARTP,
		VPP_VD1_HSC_REGION4_ENDP,
		VPP_VD1_HSC_START_PHASE_STEP,
		VPP_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_VD1_HSC_PHASE_CTRL,
		VPP_VD1_SC_MISC,
		VPP_VD1_HSC_PHASE_CTRL1,
		VPP_VD1_PREHSC_COEF,
		VPP_VD1_PRE_SCALE_CTRL,
		VPP_VD1_PREVSC_COEF,
		VPP_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE1_VD1_SCALE_COEF_IDX,
		VPP_SLICE1_VD1_SCALE_COEF,
		VPP_SLICE1_VD1_VSC_REGION12_STARTP,
		VPP_SLICE1_VD1_VSC_REGION34_STARTP,
		VPP_SLICE1_VD1_VSC_REGION4_ENDP,
		VPP_SLICE1_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE1_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE1_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE1_VD1_VSC_PHASE_CTRL,
		VPP_SLICE1_VD1_VSC_INI_PHASE,
		VPP_SLICE1_VD1_HSC_REGION12_STARTP,
		VPP_SLICE1_VD1_HSC_REGION34_STARTP,
		VPP_SLICE1_VD1_HSC_REGION4_ENDP,
		VPP_SLICE1_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE1_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE1_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE1_VD1_HSC_PHASE_CTRL,
		VPP_SLICE1_VD1_SC_MISC,
		VPP_SLICE1_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE1_VD1_PREHSC_COEF,
		VPP_SLICE1_VD1_PRE_SCALE_CTRL,
		VPP_SLICE1_VD1_PREVSC_COEF,
		VPP_SLICE1_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE2_VD1_SCALE_COEF_IDX,
		VPP_SLICE2_VD1_SCALE_COEF,
		VPP_SLICE2_VD1_VSC_REGION12_STARTP,
		VPP_SLICE2_VD1_VSC_REGION34_STARTP,
		VPP_SLICE2_VD1_VSC_REGION4_ENDP,
		VPP_SLICE2_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE2_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE2_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE2_VD1_VSC_PHASE_CTRL,
		VPP_SLICE2_VD1_VSC_INI_PHASE,
		VPP_SLICE2_VD1_HSC_REGION12_STARTP,
		VPP_SLICE2_VD1_HSC_REGION34_STARTP,
		VPP_SLICE2_VD1_HSC_REGION4_ENDP,
		VPP_SLICE2_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE2_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE2_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE2_VD1_HSC_PHASE_CTRL,
		VPP_SLICE2_VD1_SC_MISC,
		VPP_SLICE2_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE2_VD1_PREHSC_COEF,
		VPP_SLICE2_VD1_PRE_SCALE_CTRL,
		VPP_SLICE2_VD1_PREVSC_COEF,
		VPP_SLICE2_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE3_VD1_SCALE_COEF_IDX,
		VPP_SLICE3_VD1_SCALE_COEF,
		VPP_SLICE3_VD1_VSC_REGION12_STARTP,
		VPP_SLICE3_VD1_VSC_REGION34_STARTP,
		VPP_SLICE3_VD1_VSC_REGION4_ENDP,
		VPP_SLICE3_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE3_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE3_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE3_VD1_VSC_PHASE_CTRL,
		VPP_SLICE3_VD1_VSC_INI_PHASE,
		VPP_SLICE3_VD1_HSC_REGION12_STARTP,
		VPP_SLICE3_VD1_HSC_REGION34_STARTP,
		VPP_SLICE3_VD1_HSC_REGION4_ENDP,
		VPP_SLICE3_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE3_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE3_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE3_VD1_HSC_PHASE_CTRL,
		VPP_SLICE3_VD1_SC_MISC,
		VPP_SLICE3_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE3_VD1_PREHSC_COEF,
		VPP_SLICE3_VD1_PRE_SCALE_CTRL,
		VPP_SLICE3_VD1_PREVSC_COEF,
		VPP_SLICE3_VD1_PREHSC_COEF1,
	},
	{
		VPP_VD2_SCALE_COEF_IDX,
		VPP_VD2_SCALE_COEF,
		VPP_VD2_VSC_REGION12_STARTP,
		VPP_VD2_VSC_REGION34_STARTP,
		VPP_VD2_VSC_REGION4_ENDP,
		VPP_VD2_VSC_START_PHASE_STEP,
		VPP_VD2_VSC_REGION1_PHASE_SLOPE,
		VPP_VD2_VSC_REGION3_PHASE_SLOPE,
		VPP_VD2_VSC_PHASE_CTRL,
		VPP_VD2_VSC_INI_PHASE,
		VPP_VD2_HSC_REGION12_STARTP,
		VPP_VD2_HSC_REGION34_STARTP,
		VPP_VD2_HSC_REGION4_ENDP,
		VPP_VD2_HSC_START_PHASE_STEP,
		VPP_VD2_HSC_REGION1_PHASE_SLOPE,
		VPP_VD2_HSC_REGION3_PHASE_SLOPE,
		VPP_VD2_HSC_PHASE_CTRL,
		VPP_VD2_SC_MISC,
		VPP_VD2_HSC_PHASE_CTRL1,
		VPP_VD2_PREHSC_COEF,
		VPP_VD2_PRE_SCALE_CTRL,
		VPP_VD2_PREVSC_COEF,
		VPP_VD2_PREHSC_COEF1,
	},
	{
		S5_SCHN_SCALE_COEF_IDX,
		S5_SCHN_SCALE_COEF,
		S5_SCHN_VSC_REGION12_STARTP,
		S5_SCHN_VSC_REGION34_STARTP,
		S5_SCHN_VSC_REGION4_ENDP,
		S5_SCHN_VSC_START_PHASE_STEP,
		S5_SCHN_VSC_REGION1_PHASE_SLOPE,
		S5_SCHN_VSC_REGION3_PHASE_SLOPE,
		S5_SCHN_VSC_PHASE_CTRL,
		S5_SCHN_VSC_INI_PHASE,
		S5_SCHN_HSC_REGION12_STARTP,
		S5_SCHN_HSC_REGION34_STARTP,
		S5_SCHN_HSC_REGION4_ENDP,
		S5_SCHN_HSC_START_PHASE_STEP,
		S5_SCHN_HSC_REGION1_PHASE_SLOPE,
		S5_SCHN_HSC_REGION3_PHASE_SLOPE,
		S5_SCHN_HSC_PHASE_CTRL,
		S5_SCHN_SC_MISC,
		S5_SCHN_HSC_PHASE_CTRL1,
		S5_SCHN_PREHSC_COEF,
		S5_SCHN_PRE_SCALE_CTRL,
		S5_SCHN_PREVSC_COEF,
		S5_SCHN_PREHSC_COEF1,
	},
};

struct vd_pps_reg_s pps_reg_t3x_array[MAX_VD_LAYER_S5 + 1] = {
	{
		T3X_VPP_VD1_SCALE_COEF_IDX,
		T3X_VPP_VD1_SCALE_COEF,
		T3X_VPP_VD1_VSC_REGION12_STARTP,
		T3X_VPP_VD1_VSC_REGION34_STARTP,
		T3X_VPP_VD1_VSC_REGION4_ENDP,
		T3X_VPP_VD1_VSC_START_PHASE_STEP,
		T3X_VPP_VD1_VSC_REGION1_PHASE_SLOPE,
		T3X_VPP_VD1_VSC_REGION3_PHASE_SLOPE,
		T3X_VPP_VD1_VSC_PHASE_CTRL,
		T3X_VPP_VD1_VSC_INI_PHASE,
		T3X_VPP_VD1_HSC_REGION12_STARTP,
		T3X_VPP_VD1_HSC_REGION34_STARTP,
		T3X_VPP_VD1_HSC_REGION4_ENDP,
		T3X_VPP_VD1_HSC_START_PHASE_STEP,
		T3X_VPP_VD1_HSC_REGION1_PHASE_SLOPE,
		T3X_VPP_VD1_HSC_REGION3_PHASE_SLOPE,
		T3X_VPP_VD1_HSC_PHASE_CTRL,
		T3X_VPP_VD1_SC_MISC,
		T3X_VPP_VD1_HSC_PHASE_CTRL1,
		T3X_VPP_VD1_PREHSC_COEF,
		T3X_VPP_VD1_PRE_SCALE_CTRL,
		T3X_VPP_VD1_PREVSC_COEF,
		T3X_VPP_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE1_VD1_SCALE_COEF_IDX,
		VPP_SLICE1_VD1_SCALE_COEF,
		VPP_SLICE1_VD1_VSC_REGION12_STARTP,
		VPP_SLICE1_VD1_VSC_REGION34_STARTP,
		VPP_SLICE1_VD1_VSC_REGION4_ENDP,
		VPP_SLICE1_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE1_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE1_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE1_VD1_VSC_PHASE_CTRL,
		VPP_SLICE1_VD1_VSC_INI_PHASE,
		VPP_SLICE1_VD1_HSC_REGION12_STARTP,
		VPP_SLICE1_VD1_HSC_REGION34_STARTP,
		VPP_SLICE1_VD1_HSC_REGION4_ENDP,
		VPP_SLICE1_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE1_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE1_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE1_VD1_HSC_PHASE_CTRL,
		VPP_SLICE1_VD1_SC_MISC,
		VPP_SLICE1_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE1_VD1_PREHSC_COEF,
		VPP_SLICE1_VD1_PRE_SCALE_CTRL,
		VPP_SLICE1_VD1_PREVSC_COEF,
		VPP_SLICE1_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE2_VD1_SCALE_COEF_IDX,
		VPP_SLICE2_VD1_SCALE_COEF,
		VPP_SLICE2_VD1_VSC_REGION12_STARTP,
		VPP_SLICE2_VD1_VSC_REGION34_STARTP,
		VPP_SLICE2_VD1_VSC_REGION4_ENDP,
		VPP_SLICE2_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE2_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE2_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE2_VD1_VSC_PHASE_CTRL,
		VPP_SLICE2_VD1_VSC_INI_PHASE,
		VPP_SLICE2_VD1_HSC_REGION12_STARTP,
		VPP_SLICE2_VD1_HSC_REGION34_STARTP,
		VPP_SLICE2_VD1_HSC_REGION4_ENDP,
		VPP_SLICE2_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE2_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE2_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE2_VD1_HSC_PHASE_CTRL,
		VPP_SLICE2_VD1_SC_MISC,
		VPP_SLICE2_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE2_VD1_PREHSC_COEF,
		VPP_SLICE2_VD1_PRE_SCALE_CTRL,
		VPP_SLICE2_VD1_PREVSC_COEF,
		VPP_SLICE2_VD1_PREHSC_COEF1,
	},
	{
		VPP_SLICE3_VD1_SCALE_COEF_IDX,
		VPP_SLICE3_VD1_SCALE_COEF,
		VPP_SLICE3_VD1_VSC_REGION12_STARTP,
		VPP_SLICE3_VD1_VSC_REGION34_STARTP,
		VPP_SLICE3_VD1_VSC_REGION4_ENDP,
		VPP_SLICE3_VD1_VSC_START_PHASE_STEP,
		VPP_SLICE3_VD1_VSC_REGION1_PHASE_SLOPE,
		VPP_SLICE3_VD1_VSC_REGION3_PHASE_SLOPE,
		VPP_SLICE3_VD1_VSC_PHASE_CTRL,
		VPP_SLICE3_VD1_VSC_INI_PHASE,
		VPP_SLICE3_VD1_HSC_REGION12_STARTP,
		VPP_SLICE3_VD1_HSC_REGION34_STARTP,
		VPP_SLICE3_VD1_HSC_REGION4_ENDP,
		VPP_SLICE3_VD1_HSC_START_PHASE_STEP,
		VPP_SLICE3_VD1_HSC_REGION1_PHASE_SLOPE,
		VPP_SLICE3_VD1_HSC_REGION3_PHASE_SLOPE,
		VPP_SLICE3_VD1_HSC_PHASE_CTRL,
		VPP_SLICE3_VD1_SC_MISC,
		VPP_SLICE3_VD1_HSC_PHASE_CTRL1,
		VPP_SLICE3_VD1_PREHSC_COEF,
		VPP_SLICE3_VD1_PRE_SCALE_CTRL,
		VPP_SLICE3_VD1_PREVSC_COEF,
		VPP_SLICE3_VD1_PREHSC_COEF1,
	},
	{
		VPP_VD2_SCALE_COEF_IDX,
		VPP_VD2_SCALE_COEF,
		VPP_VD2_VSC_REGION12_STARTP,
		VPP_VD2_VSC_REGION34_STARTP,
		VPP_VD2_VSC_REGION4_ENDP,
		VPP_VD2_VSC_START_PHASE_STEP,
		VPP_VD2_VSC_REGION1_PHASE_SLOPE,
		VPP_VD2_VSC_REGION3_PHASE_SLOPE,
		VPP_VD2_VSC_PHASE_CTRL,
		VPP_VD2_VSC_INI_PHASE,
		VPP_VD2_HSC_REGION12_STARTP,
		VPP_VD2_HSC_REGION34_STARTP,
		VPP_VD2_HSC_REGION4_ENDP,
		VPP_VD2_HSC_START_PHASE_STEP,
		VPP_VD2_HSC_REGION1_PHASE_SLOPE,
		VPP_VD2_HSC_REGION3_PHASE_SLOPE,
		VPP_VD2_HSC_PHASE_CTRL,
		VPP_VD2_SC_MISC,
		VPP_VD2_HSC_PHASE_CTRL1,
		VPP_VD2_PREHSC_COEF,
		VPP_VD2_PRE_SCALE_CTRL,
		VPP_VD2_PREVSC_COEF,
		VPP_VD2_PREHSC_COEF1,
	},
	{
		S5_SCHN_SCALE_COEF_IDX,
		S5_SCHN_SCALE_COEF,
		S5_SCHN_VSC_REGION12_STARTP,
		S5_SCHN_VSC_REGION34_STARTP,
		S5_SCHN_VSC_REGION4_ENDP,
		S5_SCHN_VSC_START_PHASE_STEP,
		S5_SCHN_VSC_REGION1_PHASE_SLOPE,
		S5_SCHN_VSC_REGION3_PHASE_SLOPE,
		S5_SCHN_VSC_PHASE_CTRL,
		S5_SCHN_VSC_INI_PHASE,
		S5_SCHN_HSC_REGION12_STARTP,
		S5_SCHN_HSC_REGION34_STARTP,
		S5_SCHN_HSC_REGION4_ENDP,
		S5_SCHN_HSC_START_PHASE_STEP,
		S5_SCHN_HSC_REGION1_PHASE_SLOPE,
		S5_SCHN_HSC_REGION3_PHASE_SLOPE,
		S5_SCHN_HSC_PHASE_CTRL,
		S5_SCHN_SC_MISC,
		S5_SCHN_HSC_PHASE_CTRL1,
		S5_SCHN_PREHSC_COEF,
		S5_SCHN_PRE_SCALE_CTRL,
		S5_SCHN_PREVSC_COEF,
		S5_SCHN_PREHSC_COEF1,
	},
};

struct vd_proc_sr_reg_s vd_proc_sr_reg_s5 = {
	{
		{
			VD_PROC_S0_SR0_IN_SIZE,
			VD_PROC_S0_SR1_IN_SIZE,
			VD_PROC_SR0_CTRL,
			VD_PROC_SR1_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL,
			S5_SRSHARP1_SHARP_SR2_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL2,
			S5_SRSHARP1_SHARP_SR2_CTRL2,
			S5_SRSHARP0_SHARP_SYNC_CTRL,
			S5_SRSHARP1_SHARP_SYNC_CTRL,
		},
		{
			VD_PROC_S0_SR0_IN_SIZE,
			VD_PROC_S0_SR1_IN_SIZE,
			VD_PROC_SR0_CTRL,
			VD_PROC_SR1_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL,
			S5_SRSHARP1_SHARP_SR2_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL2,
			S5_SRSHARP1_SHARP_SR2_CTRL2,
			S5_SRSHARP0_SHARP_SYNC_CTRL,
			S5_SRSHARP1_SHARP_SYNC_CTRL,

		},
	},
	VD_PROC_S1_SR0_IN_SIZE,
	S5_SRSHARP1_NN_POST_TOP,
	S5_SRSHARP1_DEMO_MODE_WINDOW_CTRL0,
	S5_SRSHARP1_DEMO_MODE_WINDOW_CTRL1,
};

struct vd_proc_sr_reg_s vd_proc_sr_reg_t3x = {
	{
		{
			VD_PROC_S0_SR0_IN_SIZE,
			VD_PROC_S0_SR1_IN_SIZE,
			VD_PROC_SR0_CTRL,
			VD_PROC_SR1_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL,
			S5_SRSHARP1_SHARP_SR2_CTRL,
			S5_SRSHARP0_SHARP_SR2_CTRL2,
			S5_SRSHARP1_SHARP_SR2_CTRL2,
			S5_SRSHARP0_SHARP_SYNC_CTRL,
			S5_SRSHARP1_SHARP_SYNC_CTRL,
		},
		{
			T3X_VD_PROC_S1_SR0_IN_SIZE,
			T3X_VD_PROC_S1_SR1_IN_SIZE,
			T3X_VD_PROC_SR0_CTRL1,
			T3X_VD_PROC_SR1_CTRL1,
			T3X_SRSHARP0_SHARP_SR2_CTRL,
			T3X_SRSHARP1_SHARP_SR2_CTRL,
			T3X_SRSHARP0_SHARP_SR2_CTRL2,
			T3X_SRSHARP1_SHARP_SR2_CTRL2,
			T3X_SRSHARP0_SHARP_SYNC_CTRL,
			T3X_SRSHARP1_SHARP_SYNC_CTRL,
		},
	},
	T3X_VD_PROC_S1_SR0_IN_SIZE,
	S5_SRSHARP1_NN_POST_TOP,
	S5_SRSHARP1_DEMO_MODE_WINDOW_CTRL0,
	S5_SRSHARP1_DEMO_MODE_WINDOW_CTRL1,
};

struct vd_proc_slice_reg_s vd_proc_slice_reg_s5[SLICE_NUM] = {
	{
		VD_PROC_S0_IN_SIZE,
		VD_PROC_S0_OUT_SIZE,
		VD_S0_HWIN_CUT,
		VD1_S0_DETUNL_CTRL,
		S5_VD1_SLICE0_HDR2_CTRL,
		VD1_S0_DV_BYPASS_CTRL,
		VD1_S0_CLIP_MISC0,
		VD1_S0_CLIP_MISC1,
	},
	{
		VD_PROC_S1_IN_SIZE,
		VD_PROC_S1_OUT_SIZE,
		VD_S1_HWIN_CUT,
		VD1_S1_DETUNL_CTRL,
		S5_VD1_SLICE1_HDR2_CTRL,
		VD1_S1_DV_BYPASS_CTRL,
		VD1_S1_CLIP_MISC0,
		VD1_S1_CLIP_MISC1,
	},
	{
		VD_PROC_S2_IN_SIZE,
		VD_PROC_S2_OUT_SIZE,
		VD_S2_HWIN_CUT,
		VD1_S2_DETUNL_CTRL,
		S5_VD1_SLICE2_HDR2_CTRL,
		VD1_S2_DV_BYPASS_CTRL,
		VD1_S2_CLIP_MISC0,
		VD1_S2_CLIP_MISC1,
	},
	{
		VD_PROC_S3_IN_SIZE,
		VD_PROC_S3_OUT_SIZE,
		VD_S3_HWIN_CUT,
		VD1_S3_DETUNL_CTRL,
		S5_VD1_SLICE3_HDR2_CTRL,
		VD1_S3_DV_BYPASS_CTRL,
		VD1_S3_CLIP_MISC0,
		VD1_S3_CLIP_MISC1,
	},
};

struct vd_proc_slice_reg_s vd_proc_slice_reg_t3x[SLICE_NUM] = {
	{
		VD_PROC_S0_IN_SIZE,
		VD_PROC_S0_OUT_SIZE,
		T3X_VD_S0_HWIN_CUT,
		T3X_VD1_S0_DETUNL_CTRL,
		S5_VD1_SLICE0_HDR2_CTRL,
		T3X_VD1_S0_DV_BYPASS_CTRL,
		T3X_VD1_S0_CLIP_MISC0,
		T3X_VD1_S0_CLIP_MISC1,
	},
	{
		VD_PROC_S1_IN_SIZE,
		VD_PROC_S1_OUT_SIZE,
		T3X_VD_S1_HWIN_CUT,
		T3X_VD1_S1_DETUNL_CTRL,
		S5_VD1_SLICE1_HDR2_CTRL,
		T3X_VD1_S1_DV_BYPASS_CTRL,
		T3X_VD1_S1_CLIP_MISC0,
		T3X_VD1_S1_CLIP_MISC1,
	},
	{
		T3X_VD_PROC_S2_IN_SIZE,
		T3X_VD_PROC_S2_OUT_SIZE,
		T3X_VD_S2_HWIN_CUT,
		T3X_VD1_S2_DETUNL_CTRL,
		S5_VD1_SLICE2_HDR2_CTRL,
		T3X_VD1_S2_DV_BYPASS_CTRL,
		T3X_VD1_S2_CLIP_MISC0,
		T3X_VD1_S2_CLIP_MISC1,
	},
	{
		T3X_VD_PROC_S3_IN_SIZE,
		T3X_VD_PROC_S3_OUT_SIZE,
		T3X_VD_S3_HWIN_CUT,
		T3X_VD1_S3_DETUNL_CTRL,
		S5_VD1_SLICE3_HDR2_CTRL,
		T3X_VD1_S3_DV_BYPASS_CTRL,
		T3X_VD1_S3_CLIP_MISC0,
		T3X_VD1_S3_CLIP_MISC1,
	},
};

struct vd_proc_pi_reg_s vd_proc_pi_reg_s5 = {
	VD1_PI_CONTROL,
};

struct vd_proc_misc_reg_s vd_proc_misc_reg_s5 = {
	VD_PROC_SR0_CTRL,
	VD_PROC_BYPASS_CTRL,
	/* mux to enter pi module */
	VD1_PI_CTRL,
};

struct vd_proc_misc_reg_s vd_proc_misc_reg_t3x = {
	VD_PROC_SR0_CTRL,
	T3X_VD_PROC_BYPASS_CTRL,
	/* mux to enter pi module */
	VD1_PI_CTRL,
};

struct vd2_proc_misc_reg_s vd2_proc_misc_reg_s5 = {
	VD2_PROC_IN_SIZE,
	VD2_DETUNL_CTRL,
	S5_VD2_HDR2_CTRL,
	VD2_PILITE_CTRL,
	VD2_PROC_OUT_SIZE,
	VD2_DV_BYPASS_CTRL,
	VD2_CLIP_MISC0,
	VD2_CLIP_MISC1,
};

struct vpp_post_blend_reg_s vpp_post_blend_reg_s5 = {
	S5_VPP_OSD1_BLD_H_SCOPE,
	S5_VPP_OSD1_BLD_V_SCOPE,
	S5_VPP_OSD2_BLD_H_SCOPE,
	S5_VPP_OSD2_BLD_V_SCOPE,
	S5_VPP_POSTBLEND_VD1_H_START_END,
	S5_VPP_POSTBLEND_VD1_V_START_END,
	S5_VPP_POSTBLEND_VD2_H_START_END,
	S5_VPP_POSTBLEND_VD2_V_START_END,
	S5_VPP_POSTBLEND_VD3_H_START_END,
	S5_VPP_POSTBLEND_VD3_V_START_END,
	S5_VPP_POSTBLEND_H_V_SIZE,
	S5_VPP_POST_BLEND_BLEND_DUMMY_DATA,
	S5_VPP_POST_BLEND_DUMMY_ALPHA,
	S5_VPP_POST_BLEND_DUMMY_ALPHA1,
	S5_VD1_BLEND_SRC_CTRL,
	S5_VD2_BLEND_SRC_CTRL,
	S5_VD3_BLEND_SRC_CTRL,
	S5_OSD1_BLEND_SRC_CTRL,
	S5_OSD2_BLEND_SRC_CTRL,
	S5_VD1_POSTBLEND_ALPHA,
	S5_VD2_POSTBLEND_ALPHA,
	S5_VD3_POSTBLEND_ALPHA,
	S5_VPP_POSTBLEND_CTRL,
};

struct vpp_post_blend_reg_s vpp_post_blend_reg_t3x = {
	S5_VPP_OSD1_BLD_H_SCOPE,
	S5_VPP_OSD1_BLD_V_SCOPE,
	S5_VPP_OSD2_BLD_H_SCOPE,
	S5_VPP_OSD2_BLD_V_SCOPE,
	S5_VPP_POSTBLEND_VD1_H_START_END,
	S5_VPP_POSTBLEND_VD1_V_START_END,
	S5_VPP_POSTBLEND_VD2_H_START_END,
	S5_VPP_POSTBLEND_VD2_V_START_END,
	S5_VPP_POSTBLEND_VD3_H_START_END,
	S5_VPP_POSTBLEND_VD3_V_START_END,
	S5_VPP_POSTBLEND_H_V_SIZE,
	T3X_VPP_POST_BLEND_BLEND_DUMMY_DATA,
	T3X_VPP_POST_BLEND_DUMMY_ALPHA,
	T3X_VPP_POST_BLEND_DUMMY_ALPHA1,
	S5_VD1_BLEND_SRC_CTRL,
	S5_VD2_BLEND_SRC_CTRL,
	S5_VD3_BLEND_SRC_CTRL,
	S5_OSD1_BLEND_SRC_CTRL,
	S5_OSD2_BLEND_SRC_CTRL,
	S5_VD1_POSTBLEND_ALPHA,
	S5_VD2_POSTBLEND_ALPHA,
	S5_VD3_POSTBLEND_ALPHA,
	S5_VPP_POSTBLEND_CTRL,
};

struct vpp_post_misc_reg_s vpp_post_misc_reg_s5 = {
	S5_VPP_POSTBLEND_CTRL,
	S5_VPP_OBUF_RAM_CTRL,
	S5_VPP_4P4S_CTRL,
	S5_VPP_4S4P_CTRL,
	S5_VPP_POST_VD1_WIN_CUT_CTRL,
	S5_VPP_POST_WIN_CUT_CTRL,
	S5_VPP_POST_PAD_HSIZE,
	S5_VPP_POST_PAD_CTRL,
	/* slice reg */
	S5_VPP_OUT_H_V_SIZE,
	S5_VPP_OFIFO_SIZE,
	S5_VPP_SLC_DEAL_CTRL,
	S5_VPP_HWIN_SIZE,
	S5_VPP_ALIGN_FIFO_SIZE,
	S5_VPP_CLIP_MISC0,
	S5_VPP_CLIP_MISC1
};

struct vpp_post_misc_reg_s vpp_post_misc_reg_t3x = {
	S5_VPP_POSTBLEND_CTRL,
	S5_VPP_OBUF_RAM_CTRL,
	S5_VPP_4P4S_CTRL,
	S5_VPP_4S4P_CTRL,
	T3X_VPP_POST_VD1_WIN_CUT_CTRL,
	S5_VPP_POST_WIN_CUT_CTRL,
	T3X_VPP_POST_PAD_HSIZE,
	T3X_VPP_POST_PAD_CTRL,
	/* slice reg */
	S5_VPP_OUT_H_V_SIZE,
	S5_VPP_OFIFO_SIZE,
	S5_VPP_SLC_DEAL_CTRL,
	S5_VPP_HWIN_SIZE,
	S5_VPP_ALIGN_FIFO_SIZE,
	S5_VPP_CLIP_MISC0,
	S5_VPP_CLIP_MISC1
};

struct vpp_post_in_pad_reg_s vpp_post_in_pad_regs[5] = {
	{
		T3X_VPP_POST_VD1_PAD_CTRL,
		T3X_VPP_POST_VD1_PAD_H,
		T3X_VPP_POST_VD1_PAD_V,
		T3X_VPP_POST_VD1_DUMMY_DATA,
		T3X_VPP_POST_VD1_WIN_CUT_CTRL,
	},
	{
		T3X_VPP_POST_VD2_PAD_CTRL,
		T3X_VPP_POST_VD2_PAD_H,
		T3X_VPP_POST_VD2_PAD_V,
		T3X_VPP_POST_VD2_DUMMY_DATA,
		T3X_VPP_POST_VD2_WIN_CUT_CTRL,
	},
	{
		T3X_VPP_POST_VD3_PAD_CTRL,
		T3X_VPP_POST_VD3_PAD_H,
		T3X_VPP_POST_VD3_PAD_V,
		T3X_VPP_POST_VD3_DUMMY_DATA,
		T3X_VPP_POST_VD3_WIN_CUT_CTRL,
	},
	{
		T3X_VPP_POST_OSD1_PAD_CTRL,
		T3X_VPP_POST_OSD1_PAD_H,
		T3X_VPP_POST_OSD1_PAD_V,
		T3X_VPP_POST_OSD1_DUMMY_DATA,
		T3X_VPP_POST_OSD1_WIN_CUT_CTRL,
	},
	{
		T3X_VPP_POST_OSD2_PAD_CTRL,
		T3X_VPP_POST_OSD2_PAD_H,
		T3X_VPP_POST_OSD2_PAD_V,
		T3X_VPP_POST_OSD2_DUMMY_DATA,
		T3X_VPP_POST_OSD2_WIN_CUT_CTRL,
	},
};

struct vd_proc_blend_reg_s vd_proc_blend_reg_s5 = {
	VPP_VD_BLND_H_V_SIZE,
	VPP_VD_BLEND_DUMMY_DATA,
	VPP_VD_BLEND_DUMMY_ALPHA,
	VPP_BLEND_VD1_S0_H_START_END,
	VPP_BLEND_VD1_S0_V_START_END,
	VPP_BLEND_VD1_S1_H_START_END,
	VPP_BLEND_VD1_S1_V_START_END,
	VPP_BLEND_VD1_S2_H_START_END,
	VPP_BLEND_VD1_S2_V_START_END,
	VPP_BLEND_VD1_S3_H_START_END,
	VPP_BLEND_VD1_S3_V_START_END,
	VD1_S0_BLEND_SRC_CTRL,
	VD1_S1_BLEND_SRC_CTRL,
	VD1_S2_BLEND_SRC_CTRL,
	VD1_S3_BLEND_SRC_CTRL,
	VPP_VD_BLND_CTRL,
};

struct vpp1_post_blend_reg_s vpp1_post_blend_reg_t3x = {
	T3X_VPP1_OSD3_BLD_H_SCOPE,
	T3X_VPP1_OSD3_BLD_V_SCOPE,
	S5_VPP_POSTBLEND_VD3_H_START_END,
	S5_VPP_POSTBLEND_VD3_V_START_END,
	T3X_VPP1_BLEND_H_V_SIZE,
	T3X_VPP1_BLEND_BLEND_DUMMY_DATA,
	T3X_VPP1_BLEND_DUMMY_ALPHA,
	T3X_VPP1_BLEND_DUMMY_ALPHA1,
	T3X_VPP1_BLD_CTRL,
};

struct vd1_slice_pad_reg_s vd1_slice_pad_size0_reg_s5[SLICE_NUM] = {
	{
		VD1_S0_PAD_H_SIZE0,
		VD1_S0_PAD_V_SIZE0,
	},
	{
		VD1_S1_PAD_H_SIZE0,
		VD1_S1_PAD_V_SIZE0,
	},
	{
		VD1_S2_PAD_H_SIZE0,
		VD1_S2_PAD_V_SIZE0,
	},
	{
		VD1_S3_PAD_H_SIZE0,
		VD1_S3_PAD_V_SIZE0,
	},
};

struct vd1_slice_pad_reg_s vd1_slice_pad_size1_reg_s5[SLICE_NUM] = {
	{
		VD1_S0_PAD_H_SIZE1,
		VD1_S0_PAD_V_SIZE1,
	},
	{
		VD1_S1_PAD_H_SIZE1,
		VD1_S1_PAD_V_SIZE1,
	},
	{
		VD1_S2_PAD_H_SIZE1,
		VD1_S2_PAD_V_SIZE1,
	},
	{
		VD1_S3_PAD_H_SIZE1,
		VD1_S3_PAD_V_SIZE1,
	},
};

struct vd2_pre_blend_reg_s vd2_pre_blend_reg_s5 = {
	VPP_VD_PREBLEND_H_V_SIZE,
	VPP_VD_PRE_BLEND_DUMMY_DATA,
	VPP_VD_PRE_BLEND_DUMMY_ALPHA,
	S5_VPP_PREBLEND_VD1_H_START_END,
	S5_VPP_PREBLEND_VD1_V_START_END,
	S5_VPP_PREBLEND_VD2_H_START_END,
	S5_VPP_PREBLEND_VD2_V_START_END,
	VD1_PREBLEND_SRC_CTRL,
	VD2_PREBLEND_SRC_CTRL,
	VD1_PREBLEND_ALPHA,
	VD2_PREBLEND_ALPHA,
	VPP_VD_PREBLEND_CTRL,
};

struct vd_pip_alpha_reg_s vd_pip_alpha_reg_s5[MAX_VD_CHAN_S5] = {
	{
		S5_VD1_PIP_ALPH_CTRL,
		S5_VD1_PIP_ALPH_SCP_H_0,
		S5_VD1_PIP_ALPH_SCP_V_0,
	},
	{
		S5_VD2_PIP_ALPH_CTRL,
		S5_VD2_PIP_ALPH_SCP_H_0,
		S5_VD2_PIP_ALPH_SCP_V_0,
	},
};

struct vd_pip_alpha_reg_s vd_pip_alpha_reg_t3x[MAX_VD_CHAN_S5] = {
	{
		T3X_VD1_PIP_ALPH_CTRL,
		T3X_VD1_PIP_ALPH_SCP_H_0,
		T3X_VD1_PIP_ALPH_SCP_V_0,
	},
	{
		T3X_VD2_PIP_ALPH_CTRL,
		T3X_VD2_PIP_ALPH_SCP_H_0,
		T3X_VD2_PIP_ALPH_SCP_V_0,
	},
};

struct vd_aisr_reshape_reg_s aisr_reshape_reg_s5 = {
	S5_AISR_RESHAP_CTRL0,
	S5_AISR_RESHAP_CTRL1,
	S5_AISR_RESHAP_SCOPE_X,
	S5_AISR_RESHAP_SCOPE_Y,
	S5_AISR_RESHAP_BADDR00,
	S5_AISR_RESHAP_BADDR01,
	S5_AISR_RESHAP_BADDR02,
	S5_AISR_RESHAP_BADDR03,
	S5_AISR_RESHAP_BADDR10,
	S5_AISR_RESHAP_BADDR11,
	S5_AISR_RESHAP_BADDR12,
	S5_AISR_RESHAP_BADDR13,
	S5_AISR_RESHAP_BADDR20,
	S5_AISR_RESHAP_BADDR21,
	S5_AISR_RESHAP_BADDR22,
	S5_AISR_RESHAP_BADDR23,
	S5_AISR_RESHAP_BADDR30,
	S5_AISR_RESHAP_BADDR31,
	S5_AISR_RESHAP_BADDR32,
	S5_AISR_RESHAP_BADDR33,
	S5_AISR_POST_CTRL,
	S5_AISR_POST_SIZE,
	S5_SRSHARP1_NN_POST_TOP,
};

struct vpu_venc_regs_s venc_regs_t7[3] = {
	{
		VPU_VENCI_STAT,
		VPU_VENCP_STAT,
		VPU_VENCL_STAT,
		ENCI_VFIFO2VD_LINE_TOP_START,
		ENCP_VIDEO_VAVON_BLINE,
		ENCL_VIDEO_VAVON_BLINE,
	},
	{
		VPU_VENCI_STAT + 0x600,
		VPU_VENCP_STAT + 0x600,
		VPU_VENCL_STAT + 0x600,
		ENCI_VFIFO2VD_LINE_TOP_START + 0x600,
		ENCP_VIDEO_VAVON_BLINE + 0x600,
		ENCL_VIDEO_VAVON_BLINE + 0x600,
	},
	{
		VPU_VENCI_STAT + 0x800,
		VPU_VENCP_STAT + 0x800,
		VPU_VENCL_STAT + 0x800,
		ENCI_VFIFO2VD_LINE_TOP_START + 0x800,
		ENCP_VIDEO_VAVON_BLINE + 0x800,
		ENCL_VIDEO_VAVON_BLINE + 0x800,
	}
};

struct vpu_venc_regs_s venc_regs_t3x[3] = {
	{
		VPU_VENCI_STAT,
		VPU_VENCP_STAT,
		VPU_VENCL_STAT,
		ENCL_VIDEO_VAVON_LN_RNG,
		ENCL_VIDEO_VAVON_LN_RNG,
		ENCL_VIDEO_VAVON_LN_RNG,
	},
	{
		VPU_VENCI_STAT + 0x100,
		VPU_VENCP_STAT + 0x100,
		VPU_VENCL_STAT + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
	},
	{
		VPU_VENCI_STAT + 0x100,
		VPU_VENCP_STAT + 0x100,
		VPU_VENCL_STAT + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
		ENCL_VIDEO_VAVON_LN_RNG + 0x100,
	}
};
