/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _OSD_REG_H_
#define _OSD_REG_H_

/* vpp2 */
#define VPP2_MISC                 0x1e26
#define VPP2_OFIFO_SIZE           0x1e27
#define VPP2_INT_LINE_NUM         0x1e20
#define VPP2_OFIFO_URG_CTRL       0x1e21
#define VPP2_POSTBLEND_H_SIZE     0x1921

/* viu */
#define VIU_ADDR_START            0x1a00
#define VIU_ADDR_END              0x1aff
#define VIU_SW_RESET              0x1a01
#define VIU_MISC_CTRL0            0x1a06
#define D2D3_INTF_LENGTH          0x1a08
#define D2D3_INTF_CTRL0           0x1a09
#define VIU_OSD1_CTRL_STAT        0x1a10
#define VIU_OSD1_CTRL_STAT2       0x1a2d
#define VIU_OSD1_COLOR_ADDR       0x1a11
#define VIU_OSD1_COLOR            0x1a12
#define VIU_OSD1_TCOLOR_AG0       0x1a17
#define VIU_OSD1_TCOLOR_AG1       0x1a18
#define VIU_OSD1_TCOLOR_AG2       0x1a19
#define VIU_OSD1_TCOLOR_AG3       0x1a1a
#define VIU_OSD1_BLK0_CFG_W0      0x1a1b
#define VIU_OSD1_BLK1_CFG_W0      0x1a1f
#define VIU_OSD1_BLK2_CFG_W0      0x1a23
#define VIU_OSD1_BLK3_CFG_W0      0x1a27
#define VIU_OSD1_BLK0_CFG_W1      0x1a1c
#define VIU_OSD1_BLK1_CFG_W1      0x1a20
#define VIU_OSD1_BLK2_CFG_W1      0x1a24
#define VIU_OSD1_BLK3_CFG_W1      0x1a28
#define VIU_OSD1_BLK0_CFG_W2      0x1a1d
#define VIU_OSD1_BLK1_CFG_W2      0x1a21
#define VIU_OSD1_BLK2_CFG_W2      0x1a25
#define VIU_OSD1_BLK3_CFG_W2      0x1a29
#define VIU_OSD1_BLK0_CFG_W3      0x1a1e
#define VIU_OSD1_BLK1_CFG_W3      0x1a22
#define VIU_OSD1_BLK2_CFG_W3      0x1a26
#define VIU_OSD1_BLK3_CFG_W3      0x1a2a
#define VIU_OSD1_BLK0_CFG_W4      0x1a13
#define VIU_OSD1_BLK1_CFG_W4      0x1a14
#define VIU_OSD1_BLK2_CFG_W4      0x1a15
#define VIU_OSD1_BLK3_CFG_W4      0x1a16
#define VIU_OSD1_FIFO_CTRL_STAT   0x1a2b
#define VIU_OSD1_TEST_RDDATA      0x1a2c
#define VIU_OSD1_PROT_CTRL        0x1a2e
#define VIU_OSD1_MALI_UNPACK_CTRL 0x1a2f
#define VIU_OSD1_DIMM_CTRL        0x1adf

#define VIU_OSD2_CTRL_STAT        0x1a30
#define VIU_OSD2_CTRL_STAT2       0x1a4d
#define VIU_OSD2_COLOR_ADDR       0x1a31
#define VIU_OSD2_COLOR            0x1a32
#define VIU_OSD2_HL1_H_START_END  0x1a33
#define VIU_OSD2_HL1_V_START_END  0x1a34
#define VIU_OSD2_HL2_H_START_END  0x1a35
#define VIU_OSD2_HL2_V_START_END  0x1a36
#define VIU_OSD2_TCOLOR_AG0       0x1a37
#define VIU_OSD2_TCOLOR_AG1       0x1a38
#define VIU_OSD2_TCOLOR_AG2       0x1a39
#define VIU_OSD2_TCOLOR_AG3       0x1a3a
#define VIU_OSD2_BLK0_CFG_W0      0x1a3b
#define VIU_OSD2_BLK1_CFG_W0      0x1a3f
#define VIU_OSD2_BLK2_CFG_W0      0x1a43
#define VIU_OSD2_BLK3_CFG_W0      0x1a47
#define VIU_OSD2_BLK0_CFG_W1      0x1a3c
#define VIU_OSD2_BLK1_CFG_W1      0x1a40
#define VIU_OSD2_BLK2_CFG_W1      0x1a44
#define VIU_OSD2_BLK3_CFG_W1      0x1a48
#define VIU_OSD2_BLK0_CFG_W2      0x1a3d
#define VIU_OSD2_BLK1_CFG_W2      0x1a41
#define VIU_OSD2_BLK2_CFG_W2      0x1a45
#define VIU_OSD2_BLK3_CFG_W2      0x1a49
#define VIU_OSD2_BLK0_CFG_W3      0x1a3e
#define VIU_OSD2_BLK1_CFG_W3      0x1a42
#define VIU_OSD2_BLK2_CFG_W3      0x1a46
#define VIU_OSD2_BLK3_CFG_W3      0x1a4a
#define VIU_OSD2_BLK0_CFG_W4      0x1a64
#define VIU_OSD2_BLK1_CFG_W4      0x1a65
#define VIU_OSD2_BLK2_CFG_W4      0x1a66
#define VIU_OSD2_BLK3_CFG_W4      0x1a67
#define VIU_OSD2_FIFO_CTRL_STAT   0x1a4b
#define VIU_OSD2_TEST_RDDATA      0x1a4c
#define VIU_OSD2_PROT_CTRL        0x1a4e
#define VIU_OSD2_MALI_UNPACK_CTRL 0x1abd
#define VIU_OSD2_DIMM_CTRL        0x1acf

#define VIU_OSD3_CTRL_STAT        0x3d80
#define VIU_OSD3_CTRL_STAT2       0x3d81
#define VIU_OSD3_COLOR_ADDR       0x3d82
#define VIU_OSD3_COLOR            0x3d83
#define VIU_OSD3_TCOLOR_AG0       0x3d84
#define VIU_OSD3_TCOLOR_AG1       0x3d85
#define VIU_OSD3_TCOLOR_AG2       0x3d86
#define VIU_OSD3_TCOLOR_AG3       0x3d87
#define VIU_OSD3_BLK0_CFG_W0      0x3d88
#define VIU_OSD3_BLK0_CFG_W1      0x3d8c
#define VIU_OSD3_BLK0_CFG_W2      0x3d90
#define VIU_OSD3_BLK0_CFG_W3      0x3d94
#define VIU_OSD3_BLK0_CFG_W4      0x3d98
#define VIU_OSD3_BLK1_CFG_W4      0x3d99
#define VIU_OSD3_BLK2_CFG_W4      0x3d9a
#define VIU_OSD3_FIFO_CTRL_STAT   0x3d9c
#define VIU_OSD3_TEST_RDDATA      0x3d9d
#define VIU_OSD3_PROT_CTRL        0x3d9e
#define VIU_OSD3_MALI_UNPACK_CTRL 0x3d9f
#define VIU_OSD3_DIMM_CTRL        0x3da0
#define VIU_OSD3_MATRIX_COEF00_01                  0x3db0
#define VIU_OSD3_MATRIX_COEF02_10                  0x3db1
#define VIU_OSD3_MATRIX_COEF11_12                  0x3db2
#define VIU_OSD3_MATRIX_COEF20_21                  0x3db3
#define VIU_OSD3_MATRIX_COEF22                     0x3db4
#define VIU_OSD3_MATRIX_COEF13_14                  0x3db5
#define VIU_OSD3_MATRIX_COEF23_24                  0x3db6
#define VIU_OSD3_MATRIX_COEF15_25                  0x3db7
#define VIU_OSD3_MATRIX_CLIP                       0x3db8
#define VIU_OSD3_MATRIX_OFFSET0_1                  0x3db9
#define VIU_OSD3_MATRIX_OFFSET2                    0x3dba
#define VIU_OSD3_MATRIX_PRE_OFFSET0_1              0x3dbb
#define VIU_OSD3_MATRIX_PRE_OFFSET2                0x3dbc
#define VIU_OSD3_MATRIX_EN_CTRL                    0x3dbd

#define VIU_OSD4_CTRL_STAT                         0x3dc0
#define VIU_OSD4_CTRL_STAT2                        0x3dc1
#define VIU_OSD4_COLOR_ADDR                        0x3dc2
#define VIU_OSD4_COLOR                             0x3dc3
#define VIU_OSD4_TCOLOR_AG0                        0x3dc4
#define VIU_OSD4_TCOLOR_AG1                        0x3dc5
#define VIU_OSD4_TCOLOR_AG2                        0x3dc6
#define VIU_OSD4_TCOLOR_AG3                        0x3dc7
#define VIU_OSD4_BLK0_CFG_W0                       0x3dc8
#define VIU_OSD4_BLK1_CFG_W0                       0x3dc9
#define VIU_OSD4_BLK2_CFG_W0                       0x3dca
#define VIU_OSD4_BLK3_CFG_W0                       0x3dcb
#define VIU_OSD4_BLK0_CFG_W1                       0x3dcc
#define VIU_OSD4_BLK1_CFG_W1                       0x3dcd
#define VIU_OSD4_BLK2_CFG_W1                       0x3dce
#define VIU_OSD4_BLK3_CFG_W1                       0x3dcf
#define VIU_OSD4_BLK0_CFG_W2                       0x3dd0
#define VIU_OSD4_BLK1_CFG_W2                       0x3dd1
#define VIU_OSD4_BLK2_CFG_W2                       0x3dd2
#define VIU_OSD4_BLK3_CFG_W2                       0x3dd3
#define VIU_OSD4_BLK0_CFG_W3                       0x3dd4
#define VIU_OSD4_BLK1_CFG_W3                       0x3dd5
#define VIU_OSD4_BLK2_CFG_W3                       0x3dd6
#define VIU_OSD4_BLK3_CFG_W3                       0x3dd7
#define VIU_OSD4_BLK0_CFG_W4                       0x3dd8
#define VIU_OSD4_BLK1_CFG_W4                       0x3dd9
#define VIU_OSD4_BLK2_CFG_W4                       0x3dda
#define VIU_OSD4_BLK3_CFG_W4                       0x3ddb
#define VIU_OSD4_FIFO_CTRL_STAT                    0x3ddc
#define VIU_OSD4_TEST_RDDATA                       0x3ddd
#define VIU_OSD4_PROT_CTRL                         0x3dde
#define VIU_OSD4_MALI_UNPACK_CTRL                  0x3ddf
#define VIU_OSD4_DIMM_CTRL                         0x3de0
#define VIU_OSD4_MATRIX_COEF00_01                  0x3df0
#define VIU_OSD4_MATRIX_COEF02_10                  0x3df1
#define VIU_OSD4_MATRIX_COEF11_12                  0x3df2
#define VIU_OSD4_MATRIX_COEF20_21                  0x3df3
#define VIU_OSD4_MATRIX_COEF22                     0x3df4
#define VIU_OSD4_MATRIX_COEF13_14                  0x3df5
#define VIU_OSD4_MATRIX_COEF23_24                  0x3df6
#define VIU_OSD4_MATRIX_COEF15_25                  0x3df7
#define VIU_OSD4_MATRIX_CLIP                       0x3df8
#define VIU_OSD4_MATRIX_OFFSET0_1                  0x3df9
#define VIU_OSD4_MATRIX_OFFSET2                    0x3dfa
#define VIU_OSD4_MATRIX_PRE_OFFSET0_1              0x3dfb
#define VIU_OSD4_MATRIX_PRE_OFFSET2                0x3dfc
#define VIU_OSD4_MATRIX_EN_CTRL                    0x3dfd

#define VIU_DATA_SEC              0x1a50
#define VD1_IF0_GEN_REG           0x1a50
#define VD1_IF0_CANVAS0           0x1a51
#define VD1_IF0_CANVAS1           0x1a52
#define VD1_IF0_LUMA_X0           0x1a53
#define VD1_IF0_LUMA_Y0           0x1a54
#define VD1_IF0_CHROMA_X0         0x1a55
#define VD1_IF0_CHROMA_Y0         0x1a56
#define VD1_IF0_LUMA_X1           0x1a57
#define VD1_IF0_LUMA_Y1           0x1a58
#define VD1_IF0_CHROMA_X1         0x1a59
#define VD1_IF0_CHROMA_Y1         0x1a5a
#define VD1_IF0_RPT_LOOP          0x1a5b
#define VD1_IF0_LUMA0_RPT_PAT     0x1a5c
#define VD1_IF0_CHROMA0_RPT_PAT   0x1a5d
#define VD1_IF0_LUMA1_RPT_PAT     0x1a5e
#define VD1_IF0_CHROMA1_RPT_PAT   0x1a5f
#define VD1_IF0_LUMA_PSEL         0x1a60
#define VD1_IF0_CHROMA_PSEL       0x1a61
#define VD1_IF0_DUMMY_PIXEL       0x1a62
#define VD1_IF0_LUMA_FIFO_SIZE    0x1a63
#define VD1_IF0_RANGE_MAP_Y       0x1a6a
#define VD1_IF0_RANGE_MAP_CB      0x1a6b
#define VD1_IF0_RANGE_MAP_CR      0x1a6c
#define VD1_IF0_GEN_REG2          0x1a6d
#define VD1_IF0_PROT_CNTL         0x1a6e
#define VIU_VD1_FMT_CTRL          0x1a68
#define VIU_VD1_FMT_W             0x1a69
#define VD2_IF0_GEN_REG           0x1a70
#define VD2_IF0_CANVAS0           0x1a71
#define VD2_IF0_CANVAS1           0x1a72
#define VD2_IF0_LUMA_X0           0x1a73
#define VD2_IF0_LUMA_Y0           0x1a74
#define VD2_IF0_CHROMA_X0         0x1a75
#define VD2_IF0_CHROMA_Y0         0x1a76
#define VD2_IF0_LUMA_X1           0x1a77
#define VD2_IF0_LUMA_Y1           0x1a78
#define VD2_IF0_CHROMA_X1         0x1a79
#define VD2_IF0_CHROMA_Y1         0x1a7a
#define VD2_IF0_RPT_LOOP          0x1a7b
#define VD2_IF0_LUMA0_RPT_PAT     0x1a7c
#define VD2_IF0_CHROMA0_RPT_PAT   0x1a7d
#define VD2_IF0_LUMA1_RPT_PAT     0x1a7e
#define VD2_IF0_CHROMA1_RPT_PAT   0x1a7f
#define VD2_IF0_LUMA_PSEL         0x1a80
#define VD2_IF0_CHROMA_PSEL       0x1a81
#define VD2_IF0_DUMMY_PIXEL       0x1a82
#define VD2_IF0_LUMA_FIFO_SIZE    0x1a83
#define VD2_IF0_RANGE_MAP_Y       0x1a8a
#define VD2_IF0_RANGE_MAP_CB      0x1a8b
#define VD2_IF0_RANGE_MAP_CR      0x1a8c
#define VD2_IF0_GEN_REG2          0x1a8d
#define VD2_IF0_PROT_CNTL         0x1a8e
#define VIU_VD2_FMT_CTRL          0x1a88
#define VIU_VD2_FMT_W             0x1a89

#define VIU_OSD1_MATRIX_CTRL              0x1a90
#define VIU_OSD1_MATRIX_COEF00_01         0x1a91
#define VIU_OSD1_MATRIX_COEF02_10         0x1a92
#define VIU_OSD1_MATRIX_COEF11_12         0x1a93
#define VIU_OSD1_MATRIX_COEF20_21         0x1a94
#define VIU_OSD1_MATRIX_COLMOD_COEF42     0x1a95
#define VIU_OSD1_MATRIX_OFFSET0_1         0x1a96
#define VIU_OSD1_MATRIX_OFFSET2           0x1a97
#define VIU_OSD1_MATRIX_PRE_OFFSET0_1     0x1a98
#define VIU_OSD1_MATRIX_PRE_OFFSET2       0x1a99
#define VIU_OSD1_MATRIX_COEF22_30         0x1a9d
#define VIU_OSD1_MATRIX_COEF31_32         0x1a9e
#define VIU_OSD1_MATRIX_COEF40_41         0x1a9f

#define VIU_OSD_BLENDO_H_START_END        0x1aa9
#define VIU_OSD_BLENDO_V_START_END        0x1aaa
#define VIU_OSD_BLEND_GEN_CTRL0           0x1aab
#define VIU_OSD_BLEND_GEN_CTRL1           0x1aac
#define VIU_OSD_BLEND_DUMMY_DATA          0x1aad
#define VIU_OSD_BLEND_CURRENT_XY          0x1aae

#define VIU_OSD2_MATRIX_CTRL              0x1ab0
#define VIU_OSD2_MATRIX_COEF00_01         0x1ab1
#define VIU_OSD2_MATRIX_COEF02_10         0x1ab2
#define VIU_OSD2_MATRIX_COEF11_12         0x1ab3
#define VIU_OSD2_MATRIX_COEF20_21         0x1ab4
#define VIU_OSD2_MATRIX_COEF22            0x1ab5
#define VIU_OSD2_MATRIX_OFFSET0_1         0x1ab6
#define VIU_OSD2_MATRIX_OFFSET2           0x1ab7
#define VIU_OSD2_MATRIX_PRE_OFFSET0_1     0x1ab8
#define VIU_OSD2_MATRIX_PRE_OFFSET2       0x1ab9
#define VIU_OSD2_MATRIX_PROBE_COLOR       0x1aba
#define VIU_OSD2_MATRIX_HL_COLOR          0x1abb
#define VIU_OSD2_MATRIX_PROBE_POS         0x1abc
#define VIU_OSD1_EOTF_CTL                 0x1ad4
#define VIU_OSD1_EOTF_COEF00_01           0x1ad5
#define VIU_OSD1_EOTF_COEF02_10           0x1ad6
#define VIU_OSD1_EOTF_COEF11_12           0x1ad7
#define VIU_OSD1_EOTF_COEF20_21           0x1ad8
#define VIU_OSD1_EOTF_COEF22_RS           0x1ad9
#define VIU_OSD1_EOTF_LUT_ADDR_PORT       0x1ada
#define VIU_OSD1_EOTF_LUT_DATA_PORT       0x1adb
#define VIU_OSD1_OETF_CTL                 0x1adc
#define VIU_OSD1_OETF_LUT_ADDR_PORT       0x1add
#define VIU_OSD1_OETF_LUT_DATA_PORT       0x1ade

/* vpp */
#define VPP_DUMMY_DATA                    0x1d00
#define VPP_LINE_IN_LENGTH                0x1d01
#define VPP_PIC_IN_HEIGHT                 0x1d02
#define VPP_SCALE_COEF_IDX                0x1d03
#define VPP_SCALE_COEF                    0x1d04
#define VPP_VSC_REGION12_STARTP           0x1d05
#define VPP_VSC_REGION34_STARTP           0x1d06
#define VPP_VSC_REGION4_ENDP              0x1d07
#define VPP_VSC_START_PHASE_STEP          0x1d08
#define VPP_VSC_REGION0_PHASE_SLOPE       0x1d09
#define VPP_VSC_REGION1_PHASE_SLOPE       0x1d0a
#define VPP_VSC_REGION3_PHASE_SLOPE       0x1d0b
#define VPP_VSC_REGION4_PHASE_SLOPE       0x1d0c
#define VPP_VSC_PHASE_CTRL                0x1d0d
#define VPP_VSC_INI_PHASE                 0x1d0e
#define VPP_HSC_REGION12_STARTP           0x1d10
#define VPP_HSC_REGION34_STARTP           0x1d11
#define VPP_HSC_REGION4_ENDP              0x1d12
#define VPP_HSC_START_PHASE_STEP          0x1d13
#define VPP_HSC_REGION0_PHASE_SLOPE       0x1d14
#define VPP_HSC_REGION1_PHASE_SLOPE       0x1d15
#define VPP_HSC_REGION3_PHASE_SLOPE       0x1d16
#define VPP_HSC_REGION4_PHASE_SLOPE       0x1d17
#define VPP_HSC_PHASE_CTRL                0x1d18
#define VPP_SC_MISC                       0x1d19
#define VPP_PREBLEND_VD1_H_START_END      0x1d1a
#define VPP_PREBLEND_VD1_V_START_END      0x1d1b

#define VPP_BLEND_VD2_H_START_END         0x1d1e
#define VPP_BLEND_VD2_V_START_END         0x1d1f
#define VPP_PREBLEND_H_SIZE               0x1d20
#define VPP_POSTBLEND_H_SIZE              0x1d21
#define VPP_HOLD_LINES                    0x1d22
#define VPP_BLEND_ONECOLOR_CTRL           0x1d23
#define VPP_PREBLEND_CURRENT_XY           0x1d24
#define VPP_POSTBLEND_CURRENT_XY          0x1d25
#define VPP_MISC                          0x1d26
#define VPP_OFIFO_SIZE                    0x1d27
#define VPP_FIFO_STATUS                   0x1d28
#define VPP_SMOKE_CTRL                    0x1d29
#define VPP_SMOKE1_VAL                    0x1d2a
#define VPP_SMOKE2_VAL                    0x1d2b
#define VPP_SMOKE3_VAL                    0x1d2c
#define VPP_SMOKE1_H_START_END            0x1d2d
#define VPP_SMOKE1_V_START_END            0x1d2e
#define VPP_SMOKE2_H_START_END            0x1d2f
#define VPP_SMOKE2_V_START_END            0x1d30
#define VPP_SMOKE3_H_START_END            0x1d31
#define VPP_SMOKE3_V_START_END            0x1d32
#define VPP_SCO_FIFO_CTRL                 0x1d33
#define VPP_HSC_PHASE_CTRL1               0x1d34
#define VPP_HSC_INI_PAT_CTRL              0x1d35
#define VPP_VADJ_CTRL                     0x1d40
#define VPP_VADJ1_Y                       0x1d41
#define VPP_VADJ1_MA_MB                   0x1d42
#define VPP_VADJ1_MC_MD                   0x1d43
#define VPP_VADJ2_Y                       0x1d44
#define VPP_VADJ2_MA_MB                   0x1d45
#define VPP_VADJ2_MC_MD                   0x1d46
#define VPP_HSHARP_CTRL                   0x1d50
#define VPP_HSHARP_LUMA_THRESH01          0x1d51
#define VPP_HSHARP_LUMA_THRESH23          0x1d52
#define VPP_HSHARP_CHROMA_THRESH01        0x1d53
#define VPP_HSHARP_CHROMA_THRESH23        0x1d54
#define VPP_HSHARP_LUMA_GAIN              0x1d55
#define VPP_HSHARP_CHROMA_GAIN            0x1d56
#define VPP_MATRIX_PROBE_COLOR            0x1d5c
#define VPP_MATRIX_HL_COLOR               0x1d5d
#define VPP_MATRIX_PROBE_POS              0x1d5e
#define VPP_MATRIX_CTRL                   0x1d5f
#define VPP_MATRIX_COEF00_01              0x1d60
#define VPP_MATRIX_COEF02_10              0x1d61
#define VPP_MATRIX_COEF11_12              0x1d62
#define VPP_MATRIX_COEF20_21              0x1d63
#define VPP_MATRIX_COEF22                 0x1d64
#define VPP_MATRIX_OFFSET0_1              0x1d65
#define VPP_MATRIX_OFFSET2                0x1d66
#define VPP_MATRIX_PRE_OFFSET0_1          0x1d67
#define VPP_MATRIX_PRE_OFFSET2            0x1d68
#define VPP_DUMMY_DATA1                   0x1d69
#define VPP_GAINOFF_CTRL0                 0x1d6a
#define VPP_GAINOFF_CTRL1                 0x1d6b
#define VPP_GAINOFF_CTRL2                 0x1d6c
#define VPP_GAINOFF_CTRL3                 0x1d6d
#define VPP_GAINOFF_CTRL4                 0x1d6e
#define VPP_CHROMA_ADDR_PORT              0x1d70
#define VPP_CHROMA_DATA_PORT              0x1d71
#define VPP_GCLK_CTRL0                    0x1d72
#define VPP_GCLK_CTRL1                    0x1d73
#define VPP_SC_GCLK_CTRL                  0x1d74
#define VPP_MISC1                         0x1d76
#define VPP_BLACKEXT_CTRL                 0x1d80
#define VPP_DNLP_CTRL_00                  0x1d81
#define VPP_DNLP_CTRL_01                  0x1d82
#define VPP_DNLP_CTRL_02                  0x1d83
#define VPP_DNLP_CTRL_03                  0x1d84
#define VPP_DNLP_CTRL_04                  0x1d85
#define VPP_DNLP_CTRL_05                  0x1d86
#define VPP_DNLP_CTRL_06                  0x1d87
#define VPP_DNLP_CTRL_07                  0x1d88
#define VPP_DNLP_CTRL_08                  0x1d89
#define VPP_DNLP_CTRL_09                  0x1d8a
#define VPP_DNLP_CTRL_10                  0x1d8b
#define VPP_DNLP_CTRL_11                  0x1d8c
#define VPP_DNLP_CTRL_12                  0x1d8d
#define VPP_DNLP_CTRL_13                  0x1d8e
#define VPP_DNLP_CTRL_14                  0x1d8f
#define VPP_DNLP_CTRL_15                  0x1d90
#define VPP_PEAKING_HGAIN                 0x1d91
#define VPP_PEAKING_VGAIN                 0x1d92
#define VPP_PEAKING_NLP_1                 0x1d93
#define VPP_PEAKING_NLP_2                 0x1d94
#define VPP_PEAKING_NLP_3                 0x1d95
#define VPP_PEAKING_NLP_4                 0x1d96
#define VPP_PEAKING_NLP_5                 0x1d97
#define VPP_SHARP_LIMIT                   0x1d98
#define VPP_VLTI_CTRL                     0x1d99
#define VPP_HLTI_CTRL                     0x1d9a
#define VPP_CTI_CTRL                      0x1d9b
#define VPP_BLUE_STRETCH_1                0x1d9c
#define VPP_BLUE_STRETCH_2                0x1d9d
#define VPP_BLUE_STRETCH_3                0x1d9e
#define VPP_CCORING_CTRL                  0x1da0
#define VPP_VE_ENABLE_CTRL                0x1da1
#define VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH 0x1da2
#define VPP_VE_DEMO_CENTER_BAR            0x1da3
#define VPP_VE_H_V_SIZE                   0x1da4
#define VPP_VDO_MEAS_VS_COUNT_HI          0x1da9
#define VPP_VDO_MEAS_VS_COUNT_LO          0x1daa
#define VPP_INPUT_CTRL                    0x1dab
#define VPP_CTI_CTRL2                     0x1dac
#define VPP_PEAKING_SAT_THD1              0x1dad
#define VPP_PEAKING_SAT_THD2              0x1dae
#define VPP_PEAKING_SAT_THD3              0x1daf
#define VPP_PEAKING_SAT_THD4              0x1db0
#define VPP_PEAKING_SAT_THD5              0x1db1
#define VPP_PEAKING_SAT_THD6              0x1db2
#define VPP_PEAKING_SAT_THD7              0x1db3
#define VPP_PEAKING_SAT_THD8              0x1db4
#define VPP_PEAKING_SAT_THD9              0x1db5
#define VPP_PEAKING_GAIN_ADD1             0x1db6
#define VPP_PEAKING_GAIN_ADD2             0x1db7
#define VPP_PEAKING_DNLP                  0x1db8
#define VPP_SHARP_DEMO_WIN_CTRL1          0x1db9
#define VPP_SHARP_DEMO_WIN_CTRL2          0x1dba
#define VPP_FRONT_HLTI_CTRL               0x1dbb
#define VPP_FRONT_CTI_CTRL                0x1dbc
#define VPP_FRONT_CTI_CTRL2               0x1dbd
#define VPP_OSD_VSC_PHASE_STEP            0x1dc0
#define VPP_OSD_VSC_INI_PHASE             0x1dc1
#define VPP_OSD_VSC_CTRL0                 0x1dc2
#define VPP_OSD_HSC_PHASE_STEP            0x1dc3
#define VPP_OSD_HSC_INI_PHASE             0x1dc4
#define VPP_OSD_HSC_CTRL0                 0x1dc5
#define VPP_OSD_HSC_INI_PAT_CTRL          0x1dc6
#define VPP_OSD_SC_DUMMY_DATA             0x1dc7
#define VPP_OSD_SC_CTRL0                  0x1dc8
#define VPP_OSD_SCI_WH_M1                 0x1dc9
#define VPP_OSD_SCO_H_START_END           0x1dca
#define VPP_OSD_SCO_V_START_END           0x1dcb
#define VPP_OSD_SCALE_COEF_IDX            0x1dcc
#define VPP_OSD_SCALE_COEF                0x1dcd
#define VPP_INT_LINE_NUM                  0x1dce
#define VPP_OSD_SCALE_CTRL                0x1dff
/* osd2 scaler */
#define OSD2_VSC_PHASE_STEP               0x3d00
#define OSD2_VSC_INI_PHASE                0x3d01
#define OSD2_VSC_CTRL0                    0x3d02
#define OSD2_HSC_PHASE_STEP               0x3d03
#define OSD2_HSC_INI_PHASE                0x3d04
#define OSD2_HSC_CTRL0                    0x3d05
#define OSD2_HSC_INI_PAT_CTRL             0x3d06
#define OSD2_SC_DUMMY_DATA                0x3d07
#define OSD2_SC_CTRL0                     0x3d08
#define OSD2_SCI_WH_M1                    0x3d09
#define OSD2_SCO_H_START_END              0x3d0a
#define OSD2_SCO_V_START_END              0x3d0b
#define OSD2_SCALE_COEF_IDX               0x3d18
#define OSD2_SCALE_COEF                   0x3d19

/* osd34 scaler */
#define OSD34_SCALE_COEF_IDX              0x3d1e
#define OSD34_SCALE_COEF                  0x3d1f
#define OSD34_VSC_PHASE_STEP              0x3d20
#define OSD34_VSC_INI_PHASE               0x3d21
#define OSD34_VSC_CTRL0                   0x3d22
#define OSD34_HSC_PHASE_STEP              0x3d23
#define OSD34_HSC_INI_PHASE               0x3d24
#define OSD34_HSC_CTRL0                   0x3d25
#define OSD34_HSC_INI_PAT_CTRL            0x3d26
#define OSD34_SC_DUMMY_DATA               0x3d27
#define OSD34_SC_CTRL0                    0x3d28
#define OSD34_SCI_WH_M1                   0x3d29
#define OSD34_SCO_H_START_END             0x3d2a
#define OSD34_SCO_V_START_END             0x3d2b

/* for t7 osd scaler */
#define T7_VPP_OSD_VSC_PHASE_STEP                     0x5a00
#define T7_VPP_OSD_VSC_INI_PHASE                      0x5a01
#define T7_VPP_OSD_VSC_CTRL0                          0x5a02
#define T7_VPP_OSD_HSC_PHASE_STEP                     0x5a03
#define T7_VPP_OSD_HSC_INI_PHASE                      0x5a04
#define T7_VPP_OSD_HSC_CTRL0                          0x5a05
#define T7_VPP_OSD_HSC_INI_PAT_CTRL                   0x5a06
#define T7_VPP_OSD_SC_DUMMY_DATA                      0x5a07
#define T7_VPP_OSD_SC_CTRL0                           0x5a08
#define T7_VPP_OSD_SCI_WH_M1                          0x5a09
#define T7_VPP_OSD_SCO_H_START_END                    0x5a0a
#define T7_VPP_OSD_SCO_V_START_END                    0x5a0b
#define T7_VPP_OSD_SCALE_COEF_IDX                     0x5a0c
#define T7_VPP_OSD_SCALE_COEF                         0x5a0d

#define T7_OSD2_VSC_PHASE_STEP                        0x5a40
#define T7_OSD2_VSC_INI_PHASE                         0x5a41
#define T7_OSD2_VSC_CTRL0                             0x5a42
#define T7_OSD2_HSC_PHASE_STEP                        0x5a43
#define T7_OSD2_HSC_INI_PHASE                         0x5a44
#define T7_OSD2_HSC_CTRL0                             0x5a45
#define T7_OSD2_HSC_INI_PAT_CTRL                      0x5a46
#define T7_OSD2_SC_DUMMY_DATA                         0x5a47
#define T7_OSD2_SC_CTRL0                              0x5a48
#define T7_OSD2_SCI_WH_M1                             0x5a49
#define T7_OSD2_SCO_H_START_END                       0x5a4a
#define T7_OSD2_SCO_V_START_END                       0x5a4b
#define T7_OSD2_SCALE_COEF_IDX                        0x5a4c
#define T7_OSD2_SCALE_COEF                            0x5a4d

#define T7_OSD34_VSC_PHASE_STEP                       0x5a80
#define T7_OSD34_VSC_INI_PHASE                        0x5a81
#define T7_OSD34_VSC_CTRL0                            0x5a82
#define T7_OSD34_HSC_PHASE_STEP                       0x5a83
#define T7_OSD34_HSC_INI_PHASE                        0x5a84
#define T7_OSD34_HSC_CTRL0                            0x5a85
#define T7_OSD34_HSC_INI_PAT_CTRL                     0x5a86
#define T7_OSD34_SC_DUMMY_DATA                        0x5a87
#define T7_OSD34_SC_CTRL0                             0x5a88
#define T7_OSD34_SCI_WH_M1                            0x5a89
#define T7_OSD34_SCO_H_START_END                      0x5a8a
#define T7_OSD34_SCO_V_START_END                      0x5a8b
#define T7_OSD34_SCALE_COEF_IDX                       0x5a8c
#define T7_OSD34_SCALE_COEF                           0x5a8d

#define T7_OSD4_VSC_PHASE_STEP                        0x5ac0
#define T7_OSD4_VSC_INI_PHASE                         0x5ac1
#define T7_OSD4_VSC_CTRL0                             0x5ac2
#define T7_OSD4_HSC_PHASE_STEP                        0x5ac3
#define T7_OSD4_HSC_INI_PHASE                         0x5ac4
#define T7_OSD4_HSC_CTRL0                             0x5ac5
#define T7_OSD4_HSC_INI_PAT_CTRL                      0x5ac6
#define T7_OSD4_SC_DUMMY_DATA                         0x5ac7
#define T7_OSD4_SC_CTRL0                              0x5ac8
#define T7_OSD4_SCI_WH_M1                             0x5ac9
#define T7_OSD4_SCO_H_START_END                       0x5aca
#define T7_OSD4_SCO_V_START_END                       0x5acb
#define T7_OSD4_SCALE_COEF_IDX                        0x5acc
#define T7_OSD4_SCALE_COEF                            0x5acd

/* viu2 */
#define VIU2_ADDR_START                   0x1e00
#define VIU2_ADDR_END                     0x1eff
#define VIU2_SW_RESET                     0x1e01
#define VIU2_SW_RESET0                    0x1e02
#define VIU2_SECURE_REG                   0x1e05
#define VIU2_MISC_CTRL0                   0x1e06
#define VIU2_OSD1_CTRL_STAT               0x1e30
#define VIU2_OSD1_CTRL_STAT2              0x1e4d
#define VIU2_OSD1_COLOR_ADDR              0x1e31
#define VIU2_OSD1_COLOR                   0x1e32
#define VIU2_OSD1_HL1_H_START_END         0x1e33
#define VIU2_OSD1_HL1_V_START_END         0x1e34
#define VIU2_OSD1_HL2_H_START_END         0x1e35
#define VIU2_OSD1_HL2_V_START_END         0x1e36
#define VIU2_OSD1_TCOLOR_AG0              0x1e37
#define VIU2_OSD1_TCOLOR_AG1              0x1e38
#define VIU2_OSD1_TCOLOR_AG2              0x1e39
#define VIU2_OSD1_TCOLOR_AG3              0x1e3a
#define VIU2_OSD1_BLK0_CFG_W0             0x1e3b
#define VIU2_OSD1_BLK1_CFG_W0             0x1e3f
#define VIU2_OSD1_BLK2_CFG_W0             0x1e43
#define VIU2_OSD1_BLK3_CFG_W0             0x1e47
#define VIU2_OSD1_BLK0_CFG_W1             0x1e3c
#define VIU2_OSD1_BLK1_CFG_W1             0x1e40
#define VIU2_OSD1_BLK2_CFG_W1             0x1e44
#define VIU2_OSD1_BLK3_CFG_W1             0x1e48
#define VIU2_OSD1_BLK0_CFG_W2             0x1e3d
#define VIU2_OSD1_BLK1_CFG_W2             0x1e41
#define VIU2_OSD1_BLK2_CFG_W2             0x1e45
#define VIU2_OSD1_BLK3_CFG_W2             0x1e49
#define VIU2_OSD1_BLK0_CFG_W3             0x1e3e
#define VIU2_OSD1_BLK1_CFG_W3             0x1e42
#define VIU2_OSD1_BLK2_CFG_W3             0x1e46
#define VIU2_OSD1_BLK3_CFG_W3             0x1e4a
#define VIU2_OSD1_BLK0_CFG_W4             0x1e64
#define VIU2_OSD1_BLK1_CFG_W4             0x1e65
#define VIU2_OSD1_BLK2_CFG_W4             0x1e66
#define VIU2_OSD1_BLK3_CFG_W4             0x1e67
#define VIU2_OSD1_FIFO_CTRL_STAT          0x1e4b
#define VIU2_OSD1_TEST_RDDATA             0x1e4c
#define VIU2_OSD1_PROT_CTRL               0x1e4e
#define VIU2_OSD1_MALI_UNPACK_CTRL        0x1e4f
#define VIU2_OSD1_DIMM_CTRL               0x1e50

/* viu2 rotate */
#define VIU2_RMIF_CTRL1                   0x1e81
#define VIU2_RMIF_SCOPE_X                 0x1e83
#define VIU2_RMIF_SCOPE_Y                 0x1e84
#define VIU2_ROT_BLK_SIZE                 0x1e85
#define VIU2_ROT_LBUF_SIZE                0x1e86
#define VIU2_ROT_FMT_CTRL                 0x1e87
#define VIU2_ROT_OUT_VCROP                0x1e89

/* encode */
#define ENCP_VFIFO2VD_CTL            0x1b58
#define ENCP_VFIFO2VD_PIXEL_START    0x1b59
#define ENCP_VFIFO2VD_PIXEL_END      0x1b5a
#define ENCP_VFIFO2VD_LINE_TOP_START 0x1b5b
#define ENCP_VFIFO2VD_LINE_TOP_END   0x1b5c
#define ENCP_VFIFO2VD_LINE_BOT_START 0x1b5d
#define ENCP_VFIFO2VD_LINE_BOT_END   0x1b5e
#define VENC_SYNC_ROUTE              0x1b60
#define VENC_VIDEO_EXSRC             0x1b61
#define VENC_DVI_SETTING             0x1b62
#define VENC_C656_CTRL               0x1b63
#define VENC_UPSAMPLE_CTRL0          0x1b64
#define VENC_UPSAMPLE_CTRL1          0x1b65
#define VENC_UPSAMPLE_CTRL2          0x1b66
#define TCON_INVERT_CTL              0x1b67
#define VENC_VIDEO_PROG_MODE         0x1b68
#define VENC_ENCI_LINE               0x1b69
#define VENC_ENCI_PIXEL              0x1b6a
#define VENC_ENCP_LINE               0x1b6b
#define VENC_ENCP_PIXEL              0x1b6c
#define VENC_STATA                   0x1b6d
#define VENC_INTCTRL                 0x1b6e
#define VENC_INTFLAG                 0x1b6f
#define VENC_VIDEO_TST_EN            0x1b70
#define VENC_VIDEO_TST_MDSEL         0x1b71
#define VENC_VIDEO_TST_Y             0x1b72
#define VENC_VIDEO_TST_CB            0x1b73
#define VENC_VIDEO_TST_CR            0x1b74
#define VENC_VIDEO_TST_CLRBAR_STRT   0x1b75
#define VENC_VIDEO_TST_CLRBAR_WIDTH  0x1b76
#define VENC_VIDEO_TST_VDCNT_STSET   0x1b77
#define VENC_VDAC_DACSEL0            0x1b78
#define VENC_VDAC_DACSEL1            0x1b79
#define VENC_VDAC_DACSEL2            0x1b7a
#define VENC_VDAC_DACSEL3            0x1b7b
#define VENC_VDAC_DACSEL4            0x1b7c
#define VENC_VDAC_DACSEL5            0x1b7d
#define VENC_VDAC_SETTING            0x1b7e
#define VENC_VDAC_TST_VAL            0x1b7f
#define VENC_VDAC_DAC0_GAINCTRL      0x1bf0
#define VENC_VDAC_DAC0_OFFSET        0x1bf1
#define VENC_VDAC_DAC1_GAINCTRL      0x1bf2
#define VENC_VDAC_DAC1_OFFSET        0x1bf3
#define VENC_VDAC_DAC2_GAINCTRL      0x1bf4
#define VENC_VDAC_DAC2_OFFSET        0x1bf5
#define VENC_VDAC_DAC3_GAINCTRL      0x1bf6
#define VENC_VDAC_DAC3_OFFSET        0x1bf7
#define VENC_VDAC_DAC4_GAINCTRL      0x1bf8
#define VENC_VDAC_DAC4_OFFSET        0x1bf9
#define VENC_VDAC_DAC5_GAINCTRL      0x1bfa
#define VENC_VDAC_DAC5_OFFSET        0x1bfb
#define VENC_VDAC_FIFO_CTRL          0x1bfc
#define ENCL_TCON_INVERT_CTL         0x1bfd
#define ENCP_VIDEO_EN                0x1b80
#define ENCP_VIDEO_SYNC_MODE         0x1b81
#define ENCP_MACV_EN                 0x1b82
#define ENCP_VIDEO_Y_SCL             0x1b83
#define ENCP_VIDEO_PB_SCL            0x1b84
#define ENCP_VIDEO_PR_SCL            0x1b85
#define ENCP_VIDEO_SYNC_SCL          0x1b86
#define ENCP_VIDEO_MACV_SCL          0x1b87
#define ENCP_VIDEO_Y_OFFST           0x1b88
#define ENCP_VIDEO_PB_OFFST          0x1b89
#define ENCP_VIDEO_PR_OFFST          0x1b8a
#define ENCP_VIDEO_SYNC_OFFST        0x1b8b
#define ENCP_VIDEO_MACV_OFFST        0x1b8c
#define ENCP_VIDEO_MODE              0x1b8d
#define ENCP_VIDEO_MODE_ADV          0x1b8e
#define ENCP_DBG_PX_RST              0x1b90
#define ENCP_DBG_LN_RST              0x1b91
#define ENCP_DBG_PX_INT              0x1b92
#define ENCP_DBG_LN_INT              0x1b93
#define ENCP_VIDEO_YFP1_HTIME        0x1b94
#define ENCP_VIDEO_YFP2_HTIME        0x1b95
#define ENCP_VIDEO_YC_DLY            0x1b96
#define ENCP_VIDEO_MAX_PXCNT         0x1b97
#define ENCP_VIDEO_HSPULS_BEGIN      0x1b98
#define ENCP_VIDEO_HSPULS_END        0x1b99
#define ENCP_VIDEO_HSPULS_SWITCH     0x1b9a
#define ENCP_VIDEO_VSPULS_BEGIN      0x1b9b
#define ENCP_VIDEO_VSPULS_END        0x1b9c
#define ENCP_VIDEO_VSPULS_BLINE      0x1b9d
#define ENCP_VIDEO_VSPULS_ELINE      0x1b9e
#define ENCP_VIDEO_EQPULS_BEGIN      0x1b9f
#define ENCP_VIDEO_EQPULS_END        0x1ba0
#define ENCP_VIDEO_EQPULS_BLINE      0x1ba1
#define ENCP_VIDEO_EQPULS_ELINE      0x1ba2
#define ENCP_VIDEO_HAVON_END         0x1ba3
#define ENCP_VIDEO_HAVON_BEGIN       0x1ba4
#define ENCP_VIDEO_VAVON_ELINE       0x1baf
#define ENCP_VIDEO_VAVON_BLINE       0x1ba6
#define ENCP_VIDEO_HSO_BEGIN         0x1ba7
#define ENCP_VIDEO_HSO_END           0x1ba8
#define ENCP_VIDEO_VSO_BEGIN         0x1ba9
#define ENCP_VIDEO_VSO_END           0x1baa
#define ENCP_VIDEO_VSO_BLINE         0x1bab
#define ENCP_VIDEO_VSO_ELINE         0x1bac
#define ENCP_VIDEO_SYNC_WAVE_CURVE   0x1bad
#define ENCP_VIDEO_MAX_LNCNT         0x1bae
#define ENCP_VIDEO_SY_VAL            0x1bb0
#define ENCP_VIDEO_SY2_VAL           0x1bb1
#define ENCP_VIDEO_BLANKY_VAL        0x1bb2
#define ENCP_VIDEO_BLANKPB_VAL       0x1bb3
#define ENCP_VIDEO_BLANKPR_VAL       0x1bb4
#define ENCP_VIDEO_HOFFST            0x1bb5
#define ENCP_VIDEO_VOFFST            0x1bb6
#define ENCP_VIDEO_RGB_CTRL          0x1bb7
#define ENCP_VIDEO_FILT_CTRL         0x1bb8
#define ENCP_VIDEO_OFLD_VPEQ_OFST    0x1bb9
#define ENCP_VIDEO_OFLD_VOAV_OFST    0x1bba
#define ENCP_VIDEO_MATRIX_CB         0x1bbb
#define ENCP_VIDEO_MATRIX_CR         0x1bbc
#define ENCP_VIDEO_RGBIN_CTRL        0x1bbd
#define ENCP_MACV_BLANKY_VAL         0x1bc0
#define ENCP_MACV_MAXY_VAL           0x1bc1
#define ENCP_MACV_1ST_PSSYNC_STRT    0x1bc2
#define ENCP_MACV_PSSYNC_STRT        0x1bc3
#define ENCP_MACV_AGC_STRT           0x1bc4
#define ENCP_MACV_AGC_END            0x1bc5
#define ENCP_MACV_WAVE_END           0x1bc6
#define ENCP_MACV_STRTLINE           0x1bc7
#define ENCP_MACV_ENDLINE            0x1bc8
#define ENCP_MACV_TS_CNT_MAX_L       0x1bc9
#define ENCP_MACV_TS_CNT_MAX_H       0x1bca
#define ENCP_MACV_TIME_DOWN          0x1bcb
#define ENCP_MACV_TIME_LO            0x1bcc
#define ENCP_MACV_TIME_UP            0x1bcd
#define ENCP_MACV_TIME_RST           0x1bce
#define ENCP_VBI_CTRL                0x1bd0
#define ENCP_VBI_SETTING             0x1bd1
#define ENCP_VBI_BEGIN               0x1bd2
#define ENCP_VBI_WIDTH               0x1bd3
#define ENCP_VBI_HVAL                0x1bd4
#define ENCP_VBI_DATA0               0x1bd5
#define ENCP_VBI_DATA1               0x1bd6
#define C656_HS_ST                   0x1be0
#define C656_HS_ED                   0x1be1
#define C656_VS_LNST_E               0x1be2
#define C656_VS_LNST_O               0x1be3
#define C656_VS_LNED_E               0x1be4
#define C656_VS_LNED_O               0x1be5
#define C656_FS_LNST                 0x1be6
#define C656_FS_LNED                 0x1be7
#define ENCI_VIDEO_MODE              0x1b00
#define ENCI_VIDEO_MODE_ADV          0x1b01
#define ENCI_VIDEO_FSC_ADJ           0x1b02
#define ENCI_VIDEO_BRIGHT            0x1b03
#define ENCI_VIDEO_CONT              0x1b04
#define ENCI_VIDEO_SAT               0x1b05
#define ENCI_VIDEO_HUE               0x1b06
#define ENCI_VIDEO_SCH               0x1b07
#define ENCI_SYNC_MODE               0x1b08
#define ENCI_SYNC_CTRL               0x1b09
#define ENCI_SYNC_HSO_BEGIN          0x1b0a
#define ENCI_SYNC_HSO_END            0x1b0b
#define ENCI_SYNC_VSO_EVN            0x1b0c
#define ENCI_SYNC_VSO_ODD            0x1b0d
#define ENCI_SYNC_VSO_EVNLN          0x1b0e
#define ENCI_SYNC_VSO_ODDLN          0x1b0f
#define ENCI_SYNC_HOFFST             0x1b10
#define ENCI_SYNC_VOFFST             0x1b11
#define ENCI_SYNC_ADJ                0x1b12
#define ENCI_RGB_SETTING             0x1b13
#define ENCI_DE_H_BEGIN              0x1b16
#define ENCI_DE_H_END                0x1b17
#define ENCI_DE_V_BEGIN_EVEN         0x1b18
#define ENCI_DE_V_END_EVEN           0x1b19
#define ENCI_DE_V_BEGIN_ODD          0x1b1a
#define ENCI_DE_V_END_ODD            0x1b1b
#define ENCI_VBI_SETTING             0x1b20
#define ENCI_VBI_CCDT_EVN            0x1b21
#define ENCI_VBI_CCDT_ODD            0x1b22
#define ENCI_VBI_CC525_LN            0x1b23
#define ENCI_VBI_CC625_LN            0x1b24
#define ENCI_VBI_WSSDT               0x1b25
#define ENCI_VBI_WSS_LN              0x1b26
#define ENCI_VBI_CGMSDT_L            0x1b27
#define ENCI_VBI_CGMSDT_H            0x1b28
#define ENCI_VBI_CGMS_LN             0x1b29
#define ENCI_VBI_TTX_HTIME           0x1b2a
#define ENCI_VBI_TTX_LN              0x1b2b
#define ENCI_VBI_TTXDT0              0x1b2c
#define ENCI_VBI_TTXDT1              0x1b2d
#define ENCI_VBI_TTXDT2              0x1b2e
#define ENCI_VBI_TTXDT3              0x1b2f
#define ENCI_MACV_N0                 0x1b30
#define ENCI_MACV_N1                 0x1b31
#define ENCI_MACV_N2                 0x1b32
#define ENCI_MACV_N3                 0x1b33
#define ENCI_MACV_N4                 0x1b34
#define ENCI_MACV_N5                 0x1b35
#define ENCI_MACV_N6                 0x1b36
#define ENCI_MACV_N7                 0x1b37
#define ENCI_MACV_N8                 0x1b38
#define ENCI_MACV_N9                 0x1b39
#define ENCI_MACV_N10                0x1b3a
#define ENCI_MACV_N11                0x1b3b
#define ENCI_MACV_N12                0x1b3c
#define ENCI_MACV_N13                0x1b3d
#define ENCI_MACV_N14                0x1b3e
#define ENCI_MACV_N15                0x1b3f
#define ENCI_MACV_N16                0x1b40
#define ENCI_MACV_N17                0x1b41
#define ENCI_MACV_N18                0x1b42
#define ENCI_MACV_N19                0x1b43
#define ENCI_MACV_N20                0x1b44
#define ENCI_MACV_N21                0x1b45
#define ENCI_MACV_N22                0x1b46
#define ENCI_DBG_PX_RST              0x1b48
#define ENCI_DBG_FLDLN_RST           0x1b49
#define ENCI_DBG_PX_INT              0x1b4a
#define ENCI_DBG_FLDLN_INT           0x1b4b
#define ENCI_DBG_MAXPX               0x1b4c
#define ENCI_DBG_MAXLN               0x1b4d
#define ENCI_MACV_MAX_AMP            0x1b50
#define ENCI_MACV_PULSE_LO           0x1b51
#define ENCI_MACV_PULSE_HI           0x1b52
#define ENCI_MACV_BKP_MAX            0x1b53
#define ENCI_CFILT_CTRL              0x1b54
#define ENCI_CFILT7                  0x1b55
#define ENCI_YC_DELAY                0x1b56
#define ENCI_VIDEO_EN                0x1b57
#define ENCI_DVI_HSO_BEGIN           0x1c00
#define ENCI_DVI_HSO_END             0x1c01
#define ENCI_DVI_VSO_BLINE_EVN       0x1c02
#define ENCI_DVI_VSO_BLINE_ODD       0x1c03
#define ENCI_DVI_VSO_ELINE_EVN       0x1c04
#define ENCI_DVI_VSO_ELINE_ODD       0x1c05
#define ENCI_DVI_VSO_BEGIN_EVN       0x1c06
#define ENCI_DVI_VSO_BEGIN_ODD       0x1c07
#define ENCI_DVI_VSO_END_EVN         0x1c08
#define ENCI_DVI_VSO_END_ODD         0x1c09
#define ENCI_CFILT_CTRL2             0x1c0a
#define ENCI_DACSEL_0                0x1c0b
#define ENCI_DACSEL_1                0x1c0c
#define ENCP_DACSEL_0                0x1c0d
#define ENCP_DACSEL_1                0x1c0e
#define ENCP_MAX_LINE_SWITCH_POINT   0x1c0f
#define ENCI_TST_EN                  0x1c10
#define ENCI_TST_MDSEL               0x1c11
#define ENCI_TST_Y                   0x1c12
#define ENCI_TST_CB                  0x1c13
#define ENCI_TST_CR                  0x1c14
#define ENCI_TST_CLRBAR_STRT         0x1c15
#define ENCI_TST_CLRBAR_WIDTH        0x1c16
#define ENCI_TST_VDCNT_STSET         0x1c17
#define ENCI_VFIFO2VD_CTL            0x1c18
#define ENCI_VFIFO2VD_PIXEL_START    0x1c19
#define ENCI_VFIFO2VD_PIXEL_END      0x1c1a
#define ENCI_VFIFO2VD_LINE_TOP_START 0x1c1b
#define ENCI_VFIFO2VD_LINE_TOP_END   0x1c1c
#define ENCI_VFIFO2VD_LINE_BOT_START 0x1c1d
#define ENCI_VFIFO2VD_LINE_BOT_END   0x1c1e
#define ENCI_VFIFO2VD_CTL2           0x1c1f
#define ENCT_VFIFO2VD_CTL            0x1c20
#define ENCT_VFIFO2VD_PIXEL_START    0x1c21
#define ENCT_VFIFO2VD_PIXEL_END      0x1c22
#define ENCT_VFIFO2VD_LINE_TOP_START 0x1c23
#define ENCT_VFIFO2VD_LINE_TOP_END   0x1c24
#define ENCT_VFIFO2VD_LINE_BOT_START 0x1c25
#define ENCT_VFIFO2VD_LINE_BOT_END   0x1c26
#define ENCT_VFIFO2VD_CTL2           0x1c27
#define ENCT_TST_EN                  0x1c28
#define ENCT_TST_MDSEL               0x1c29
#define ENCT_TST_Y                   0x1c2a
#define ENCT_TST_CB                  0x1c2b
#define ENCT_TST_CR                  0x1c2c
#define ENCT_TST_CLRBAR_STRT         0x1c2d
#define ENCT_TST_CLRBAR_WIDTH        0x1c2e
#define ENCT_TST_VDCNT_STSET         0x1c2f
#define ENCP_DVI_HSO_BEGIN           0x1c30
#define ENCP_DVI_HSO_END             0x1c31
#define ENCP_DVI_VSO_BLINE_EVN       0x1c32
#define ENCP_DVI_VSO_BLINE_ODD       0x1c33
#define ENCP_DVI_VSO_ELINE_EVN       0x1c34
#define ENCP_DVI_VSO_ELINE_ODD       0x1c35
#define ENCP_DVI_VSO_BEGIN_EVN       0x1c36
#define ENCP_DVI_VSO_BEGIN_ODD       0x1c37
#define ENCP_DVI_VSO_END_EVN         0x1c38
#define ENCP_DVI_VSO_END_ODD         0x1c39
#define ENCP_DE_H_BEGIN              0x1c3a
#define ENCP_DE_H_END                0x1c3b
#define ENCP_DE_V_BEGIN_EVEN         0x1c3c
#define ENCP_DE_V_END_EVEN           0x1c3d
#define ENCP_DE_V_BEGIN_ODD          0x1c3e
#define ENCP_DE_V_END_ODD            0x1c3f
#define ENCI_SYNC_LINE_LENGTH        0x1c40
#define ENCI_SYNC_PIXEL_EN           0x1c41
#define ENCI_SYNC_TO_LINE_EN         0x1c42
#define ENCI_SYNC_TO_PIXEL           0x1c43
#define ENCP_SYNC_LINE_LENGTH        0x1c44
#define ENCP_SYNC_PIXEL_EN           0x1c45
#define ENCP_SYNC_TO_LINE_EN         0x1c46
#define ENCP_SYNC_TO_PIXEL           0x1c47
#define ENCT_SYNC_LINE_LENGTH        0x1c48
#define ENCT_SYNC_PIXEL_EN           0x1c49
#define ENCT_SYNC_TO_LINE_EN         0x1c4a
#define ENCT_SYNC_TO_PIXEL           0x1c4b
#define ENCL_SYNC_LINE_LENGTH        0x1c4c
#define ENCL_SYNC_PIXEL_EN           0x1c4d
#define ENCL_SYNC_TO_LINE_EN         0x1c4e
#define ENCL_SYNC_TO_PIXEL           0x1c4f
#define ENCP_VFIFO2VD_CTL2           0x1c50
#define VENC_DVI_SETTING_MORE        0x1c51
#define VENC_VDAC_DAC4_FILT_CTRL0    0x1c54
#define VENC_VDAC_DAC4_FILT_CTRL1    0x1c55
#define VENC_VDAC_DAC5_FILT_CTRL0    0x1c56
#define VENC_VDAC_DAC5_FILT_CTRL1    0x1c57
#define VENC_VDAC_DAC0_FILT_CTRL0    0x1c58
#define VENC_VDAC_DAC0_FILT_CTRL1    0x1c59
#define VENC_VDAC_DAC1_FILT_CTRL0    0x1c5a
#define VENC_VDAC_DAC1_FILT_CTRL1    0x1c5b
#define VENC_VDAC_DAC2_FILT_CTRL0    0x1c5c
#define VENC_VDAC_DAC2_FILT_CTRL1    0x1c5d
#define VENC_VDAC_DAC3_FILT_CTRL0    0x1c5e
#define VENC_VDAC_DAC3_FILT_CTRL1    0x1c5f
#define ENCT_VIDEO_EN                0x1c60
#define ENCT_VIDEO_Y_SCL             0x1c61
#define ENCT_VIDEO_PB_SCL            0x1c62
#define ENCT_VIDEO_PR_SCL            0x1c63
#define ENCT_VIDEO_Y_OFFST           0x1c64
#define ENCT_VIDEO_PB_OFFST          0x1c65
#define ENCT_VIDEO_PR_OFFST          0x1c66
#define ENCT_VIDEO_MODE              0x1c67
#define ENCT_VIDEO_MODE_ADV          0x1c68
#define ENCT_DBG_PX_RST              0x1c69
#define ENCT_DBG_LN_RST              0x1c6a
#define ENCT_DBG_PX_INT              0x1c6b
#define ENCT_DBG_LN_INT              0x1c6c
#define ENCT_VIDEO_YFP1_HTIME        0x1c6d
#define ENCT_VIDEO_YFP2_HTIME        0x1c6e
#define ENCT_VIDEO_YC_DLY            0x1c6f
#define ENCT_VIDEO_MAX_PXCNT         0x1c70
#define ENCT_VIDEO_HAVON_END         0x1c71
#define ENCT_VIDEO_HAVON_BEGIN       0x1c72
#define ENCT_VIDEO_VAVON_ELINE       0x1c73
#define ENCT_VIDEO_VAVON_BLINE       0x1c74
#define ENCT_VIDEO_HSO_BEGIN         0x1c75
#define ENCT_VIDEO_HSO_END           0x1c76
#define ENCT_VIDEO_VSO_BEGIN         0x1c77
#define ENCT_VIDEO_VSO_END           0x1c78
#define ENCT_VIDEO_VSO_BLINE         0x1c79
#define ENCT_VIDEO_VSO_ELINE         0x1c7a
#define ENCT_VIDEO_MAX_LNCNT         0x1c7b
#define ENCT_VIDEO_BLANKY_VAL        0x1c7c
#define ENCT_VIDEO_BLANKPB_VAL       0x1c7d
#define ENCT_VIDEO_BLANKPR_VAL       0x1c7e
#define ENCT_VIDEO_HOFFST            0x1c7f
#define ENCT_VIDEO_VOFFST            0x1c80
#define ENCT_VIDEO_RGB_CTRL          0x1c81
#define ENCT_VIDEO_FILT_CTRL         0x1c82
#define ENCT_VIDEO_OFLD_VPEQ_OFST    0x1c83
#define ENCT_VIDEO_OFLD_VOAV_OFST    0x1c84
#define ENCT_VIDEO_MATRIX_CB         0x1c85
#define ENCT_VIDEO_MATRIX_CR         0x1c86
#define ENCT_VIDEO_RGBIN_CTRL        0x1c87
#define ENCT_MAX_LINE_SWITCH_POINT   0x1c88
#define ENCT_DACSEL_0                0x1c89
#define ENCT_DACSEL_1                0x1c8a
#define ENCL_VFIFO2VD_CTL            0x1c90
#define ENCL_VFIFO2VD_PIXEL_START    0x1c91
#define ENCL_VFIFO2VD_PIXEL_END      0x1c92
#define ENCL_VFIFO2VD_LINE_TOP_START 0x1c93
#define ENCL_VFIFO2VD_LINE_TOP_END   0x1c94
#define ENCL_VFIFO2VD_LINE_BOT_START 0x1c95
#define ENCL_VFIFO2VD_LINE_BOT_END   0x1c96
#define ENCL_VFIFO2VD_CTL2           0x1c97
#define ENCL_TST_EN                  0x1c98
#define ENCL_TST_MDSEL               0x1c99
#define ENCL_TST_Y                   0x1c9a
#define ENCL_TST_CB                  0x1c9b
#define ENCL_TST_CR                  0x1c9c
#define ENCL_TST_CLRBAR_STRT         0x1c9d
#define ENCL_TST_CLRBAR_WIDTH        0x1c9e
#define ENCL_TST_VDCNT_STSET         0x1c9f
#define ENCL_VIDEO_EN                0x1ca0
#define ENCL_VIDEO_Y_SCL             0x1ca1
#define ENCL_VIDEO_PB_SCL            0x1ca2
#define ENCL_VIDEO_PR_SCL            0x1ca3
#define ENCL_VIDEO_Y_OFFST           0x1ca4
#define ENCL_VIDEO_PB_OFFST          0x1ca5
#define ENCL_VIDEO_PR_OFFST          0x1ca6
#define ENCL_VIDEO_MODE              0x1ca7
#define ENCL_VIDEO_MODE_ADV          0x1ca8
#define ENCL_DBG_PX_RST              0x1ca9
#define ENCL_DBG_LN_RST              0x1caa
#define ENCL_DBG_PX_INT              0x1cab
#define ENCL_DBG_LN_INT              0x1cac
#define ENCL_VIDEO_YFP1_HTIME        0x1cad
#define ENCL_VIDEO_YFP2_HTIME        0x1cae
#define ENCL_VIDEO_YC_DLY            0x1caf
#define ENCL_VIDEO_MAX_PXCNT         0x1cb0
#define ENCL_VIDEO_HAVON_END         0x1cb1
#define ENCL_VIDEO_HAVON_BEGIN       0x1cb2
#define ENCL_VIDEO_VAVON_ELINE       0x1cb3
#define ENCL_VIDEO_VAVON_BLINE       0x1cb4
#define ENCL_VIDEO_HSO_BEGIN         0x1cb5
#define ENCL_VIDEO_HSO_END           0x1cb6
#define ENCL_VIDEO_VSO_BEGIN         0x1cb7
#define ENCL_VIDEO_VSO_END           0x1cb8
#define ENCL_VIDEO_VSO_BLINE         0x1cb9
#define ENCL_VIDEO_VSO_ELINE         0x1cba
#define ENCL_VIDEO_MAX_LNCNT         0x1cbb
#define ENCL_VIDEO_BLANKY_VAL        0x1cbc
#define ENCL_VIDEO_BLANKPB_VAL       0x1cbd
#define ENCL_VIDEO_BLANKPR_VAL       0x1cbe
#define ENCL_VIDEO_HOFFST            0x1cbf
#define ENCL_VIDEO_VOFFST            0x1cc0
#define ENCL_VIDEO_RGB_CTRL          0x1cc1
#define ENCL_VIDEO_FILT_CTRL         0x1cc2
#define ENCL_VIDEO_OFLD_VPEQ_OFST    0x1cc3
#define ENCL_VIDEO_OFLD_VOAV_OFST    0x1cc4
#define ENCL_VIDEO_MATRIX_CB         0x1cc5
#define ENCL_VIDEO_MATRIX_CR         0x1cc6
#define ENCL_VIDEO_RGBIN_CTRL        0x1cc7
#define ENCL_MAX_LINE_SWITCH_POINT   0x1cc8
#define ENCL_DACSEL_0                0x1cc9
#define ENCL_DACSEL_1                0x1cca
#define RDMA_AHB_START_ADDR_MAN      0x1100
#define RDMA_AHB_END_ADDR_MAN        0x1101
#define RDMA_AHB_START_ADDR_1        0x1102
#define RDMA_AHB_END_ADDR_1          0x1103
#define RDMA_AHB_START_ADDR_2        0x1104
#define RDMA_AHB_END_ADDR_2          0x1105
#define RDMA_AHB_START_ADDR_3        0x1106
#define RDMA_AHB_END_ADDR_3          0x1107
#define RDMA_AHB_START_ADDR_4        0x1108
#define RDMA_AHB_END_ADDR_4          0x1109
#define RDMA_AHB_START_ADDR_5        0x110a
#define RDMA_AHB_END_ADDR_5          0x110b
#define RDMA_AHB_START_ADDR_6        0x110c
#define RDMA_AHB_END_ADDR_6          0x110d
#define RDMA_AHB_START_ADDR_7        0x110e
#define RDMA_AHB_END_ADDR_7          0x110f
#define RDMA_ACCESS_AUTO             0x1110
#define RDMA_ACCESS_AUTO2            0x1111
#define RDMA_ACCESS_AUTO3            0x1112
#define RDMA_ACCESS_MAN              0x1113
#define RDMA_CTRL                    0x1114
#define RDMA_STATUS                  0x1115
#define RDMA_STATUS2                 0x1116
#define RDMA_STATUS3                 0x1117
#define RDMA_AHB_START_ADDR_MAN_MSB                0x1130
#define RDMA_AHB_END_ADDR_MAN_MSB                  0x1131
#define RDMA_AHB_START_ADDR_1_MSB                  0x1132
#define RDMA_AHB_END_ADDR_1_MSB                    0x1133
#define RDMA_AHB_START_ADDR_2_MSB                  0x1134
#define RDMA_AHB_END_ADDR_2_MSB                    0x1135
#define RDMA_AHB_START_ADDR_3_MSB                  0x1136
#define RDMA_AHB_END_ADDR_3_MSB                    0x1137
#define RDMA_AHB_START_ADDR_4_MSB                  0x1138
#define RDMA_AHB_END_ADDR_4_MSB                    0x1139
#define RDMA_AHB_START_ADDR_5_MSB                  0x113a
#define RDMA_AHB_END_ADDR_5_MSB                    0x113b
#define RDMA_AHB_START_ADDR_6_MSB                  0x113c
#define RDMA_AHB_END_ADDR_6_MSB                    0x113d
#define RDMA_AHB_START_ADDR_7_MSB                  0x113e
#define RDMA_AHB_END_ADDR_7_MSB                    0x113f

#define L_GAMMA_CNTL_PORT            0x1400
#define L_GAMMA_DATA_PORT            0x1401
#define L_GAMMA_ADDR_PORT            0x1402
#define L_GAMMA_VCOM_HSWITCH_ADDR    0x1403
#define L_RGB_BASE_ADDR              0x1405
#define L_RGB_COEFF_ADDR             0x1406
#define L_POL_CNTL_ADDR              0x1407
#define L_DITH_CNTL_ADDR             0x1408
#define L_GAMMA_PROBE_CTRL           0x1409
#define L_GAMMA_PROBE_COLOR_L        0x140a
#define L_GAMMA_PROBE_COLOR_H        0x140b
#define L_GAMMA_PROBE_HL_COLOR       0x140c
#define L_GAMMA_PROBE_POS_X          0x140d
#define L_GAMMA_PROBE_POS_Y          0x140e
#define L_STH1_HS_ADDR               0x1410
#define L_STH1_HE_ADDR               0x1411
#define L_STH1_VS_ADDR               0x1412
#define L_STH1_VE_ADDR               0x1413
#define L_STH2_HS_ADDR               0x1414
#define L_STH2_HE_ADDR               0x1415
#define L_STH2_VS_ADDR               0x1416
#define L_STH2_VE_ADDR               0x1417
#define L_OEH_HS_ADDR                0x1418
#define L_OEH_HE_ADDR                0x1419
#define L_OEH_VS_ADDR                0x141a
#define L_OEH_VE_ADDR                0x141b
#define L_VCOM_HSWITCH_ADDR          0x141c
#define L_VCOM_VS_ADDR               0x141d
#define L_VCOM_VE_ADDR               0x141e
#define L_CPV1_HS_ADDR               0x141f
#define L_CPV1_HE_ADDR               0x1420
#define L_CPV1_VS_ADDR               0x1421
#define L_CPV1_VE_ADDR               0x1422
#define L_CPV2_HS_ADDR               0x1423
#define L_CPV2_HE_ADDR               0x1424
#define L_CPV2_VS_ADDR               0x1425
#define L_CPV2_VE_ADDR               0x1426
#define L_STV1_HS_ADDR               0x1427
#define L_STV1_HE_ADDR               0x1428
#define L_STV1_VS_ADDR               0x1429
#define L_STV1_VE_ADDR               0x142a
#define L_STV2_HS_ADDR               0x142b
#define L_STV2_HE_ADDR               0x142c
#define L_STV2_VS_ADDR               0x142d
#define L_STV2_VE_ADDR               0x142e
#define L_OEV1_HS_ADDR               0x142f
#define L_OEV1_HE_ADDR               0x1430
#define L_OEV1_VS_ADDR               0x1431
#define L_OEV1_VE_ADDR               0x1432
#define L_OEV2_HS_ADDR               0x1433
#define L_OEV2_HE_ADDR               0x1434
#define L_OEV2_VS_ADDR               0x1435
#define L_OEV2_VE_ADDR               0x1436
#define L_OEV3_HS_ADDR               0x1437
#define L_OEV3_HE_ADDR               0x1438
#define L_OEV3_VS_ADDR               0x1439
#define L_OEV3_VE_ADDR               0x143a
#define L_LCD_PWR_ADDR               0x143b
#define L_LCD_PWM0_LO_ADDR           0x143c
#define L_LCD_PWM0_HI_ADDR           0x143d
#define L_LCD_PWM1_LO_ADDR           0x143e
#define L_LCD_PWM1_HI_ADDR           0x143f
#define L_INV_CNT_ADDR               0x1440
#define L_TCON_MISC_SEL_ADDR         0x1441
#define L_DUAL_PORT_CNTL_ADDR        0x1442
#define MLVDS_CLK_CTL1_HI            0x1443
#define MLVDS_CLK_CTL1_LO            0x1444
#define L_TCON_DOUBLE_CTL            0x1449
#define L_TCON_PATTERN_HI            0x144a
#define L_TCON_PATTERN_LO            0x144b
#define LDIM_BL_ADDR_PORT            0x144e
#define LDIM_BL_DATA_PORT            0x144f
#define L_DE_HS_ADDR                 0x1451
#define L_DE_HE_ADDR                 0x1452
#define L_DE_VS_ADDR                 0x1453
#define L_DE_VE_ADDR                 0x1454
#define L_HSYNC_HS_ADDR              0x1455
#define L_HSYNC_HE_ADDR              0x1456
#define L_HSYNC_VS_ADDR              0x1457
#define L_HSYNC_VE_ADDR              0x1458
#define L_VSYNC_HS_ADDR              0x1459
#define L_VSYNC_HE_ADDR              0x145a
#define L_VSYNC_VS_ADDR              0x145b
#define L_VSYNC_VE_ADDR              0x145c
#define L_LCD_MCU_CTL                0x145d
#define DUAL_MLVDS_CTL               0x1460
#define DUAL_MLVDS_LINE_START        0x1461
#define DUAL_MLVDS_LINE_END          0x1462
#define DUAL_MLVDS_PIXEL_W_START_L   0x1463
#define DUAL_MLVDS_PIXEL_W_END_L     0x1464
#define DUAL_MLVDS_PIXEL_W_START_R   0x1465
#define DUAL_MLVDS_PIXEL_W_END_R     0x1466
#define DUAL_MLVDS_PIXEL_R_START_L   0x1467
#define DUAL_MLVDS_PIXEL_R_CNT_L     0x1468
#define DUAL_MLVDS_PIXEL_R_START_R   0x1469
#define DUAL_MLVDS_PIXEL_R_CNT_R     0x146a
#define V_INVERSION_PIXEL            0x1470
#define V_INVERSION_LINE             0x1471
#define V_INVERSION_CONTROL          0x1472
#define MLVDS2_CONTROL               0x1474
#define MLVDS2_CONFIG_HI             0x1475
#define MLVDS2_CONFIG_LO             0x1476
#define MLVDS2_DUAL_GATE_WR_START    0x1477
#define MLVDS2_DUAL_GATE_WR_END      0x1478
#define MLVDS2_DUAL_GATE_RD_START    0x1479
#define MLVDS2_DUAL_GATE_RD_END      0x147a
#define MLVDS2_SECOND_RESET_CTL      0x147b
#define MLVDS2_DUAL_GATE_CTL_HI      0x147c
#define MLVDS2_DUAL_GATE_CTL_LO      0x147d
#define MLVDS2_RESET_CONFIG_HI       0x147e
#define MLVDS2_RESET_CONFIG_LO       0x147f
#define GAMMA_CNTL_PORT              0x1480
#define GAMMA_DATA_PORT              0x1481
#define GAMMA_ADDR_PORT              0x1482
#define GAMMA_VCOM_HSWITCH_ADDR      0x1483
#define RGB_BASE_ADDR                0x1485
#define RGB_COEFF_ADDR               0x1486
#define POL_CNTL_ADDR                0x1487
#define DITH_CNTL_ADDR               0x1488
#define GAMMA_PROBE_CTRL             0x1489
#define GAMMA_PROBE_COLOR_L          0x148a
#define GAMMA_PROBE_COLOR_H          0x148b
#define GAMMA_PROBE_HL_COLOR         0x148c
#define GAMMA_PROBE_POS_X            0x148d
#define GAMMA_PROBE_POS_Y            0x148e
#define STH1_HS_ADDR                 0x1490
#define STH1_HE_ADDR                 0x1491
#define STH1_VS_ADDR                 0x1492
#define STH1_VE_ADDR                 0x1493
#define STH2_HS_ADDR                 0x1494
#define STH2_HE_ADDR                 0x1495
#define STH2_VS_ADDR                 0x1496
#define STH2_VE_ADDR                 0x1497
#define OEH_HS_ADDR                  0x1498
#define OEH_HE_ADDR                  0x1499
#define OEH_VS_ADDR                  0x149a
#define OEH_VE_ADDR                  0x149b
#define VCOM_HSWITCH_ADDR            0x149c
#define VCOM_VS_ADDR                 0x149d
#define VCOM_VE_ADDR                 0x149e
#define CPV1_HS_ADDR                 0x149f
#define CPV1_HE_ADDR                 0x14a0
#define CPV1_VS_ADDR                 0x14a1
#define CPV1_VE_ADDR                 0x14a2
#define CPV2_HS_ADDR                 0x14a3
#define CPV2_HE_ADDR                 0x14a4
#define CPV2_VS_ADDR                 0x14a5
#define CPV2_VE_ADDR                 0x14a6
#define STV1_HS_ADDR                 0x14a7
#define STV1_HE_ADDR                 0x14a8
#define STV1_VS_ADDR                 0x14a9
#define STV1_VE_ADDR                 0x14aa
#define STV2_HS_ADDR                 0x14ab
#define STV2_HE_ADDR                 0x14ac
#define STV2_VS_ADDR                 0x14ad
#define STV2_VE_ADDR                 0x14ae
#define OEV1_HS_ADDR                 0x14af
#define OEV1_HE_ADDR                 0x14b0
#define OEV1_VS_ADDR                 0x14b1
#define OEV1_VE_ADDR                 0x14b2
#define OEV2_HS_ADDR                 0x14b3
#define OEV2_HE_ADDR                 0x14b4
#define OEV2_VS_ADDR                 0x14b5
#define OEV2_VE_ADDR                 0x14b6
#define OEV3_HS_ADDR                 0x14b7
#define OEV3_HE_ADDR                 0x14b8
#define OEV3_VS_ADDR                 0x14b9
#define OEV3_VE_ADDR                 0x14ba
#define LCD_PWR_ADDR                 0x14bb
#define LCD_PWM0_LO_ADDR             0x14bc
#define LCD_PWM0_HI_ADDR             0x14bd
#define LCD_PWM1_LO_ADDR             0x14be
#define LCD_PWM1_HI_ADDR             0x14bf
#define INV_CNT_ADDR                 0x14c0
#define TCON_MISC_SEL_ADDR           0x14c1
#define DUAL_PORT_CNTL_ADDR          0x14c2
#define MLVDS_CONTROL                0x14c3
#define MLVDS_RESET_PATTERN_HI       0x14c4
#define MLVDS_RESET_PATTERN_LO       0x14c5
#define MLVDS_RESET_PATTERN_EXT      0x14c6
#define MLVDS_CONFIG_HI              0x14c7
#define MLVDS_CONFIG_LO              0x14c8
#define TCON_DOUBLE_CTL              0x14c9
#define TCON_PATTERN_HI              0x14ca
#define TCON_PATTERN_LO              0x14cb
#define TCON_CONTROL_HI              0x14cc
#define TCON_CONTROL_LO              0x14cd
#define LVDS_BLANK_DATA_HI           0x14ce
#define LVDS_BLANK_DATA_LO           0x14cf
#define LVDS_PACK_CNTL_ADDR          0x14d0
#define DE_HS_ADDR                   0x14d1
#define DE_HE_ADDR                   0x14d2
#define DE_VS_ADDR                   0x14d3
#define DE_VE_ADDR                   0x14d4
#define HSYNC_HS_ADDR                0x14d5
#define HSYNC_HE_ADDR                0x14d6
#define HSYNC_VS_ADDR                0x14d7
#define HSYNC_VE_ADDR                0x14d8
#define VSYNC_HS_ADDR                0x14d9
#define VSYNC_HE_ADDR                0x14da
#define VSYNC_VS_ADDR                0x14db
#define VSYNC_VE_ADDR                0x14dc
#define LCD_MCU_CTL                  0x14dd
#define LCD_MCU_DATA_0               0x14de
#define LCD_MCU_DATA_1               0x14df
#define LVDS_GEN_CNTL                0x14e0
#define LVDS_PHY_CNTL0               0x14e1
#define LVDS_PHY_CNTL1               0x14e2
#define LVDS_PHY_CNTL2               0x14e3
#define LVDS_PHY_CNTL3               0x14e4
#define LVDS_PHY_CNTL4               0x14e5
#define LVDS_PHY_CNTL5               0x14e6
#define LVDS_SRG_TEST                0x14e8
#define LVDS_BIST_MUX0               0x14e9
#define LVDS_BIST_MUX1               0x14ea
#define LVDS_BIST_FIXED0             0x14eb
#define LVDS_BIST_FIXED1             0x14ec
#define LVDS_BIST_CNTL0              0x14ed
#define LVDS_CLKB_CLKA               0x14ee
#define LVDS_PHY_CLK_CNTL            0x14ef
#define LVDS_SER_EN                  0x14f0
#define LVDS_PHY_CNTL6               0x14f1
#define LVDS_PHY_CNTL7               0x14f2
#define LVDS_PHY_CNTL8               0x14f3
#define MLVDS_CLK_CTL0_HI            0x14f4
#define MLVDS_CLK_CTL0_LO            0x14f5
#define MLVDS_DUAL_GATE_WR_START     0x14f6
#define MLVDS_DUAL_GATE_WR_END       0x14f7
#define MLVDS_DUAL_GATE_RD_START     0x14f8
#define MLVDS_DUAL_GATE_RD_END       0x14f9
#define MLVDS_SECOND_RESET_CTL       0x14fa
#define MLVDS_DUAL_GATE_CTL_HI       0x14fb
#define MLVDS_DUAL_GATE_CTL_LO       0x14fc
#define MLVDS_RESET_CONFIG_HI        0x14fd
#define MLVDS_RESET_CONFIG_LO        0x14fe
#define VPU_OSD1_MMC_CTRL            0x2701
#define VPU_OSD2_MMC_CTRL            0x2702
#define VPU_VD1_MMC_CTRL             0x2703
#define VPU_VD2_MMC_CTRL             0x2704
#define VPU_DI_IF1_MMC_CTRL          0x2705
#define VPU_DI_MEM_MMC_CTRL          0x2706
#define VPU_DI_INP_MMC_CTRL          0x2707
#define VPU_DI_MTNRD_MMC_CTRL        0x2708
#define VPU_DI_CHAN2_MMC_CTRL        0x2709
#define VPU_DI_MTNWR_MMC_CTRL        0x270a
#define VPU_DI_NRWR_MMC_CTRL         0x270b
#define VPU_DI_DIWR_MMC_CTRL         0x270c
#define VPU_VDIN0_MMC_CTRL           0x270d
#define VPU_VDIN1_MMC_CTRL           0x270e
#define VPU_BT656_MMC_CTRL           0x270f
#define VPU_TVD3D_MMC_CTRL           0x2710
#define VPU_TVDVBI_MMC_CTRL          0x2711
#define VPU_TVDVBI_VSLATCH_ADDR      0x2712
#define VPU_TVDVBI_WRRSP_ADDR        0x2713
#define VPU_VDIN_PRE_ARB_CTRL        0x2714
#define VPU_VDISP_PRE_ARB_CTRL       0x2715
#define VPU_VPUARB2_PRE_ARB_CTRL     0x2716
#define VPU_OSD3_MMC_CTRL            0x2717
#define VPU_OSD4_MMC_CTRL            0x2718
#define VPU_VD3_MMC_CTRL             0x2719
#define VPU_VIU_VENC_MUX_CTRL        0x271a
#define VPU_HDMI_SETTING             0x271b
#define ENCI_INFO_READ               0x271c
#define ENCP_INFO_READ               0x271d
#define ENCT_INFO_READ               0x271e
#define ENCL_INFO_READ               0x271f
#define VPU_SW_RESET                 0x2720
#define VPU_D2D3_MMC_CTRL            0x2721
#define VPU_CONT_MMC_CTRL            0x2722
#define VPU_CLK_GATE                 0x2723
#define VPU_RDMA_MMC_CTRL            0x2724
#define VPU_MEM_PD_REG0              0x2725
#define VPU_MEM_PD_REG1              0x2726
#define VPU_HDMI_DATA_OVR            0x2727
#define VPU_PROT1_MMC_CTRL           0x2728
#define VPU_PROT2_MMC_CTRL           0x2729
#define VPU_PROT3_MMC_CTRL           0x272a
#define VPU_ARB4_V1_MMC_CTRL         0x272b
#define VPU_ARB4_V2_MMC_CTRL         0x272c
#define VPU_VPU_PWM_V0               0x2730
#define VPU_VPU_PWM_V1               0x2731
#define VPU_VPU_PWM_V2               0x2732
#define VPU_VPU_PWM_V3               0x2733
#define VPU_VPU_PWM_H0               0x2734
#define VPU_VPU_PWM_H1               0x2735
#define VPU_VPU_PWM_H2               0x2736
#define VPU_VPU_PWM_H3               0x2737
#define VPU_MISC_CTRL                0x2740
#define VPU_ISP_GCLK_CTRL0           0x2741
#define VPU_ISP_GCLK_CTRL1           0x2742
#define VPU_VDIN_ASYNC_HOLD_CTRL     0x2743
#define VPU_VDISP_ASYNC_HOLD_CTRL    0x2744
#define VPU_VPUARB2_ASYNC_HOLD_CTRL  0x2745

#define VPU_PROT1_CLK_GATE                  0x2750
#define VPU_PROT1_GEN_CNTL                  0x2751
#define VPU_PROT1_X_START_END               0x2752
#define VPU_PROT1_Y_START_END               0x2753
#define VPU_PROT1_Y_LEN_STEP                0x2754
#define VPU_PROT1_RPT_LOOP                  0x2755
#define VPU_PROT1_RPT_PAT                   0x2756
#define VPU_PROT1_DDR                       0x2757
#define VPU_PROT1_RBUF_ROOM                 0x2758
#define VPU_PROT1_STAT_0                    0x2759
#define VPU_PROT1_STAT_1                    0x275a
#define VPU_PROT1_STAT_2                    0x275b
#define VPU_PROT1_REQ_ONOFF                 0x275c
#define VPU_PROT2_CLK_GATE                  0x2760
#define VPU_PROT2_GEN_CNTL                  0x2761
#define VPU_PROT2_X_START_END               0x2762
#define VPU_PROT2_Y_START_END               0x2763
#define VPU_PROT2_Y_LEN_STEP                0x2764
#define VPU_PROT2_RPT_LOOP                  0x2765
#define VPU_PROT2_RPT_PAT                   0x2766
#define VPU_PROT2_DDR                       0x2767
#define VPU_PROT2_RBUF_ROOM                 0x2768
#define VPU_PROT2_STAT_0                    0x2769
#define VPU_PROT2_STAT_1                    0x276a
#define VPU_PROT2_STAT_2                    0x276b
#define VPU_PROT2_REQ_ONOFF                 0x276c
#define VPU_PROT3_CLK_GATE                  0x2770
#define VPU_PROT3_GEN_CNTL                  0x2771
#define VPU_PROT3_X_START_END               0x2772
#define VPU_PROT3_Y_START_END               0x2773
#define VPU_PROT3_Y_LEN_STEP                0x2774
#define VPU_PROT3_RPT_LOOP                  0x2775
#define VPU_PROT3_RPT_PAT                   0x2776
#define VPU_PROT3_DDR                       0x2777
#define VPU_PROT3_RBUF_ROOM                 0x2778
#define VPU_PROT3_STAT_0                    0x2779
#define VPU_PROT3_STAT_1                    0x277a
#define VPU_PROT3_STAT_2                    0x277b
#define VPU_PROT3_REQ_ONOFF                 0x277c
#define VPU_RDARB_MODE_L1C2                 0x2799
/* osd super scale */
#define OSDSR_HV_SIZEIN                     0x3130
#define OSDSR_CTRL_MODE                     0x3131
#define OSDSR_ABIC_HCOEF                    0x3132
#define OSDSR_YBIC_HCOEF                    0x3133
#define OSDSR_CBIC_HCOEF                    0x3134
#define OSDSR_ABIC_VCOEF                    0x3135
#define OSDSR_YBIC_VCOEF                    0x3136
#define OSDSR_CBIC_VCOEF                    0x3137
#define OSDSR_VAR_PARA                      0x3138
#define OSDSR_CONST_PARA                    0x3139
#define OSDSR_RKE_EXTWIN                    0x313a
#define OSDSR_UK_GRAD2DDIAG_TH_RATE         0x313b
#define OSDSR_UK_GRAD2DDIAG_LIMIT           0x313c
#define OSDSR_UK_GRAD2DADJA_TH_RATE         0x313d
#define OSDSR_UK_GRAD2DADJA_LIMIT           0x313e
#define OSDSR_UK_BST_GAIN                   0x313f

#define OSD_DB_FLT_CTRL                     0x3140
#define OSD_DB_FLT_CTRL1                    0x3141
#define OSD_DB_FLT_LUMA_THRD                0x3142
#define OSD_DB_FLT_CHRM_THRD                0x3143
#define OSD_DB_FLT_RANDLUT                  0x3144
#define OSD_DB_FLT_PXI_THRD                 0x3145
#define OSD_DB_FLT_SEED_Y                   0x3146
#define OSD_DB_FLT_SEED_U                   0x3147
#define OSD_DB_FLT_SEED_V                   0x3148
#define OSD_DB_FLT_SEED3                    0x3149
#define OSD_DB_FLT_SEED4                    0x314a
#define OSD_DB_FLT_SEED5                    0x314b

/* osd afbcd on gxtvbb */
#define OSD1_AFBCD_ENABLE                   0x31a0
#define OSD1_AFBCD_MODE                     0x31a1
#define OSD1_AFBCD_SIZE_IN                  0x31a2
#define OSD1_AFBCD_HDR_PTR                  0x31a3
#define OSD1_AFBCD_FRAME_PTR                0x31a4
#define OSD1_AFBCD_CHROMA_PTR               0x31a5
#define OSD1_AFBCD_CONV_CTRL                0x31a6
#define OSD1_AFBCD_STATUS                   0x31a8
#define OSD1_AFBCD_PIXEL_HSCOPE             0x31a9
#define OSD1_AFBCD_PIXEL_VSCOPE             0x31aa
#define VIU_MISC_CTRL1                      0x1a07

/* add for gxm and 962e dv core2 */
#define AMDV_CORE2A_SWAP_CTRL1		          0x3434
#define AMDV_CORE2A_SWAP_CTRL2		          0x3435

#define S5_AMDV_CORE2A_SWAP_CTRL1		      0x0b34
#define S5_AMDV_CORE2A_SWAP_CTRL2		      0x0b35

/* osd afbc on g12a */
#define VPU_MAFBC_BLOCK_ID                  0x3a00
#define VPU_MAFBC_IRQ_RAW_STATUS            0x3a01
#define VPU_MAFBC_IRQ_CLEAR                 0x3a02
#define VPU_MAFBC_IRQ_MASK                  0x3a03
#define VPU_MAFBC_IRQ_STATUS                0x3a04
#define VPU_MAFBC_COMMAND                   0x3a05
#define VPU_MAFBC_STATUS                    0x3a06
#define VPU_MAFBC_SURFACE_CFG               0x3a07

/* osd afbc on g12a */
#define VPU_MAFBC_HEADER_BUF_ADDR_LOW_S0    0x3a10
#define VPU_MAFBC_HEADER_BUF_ADDR_HIGH_S0   0x3a11
#define VPU_MAFBC_FORMAT_SPECIFIER_S0       0x3a12
#define VPU_MAFBC_BUFFER_WIDTH_S0           0x3a13
#define VPU_MAFBC_BUFFER_HEIGHT_S0          0x3a14
#define VPU_MAFBC_BOUNDING_BOX_X_START_S0   0x3a15
#define VPU_MAFBC_BOUNDING_BOX_X_END_S0     0x3a16
#define VPU_MAFBC_BOUNDING_BOX_Y_START_S0   0x3a17
#define VPU_MAFBC_BOUNDING_BOX_Y_END_S0     0x3a18
#define VPU_MAFBC_OUTPUT_BUF_ADDR_LOW_S0    0x3a19
#define VPU_MAFBC_OUTPUT_BUF_ADDR_HIGH_S0   0x3a1a
#define VPU_MAFBC_OUTPUT_BUF_STRIDE_S0      0x3a1b
#define VPU_MAFBC_PREFETCH_CFG_S0           0x3a1c

#define VPU_MAFBC_HEADER_BUF_ADDR_LOW_S1    0x3a30
#define VPU_MAFBC_HEADER_BUF_ADDR_HIGH_S1   0x3a31
#define VPU_MAFBC_FORMAT_SPECIFIER_S1       0x3a32
#define VPU_MAFBC_BUFFER_WIDTH_S1           0x3a33
#define VPU_MAFBC_BUFFER_HEIGHT_S1          0x3a34
#define VPU_MAFBC_BOUNDING_BOX_X_START_S1   0x3a35
#define VPU_MAFBC_BOUNDING_BOX_X_END_S1     0x3a36
#define VPU_MAFBC_BOUNDING_BOX_Y_START_S1   0x3a37
#define VPU_MAFBC_BOUNDING_BOX_Y_END_S1     0x3a38
#define VPU_MAFBC_OUTPUT_BUF_ADDR_LOW_S1    0x3a39
#define VPU_MAFBC_OUTPUT_BUF_ADDR_HIGH_S1   0x3a3a
#define VPU_MAFBC_OUTPUT_BUF_STRIDE_S1      0x3a3b
#define VPU_MAFBC_PREFETCH_CFG_S1           0x3a3c

#define VPU_MAFBC_HEADER_BUF_ADDR_LOW_S2    0x3a50
#define VPU_MAFBC_HEADER_BUF_ADDR_HIGH_S2   0x3a51
#define VPU_MAFBC_FORMAT_SPECIFIER_S2       0x3a52
#define VPU_MAFBC_BUFFER_WIDTH_S2           0x3a53
#define VPU_MAFBC_BUFFER_HEIGHT_S2          0x3a54
#define VPU_MAFBC_BOUNDING_BOX_X_START_S2   0x3a55
#define VPU_MAFBC_BOUNDING_BOX_X_END_S2     0x3a56
#define VPU_MAFBC_BOUNDING_BOX_Y_START_S2   0x3a57
#define VPU_MAFBC_BOUNDING_BOX_Y_END_S2     0x3a58
#define VPU_MAFBC_OUTPUT_BUF_ADDR_LOW_S2    0x3a59
#define VPU_MAFBC_OUTPUT_BUF_ADDR_HIGH_S2   0x3a5a
#define VPU_MAFBC_OUTPUT_BUF_STRIDE_S2      0x3a5b
#define VPU_MAFBC_PREFETCH_CFG_S2           0x3a5c

#define VPU_MAFBC_HEADER_BUF_ADDR_LOW_S3    0x3a70
#define VPU_MAFBC_HEADER_BUF_ADDR_HIGH_S3   0x3a71
#define VPU_MAFBC_FORMAT_SPECIFIER_S3       0x3a72
#define VPU_MAFBC_BUFFER_WIDTH_S3           0x3a73
#define VPU_MAFBC_BUFFER_HEIGHT_S3          0x3a74
#define VPU_MAFBC_BOUNDING_BOX_X_START_S3   0x3a75
#define VPU_MAFBC_BOUNDING_BOX_X_END_S3     0x3a76
#define VPU_MAFBC_BOUNDING_BOX_Y_START_S3   0x3a77
#define VPU_MAFBC_BOUNDING_BOX_Y_END_S3     0x3a78
#define VPU_MAFBC_OUTPUT_BUF_ADDR_LOW_S3    0x3a79
#define VPU_MAFBC_OUTPUT_BUF_ADDR_HIGH_S3   0x3a7a
#define VPU_MAFBC_OUTPUT_BUF_STRIDE_S3      0x3a7b
#define VPU_MAFBC_PREFETCH_CFG_S3           0x3a7c

#define VPU_MAFBC1_BLOCK_ID                        0x3b00
#define VPU_MAFBC1_IRQ_RAW_STATUS                  0x3b01
#define VPU_MAFBC1_IRQ_CLEAR                       0x3b02
#define VPU_MAFBC1_IRQ_MASK                        0x3b03
#define VPU_MAFBC1_IRQ_STATUS                      0x3b04
#define VPU_MAFBC1_COMMAND                         0x3b05
#define VPU_MAFBC1_STATUS                          0x3b06
#define VPU_MAFBC1_SURFACE_CFG                     0x3b07
#define VPU_MAFBC1_AXI_CFG                         0x3b08
#define VPU_MAFBC1_HEADER_BUF_ADDR_LOW_S0          0x3b10
#define VPU_MAFBC1_HEADER_BUF_ADDR_HIGH_S0         0x3b11
#define VPU_MAFBC1_FORMAT_SPECIFIER_S0             0x3b12
#define VPU_MAFBC1_BUFFER_WIDTH_S0                 0x3b13
#define VPU_MAFBC1_BUFFER_HEIGHT_S0                0x3b14
#define VPU_MAFBC1_BOUNDING_BOX_X_START_S0         0x3b15
#define VPU_MAFBC1_BOUNDING_BOX_X_END_S0           0x3b16
#define VPU_MAFBC1_BOUNDING_BOX_Y_START_S0         0x3b17
#define VPU_MAFBC1_BOUNDING_BOX_Y_END_S0           0x3b18
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_LOW_S0          0x3b19
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_HIGH_S0         0x3b1a
#define VPU_MAFBC1_OUTPUT_BUF_STRIDE_S0            0x3b1b
#define VPU_MAFBC1_PREFETCH_CFG_S0                 0x3b1c
#define VPU_MAFBC1_PAYLOAD_MIN_LOW_S0              0x3b1d
#define VPU_MAFBC1_PAYLOAD_MIN_HIGH_S0             0x3b1e
#define VPU_MAFBC1_PAYLOAD_MAX_LOW_S0              0x3b1f
#define VPU_MAFBC1_PAYLOAD_MAX_HIGH_S0             0x3b20
#define VPU_MAFBC1_HEADER_BUF_ADDR_LOW_S1          0x3b30
#define VPU_MAFBC1_HEADER_BUF_ADDR_HIGH_S1         0x3b31
#define VPU_MAFBC1_FORMAT_SPECIFIER_S1             0x3b32
#define VPU_MAFBC1_BUFFER_WIDTH_S1                 0x3b33
#define VPU_MAFBC1_BUFFER_HEIGHT_S1                0x3b34
#define VPU_MAFBC1_BOUNDING_BOX_X_START_S1         0x3b35
#define VPU_MAFBC1_BOUNDING_BOX_X_END_S1           0x3b36
#define VPU_MAFBC1_BOUNDING_BOX_Y_START_S1         0x3b37
#define VPU_MAFBC1_BOUNDING_BOX_Y_END_S1           0x3b38
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_LOW_S1          0x3b39
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_HIGH_S1         0x3b3a
#define VPU_MAFBC1_OUTPUT_BUF_STRIDE_S1            0x3b3b
#define VPU_MAFBC1_PREFETCH_CFG_S1                 0x3b3c
#define VPU_MAFBC1_PAYLOAD_MIN_LOW_S1              0x3b3d
#define VPU_MAFBC1_PAYLOAD_MIN_HIGH_S1             0x3b3e
#define VPU_MAFBC1_PAYLOAD_MAX_LOW_S1              0x3b3f
#define VPU_MAFBC1_PAYLOAD_MAX_HIGH_S1             0x3b40
#define VPU_MAFBC1_HEADER_BUF_ADDR_LOW_S2          0x3b50
#define VPU_MAFBC1_HEADER_BUF_ADDR_HIGH_S2         0x3b51
#define VPU_MAFBC1_FORMAT_SPECIFIER_S2             0x3b52
#define VPU_MAFBC1_BUFFER_WIDTH_S2                 0x3b53
#define VPU_MAFBC1_BUFFER_HEIGHT_S2                0x3b54
#define VPU_MAFBC1_BOUNDING_BOX_X_START_S2         0x3b55
#define VPU_MAFBC1_BOUNDING_BOX_X_END_S2           0x3b56
#define VPU_MAFBC1_BOUNDING_BOX_Y_START_S2         0x3b57
#define VPU_MAFBC1_BOUNDING_BOX_Y_END_S2           0x3b58
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_LOW_S2          0x3b59
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_HIGH_S2         0x3b5a
#define VPU_MAFBC1_OUTPUT_BUF_STRIDE_S2            0x3b5b
#define VPU_MAFBC1_PREFETCH_CFG_S2                 0x3b5c
#define VPU_MAFBC1_PAYLOAD_MIN_LOW_S2              0x3b5d
#define VPU_MAFBC1_PAYLOAD_MIN_HIGH_S2             0x3b5e
#define VPU_MAFBC1_PAYLOAD_MAX_LOW_S2              0x3b5f
#define VPU_MAFBC1_PAYLOAD_MAX_HIGH_S2             0x3b60
#define VPU_MAFBC1_HEADER_BUF_ADDR_LOW_S3          0x3b70
#define VPU_MAFBC1_HEADER_BUF_ADDR_HIGH_S3         0x3b71
#define VPU_MAFBC1_FORMAT_SPECIFIER_S3             0x3b72
#define VPU_MAFBC1_BUFFER_WIDTH_S3                 0x3b73
#define VPU_MAFBC1_BUFFER_HEIGHT_S3                0x3b74
#define VPU_MAFBC1_BOUNDING_BOX_X_START_S3         0x3b75
#define VPU_MAFBC1_BOUNDING_BOX_X_END_S3           0x3b76
#define VPU_MAFBC1_BOUNDING_BOX_Y_START_S3         0x3b77
#define VPU_MAFBC1_BOUNDING_BOX_Y_END_S3           0x3b78
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_LOW_S3          0x3b79
#define VPU_MAFBC1_OUTPUT_BUF_ADDR_HIGH_S3         0x3b7a
#define VPU_MAFBC1_OUTPUT_BUF_STRIDE_S3            0x3b7b
#define VPU_MAFBC1_PREFETCH_CFG_S3                 0x3b7c
#define VPU_MAFBC1_PAYLOAD_MIN_LOW_S3              0x3b7d
#define VPU_MAFBC1_PAYLOAD_MIN_HIGH_S3             0x3b7e
#define VPU_MAFBC1_PAYLOAD_MAX_LOW_S3              0x3b7f
#define VPU_MAFBC1_PAYLOAD_MAX_HIGH_S3             0x3b80

#define VPU_MAFBC2_BLOCK_ID                        0x3c00
#define VPU_MAFBC2_IRQ_RAW_STATUS                  0x3c01
#define VPU_MAFBC2_IRQ_CLEAR                       0x3c02
#define VPU_MAFBC2_IRQ_MASK                        0x3c03
#define VPU_MAFBC2_IRQ_STATUS                      0x3c04
#define VPU_MAFBC2_COMMAND                         0x3c05
#define VPU_MAFBC2_STATUS                          0x3c06
#define VPU_MAFBC2_SURFACE_CFG                     0x3c07
#define VPU_MAFBC2_AXI_CFG                         0x3c08
#define VPU_MAFBC2_HEADER_BUF_ADDR_LOW_S0          0x3c10
#define VPU_MAFBC2_HEADER_BUF_ADDR_HIGH_S0         0x3c11
#define VPU_MAFBC2_FORMAT_SPECIFIER_S0             0x3c12
#define VPU_MAFBC2_BUFFER_WIDTH_S0                 0x3c13
#define VPU_MAFBC2_BUFFER_HEIGHT_S0                0x3c14
#define VPU_MAFBC2_BOUNDING_BOX_X_START_S0         0x3c15
#define VPU_MAFBC2_BOUNDING_BOX_X_END_S0           0x3c16
#define VPU_MAFBC2_BOUNDING_BOX_Y_START_S0         0x3c17
#define VPU_MAFBC2_BOUNDING_BOX_Y_END_S0           0x3c18
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_LOW_S0          0x3c19
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_HIGH_S0         0x3c1a
#define VPU_MAFBC2_OUTPUT_BUF_STRIDE_S0            0x3c1b
#define VPU_MAFBC2_PREFETCH_CFG_S0                 0x3c1c
#define VPU_MAFBC2_PAYLOAD_MIN_LOW_S0              0x3c1d
#define VPU_MAFBC2_PAYLOAD_MIN_HIGH_S0             0x3c1e
#define VPU_MAFBC2_PAYLOAD_MAX_LOW_S0              0x3c1f
#define VPU_MAFBC2_PAYLOAD_MAX_HIGH_S0             0x3c20
#define VPU_MAFBC2_HEADER_BUF_ADDR_LOW_S1          0x3c30
#define VPU_MAFBC2_HEADER_BUF_ADDR_HIGH_S1         0x3c31
#define VPU_MAFBC2_FORMAT_SPECIFIER_S1             0x3c32
#define VPU_MAFBC2_BUFFER_WIDTH_S1                 0x3c33
#define VPU_MAFBC2_BUFFER_HEIGHT_S1                0x3c34
#define VPU_MAFBC2_BOUNDING_BOX_X_START_S1         0x3c35
#define VPU_MAFBC2_BOUNDING_BOX_X_END_S1           0x3c36
#define VPU_MAFBC2_BOUNDING_BOX_Y_START_S1         0x3c37
#define VPU_MAFBC2_BOUNDING_BOX_Y_END_S1           0x3c38
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_LOW_S1          0x3c39
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_HIGH_S1         0x3c3a
#define VPU_MAFBC2_OUTPUT_BUF_STRIDE_S1            0x3c3b
#define VPU_MAFBC2_PREFETCH_CFG_S1                 0x3c3c
#define VPU_MAFBC2_PAYLOAD_MIN_LOW_S1              0x3c3d
#define VPU_MAFBC2_PAYLOAD_MIN_HIGH_S1             0x3c3e
#define VPU_MAFBC2_PAYLOAD_MAX_LOW_S1              0x3c3f
#define VPU_MAFBC2_PAYLOAD_MAX_HIGH_S1             0x3c40
#define VPU_MAFBC2_HEADER_BUF_ADDR_LOW_S2          0x3c50
#define VPU_MAFBC2_HEADER_BUF_ADDR_HIGH_S2         0x3c51
#define VPU_MAFBC2_FORMAT_SPECIFIER_S2             0x3c52
#define VPU_MAFBC2_BUFFER_WIDTH_S2                 0x3c53
#define VPU_MAFBC2_BUFFER_HEIGHT_S2                0x3c54
#define VPU_MAFBC2_BOUNDING_BOX_X_START_S2         0x3c55
#define VPU_MAFBC2_BOUNDING_BOX_X_END_S2           0x3c56
#define VPU_MAFBC2_BOUNDING_BOX_Y_START_S2         0x3c57
#define VPU_MAFBC2_BOUNDING_BOX_Y_END_S2           0x3c58
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_LOW_S2          0x3c59
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_HIGH_S2         0x3c5a
#define VPU_MAFBC2_OUTPUT_BUF_STRIDE_S2            0x3c5b
#define VPU_MAFBC2_PREFETCH_CFG_S2                 0x3c5c
#define VPU_MAFBC2_PAYLOAD_MIN_LOW_S2              0x3c5d
#define VPU_MAFBC2_PAYLOAD_MIN_HIGH_S2             0x3c5e
#define VPU_MAFBC2_PAYLOAD_MAX_LOW_S2              0x3c5f
#define VPU_MAFBC2_PAYLOAD_MAX_HIGH_S2             0x3c60
#define VPU_MAFBC2_HEADER_BUF_ADDR_LOW_S3          0x3c70
#define VPU_MAFBC2_HEADER_BUF_ADDR_HIGH_S3         0x3c71
#define VPU_MAFBC2_FORMAT_SPECIFIER_S3             0x3c72
#define VPU_MAFBC2_BUFFER_WIDTH_S3                 0x3c73
#define VPU_MAFBC2_BUFFER_HEIGHT_S3                0x3c74
#define VPU_MAFBC2_BOUNDING_BOX_X_START_S3         0x3c75
#define VPU_MAFBC2_BOUNDING_BOX_X_END_S3           0x3c76
#define VPU_MAFBC2_BOUNDING_BOX_Y_START_S3         0x3c77
#define VPU_MAFBC2_BOUNDING_BOX_Y_END_S3           0x3c78
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_LOW_S3          0x3c79
#define VPU_MAFBC2_OUTPUT_BUF_ADDR_HIGH_S3         0x3c7a
#define VPU_MAFBC2_OUTPUT_BUF_STRIDE_S3            0x3c7b
#define VPU_MAFBC2_PREFETCH_CFG_S3                 0x3c7c
#define VPU_MAFBC2_PAYLOAD_MIN_LOW_S3              0x3c7d
#define VPU_MAFBC2_PAYLOAD_MIN_HIGH_S3             0x3c7e
#define VPU_MAFBC2_PAYLOAD_MAX_LOW_S3              0x3c7f
#define VPU_MAFBC2_PAYLOAD_MAX_HIGH_S3             0x3c80

#define AMDV_PATH_CTRL                     0x1a0c
#define OSD_PATH_MISC_CTRL                  0x1a0e
#define MALI_AFBCD_TOP_CTRL                 0x1a0f

#define VIU_OSD_BLEND_CTRL                  0x39b0
#define VIU_OSD_BLEND_CTRL1                 0x39c0
#define VIU_OSD_BLEND_DIN0_SCOPE_H          0x39b1
#define VIU_OSD_BLEND_DIN0_SCOPE_V          0x39b2
#define VIU_OSD_BLEND_DIN1_SCOPE_H          0x39b3
#define VIU_OSD_BLEND_DIN1_SCOPE_V          0x39b4
#define VIU_OSD_BLEND_DIN2_SCOPE_H          0x39b5
#define VIU_OSD_BLEND_DIN2_SCOPE_V          0x39b6
#define VIU_OSD_BLEND_DIN3_SCOPE_H          0x39b7
#define VIU_OSD_BLEND_DIN3_SCOPE_V          0x39b8
#define VIU_OSD_BLEND_DUMMY_DATA0           0x39b9
#define VIU_OSD_BLEND_DUMMY_ALPHA           0x39ba
#define VIU_OSD_BLEND_BLEND0_SIZE           0x39bb
#define VIU_OSD_BLEND_BLEND1_SIZE           0x39bc

#define VPP_OUT_H_V_SIZE                    0x1da5

#define VPP_VD2_HDR_IN_SIZE                 0x1df0
#define VPP_OSD1_IN_SIZE                    0x1df1
#define VPP_GCLK_CTRL2                      0x1df2
#define VD2_PPS_DUMMY_DATA                  0x1df4

#define VPP_OSD1_BLD_H_SCOPE                0x1df5
#define VPP_OSD1_BLD_V_SCOPE                0x1df6
#define VPP_OSD2_BLD_H_SCOPE                0x1df7
#define VPP_OSD2_BLD_V_SCOPE                0x1df8

#define VPP_WRBAK_CTRL                      0x1df9
#define VPP_SLEEP_CTRL                      0x1dfa

#define VD1_BLEND_SRC_CTRL                  0x1dfb
#define VD2_BLEND_SRC_CTRL                  0x1dfc
#define VD3_BLEND_SRC_CTRL                  0x1def
#define OSD1_BLEND_SRC_CTRL                 0x1dfd
#define OSD2_BLEND_SRC_CTRL                 0x1dfe

#define VPP_RDARB_MODE                      0x3978
#define VPP_RDARB_REQEN_SLV                 0x3979
#define VPU_RDARB_MODE_L2C1                 0x279d

/*VIU2 osd1 reg*/
#define VIU2_OSD1_MATRIX_COEF00_01          0x1e70
#define VIU2_OSD1_MATRIX_COEF02_10          0x1e71
#define VIU2_OSD1_MATRIX_COEF11_12          0x1e72
#define VIU2_OSD1_MATRIX_COEF20_21          0x1e73
#define VIU2_OSD1_MATRIX_COEF22             0x1e74
#define VIU2_OSD1_MATRIX_COEF13_14          0x1e75
#define VIU2_OSD1_MATRIX_COEF23_24          0x1e76
#define VIU2_OSD1_MATRIX_COEF15_25          0x1e77
#define VIU2_OSD1_MATRIX_CLIP               0x1e78
#define VIU2_OSD1_MATRIX_OFFSET0_1          0x1e79
#define VIU2_OSD1_MATRIX_OFFSET2            0x1e7a
#define VIU2_OSD1_MATRIX_PRE_OFFSET0_1      0x1e7b
#define VIU2_OSD1_MATRIX_PRE_OFFSET2        0x1e7c
#define VIU2_OSD1_MATRIX_EN_CTRL            0x1e7d

#define VPP_WRAP_OSD1_MATRIX_EN_CTRL        0x3d6d
#define VPP_WRAP_OSD2_MATRIX_EN_CTRL        0x3d7d
#define VPP_WRAP_OSD3_MATRIX_EN_CTRL        0x3dbd
#define OSD1_HDR2_MATRIXI_EN_CTRL           0x38db
#define OSD1_HDR2_MATRIXO_EN_CTRL           0x38dc

#define VPP_OSD1_MATRIX_COEF00_01           0x3910
#define VPP_OSD1_MATRIX_COEF02_10           0x3911
#define VPP_OSD1_MATRIX_COEF11_12           0x3912
#define VPP_OSD1_MATRIX_COEF20_21           0x3913
#define VPP_OSD1_MATRIX_COEF22              0x3914
#define VPP_OSD1_MATRIX_COEF13_14           0x3915
#define VPP_OSD1_MATRIX_COEF23_24           0x3916
#define VPP_OSD1_MATRIX_COEF15_25           0x3917
#define VPP_OSD1_MATRIX_CLIP                0x3918
#define VPP_OSD1_MATRIX_OFFSET0_1           0x3919
#define VPP_OSD1_MATRIX_OFFSET2             0x391a
#define VPP_OSD1_MATRIX_PRE_OFFSET0_1       0x391b
#define VPP_OSD1_MATRIX_PRE_OFFSET2         0x391c
#define VPP_OSD1_MATRIX_EN_CTRL             0x391d

#define VPP_OSD2_MATRIX_COEF00_01           0x3920
#define VPP_OSD2_MATRIX_COEF02_10           0x3921
#define VPP_OSD2_MATRIX_COEF11_12           0x3922
#define VPP_OSD2_MATRIX_COEF20_21           0x3923
#define VPP_OSD2_MATRIX_COEF22              0x3924
#define VPP_OSD2_MATRIX_COEF13_14           0x3925
#define VPP_OSD2_MATRIX_COEF23_24           0x3926
#define VPP_OSD2_MATRIX_COEF15_25           0x3927
#define VPP_OSD2_MATRIX_CLIP                0x3928
#define VPP_OSD2_MATRIX_OFFSET0_1           0x3929
#define VPP_OSD2_MATRIX_OFFSET2             0x392a
#define VPP_OSD2_MATRIX_PRE_OFFSET0_1       0x392b
#define VPP_OSD2_MATRIX_PRE_OFFSET2         0x392c
#define VPP_OSD2_MATRIX_EN_CTRL             0x392d

#define OSD2_DB_FLT_CTRL                           0x5a60
#define OSD34_DB_FLT_CTRL                          0x5aa0
#define OSD4_DB_FLT_CTRL                           0x5ae0

#define VPP_OSD1_SCALE_CTRL                        0x1a73
#define VPP_OSD2_SCALE_CTRL                        0x1a74
#define VPP_OSD3_SCALE_CTRL                        0x1a75
#define VPP_OSD4_SCALE_CTRL                        0x1a76
#define VPP_VD1_DSC_CTRL                           0x1a83
#define VPP_VD2_DSC_CTRL                           0x1a84
#define VPP_VD3_DSC_CTRL                           0x1a85
#define MALI_AFBCD1_TOP_CTRL                       0x1a55
#define MALI_AFBCD2_TOP_CTRL                       0x1a56
#define PATH_START_SEL                             0x1a8a
#define OSD1_HDR_IN_SIZE                           0x1a5a
#define OSD2_HDR_IN_SIZE                           0x1a5b
#define OSD3_HDR_IN_SIZE                           0x1a5c
#define OSD4_HDR_IN_SIZE                           0x1a5d
#define OSD1_HDR2_CTRL                             0x38a0
#define _OSD2_HDR2_CTRL                             0x5b00
#define OSD3_HDR2_CTRL                             0x5b50
#define OSD4_HDR2_CTRL                             0x5ba0
#define _OSD2_HDR2_MATRIXI_EN_CTRL                  0x5b3b
#define _OSD2_HDR2_MATRIXO_EN_CTRL                  0x5b3c
#define OSD3_HDR2_MATRIXI_EN_CTRL                  0x5b8b
#define OSD3_HDR2_MATRIXO_EN_CTRL                  0x5b8c
#define OSD4_HDR2_MATRIXI_EN_CTRL                  0x5bdb
#define OSD4_HDR2_MATRIXO_EN_CTRL                  0x5bdc

#define VPU_VENCI_STAT                             0x1ceb
#define VPU_VENCL_STAT                             0x1cec
#define VPU_VENCP_STAT                             0x1ced
#define VPU_VENC_CTRL                              0x1cef
#define VPU1_VENC_CTRL                             0x22ef
#define VPU2_VENC_CTRL                             0x24ef
#define VIU_VD1_PATH_CTRL                          0x1a73
#define VIU_VD2_PATH_CTRL                          0x1a74
#define VIU_OSD1_PATH_CTRL                         0x1a76
#define VIU_OSD2_PATH_CTRL                         0x1a77
#define VIU_OSD3_PATH_CTRL                         0x1a78

#define VPP1_BLD_CTRL                              0x5985
#define VPP1_BLD_OUT_SIZE                          0x5986
#define VPP1_BLD_DIN0_HSCOPE                       0x5987
#define VPP1_BLD_DIN0_VSCOPE                       0x5988
#define VPP1_BLD_DIN1_HSCOPE                       0x5989
#define VPP1_BLD_DIN1_VSCOPE                       0x598a
#define VPP1_BLD_DIN2_HSCOPE                       0x598b
#define VPP1_BLD_DIN2_VSCOPE                       0x598c
#define VPP1_BLEND_BLEND_DUMMY_DATA                0x59a9
#define VPP1_BLEND_DUMMY_ALPHA                     0x59aa

#define VPP2_BLD_CTRL                              0x59c5
#define VPP2_BLD_OUT_SIZE                          0x59c6
#define VPP2_BLD_DIN0_HSCOPE                       0x59c7
#define VPP2_BLD_DIN0_VSCOPE                       0x59c8
#define VPP2_BLD_DIN1_HSCOPE                       0x59c9
#define VPP2_BLD_DIN1_VSCOPE                       0x59ca
#define VPP2_BLD_DIN2_HSCOPE                       0x59cb
#define VPP2_BLD_DIN2_VSCOPE                       0x59cc
#define VPP2_BLEND_BLEND_DUMMY_DATA                0x59e9
#define VPP2_BLEND_DUMMY_ALPHA                     0x59ea

#define T3X_VPP1_OSD3_BLD_H_SCOPE                  0x1d1c
#define T3X_VPP1_OSD3_BLD_V_SCOPE                  0x1d1d
#define T3X_VPP1_BLD_CTRL                          0x1d1b
#define T3X_VPP1_BLEND_H_V_SIZE                    0x1d1a
#define T3X_VPP1_BLEND_BLEND_DUMMY_DATA            0x1d51
#define T3X_VPP1_BLEND_DUMMY_ALPHA                 0x1d52
#define T3X_VPP1_BLEND_DUMMY_ALPHA1                0x1d54

/* c3 osd */
#define VOUT_OSD1_CTRL_STAT                        0x0240
#define VOUT_OSD1_CTRL_STAT2                       0x0241
#define VOUT_OSD1_COLOR_ADDR                       0x0242
#define VOUT_OSD1_COLOR                            0x0243
#define VOUT_OSD1_TCOLOR_AG0                       0x0244
#define VOUT_OSD1_TCOLOR_AG1                       0x0245
#define VOUT_OSD1_TCOLOR_AG2                       0x0246
#define VOUT_OSD1_TCOLOR_AG3                       0x0247
#define VOUT_OSD1_BLK0_CFG_W0                      0x0248
#define VOUT_OSD1_BLK1_CFG_W0                      0x0249
#define VOUT_OSD1_BLK2_CFG_W0                      0x024a
#define VOUT_OSD1_BLK3_CFG_W0                      0x024b
#define VOUT_OSD1_BLK0_CFG_W1                      0x024c
#define VOUT_OSD1_BLK1_CFG_W1                      0x024d
#define VOUT_OSD1_BLK2_CFG_W1                      0x024e
#define VOUT_OSD1_BLK3_CFG_W1                      0x024f
#define VOUT_OSD1_BLK0_CFG_W2                      0x0250
#define VOUT_OSD1_BLK1_CFG_W2                      0x0251
#define VOUT_OSD1_BLK2_CFG_W2                      0x0252
#define VOUT_OSD1_BLK3_CFG_W2                      0x0253
#define VOUT_OSD1_BLK0_CFG_W3                      0x0254
#define VOUT_OSD1_BLK1_CFG_W3                      0x0255
#define VOUT_OSD1_BLK2_CFG_W3                      0x0256
#define VOUT_OSD1_BLK3_CFG_W3                      0x0257
#define VOUT_OSD1_BLK0_CFG_W4                      0x0258
#define VOUT_OSD1_BLK1_CFG_W4                      0x0259
#define VOUT_OSD1_BLK2_CFG_W4                      0x025a
#define VOUT_OSD1_BLK3_CFG_W4                      0x025b
#define VOUT_OSD1_FIFO_CTRL_STAT                   0x0260
#define VOUT_OSD1_TEST_RDDATA                      0x0261
#define VOUT_OSD1_PROT_CTRL                        0x0262
#define VOUT_OSD1_MALI_UNPACK_CTRL                 0x0263
#define VOUT_OSD1_DIMM_CTRL                        0x0264

#define VOUT_OSD1_UNSUPPORT      VOUT_OSD1_TCOLOR_AG0

//OSD_CSC
#define VOUT_OSD1_CSC_COEF00_01                    0x0280
#define VOUT_OSD1_CSC_COEF02_10                    0x0281
#define VOUT_OSD1_CSC_COEF11_12                    0x0282
#define VOUT_OSD1_CSC_COEF20_21                    0x0283
#define VOUT_OSD1_CSC_COEF22                       0x0284
#define VOUT_OSD1_CSC_COEF30_31                    0x0285
#define VOUT_OSD1_CSC_COEF32_40                    0x0286
#define VOUT_OSD1_CSC_COEF41_42                    0x0287
#define VOUT_OSD1_CSC_CLIP                         0x0288
#define VOUT_OSD1_CSC_OFFSET0_1                    0x0289
#define VOUT_OSD1_CSC_OFFSET2                      0x028a
#define VOUT_OSD1_CSC_PRE_OFFSET0_1                0x028b
#define VOUT_OSD1_CSC_PRE_OFFSET2                  0x028c
#define VOUT_OSD1_CSC_EN_CTRL                      0x028d
//OSD_SCALER
#define VOUT_OSD1_VSC_PHASE_STEP                   0x02a0
#define VOUT_OSD1_VSC_INI_PHASE                    0x02a1
#define VOUT_OSD1_VSC_CTRL0                        0x02a2
#define VOUT_OSD1_HSC_PHASE_STEP                   0x02a3
#define VOUT_OSD1_HSC_INI_PHASE                    0x02a4
#define VOUT_OSD1_HSC_CTRL0                        0x02a5
#define VOUT_OSD1_HSC_INI_PAT_CTRL                 0x02a6
#define VOUT_OSD1_SC_DUMMY_DATA                    0x02a7
#define VOUT_OSD1_SC_CTRL0                         0x02a8
#define VOUT_OSD1_SCI_WH_M1                        0x02a9
#define VOUT_OSD1_SCO_H_START_END                  0x02aa
#define VOUT_OSD1_SCO_V_START_END                  0x02ab
#define VOUT_OSD1_SCALE_COEF_IDX                   0x02ac
#define VOUT_OSD1_SCALE_COEF                       0x02ad
#define VOUT_OSD1_DB_FLT_CTRL                      0x02ae
#define VOUT_OSD1_DB_FLT_CTRL1                     0x02af
#define VOUT_OSD1_DB_FLT_LUMA_THRD                 0x02b0
#define VOUT_OSD1_DB_FLT_CHRM_THRD                 0x02b1
#define VOUT_OSD1_DB_FLT_RANDLUT                   0x02b2
#define VOUT_OSD1_DB_FLT_PXI_THRD                  0x02b3
#define VOUT_OSD1_DB_FLT_SEED_Y                    0x02b4
#define VOUT_OSD1_DB_FLT_SEED_U                    0x02b5
#define VOUT_OSD1_DB_FLT_SEED_V                    0x02b6
#define VOUT_OSD1_DB_FLT_SEED3                     0x02b7
#define VOUT_OSD1_DB_FLT_SEED4                     0x02b8
#define VOUT_OSD1_DB_FLT_SEED5                     0x02b9

#define VPU_VOUT_IRQ_CTRL                          0x0007
#define VPU_VOUT_BLEND_CTRL                        0x0010
#define VPU_VOUT_BLEND_DUMDATA                     0x0011
#define VPU_VOUT_BLEND_SIZE                        0x0012
//vd1 module
#define VPU_VOUT_BLD_SRC0_HPOS                     0x0020
#define VPU_VOUT_BLD_SRC0_VPOS                     0x0021
//osd1 module
#define VPU_VOUT_BLD_SRC1_HPOS                     0x0030
#define VPU_VOUT_BLD_SRC1_VPOS                     0x0031

/* s5 mif regs */
#define S5_VIU_OSD1_CTRL_STAT          0x4200
#define S5_VIU_OSD1_CTRL_STAT2         0x4201
#define S5_VIU_OSD1_COLOR_ADDR         0x4202
#define S5_VIU_OSD1_COLOR              0x4203
#define S5_VIU_OSD1_TCOLOR_AG0         0x4204
#define S5_VIU_OSD1_TCOLOR_AG1         0x4205
#define S5_VIU_OSD1_TCOLOR_AG2         0x4206
#define S5_VIU_OSD1_TCOLOR_AG3         0x4207
#define S5_VIU_OSD1_BLK0_CFG_W0        0x4208
#define S5_VIU_OSD1_BLK1_CFG_W0        0x4209
#define S5_VIU_OSD1_BLK2_CFG_W0        0x420a
#define S5_VIU_OSD1_BLK3_CFG_W0        0x420b
#define S5_VIU_OSD1_BLK0_CFG_W1        0x420c
#define S5_VIU_OSD1_BLK1_CFG_W1        0x420d
#define S5_VIU_OSD1_BLK2_CFG_W1        0x420e
#define S5_VIU_OSD1_BLK3_CFG_W1        0x420f
#define S5_VIU_OSD1_BLK0_CFG_W2        0x4210
#define S5_VIU_OSD1_BLK1_CFG_W2        0x4211
#define S5_VIU_OSD1_BLK2_CFG_W2        0x4212
#define S5_VIU_OSD1_BLK3_CFG_W2        0x4213
#define S5_VIU_OSD1_BLK0_CFG_W3        0x4214
#define S5_VIU_OSD1_BLK1_CFG_W3        0x4215
#define S5_VIU_OSD1_BLK2_CFG_W3        0x4216
#define S5_VIU_OSD1_BLK3_CFG_W3        0x4217
#define S5_VIU_OSD1_BLK0_CFG_W4        0x4218
#define S5_VIU_OSD1_BLK1_CFG_W4        0x4219
#define S5_VIU_OSD1_BLK2_CFG_W4        0x421a
#define S5_VIU_OSD1_BLK3_CFG_W4        0x421b
#define S5_VIU_OSD1_FIFO_CTRL_STAT     0x421c
#define S5_VIU_OSD1_TEST_RDDATA        0x421d
#define S5_VIU_OSD1_PROT_CTRL          0x421e
#define S5_VIU_OSD1_MALI_UNPACK_CTRL   0x421f
#define S5_VIU_OSD1_DIMM_CTRL          0x4220

#define S5_VIU_OSD2_CTRL_STAT          0x4240
#define S5_VIU_OSD2_CTRL_STAT2         0x4241
#define S5_VIU_OSD2_COLOR_ADDR         0x4242
#define S5_VIU_OSD2_COLOR              0x4243
#define S5_VIU_OSD2_TCOLOR_AG0         0x4244
#define S5_VIU_OSD2_TCOLOR_AG1         0x4245
#define S5_VIU_OSD2_TCOLOR_AG2         0x4246
#define S5_VIU_OSD2_TCOLOR_AG3         0x4247
#define S5_VIU_OSD2_BLK0_CFG_W0        0x4248
#define S5_VIU_OSD2_BLK1_CFG_W0        0x4249
#define S5_VIU_OSD2_BLK2_CFG_W0        0x424a
#define S5_VIU_OSD2_BLK3_CFG_W0        0x424b
#define S5_VIU_OSD2_BLK0_CFG_W1        0x424c
#define S5_VIU_OSD2_BLK1_CFG_W1        0x424d
#define S5_VIU_OSD2_BLK2_CFG_W1        0x424e
#define S5_VIU_OSD2_BLK3_CFG_W1        0x424f
#define S5_VIU_OSD2_BLK0_CFG_W2        0x4250
#define S5_VIU_OSD2_BLK1_CFG_W2        0x4251
#define S5_VIU_OSD2_BLK2_CFG_W2        0x4252
#define S5_VIU_OSD2_BLK3_CFG_W2        0x4253
#define S5_VIU_OSD2_BLK0_CFG_W3        0x4254
#define S5_VIU_OSD2_BLK1_CFG_W3        0x4255
#define S5_VIU_OSD2_BLK2_CFG_W3        0x4256
#define S5_VIU_OSD2_BLK3_CFG_W3        0x4257
#define S5_VIU_OSD2_BLK0_CFG_W4        0x4258
#define S5_VIU_OSD2_BLK1_CFG_W4        0x4259
#define S5_VIU_OSD2_BLK2_CFG_W4        0x425a
#define S5_VIU_OSD2_BLK3_CFG_W4        0x425b
#define S5_VIU_OSD2_FIFO_CTRL_STAT     0x425c
#define S5_VIU_OSD2_TEST_RDDATA        0x425d
#define S5_VIU_OSD2_PROT_CTRL          0x425e
#define S5_VIU_OSD2_MALI_UNPACK_CTRL   0x425f
#define S5_VIU_OSD2_DIMM_CTRL          0x4260
#define S5_VIU_OSD2_HL1_H_START_END    0x4263
#define S5_VIU_OSD2_HL1_V_START_END    0x4264
#define S5_VIU_OSD2_HL2_H_START_END    0x4265
#define S5_VIU_OSD2_HL2_V_START_END    0x4266

#define S5_VIU_OSD3_CTRL_STAT          0x4280
#define S5_VIU_OSD3_CTRL_STAT2         0x4281
#define S5_VIU_OSD3_COLOR_ADDR         0x4282
#define S5_VIU_OSD3_COLOR              0x4283
#define S5_VIU_OSD3_TCOLOR_AG0         0x4284
#define S5_VIU_OSD3_TCOLOR_AG1         0x4285
#define S5_VIU_OSD3_TCOLOR_AG2         0x4286
#define S5_VIU_OSD3_TCOLOR_AG3         0x4287
#define S5_VIU_OSD3_BLK0_CFG_W0        0x4288
#define S5_VIU_OSD3_BLK1_CFG_W0        0x4289
#define S5_VIU_OSD3_BLK2_CFG_W0        0x428a
#define S5_VIU_OSD3_BLK3_CFG_W0        0x428b
#define S5_VIU_OSD3_BLK0_CFG_W1        0x428c
#define S5_VIU_OSD3_BLK1_CFG_W1        0x428d
#define S5_VIU_OSD3_BLK2_CFG_W1        0x428e
#define S5_VIU_OSD3_BLK3_CFG_W1        0x428f
#define S5_VIU_OSD3_BLK0_CFG_W2        0x4290
#define S5_VIU_OSD3_BLK1_CFG_W2        0x4291
#define S5_VIU_OSD3_BLK2_CFG_W2        0x4292
#define S5_VIU_OSD3_BLK3_CFG_W2        0x4293
#define S5_VIU_OSD3_BLK0_CFG_W3        0x4294
#define S5_VIU_OSD3_BLK1_CFG_W3        0x4295
#define S5_VIU_OSD3_BLK2_CFG_W3        0x4296
#define S5_VIU_OSD3_BLK3_CFG_W3        0x4297
#define S5_VIU_OSD3_BLK0_CFG_W4        0x4298
#define S5_VIU_OSD3_BLK1_CFG_W4        0x4299
#define S5_VIU_OSD3_BLK2_CFG_W4        0x429a
#define S5_VIU_OSD3_BLK3_CFG_W4        0x429b
#define S5_VIU_OSD3_FIFO_CTRL_STAT     0x429c
#define S5_VIU_OSD3_TEST_RDDATA        0x429d
#define S5_VIU_OSD3_PROT_CTRL          0x429e
#define S5_VIU_OSD3_MALI_UNPACK_CTRL   0x429f
#define S5_VIU_OSD3_DIMM_CTRL          0x42a0

#define S5_VIU_OSD4_CTRL_STAT          0x42c0
#define S5_VIU_OSD4_CTRL_STAT2         0x42c1
#define S5_VIU_OSD4_COLOR_ADDR         0x42c2
#define S5_VIU_OSD4_COLOR              0x42c3
#define S5_VIU_OSD4_TCOLOR_AG0         0x42c4
#define S5_VIU_OSD4_TCOLOR_AG1         0x42c5
#define S5_VIU_OSD4_TCOLOR_AG2         0x42c6
#define S5_VIU_OSD4_TCOLOR_AG3         0x42c7
#define S5_VIU_OSD4_BLK0_CFG_W0        0x42c8
#define S5_VIU_OSD4_BLK1_CFG_W0        0x42c9
#define S5_VIU_OSD4_BLK2_CFG_W0        0x42ca
#define S5_VIU_OSD4_BLK3_CFG_W0        0x42cb
#define S5_VIU_OSD4_BLK0_CFG_W1        0x42cc
#define S5_VIU_OSD4_BLK1_CFG_W1        0x42cd
#define S5_VIU_OSD4_BLK2_CFG_W1        0x42ce
#define S5_VIU_OSD4_BLK3_CFG_W1        0x42cf
#define S5_VIU_OSD4_BLK0_CFG_W2        0x42d0
#define S5_VIU_OSD4_BLK1_CFG_W2        0x42d1
#define S5_VIU_OSD4_BLK2_CFG_W2        0x42d2
#define S5_VIU_OSD4_BLK3_CFG_W2        0x42d3
#define S5_VIU_OSD4_BLK0_CFG_W3        0x42d4
#define S5_VIU_OSD4_BLK1_CFG_W3        0x42d5
#define S5_VIU_OSD4_BLK2_CFG_W3        0x42d6
#define S5_VIU_OSD4_BLK3_CFG_W3        0x42d7
#define S5_VIU_OSD4_BLK0_CFG_W4        0x42d8
#define S5_VIU_OSD4_BLK1_CFG_W4        0x42d9
#define S5_VIU_OSD4_BLK2_CFG_W4        0x42da
#define S5_VIU_OSD4_BLK3_CFG_W4        0x42db
#define S5_VIU_OSD4_FIFO_CTRL_STAT     0x42dc
#define S5_VIU_OSD4_TEST_RDDATA        0x42dd
#define S5_VIU_OSD4_PROT_CTRL          0x42de
#define S5_VIU_OSD4_MALI_UNPACK_CTRL   0x42df
#define S5_VIU_OSD4_DIMM_CTRL          0x42e0

/* s5 scaler regs */
#define OSD1_PROC_VSC_PHASE_STEP      0x6410
#define OSD1_PROC_VSC_INI_PHASE       0x6411
#define OSD1_PROC_VSC_CTRL0           0x6412
#define OSD1_PROC_HSC_PHASE_STEP      0x6413
#define OSD1_PROC_HSC_INI_PHASE       0x6414
#define OSD1_PROC_HSC_CTRL0           0x6415
#define OSD1_PROC_HSC_INI_PAT_CTRL    0x6416
#define OSD1_PROC_SC_DUMMY_DATA       0x6417
#define OSD1_PROC_SC_CTRL0            0x6418
#define OSD1_PROC_SCI_WH_M1           0x6419
#define OSD1_PROC_SCO_H_START_END     0x641a
#define OSD1_PROC_SCO_V_START_END     0x641b
#define OSD1_PROC_SCALE_COEF_IDX      0x641c
#define OSD1_PROC_SCALE_COEF          0x641d
#define OSD1_PROC_DB_FLT_CTRL         0x6420
#define OSD1_PROC_DB_FLT_CTRL1        0x6421
#define OSD1_PROC_DB_FLT_LUMA_THRD    0x6422
#define OSD1_PROC_DB_FLT_CHRM_THRD    0x6423
#define OSD1_PROC_DB_FLT_RANDLUT      0x6424
#define OSD1_PROC_DB_FLT_PXI_THRD     0x6425
#define OSD1_PROC_DB_FLT_SEED_Y       0x6426
#define OSD1_PROC_DB_FLT_SEED_U       0x6427
#define OSD1_PROC_DB_FLT_SEED_V       0x6428
#define OSD1_PROC_DB_FLT_SEED3        0x6429
#define OSD1_PROC_DB_FLT_SEED4        0x642a
#define OSD1_PROC_DB_FLT_SEED5        0x642b

#define OSD2_PROC_VSC_PHASE_STEP      0x6810
#define OSD2_PROC_VSC_INI_PHASE       0x6811
#define OSD2_PROC_VSC_CTRL0           0x6812
#define OSD2_PROC_HSC_PHASE_STEP      0x6813
#define OSD2_PROC_HSC_INI_PHASE       0x6814
#define OSD2_PROC_HSC_CTRL0           0x6815
#define OSD2_PROC_HSC_INI_PAT_CTRL    0x6816
#define OSD2_PROC_SC_DUMMY_DATA       0x6817
#define OSD2_PROC_SC_CTRL0            0x6818
#define OSD2_PROC_SCI_WH_M1           0x6819
#define OSD2_PROC_SCO_H_START_END     0x681a
#define OSD2_PROC_SCO_V_START_END     0x681b
#define OSD2_PROC_SCALE_COEF_IDX      0x681c
#define OSD2_PROC_SCALE_COEF          0x681d
#define OSD2_PROC_DB_FLT_CTRL         0x6820
#define OSD2_PROC_DB_FLT_CTRL1        0x6821
#define OSD2_PROC_DB_FLT_LUMA_THRD    0x6822
#define OSD2_PROC_DB_FLT_CHRM_THRD    0x6823
#define OSD2_PROC_DB_FLT_RANDLUT      0x6824
#define OSD2_PROC_DB_FLT_PXI_THRD     0x6825
#define OSD2_PROC_DB_FLT_SEED_Y       0x6826
#define OSD2_PROC_DB_FLT_SEED_U       0x6827
#define OSD2_PROC_DB_FLT_SEED_V       0x6828
#define OSD2_PROC_DB_FLT_SEED3        0x6829
#define OSD2_PROC_DB_FLT_SEED4        0x682a
#define OSD2_PROC_DB_FLT_SEED5        0x682b

#define OSD3_PROC_VSC_PHASE_STEP      0x6c10
#define OSD3_PROC_VSC_INI_PHASE       0x6c11
#define OSD3_PROC_VSC_CTRL0           0x6c12
#define OSD3_PROC_HSC_PHASE_STEP      0x6c13
#define OSD3_PROC_HSC_INI_PHASE       0x6c14
#define OSD3_PROC_HSC_CTRL0           0x6c15
#define OSD3_PROC_HSC_INI_PAT_CTRL    0x6c16
#define OSD3_PROC_SC_DUMMY_DATA       0x6c17
#define OSD3_PROC_SC_CTRL0            0x6c18
#define OSD3_PROC_SCI_WH_M1           0x6c19
#define OSD3_PROC_SCO_H_START_END     0x6c1a
#define OSD3_PROC_SCO_V_START_END     0x6c1b
#define OSD3_PROC_SCALE_COEF_IDX      0x6c1c
#define OSD3_PROC_SCALE_COEF          0x6c1d
#define OSD3_PROC_DB_FLT_CTRL         0x6c20
#define OSD3_PROC_DB_FLT_CTRL1        0x6c21
#define OSD3_PROC_DB_FLT_LUMA_THRD    0x6c22
#define OSD3_PROC_DB_FLT_CHRM_THRD    0x6c23
#define OSD3_PROC_DB_FLT_RANDLUT      0x6c24
#define OSD3_PROC_DB_FLT_PXI_THRD     0x6c25
#define OSD3_PROC_DB_FLT_SEED_Y       0x6c26
#define OSD3_PROC_DB_FLT_SEED_U       0x6c27
#define OSD3_PROC_DB_FLT_SEED_V       0x6c28
#define OSD3_PROC_DB_FLT_SEED3        0x6c29
#define OSD3_PROC_DB_FLT_SEED4        0x6c2a
#define OSD3_PROC_DB_FLT_SEED5        0x6c2b

#define OSD4_PROC_VSC_PHASE_STEP      0x7010
#define OSD4_PROC_VSC_INI_PHASE       0x7011
#define OSD4_PROC_VSC_CTRL0           0x7012
#define OSD4_PROC_HSC_PHASE_STEP      0x7013
#define OSD4_PROC_HSC_INI_PHASE       0x7014
#define OSD4_PROC_HSC_CTRL0           0x7015
#define OSD4_PROC_HSC_INI_PAT_CTRL    0x7016
#define OSD4_PROC_SC_DUMMY_DATA       0x7017
#define OSD4_PROC_SC_CTRL0            0x7018
#define OSD4_PROC_SCI_WH_M1           0x7019
#define OSD4_PROC_SCO_H_START_END     0x701a
#define OSD4_PROC_SCO_V_START_END     0x701b
#define OSD4_PROC_SCALE_COEF_IDX      0x701c
#define OSD4_PROC_SCALE_COEF          0x701d
#define OSD4_PROC_DB_FLT_CTRL         0x7020
#define OSD4_PROC_DB_FLT_CTRL1        0x7021
#define OSD4_PROC_DB_FLT_LUMA_THRD    0x7022
#define OSD4_PROC_DB_FLT_CHRM_THRD    0x7023
#define OSD4_PROC_DB_FLT_RANDLUT      0x7024
#define OSD4_PROC_DB_FLT_PXI_THRD     0x7025
#define OSD4_PROC_DB_FLT_SEED_Y       0x7026
#define OSD4_PROC_DB_FLT_SEED_U       0x7027
#define OSD4_PROC_DB_FLT_SEED_V       0x7028
#define OSD4_PROC_DB_FLT_SEED3        0x7029
#define OSD4_PROC_DB_FLT_SEED4        0x702a
#define OSD4_PROC_DB_FLT_SEED5        0x702b

/* osd sys regs */
#define OSD1_PROC_IN_SIZE                0x6061
#define OSD2_PROC_IN_SIZE                0x6062
#define OSD3_PROC_IN_SIZE                0x6063
#define OSD4_PROC_IN_SIZE                0x6064
#define OSD1_PROC_OUT_SIZE               0x6065
#define OSD2_PROC_OUT_SIZE               0x6066
#define OSD3_PROC_OUT_SIZE               0x6067
#define OSD4_PROC_OUT_SIZE               0x6068
#define OSD_BLEND_DOUT0_SIZE             0x6069
#define OSD_BLEND_DOUT1_SIZE             0x606a

#define VPP_HL_COLOR                     0x606d
#define VPP_RO_PROBE_COLOR               0x6070
#define VPP_RO_PROBE_COLOR1              0x6071
#define OSD_PROC_1MUX3_SEL               0x6072
#define OSD_2SLICE2PPC_IN_SIZE           0x6073
#define OSD_2SLICE2PPC_MODE              0x6074
#define OSD_2SLICE2PPC_GC_CTRL           0x6075
#define OSD_PI_BYPASS_EN                 0x6076
#define OSD_DOLBY_BYPASS_EN              0x6077
#define OSD_SYS_5MUX4_SEL                0x6078
#define OSD_SYS_HWIN0_CUT                0x6079
#define OSD_SYS_HWIN1_CUT                0x607a
#define OSD_SYS_PAD_CTRL                 0x607b
#define OSD_SYS_PAD_DUMMY_DATA0          0x607c
#define OSD_SYS_PAD_DUMMY_DATA1          0x607d
#define OSD_SYS_PAD_H_SIZE               0x607e
#define OSD_SYS_PAD_V_SIZE               0x607f
#define OSD_SYS_2SLICE_HWIN_CUT          0x6080

/* vpp_intf_top */
#define VPP_INTF_OSD1_CTRL               0x4105
#define VPP_INTF_OSD2_CTRL               0x4106
#define VPP_INTF_OSD3_CTRL               0x4107
#define VPP_INTF_OSD4_CTRL               0x4108

/* s5 osd blend */
#define S5_VIU_OSD_BLEND_CTRL               0x60b0
#define S5_VIU_OSD_BLEND_CTRL1              0x60c0
#define S5_VIU_OSD_BLEND_DIN0_SCOPE_H       0x60b1
#define S5_VIU_OSD_BLEND_DIN0_SCOPE_V       0x60b2
#define S5_VIU_OSD_BLEND_DIN1_SCOPE_H       0x60b3
#define S5_VIU_OSD_BLEND_DIN1_SCOPE_V       0x60b4
#define S5_VIU_OSD_BLEND_DIN2_SCOPE_H       0x60b5
#define S5_VIU_OSD_BLEND_DIN2_SCOPE_V       0x60b6
#define S5_VIU_OSD_BLEND_DIN3_SCOPE_H       0x60b7
#define S5_VIU_OSD_BLEND_DIN3_SCOPE_V       0x60b8
#define S5_VIU_OSD_BLEND_DUMMY_DATA0        0x60b9
#define S5_VIU_OSD_BLEND_DUMMY_ALPHA        0x60ba
#define S5_VIU_OSD_BLEND_BLEND0_SIZE        0x60bb
#define S5_VIU_OSD_BLEND_BLEND1_SIZE        0x60bc

/* vpp post regs */
#define VPP_POST_GCLK_CTRL                  0x1d00
#define VPP_POSTBLEND_H_V_SIZE               0x1d01
#define VPP_POSTBLEND_CTRL                   0x1d02

#define S5_VPP_OSD1_BLD_H_SCOPE             0x1d09
#define S5_VPP_OSD1_BLD_V_SCOPE             0x1d0a
#define S5_VPP_OSD2_BLD_H_SCOPE             0x1d0b
#define S5_VPP_OSD2_BLD_V_SCOPE             0x1d0c

#define S5_VD1_BLEND_SRC_CTRL               0x1d0d
#define S5_VD2_BLEND_SRC_CTRL               0x1d0e
#define S5_VD3_BLEND_SRC_CTRL               0x1d0f
#define S5_OSD1_BLEND_SRC_CTRL              0x1d10
#define S5_OSD2_BLEND_SRC_CTRL              0x1d11

#define VIU_OSD1_MISC                       0x1a15
#define VIU_OSD2_MISC                       0x1a16
#define VIU_OSD3_MISC                       0x1a17
#define VIU_OSD4_MISC                       0x1a18

#define S5_VPP_RDARB_MODE                   0x4120

#define VPP_RDARB_REQEN_SLV0                0x4121
#define VPP_RDARB_REQEN_SLV1                0x4122

#define S5_VPP_MISC                         0x2509
#define S5_VPP_OFIFO_SIZE                   0x2504
#define S5_VPP_OUT_H_V_SIZE                 0x2503

/* for t3x */
#define ENCL_VIDEO_VAVON_LN_RNG             0x14ca

#define OSD_REG_UNSUPPORT                   0xffff

#endif
