/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//#define LOG_NDEBUG 0
#define LOG_TAG "android.hardware.tv.tuner-service.droidlogic"

#include <android-base/logging.h>
#include <android/binder_manager.h>
#include <android/binder_process.h>

#include "Tuner.h"

using ::aidl::android::hardware::tv::tuner::Tuner;

int main() {
    ABinderProcess_setThreadPoolMaxThreadCount(8);
    std::shared_ptr<Tuner> tuner = ndk::SharedRefBase::make<Tuner>();

    binder_status_t status;
    const std::string instance = std::string() + Tuner::descriptor + "/default";
#ifdef LAZY_HAL
    status = AServiceManager_registerLazyService(tuner->asBinder().get(), instance.c_str());
    ALOGD("Start as a lazy HAL");
#else
    status = AServiceManager_addService(tuner->asBinder().get(), instance.c_str());
    ALOGD("Start as a normal HAL");
#endif
    CHECK(status == STATUS_OK);
    tuner->init();

    ABinderProcess_joinThreadPool();
    return EXIT_FAILURE;  // should not reached
}
