/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef DRMPLAYER_ERRORS_H
#define DRMPLAYER_ERRORS_H

#include <sys/types.h>
#include <errno.h>

typedef int32_t     dp_state;

enum {
    OK                = 0,    // Everything's swell.
    NO_ERROR          = 0,    // No errors.

   // UNKNOWN_ERROR       = (-2147483647-1), // INT32_MIN value

    NO_MEMORY           = -ENOMEM,
    INVALID_OPERATION   = -ENOSYS,
    BAD_VALUE           = -EINVAL,
    BAD_TYPE            = (-2147483647-1 + 1),
    NAME_NOT_FOUND      = -ENOENT,
    PERMISSION_DENIED   = -EPERM,
    NO_INIT             = -ENODEV,
    ALREADY_EXISTS      = -EEXIST,
    DEAD_OBJECT         = -EPIPE,
    FAILED_TRANSACTION  = (-2147483647-1 + 2),
#if !defined(_WIN32)
    BAD_INDEX           = -EOVERFLOW,
    NOT_ENOUGH_DATA     = -ENODATA,
    WOULD_BLOCK         = -EWOULDBLOCK,
    TIMED_OUT           = -ETIMEDOUT,
    UNKNOWN_TRANSACTION = -EBADMSG,
#else
    BAD_INDEX           = -E2BIG,
    NOT_ENOUGH_DATA     = (-2147483647-1 + 3),
    WOULD_BLOCK         = (-2147483647-1 + 4),
    TIMED_OUT           = (-2147483647-1 + 5),
    UNKNOWN_TRANSACTION = (-2147483647-1 + 6),
#endif
    FDS_NOT_ALLOWED     = (-2147483647-1 + 7),
    UNEXPECTED_NULL     = (-2147483647-1 + 8),
};

// ---------------------------------------------------------------------------

#endif // ANDROID_ERRORS_H
