/*
**
** Copyright 2018, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#include <android-base/logging.h>
#include <android/hardware/keymaster/4.1/IKeymasterDevice.h>
#include <hidl/HidlTransportSupport.h>
#include <amlogic_keymaster/AmlogicKeymaster.h>
#include <amlogic_keymaster/AmlogicKeymaster41Device.h>

#ifndef KEYMASTER_TEMP_FAILURE_RETRY
#define KEYMASTER_TEMP_FAILURE_RETRY(exp, retry)            \
      ({                                       \
           __typeof__(exp) _rc;                   \
           int count = 0;                         \
           do {                                   \
             usleep(10000);                        \
             _rc = (exp);                         \
             count ++;                            \
           } while (_rc != 0 && count < retry); \
           _rc;                                   \
         })
#endif

int main() {
    ::android::hardware::configureRpcThreadpool(1, true);
    auto amlKeymaster = new keymaster::AmlogicKeymaster();
    int err = KEYMASTER_TEMP_FAILURE_RETRY(amlKeymaster->Initialize(keymaster::KmVersion::KEYMASTER_4_1), 1000);
    if (err != 0) {
        LOG(FATAL) << "Could not initialize AmlogicKeymaster (" << err << ")";
        return -1;
    }

    auto keymaster = new ::keymaster::V4_1::AmlogicKeymaster41Device(amlKeymaster);

    auto status = keymaster->registerAsService();
    if (status != android::OK) {
        LOG(FATAL) << "Could not register service for Keymaster 4.1 (" << status << ")";
        return -1;
    }

    android::hardware::joinRpcThreadpool();
    return -1;  // Should never get here.
}
