/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "Common.h"

#include <android-base/properties.h>

namespace aidl::android::hardware::graphics::composer3::impl {
namespace meson {

std::string toString(HWC3::Error error) {
    switch (error) {
        case HWC3::Error::None:
            return "None";
        case HWC3::Error::BadConfig:
            return "BadConfig";
        case HWC3::Error::BadDisplay:
            return "BadDisplay";
        case HWC3::Error::BadLayer:
            return "BadLayer";
        case HWC3::Error::BadParameter:
            return "BadParameter";
        case HWC3::Error::NoResources:
            return "NoResources";
        case HWC3::Error::NotValidated:
            return "NotValidated";
        case HWC3::Error::Unsupported:
            return "Unsupported";
        case HWC3::Error::SeamlessNotAllowed:
            return "SeamlessNotAllowed";
        case HWC3::Error::SeamlessNotPossible:
            return "SeamlessNotPossible";
    }
}

}
}  // namespace aidl::android::hardware::graphics::composer3::impl
