/*
 * Copyright (c) 2017 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in the
 * file 'LICENSE' which is part of this source code package.
 *
 * Description:
 */

#ifndef FB_PROCESSOR_H
#define FB_PROCESSOR_H

#include <BasicTypes.h>
#include <DrmFramebuffer.h>

typedef enum {
    FB_DUMMY_PROCESSOR = 0,
    FB_COPY_PROCESSOR,
    FB_KEYSTONE_PROCESSOR,
    FB_AISR_PROCESSOR,
    FB_AIPQ_PROCESSOR,
    FB_RENDER_PROCESSOR,
    FB_DALTON_PROCESSOR,
    FB_AIFACE_PROCESSOR,
    FB_AICOLOR_PROCESSOR,
    FB_DI_PROCESSOR,
} meson_fb_processor_t;

class FbProcessor {
public:
    virtual ~FbProcessor() {}

    virtual int32_t setup() = 0;
    /* non block operation, with process fence */
    virtual int32_t asyncProcess(
        std::shared_ptr<DrmFramebuffer> & inputfb,
        std::shared_ptr<DrmFramebuffer> & outfb,
        int & processFence) = 0;

    /* for non block, let processor aware of release fence */
    virtual int32_t onBufferDisplayed(
        std::shared_ptr<DrmFramebuffer> & outfb,
        int releaseFence) = 0;

    /*block operation, no fence.*/
    virtual int32_t process(
        std::shared_ptr<DrmFramebuffer> & inputfb,
        std::shared_ptr<DrmFramebuffer> & outfb) = 0;
    virtual int32_t teardown() = 0;
    virtual bool updateProcess(std::string params) { UNUSED(params); return false;};
    virtual int32_t composite(
        std::shared_ptr<DrmFramebuffer> & inputUIfb __unused, std::shared_ptr<DrmFramebuffer> & inputWBfb __unused,
        std::shared_ptr<DrmFramebuffer> & outfb __unused) {
        return 0;
    };
    virtual int32_t update(drm_rect_t pos __unused) {
        return 0;
    };
    virtual void enableSyncProtection(bool mode __unused) {return;};

    virtual meson_fb_processor_t getFbProcessorType() = 0;
};

int32_t createFbProcessor(meson_fb_processor_t type, std::shared_ptr<FbProcessor> & processor);

#endif
