/*
 * Copyright (c) 2017 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in the
 * file 'LICENSE' which is part of this source code package.
 *
 * Description:
 */
#ifndef MESON_HWC2_H
#define MESON_HWC2_H

#include <map>
#include <hardware/hardware.h>
#include "HwcDisplayPipe.h"

#include "Hwc2Display.h"
#include "IModePolicy.h"

class MesonHwc2 : public android::Singleton<MesonHwc2> {
/*hwc2 interface*/
public:
    void getCapabilities(uint32_t* outCount, int32_t* outCapabilities);
    int32_t getClientTargetSupport( hwc2_display_t display,
        uint32_t width, uint32_t height, int32_t format, int32_t dataspace);

    int32_t registerCallback(int32_t descriptor,
        hwc2_callback_data_t callbackData, hwc2_function_pointer_t pointer);

    /*Virtual display functions*/
    int32_t createVirtualDisplay(uint32_t width, uint32_t height,
        int32_t* format, hwc2_display_t* outDisplay);
    int32_t destroyVirtualDisplay(hwc2_display_t display);
    uint32_t getMaxVirtualDisplayCount();

    /*display functions*/
    int32_t  acceptDisplayChanges(hwc2_display_t display);
    int32_t getActiveConfig(hwc2_display_t display, hwc2_config_t* outConfig);
    int32_t  getDisplayConfigs(hwc2_display_t display,
        uint32_t* outNumConfigs, hwc2_config_t* outConfigs);

    int32_t  getColorModes(hwc2_display_t display, uint32_t* outNumModes,
        int32_t*  outModes);
    int32_t  getDisplayAttribute( hwc2_display_t display, hwc2_config_t config,
        int32_t attribute, int32_t* outValue);
    int32_t getDisplayName(hwc2_display_t display, uint32_t* outSize, char* outName);
    int32_t getDisplayRequests(hwc2_display_t display,
        int32_t* outDisplayRequests, uint32_t* outNumElements,
        hwc2_layer_t* outLayers, int32_t* outLayerRequests);
    int32_t  getDisplayType(hwc2_display_t display, int32_t* outType);
    int32_t getDozeSupport(hwc2_display_t display, int32_t* outSupport);
    int32_t getHdrCapabilities(hwc2_display_t display, uint32_t* outNumTypes,
        int32_t* outTypes, float* outMaxLuminance,
        float* outMaxAverageLuminance, float* outMinLuminance);
    int32_t presentDisplay(hwc2_display_t display, int32_t* outPresentFence);
    int32_t setActiveConfig(hwc2_display_t display, hwc2_config_t config);
    int32_t setClientTarget(hwc2_display_t display, buffer_handle_t target,
        int32_t acquireFence, int32_t dataspace, hwc_region_t damage);
    int32_t setColorMode(hwc2_display_t display, int32_t mode);
    int32_t setColorTransform(hwc2_display_t display, const float* matrix,
        int32_t hint);
    int32_t setOutputBuffer(hwc2_display_t display, buffer_handle_t buffer,
        int32_t releaseFence);
    int32_t setPowerMode(hwc2_display_t display, int32_t mode);
    int32_t setVsyncEnable(hwc2_display_t display, int32_t enabled);
    int32_t getReleaseFences(hwc2_display_t display, uint32_t* outNumElements,
        hwc2_layer_t* outLayers, int32_t* outFences);
    int32_t validateDisplay(hwc2_display_t display, uint32_t* outNumTypes,
        uint32_t* outNumRequests);
    int32_t getChangedCompositionTypes(hwc2_display_t display,
        uint32_t* outNumElements, hwc2_layer_t* outLayers, int32_t*  outTypes);
    int32_t setCalibrateInfo(hwc2_display_t display);
    int32_t setPerferredMode(std::string mode);
    int32_t setColorSpace(std::string colorspace);
    int32_t clearUserDisplayConfig();
    int32_t setDvMode(std::string dv_mode);

    /*layer functions*/
    int32_t createLayer(hwc2_display_t display, hwc2_layer_t* outLayer);
    int32_t destroyLayer(hwc2_display_t display, hwc2_layer_t layer);
    int32_t setCursorPosition(hwc2_display_t display, hwc2_layer_t layer,
        int32_t x, int32_t y);
    int32_t setLayerBuffer(hwc2_display_t display, hwc2_layer_t layer,
        buffer_handle_t buffer, int32_t acquireFence);
    int32_t setLayerSurfaceDamage(hwc2_display_t display, hwc2_layer_t layer,
        hwc_region_t damage);
    int32_t setLayerBlendMode(hwc2_display_t display, hwc2_layer_t layer,
        int32_t mode);
    int32_t setLayerColor(hwc2_display_t display, hwc2_layer_t layer,
        hwc_color_t color);
    int32_t setLayerCompositionType(hwc2_display_t display, hwc2_layer_t layer,
        int32_t type);
    int32_t setLayerDataspace(hwc2_display_t display, hwc2_layer_t layer,
        int32_t dataspace);
    int32_t setLayerDisplayFrame(hwc2_display_t display, hwc2_layer_t layer,
        hwc_rect_t frame);
    int32_t setLayerPlaneAlpha(hwc2_display_t display, hwc2_layer_t layer,
        float alpha);
    int32_t setLayerSidebandStream(hwc2_display_t display, hwc2_layer_t layer,
        const native_handle_t* stream);
    int32_t setLayerSourceCrop(hwc2_display_t display, hwc2_layer_t layer,
        hwc_frect_t crop);
    int32_t setLayerTransform(hwc2_display_t display, hwc2_layer_t layer,
        int32_t transform);
    int32_t setLayerVisibleRegion(hwc2_display_t display, hwc2_layer_t layer,
        hwc_region_t visible);
    int32_t  setLayerZorder(hwc2_display_t display, hwc2_layer_t layer,
        uint32_t z);

    int32_t setLayerPerFrameMetadata(
            hwc2_display_t display, hwc2_layer_t layer,
            uint32_t numElements, const int32_t* /*hw2_per_frame_metadata_key_t*/ keys,
            const float* metadata);
    int32_t getPerFrameMetadataKeys(
            hwc2_display_t display,
            uint32_t* outNumKeys,
            int32_t* /*hwc2_per_frame_metadata_key_t*/ outKeys);

    int32_t getRenderIntents(hwc2_display_t display,
            int32_t mode, uint32_t* outNumIntents, int32_t* outIntents);
    int32_t setColorModeWithRenderIntent (hwc2_display_t display,
            int32_t mode, int32_t intent);


    int32_t getDisplayIdentificationData(hwc2_display_t display, uint8_t* outPort,
            uint32_t* outDataSize, uint8_t* outData);
    int32_t getDisplayCapabilities(hwc2_display_t display, uint32_t* outNumCapabilities, uint32_t* outCapabilities);
    int32_t getDisplayBrightnessSupport(hwc2_display_t display, bool* outSupport);
    int32_t setDisplayBrightness(hwc2_display_t display, float brightness);

    int32_t getDisplayConnectionType(hwc2_display_t display, uint32_t* outType);
    int32_t getDisplayVsyncPeriod(hwc2_display_t display, hwc2_vsync_period_t* outVsyncPeriod);
    int32_t setActiveConfigWithConstraints(hwc2_display_t display, hwc2_config_t config,
            hwc_vsync_period_change_constraints_t* vsyncPeriodChangeConstraints,
            hwc_vsync_period_change_timeline_t* outTimeline);
    int32_t setAutoLowLatencyMode(hwc2_display_t display, bool on);
    int32_t getSupportedContentTypes (hwc2_display_t display, uint32_t* outNum, uint32_t* outSupportedContentTypes);
    int32_t setContentType(hwc2_display_t display, uint32_t contentType);

    /* hwc3 */
    int32_t setBootDisplayConfig(hwc2_display_t display, uint32_t config);
    int32_t clearBootDisplayConfig(hwc2_display_t display);
    int32_t getPreferredBootDisplayConfig(hwc2_display_t display, int32_t* config);
    int32_t getDisplayPhysicalOrientation(hwc2_display_t display, int32_t* outOrientation);
    int32_t setExpectedPresentTime(hwc2_display_t display, int64_t expectedPresentTime);
    int32_t setLayerBrightness(hwc2_display_t display, hwc2_layer_t layer, float brightness);
    int32_t setAidlClientPid(int32_t pid);

    /* hwc3.2*/
    int32_t getHdrConversionCapabilities(uint32_t* outNumCapability,
                drm_hdr_conversion_capability_t* outConversionCapability);
    int32_t setHdrConversionStrategy(bool passThrough, uint32_t numElements, bool isAuto,
                uint32_t* autoAllowedHdrTypes, uint32_t* preferredHdrOutputType);
    int32_t getOverlaySupport(uint32_t* numElements,
                uint32_t* pixelFormats);

    void dump(uint32_t* outSize, char* outBuffer);

/*amlogic ext display interface*/
public:
    int32_t setPostProcessor(bool bEnable);

    uint32_t getDisplayRequest();
    int32_t handleDisplayRequest(uint32_t request);
    bool getDisplayVsyncAndPeriod(int64_t& timestamp, int32_t& vsyncPeriodNanos);

/*implement*/
public:
    void refresh(hwc2_display_t  display);
    void onVsync(hwc2_display_t display, int64_t timestamp, uint32_t vsyncPeriodNanos);
    void onHotplug(hwc2_display_t display, bool connected);
    void onVsyncPeriodTimingChanged(hwc2_display_t display, hwc_vsync_period_change_timeline_t* updatedTimeline);

public:
    MesonHwc2();
    virtual ~MesonHwc2();

/* for meson display service */
public:
    int32_t captureDisplayScreen(buffer_handle_t hnd);
    int32_t getWhiteBoardHanle(native_handle_t** hnd);
    bool setWriteBoardMode(bool mode, int callingPid);
    bool getWriteBoardMode(bool& mode);
    bool setWBDisplayFrame(int x, int y);
    bool hideVideoLayer(bool hide);
    bool setViewPort(const drm_rect_wh_t viewPort);
    void getViewPort(drm_rect_wh_t& viewPort);
    bool setFrameRateHint(std::string value);
    bool setKeystoneCorrection(std::string params);
    bool setReverseMode(int type);
    int32_t getDisplays(std::map<hwc2_display_t, shared_ptr<Hwc2Display>> & displays);
    int32_t setFrameRate(float value);
    std::shared_ptr<HwcDisplayPipe> mDisplayPipe;
    bool enableSyncProtection(bool mode);
    bool disableSideband(bool isDisable);

    int mCallingPid = -1;
    bool mWhiteBoardMode = false;

protected:
    int32_t initialize();
    bool isDisplayValid(hwc2_display_t display);

    uint32_t getVirtualDisplayId();
    void freeVirtualDisplayId(uint32_t id);
    std::string mKeystoneConfigs = "0";

protected:
    std::map<hwc2_display_t, std::shared_ptr<Hwc2Display>> mDisplays;

    HWC2_PFN_HOTPLUG mHotplugFn;
    hwc2_callback_data_t mHotplugData;
    HWC2_PFN_REFRESH mRefreshFn;
    hwc2_callback_data_t mRefreshData;
    HWC2_PFN_VSYNC mVsyncFn;
    hwc2_callback_data_t mVsyncData;
    HWC2_PFN_VSYNC_2_4 mVsync24Fn;
    hwc2_callback_data_t mVsync24Data;
    HWC2_PFN_VSYNC_PERIOD_TIMING_CHANGED mVsyncPeriodTimingChangedFn;
    hwc2_callback_data_t mVsyncPeriodData;

    uint32_t mVirtualDisplayIds;

    uint32_t mDisplayRequests;
    /* meson display */
    drm_rect_wh_t mViewPort;
    bool mChangedViewPort;

    std::shared_ptr<IModePolicy> mModePolicy;
};

#endif/*MESON_HWC2_H*/
