/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in the
 * file 'LICENSE' which is part of this source code package.
 *
 * Description:
 */

#ifndef HWC_DISPLAY_PIPE_H
#define HWC_DISPLAY_PIPE_H

#include <BasicTypes.h>
#include <HwDisplayConnector.h>
#include <HwDisplayCrtc.h>
#include <HwDisplayEventListener.h>
#include <HwcDisplay.h>
#include <HwcVsync.h>
#include <HwcPostProcessor.h>
#include <HwcModeMgr.h>

#include <MesonLog.h>
#include <unordered_map>
#include <VdinPostProcessor.h>

typedef enum {
    /*primary:
    viu1 + connector from config*/
    HWC_PIPE_DEFAULT = 0,

    /* two display:
    viu1 + connector from config
    extend:
    viu2 + connector from config*/
    HWC_PIPE_DUAL,

    /*primary:
        when postprocessor disable: viu1 -> connector
        when postprocessor enable: viu1->vdin->viu2->connector
    extend:
        NONE*/
    HWC_PIPE_LOOPBACK,

    HWC_PIPE_MULTI,

} hwc_pipe_policy_t;

/*requests*/
enum {
    rPostProcessorStart = 1 << 0,
    rPostProcessorStop = 1 << 1,
    rPostProcessorStartExt = 1 << 2,
    rPostProcessorStopExt  = 1 << 3,

    rDisplayModeSet = 1 << 4,
    rDisplayModeSetExt = 1 << 5,

    rCalibrationSet = 1 << 6,
    rCalibrationSetExt = 1 << 7,

    rKeystoneEnable = 1 << 8,
    rKeystoneDisable = 1 << 9,

    r3DModeEnable = 1 << 10,
    r3DModeDisable = 1 << 11,

    rPostProcessorRestart = 1 << 12,
};

/*events*/
enum {
    eHdmiPlugIn = 1 << 0,
    eHdmiPlugOut = 1<< 1,

    eDisplayModeChange = 1 << 2,
    eDisplayModeExtChange = 1 << 3,
};

class HwcDisplayPipe :  public HwDisplayEventHandler {
public:
    HwcDisplayPipe();
    virtual ~HwcDisplayPipe();

    virtual int32_t init(std::map<uint32_t, std::shared_ptr<HwcDisplay>> & hwcDisps);
    virtual int32_t handleRequest(uint32_t flags);
    virtual void handleEvent(drm_display_event event, int val);
    virtual void dump(String8 & dumpstr);
    virtual void lateInit(){};
    bool hasDummyConnector();
    virtual void addVirtualDisplay(std::shared_ptr<HwcDisplay> disp __unused);
    std::shared_ptr<VdinPostProcessor> mVdinPostProcessor;

protected:
    class PipeCfg {
    public:
    /*use pipe id, for crtc id may change.*/
        uint32_t hwcPipeIdx;
        uint32_t modePipeIdx;
        drm_connector_type_t hwcConnectorType;
        drm_connector_type_t modeConnectorType;
        hwc_post_processor_t hwcPostprocessorType;
    };

    class PipeStat {
    public:
        PipeStat(uint32_t hwc_id);
        ~PipeStat();

        uint32_t hwcId;
        PipeCfg cfg;

        std::shared_ptr<HwcDisplay> hwcDisplay;
        std::shared_ptr<HwcDisplay> hwcVirtualDisplay;
        std::shared_ptr<HwDisplayCrtc> hwcCrtc;
        std::vector<std::shared_ptr<HwDisplayPlane>> hwcPlanes;
        std::shared_ptr<HwDisplayConnector> hwcConnector;
        std::shared_ptr<HwcVsync> hwcVsync;
        // for videotunnel thread
        std::shared_ptr<HwcVsync> hwcVtVsync;
        std::shared_ptr<HwcPostProcessor> hwcPostProcessor;
        std::shared_ptr<HwcPostProcessor> hwcVIRPostProcessor;
        std::shared_ptr<HwcVsync> hwcWBVsync;

        std::shared_ptr<HwcModeMgr> modeMgr;
        std::shared_ptr<HwDisplayCrtc> modeCrtc;
        std::shared_ptr<HwDisplayConnector> modeConnector;
    };

protected:
    /*load display pipe config*/
    virtual int32_t updatePipe(std::shared_ptr<PipeStat> & stat);
    virtual int32_t getPipeCfg(uint32_t hwcid, PipeCfg & cfg) = 0;
    virtual drm_connector_type_t getConnectorCfg(uint32_t hwcid);

    virtual int32_t initDisplayMode(std::shared_ptr<PipeStat> & stat);

    /*load display resource*/
    int32_t getPlanes(
        uint32_t pipeidx, std::vector<std::shared_ptr<HwDisplayPlane>> & planes);
    int32_t getConnector(
        drm_connector_type_t type, std::shared_ptr<HwDisplayConnector> & connector);
    virtual int32_t getPostProcessor(
        hwc_post_processor_t type, std::shared_ptr<HwcPostProcessor> & processor);

protected:
    std::unordered_multimap<uint32_t, std::shared_ptr<HwDisplayPlane>> mPlanesForPipe;
    std::map<drm_connector_type_t, std::shared_ptr<HwDisplayConnector>> mConnectors;
    std::map<uint32_t, std::shared_ptr<PipeStat>> mPipeStats;
    std::mutex mMutex;
};

std::shared_ptr<HwcDisplayPipe> createDisplayPipe(hwc_pipe_policy_t pipet);

#endif
