/*
 * Copyright (c) 2018 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in the
 * file 'LICENSE' which is part of this source code package.
 *
 * Description:
 */

#ifndef ACTIVE_MODE_MGR_H
#define ACTIVE_MODE_MGR_H

#include "HwcModeMgr.h"

/*
 * ActiveModeMgr:
 * This class designed for removeable device(hdmi, cvbs)
 * to support real activeModes.
 * Config list will changed when device disconnect/connect.
 */
class  ActiveModeMgr : public  HwcModeMgr {
public:
     ActiveModeMgr();
    ~ ActiveModeMgr();

    hwc_modes_policy_t getPolicyType();
    const char * getName();

    void setFramebufferSize(uint32_t w, uint32_t h);
    void setDisplayResources(
        std::shared_ptr<HwDisplayCrtc> & crtc,
        std::shared_ptr<HwDisplayConnector> & connector);
    int32_t update();
    bool needCallHotPlug(){return mCallOnHotPlug;};
    int32_t getDisplayMode(drm_mode_info_t & mode);

    int32_t  getDisplayConfigs(
        uint32_t* outNumConfigs, uint32_t * outConfigs);
    int32_t  getDisplayAttribute(
        uint32_t config, int32_t attribute, int32_t* outValue, int32_t caller);
    int32_t getActiveConfig(uint32_t * outConfig, int32_t caller);
    int32_t setActiveConfig(uint32_t configId);
    bool isSeamlessSwitch(uint32_t config);
    int32_t getPreferredBootConfig(int32_t* outConfig);
    int32_t setBootConfig(int32_t config);
    int32_t clearBootConfig();
    void resetTags();
    void dump(String8 & dumpstr);

    bool is16_9Mode(drm_mode_info_t mode __unused) {return false;}
    int32_t setPerferredMode(std::string mode) {
        UNUSED(mode);
        return HWC2_ERROR_NONE;
    };

protected:
    int32_t updateSfDispConfigs();
    int32_t updateHwcActiveConfig(drm_mode_info_t activeMode);
    int32_t updateSfActiveConfig(uint32_t config, drm_mode_info_t cfg);
    bool isFracRate(float refreshRate);
    void reset();
    const drm_mode_info_t findMatchedMode(
        uint32_t width, uint32_t height, float refreshrate);
    int32_t setModeLocked(uint32_t & configId, drm_mode_info_t & mode);

protected:
    std::shared_ptr<HwDisplayConnector> mConnector;
    std::shared_ptr<HwDisplayCrtc> mCrtc;

    uint32_t mFbWidth;
    uint32_t mFbHeight;

    bool mCallOnHotPlug;
    drm_mode_info_t mLastActiveMode;
    std::mutex mMutex;

    // Used for HWC
    uint32_t mHwcActiveConfigId;
    std::map<uint32_t, drm_mode_info_t> mHwcActiveModes;

    // Passed to SF
    uint32_t mSfActiveConfigId;
    std::map<uint32_t, drm_mode_info_t> mSfActiveModes;

    // Dolby Vision enabled or not
    bool mDvEnabled;
};

#endif/*ACTIVE_MODE_MGR_H*/
