/*
 * Copyright (c) 2017 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in the
 * file 'LICENSE' which is part of this source code package.
 *
 * Description:
 */

#ifndef VIDEO_COMPOSER_DEV_H
#define VIDEO_COMPOSER_DEV_H

#include <BasicTypes.h>
#include <stdlib.h>
#include <DrmFramebuffer.h>

typedef uint32_t u32;

#define VIDEO_COMPOSER_IOC_MAGIC  'V'
#define VIDEO_COMPOSER_IOCTL_SET_FRAMES   _IOW(VIDEO_COMPOSER_IOC_MAGIC, 0x00, video_frames_info_t)
#define VIDEO_COMPOSER_IOCTL_SET_ENABLE   _IOW(VIDEO_COMPOSER_IOC_MAGIC, 0x01, int)
#define VIDEO_COMPOSER_IOCTL_SET_DISABLE  _IOW(VIDEO_COMPOSER_IOC_MAGIC, 0x02, int)
#define VIDEO_COMPOSER_IOCTL_GET_PANEL_CAPABILITY   _IOR(VIDEO_COMPOSER_IOC_MAGIC, 0x03, int)
#define VIDEO_COMPOSER_IOCTL_GET_LAYER_CAPABILITY _IOR(VIDEO_COMPOSER_IOC_MAGIC, 0x04, capability_info_t)

#define MAX_LAYER_COUNT 9

enum source_type_t {
    DTV_FIX_TUNNEL = 1,
    HWC_CREAT_ION = 2,
};

enum buffer_format_t {
    NV21 = 0,
    YUV444 = 1,
};

typedef struct video_frame_info {
    int32_t fd;
    int32_t composer_fen_fd;
    int32_t disp_fen_fd;
    u32 buffer_w;
    u32 buffer_h;
    u32 dst_x;
    u32 dst_y;
    u32 dst_w;
    u32 dst_h;
    u32 crop_x;
    u32 crop_y;
    u32 crop_w;
    u32 crop_h;
    u32 zorder;
    u32 transform;
    u32 type;
    u32 sideband_type;
    u32 stride_in_pixel;
    u32 aligned_height;
    u32 source_type;
    u32 bufferFormat;
    u32 reserved[5];
} video_frame_info_t;

typedef struct video_frames_info {
    u32 frame_count;
    video_frame_info_t frame_info[MAX_LAYER_COUNT];
    u32 layer_index; /*useless member, always set to 0 now.*/
    u32 disp_zorder;
    u32 reserved[4];
} video_frames_info_t;

typedef struct capability_info {
    u32 capability;
    u32 min_w;
    u32 min_h;
    u32 max_w;
    u32 max_h;
    u32 reserved[10];
} capability_info_t;

class VideoComposerDev {
public:
    VideoComposerDev(int drvFd);
    ~VideoComposerDev();

    int32_t enable(bool bEnable);
    int32_t setFrame(std::shared_ptr<DrmFramebuffer> & fb, int & releaseFence, uint32_t z);
    int32_t setFrames(std::vector<std::shared_ptr<DrmFramebuffer>> & composefbs, int & releaseFence, uint32_t z);

protected:
    int mDrvFd;
    video_frames_info_t mVideoFramesInfo;
    bool mEnable;
};

int createVideoComposerDev(int fd, int idx);
std::shared_ptr<VideoComposerDev> getVideoComposerDev(int idx);
std::map<int,std::shared_ptr<VideoComposerDev>> getVideoComposerDevByDisplayId(int displayId);

#endif
