/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_MEM_INFO_T stDstBgModel1;
    CVE_MEM_INFO_T stDstBgModel2;
    CVE_MEM_INFO_T stDstStatData;

    CVE_UPDATE_BG_MODEL_CTRL_T stUpdateBgModelCtrl;

    FILE *pFpSrc;
    FILE *pFpDstModel1;
    FILE *pFpDstModel2;
    FILE *pFpDstStat;
} SAMPLE_CVE_UpDateBgModel_INFO_T;

SAMPLE_CVE_UpDateBgModel_INFO_T stUpdateBgModelInfo;

void SAMPLE_CVE_UpdateBgModelCaseList(void)
{
    printf("\t\t  0) Down Sample mode, mode=0\n");
    printf("\t\t  1) Down Sample mode, mode=1 2x2\n");
    printf("\t\t  2) Down Sample mode, mode=2 4x4\n");
    return;
}

static AML_VOID
SAMPLE_CVE_UpdateBgModelUninit(SAMPLE_CVE_UpDateBgModel_INFO_T *pstUpdateBgModelInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstUpdateBgModelInfo->stDstBgModel1,
                                                pstUpdateBgModelInfo->pFpDstModel1);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst1 Mem Info failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstUpdateBgModelInfo->stDstBgModel2,
                                                pstUpdateBgModelInfo->pFpDstModel2);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst2 Mem Info failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstUpdateBgModelInfo->stDstStatData,
                                                pstUpdateBgModelInfo->pFpDstStat);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst stat Mem Info failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstUpdateBgModelInfo->stSrc.au64PhyAddr[0],
                 pstUpdateBgModelInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstBgModel1.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstBgModel1.u64VirAddr);
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstBgModel2.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstBgModel2.u64VirAddr);
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstStatData.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstStatData.u64VirAddr);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpSrc);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstModel1);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstModel2);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstStat);
}

static AML_S32 SAMPLE_CVE_UpdateBgModelInit(SAMPLE_CVE_UpDateBgModel_INFO_T *pstUpdateBgModelInfo,
                                            AML_CHAR *pchSrcFileName, AML_CHAR *pchDst1FileName,
                                            AML_CHAR *pchDst2FileName, AML_CHAR *pchDstStatFileName,
                                            AML_U32 u32Width, AML_U32 u32Height)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstUpdateBgModelInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstUpdateBgModelInfo->stDstBgModel1, 0, sizeof(CVE_MEM_INFO_T));
    memset(&pstUpdateBgModelInfo->stDstBgModel2, 0, sizeof(CVE_MEM_INFO_T));
    memset(&pstUpdateBgModelInfo->stDstStatData, 0, sizeof(CVE_MEM_INFO_T));

    CVE_OPEN_FILE(pstUpdateBgModelInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstUpdateBgModelInfo->pFpDstModel1, pchDst1FileName, "w");
    CVE_OPEN_FILE(pstUpdateBgModelInfo->pFpDstModel2, pchDst2FileName, "w");
    CVE_OPEN_FILE(pstUpdateBgModelInfo->pFpDstStat, pchDstStatFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstUpdateBgModelInfo->stSrc, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_UPDATEBG_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstUpdateBgModelInfo->stDstBgModel1,
                                           u32Width * u32Height * 16);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem1 failed!\n", s32Ret);
        goto CVE_UPDATEBG_EXIT2;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstUpdateBgModelInfo->stDstBgModel2,
                                           u32Width * u32Height * 16);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem2 failed!\n", s32Ret);
        goto CVE_UPDATEBG_EXIT3;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstUpdateBgModelInfo->stDstStatData,
                                           sizeof(CVE_BG_STAT_DATA_T));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem2 failed!\n", s32Ret);
        goto CVE_UPDATEBG_EXIT4;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstUpdateBgModelInfo->stSrc, pstUpdateBgModelInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Cur Image failed!\n", s32Ret);
        goto CVE_UPDATEBG_EXIT5;
    }
    goto CVE_UPDATEBG_EXIT0;

CVE_UPDATEBG_EXIT5:
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstStatData.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstStatData.u64VirAddr);
CVE_UPDATEBG_EXIT4:
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstBgModel2.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstBgModel2.u64VirAddr);
CVE_UPDATEBG_EXIT3:
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stDstBgModel1.u64PhyAddr,
                 pstUpdateBgModelInfo->stDstBgModel1.u64VirAddr);
CVE_UPDATEBG_EXIT2:
    CVE_PMZ_FREE(pstUpdateBgModelInfo->stSrc.au64PhyAddr[0],
                 pstUpdateBgModelInfo->stSrc.au64VirAddr[0]);
CVE_UPDATEBG_EXIT1:
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpSrc);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstModel1);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstModel2);
    CVE_CLOSE_FILE(pstUpdateBgModelInfo->pFpDstStat);
CVE_UPDATEBG_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_UpdateBgModelProc(SAMPLE_CVE_UpDateBgModel_INFO_T *pstUpdateBgModelInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_UpdateBgModel(
        &cveHandle, &pstUpdateBgModelInfo->stSrc, &pstUpdateBgModelInfo->stDstBgModel1,
        &pstUpdateBgModelInfo->stDstBgModel2, &pstUpdateBgModelInfo->stDstStatData,
        &pstUpdateBgModelInfo->stUpdateBgModelCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE UpdateBgModel Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE UpdateBgmodel Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_UpdateBgModelCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    CVE_UPDATE_BG_MODEL_CTRL_T *pstUpdateBgModelCtrl = &stUpdateBgModelInfo.stUpdateBgModelCtrl;
    AML_CHAR *SrcName = "/data/cve/hall_1_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDst1Name = "/data/cve/updatebgmodel1.out";
    AML_CHAR *pFpDst2Name = "/data/cve/updatebgmodel2.out";
    AML_CHAR *pFpDstStatName = "/data/cve/updatebgstat.out";

    stUpdateBgModelInfo.stUpdateBgModelCtrl.stCrop.enCrop = AML_FALSE;
    stUpdateBgModelInfo.stUpdateBgModelCtrl.stCrop.u16X = 0;
    stUpdateBgModelInfo.stUpdateBgModelCtrl.stCrop.u16Y = 0;
    stUpdateBgModelInfo.stUpdateBgModelCtrl.stCrop.u16Width = 200;
    stUpdateBgModelInfo.stUpdateBgModelCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] update bg mode case 0: ds mode=0.\n");
        pstUpdateBgModelCtrl->enDownScaleMode = CVE_UPDATE_BG_MODEL_DOWN_SCALE_MODE_DISABLE;
        break;
    case 1:
        TEST_PRT("[INFO] update bg mode case 1: ds mode=1.\n");
        pstUpdateBgModelCtrl->enDownScaleMode = CVE_UPDATE_BG_MODEL_DOWN_SCALE_MODE_2X2;
        break;
    case 2:
        TEST_PRT("[INFO] update bg mode case 2: ds mode=2.\n");
        pstUpdateBgModelCtrl->enDownScaleMode = CVE_UPDATE_BG_MODEL_DOWN_SCALE_MODE_4X4;
        break;
    default:
        printf("the update bg model case index is invalid! valid index:\n");
        SAMPLE_CVE_UpdateBgModelCaseList();
        return AML_FAILURE;
    }

    pstUpdateBgModelCtrl->u16DelThr = 1000;
    pstUpdateBgModelCtrl->u16FrqThr = 200;
    pstUpdateBgModelCtrl->u16IntervalThr = 40;
    pstUpdateBgModelCtrl->u0q16LearnRate = 1310;

    printf("please input src img file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src img file name :%s\n", pFpSrcName);
    printf("dst bg1 file name :%s\n", pFpDst1Name);
    printf("dst bg2 file name :%s\n", pFpDst2Name);
    printf("dst stat data file name :%s\n", pFpDstStatName);

    s32Ret = SAMPLE_CVE_UpdateBgModelInit(&stUpdateBgModelInfo, pFpSrcName, pFpDst1Name,
                                          pFpDst2Name, pFpDstStatName, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_UpdateBgModelProc(&stUpdateBgModelInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_UpdateBgModelUninit(&stUpdateBgModelInfo);
    memset(&stUpdateBgModelInfo, 0, sizeof(SAMPLE_CVE_UpDateBgModel_INFO_T));

    return s32Ret;
}
