/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_THRESH_U16_CTRL_T stThrU16Ctrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_THRESH_U16_INFO_T;

SAMPLE_CVE_THRESH_U16_INFO_T stThreshU16Info;

void SAMPLE_CVE_ThreshU16CaseList(void)
{
    printf("\t\t  0) ThreshU16Mode 0: U16 To U8 MIN_MID_MAX.\n");
    printf("\t\t  1) ThreshU16Mode 1: U16 To U8 MIN_ORI_MAX.\n");
    return;
}

static AML_VOID SAMPLE_CVE_ThreshU16Uninit(SAMPLE_CVE_THRESH_U16_INFO_T *pstThreshU16Info)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstThreshU16Info->stDst, pstThreshU16Info->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstThreshU16Info->stSrc.au64PhyAddr[0], pstThreshU16Info->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstThreshU16Info->stDst.au64PhyAddr[0], pstThreshU16Info->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstThreshU16Info->pFpSrc);
    CVE_CLOSE_FILE(pstThreshU16Info->pFpDst);
}

static AML_S32 SAMPLE_CVE_ThreshU16Init(SAMPLE_CVE_THRESH_U16_INFO_T *pstThreshU16Info,
                                        AML_U32 u32Width, AML_U32 u32Height,
                                        AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstThreshU16Info->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstThreshU16Info->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstThreshU16Info->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstThreshU16Info->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshU16Info->stSrc, CVE_IMAGE_TYPE_U16C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_THRESH_U16_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshU16Info->stDst, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_THRESH_U16_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstThreshU16Info->stSrc, pstThreshU16Info->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src2 Image failed!\n", s32Ret);
        goto CVE_THRESH_U16_EXIT3;
    }

    goto CVE_THRESH_U16_EXIT0;

CVE_THRESH_U16_EXIT3:
    CVE_PMZ_FREE(pstThreshU16Info->stDst.au64PhyAddr[0], pstThreshU16Info->stDst.au64VirAddr[0]);
CVE_THRESH_U16_EXIT2:
    CVE_PMZ_FREE(pstThreshU16Info->stSrc.au64PhyAddr[0], pstThreshU16Info->stSrc.au64VirAddr[0]);
CVE_THRESH_U16_EXIT1:
    CVE_CLOSE_FILE(pstThreshU16Info->pFpSrc);
    CVE_CLOSE_FILE(pstThreshU16Info->pFpDst);
CVE_THRESH_U16_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_ThreshU16Proc(SAMPLE_CVE_THRESH_U16_INFO_T *pstThreshU16Info)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_Thresh_U16(&cveHandle, &pstThreshU16Info->stSrc, &pstThreshU16Info->stDst,
                            &pstThreshU16Info->stThrU16Ctrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE ThreshU16 Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE ThreshU16 Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_ThreshU16Case(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 704;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    CVE_THRESH_U16_CTRL_T *pstThrU16Ctrl = &stThreshU16Info.stThrU16Ctrl;
    AML_CHAR *SrcName = "/data/cve/00_704x576.u16";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/ThreshU16.out";

    stThreshU16Info.stThrU16Ctrl.stCrop.enCrop = AML_FALSE;
    stThreshU16Info.stThrU16Ctrl.stCrop.u16X = 0;
    stThreshU16Info.stThrU16Ctrl.stCrop.u16Y = 0;
    stThreshU16Info.stThrU16Ctrl.stCrop.u16Width = 200;
    stThreshU16Info.stThrU16Ctrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] ThreshU16Mode 0: U16 To U8 MIN_MID_MAX\n");
        pstThrU16Ctrl->enMode = CVE_THRESH_U16_MODE_U16_TO_U8_MIN_MID_MAX;
        pstThrU16Ctrl->u8MaxVal = 255;
        pstThrU16Ctrl->u8MidVal = 130;
        pstThrU16Ctrl->u8MinVal = 0;
        pstThrU16Ctrl->u16LowThr = 40;
        pstThrU16Ctrl->u16HighThr = 280;

        break;
    case 1:
        TEST_PRT("[INFO] ThreshU16Mode 1: U16 To U8 MIN_ORI_MAX\n");
        pstThrU16Ctrl->enMode = CVE_THRESH_U16_MODE_U16_TO_U8_MIN_ORI_MAX;
        pstThrU16Ctrl->u8MaxVal = 255;
        pstThrU16Ctrl->u8MidVal = 130;
        pstThrU16Ctrl->u8MinVal = 0;
        pstThrU16Ctrl->u16LowThr = 40;
        pstThrU16Ctrl->u16HighThr = 255;
        break;
    default:
        printf("the threshU16 case index is invalid! valid index:\n");
        SAMPLE_CVE_ThreshU16CaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src1 file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret =
        SAMPLE_CVE_ThreshU16Init(&stThreshU16Info, u32Width, u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshU16Init failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_ThreshU16Proc(&stThreshU16Info);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshU16Proc failed!\n", s32Ret);
    }

    SAMPLE_CVE_ThreshU16Uninit(&stThreshU16Info);
    memset(&stThreshU16Info, 0, sizeof(SAMPLE_CVE_THRESH_U16_INFO_T));

    return s32Ret;
}
