/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_THRESH_S16_CTRL_T stThrS16Ctrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_THRESH_S16_INFO_T;

SAMPLE_CVE_THRESH_S16_INFO_T stThreshS16Info;

void SAMPLE_CVE_ThreshS16CaseList(void)
{
    printf("\t\t  0) ThreshS16Mode 0: S16ToS8 MIN_MID_MAX.\n");
    printf("\t\t  1) ThreshS16Mode 1: S16ToS8 MIN_ORI_MAX.\n");
    printf("\t\t  2) ThreshS16Mode 2: S16ToU8 MIN_MID_MAX.\n");
    printf("\t\t  3) ThreshS16Mode 3: S16ToU8 MIN_ORI_MAX.\n");
    return;
}

static AML_VOID SAMPLE_CVE_ThreshS16Uninit(SAMPLE_CVE_THRESH_S16_INFO_T *pstThreshS16Info)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstThreshS16Info->stDst, pstThreshS16Info->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstThreshS16Info->stSrc.au64PhyAddr[0], pstThreshS16Info->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstThreshS16Info->stDst.au64PhyAddr[0], pstThreshS16Info->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstThreshS16Info->pFpSrc);
    CVE_CLOSE_FILE(pstThreshS16Info->pFpDst);
}

static AML_S32 SAMPLE_CVE_ThreshS16Init(SAMPLE_CVE_THRESH_S16_INFO_T *pstThreshS16Info,
                                        CVE_IMAGE_TYPE_E enDstType, AML_U32 u32Width,
                                        AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                        AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstThreshS16Info->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstThreshS16Info->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstThreshS16Info->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstThreshS16Info->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshS16Info->stSrc, CVE_IMAGE_TYPE_S16C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_THRESH_S16_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshS16Info->stDst, enDstType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_THRESH_S16_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstThreshS16Info->stSrc, pstThreshS16Info->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_THRESH_S16_EXIT3;
    }

    goto CVE_THRESH_S16_EXIT0;

CVE_THRESH_S16_EXIT3:
    CVE_PMZ_FREE(pstThreshS16Info->stDst.au64PhyAddr[0], pstThreshS16Info->stDst.au64VirAddr[0]);
CVE_THRESH_S16_EXIT2:
    CVE_PMZ_FREE(pstThreshS16Info->stSrc.au64PhyAddr[0], pstThreshS16Info->stSrc.au64VirAddr[0]);
CVE_THRESH_S16_EXIT1:
    CVE_CLOSE_FILE(pstThreshS16Info->pFpSrc);
    CVE_CLOSE_FILE(pstThreshS16Info->pFpDst);
CVE_THRESH_S16_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_ThreshS16Proc(SAMPLE_CVE_THRESH_S16_INFO_T *pstThreshS16Info)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_Thresh_S16(&cveHandle, &pstThreshS16Info->stSrc, &pstThreshS16Info->stDst,
                            &pstThreshS16Info->stThrS16Ctrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE ThreshS16 Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE ThreshS16 Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_ThreshS16Case(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 704;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    CVE_THRESH_S16_CTRL_T *pstThrS16Ctrl = &stThreshS16Info.stThrS16Ctrl;
    CVE_IMAGE_TYPE_E enDstType;
    AML_CHAR *SrcName = "/data/cve/00_704x576.s16";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/threshs16.out";
    stThreshS16Info.stThrS16Ctrl.stCrop.enCrop = AML_FALSE;
    stThreshS16Info.stThrS16Ctrl.stCrop.u16X = 0;
    stThreshS16Info.stThrS16Ctrl.stCrop.u16Y = 0;
    stThreshS16Info.stThrS16Ctrl.stCrop.u16Width = 200;
    stThreshS16Info.stThrS16Ctrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] ThreshS16Mode 0: S16 To S8 MIN_MID_MAX\n");
        pstThrS16Ctrl->enMode = CVE_THRESH_S16_MODE_S16_TO_S8_MIN_MID_MAX;
        enDstType = CVE_IMAGE_TYPE_S8C1;
        pstThrS16Ctrl->un8MaxVal.s8Val = 78;
        pstThrS16Ctrl->un8MidVal.s8Val = 0;
        pstThrS16Ctrl->un8MinVal.s8Val = -73; // 0x37 | 0x80;
        pstThrS16Ctrl->s16LowThr = -1;
        pstThrS16Ctrl->s16HighThr = 255;
        break;
    case 1:
        TEST_PRT("[INFO] ThreshS16Mode 1: S16 To S8 MIN_ORI_MAX\n");
        pstThrS16Ctrl->enMode = CVE_THRESH_S16_MODE_S16_TO_S8_MIN_ORI_MAX;
        enDstType = CVE_IMAGE_TYPE_S8C1;
        pstThrS16Ctrl->un8MaxVal.s8Val = 78;
        pstThrS16Ctrl->un8MidVal.s8Val = 0;
        pstThrS16Ctrl->un8MinVal.s8Val = -73; // 0x37 | 0x80;
        pstThrS16Ctrl->s16LowThr = -1;
        pstThrS16Ctrl->s16HighThr = 127;
        break;
    case 2:
        TEST_PRT("[INFO] ThreshS16Mode 2: S16 To U8 MIN_MID_MAX\n");
        pstThrS16Ctrl->enMode = CVE_THRESH_S16_MODE_S16_TO_U8_MIN_MID_MAX;
        enDstType = CVE_IMAGE_TYPE_U8C1;
        pstThrS16Ctrl->un8MaxVal.u8Val = 255;
        pstThrS16Ctrl->un8MidVal.u8Val = 128;
        pstThrS16Ctrl->un8MinVal.u8Val = 0;
        pstThrS16Ctrl->s16LowThr = -1;
        pstThrS16Ctrl->s16HighThr = 255;
        break;
    case 3:
        TEST_PRT("[INFO] ThreshS16Mode 3: S16 To U8 MIN_ORI_MAX\n");
        pstThrS16Ctrl->enMode = CVE_THRESH_S16_MODE_S16_TO_U8_MIN_ORI_MAX;
        enDstType = CVE_IMAGE_TYPE_U8C1;
        pstThrS16Ctrl->un8MaxVal.u8Val = 255;
        pstThrS16Ctrl->un8MidVal.u8Val = 128;
        pstThrS16Ctrl->un8MinVal.u8Val = 0;
        pstThrS16Ctrl->s16LowThr = -1;
        pstThrS16Ctrl->s16HighThr = 255;
        break;
    default:
        printf("the threshS16 case index is invalid! valid index:\n");
        SAMPLE_CVE_ThreshS16CaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_ThreshS16Init(&stThreshS16Info, enDstType, u32Width, u32Height, pFpSrcName,
                                      pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshS16Init failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_ThreshS16Proc(&stThreshS16Info);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshS16Proc failed!\n", s32Ret);
    }

    SAMPLE_CVE_ThreshS16Uninit(&stThreshS16Info);
    memset(&stThreshS16Info, 0, sizeof(SAMPLE_CVE_THRESH_S16_INFO_T));

    return s32Ret;
}
