/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_THRESH_CTRL_T stThrCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_THRESH_INFO_T;

SAMPLE_CVE_THRESH_INFO_T stThreshInfo;

void SAMPLE_CVE_ThreshCaseList(void)
{
    printf("\t\t  0) ThreshMode: Binary.\n");
    printf("\t\t  1) ThreshMode: Trunc.\n");
    printf("\t\t  2) ThreshMode: ToMinVal.\n");
    printf("\t\t  3) ThreshMode: MinMidMax.\n");
    printf("\t\t  4) ThreshMode: OriMidMax.\n");
    printf("\t\t  5) ThreshMode: MinMidOri.\n");
    printf("\t\t  6) ThreshMode: OriMidOri.\n");
    printf("\t\t  7) ThreshMode: MinOriMax.\n");
    return;
}

static AML_VOID SAMPLE_CVE_ThreshUninit(SAMPLE_CVE_THRESH_INFO_T *pstThreshInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstThreshInfo->stDst, pstThreshInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstThreshInfo->stSrc.au64PhyAddr[0], pstThreshInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstThreshInfo->stDst.au64PhyAddr[0], pstThreshInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstThreshInfo->pFpSrc);
    CVE_CLOSE_FILE(pstThreshInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_ThreshInit(SAMPLE_CVE_THRESH_INFO_T *pstThreshInfo, AML_U32 u32Width,
                                     AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                     AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstThreshInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstThreshInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstThreshInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstThreshInfo->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_THRESH_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstThreshInfo->stDst, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_THRESH_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstThreshInfo->stSrc, pstThreshInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_THRESH_EXIT3;
    }

    goto CVE_THRESH_EXIT0;

CVE_THRESH_EXIT3:
    CVE_PMZ_FREE(pstThreshInfo->stDst.au64PhyAddr[0], pstThreshInfo->stDst.au64VirAddr[0]);
CVE_THRESH_EXIT2:
    CVE_PMZ_FREE(pstThreshInfo->stSrc.au64PhyAddr[0], pstThreshInfo->stSrc.au64VirAddr[0]);
CVE_THRESH_EXIT1:
    CVE_CLOSE_FILE(pstThreshInfo->pFpSrc);
    CVE_CLOSE_FILE(pstThreshInfo->pFpDst);
CVE_THRESH_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_ThreshProc(SAMPLE_CVE_THRESH_INFO_T *pstThreshInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_Thresh(&cveHandle, &pstThreshInfo->stSrc, &pstThreshInfo->stDst,
                        &pstThreshInfo->stThrCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Thresh Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Thresh Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_ThreshCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    CVE_THRESH_CTRL_T *pstThrCtrl = &stThreshInfo.stThrCtrl;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/ThreshCase.out";
    stThreshInfo.stThrCtrl.stCrop.enCrop = AML_FALSE;
    stThreshInfo.stThrCtrl.stCrop.u16X = 0;
    stThreshInfo.stThrCtrl.stCrop.u16Y = 0;
    stThreshInfo.stThrCtrl.stCrop.u16Width = 160;
    stThreshInfo.stThrCtrl.stCrop.u16Height = 160;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] Thresh CASE 0: ThreshMode: Binary\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_BINARY;
        pstThrCtrl->u8LowThr = 128;
        pstThrCtrl->u8MaxVal = 255;
        pstThrCtrl->u8MinVal = 0;
        break;
    case 1:
        TEST_PRT("[INFO] Thresh CASE 1: ThreshMode: Trunc\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_TRUNC;
        pstThrCtrl->u8LowThr = 128;
        pstThrCtrl->u8MaxVal = 255;
        break;
    case 2:
        TEST_PRT("[INFO] Thresh CASE 2: ThreshMode: ToMinVal\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_TO_MINVAL;
        pstThrCtrl->u8LowThr = 128;
        pstThrCtrl->u8MinVal = 0;
        break;
    case 3:
        TEST_PRT("[INFO] Thresh CASE 3: ThreshMode: MinMidMax\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_MIN_MID_MAX;
        pstThrCtrl->u8LowThr = 50;
        pstThrCtrl->u8HighThr = 200;
        pstThrCtrl->u8MaxVal = 255;
        pstThrCtrl->u8MidVal = 128;
        pstThrCtrl->u8MinVal = 0;
        break;
    case 4:
        TEST_PRT("[INFO] Thresh CASE 4: ThreshMode: OriMidMax\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_ORI_MID_MAX;
        pstThrCtrl->u8LowThr = 50;
        pstThrCtrl->u8HighThr = 200;
        pstThrCtrl->u8MaxVal = 255;
        pstThrCtrl->u8MidVal = 128;
        break;
    case 5:
        TEST_PRT("[INFO] Thresh CASE 5: ThreshMode: MinMidOri\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_MIN_MID_ORI;
        pstThrCtrl->u8LowThr = 50;
        pstThrCtrl->u8HighThr = 200;
        pstThrCtrl->u8MidVal = 128;
        pstThrCtrl->u8MinVal = 0;
        break;
    case 6:
        TEST_PRT("[INFO] Thresh CASE 6: ThreshMode: MinORIMax\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_MIN_ORI_MAX;
        pstThrCtrl->u8LowThr = 50;
        pstThrCtrl->u8HighThr = 200;
        pstThrCtrl->u8MidVal = 128;
        pstThrCtrl->u8MaxVal = 255;
        break;
    case 7:
        TEST_PRT("[INFO] Thresh CASE 7: ThreshMode: OriMidOri\n");
        pstThrCtrl->enMode = CVE_THRESH_MODE_ORI_MID_ORI;
        pstThrCtrl->u8LowThr = 50;
        pstThrCtrl->u8HighThr = 200;
        pstThrCtrl->u8MidVal = 128;
        break;
    default:
        printf("the thresh case index is invalid! valid index:\n");
        SAMPLE_CVE_ThreshCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_ThreshInit(&stThreshInfo, u32Width, u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_ThreshProc(&stThreshInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ThreshProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_ThreshUninit(&stThreshInfo);
    memset(&stThreshInfo, 0, sizeof(SAMPLE_CVE_THRESH_INFO_T));

    return s32Ret;
}
