/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stLabel;
    CVE_DST_IMAGE_T stCandiCorner;
    CVE_DST_MEM_INFO_T stCandiCornerPoint;
    CVE_ST_CANDI_CORNER_CTRL_T stStCandiCornerCtrl;
    FILE *pFpSrc;
    FILE *pFpLabel;
    FILE *pFpCandiCorner;
    FILE *pFpCandiCornerPoint;
} SAMPLE_CVE_ST_INFO_T;

SAMPLE_CVE_ST_INFO_T stStInfo;

void SAMPLE_CVE_StCaseList(void)
{
    printf("\t\t  0) St Output Data Mode: u8 [0~255].\n");
    printf("\t\t  1) St Output Data Mode: u1 [0 or 1].\n");
    return;
}

static AML_VOID SAMPLE_CVE_StUninit(SAMPLE_CVE_ST_INFO_T *pstStInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstStInfo->stLabel, pstStInfo->pFpLabel);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstStInfo->stCandiCorner, pstStInfo->pFpCandiCorner);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstStInfo->stCandiCornerPoint,
                                                pstStInfo->pFpCandiCornerPoint);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstStInfo->stSrc.au64PhyAddr[0], pstStInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstStInfo->stStCandiCornerCtrl.stMem.u64PhyAddr,
                 pstStInfo->stStCandiCornerCtrl.stMem.u64VirAddr);
    CVE_PMZ_FREE(pstStInfo->stLabel.au64PhyAddr[0], pstStInfo->stLabel.au64VirAddr[0]);
    CVE_PMZ_FREE(pstStInfo->stCandiCorner.au64PhyAddr[0], pstStInfo->stCandiCorner.au64VirAddr[0]);
    CVE_PMZ_FREE(pstStInfo->stCandiCornerPoint.u64PhyAddr,
                 pstStInfo->stCandiCornerPoint.u64VirAddr);
    CVE_CLOSE_FILE(pstStInfo->pFpSrc);
    CVE_CLOSE_FILE(pstStInfo->pFpLabel);
    CVE_CLOSE_FILE(pstStInfo->pFpCandiCorner);
    CVE_CLOSE_FILE(pstStInfo->pFpCandiCornerPoint);
}

static AML_S32 SAMPLE_CVE_StInit(SAMPLE_CVE_ST_INFO_T *pstStInfo, AML_U32 u32Width,
                                 AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                 AML_CHAR *pchDstLFileName, AML_CHAR *pchDstCFileName,
                                 AML_CHAR *pchDstCCPFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_U32 u32Size;

    memset(&pstStInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstStInfo->stLabel, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstStInfo->stCandiCorner, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstStInfo->stCandiCornerPoint, 0, sizeof(CVE_DST_MEM_INFO_T));
    memset(&pstStInfo->stStCandiCornerCtrl.stMem, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstStInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstStInfo->pFpLabel, pchDstLFileName, "w");
    CVE_OPEN_FILE(pstStInfo->pFpCandiCorner, pchDstCFileName, "w");
    CVE_OPEN_FILE(pstStInfo->pFpCandiCornerPoint, pchDstCCPFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstStInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_ST_EXIT1;
    }
    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstStInfo->stLabel, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_ST_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstStInfo->stCandiCorner, CVE_IMAGE_TYPE_U16C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_ST_EXIT3;
    }

    u32Size =
        pstStInfo->stLabel.au32Stride[0] * pstStInfo->stLabel.u32Height * sizeof(CVE_POINT_U16_T) +
        sizeof(AML_U32);
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstStInfo->stCandiCornerPoint, u32Size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_ST_EXIT4;
    }
    u32Size = SAMPLE_COMM_CVE_CalcStride(pstStInfo->stSrc.u32Width, CVE_ALIGN) *
              pstStInfo->stSrc.u32Height * 2;
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstStInfo->stStCandiCornerCtrl.stMem, u32Size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create mem failed!\n", s32Ret);
        goto CVE_ST_EXIT5;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstStInfo->stSrc, pstStInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_ST_EXIT6;
    }
    goto CVE_ST_EXIT0;

CVE_ST_EXIT6:
    CVE_PMZ_FREE(pstStInfo->stStCandiCornerCtrl.stMem.u64PhyAddr,
                 pstStInfo->stStCandiCornerCtrl.stMem.u64VirAddr);
CVE_ST_EXIT5:
    CVE_PMZ_FREE(pstStInfo->stCandiCornerPoint.u64PhyAddr,
                 pstStInfo->stCandiCornerPoint.u64VirAddr);
CVE_ST_EXIT4:
    CVE_PMZ_FREE(pstStInfo->stCandiCorner.au64PhyAddr[0], pstStInfo->stCandiCorner.au64VirAddr[0]);
CVE_ST_EXIT3:
    CVE_PMZ_FREE(pstStInfo->stLabel.au64PhyAddr[0], pstStInfo->stLabel.au64VirAddr[0]);
CVE_ST_EXIT2:
    CVE_PMZ_FREE(pstStInfo->stSrc.au64PhyAddr[0], pstStInfo->stSrc.au64VirAddr[0]);
CVE_ST_EXIT1:
    CVE_CLOSE_FILE(pstStInfo->pFpSrc);
    CVE_CLOSE_FILE(pstStInfo->pFpLabel);
    CVE_CLOSE_FILE(pstStInfo->pFpCandiCorner);
    CVE_CLOSE_FILE(pstStInfo->pFpCandiCornerPoint);
CVE_ST_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_StProc(SAMPLE_CVE_ST_INFO_T *pstStInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_STCandiCorner(&cveHandle, &pstStInfo->stSrc, &pstStInfo->stLabel,
                               &pstStInfo->stCandiCorner, &pstStInfo->stCandiCornerPoint,
                               &pstStInfo->stStCandiCornerCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE StCandiCorner Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE StCandiCorner Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_StCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    CVE_ST_CANDI_CORNER_CTRL_T *pstCandiCorner = &stStInfo.stStCandiCornerCtrl;
    AML_CHAR *SrcName = "/data/cve/penguinx.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstLName = "/data/cve/St_label.out";
    AML_CHAR *pFpDstCName = "/data/cve/St_candicorner.out";
    AML_CHAR *pFpDstCCPName = "/data/cve/St_candicpoint.out";
    stStInfo.stStCandiCornerCtrl.stCrop.enCrop = AML_FALSE;
    stStInfo.stStCandiCornerCtrl.stCrop.u16X = 290;
    stStInfo.stStCandiCornerCtrl.stCrop.u16Y = 70;
    stStInfo.stStCandiCornerCtrl.stCrop.u16Width = 10;
    stStInfo.stStCandiCornerCtrl.stCrop.u16Height = 30;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] St CASE 0: stCandiCorner output mode u8\n");
        pstCandiCorner->enOutputDataMode = CVE_ST_CANDI_CORNER_OUTPUT_DATA_MODE_U8;
        break;
    case 1:
        TEST_PRT("[INFO] St CASE 1: stCandiCorner output mode u1\n");
        pstCandiCorner->enOutputDataMode = CVE_ST_CANDI_CORNER_OUTPUT_DATA_MODE_U1;
        break;
    default:
        printf("the thresh case index is invalid! valid index:\n");
        SAMPLE_CVE_StCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst label file name:%s\n", pFpDstLName);
    printf("dst candi cornet file name:%s\n", pFpDstCName);
    printf("dst candi cornet point file name:%s\n", pFpDstCCPName);

    s32Ret = SAMPLE_CVE_StInit(&stStInfo, u32Width, u32Height, pFpSrcName, pFpDstLName, pFpDstCName,
                               pFpDstCCPName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_StInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_StProc(&stStInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_StProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_StUninit(&stStInfo);
    memset(&stStInfo, 0, sizeof(SAMPLE_CVE_ST_INFO_T));

    return s32Ret;
}
