/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc1;
    CVE_SRC_IMAGE_T stSrc2;
    CVE_DST_IMAGE_T stSad;
    CVE_DST_IMAGE_T stThr;
    CVE_SAD_CTRL_T stSadCtrl;
    FILE *pFpSrc1;
    FILE *pFpSrc2;
    FILE *pFpSad;
    FILE *pFpThr;
} SAMPLE_CVE_SAD_INFO_T;

SAMPLE_CVE_SAD_INFO_T stSadInfo;

void SAMPLE_CVE_SadCaseList(void)
{
    printf("\t\t  0) SadMode: MB_4X4.\n");
    printf("\t\t  1) SadMode: MB_8X8.\n");
    printf("\t\t  2) SadMode: MB_16X16.\n");
    return;
}

static AML_VOID SAMPLE_CVE_SadUninit(SAMPLE_CVE_SAD_INFO_T *pstSadInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstSadInfo->stSad, pstSadInfo->pFpSad);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstSadInfo->stThr, pstSadInfo->pFpThr);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstSadInfo->stSrc1.au64PhyAddr[0], pstSadInfo->stSrc1.au64VirAddr[0]);
    CVE_PMZ_FREE(pstSadInfo->stSrc2.au64PhyAddr[0], pstSadInfo->stSrc2.au64VirAddr[0]);
    CVE_PMZ_FREE(pstSadInfo->stSad.au64PhyAddr[0], pstSadInfo->stSad.au64VirAddr[0]);
    CVE_PMZ_FREE(pstSadInfo->stThr.au64PhyAddr[0], pstSadInfo->stThr.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstSadInfo->pFpSrc1);
    CVE_CLOSE_FILE(pstSadInfo->pFpSrc2);
    CVE_CLOSE_FILE(pstSadInfo->pFpSad);
    CVE_CLOSE_FILE(pstSadInfo->pFpThr);
}

static AML_S32 SAMPLE_CVE_SadInit(SAMPLE_CVE_SAD_INFO_T *pstSadInfo, AML_U32 u32SrcWidth,
                                  AML_U32 u32SrcHeight, AML_U32 u32DstWidth, AML_U32 u32DstHeight,
                                  AML_CHAR *pchSrc1FileName, AML_CHAR *pchSrc2FileName,
                                  AML_CHAR *pchDstSadFileName, AML_CHAR *pchDstThrFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstSadInfo->stSrc1, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstSadInfo->stSrc2, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstSadInfo->stSad, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstSadInfo->stThr, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstSadInfo->pFpSrc1, pchSrc1FileName, "r+");
    CVE_OPEN_FILE(pstSadInfo->pFpSrc2, pchSrc2FileName, "r+");
    CVE_OPEN_FILE(pstSadInfo->pFpSad, pchDstSadFileName, "w");
    CVE_OPEN_FILE(pstSadInfo->pFpThr, pchDstThrFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstSadInfo->stSrc1, CVE_IMAGE_TYPE_U8C1, u32SrcWidth,
                                         u32SrcHeight);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstSadInfo->stSrc2, CVE_IMAGE_TYPE_U8C1, u32SrcWidth,
                                         u32SrcHeight);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstSadInfo->stSad, CVE_IMAGE_TYPE_U16C1, u32DstWidth,
                                         u32DstHeight);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstSadInfo->stThr, CVE_IMAGE_TYPE_U8C1, u32DstWidth,
                                         u32DstHeight);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT4;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstSadInfo->stSrc1, pstSadInfo->pFpSrc1);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT5;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstSadInfo->stSrc2, pstSadInfo->pFpSrc2);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_SAD_EXIT5;
    }

    goto CVE_SAD_EXIT0;

CVE_SAD_EXIT5:
    CVE_PMZ_FREE(pstSadInfo->stThr.au64PhyAddr[0], pstSadInfo->stThr.au64VirAddr[0]);
CVE_SAD_EXIT4:
    CVE_PMZ_FREE(pstSadInfo->stSad.au64PhyAddr[0], pstSadInfo->stSad.au64VirAddr[0]);
CVE_SAD_EXIT3:
    CVE_PMZ_FREE(pstSadInfo->stSrc2.au64PhyAddr[0], pstSadInfo->stSrc2.au64VirAddr[0]);
CVE_SAD_EXIT2:
    CVE_PMZ_FREE(pstSadInfo->stSrc1.au64PhyAddr[0], pstSadInfo->stSrc1.au64VirAddr[0]);
CVE_SAD_EXIT1:
    CVE_CLOSE_FILE(pstSadInfo->pFpSrc1);
    CVE_CLOSE_FILE(pstSadInfo->pFpSrc2);
    CVE_CLOSE_FILE(pstSadInfo->pFpSad);
    CVE_CLOSE_FILE(pstSadInfo->pFpThr);
CVE_SAD_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_SadProc(SAMPLE_CVE_SAD_INFO_T *pstSadInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_SAD(&cveHandle, &pstSadInfo->stSrc1, &pstSadInfo->stSrc2, &pstSadInfo->stSad,
                     &pstSadInfo->stThr, &pstSadInfo->stSadCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE SAD Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE SAD Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_SadCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32SrcWidth = 352;
    AML_U32 u32SrcHeight = 288;
    AML_U32 u32DstWidth = 0;
    AML_U32 u32DstHeight = 0;
    AML_S32 s32Ret;
    CVE_SAD_CTRL_T *pstSadCtrl = &stSadInfo.stSadCtrl;
    AML_CHAR *Src1Name = "/data/cve/00_352x288_y.yuv";
    AML_CHAR *Src2Name = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrc1Name[64] = {0};
    AML_CHAR pFpSrc2Name[64] = {0};
    AML_CHAR *pFpDstSadName = "/data/cve/Sad.out";
    AML_CHAR *pFpDstThrName = "/data/cve/Sad_Thr.out";

    stSadInfo.stSadCtrl.stCrop.enCrop = AML_FALSE;
    stSadInfo.stSadCtrl.stCrop.u16X = 0;
    stSadInfo.stSadCtrl.stCrop.u16Y = 0;
    stSadInfo.stSadCtrl.stCrop.u16Width = 200;
    stSadInfo.stSadCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] Sad CASE 0: SadMode: MB_4X4\n");
        pstSadCtrl->enMode = CVE_SAD_MODE_MB_4X4;
        pstSadCtrl->u16Thr = 1500;
        pstSadCtrl->u8MaxVal = 245;
        pstSadCtrl->u8MinVal = 10;
        u32DstWidth = u32SrcWidth >> 2;
        u32DstHeight = u32SrcHeight >> 2;
        break;
    case 1:
        TEST_PRT("[INFO] Sad CASE 1: SadMode: MB_8X8\n");
        pstSadCtrl->enMode = CVE_SAD_MODE_MB_8X8;
        pstSadCtrl->u16Thr = 4000;
        pstSadCtrl->u8MaxVal = 245;
        pstSadCtrl->u8MinVal = 10;
        u32DstWidth = u32SrcWidth >> 3;
        u32DstHeight = u32SrcHeight >> 3;
        break;
    case 2:
        TEST_PRT("[INFO] Sad CASE 2: SadMode: MB_16X16\n");
        pstSadCtrl->enMode = CVE_SAD_MODE_MB_16X16;
        pstSadCtrl->u16Thr = 12000;
        pstSadCtrl->u8MaxVal = 245;
        pstSadCtrl->u8MinVal = 10;
        u32DstWidth = u32SrcWidth >> 4;
        u32DstHeight = u32SrcHeight >> 4;
        break;
    default:
        printf("the sad case index is invalid! valid index:\n");
        SAMPLE_CVE_SadCaseList();
        return AML_FAILURE;
    }

    printf("please input src1 file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc1Name, sizeof(pFpSrc1Name), Src1Name);
    printf("please input src2 file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc2Name, sizeof(pFpSrc2Name), Src2Name);
    printf("src1 file name:%s\n", pFpSrc1Name);
    printf("src2 file name:%s\n", pFpSrc2Name);
    printf("dst sad file name:%s\n", pFpDstSadName);
    printf("dst thresh file name:%s\n", pFpDstThrName);

    s32Ret = SAMPLE_CVE_SadInit(&stSadInfo, u32SrcWidth, u32SrcHeight, u32DstWidth, u32DstHeight,
                                pFpSrc1Name, pFpSrc2Name, pFpDstSadName, pFpDstThrName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_SadInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_SadProc(&stSadInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_SadProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_SadUninit(&stSadInfo);
    memset(&stSadInfo, 0, sizeof(SAMPLE_CVE_SAD_INFO_T));

    return s32Ret;
}
