/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_ORD_STAT_FILTER_CTRL_T stOrdStatFltCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_ORD_STAT_FILTER_INFO_T;

SAMPLE_CVE_ORD_STAT_FILTER_INFO_T stOrdStatFilterInfo;

void SAMPLE_CVE_OrdStatFilterCaseList(void)
{
    printf("\t\t  0) OrdStatFilterMode: Min.\n");
    printf("\t\t  1) OrdStatFilterMode: Median.\n");
    printf("\t\t  2) OrdStatFilterMode: Max.\n");
    return;
}

static AML_VOID
SAMPLE_CVE_OrdStatFilterUninit(SAMPLE_CVE_ORD_STAT_FILTER_INFO_T *pstOrdStatFilterInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstOrdStatFilterInfo->stDst, pstOrdStatFilterInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstOrdStatFilterInfo->stSrc.au64PhyAddr[0],
                 pstOrdStatFilterInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstOrdStatFilterInfo->stDst.au64PhyAddr[0],
                 pstOrdStatFilterInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstOrdStatFilterInfo->pFpSrc);
    CVE_CLOSE_FILE(pstOrdStatFilterInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_OrdStatFilterInit(SAMPLE_CVE_ORD_STAT_FILTER_INFO_T *pstOrdStatFilterInfo,
                                            AML_U32 u32Width, AML_U32 u32Height,
                                            AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstOrdStatFilterInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstOrdStatFilterInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstOrdStatFilterInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstOrdStatFilterInfo->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstOrdStatFilterInfo->stSrc, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_ORD_STAT_FILTER_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstOrdStatFilterInfo->stDst, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_ORD_STAT_FILTER_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstOrdStatFilterInfo->stSrc, pstOrdStatFilterInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src2 Image failed!\n", s32Ret);
        goto CVE_ORD_STAT_FILTER_EXIT3;
    }

    goto CVE_ORD_STAT_FILTER_EXIT0;

CVE_ORD_STAT_FILTER_EXIT3:
    CVE_PMZ_FREE(pstOrdStatFilterInfo->stSrc.au64PhyAddr[0],
                 pstOrdStatFilterInfo->stSrc.au64VirAddr[0]);
CVE_ORD_STAT_FILTER_EXIT2:
    CVE_PMZ_FREE(pstOrdStatFilterInfo->stDst.au64PhyAddr[0],
                 pstOrdStatFilterInfo->stDst.au64VirAddr[0]);
CVE_ORD_STAT_FILTER_EXIT1:
    CVE_CLOSE_FILE(pstOrdStatFilterInfo->pFpSrc);
    CVE_CLOSE_FILE(pstOrdStatFilterInfo->pFpDst);
CVE_ORD_STAT_FILTER_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_OrdStatFilterProc(SAMPLE_CVE_ORD_STAT_FILTER_INFO_T *pstOrdStatFilterInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret =
        CVE_OrdStatFilter(&cveHandle, &pstOrdStatFilterInfo->stSrc, &pstOrdStatFilterInfo->stDst,
                          &pstOrdStatFilterInfo->stOrdStatFltCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE OrdStatFilter Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE OrdStatFilter Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_OrdStatFilterCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    CVE_ORD_STAT_FILTER_CTRL_T *pstOrdStatFltCtrl = &stOrdStatFilterInfo.stOrdStatFltCtrl;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/OrdStatFilter.out";

    stOrdStatFilterInfo.stOrdStatFltCtrl.stCrop.enCrop = AML_FALSE;
    stOrdStatFilterInfo.stOrdStatFltCtrl.stCrop.u16X = 0;
    stOrdStatFilterInfo.stOrdStatFltCtrl.stCrop.u16Y = 0;
    stOrdStatFilterInfo.stOrdStatFltCtrl.stCrop.u16Width = 200;
    stOrdStatFilterInfo.stOrdStatFltCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] OrdStatFilter CASE 0: OrdStatFilterMode: Min\n");
        pstOrdStatFltCtrl->enMode = CVE_ORD_STAT_FILTER_MODE_MIN;
        break;
    case 1:
        TEST_PRT("[INFO] OrdStatFilter CASE 1: OrdStatFilterMode: Median\n");
        pstOrdStatFltCtrl->enMode = CVE_ORD_STAT_FILTER_MODE_MEDIAN;
        break;
    case 2:
        TEST_PRT("[INFO] OrdStatFilter CASE 2: OrdStatFilterMode: Max\n");
        pstOrdStatFltCtrl->enMode = CVE_ORD_STAT_FILTER_MODE_MAX;
        break;
    default:
        printf("the ordStatFilter case index is invalid! valid index:\n");
        SAMPLE_CVE_OrdStatFilterCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src1 file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_OrdStatFilterInit(&stOrdStatFilterInfo, u32Width, u32Height, pFpSrcName,
                                          pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_OrdStatFilterInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_OrdStatFilterProc(&stOrdStatFilterInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_OrdStatFilterProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_OrdStatFilterUninit(&stOrdStatFilterInfo);
    memset(&stOrdStatFilterInfo, 0, sizeof(SAMPLE_CVE_ORD_STAT_FILTER_INFO_T));

    return s32Ret;
}
