/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDstH;
    CVE_DST_IMAGE_T stDstV;
    CVE_DST_IMAGE_T stDstHV;
    CVE_NORM_GRAD_CTRL_T stNormGradCtrl;
    FILE *pFpSrc;
    FILE *pFpDstH;
    FILE *pFpDstV;
    FILE *pFpDstHV;
} SAMPLE_CVE_NORM_GRAD_INFO_T;

SAMPLE_CVE_NORM_GRAD_INFO_T stNormGradInfo;

static AML_CHAR acMask0[25] = {0, 0, 0, 0,  0, 0, -1, 0, 1, 0, 0, -2, 0,
                               2, 0, 0, -1, 0, 1, 0,  0, 0, 0, 0, 0};

void SAMPLE_CVE_NormGradCaseList(void)
{
    printf("\t\t  0) Output:H&V.\n");
    printf("\t\t  1) Output:H.\n");
    printf("\t\t  2) Output:V.\n");
    printf("\t\t  3) Output:Combine\n");
    return;
}

static AML_VOID SAMPLE_CVE_NormGradUninit(SAMPLE_CVE_NORM_GRAD_INFO_T *pstNormGradInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstNormGradInfo->stDstH, pstNormGradInfo->pFpDstH);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst H Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstNormGradInfo->stDstV, pstNormGradInfo->pFpDstV);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst V Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstNormGradInfo->stDstHV, pstNormGradInfo->pFpDstHV);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst HV Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstNormGradInfo->stSrc.au64PhyAddr[0], pstNormGradInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstNormGradInfo->stDstH.au64PhyAddr[0], pstNormGradInfo->stDstH.au64VirAddr[0]);
    CVE_PMZ_FREE(pstNormGradInfo->stDstV.au64PhyAddr[0], pstNormGradInfo->stDstV.au64VirAddr[0]);
    CVE_PMZ_FREE(pstNormGradInfo->stDstHV.au64PhyAddr[0], pstNormGradInfo->stDstHV.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpSrc);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstH);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstV);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstHV);
}

static AML_S32 SAMPLE_CVE_NormGradInit(SAMPLE_CVE_NORM_GRAD_INFO_T *pstNormGradInfo,
                                       AML_U32 u32Width, AML_U32 u32Height,
                                       AML_CHAR *pchSrcFileName, AML_CHAR *pchDstHFileName,
                                       AML_CHAR *pchDstVFileName, AML_CHAR *pchDstHVFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstNormGradInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstNormGradInfo->stDstH, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstNormGradInfo->stDstV, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstNormGradInfo->stDstHV, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstNormGradInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstNormGradInfo->pFpDstH, pchDstHFileName, "w");
    CVE_OPEN_FILE(pstNormGradInfo->pFpDstV, pchDstVFileName, "w");
    CVE_OPEN_FILE(pstNormGradInfo->pFpDstHV, pchDstHVFileName, "w");

    memcpy(&pstNormGradInfo->stNormGradCtrl.as8Mask, acMask0, 25);
    pstNormGradInfo->stNormGradCtrl.u8Norm = 0;

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstNormGradInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_NORM_GRAD_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstNormGradInfo->stDstH, CVE_IMAGE_TYPE_S8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_NORM_GRAD_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstNormGradInfo->stDstV, CVE_IMAGE_TYPE_S8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_NORM_GRAD_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstNormGradInfo->stDstHV, CVE_IMAGE_TYPE_S8C2_PACKAGE,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_NORM_GRAD_EXIT4;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstNormGradInfo->stSrc, pstNormGradInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_NORM_GRAD_EXIT5;
    }
    goto CVE_NORM_GRAD_EXIT0;

CVE_NORM_GRAD_EXIT5:
    CVE_PMZ_FREE(pstNormGradInfo->stDstHV.au64PhyAddr[0], pstNormGradInfo->stDstHV.au64VirAddr[0]);
CVE_NORM_GRAD_EXIT4:
    CVE_PMZ_FREE(pstNormGradInfo->stDstV.au64PhyAddr[0], pstNormGradInfo->stDstV.au64VirAddr[0]);
CVE_NORM_GRAD_EXIT3:
    CVE_PMZ_FREE(pstNormGradInfo->stDstH.au64PhyAddr[0], pstNormGradInfo->stDstH.au64VirAddr[0]);
CVE_NORM_GRAD_EXIT2:
    CVE_PMZ_FREE(pstNormGradInfo->stSrc.au64PhyAddr[0], pstNormGradInfo->stSrc.au64VirAddr[0]);
CVE_NORM_GRAD_EXIT1:
    CVE_CLOSE_FILE(pstNormGradInfo->pFpSrc);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstH);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstV);
    CVE_CLOSE_FILE(pstNormGradInfo->pFpDstHV);
CVE_NORM_GRAD_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_NormGradProc(SAMPLE_CVE_NORM_GRAD_INFO_T *pstNormGradInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_NormGrad(&cveHandle, &pstNormGradInfo->stSrc, &pstNormGradInfo->stDstH,
                          &pstNormGradInfo->stDstV, &pstNormGradInfo->stDstHV,
                          &pstNormGradInfo->stNormGradCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE NormGrad Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE NormGrad Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_NormGradCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    CVE_NORM_GRAD_CTRL_T *pstNormGradCtrl = &stNormGradInfo.stNormGradCtrl;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstHName = "/data/cve/NormGrad_H.out";
    AML_CHAR *pFpDstVName = "/data/cve/NormGrad_V.out";
    AML_CHAR *pFpDstHVName = "/data/cve/NormGrad_HV.out";

    stNormGradInfo.stNormGradCtrl.stCrop.enCrop = AML_FALSE;
    stNormGradInfo.stNormGradCtrl.stCrop.u16X = 0;
    stNormGradInfo.stNormGradCtrl.stCrop.u16Y = 0;
    stNormGradInfo.stNormGradCtrl.stCrop.u16Width = 200;
    stNormGradInfo.stNormGradCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] NormGrad CASE 0: Output:H&V\n");
        pstNormGradCtrl->enOutCtrl = CVE_NORM_GRAD_OUT_CTRL_HOR_AND_VER;
        break;
    case 1:
        TEST_PRT("[INFO] NormGrad CASE 1: Output:H\n");
        pstNormGradCtrl->enOutCtrl = CVE_NORM_GRAD_OUT_CTRL_HOR;
        break;
    case 2:
        TEST_PRT("[INFO] NormGrad CASE 2: Output:V\n");
        pstNormGradCtrl->enOutCtrl = CVE_NORM_GRAD_OUT_CTRL_VER;
        break;
    case 3:
        TEST_PRT("[INFO] NormGrad CASE 3: Output:Combine\n");
        pstNormGradCtrl->enOutCtrl = CVE_NORM_GRAD_OUT_CTRL_COMBINE;
        break;
    default:
        printf("the NormGrad case index is invalid! valid index:\n");
        SAMPLE_CVE_NormGradCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst H file name:%s\n", pFpDstHName);
    printf("dst V file name:%s\n", pFpDstVName);
    printf("dst HV file name:%s\n", pFpDstHVName);

    s32Ret = SAMPLE_CVE_NormGradInit(&stNormGradInfo, u32Width, u32Height, pFpSrcName, pFpDstHName,
                                     pFpDstVName, pFpDstHVName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_NormGradInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_NormGradProc(&stNormGradInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_NormGradProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_NormGradUninit(&stNormGradInfo);
    memset(&stNormGradInfo, 0, sizeof(SAMPLE_CVE_NORM_GRAD_INFO_T));

    return s32Ret;
}
