/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc1;
    CVE_DST_IMAGE_T stSrc2;
    CVE_DST_MEM_INFO_T stDst;
    CVE_NCC_CTRL_T stNccCtrl;
    FILE *pFpSrc1;
    FILE *pFpSrc2;
    FILE *pFpDst;
} SAMPLE_CVE_NCC_INFO_T;

SAMPLE_CVE_NCC_INFO_T stNccInfo;

void SAMPLE_CVE_NccCaseList(void)
{
    printf("\t\t  0) Ncc.\n");
    printf("\t\t  1) similar.\n");
    return;
}

static AML_VOID SAMPLE_CVE_NccUninit(SAMPLE_CVE_NCC_INFO_T *pstNccInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstNccInfo->stDst, pstNccInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstNccInfo->stSrc1.au64PhyAddr[0], pstNccInfo->stSrc1.au64VirAddr[0]);
    CVE_PMZ_FREE(pstNccInfo->stSrc2.au64PhyAddr[0], pstNccInfo->stSrc2.au64VirAddr[0]);
    CVE_PMZ_FREE(pstNccInfo->stDst.u64PhyAddr, pstNccInfo->stDst.u64VirAddr);
    CVE_CLOSE_FILE(pstNccInfo->pFpSrc1);
    CVE_CLOSE_FILE(pstNccInfo->pFpSrc2);
    CVE_CLOSE_FILE(pstNccInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_NccInit(SAMPLE_CVE_NCC_INFO_T *pstNccInfo, AML_U32 u32Width,
                                  AML_U32 u32Height, AML_U32 enMode, AML_CHAR *pchSrc1FileName,
                                  AML_CHAR *pchSrc2FileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstNccInfo->stSrc1, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstNccInfo->stSrc2, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstNccInfo->stDst, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstNccInfo->pFpSrc1, pchSrc1FileName, "r+");
    CVE_OPEN_FILE(pstNccInfo->pFpSrc2, pchSrc2FileName, "r+");
    CVE_OPEN_FILE(pstNccInfo->pFpDst, pchDstFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstNccInfo->stSrc1, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_NCC_EXIT1;
    }

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstNccInfo->stSrc2, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_NCC_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstNccInfo->stDst, sizeof(CVE_NCC_DST_MEM_T));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_NCC_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstNccInfo->stSrc1, pstNccInfo->pFpSrc1);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src1 Image failed!\n", s32Ret);
        goto CVE_NCC_EXIT4;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstNccInfo->stSrc2, pstNccInfo->pFpSrc2);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src2 Image failed!\n", s32Ret);
        goto CVE_NCC_EXIT4;
    }

    pstNccInfo->stNccCtrl.enMode = enMode;

    if (pstNccInfo->stNccCtrl.enMode == CVE_NCC_MODE_SIMILAR) {
        pstNccInfo->stNccCtrl.u8Src1Offset = 0x39;
        pstNccInfo->stNccCtrl.u8Src0Offset = 0x28;
    }
    goto CVE_NCC_EXIT0;

CVE_NCC_EXIT4:
    CVE_PMZ_FREE(pstNccInfo->stDst.u64PhyAddr, pstNccInfo->stDst.u64VirAddr);
CVE_NCC_EXIT3:
    CVE_PMZ_FREE(pstNccInfo->stSrc2.au64PhyAddr[0], pstNccInfo->stSrc2.au64VirAddr[0]);
CVE_NCC_EXIT2:
    CVE_PMZ_FREE(pstNccInfo->stSrc1.au64PhyAddr[0], pstNccInfo->stSrc1.au64VirAddr[0]);
CVE_NCC_EXIT1:
    CVE_CLOSE_FILE(pstNccInfo->pFpSrc1);
    CVE_CLOSE_FILE(pstNccInfo->pFpSrc2);
    CVE_CLOSE_FILE(pstNccInfo->pFpDst);
CVE_NCC_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_NccProc(SAMPLE_CVE_NCC_INFO_T *pstNccInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_NCC(&cveHandle, &pstNccInfo->stSrc1, &pstNccInfo->stSrc2, &pstNccInfo->stDst,
                     &pstNccInfo->stNccCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE NCC Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE NCC Query error\n");
        return s32Ret;
    }
    return s32Ret;
}

AML_S32 SAMPLE_CVE_NccCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_U32 enmode = 0;
    AML_S32 s32Ret;
    AML_CHAR *Src1Name = "/data/cve/00_352x288_y.yuv";
    AML_CHAR *Src2Name = "/data/cve/02_352x288_y.yuv";
    AML_CHAR pFpSrc1Name[64] = {0};
    AML_CHAR pFpSrc2Name[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/Ncc.out";

    stNccInfo.stNccCtrl.stCrop.enCrop = AML_FALSE;
    stNccInfo.stNccCtrl.stCrop.u16X = 0;
    stNccInfo.stNccCtrl.stCrop.u16Y = 0;
    stNccInfo.stNccCtrl.stCrop.u16Width = 200;
    stNccInfo.stNccCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] Ncc CASE 0: Ncc.\n");
        enmode = CVE_NCC_MODE_COM;
        break;
    case 1:
        TEST_PRT("[INFO] Ncc CASE 0: Similar.\n");
        enmode = CVE_NCC_MODE_SIMILAR;
        break;
    default:
        printf("the ncc case index is invalid! valid index:\n");
        SAMPLE_CVE_NccCaseList();
        return AML_FAILURE;
    }

    printf("please input src1 file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc1Name, sizeof(pFpSrc1Name), Src1Name);
    printf("please input src2 file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc2Name, sizeof(pFpSrc2Name), Src2Name);
    printf("src1 file name:%s\n", pFpSrc1Name);
    printf("src2 file name:%s\n", pFpSrc2Name);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_NccInit(&stNccInfo, u32Width, u32Height, enmode, pFpSrc1Name, pFpSrc2Name,
                                pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_NccInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_NccProc(&stNccInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_NccProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_NccUninit(&stNccInfo);
    memset(&stNccInfo, 0, sizeof(SAMPLE_CVE_NCC_INFO_T));

    return s32Ret;
}
