/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrcCur;
    CVE_SRC_IMAGE_T stSrcPre;
    CVE_DST_IMAGE_T stDstFg;
    CVE_DST_IMAGE_T stDstBg;
    CVE_DST_IMAGE_T stDstCurDiffBg;
    CVE_DST_IMAGE_T stDstFrmDiff;
    CVE_MEM_INFO_T stBgModel;
    CVE_MEM_INFO_T stDstStatData;

    CVE_MATCH_BG_MODEL_CTRL_T stMatchBgModelCtrl;

    FILE *pFpSrcCur;
    FILE *pFpSrcPre;
    FILE *pFpBgModel;
    FILE *pFpBgModelPrev;
    FILE *pFpDstFg;
    FILE *pFpDstBg;
    FILE *pFpDstCurDiffBg;
    FILE *pFpDstFrmDiff;
    FILE *pFpDstStatData;
} SAMPLE_CVE_MatchBgModel_INFO_T;

SAMPLE_CVE_MatchBgModel_INFO_T stMatchBgModelInfo;

void SAMPLE_CVE_MatchBgModelCaseList(void)
{
    printf("\t\t  0) output fg. ds=0\n");
    printf("\t\t  1) output fg. ds=1\n");
    printf("\t\t  2) output fg. ds=2\n");
    printf("\t\t  3) output fg and bg. ds=0\n");
    printf("\t\t  4) output fg and bg. ds=1\n");
    printf("\t\t  5) output fg and bg. ds=2\n");
    printf("\t\t  6) output fg, bg and gray fg. ds=0\n");
    printf("\t\t  7) output fg, bg and gray fg. ds=1\n");
    printf("\t\t  8) output fg, bg and gray fg. ds=2\n");
    printf("\t\t  9) output fg, bg, gray fg and two frame difference. ds=0\n");
    printf("\t\t  10) output fg, bg, gray fg and two frame difference. ds=1\n");
    printf("\t\t  11) output fg, bg, gray fg and two frame difference. ds=2\n");
    return;
}

static AML_VOID SAMPLE_CVE_MatchBgModelUninit(SAMPLE_CVE_MatchBgModel_INFO_T *pstMatchBgModelInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    CVE_MATCH_BG_MODEL_CTRL_T *pstMatchBgModelCtrl;

    pstMatchBgModelCtrl = &pstMatchBgModelInfo->stMatchBgModelCtrl;
    s32Ret =
        SAMPLE_COMM_CVE_WriteFile(&pstMatchBgModelInfo->stDstFg, pstMatchBgModelInfo->pFpDstFg);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst fg Image failed!\n", s32Ret);
    }
    if (pstMatchBgModelCtrl->enOutputMode >= CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG) {
        s32Ret =
            SAMPLE_COMM_CVE_WriteFile(&pstMatchBgModelInfo->stDstBg, pstMatchBgModelInfo->pFpDstBg);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Write Dst bg Image failed!\n", s32Ret);
        }
    }
    if (pstMatchBgModelCtrl->enOutputMode >=
        CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG_AND_CURDIFFBG) {
        s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstMatchBgModelInfo->stDstCurDiffBg,
                                           pstMatchBgModelInfo->pFpDstCurDiffBg);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Write Dst cur diff bg Image failed!\n", s32Ret);
        }
    }
    if (pstMatchBgModelCtrl->enOutputMode >= CVE_MATCH_BG_MODEL_OUTPUT_MODE_ALL) {
        s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstMatchBgModelInfo->stDstFrmDiff,
                                           pstMatchBgModelInfo->pFpDstFrmDiff);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Write Dst frm Image failed!\n", s32Ret);
        }
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstMatchBgModelInfo->stBgModel,
                                                pstMatchBgModelInfo->pFpBgModel);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst bg model file failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstMatchBgModelInfo->stDstStatData,
                                                pstMatchBgModelInfo->pFpDstStatData);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst status file failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstMatchBgModelInfo->stSrcCur.au64PhyAddr[0],
                 pstMatchBgModelInfo->stSrcCur.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stSrcPre.au64PhyAddr[0],
                 pstMatchBgModelInfo->stSrcPre.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stBgModel.u64PhyAddr,
                 pstMatchBgModelInfo->stBgModel.u64VirAddr);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstFg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstFg.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstBg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstBg.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstCurDiffBg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstCurDiffBg.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstFrmDiff.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstFrmDiff.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstStatData.u64PhyAddr,
                 pstMatchBgModelInfo->stDstStatData.u64VirAddr);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpSrcCur);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpSrcPre);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstFg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstBg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstCurDiffBg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstFrmDiff);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpBgModel);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpBgModelPrev);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstStatData);
}

static AML_S32 SAMPLE_CVE_MatchBgModelInit(SAMPLE_CVE_MatchBgModel_INFO_T *pstMatchBgModelInfo,
                                           AML_CHAR *pchSrc0FileName, AML_CHAR *pchSrc1FileName,
                                           AML_CHAR *pchDst0FileName, AML_CHAR *pchDst1FileName,
                                           AML_CHAR *pchDst2FileName, AML_CHAR *pchDst3FileName,
                                           AML_CHAR *pchDst4FileName, AML_CHAR *pchDst4PrevFileName,
                                           AML_CHAR *pchDstStatDataFileName, AML_U32 u32OutputMode,
                                           AML_U32 u32OutputDsmode, AML_U32 u32Width,
                                           AML_U32 u32Height)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstMatchBgModelInfo->stSrcCur, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstMatchBgModelInfo->stSrcPre, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstMatchBgModelInfo->stDstFg, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstMatchBgModelInfo->stDstBg, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstMatchBgModelInfo->stDstCurDiffBg, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstMatchBgModelInfo->stDstFrmDiff, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstMatchBgModelInfo->stBgModel, 0, sizeof(CVE_MEM_INFO_T));
    memset(&pstMatchBgModelInfo->stDstStatData, 0, sizeof(CVE_MEM_INFO_T));

    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpSrcCur, pchSrc0FileName, "r+");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpSrcPre, pchSrc1FileName, "r+");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpDstFg, pchDst0FileName, "w");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpDstBg, pchDst1FileName, "w");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpDstCurDiffBg, pchDst2FileName, "w");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpDstFrmDiff, pchDst3FileName, "w");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpBgModel, pchDst4FileName, "w");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpBgModelPrev, pchDst4PrevFileName, "r+");
    CVE_OPEN_FILE(pstMatchBgModelInfo->pFpDstStatData, pchDstStatDataFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stSrcCur, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Cur Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT1;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stSrcPre, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Pre Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stDstFg, CVE_IMAGE_TYPE_U8C1,
                                         u32Width >> u32OutputDsmode, u32Height >> u32OutputDsmode);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Fg Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT3;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stDstBg, CVE_IMAGE_TYPE_U8C1,
                                         u32Width >> u32OutputDsmode, u32Height >> u32OutputDsmode);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Bg Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT4;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stDstCurDiffBg, CVE_IMAGE_TYPE_U8C1,
                                         u32Width >> u32OutputDsmode, u32Height >> u32OutputDsmode);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Cru Diff Bg Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT5;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMatchBgModelInfo->stDstFrmDiff, CVE_IMAGE_TYPE_U8C1,
                                         u32Width >> u32OutputDsmode, u32Height >> u32OutputDsmode);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Frm Diff Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT6;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstMatchBgModelInfo->stBgModel,
                                           (u32Width >> u32OutputDsmode) *
                                               (u32Height >> u32OutputDsmode) * 16);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Mem failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT7;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstMatchBgModelInfo->stDstStatData, 12);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT8;
    }

    s32Ret =
        SAMPLE_COMM_CVE_ReadFile(&pstMatchBgModelInfo->stSrcCur, pstMatchBgModelInfo->pFpSrcCur);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Cur Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT8;
    }
    s32Ret =
        SAMPLE_COMM_CVE_ReadFile(&pstMatchBgModelInfo->stSrcPre, pstMatchBgModelInfo->pFpSrcPre);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Pre Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT8;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile_On_Mem(&pstMatchBgModelInfo->stBgModel,
                                             pstMatchBgModelInfo->pFpBgModelPrev);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read dst model prev Image failed!\n", s32Ret);
        goto CVE_MATCHBG_EXIT8;
    }

    pstMatchBgModelInfo->stMatchBgModelCtrl.enOutputMode = u32OutputMode;
    pstMatchBgModelInfo->stMatchBgModelCtrl.enDownScaleMode = u32OutputDsmode;
    pstMatchBgModelInfo->stMatchBgModelCtrl.u8GrayThr = 20;
    pstMatchBgModelInfo->stMatchBgModelCtrl.u8q4DistThr = 560;
    goto CVE_MATCHBG_EXIT0;

CVE_MATCHBG_EXIT8:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stBgModel.u64VirAddr,
                 pstMatchBgModelInfo->stBgModel.u64VirAddr);
CVE_MATCHBG_EXIT7:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstFrmDiff.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstFrmDiff.au64VirAddr[0]);
CVE_MATCHBG_EXIT6:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstCurDiffBg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstCurDiffBg.au64VirAddr[0]);
CVE_MATCHBG_EXIT5:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstBg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstBg.au64VirAddr[0]);
CVE_MATCHBG_EXIT4:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stDstFg.au64PhyAddr[0],
                 pstMatchBgModelInfo->stDstFg.au64VirAddr[0]);
CVE_MATCHBG_EXIT3:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stSrcPre.au64PhyAddr[0],
                 pstMatchBgModelInfo->stSrcPre.au64VirAddr[0]);
CVE_MATCHBG_EXIT2:
    CVE_PMZ_FREE(pstMatchBgModelInfo->stSrcCur.au64PhyAddr[0],
                 pstMatchBgModelInfo->stSrcCur.au64VirAddr[0]);
CVE_MATCHBG_EXIT1:
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpSrcCur);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpSrcPre);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpBgModel);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstFg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstBg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstCurDiffBg);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstFrmDiff);
    CVE_CLOSE_FILE(pstMatchBgModelInfo->pFpDstStatData);
CVE_MATCHBG_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_MatchBgModelProc(SAMPLE_CVE_MatchBgModel_INFO_T *pstMatchBgModelInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret =
        CVE_MatchBgModel(&cveHandle, &pstMatchBgModelInfo->stSrcCur, &pstMatchBgModelInfo->stSrcPre,
                         &pstMatchBgModelInfo->stBgModel, &pstMatchBgModelInfo->stDstFg,
                         &pstMatchBgModelInfo->stDstBg, &pstMatchBgModelInfo->stDstCurDiffBg,
                         &pstMatchBgModelInfo->stDstFrmDiff, &pstMatchBgModelInfo->stDstStatData,
                         &pstMatchBgModelInfo->stMatchBgModelCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE MatchBgModel Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE MatchBgModel Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_MatchBgModelCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    AML_S32 i;
    AML_U32 u32OutputMode;
    AML_U32 u32OutputDsmode;
    AML_CHAR pFpSrc0Name[64] = {0};
    AML_CHAR pFpSrc1Name[64] = {0};
    AML_CHAR pFpDst0Name[64] = {0};
    AML_CHAR pFpDst1Name[64] = {0};
    AML_CHAR pFpDst2Name[64] = {0};
    AML_CHAR pFpDst3Name[64] = {0};
    AML_CHAR pFpDst4Name[64] = {0};
    AML_CHAR pFpDst4PrevName[64] = {0};
    AML_CHAR pFpDstStatDataName[64] = {0};
    stMatchBgModelInfo.stMatchBgModelCtrl.stCrop.enCrop = AML_FALSE;
    stMatchBgModelInfo.stMatchBgModelCtrl.stCrop.u16X = 0;
    stMatchBgModelInfo.stMatchBgModelCtrl.stCrop.u16Y = 0;
    stMatchBgModelInfo.stMatchBgModelCtrl.stCrop.u16Width = 200;
    stMatchBgModelInfo.stMatchBgModelCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] match bg mode case 0: output fg, not down sample.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_DISABLE;
        break;
    case 1:
        TEST_PRT("[INFO] match bg mode case 1: output fg, down sample 2x2.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_2X2;
        break;
    case 2:
        TEST_PRT("[INFO] match bg mode case 2: output fg, down sample 4x4.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_4X4;
        break;
    case 3:
        TEST_PRT("[INFO] match bg mode case 3: output fg and bg, not down sample.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_DISABLE;
        break;
    case 4:
        TEST_PRT("[INFO] match bg mode case 4: output fg and bg, down sample 2x2.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_2X2;
        break;
    case 5:
        TEST_PRT("[INFO] match bg mode case 5: output fg and bg, down sample 4x4.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_4X4;
        break;
    case 6:
        TEST_PRT("[INFO] match bg mode case 6: output fg, bg and gray fg, not down sample.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG_AND_CURDIFFBG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_DISABLE;
        break;
    case 7:
        TEST_PRT("[INFO] match bg mode case 7: output fg, bg and gray fg, down sample 2x2.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG_AND_CURDIFFBG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_2X2;
        break;
    case 8:
        TEST_PRT("[INFO] match bg mode case 8: output fg, bg and gray fg, down sample 4x4.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_FG_AND_BG_AND_CURDIFFBG;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_4X4;
        break;
    case 9:
        TEST_PRT("[INFO] match bg mode case 9: output fg, bg, gray fg and frame diff, not down "
                 "sample.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_ALL;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_DISABLE;
        break;
    case 10:
        TEST_PRT("[INFO] match bg mode case 10: output fg, bg, gray fg and frame diff, down sample "
                 "2x2.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_ALL;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_2X2;
        break;
    case 11:
        TEST_PRT("[INFO] match bg mode case 11: output fg, bg, gray fg and frame diff, down sample "
                 "4x4.\n");
        u32OutputMode = CVE_MATCH_BG_MODEL_OUTPUT_MODE_ALL;
        u32OutputDsmode = CVE_MATCH_BG_MODEL_DOWN_SCALE_MODE_4X4;
        break;
    default:
        printf("the match bg model case index is invalid! valid index:\n");
        SAMPLE_CVE_MatchBgModelCaseList();
        return AML_FAILURE;
    }

    for (i = 2; i < 8; i++) {
        memset(pFpSrc0Name, 0, 64);
        memset(pFpSrc1Name, 0, 64);
        memset(pFpDst0Name, 0, 64);
        memset(pFpDst1Name, 0, 64);
        memset(pFpDst2Name, 0, 64);
        memset(pFpDst3Name, 0, 64);
        memset(pFpDst4Name, 0, 64);
        memset(pFpDst4PrevName, 0, 64);
        memset(pFpDstStatDataName, 0, 64);
        sprintf(pFpSrc0Name, "/data/cve/hall_%d_y.yuv", i);
        sprintf(pFpSrc1Name, "/data/cve/hall_%d_y.yuv", i - 1);
        sprintf(pFpDst0Name, "/data/cve/matchbgmodel_fg_%d.out", i);
        sprintf(pFpDst1Name, "/data/cve/matchbgmodel_bg_%d.out", i);
        sprintf(pFpDst2Name, "/data/cve/matchbgmodel_curdiffbg_%d.out", i);
        sprintf(pFpDst3Name, "/data/cve/matchbgmodel_frmdiff_%d.out", i);
        sprintf(pFpDst4Name, "/data/cve/matchbgmodel_bg_model_%d.out", i);
        sprintf(pFpDst4PrevName, "/data/cve/matchbgmodel_bg_model_%d.out", i - 1);
        sprintf(pFpDstStatDataName, "/data/cve/matchbgmodel_stat_%d.out", i);
        printf("src cur img file name:%s\n", pFpSrc0Name);
        printf("src pre img file name:%s\n", pFpSrc1Name);
        printf("dst fg img file name :%s\n", pFpDst0Name);
        printf("dst bg img file name :%s\n", pFpDst1Name);
        printf("dst cur diff bg file name :%s\n", pFpDst2Name);
        printf("dst cur frm diff file name:%s\n", pFpDst3Name);
        printf("dst bg model img file name :%s\n", pFpDst4Name);
        printf("dst bg model prev img file name :%s\n", pFpDst4PrevName);
        printf("dst stat data file name   :%s\n", pFpDstStatDataName);

        s32Ret = SAMPLE_CVE_MatchBgModelInit(&stMatchBgModelInfo, pFpSrc0Name, pFpSrc1Name,
                                             pFpDst0Name, pFpDst1Name, pFpDst2Name, pFpDst3Name,
                                             pFpDst4Name, pFpDst4PrevName, pFpDstStatDataName,
                                             u32OutputMode, u32OutputDsmode, u32Width, u32Height);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterInit failed!\n", s32Ret);
            return s32Ret;
        }

        s32Ret = SAMPLE_CVE_MatchBgModelProc(&stMatchBgModelInfo);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterProc failed!\n", s32Ret);
        }

        SAMPLE_CVE_MatchBgModelUninit(&stMatchBgModelInfo);
        memset(&stMatchBgModelInfo, 0, sizeof(SAMPLE_CVE_MatchBgModel_INFO_T));
    }
    return s32Ret;
}
