/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDstMag;
    CVE_DST_IMAGE_T stDstAng;
    CVE_MAG_AND_ANG_CTRL_T stMagAndAngCtrl;

    FILE *pFpSrc;
    FILE *pFpDstMag;
    FILE *pFpDstAng;
} SAMPLE_CVE_MAG_ANG_INFO_T;

SAMPLE_CVE_MAG_ANG_INFO_T stMagAngInfo;

static AML_CHAR acMask0[25] = {0, 0, 0, 0,  0, 0, -1, 0, 1, 0, 0, -2, 0,
                               2, 0, 0, -1, 0, 1, 0,  0, 0, 0, 0, 0};

static AML_CHAR acMask1[25] = {-1, -2, 0,  2,  1, -4, -8, 0,  8,  4, -6, -12, 0,
                               12, 6,  -4, -8, 0, 8,  4,  -1, -2, 0, 2,  1};

static AML_CHAR acMask2[25] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0,
                               1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void SAMPLE_CVE_MagAngCaseList(void)
{
    printf("\t\t  0) Output:Mag MT:0  Thr:0.\n");
    printf("\t\t  1) Output:Mag MT:1  Thr:0.\n");
    printf("\t\t  2) Output:Mag and Ang MT:0 Thr:0.\n");
    printf("\t\t  3) Output:Mag and Ang MT:1 Thr:0.\n");
    printf("\t\t  4) Output:HOG MT:2 Thr:0.\n");
    return;
}

static AML_VOID SAMPLE_CVE_MagAngUninit(SAMPLE_CVE_MAG_ANG_INFO_T *pstMagAngInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstMagAngInfo->stDstMag, pstMagAngInfo->pFpDstMag);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Mag Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstMagAngInfo->stDstAng, pstMagAngInfo->pFpDstAng);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Ang Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstMagAngInfo->stSrc.au64PhyAddr[0], pstMagAngInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMagAngInfo->stDstMag.au64PhyAddr[0], pstMagAngInfo->stDstMag.au64VirAddr[0]);
    CVE_PMZ_FREE(pstMagAngInfo->stDstAng.au64PhyAddr[0], pstMagAngInfo->stDstAng.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstMagAngInfo->pFpSrc);
    CVE_CLOSE_FILE(pstMagAngInfo->pFpDstMag);
    CVE_CLOSE_FILE(pstMagAngInfo->pFpDstAng);
}

static AML_S32 SAMPLE_CVE_MagAngInit(SAMPLE_CVE_MAG_ANG_INFO_T *pstMagAngInfo, AML_U32 u32ModelType,
                                     CVE_MAG_AND_ANG_OUT_CTRL_E enOutCtrl, AML_U16 u16Thr,
                                     AML_U32 u32Width, AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                     AML_CHAR *pchDstMagFileName, AML_CHAR *pchDstAngFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstMagAngInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstMagAngInfo->stDstMag, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstMagAngInfo->stDstAng, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstMagAngInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstMagAngInfo->pFpDstMag, pchDstMagFileName, "w");
    CVE_OPEN_FILE(pstMagAngInfo->pFpDstAng, pchDstAngFileName, "w");

    if (u32ModelType == 0) {
        memcpy(&pstMagAngInfo->stMagAndAngCtrl.as8Mask, acMask0, 25);
    } else if (u32ModelType == 1) {
        memcpy(&pstMagAngInfo->stMagAndAngCtrl.as8Mask, acMask1, 25);
    } else {
        memcpy(&pstMagAngInfo->stMagAndAngCtrl.as8Mask, acMask2, 25);
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMagAngInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_MagAng_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMagAngInfo->stDstMag, CVE_IMAGE_TYPE_U16C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_MagAng_EXIT2;
    }

    if (enOutCtrl == CVE_MAG_AND_ANG_OUT_CTRL_MAG_AND_ANG) {
        s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMagAngInfo->stDstAng, CVE_IMAGE_TYPE_U8C1,
                                             u32Width, u32Height);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
            goto CVE_MagAng_EXIT3;
        }
    } else if (enOutCtrl == CVE_MAG_AND_ANG_OUT_CTRL_HOG) {
        s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstMagAngInfo->stDstAng, CVE_IMAGE_TYPE_U16C1,
                                             u32Width, u32Height);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
            goto CVE_MagAng_EXIT3;
        }
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstMagAngInfo->stSrc, pstMagAngInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_MagAng_EXIT4;
    }

    pstMagAngInfo->stMagAndAngCtrl.enOutCtrl = enOutCtrl;
    pstMagAngInfo->stMagAndAngCtrl.u16Thr = u16Thr;
    goto CVE_MagAng_EXIT0;

CVE_MagAng_EXIT4:
    CVE_PMZ_FREE(pstMagAngInfo->stDstAng.au64PhyAddr[0], pstMagAngInfo->stDstAng.au64VirAddr[0]);
CVE_MagAng_EXIT3:
    CVE_PMZ_FREE(pstMagAngInfo->stDstMag.au64PhyAddr[0], pstMagAngInfo->stDstMag.au64VirAddr[0]);
CVE_MagAng_EXIT2:
    CVE_PMZ_FREE(pstMagAngInfo->stSrc.au64PhyAddr[0], pstMagAngInfo->stSrc.au64VirAddr[0]);
CVE_MagAng_EXIT1:
    CVE_CLOSE_FILE(pstMagAngInfo->pFpSrc);
    CVE_CLOSE_FILE(pstMagAngInfo->pFpDstMag);
    CVE_CLOSE_FILE(pstMagAngInfo->pFpDstAng);
CVE_MagAng_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_MagAngProc(SAMPLE_CVE_MAG_ANG_INFO_T *pstMagAngInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_MagAndAng(&cveHandle, &pstMagAngInfo->stSrc, &pstMagAngInfo->stDstMag,
                           &pstMagAngInfo->stDstAng, &pstMagAngInfo->stMagAndAngCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE MagAndAng Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE MagAndAng Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_MagAngCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32ModelType;
    CVE_MAG_AND_ANG_OUT_CTRL_E enOutCtrl;
    AML_U16 u16Thr;
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstMagName = "/data/cve/mag.out";
    AML_CHAR *pFpDstAngName = "/data/cve/ang.out";
    stMagAngInfo.stMagAndAngCtrl.stCrop.enCrop = AML_FALSE;
    stMagAngInfo.stMagAndAngCtrl.stCrop.u16X = 0;
    stMagAngInfo.stMagAndAngCtrl.stCrop.u16Y = 0;
    stMagAngInfo.stMagAndAngCtrl.stCrop.u16Width = 200;
    stMagAngInfo.stMagAndAngCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] MagAng CASE 0: OT:Mag MT:0  THR:0\n");
        u32ModelType = 0;
        enOutCtrl = CVE_MAG_AND_ANG_OUT_CTRL_MAG;
        u16Thr = 0;
        break;
    case 1:
        TEST_PRT("[INFO] MagAng CASE 1: OT:Mag MT:1  THR:0\n");
        u32ModelType = 1;
        enOutCtrl = CVE_MAG_AND_ANG_OUT_CTRL_MAG;
        u16Thr = 0;
        break;
    case 2:
        TEST_PRT("[INFO] MagAng CASE 2: OT:Mag and Ang MT:0 THR:0\n");
        u32ModelType = 0;
        enOutCtrl = CVE_MAG_AND_ANG_OUT_CTRL_MAG_AND_ANG;
        u16Thr = 0;
        break;
    case 3:
        TEST_PRT("[INFO] MagAng CASE 3: OT:Mag and Ang MT:1 THR:0\n");
        u32ModelType = 1;
        enOutCtrl = CVE_MAG_AND_ANG_OUT_CTRL_MAG_AND_ANG;
        u16Thr = 0;
        break;
    case 4:
        TEST_PRT("[INFO] MagAng CASE 4: OT:HOG MT:2 THR:0\n");
        u32ModelType = 2;
        enOutCtrl = CVE_MAG_AND_ANG_OUT_CTRL_HOG;
        u16Thr = 0;
        break;
    default:
        printf("the magAndAng case index is invalid! valid index:\n");
        SAMPLE_CVE_MagAngCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst mag file name:%s\n", pFpDstMagName);
    printf("dst ang file name:%s\n", pFpDstAngName);

    s32Ret = SAMPLE_CVE_MagAngInit(&stMagAngInfo, u32ModelType, enOutCtrl, u16Thr, u32Width,
                                   u32Height, pFpSrcName, pFpDstMagName, pFpDstAngName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_MagAngInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_MagAngProc(&stMagAngInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_MagAngProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_MagAngUninit(&stMagAngInfo);
    memset(&stMagAngInfo, 0, sizeof(SAMPLE_CVE_MAG_ANG_INFO_T));

    return s32Ret;
}
