/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_MEM_INFO_T stDst;
    CVE_RECT_U16_T astCveLumaRect[CVE_LUMA_RECT_MAX];
    CVE_LUMA_STAT_ARRAY_CTRL_T stLumaStatCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_LUMA_STAT_INFO_T;

SAMPLE_CVE_LUMA_STAT_INFO_T stLumaStatInfo;

void SAMPLE_CVE_LumaStatCaseList(void)
{
    printf("\t\t  0) Step 0.\n");
    printf("\t\t  1) Step 1.\n");
    printf("\t\t  2) Step 2.\n");
    printf("\t\t  3) Step 3.\n");
    return;
}

static AML_VOID SAMPLE_CVE_LumaStatUninit(SAMPLE_CVE_LUMA_STAT_INFO_T *pstLumaStatInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstLumaStatInfo->stDst, pstLumaStatInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Data failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstLumaStatInfo->stSrc.au64PhyAddr[0], pstLumaStatInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstLumaStatInfo->stDst.u64PhyAddr, pstLumaStatInfo->stDst.u64VirAddr);
    CVE_CLOSE_FILE(pstLumaStatInfo->pFpSrc);
    CVE_CLOSE_FILE(pstLumaStatInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_LumaStatInit(SAMPLE_CVE_LUMA_STAT_INFO_T *pstLumaStatInfo,
                                       CVE_LUMA_STAT_MODE_E enMode, AML_CHAR *pchSrcFileName,
                                       AML_CHAR *pchDstFileName, AML_U32 u32Width,
                                       AML_U32 u32Height)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_U32 u32Size;
    AML_U16 u16X;
    AML_U16 u16Y;
    AML_U16 u16XSize = 8;
    AML_U16 u16YSize = 8;
    AML_U16 u16RectIndex = 0;

    memset(&pstLumaStatInfo->stSrc, 0, sizeof(CVE_SRC_DATA_T));
    memset(&pstLumaStatInfo->stDst, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstLumaStatInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstLumaStatInfo->pFpDst, pchDstFileName, "w");

    pstLumaStatInfo->stLumaStatCtrl.enMode = enMode;
    pstLumaStatInfo->stLumaStatCtrl.u8MaxLumaRect = 32;

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstLumaStatInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Data failed!\n", s32Ret);
        goto CVE_FILTER_LUMA_STAT_EXIT1;
    }

    u32Size = pstLumaStatInfo->stLumaStatCtrl.u8MaxLumaRect * sizeof(AML_U32) * 4;
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstLumaStatInfo->stDst, u32Size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Data failed!\n", s32Ret);
        goto CVE_FILTER_LUMA_STAT_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstLumaStatInfo->stSrc, pstLumaStatInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Data failed!\n", s32Ret);
        goto CVE_FILTER_LUMA_STAT_EXIT3;
    }

    for (u16X = 0; u16X < u32Width; u16X += 2) {
        if (u16RectIndex >= pstLumaStatInfo->stLumaStatCtrl.u8MaxLumaRect) {
            break;
        }
        for (u16Y = 0; u16Y < u32Height; u16Y += 2) {
            pstLumaStatInfo->astCveLumaRect[u16RectIndex].u16X = u16X;
            pstLumaStatInfo->astCveLumaRect[u16RectIndex].u16Y = u16Y;
            pstLumaStatInfo->astCveLumaRect[u16RectIndex].u16Width = u16XSize;
            pstLumaStatInfo->astCveLumaRect[u16RectIndex].u16Height = u16YSize;
            u16RectIndex++;
            if (u16RectIndex >= pstLumaStatInfo->stLumaStatCtrl.u8MaxLumaRect) {
                break;
            }
        }
    }

    goto CVE_FILTER_LUMA_STAT_EXIT0;

CVE_FILTER_LUMA_STAT_EXIT3:
    CVE_PMZ_FREE(pstLumaStatInfo->stDst.u64PhyAddr, pstLumaStatInfo->stDst.u64VirAddr);
CVE_FILTER_LUMA_STAT_EXIT2:
    CVE_PMZ_FREE(pstLumaStatInfo->stSrc.au64PhyAddr[0], pstLumaStatInfo->stSrc.au64VirAddr[0]);
CVE_FILTER_LUMA_STAT_EXIT1:
    CVE_CLOSE_FILE(pstLumaStatInfo->pFpSrc);
    CVE_CLOSE_FILE(pstLumaStatInfo->pFpDst);
CVE_FILTER_LUMA_STAT_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_LumaStatProc(SAMPLE_CVE_LUMA_STAT_INFO_T *pstLumaStatInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = CVE_LumaStatArray(&cveHandle, &pstLumaStatInfo->stSrc, &pstLumaStatInfo->stDst,
                               pstLumaStatInfo->astCveLumaRect, &pstLumaStatInfo->stLumaStatCtrl,
                               bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Luma Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Luma Query error\n");
        return s32Ret;
    }
    return s32Ret;
}

AML_S32 SAMPLE_CVE_LumaStatCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    CVE_LUMA_STAT_MODE_E enMode;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/dma_luma.out";
    stLumaStatInfo.stLumaStatCtrl.stCrop.enCrop = AML_FALSE;
    stLumaStatInfo.stLumaStatCtrl.stCrop.u16X = 0;
    stLumaStatInfo.stLumaStatCtrl.stCrop.u16Y = 0;
    stLumaStatInfo.stLumaStatCtrl.stCrop.u16Width = 200;
    stLumaStatInfo.stLumaStatCtrl.stCrop.u16Height = 200;
    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] LumaStat CASE 0: Step 0\n");
        enMode = CVE_LUMA_STAT_MODE_STEP_0;
        break;
    case 1:
        TEST_PRT("[INFO] LumaStat CASE 1: Step 1\n");
        enMode = CVE_LUMA_STAT_MODE_STEP_1;
        break;
    case 2:
        TEST_PRT("[INFO] LumaStat CASE 2: Step 2\n");
        enMode = CVE_LUMA_STAT_MODE_STEP_2;
        break;
    case 3:
        TEST_PRT("[INFO] LumaStat CASE 3: Step 3\n");
        enMode = CVE_LUMA_STAT_MODE_STEP_3;
        break;
    default:
        printf("the LumaStat case index is invalid! valid index:\n");
        SAMPLE_CVE_LumaStatCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);
    s32Ret = SAMPLE_CVE_LumaStatInit(&stLumaStatInfo, enMode, pFpSrcName, pFpDstName, u32Width,
                                     u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LumaStatInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_LumaStatProc(&stLumaStatInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LumaStatProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_LumaStatUninit(&stLumaStatInfo);
    memset(&stLumaStatInfo, 0, sizeof(SAMPLE_CVE_LUMA_STAT_INFO_T));

    return s32Ret;
}
