/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T astSrcPrev[4];
    CVE_DST_IMAGE_T astSrcNext[4];
    CVE_SRC_MEM_INFO_T stPrevPts;
    CVE_SRC_MEM_INFO_T stNextPts;
    CVE_DST_MEM_INFO_T stStatus;
    CVE_LK_OPTICAL_FLOW_PYR_CTRL_T stLkOptiFlowPyrCtrl;
    FILE *pFpSrcPrev[4];
    FILE *pFpSrcNext[4];
    FILE *pFpSrcPrevPts;
    FILE *pFpSrcNextPts;
    FILE *pFpDstStat;
} SAMPLE_CVE_LkOpticalFlowPyr_INFO_T;

SAMPLE_CVE_LkOpticalFlowPyr_INFO_T stLKOptiFlowPyrInfo;

void SAMPLE_CVE_LKOpticalFlowPyrCaseList(void)
{
    printf("\t\t  0) LK Optical Flow Pyr, input layer:1.\n");
    printf("\t\t  1) LK Optical Flow Pyr, input layer:2.\n");
    printf("\t\t  2) LK Optical Flow Pyr, input layer:3.\n");
    printf("\t\t  3) LK Optical Flow Pyr, input layer:4.\n");
    return;
}

static AML_VOID
SAMPLE_CVE_LKOpticalFlowPyrUninit(SAMPLE_CVE_LkOpticalFlowPyr_INFO_T *pstLkOptiFlowPyrInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_S32 i = 0;

    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstLkOptiFlowPyrInfo->stStatus,
                                                pstLkOptiFlowPyrInfo->pFpDstStat);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Status Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stPrevPts.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stPrevPts.u64VirAddr);
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stNextPts.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stNextPts.u64VirAddr);
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stStatus.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stStatus.u64VirAddr);
    for (i = 0; i < pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->astSrcPrev[i].au64PhyAddr[0],
                     pstLkOptiFlowPyrInfo->astSrcPrev[i].au64VirAddr[0]);
        CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->astSrcNext[i].au64PhyAddr[0],
                     pstLkOptiFlowPyrInfo->astSrcNext[i].au64VirAddr[0]);
        CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrev[i]);
        CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcNext[i]);
    }
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrevPts);
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcNextPts);
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpDstStat);
}

static AML_S32 SAMPLE_CVE_LKOpticalFlowPyrInit(
    SAMPLE_CVE_LkOpticalFlowPyr_INFO_T *pstLkOptiFlowPyrInfo, AML_U32 u32Width, AML_U32 u32Height,
    AML_CHAR (*pchSrcPrevFileName)[64], AML_CHAR (*pchSrcNextFileName)[64],
    AML_CHAR *pchSrcPrevPtsName, AML_CHAR *PchSrcNextPtsName, AML_CHAR *pchDstStatName)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_S32 i;

    memset(&pstLkOptiFlowPyrInfo->astSrcPrev, 0, sizeof(CVE_SRC_IMAGE_T) * 4);
    memset(&pstLkOptiFlowPyrInfo->astSrcNext, 0, sizeof(CVE_DST_IMAGE_T) * 4);
    memset(&pstLkOptiFlowPyrInfo->stPrevPts, 0, sizeof(CVE_SRC_MEM_INFO_T));
    memset(&pstLkOptiFlowPyrInfo->stNextPts, 0, sizeof(CVE_SRC_MEM_INFO_T));
    memset(&pstLkOptiFlowPyrInfo->stStatus, 0, sizeof(CVE_SRC_MEM_INFO_T));

    for (i = 0; i <= pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_OPEN_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrev[i], pchSrcPrevFileName[i], "r+");
        CVE_OPEN_FILE(pstLkOptiFlowPyrInfo->pFpSrcNext[i], pchSrcNextFileName[i], "r+");
    }
    CVE_OPEN_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrevPts, pchSrcPrevPtsName, "r+");
    CVE_OPEN_FILE(pstLkOptiFlowPyrInfo->pFpSrcNextPts, PchSrcNextPtsName, "r+");
    CVE_OPEN_FILE(pstLkOptiFlowPyrInfo->pFpDstStat, pchDstStatName, "w");

    for (i = 0; i <= pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstLkOptiFlowPyrInfo->astSrcPrev[i],
                                             CVE_IMAGE_TYPE_U8C1, u32Width >> i, u32Height >> i);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Create Prev Src %d Image failed!\n", s32Ret, i);
            goto CVE_LK_OPTICALFLOWPYR_EXIT1;
        }
    }
    for (i = 0; i <= pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstLkOptiFlowPyrInfo->astSrcNext[i],
                                             CVE_IMAGE_TYPE_U8C1, u32Width >> i, u32Height >> i);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Create Next Src %d Image failed!\n", s32Ret, i);
            goto CVE_LK_OPTICALFLOWPYR_EXIT2;
        }
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstLkOptiFlowPyrInfo->stPrevPts,
                                           u32Width * u32Height * sizeof(CVE_POINT_S12Q7_T));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Prev pts failed!\n", s32Ret);
        goto CVE_LK_OPTICALFLOWPYR_EXIT3;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstLkOptiFlowPyrInfo->stNextPts,
                                           u32Width * u32Height * sizeof(CVE_POINT_S12Q7_T));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Next pts failed!\n", s32Ret);
        goto CVE_LK_OPTICALFLOWPYR_EXIT4;
    }
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstLkOptiFlowPyrInfo->stStatus, 17 * sizeof(AML_U32));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Status failed!\n", s32Ret);
        goto CVE_LK_OPTICALFLOWPYR_EXIT5;
    }

    for (i = 0; i < pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstLkOptiFlowPyrInfo->astSrcPrev[i],
                                          pstLkOptiFlowPyrInfo->pFpSrcPrev[i]);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Read Src %d Prev Image failed!\n", s32Ret, i);
            goto CVE_LK_OPTICALFLOWPYR_EXIT6;
        }
        s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstLkOptiFlowPyrInfo->astSrcNext[i],
                                          pstLkOptiFlowPyrInfo->pFpSrcNext[i]);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Read Src %d Prev Image failed!\n", s32Ret, i);
            goto CVE_LK_OPTICALFLOWPYR_EXIT6;
        }
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile_On_Mem(&pstLkOptiFlowPyrInfo->stPrevPts,
                                             pstLkOptiFlowPyrInfo->pFpSrcPrevPts);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src %d Prev Image failed!\n", s32Ret, i);
        goto CVE_LK_OPTICALFLOWPYR_EXIT6;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile_On_Mem(&pstLkOptiFlowPyrInfo->stNextPts,
                                             pstLkOptiFlowPyrInfo->pFpSrcNextPts);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src %d Prev Image failed!\n", s32Ret, i);
        goto CVE_LK_OPTICALFLOWPYR_EXIT6;
    }
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.bUseInitFlow = 1;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.u16PtsNum = 50;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.enOutMode = CVE_LK_OPTICAL_FLOW_PYR_OUT_MODE_NONE;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.u8IterCnt = 10;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.u0q8Eps = 10;

    goto CVE_LK_OPTICALFLOWPYR_EXIT0;

CVE_LK_OPTICALFLOWPYR_EXIT6:
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stStatus.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stStatus.u64VirAddr);
CVE_LK_OPTICALFLOWPYR_EXIT5:
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stNextPts.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stNextPts.u64VirAddr);
CVE_LK_OPTICALFLOWPYR_EXIT4:
    CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->stPrevPts.u64PhyAddr,
                 pstLkOptiFlowPyrInfo->stPrevPts.u64VirAddr);
CVE_LK_OPTICALFLOWPYR_EXIT3:
    for (i = 0; i < pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->astSrcNext[i].au64PhyAddr[0],
                     pstLkOptiFlowPyrInfo->astSrcNext[i].au64VirAddr[0]);
    }
CVE_LK_OPTICALFLOWPYR_EXIT2:
    for (i = 0; i < pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_PMZ_FREE(pstLkOptiFlowPyrInfo->astSrcPrev[i].au64PhyAddr[0],
                     pstLkOptiFlowPyrInfo->astSrcPrev[i].au64VirAddr[0]);
    }
CVE_LK_OPTICALFLOWPYR_EXIT1:
    for (i = 0; i < pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrev[i]);
        CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcNext[i]);
    }
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcPrevPts);
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpSrcNextPts);
    CVE_CLOSE_FILE(pstLkOptiFlowPyrInfo->pFpDstStat);
CVE_LK_OPTICALFLOWPYR_EXIT0:

    return s32Ret;
}

static AML_S32
SAMPLE_CVE_LKOpticalFlowPyrProc(SAMPLE_CVE_LkOpticalFlowPyr_INFO_T *pstLkOptiFlowPyrInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle = CVE_INVALID_POOL_HANDLE;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_LKOpticalFlowPyr(
        &cveHandle, pstLkOptiFlowPyrInfo->astSrcPrev, pstLkOptiFlowPyrInfo->astSrcNext,
        &pstLkOptiFlowPyrInfo->stPrevPts, &pstLkOptiFlowPyrInfo->stNextPts,
        &pstLkOptiFlowPyrInfo->stStatus, &pstLkOptiFlowPyrInfo->stLkOptiFlowPyrCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE LKOpticalFlowPyr Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE LKOpticalFlowPyr Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_LKOpticalFlowPyrCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    AML_S32 i;
    CVE_LK_OPTICAL_FLOW_PYR_CTRL_T *pstLkOptiFlowPyrCtrl = &stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl;
    AML_CHAR *SrcName = "/data/cve/input/u8c1.in";
    AML_CHAR pFpSrcPrevName[4][64] = {0};
    AML_CHAR pFpSrcNextName[4][64] = {0};
    AML_CHAR pFpSrcPrevPtsName[64] = {0};
    AML_CHAR pFpSrcNextPtsName[64] = {0};
    AML_CHAR *pFpDstStatName = "/data/cve/LKOPtFlowPyrStat.out";

    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.stCrop.enCrop = AML_FALSE;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.stCrop.u16X = 0;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.stCrop.u16Y = 0;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.stCrop.u16Width = 200;
    stLKOptiFlowPyrInfo.stLkOptiFlowPyrCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] LKOpticalFlowPyr CASE 0: Input layer 1 \n");
        pstLkOptiFlowPyrCtrl->u8MaxLevel = 0;
        break;
    case 1:
        TEST_PRT("[INFO] LKOpticalFlowPyr CASE 1: Input layer 2 \n");
        pstLkOptiFlowPyrCtrl->u8MaxLevel = 1;
        break;
    case 2:
        TEST_PRT("[INFO] LKOpticalFlowPyr CASE 2: Input layer 3 \n");
        pstLkOptiFlowPyrCtrl->u8MaxLevel = 2;
        break;
    case 3:
        TEST_PRT("[INFO] LKOpticalFlowPyr CASE 3: Input layer 4 \n");
        pstLkOptiFlowPyrCtrl->u8MaxLevel = 3;
        break;
    default:
        printf("the Build LK Optical Flow Pyr case index is invalid! valid index:\n");
        SAMPLE_CVE_LKOpticalFlowPyrCaseList();
        return AML_FAILURE;
    }

    for (i = 0; i <= pstLkOptiFlowPyrCtrl->u8MaxLevel; i++) {
        printf("please input astSrcPrev%d file name:", i);
        SAMPLE_COMM_CVE_Input_FileName(pFpSrcPrevName[i], sizeof(pFpSrcPrevName[i]), SrcName);
    }
    for (i = 0; i <= pstLkOptiFlowPyrCtrl->u8MaxLevel; i++) {
        printf("please input astSrcNext%d file name:", i);
        SAMPLE_COMM_CVE_Input_FileName(pFpSrcNextName[i], sizeof(pFpSrcNextName[i]), SrcName);
    }
    printf("please input stSrcPrevPts file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcPrevPtsName, sizeof(pFpSrcPrevPtsName), SrcName);
    printf("please input stSrcNextfile name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcNextPtsName, sizeof(pFpSrcNextPtsName), SrcName);

    for (i = 0; i <= pstLkOptiFlowPyrCtrl->u8MaxLevel; i++) {
        printf("srcPrev%d file name:%s\n", i, pFpSrcPrevName[i]);
    }
    for (i = 0; i <= pstLkOptiFlowPyrCtrl->u8MaxLevel; i++) {
        printf("srcNext%d file name:%s\n", i, pFpSrcNextName[i]);
    }
    printf("srcPrevPts file name:%s\n", pFpSrcPrevPtsName);
    printf("srcNextPts file name:%s\n", pFpSrcNextPtsName);
    printf("Dst stat file name:%s\n", pFpDstStatName);

    s32Ret = SAMPLE_CVE_LKOpticalFlowPyrInit(&stLKOptiFlowPyrInfo, u32Width, u32Height,
                                             pFpSrcPrevName, pFpSrcNextName, pFpSrcPrevPtsName,
                                             pFpSrcNextPtsName, pFpDstStatName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LKOpticalFlowPyrInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_LKOpticalFlowPyrProc(&stLKOptiFlowPyrInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LKOpticalFlowPyrProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_LKOpticalFlowPyrUninit(&stLKOptiFlowPyrInfo);
    memset(&stLKOptiFlowPyrInfo, 0, sizeof(SAMPLE_CVE_LkOpticalFlowPyr_INFO_T));

    return s32Ret;
}
