/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_LBP_CTRL_T stLbpCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_LBP_INFO_T;

SAMPLE_CVE_LBP_INFO_T stLbpInfo;

void SAMPLE_CVE_LbpCaseList(void)
{
    printf("\t\t  0) LbpMode: Normal.\n");
    printf("\t\t  1) LbpMode: Abs.\n");
    return;
}

static AML_VOID SAMPLE_CVE_LbpUninit(SAMPLE_CVE_LBP_INFO_T *pstLbpInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstLbpInfo->stDst, pstLbpInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstLbpInfo->stSrc.au64PhyAddr[0], pstLbpInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstLbpInfo->stDst.au64PhyAddr[0], pstLbpInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstLbpInfo->pFpSrc);
    CVE_CLOSE_FILE(pstLbpInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_LbpInit(SAMPLE_CVE_LBP_INFO_T *pstLbpInfo, AML_U32 u32Width,
                                  AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                  AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstLbpInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstLbpInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstLbpInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstLbpInfo->pFpDst, pchDstFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstLbpInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_LBP_EXIT1;
    }

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstLbpInfo->stDst, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_LBP_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstLbpInfo->stSrc, pstLbpInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_LBP_EXIT3;
    }
    goto CVE_LBP_EXIT0;

CVE_LBP_EXIT3:
    CVE_PMZ_FREE(pstLbpInfo->stDst.au64PhyAddr[0], pstLbpInfo->stDst.au64VirAddr[0]);
CVE_LBP_EXIT2:
    CVE_PMZ_FREE(pstLbpInfo->stSrc.au64PhyAddr[0], pstLbpInfo->stSrc.au64VirAddr[0]);
CVE_LBP_EXIT1:
    CVE_CLOSE_FILE(pstLbpInfo->pFpSrc);
    CVE_CLOSE_FILE(pstLbpInfo->pFpDst);
CVE_LBP_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_LbpProc(SAMPLE_CVE_LBP_INFO_T *pstLbpInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_LBP(&cveHandle, &pstLbpInfo->stSrc, &pstLbpInfo->stDst, &pstLbpInfo->stLbpCtrl,
                     bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Lbp Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Lbp Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_LbpCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    CVE_LBP_CTRL_T *pstLbpCtrl = &stLbpInfo.stLbpCtrl;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/Lbp.out";

    stLbpInfo.stLbpCtrl.stCrop.enCrop = AML_TRUE;
    stLbpInfo.stLbpCtrl.stCrop.u16X = 0;
    stLbpInfo.stLbpCtrl.stCrop.u16Y = 0;
    stLbpInfo.stLbpCtrl.stCrop.u16Width = 200;
    stLbpInfo.stLbpCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] Lbp CASE 0: LbpMode: Normal\n");
        pstLbpCtrl->enMode = CVE_LBP_CMP_MODE_NORMAL;
        pstLbpCtrl->un8BitThr.s8Val = 41;
        break;
    case 1:
        TEST_PRT("[INFO] Lbp CASE 1: LbpMode: Abs\n");
        pstLbpCtrl->enMode = CVE_LBP_CMP_MODE_ABS;
        pstLbpCtrl->un8BitThr.s8Val = 41;
        break;
    default:
        printf("the Lbp case index is invalid! valid index:\n");
        SAMPLE_CVE_LbpCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_LbpInit(&stLbpInfo, u32Width, u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LbpInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_LbpProc(&stLbpInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_LbpProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_LbpUninit(&stLbpInfo);
    memset(&stLbpInfo, 0, sizeof(SAMPLE_CVE_LBP_INFO_T));

    return s32Ret;
}
