/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_INTEG_CTRL_T stIntegCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_INTEG_INFO_T;

SAMPLE_CVE_INTEG_INFO_T stIntegInfo;

void SAMPLE_CVE_IntegCaseList(void)
{
    printf("\t\t  0) DstType:U64C1 Output:Combine.\n");
    printf("\t\t  1) DstType:U32C1 Output:Sum.\n");
    printf("\t\t  2) DstType:U64C1 Output:Sqsum.\n");
    return;
}

static AML_VOID SAMPLE_CVE_IntegUninit(SAMPLE_CVE_INTEG_INFO_T *pstIntegInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstIntegInfo->stDst, pstIntegInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstIntegInfo->stSrc.au64PhyAddr[0], pstIntegInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstIntegInfo->stDst.au64PhyAddr[0], pstIntegInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstIntegInfo->pFpSrc);
    CVE_CLOSE_FILE(pstIntegInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_IntegInit(SAMPLE_CVE_INTEG_INFO_T *pstIntegInfo,
                                    CVE_IMAGE_TYPE_E enDstType, AML_U32 u32Width, AML_U32 u32Height,
                                    AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstIntegInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstIntegInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstIntegInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstIntegInfo->pFpDst, pchDstFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstIntegInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_INTEG_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstIntegInfo->stDst, enDstType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_INTEG_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstIntegInfo->stSrc, pstIntegInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_INTEG_EXIT3;
    }

    goto CVE_INTEG_EXIT0;

CVE_INTEG_EXIT3:
    CVE_PMZ_FREE(pstIntegInfo->stDst.au64PhyAddr[0], pstIntegInfo->stDst.au64VirAddr[0]);
CVE_INTEG_EXIT2:
    CVE_PMZ_FREE(pstIntegInfo->stSrc.au64PhyAddr[0], pstIntegInfo->stSrc.au64VirAddr[0]);
CVE_INTEG_EXIT1:
    CVE_CLOSE_FILE(pstIntegInfo->pFpSrc);
    CVE_CLOSE_FILE(pstIntegInfo->pFpDst);
CVE_INTEG_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_IntegProc(SAMPLE_CVE_INTEG_INFO_T *pstIntegInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_Integ(&cveHandle, &pstIntegInfo->stSrc, &pstIntegInfo->stDst,
                       &pstIntegInfo->stIntegCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Integ Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Integ Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_IntegCase(AML_U32 u32CaseIndex)
{
    CVE_IMAGE_TYPE_E enDstType;
    CVE_INTEG_CTRL_T *pstIntegCtrl = &stIntegInfo.stIntegCtrl;
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/integ.out";
    stIntegInfo.stIntegCtrl.stCrop.enCrop = AML_FALSE;
    stIntegInfo.stIntegCtrl.stCrop.u16X = 0;
    stIntegInfo.stIntegCtrl.stCrop.u16Y = 0;
    stIntegInfo.stIntegCtrl.stCrop.u16Width = 200;
    stIntegInfo.stIntegCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] INTEG CASE 0: DstType:U64C1 Output:Combine\n");
        enDstType = CVE_IMAGE_TYPE_U64C1;
        pstIntegCtrl->enOutCtrl = CVE_INTEG_OUT_CTRL_COMBINE;
        break;
    case 1:
        TEST_PRT("[INFO] INTEG CASE 1: DstType:U32C1 Output:Sum\n");
        enDstType = CVE_IMAGE_TYPE_U32C1;
        pstIntegCtrl->enOutCtrl = CVE_INTEG_OUT_CTRL_TUM;
        break;
    case 2:
        TEST_PRT("[INFO] INTEG CASE 2: DstType:U64C1 Output:Sqsum\n");
        enDstType = CVE_IMAGE_TYPE_U64C1;
        pstIntegCtrl->enOutCtrl = CVE_INTEG_OUT_CTRL_TQSUM;
        break;
    default:
        printf("the integ case index is invalid! valid index:\n");
        SAMPLE_CVE_IntegCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret =
        SAMPLE_CVE_IntegInit(&stIntegInfo, enDstType, u32Width, u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_IntegInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_IntegProc(&stIntegInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_IntegProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_IntegUninit(&stIntegInfo);
    memset(&stIntegInfo, 0, sizeof(SAMPLE_CVE_INTEG_INFO_T));

    return s32Ret;
}
