/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_MEM_INFO_T stDst;
    CVE_HIST_CTRL_T stHistCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_HIST_INFO_T;

SAMPLE_CVE_HIST_INFO_T stHistInfo;

void SAMPLE_CVE_HistCaseList(void)
{
    printf("\t\t  0) Hist.\n");
    return;
}

static AML_VOID SAMPLE_CVE_HistUninit(SAMPLE_CVE_HIST_INFO_T *pstHistInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstHistInfo->stDst, pstHistInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstHistInfo->stSrc.au64PhyAddr[0], pstHistInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstHistInfo->stDst.u64PhyAddr, pstHistInfo->stDst.u64VirAddr);
    CVE_CLOSE_FILE(pstHistInfo->pFpSrc);
    CVE_CLOSE_FILE(pstHistInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_HistInit(SAMPLE_CVE_HIST_INFO_T *pstHistInfo, AML_U32 u32Width,
                                   AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                   AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstHistInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstHistInfo->stDst, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstHistInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstHistInfo->pFpDst, pchDstFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstHistInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_HIST_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstHistInfo->stDst, CVE_HIST_NUM * sizeof(AML_U32) * 2);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_HIST_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstHistInfo->stSrc, pstHistInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_HIST_EXIT3;
    }
    goto CVE_HIST_EXIT0;

CVE_HIST_EXIT3:
    CVE_PMZ_FREE(pstHistInfo->stDst.u64PhyAddr, pstHistInfo->stDst.u64VirAddr);
CVE_HIST_EXIT2:
    CVE_PMZ_FREE(pstHistInfo->stSrc.au64PhyAddr[0], pstHistInfo->stSrc.au64VirAddr[0]);
CVE_HIST_EXIT1:
    CVE_CLOSE_FILE(pstHistInfo->pFpSrc);
    CVE_CLOSE_FILE(pstHistInfo->pFpDst);
CVE_HIST_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_HistProc(SAMPLE_CVE_HIST_INFO_T *pstHistInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_Hist(&cveHandle, &pstHistInfo->stSrc, &pstHistInfo->stDst,
                      &pstHistInfo->stHistCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Hist Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Hist Query error\n");
        return s32Ret;
    }
    return s32Ret;
}

AML_S32 SAMPLE_CVE_HistCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/hist.out";
    stHistInfo.stHistCtrl.stCrop.enCrop = AML_FALSE;
    stHistInfo.stHistCtrl.stCrop.u16X = 0;
    stHistInfo.stHistCtrl.stCrop.u16Y = 0;
    stHistInfo.stHistCtrl.stCrop.u16Width = 60;
    stHistInfo.stHistCtrl.stCrop.u16Height = 60;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] HIST CASE 0: Hist\n");
        break;
    default:
        printf("the integ case index is invalid! valid index:\n");
        SAMPLE_CVE_HistCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_HistInit(&stHistInfo, u32Width, u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_HistInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_HistProc(&stHistInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_HistProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_HistUninit(&stHistInfo);
    memset(&stHistInfo, 0, sizeof(SAMPLE_CVE_HIST_INFO_T));

    return s32Ret;
}
