/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stFg;
    CVE_SRC_IMAGE_T stCurGrad;
    CVE_SRC_IMAGE_T stBgGrad;
    CVE_DST_IMAGE_T stGradFg;
    CVE_GRAD_FG_CTRL_T stGradFgCtrl;
    FILE *pFpBgDiffFg;
    FILE *pFpCurGrad;
    FILE *pFpBgGrad;
    FILE *pFpGradFg;
} SAMPLE_CVE_GRAD_FG_INFO_T;

SAMPLE_CVE_GRAD_FG_INFO_T stGradFgInfo;

void SAMPLE_CVE_GradFgCaseList(void)
{
    printf("\t\t  0) GradFgMode0: direct.\n");
    printf("\t\t  1) GradFgMode1: thr.\n");
    printf("\t\t  2) GradFgMode2: thr fg.\n");
    printf("\t\t  3) GradFgMode3: fg.\n");
    return;
}

static AML_VOID SAMPLE_CVE_GradFgUninit(SAMPLE_CVE_GRAD_FG_INFO_T *pstGradFgInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstGradFgInfo->stGradFg, pstGradFgInfo->pFpGradFg);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstGradFgInfo->stFg.au64PhyAddr[0], pstGradFgInfo->stFg.au64VirAddr[0]);
    CVE_PMZ_FREE(pstGradFgInfo->stCurGrad.au64PhyAddr[0], pstGradFgInfo->stCurGrad.au64VirAddr[0]);
    CVE_PMZ_FREE(pstGradFgInfo->stBgGrad.au64PhyAddr[0], pstGradFgInfo->stBgGrad.au64VirAddr[0]);
    CVE_PMZ_FREE(pstGradFgInfo->stGradFg.au64PhyAddr[0], pstGradFgInfo->stGradFg.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpBgDiffFg);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpCurGrad);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpBgGrad);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpGradFg);
}

static AML_S32 SAMPLE_CVE_GradFgInit(SAMPLE_CVE_GRAD_FG_INFO_T *pstGradFgInfo, AML_U32 u32Width,
                                     AML_U32 u32Height, AML_CHAR *pchBgDiffFgFileName,
                                     AML_CHAR *pchCurGradFileName, AML_CHAR *pchBgGradFileName,
                                     AML_CHAR *pchGradFgFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstGradFgInfo->stFg, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstGradFgInfo->stCurGrad, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstGradFgInfo->stBgGrad, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstGradFgInfo->stGradFg, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstGradFgInfo->pFpBgDiffFg, pchBgDiffFgFileName, "r+");
    CVE_OPEN_FILE(pstGradFgInfo->pFpCurGrad, pchCurGradFileName, "r+");
    CVE_OPEN_FILE(pstGradFgInfo->pFpBgGrad, pchBgGradFileName, "r+");
    CVE_OPEN_FILE(pstGradFgInfo->pFpGradFg, pchGradFgFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstGradFgInfo->stFg, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Fg Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstGradFgInfo->stCurGrad, CVE_IMAGE_TYPE_S8C2_PACKAGE,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Cur Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstGradFgInfo->stBgGrad, CVE_IMAGE_TYPE_S8C2_PACKAGE,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src bg Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstGradFgInfo->stGradFg, CVE_IMAGE_TYPE_S8C2_PACKAGE,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT4;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstGradFgInfo->stFg, pstGradFgInfo->pFpBgDiffFg);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src fg Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT5;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstGradFgInfo->stCurGrad, pstGradFgInfo->pFpCurGrad);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src cur grad Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT5;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstGradFgInfo->stBgGrad, pstGradFgInfo->pFpBgGrad);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src bg grad Image failed!\n", s32Ret);
        goto CVE_GRAD_FG_EXIT1;
    }
    pstGradFgInfo->stGradFgCtrl.u8MinMagDiff = 0;
    goto CVE_GRAD_FG_EXIT0;

CVE_GRAD_FG_EXIT5:
    CVE_PMZ_FREE(pstGradFgInfo->stGradFg.au64PhyAddr[0], pstGradFgInfo->stGradFg.au64VirAddr[0]);
CVE_GRAD_FG_EXIT4:
    CVE_PMZ_FREE(pstGradFgInfo->stBgGrad.au64PhyAddr[0], pstGradFgInfo->stBgGrad.au64VirAddr[0]);
CVE_GRAD_FG_EXIT3:
    CVE_PMZ_FREE(pstGradFgInfo->stCurGrad.au64PhyAddr[0], pstGradFgInfo->stCurGrad.au64VirAddr[0]);
CVE_GRAD_FG_EXIT2:
    CVE_PMZ_FREE(pstGradFgInfo->stFg.au64PhyAddr[0], pstGradFgInfo->stFg.au64VirAddr[0]);
CVE_GRAD_FG_EXIT1:
    CVE_CLOSE_FILE(pstGradFgInfo->pFpBgDiffFg);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpCurGrad);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpBgGrad);
    CVE_CLOSE_FILE(pstGradFgInfo->pFpGradFg);
CVE_GRAD_FG_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_GradFgProc(SAMPLE_CVE_GRAD_FG_INFO_T *pstGradFgInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_GradFg(&cveHandle, &pstGradFgInfo->stFg, &pstGradFgInfo->stCurGrad,
                        &pstGradFgInfo->stBgGrad, &pstGradFgInfo->stGradFg,
                        &pstGradFgInfo->stGradFgCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE GradFg Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE GradFg Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_GradFgCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    CVE_GRAD_FG_CTRL_T *pstGradFgCtrl = &stGradFgInfo.stGradFgCtrl;
    AML_CHAR *Src1Name = "/data/cve/hall_1_y.yuv";
    AML_CHAR *Src2Name = "/data/cve/s8c2bg.yuv";
    AML_CHAR *Src3Name = "/data/cve/s8c2cur.yuv";
    AML_CHAR pFpSrc1Name[64] = {0};
    AML_CHAR pFpSrc2Name[64] = {0};
    AML_CHAR pFpSrc3Name[64] = {0};
    AML_CHAR *pFpDstName = "/root/image/GradFg/output/GradFg.out";

    stGradFgInfo.stGradFgCtrl.stCrop.enCrop = AML_FALSE;
    stGradFgInfo.stGradFgCtrl.stCrop.u16X = 0;
    stGradFgInfo.stGradFgCtrl.stCrop.u16Y = 0;
    stGradFgInfo.stGradFgCtrl.stCrop.u16Width = 200;
    stGradFgInfo.stGradFgCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] GradFg CASE 0: GradFgMode: Direct\n");
        pstGradFgCtrl->enMode = CVE_GRAD_FG_MODE_DIRECT;
        break;
    case 1:
        TEST_PRT("[INFO] GradFg CASE 1: GradFgMode: Thr\n");
        pstGradFgCtrl->enMode = CVE_GRAD_FG_MODE_THR;
        break;
    case 2:
        TEST_PRT("[INFO] GradFg CASE 2: GradFgMode: Thr Fg\n");
        pstGradFgCtrl->enMode = CVE_GRAD_FG_MODE_THR_FG;
        break;
    case 3:
        TEST_PRT("[INFO] GradFg CASE 3: GradFgMode: Fg\n");
        pstGradFgCtrl->enMode = CVE_GRAD_FG_MODE_FG;
        break;
    default:
        printf("the GradFg case index is invalid! valid index:\n");
        SAMPLE_CVE_GradFgCaseList();
        return AML_FAILURE;
    }

    printf("please input src fg file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc1Name, sizeof(pFpSrc1Name), Src1Name);
    printf("please input src cur grad file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc2Name, sizeof(pFpSrc2Name), Src2Name);
    printf("please input src bg file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrc3Name, sizeof(pFpSrc3Name), Src3Name);
    printf("src file fg name:%s\n", pFpSrc1Name);
    printf("src file cur grad name:%s\n", pFpSrc2Name);
    printf("src file bg name:%s\n", pFpSrc3Name);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_GradFgInit(&stGradFgInfo, u32Width, u32Height, pFpSrc1Name, pFpSrc2Name,
                                   pFpSrc3Name, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_GradFgInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_GradFgProc(&stGradFgInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_GradFgProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_GradFgUninit(&stGradFgInfo);
    memset(&stGradFgInfo, 0, sizeof(SAMPLE_CVE_GRAD_FG_INFO_T));

    return s32Ret;
}
