/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_FILTER_AND_CSC_CTRL_T stFilterCscCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_FILTER_CSC_INFO_T;

SAMPLE_CVE_FILTER_CSC_INFO_T stFilterCscInfo;

static AML_CHAR acMask0[25] = {0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 2, 4,
                               2, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0};

static AML_CHAR acMask1[25] = {1, 2, 3, 2, 1, 2, 5, 6, 5, 2, 3, 6, 8,
                               6, 3, 2, 5, 6, 5, 2, 1, 2, 3, 2, 1};

void SAMPLE_CVE_FilterCscCaseList(void)
{
    printf("\t\t  0) ST:YUV420SP DT:U8C3_PLANAR FT:1.\n");
    printf("\t\t  1) ST:YUV420SP DT:U8C3_PACKAGE FT:1.\n");
    printf("\t\t  2) ST:YUV422SP DT:U8C3_PLANAR FT:1.\n");
    printf("\t\t  3) ST:YUV422SP DT:U8C3_PACKAGE FT:1.\n");
    printf("\t\t  4) ST:YUV420SP DT:U8C3_PLANAR FT:0.\n");
    printf("\t\t  5) ST:YUV420SP DT:U8C3_PACKAGE FT:0.\n");
    printf("\t\t  6) ST:YUV422SP DT:U8C3_PLANAR FT:0.\n");
    printf("\t\t  7) ST:YUV422SP DT:U8C3_PACKAGE FT:0.\n");
    return;
}

static AML_VOID SAMPLE_CVE_FilterCscUninit(SAMPLE_CVE_FILTER_CSC_INFO_T *pstFilterCscInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstFilterCscInfo->stDst, pstFilterCscInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstFilterCscInfo->stSrc.au64PhyAddr[0], pstFilterCscInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstFilterCscInfo->stDst.au64PhyAddr[0], pstFilterCscInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstFilterCscInfo->pFpSrc);
    CVE_CLOSE_FILE(pstFilterCscInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_FilterCscInit(SAMPLE_CVE_FILTER_CSC_INFO_T *pstFilterCscInfo,
                                        CVE_IMAGE_TYPE_E enSrcType, CVE_IMAGE_TYPE_E enDstType,
                                        AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName,
                                        AML_U32 u32FilterType, AML_U32 u32Width, AML_U32 u32Height)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstFilterCscInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstFilterCscInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstFilterCscInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstFilterCscInfo->pFpDst, pchDstFileName, "w");

    if (u32FilterType == 0) {
        memcpy(&pstFilterCscInfo->stFilterCscCtrl.as8Mask, acMask0, 25);
        pstFilterCscInfo->stFilterCscCtrl.u8Norm = 4;
    } else {
        memcpy(&pstFilterCscInfo->stFilterCscCtrl.as8Mask, acMask1, 25);
        pstFilterCscInfo->stFilterCscCtrl.u8Norm = 7;
    }
    pstFilterCscInfo->stFilterCscCtrl.enMode = CVE_CSC_MODE_PIC_BT601_YUV2RGB;

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstFilterCscInfo->stSrc, enSrcType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_FILTERCSC_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstFilterCscInfo->stDst, enDstType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_FILTERCSC_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstFilterCscInfo->stSrc, pstFilterCscInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_FILTERCSC_EXIT3;
    }
    goto CVE_FILTERCSC_EXIT0;

CVE_FILTERCSC_EXIT3:
    CVE_PMZ_FREE(pstFilterCscInfo->stDst.au64PhyAddr[0], pstFilterCscInfo->stDst.au64VirAddr[0]);
CVE_FILTERCSC_EXIT2:
    CVE_PMZ_FREE(pstFilterCscInfo->stSrc.au64PhyAddr[0], pstFilterCscInfo->stSrc.au64VirAddr[0]);
CVE_FILTERCSC_EXIT1:
    CVE_CLOSE_FILE(pstFilterCscInfo->pFpSrc);
    CVE_CLOSE_FILE(pstFilterCscInfo->pFpDst);
CVE_FILTERCSC_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_FilterCscProc(SAMPLE_CVE_FILTER_CSC_INFO_T *pstFilterCscInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_FilterAndCSC(&cveHandle, &pstFilterCscInfo->stSrc, &pstFilterCscInfo->stDst,
                              &pstFilterCscInfo->stFilterCscCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE FilterAndCSC Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE FilterAndCSC Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_FilterCscCase(AML_U32 u32CaseIndex)
{
    CVE_IMAGE_TYPE_E enSrcType;
    CVE_IMAGE_TYPE_E enDstType;
    AML_U32 u32FilterType;
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_SP422.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/filterandcsc.out";
    stFilterCscInfo.stFilterCscCtrl.stCrop.enCrop = AML_FALSE;
    stFilterCscInfo.stFilterCscCtrl.stCrop.u16X = 0;
    stFilterCscInfo.stFilterCscCtrl.stCrop.u16Y = 0;
    stFilterCscInfo.stFilterCscCtrl.stCrop.u16Width = 200;
    stFilterCscInfo.stFilterCscCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] FilterCSC CASE 0: ST:YUV420SP DT:U8C3_PLANAR FT:1\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        u32FilterType = 1;
        break;
    case 1:
        TEST_PRT("[INFO] FilterCSC CASE 1: ST:YUV420SP DT:U8C3_PACKAGE FT:1\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        u32FilterType = 1;
        break;
    case 2:
        TEST_PRT("[INFO] FilterCSC CASE 2: ST:YUV422SP DT:U8C3_PLANAR FT:1\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        u32FilterType = 1;
        break;
    case 3:
        TEST_PRT("[INFO] FilterCSC CASE 3: ST:YUV422SP DT:U8C3_PACKAGE FT:1\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        u32FilterType = 1;
        break;
    case 4:
        TEST_PRT("[INFO] FilterCSC CASE 4: ST:YUV420SP DT:U8C3_PLANAR FT:0\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        u32FilterType = 0;
        break;
    case 5:
        TEST_PRT("[INFO] FilterCSC CASE 5: ST:YUV420SP DT:U8C3_PACKAGE FT:0\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        u32FilterType = 0;
        break;
    case 6:
        TEST_PRT("[INFO] FilterCSC CASE 6: ST:YUV422SP DT:U8C3_PLANAR FT:0\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        u32FilterType = 0;
        break;
    case 7:
        TEST_PRT("[INFO] FilterCSC CASE 7: ST:YUV422SP DT:U8C3_PLANAR FT:0\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        u32FilterType = 0;
        break;
    default:
        printf("the filter_csc case index is invalid! valid index:\n");
        SAMPLE_CVE_FilterCscCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_FilterCscInit(&stFilterCscInfo, enSrcType, enDstType, pFpSrcName,
                                      pFpDstName, u32FilterType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterCscInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_FilterCscProc(&stFilterCscInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_FilterCscProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_FilterCscUninit(&stFilterCscInfo);
    memset(&stFilterCscInfo, 0, sizeof(SAMPLE_CVE_FILTER_CSC_INFO_T));

    return s32Ret;
}
