/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef enum {
    CVE_OP_ERODE = 0x0,
    CVE_OP_DILATE = 0x1,
} CVE_ERODE_DILATE_OP_E;

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_ERODE_DILATE_OP_E enOp;
    CVE_DILATE_CTRL_T stDilateCtrl;
    CVE_ERODE_CTRL_T stErodeCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_ERODE_DILATE_INFO_T;

SAMPLE_CVE_ERODE_DILATE_INFO_T stErodeDilateInfo;

AML_CHAR acMask0[25] = {0,   0, 0, 0, 0,   0, 0, 255, 0, 0, 0, 255, 255,
                        255, 0, 0, 0, 255, 0, 0, 0,   0, 0, 0, 0};

AML_CHAR acMask1[25] = {0,   0,   255, 0,   0,   0,   255, 255, 255, 0,   255, 255, 255,
                        255, 255, 0,   255, 255, 255, 0,   0,   0,   255, 0,   0};

void SAMPLE_CVE_ErodeDilateCaseList(void)
{
    printf("\t\t  0) OP:Erode FT:0.\n");
    printf("\t\t  1) OP:Erode FT:1.\n");
    printf("\t\t  2) OP:Dilate FT:0.\n");
    printf("\t\t  3) OP:Dilate FT:1.\n");

    return;
}

static AML_VOID SAMPLE_CVE_ErodeDilateUninit(SAMPLE_CVE_ERODE_DILATE_INFO_T *pstErodeDilateInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstErodeDilateInfo->stDst, pstErodeDilateInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pstErodeDilateInfo->stSrc.au64PhyAddr[0],
                 pstErodeDilateInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstErodeDilateInfo->stDst.au64PhyAddr[0],
                 pstErodeDilateInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstErodeDilateInfo->pFpSrc);
    CVE_CLOSE_FILE(pstErodeDilateInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_ErodeDilateInit(SAMPLE_CVE_ERODE_DILATE_INFO_T *pstErodeDilateInfo,
                                          AML_U32 u32FilterType, AML_U32 u32Width,
                                          AML_U32 u32Height, CVE_ERODE_DILATE_OP_E enOp,
                                          AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstErodeDilateInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstErodeDilateInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstErodeDilateInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstErodeDilateInfo->pFpDst, pchDstFileName, "w");

    if (u32FilterType == 0) {
        if (enOp == CVE_OP_ERODE) {
            memcpy(&pstErodeDilateInfo->stErodeCtrl.au8Mask, acMask0, 25);
        } else if (enOp == CVE_OP_DILATE) {
            memcpy(&pstErodeDilateInfo->stDilateCtrl.au8Mask, acMask0, 25);
        } else {
            TEST_PRT("[ERROR]Invalid mode!\n");
            s32Ret = AML_FAILURE;
            return s32Ret;
        }
    } else {
        if (enOp == CVE_OP_ERODE) {
            memcpy(&pstErodeDilateInfo->stErodeCtrl.au8Mask, acMask1, 25);
        } else if (enOp == CVE_OP_DILATE) {
            memcpy(&pstErodeDilateInfo->stDilateCtrl.au8Mask, acMask1, 25);
        } else {
            TEST_PRT("[ERROR]Invalid mode!\n");
            s32Ret = AML_FAILURE;
            return s32Ret;
        }
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstErodeDilateInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_ERODE_DILATE_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstErodeDilateInfo->stDst, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_ERODE_DILATE_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstErodeDilateInfo->stSrc, pstErodeDilateInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_ERODE_DILATE_EXIT3;
    }
    pstErodeDilateInfo->enOp = enOp;
    goto CVE_ERODE_DILATE_EXIT0;

CVE_ERODE_DILATE_EXIT3:
    CVE_PMZ_FREE(pstErodeDilateInfo->stDst.au64PhyAddr[0],
                 pstErodeDilateInfo->stDst.au64VirAddr[0]);
CVE_ERODE_DILATE_EXIT2:
    CVE_PMZ_FREE(pstErodeDilateInfo->stSrc.au64PhyAddr[0],
                 pstErodeDilateInfo->stSrc.au64VirAddr[0]);
CVE_ERODE_DILATE_EXIT1:
    CVE_CLOSE_FILE(pstErodeDilateInfo->pFpSrc);
    CVE_CLOSE_FILE(pstErodeDilateInfo->pFpDst);
CVE_ERODE_DILATE_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_ErodeDilateProc(SAMPLE_CVE_ERODE_DILATE_INFO_T *pstErodeDilateInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    if (pstErodeDilateInfo->enOp == CVE_OP_ERODE) {
        s32Ret = CVE_Erode(&cveHandle, &pstErodeDilateInfo->stSrc, &pstErodeDilateInfo->stDst,
                           &pstErodeDilateInfo->stErodeCtrl, bInstant);
    } else if (pstErodeDilateInfo->enOp == CVE_OP_DILATE) {
        s32Ret = CVE_Dilate(&cveHandle, &pstErodeDilateInfo->stSrc, &pstErodeDilateInfo->stDst,
                            &pstErodeDilateInfo->stDilateCtrl, bInstant);
    } else {
        TEST_PRT("[ERROR]Invalid mode!\n");
        s32Ret = AML_FAILURE;
    }
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Erode or Dilate Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Erode or Dilate Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_ErodeDilateCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32FilterType;
    CVE_ERODE_DILATE_OP_E enOp = CVE_OP_ERODE;
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_bi_conversion.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/erodedilat.out";
    stErodeDilateInfo.stDilateCtrl.stCrop.enCrop = AML_FALSE;
    stErodeDilateInfo.stDilateCtrl.stCrop.u16X = 0;
    stErodeDilateInfo.stDilateCtrl.stCrop.u16Y = 0;
    stErodeDilateInfo.stDilateCtrl.stCrop.u16Width = 200;
    stErodeDilateInfo.stDilateCtrl.stCrop.u16Height = 200;

    stErodeDilateInfo.stErodeCtrl.stCrop.enCrop = AML_FALSE;
    stErodeDilateInfo.stErodeCtrl.stCrop.u16X = 0;
    stErodeDilateInfo.stErodeCtrl.stCrop.u16Y = 0;
    stErodeDilateInfo.stErodeCtrl.stCrop.u16Width = 200;
    stErodeDilateInfo.stErodeCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] ErodeDilate CASE 0: OP:Erode FT:0\n");
        u32FilterType = 0;
        enOp = CVE_OP_ERODE;
        break;
    case 1:
        TEST_PRT("[INFO] ErodeDilate CASE 1: OP:Erode FT:1\n");
        u32FilterType = 1;
        enOp = CVE_OP_ERODE;
        break;
    case 2:
        TEST_PRT("[INFO] ErodeDilate CASE 2: OP:Dilate FT:0\n");
        u32FilterType = 0;
        enOp = CVE_OP_DILATE;
        break;
    case 3:
        TEST_PRT("[INFO] ErodeDilate CASE 3: OP:Dilate FT:1\n");
        u32FilterType = 1;
        enOp = CVE_OP_DILATE;
        break;
    default:
        printf("the erode and dilate case index is invalid! valid index:\n");
        SAMPLE_CVE_ErodeDilateCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_ErodeDilateInit(&stErodeDilateInfo, u32FilterType, u32Width, u32Height,
                                        enOp, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ErodeDilateInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_ErodeDilateProc(&stErodeDilateInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_ErodeDilateProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_ErodeDilateUninit(&stErodeDilateInfo);
    memset(&stErodeDilateInfo, 0, sizeof(SAMPLE_CVE_ERODE_DILATE_INFO_T));

    return s32Ret;
}
