/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_EQUALIZE_HIST_CTRL_T stEqualizeHistCtrl;
    FILE *pFpSrc;
    FILE *pFpSrcEqhist;
    FILE *pFpDst;
} SAMPLE_CVE_EQUALIZE_HIST_INFO_T;

SAMPLE_CVE_EQUALIZE_HIST_INFO_T stEqualizeHistInfo;

void SAMPLE_CVE_EqualizeHistCaseList(void)
{
    printf("\t\t  0) EqualizeHist.\n");
    return;
}

static AML_VOID SAMPLE_CVE_EqualizeHistUninit(SAMPLE_CVE_EQUALIZE_HIST_INFO_T *pstEqualizeHistInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstEqualizeHistInfo->stDst, pstEqualizeHistInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstEqualizeHistInfo->stSrc.au64PhyAddr[0],
                 pstEqualizeHistInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstEqualizeHistInfo->stDst.au64PhyAddr[0],
                 pstEqualizeHistInfo->stDst.au64VirAddr[0]);
    CVE_PMZ_FREE(pstEqualizeHistInfo->stEqualizeHistCtrl.stMem.u64PhyAddr,
                 pstEqualizeHistInfo->stEqualizeHistCtrl.stMem.u64VirAddr);
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpSrc);
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpSrcEqhist);
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_EqualizeHistInit(SAMPLE_CVE_EQUALIZE_HIST_INFO_T *pstEqualizeHistInfo,
                                           AML_U32 u32Width, AML_U32 u32Height,
                                           AML_CHAR *pchSrcFileName, AML_CHAR *pchSrcEquFileName,
                                           AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstEqualizeHistInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstEqualizeHistInfo->stEqualizeHistCtrl.stMem, 0, sizeof(CVE_SRC_MEM_INFO_T));
    memset(&pstEqualizeHistInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstEqualizeHistInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstEqualizeHistInfo->pFpSrcEqhist, pchSrcEquFileName, "r+");
    CVE_OPEN_FILE(pstEqualizeHistInfo->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstEqualizeHistInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_EQUALIZE_HIST_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstEqualizeHistInfo->stDst, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_EQUALIZE_HIST_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstEqualizeHistInfo->stEqualizeHistCtrl.stMem,
                                           sizeof(CVE_EQUALIZE_HIST_CTRL_MEM_T));
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_EQUALIZE_HIST_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstEqualizeHistInfo->stSrc, pstEqualizeHistInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_EQUALIZE_HIST_EXIT4;
    }
    s32Ret = SAMPLE_COMM_CVE_ReadFile_On_Mem(&pstEqualizeHistInfo->stEqualizeHistCtrl.stMem,
                                             pstEqualizeHistInfo->pFpSrcEqhist);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_EQUALIZE_HIST_EXIT4;
    }

    goto CVE_EQUALIZE_HIST_EXIT0;

CVE_EQUALIZE_HIST_EXIT4:
    CVE_PMZ_FREE(pstEqualizeHistInfo->stEqualizeHistCtrl.stMem.u64PhyAddr,
                 pstEqualizeHistInfo->stEqualizeHistCtrl.stMem.u64VirAddr);
CVE_EQUALIZE_HIST_EXIT3:
    CVE_PMZ_FREE(pstEqualizeHistInfo->stDst.au64PhyAddr[0],
                 pstEqualizeHistInfo->stDst.au64VirAddr[0]);
CVE_EQUALIZE_HIST_EXIT2:
    CVE_PMZ_FREE(pstEqualizeHistInfo->stSrc.au64PhyAddr[0],
                 pstEqualizeHistInfo->stSrc.au64VirAddr[0]);
CVE_EQUALIZE_HIST_EXIT1:
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpSrc);
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpSrcEqhist);
    CVE_CLOSE_FILE(pstEqualizeHistInfo->pFpDst);
CVE_EQUALIZE_HIST_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_EqualizeHistProc(SAMPLE_CVE_EQUALIZE_HIST_INFO_T *pstEqualizeHistInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_EqualizeHist(&cveHandle, &pstEqualizeHistInfo->stSrc, &pstEqualizeHistInfo->stDst,
                              &pstEqualizeHistInfo->stEqualizeHistCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE EqualizeHist Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE EqualizeHist Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_EqualizeHistCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR *SrcEqhistName = "/data/cve/hist.in";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR pFpSrcEqhistName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/EqualizeHist.out";

    stEqualizeHistInfo.stEqualizeHistCtrl.stCrop.enCrop = AML_FALSE;
    stEqualizeHistInfo.stEqualizeHistCtrl.stCrop.u16X = 0;
    stEqualizeHistInfo.stEqualizeHistCtrl.stCrop.u16Y = 0;
    stEqualizeHistInfo.stEqualizeHistCtrl.stCrop.u16Width = 200;
    stEqualizeHistInfo.stEqualizeHistCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] EqualizeHist CASE 0: EqualizeHist.\n");
        break;
    default:
        printf("the equalizeHist case index is invalid! valid index:\n");
        SAMPLE_CVE_EqualizeHistCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("please input src Eqhist file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcEqhistName, sizeof(pFpSrcEqhistName), SrcEqhistName);
    printf("src file name:%s\n", pFpSrcName);
    printf("src file name:%s\n", pFpSrcEqhistName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_EqualizeHistInit(&stEqualizeHistInfo, u32Width, u32Height, pFpSrcName,
                                         pFpSrcEqhistName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_EqualizeHistInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_EqualizeHistProc(&stEqualizeHistInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_EqualizeHistProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_EqualizeHistUninit(&stEqualizeHistInfo);
    memset(&stEqualizeHistInfo, 0, sizeof(SAMPLE_CVE_EQUALIZE_HIST_INFO_T));

    return s32Ret;
}
