/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_CSC_CTRL_T stCscCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_CSC_INFO_T;

SAMPLE_CVE_CSC_INFO_T stCscInfo;

void SAMPLE_CVE_CscCaseList(void)
{
    printf("\t\t  0) SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2HSV.\n");
    printf("\t\t  1) SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2HSV.\n");
    printf("\t\t  2) SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2RGB.\n");
    printf("\t\t  3) SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2RGB.\n");
    printf("\t\t  4) SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2LAB.\n");
    printf("\t\t  5) SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2LAB.\n");
    printf("\t\t  6) SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2HSV.\n");
    printf("\t\t  7) SrcType:YUV422SP DstType:U8C3_PACKAGE CscMode:YUV2HSV.\n");
    printf("\t\t  8) SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2RGB.\n");
    printf("\t\t  9) SrcType:YUV422SP DstType:U8C3_PACKAGE CscMode:YUV2RGB.\n");
    printf("\t\t  10) SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2LAB.\n");
    printf("\t\t  11) SrcType:YUV422SP DstType:U8C3_PACKAGE CscMode:YUV2LAB.\n");
    printf("\t\t  12) SrcType:U8C3_PACKAGE DstType:YUV420SP CscMode:RGB2YUV.\n");
    printf("\t\t  13) SrcType:U8C3_PACKAGE DstType:YUV422SP CscMode:RGB2YUV.\n");
    printf("\t\t  14) SrcType:U8C3_PLANAR DstType:YUV420SP CscMode:RGB2YUV.\n");
    printf("\t\t  15) SrcType:U8C3_PLANAR DstType:YUV422SP CscMode:RGB2YUV.\n");
    printf("\t\t  16) SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2BGR.\n");
    printf("\t\t  17) SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2BGR.\n");
    printf("\t\t  18) SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2BGR.\n");
    printf("\t\t  19) SrcType:YUV422SP DstType:U8C3_PACKAGE CscMode:YUV2BGR.\n");
    printf("\t\t  20) SrcType:U8C3_PLANAR DstType:YUV420SP CscMode:BGR2YUV.\n");
    printf("\t\t  21) SrcType:U8C3_PACKAGE DstType:YUV420SP CscMode:BGR2YUV.\n");
    printf("\t\t  22) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2HSV.\n");
    printf("\t\t  23) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2HSV.\n");
    printf("\t\t  24) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2LAB.\n");
    printf("\t\t  25) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2LAB.\n");
    printf("\t\t  26) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2BGR.\n");
    printf("\t\t  27) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2BGR.\n");
    printf("\t\t  28) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2RGB.\n");
    printf("\t\t  29) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2RGB.\n");
    printf("\t\t  30) SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2HSV.\n");
    printf("\t\t  31) SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2HSV.\n");
    printf("\t\t  32) SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2RGB.\n");
    printf("\t\t  33) SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2RGB.\n");
    printf("\t\t  34) SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2LAB.\n");
    printf("\t\t  35) SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2LAB.\n");
    printf("\t\t  36) SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2BGR.\n");
    printf("\t\t  37) SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2BGR.\n");
    printf("\t\t  38) SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2HSV.\n");
    printf("\t\t  39) SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2HSV.\n");
    printf("\t\t  40) SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2RGB.\n");
    printf("\t\t  41) SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2RGB.\n");
    printf("\t\t  42) SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2LAB.\n");
    printf("\t\t  43) SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2LAB.\n");
    printf("\t\t  44) SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2BGR.\n");
    printf("\t\t  45) SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2BGR.\n");
    printf("\t\t  46) SrcType:U8C3_PACKAGE DstType:YVU420SP CscMode:RGB2YVU.\n");
    printf("\t\t  47) SrcType:U8C3_PACKAGE DstType:YVU422SP CscMode:RGB2YVU.\n");
    printf("\t\t  48) SrcType:U8C3_PLANAR DstType:YVU420SP CscMode:RGB2YVU.\n");
    printf("\t\t  49) SrcType:U8C3_PLANAR DstType:YVU422SP CscMode:RGB2YVU.\n");
    printf("\t\t  50) SrcType:U8C3_PLANAR DstType:YVU420SP CscMode:BGR2YUV.\n");
    printf("\t\t  51) SrcType:U8C3_PACKAGE DstType:YVU420SP CscMode:BGR2YUV.\n");
    printf("\t\t  52) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2HSV.\n");
    printf("\t\t  53) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2HSV.\n");
    printf("\t\t  54) SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2LAB.\n");
    printf("\t\t  55) SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2LAB.\n");
    return;
}

static AML_VOID SAMPLE_CVE_CscUninit(SAMPLE_CVE_CSC_INFO_T *pstCscInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstCscInfo->stDst, pstCscInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstCscInfo->stSrc.au64PhyAddr[0], pstCscInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstCscInfo->stDst.au64PhyAddr[0], pstCscInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstCscInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCscInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_CscInit(SAMPLE_CVE_CSC_INFO_T *pstCscInfo, CVE_IMAGE_TYPE_E enSrcType,
                                  CVE_IMAGE_TYPE_E enDstType, CVE_CSC_MODE_E enCscMode,
                                  AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName,
                                  AML_U32 u32Width, AML_U32 u32Height)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pstCscInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstCscInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pstCscInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstCscInfo->pFpDst, pchDstFileName, "w");

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstCscInfo->stSrc, enSrcType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_CSC_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstCscInfo->stDst, enDstType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_CSC_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstCscInfo->stSrc, pstCscInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_CSC_EXIT3;
    }

    pstCscInfo->stCscCtrl.enMode = enCscMode;
    goto CVE_CSC_EXIT0;

CVE_CSC_EXIT3:
    CVE_PMZ_FREE(pstCscInfo->stDst.au64PhyAddr[0], pstCscInfo->stDst.au64VirAddr[0]);
CVE_CSC_EXIT2:
    CVE_PMZ_FREE(pstCscInfo->stSrc.au64PhyAddr[0], pstCscInfo->stSrc.au64VirAddr[0]);
CVE_CSC_EXIT1:
    CVE_CLOSE_FILE(pstCscInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCscInfo->pFpDst);
CVE_CSC_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_CscProc(SAMPLE_CVE_CSC_INFO_T *pstCscInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_CSC(&cveHandle, &pstCscInfo->stSrc, &pstCscInfo->stDst, &pstCscInfo->stCscCtrl,
                     bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE CSC Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE CSC Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_CscCase(AML_U32 u32CaseIndex)
{
    CVE_IMAGE_TYPE_E enSrcType;
    CVE_IMAGE_TYPE_E enDstType;
    AML_U32 u32Width = 1920;
    AML_U32 u32Height = 1080;
    CVE_CSC_MODE_E enCscMode;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/09140_yuv420sp.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/csc.out";
    stCscInfo.stCscCtrl.stCrop.enCrop = AML_FALSE;
    stCscInfo.stCscCtrl.stCrop.u16X = 0;
    stCscInfo.stCscCtrl.stCrop.u16Y = 0;
    stCscInfo.stCscCtrl.stCrop.u16Width = 60;
    stCscInfo.stCscCtrl.stCrop.u16Height = 60;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] CSC CASE 0: SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2HSV;
        break;
    case 1:
        TEST_PRT("[INFO] CSC CASE 1: SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2HSV;
        break;
    case 2:
        TEST_PRT("[INFO] CSC CASE 2: SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2RGB;
        break;
    case 3:
        TEST_PRT("[INFO] CSC CASE 3: SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2RGB;
        break;
    case 4:
        TEST_PRT("[INFO] CSC CASE 4: SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2LAB;
        break;
    case 5:
        TEST_PRT("[INFO] CSC CASE 5: SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2LAB;
        break;
    case 6:
        TEST_PRT("[INFO] CSC CASE 6: SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2HSV;
        break;
    case 7:
        TEST_PRT("[INFO] CSC CASE 7: SrcType:YUV422SP DstType: U8C3_PACKAGE CscMode:YUV2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2HSV;
        break;
    case 8:
        TEST_PRT("[INFO] CSC CASE 8: SrcType:YUV422SP DstType: U8C3_PLANAR CscMode:YUV2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2RGB;
        break;
    case 9:
        TEST_PRT("[INFO] CSC CASE 9: SrcType:YUV422SP DstType: U8C3_PACKAGE CscMode:YUV2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2RGB;
        break;
    case 10:
        TEST_PRT("[INFO] CSC CASE 10: SrcType:YUV422SP DstType: U8C3_PLANAR CscMode:YUV2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2LAB;
        break;
    case 11:
        TEST_PRT("[INFO] CSC CASE 11: SrcType:YUV422SP DstType: U8C3_PACKAGE CscMode:YUV2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2LAB;
        break;
    case 12:
        TEST_PRT("[INFO] CSC CASE 12: SrcType:U8C3_PACKAGE DstType:YUV420SP CscMode:RGB2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YUV420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YUV;
        break;
    case 13:
        TEST_PRT("[INFO] CSC CASE 13: SrcType:U8C3_PACKAGE DstType: YUV422SP CscMode:RGB2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YUV422SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YUV;
        break;
    case 14:
        TEST_PRT("[INFO] CSC CASE 14: SrcType:U8C3_PACKAGE DstType: YUV420SP CscMode:RGB2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YUV420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YUV;
        break;
    case 15:
        TEST_PRT("[INFO] CSC CASE 15: SrcType:U8C3_PLANAR DstType: YUV422SP CscMode:RGB2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YUV422SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YUV;
        break;
    case 16:
        TEST_PRT("[INFO] CSC CASE 16: SrcType:YUV420SP DstType:U8C3_PLANAR CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2BGR;
        break;
    case 17:
        TEST_PRT("[INFO] CSC CASE 17: SrcType:YUV420SP DstType:U8C3_PACKAGE CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YUV420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2BGR;
        break;
    case 18:
        TEST_PRT("[INFO] CSC CASE 18: SrcType:YUV422SP DstType:U8C3_PLANAR CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2BGR;
        break;
    case 19:
        TEST_PRT("[INFO] CSC CASE 19: SrcType:YUV422SP DstType:U8C3_PACKAGE CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YUV422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YUV2BGR;
        break;
    case 20:
        TEST_PRT("[INFO] CSC CASE 20: SrcType:U8C3_PLANAR DstType:YUV420SP CscMode:BGR2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YUV420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2YUV;
        break;
    case 21:
        TEST_PRT("[INFO] CSC CASE 21: SrcType:U8C3_PACKAGE DstType:YUV420SP CscMode:BGR2YUV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YUV420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2YUV;
        break;
    case 22:
        TEST_PRT("[INFO] CSC CASE 22: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2HSV;
        break;
    case 23:
        TEST_PRT("[INFO] CSC CASE 23: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2HSV;
        break;
    case 24:
        TEST_PRT("[INFO] CSC CASE 24: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2LAB;
        break;
    case 25:
        TEST_PRT("[INFO] CSC CASE 25: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2LAB;
        break;
    case 26:
        TEST_PRT("[INFO] CSC CASE 26: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:RGB2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2BGR;
        break;
    case 27:
        TEST_PRT("[INFO] CSC CASE 27: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:RGB2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2BGR;
        break;
    case 28:
        TEST_PRT("[INFO] CSC CASE 28: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2RGB;
        break;
    case 29:
        TEST_PRT("[INFO] CSC CASE 29: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2RGB;
        break;
    case 30:
        TEST_PRT("[INFO] CSC CASE 30: SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2HSV;
        break;
    case 31:
        TEST_PRT("[INFO] CSC CASE 31: SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2HSV;
        break;
    case 32:
        TEST_PRT("[INFO] CSC CASE 32: SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2RGB;
        break;
    case 33:
        TEST_PRT("[INFO] CSC CASE 33: SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2RGB;
        break;
    case 34:
        TEST_PRT("[INFO] CSC CASE 34: SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YVU2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2LAB;
        break;
    case 35:
        TEST_PRT("[INFO] CSC CASE 35: SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YVU2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2LAB;
        break;
    case 36:
        TEST_PRT("[INFO] CSC CASE 36: SrcType:YVU420SP DstType:U8C3_PLANAR CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2BGR;
        break;
    case 37:
        TEST_PRT("[INFO] CSC CASE 37: SrcType:YVU420SP DstType:U8C3_PACKAGE CscMode:YUV2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YVU420SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2BGR;
        break;
    case 38:
        TEST_PRT("[INFO] CSC CASE 38: SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2HSV;
        break;
    case 39:
        TEST_PRT("[INFO] CSC CASE 39: SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2HSV;
        break;
    case 40:
        TEST_PRT("[INFO] CSC CASE 40: SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2RGB;
        break;
    case 41:
        TEST_PRT("[INFO] CSC CASE 41: SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2RGB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2RGB;
        break;
    case 42:
        TEST_PRT("[INFO] CSC CASE 42: SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2LAB;
        break;
    case 43:
        TEST_PRT("[INFO] CSC CASE 43: SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2LAB;
        break;
    case 44:
        TEST_PRT("[INFO] CSC CASE 44: SrcType:YVU422SP DstType:U8C3_PLANAR CscMode:YVU2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2BGR;
        break;
    case 45:
        TEST_PRT("[INFO] CSC CASE 45: SrcType:YVU422SP DstType:U8C3_PACKAGE CscMode:YVU2BGR\n");
        enSrcType = CVE_IMAGE_TYPE_YVU422SP;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_YVU2BGR;
        break;
    case 46:
        TEST_PRT("[INFO] CSC CASE 46: SrcType:U8C3_PACKAGE DstType:YVU420SP CscMode:RGB2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YVU420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YVU;
        break;
    case 47:
        TEST_PRT("[INFO] CSC CASE 47: SrcType:U8C3_PACKAGE DstType:YVU422SP CscMode:RGB2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YVU422SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YVU;
        break;
    case 48:
        TEST_PRT("[INFO] CSC CASE 48: SrcType:U8C3_PACKAGE DstType:YVU420SP CscMode:RGB2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YVU420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YVU;
        break;
    case 49:
        TEST_PRT("[INFO] CSC CASE 49: SrcType:U8C3_PLANAR DstType:YVU422SP CscMode:RGB2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YVU422SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_RGB2YVU;
        break;
    case 50:
        TEST_PRT("[INFO] CSC CASE 50: SrcType:U8C3_PLANAR DstType:YVU420SP CscMode:BGR2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_YVU420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2YVU;
        break;
    case 51:
        TEST_PRT("[INFO] CSC CASE 51: SrcType:U8C3_PACKAGE DstType:YVU420SP CscMode:BGR2YVU\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_YVU420SP;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2YVU;
        break;
    case 52:
        TEST_PRT("[INFO] CSC CASE 52: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2HSV;
        break;
    case 53:
        TEST_PRT("[INFO] CSC CASE 53: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2HSV\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2HSV;
        break;
    case 54:
        TEST_PRT("[INFO] CSC CASE 54: SrcType:U8C3_PLANAR DstType:U8C3_PLANAR CscMode:BGR2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enDstType = CVE_IMAGE_TYPE_U8C3_PLANAR;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2LAB;
        break;
    case 55:
        TEST_PRT("[INFO] CSC CASE 55: SrcType:U8C3_PACKAGE DstType:U8C3_PACKAGE CscMode:BGR2LAB\n");
        enSrcType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enDstType = CVE_IMAGE_TYPE_U8C3_PACKAGE;
        enCscMode = CVE_CSC_MODE_PIC_BT601_BGR2LAB;
        break;
    default:
        printf("the csc case index is invalid! valid index:\n");
        SAMPLE_CVE_CscCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_CscInit(&stCscInfo, enSrcType, enDstType, enCscMode, pFpSrcName, pFpDstName,
                                u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CscInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_CscProc(&stCscInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CscProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_CscUninit(&stCscInfo);
    memset(&stCscInfo, 0, sizeof(SAMPLE_CVE_CSC_INFO_T));

    return s32Ret;
}
