/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_DST_MEM_INFO_T stBlob;
    CVE_CCL_CTRL_T stCclCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
    FILE *pFpDstFeather;
} SAMPLE_CVE_CCL_INFO_T;

SAMPLE_CVE_CCL_INFO_T stCclInfo;

void SAMPLE_CVE_CclCaseList(void)
{
    printf("\t\t  0) Ccl.\n");
    return;
}

static AML_VOID SAMPLE_CVE_CclUninit(SAMPLE_CVE_CCL_INFO_T *pstCclInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstCclInfo->stDst, pstCclInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstCclInfo->stBlob, pstCclInfo->pFpDstFeather);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstCclInfo->stSrc.au64PhyAddr[0], pstCclInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstCclInfo->stDst.au64PhyAddr[0], pstCclInfo->stDst.au64VirAddr[0]);
    CVE_PMZ_FREE(pstCclInfo->stBlob.u64PhyAddr, pstCclInfo->stBlob.u64VirAddr);
    CVE_CLOSE_FILE(pstCclInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCclInfo->pFpDst);
    CVE_CLOSE_FILE(pstCclInfo->pFpDstFeather);
}

static AML_S32 SAMPLE_CVE_CclInit(SAMPLE_CVE_CCL_INFO_T *pstCclInfo, AML_U32 u32Width,
                                  AML_U32 u32Height, AML_CHAR *pchSrcFileName,
                                  AML_CHAR *pchDst0FileName, AML_CHAR *pchDst1FileName)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_S32 size;

    memset(&pstCclInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstCclInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstCclInfo->stBlob, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstCclInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstCclInfo->pFpDst, pchDst1FileName, "w");
    CVE_OPEN_FILE(pstCclInfo->pFpDstFeather, pchDst0FileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstCclInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_CCL_EXIT1;
    }

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pstCclInfo->stDst, CVE_IMAGE_TYPE_U16C1, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_CCL_EXIT2;
    }

    size = sizeof(CVE_CCBLOB_T);
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstCclInfo->stBlob, size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_CCL_EXIT3;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstCclInfo->stSrc, pstCclInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_CCL_EXIT4;
    }
    goto CVE_CCL_EXIT0;

CVE_CCL_EXIT4:
    CVE_PMZ_FREE(pstCclInfo->stBlob.u64PhyAddr, pstCclInfo->stBlob.u64VirAddr);
CVE_CCL_EXIT3:
    CVE_PMZ_FREE(pstCclInfo->stDst.au64PhyAddr[0], pstCclInfo->stDst.au64VirAddr[0]);
CVE_CCL_EXIT2:
    CVE_PMZ_FREE(pstCclInfo->stSrc.au64PhyAddr[0], pstCclInfo->stSrc.au64VirAddr[0]);
CVE_CCL_EXIT1:
    CVE_CLOSE_FILE(pstCclInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCclInfo->pFpDst);
    CVE_CLOSE_FILE(pstCclInfo->pFpDstFeather);
CVE_CCL_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_CclProc(SAMPLE_CVE_CCL_INFO_T *pstCclInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    pstCclInfo->stCclCtrl.enInputDataMode = CVE_CCL_INPUT_DATA_MODE_U8;

    s32Ret = CVE_CCL(&cveHandle, &pstCclInfo->stSrc, &pstCclInfo->stDst, &pstCclInfo->stBlob,
                     &pstCclInfo->stCclCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Ccl Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE Ccl Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_CclCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/ccl.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDst0Name = "/data/cve/Ccl_feather.out";
    AML_CHAR *pFpDst1Name = "/data/cve/Ccl_label.out";
    AML_CHAR CclCheck_Sum[128] = {0};
    AML_S32 Ccl_Data_Checksum;
    AML_S32 Ccl_Feature_Checksum;
    stCclInfo.stCclCtrl.stCrop.enCrop = AML_FALSE;
    stCclInfo.stCclCtrl.stCrop.u16X = 0;
    stCclInfo.stCclCtrl.stCrop.u16Y = 0;
    stCclInfo.stCclCtrl.stCrop.u16Width = 200;
    stCclInfo.stCclCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] Ccl CASE 0: Ccl.\n");
        break;
    default:
        printf("the ccl case index is invalid! valid index:\n");
        SAMPLE_CVE_CclCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst0 feather file name:%s\n", pFpDst0Name);
    printf("dst1 data file name:%s\n", pFpDst1Name);

    s32Ret =
        SAMPLE_CVE_CclInit(&stCclInfo, u32Width, u32Height, pFpSrcName, pFpDst0Name, pFpDst1Name);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CclInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_CclProc(&stCclInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CclProc failed!\n", s32Ret);
    }
    Ccl_Data_Checksum = 0;
    Ccl_Feature_Checksum = 0;
    memset(CclCheck_Sum, 0, sizeof(CclCheck_Sum));
    Ccl_Data_Checksum =
        SAMPLE_CVE_CheckSum(stCclInfo.stDst.u32Width * stCclInfo.stDst.u32Height * 2,
                            (AML_U8 *)(AML_UINTPTR_T)stCclInfo.stDst.au64VirAddr[0], 0);
    Ccl_Feature_Checksum = SAMPLE_CVE_CCL_Feature_Checksum(
        (CCL_Feature_T *)(AML_UINTPTR_T)stCclInfo.stBlob.u64VirAddr, CVE_MAX_REGION_NUM);

    sprintf(CclCheck_Sum, "0x%08x, 0x%08x,\n", Ccl_Feature_Checksum, Ccl_Data_Checksum);
    printf("checksum: %s\n", CclCheck_Sum);
    SAMPLE_CVE_CclUninit(&stCclInfo);
    memset(&stCclInfo, 0, sizeof(SAMPLE_CVE_CCL_INFO_T));

    return s32Ret;
}
