/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static AML_CHAR acMask0[25] = {0, 0, 0, 0,  0, 0, -1, 0, 1, 0, 0, -2, 0,
                               2, 0, 0, -1, 0, 1, 0,  0, 0, 0, 0, 0};

static AML_CHAR acMask1[25] = {-1, -2, 0,  2,  1, -4, -8, 0,  8,  4, -6, -12, 0,
                               12, 6,  -4, -8, 0, 8,  4,  -1, -2, 0, 2,  1};

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stEdge;
    CVE_DST_MEM_INFO_T stStack;
    CVE_CANNY_HYS_EDGE_CTRL_T stCannyHysEdgeCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
    FILE *pFpDstP;
} SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T;

SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T stCannyHysEdgeInfo;

void SAMPLE_CVE_CannyHysEdgeCaseList(void)
{
    printf("\t\t  0) CannyHysEdgeMode gaussen 0, filtertype 0.\n");
    printf("\t\t  1) CannyHysEdgeMode gaussen 0. filtertype 1\n");
    printf("\t\t  2) CannyHysEdgeMode gaussen 1. filtertype 0\n");
    printf("\t\t  3) CannyHysEdgeMode gaussen 1. filtertype 1\n");
    return;
}

static AML_VOID SAMPLE_CVE_CannyHysEdgeUninit(SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T *pstCannyHysEdgeInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstCannyHysEdgeInfo->stEdge, pstCannyHysEdgeInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    s32Ret = SAMPLE_COMM_CVE_WriteFile_From_Mem(&pstCannyHysEdgeInfo->stStack,
                                                pstCannyHysEdgeInfo->pFpDstP);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Point Image failed!\n", s32Ret);
    }

    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stSrc.au64PhyAddr[0],
                 pstCannyHysEdgeInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stEdge.au64PhyAddr[0],
                 pstCannyHysEdgeInfo->stEdge.au64VirAddr[0]);
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stStack.u64PhyAddr, pstCannyHysEdgeInfo->stStack.u64VirAddr);
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem.u64PhyAddr,
                 pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem.u64VirAddr);
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpDst);
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpDstP);
}

static AML_S32 SAMPLE_CVE_CannyHysEdgeInit(SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T *pstCannyHysEdgeInfo,
                                           AML_U32 u32FilterType, AML_U32 u32Gaussen,
                                           AML_U32 u32Width, AML_U32 u32Height,
                                           AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName,
                                           AML_CHAR *pchDstPFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_U32 u32Size;

    memset(&pstCannyHysEdgeInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pstCannyHysEdgeInfo->stEdge, 0, sizeof(CVE_DST_IMAGE_T));
    memset(&pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem, 0, sizeof(CVE_MEM_INFO_T));
    memset(&pstCannyHysEdgeInfo->stStack, 0, sizeof(CVE_DST_MEM_INFO_T));

    CVE_OPEN_FILE(pstCannyHysEdgeInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pstCannyHysEdgeInfo->pFpDst, pchDstFileName, "w");
    CVE_OPEN_FILE(pstCannyHysEdgeInfo->pFpDstP, pchDstPFileName, "w");

    if (u32FilterType == 0) {
        memcpy(&pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.as8Mask, acMask0, 25);
    } else {
        memcpy(&pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.as8Mask, acMask1, 25);
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstCannyHysEdgeInfo->stSrc, CVE_IMAGE_TYPE_U8C1, u32Width,
                                         u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_CANNY_HYS_EDGE_EXIT1;
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstCannyHysEdgeInfo->stEdge, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_CANNY_HYS_EDGE_EXIT2;
    }

    u32Size = pstCannyHysEdgeInfo->stEdge.au32Stride[0] * pstCannyHysEdgeInfo->stEdge.u32Height *
                  sizeof(CVE_POINT_U16_T) + sizeof(AML_U32);
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstCannyHysEdgeInfo->stStack, u32Size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_CANNY_HYS_EDGE_EXIT3;
    }

    u32Size = pstCannyHysEdgeInfo->stSrc.au32Stride[0] * pstCannyHysEdgeInfo->stSrc.u32Height * 4;
    s32Ret = SAMPLE_COMM_CVE_CreateMemInfo(&pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem, u32Size);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Mem failed!\n", s32Ret);
        goto CVE_CANNY_HYS_EDGE_EXIT4;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstCannyHysEdgeInfo->stSrc, pstCannyHysEdgeInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_CANNY_HYS_EDGE_EXIT5;
    }

    pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.u16LowThr = 50;
    pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.u16HighThr = 100;
    pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.bGauss = u32Gaussen;

    goto CVE_CANNY_HYS_EDGE_EXIT0;

CVE_CANNY_HYS_EDGE_EXIT5:
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem.u64PhyAddr,
                 pstCannyHysEdgeInfo->stCannyHysEdgeCtrl.stMem.u64VirAddr);
CVE_CANNY_HYS_EDGE_EXIT4:
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stStack.u64PhyAddr, pstCannyHysEdgeInfo->stStack.u64VirAddr);
CVE_CANNY_HYS_EDGE_EXIT3:
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stEdge.au64PhyAddr[0],
                 pstCannyHysEdgeInfo->stEdge.au64VirAddr[0]);
CVE_CANNY_HYS_EDGE_EXIT2:
    CVE_PMZ_FREE(pstCannyHysEdgeInfo->stSrc.au64PhyAddr[0],
                 pstCannyHysEdgeInfo->stSrc.au64VirAddr[0]);
CVE_CANNY_HYS_EDGE_EXIT1:
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpSrc);
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpDst);
    CVE_CLOSE_FILE(pstCannyHysEdgeInfo->pFpDstP);
CVE_CANNY_HYS_EDGE_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_CannyHysEdgeProc(SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T *pstCannyHysEdgeInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_CannyHysEdge(&cveHandle, &pstCannyHysEdgeInfo->stSrc, &pstCannyHysEdgeInfo->stEdge,
                              &pstCannyHysEdgeInfo->stStack,
                              &pstCannyHysEdgeInfo->stCannyHysEdgeCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE CannyHysEdge Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE CannyHysEdge Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_CannyHysEdgeCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 352;
    AML_U32 u32Height = 288;
    AML_U32 u32FilterType;
    AML_U32 u32Gaussen;
    AML_S32 s32Ret;
    AML_CHAR *SrcName = "/data/cve/00_352x288_y.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/CannyHysEdge.out";
    AML_CHAR *pFpDstPName = "/data/cve/CannyHysEdge_poin.out";
    stCannyHysEdgeInfo.stCannyHysEdgeCtrl.stCrop.enCrop = AML_FALSE;
    stCannyHysEdgeInfo.stCannyHysEdgeCtrl.stCrop.u16X = 0;
    stCannyHysEdgeInfo.stCannyHysEdgeCtrl.stCrop.u16Y = 0;
    stCannyHysEdgeInfo.stCannyHysEdgeCtrl.stCrop.u16Width = 200;
    stCannyHysEdgeInfo.stCannyHysEdgeCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] CannyHysEdge CASE 0: Gaussen 0, FilterType 0\n");
        u32Gaussen = 0;
        u32FilterType = 0;
        break;
    case 1:
        TEST_PRT("[INFO] CannyHysEdge CASE 1: Gaussen 0, FilterType 1\n");
        u32Gaussen = 0;
        u32FilterType = 1;
        break;
    case 2:
        TEST_PRT("[INFO] CannyHysEdge CASE 2: Gaussen 1, FilterType 0\n");
        u32Gaussen = 1;
        u32FilterType = 0;
        break;
    case 3:
        TEST_PRT("[INFO] CannyHysEdge CASE 3: Gaussen 1, FilterType 1\n");
        u32Gaussen = 1;
        u32FilterType = 1;
        break;
    default:
        printf("the cannyHysEdge case index is invalid! valid index:\n");
        SAMPLE_CVE_CannyHysEdgeCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);
    printf("dst point file name:%s\n", pFpDstPName);

    s32Ret = SAMPLE_CVE_CannyHysEdgeInit(&stCannyHysEdgeInfo, u32FilterType, u32Gaussen, u32Width,
                                         u32Height, pFpSrcName, pFpDstName, pFpDstPName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CannyHysEdgeInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_CannyHysEdgeProc(&stCannyHysEdgeInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_CannyHysEdgeProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_CannyHysEdgeUninit(&stCannyHysEdgeInfo);
    memset(&stCannyHysEdgeInfo, 0, sizeof(SAMPLE_CVE_CANNY_HYS_EDGE_INFO_T));

    return s32Ret;
}
