/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T astDst[4];
    CVE_BUILD_LK_OPTICAL_FLOW_PYR_CTRL_T stLkBuildOptiFlowPyrCtrl;
    FILE *pFpSrc;
    FILE *pFpDst[4];
} SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T;

SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T stBuildLKOpticalFlowPyrInfo;

void SAMPLE_CVE_BuildLKOpticalFlowPyrCaseList(void)
{
    printf("\t\t  0) Build LK Optical Flow Pyr, output layer:1.\n");
    printf("\t\t  1) Build LK Optical Flow Pyr, output layer:2.\n");
    printf("\t\t  2) Build LK Optical Flow Pyr, output layer:3.\n");
    printf("\t\t  3) Build LK Optical Flow Pyr, output layer:4.\n");
    return;
}

static AML_VOID SAMPLE_CVE_BuildLKOpticalFlowPyrUninit(
    SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T *pstBuildLkOptiFlowPyrInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_S32 i = 0;

    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        s32Ret = SAMPLE_COMM_CVE_WriteFile(&pstBuildLkOptiFlowPyrInfo->astDst[i],
                                           pstBuildLkOptiFlowPyrInfo->pFpDst[i]);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Write Dst 0 Image failed!\n", s32Ret);
        }
    }

    CVE_PMZ_FREE(pstBuildLkOptiFlowPyrInfo->stSrc.au64PhyAddr[0],
                 pstBuildLkOptiFlowPyrInfo->stSrc.au64VirAddr[0]);
    CVE_CLOSE_FILE(pstBuildLkOptiFlowPyrInfo->pFpSrc);
    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_PMZ_FREE(pstBuildLkOptiFlowPyrInfo->astDst[i].au64PhyAddr[0],
                     pstBuildLkOptiFlowPyrInfo->astDst[i].au64VirAddr[0]);
        CVE_CLOSE_FILE(pstBuildLkOptiFlowPyrInfo->pFpDst[i]);
    }
}

static AML_S32 SAMPLE_CVE_BuildLKOpticalFlowPyrInit(
    SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T *pstBuildLkOptiFlowPyrInfo, AML_U32 u32Width,
    AML_U32 u32Height, AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName[])
{
    AML_S32 s32Ret = AML_SUCCESS;
    AML_S32 i = 0;

    memset(&pstBuildLkOptiFlowPyrInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(pstBuildLkOptiFlowPyrInfo->astDst, 0, sizeof(CVE_DST_IMAGE_T) * 4);

    CVE_OPEN_FILE(pstBuildLkOptiFlowPyrInfo->pFpSrc, pchSrcFileName, "r+");
    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_OPEN_FILE(pstBuildLkOptiFlowPyrInfo->pFpDst[i], pchDstFileName[i], "w");
    }

    s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstBuildLkOptiFlowPyrInfo->stSrc, CVE_IMAGE_TYPE_U8C1,
                                         u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_BUILDLK_OPTICALFLOWPYR_EXIT1;
    }

    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        s32Ret = SAMPLE_COMM_CVE_CreateImage(&pstBuildLkOptiFlowPyrInfo->astDst[i],
                                             CVE_IMAGE_TYPE_U8C1, u32Width >> i, u32Height >> i);
        if (s32Ret != AML_SUCCESS) {
            TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
            goto CVE_BUILDLK_OPTICALFLOWPYR_EXIT2;
        }
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pstBuildLkOptiFlowPyrInfo->stSrc,
                                      pstBuildLkOptiFlowPyrInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src Image failed!\n", s32Ret);
        goto CVE_BUILDLK_OPTICALFLOWPYR_EXIT3;
    }
    goto CVE_BUILDLK_OPTICALFLOWPYR_EXIT0;

CVE_BUILDLK_OPTICALFLOWPYR_EXIT3:
    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_PMZ_FREE(pstBuildLkOptiFlowPyrInfo->astDst[i].au64PhyAddr[0],
                     pstBuildLkOptiFlowPyrInfo->astDst[i].au64VirAddr[0]);
    }
CVE_BUILDLK_OPTICALFLOWPYR_EXIT2:
    CVE_PMZ_FREE(pstBuildLkOptiFlowPyrInfo->stSrc.au64PhyAddr[0],
                 pstBuildLkOptiFlowPyrInfo->stSrc.au64VirAddr[0]);
CVE_BUILDLK_OPTICALFLOWPYR_EXIT1:
    CVE_CLOSE_FILE(pstBuildLkOptiFlowPyrInfo->pFpSrc);
    for (i = 0; i <= pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl.u8MaxLevel; i++) {
        CVE_CLOSE_FILE(pstBuildLkOptiFlowPyrInfo->pFpDst[i]);
    }
CVE_BUILDLK_OPTICALFLOWPYR_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_BuildLKOpticalFlowPyrProc(
    SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T *pstBuildLkOptiFlowPyrInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_BuildLKOpticalFlowPyr(
        &cveHandle, &pstBuildLkOptiFlowPyrInfo->stSrc, pstBuildLkOptiFlowPyrInfo->astDst,
        &pstBuildLkOptiFlowPyrInfo->stLkBuildOptiFlowPyrCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE BuildLKOPtFlowPyr Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE BuildLKOPtFlowPyr Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_BuildLKOpticalFlowPyrCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 720;
    AML_U32 u32Height = 576;
    AML_S32 s32Ret;
    AML_S32 i;
    CVE_BUILD_LK_OPTICAL_FLOW_PYR_CTRL_T *pstBuildLkOptiFlowPyrCtrl =
        &stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl;
    AML_CHAR *SrcName = "/data/cve/penguinx.yuv";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName[4] = {
        "/data/cve/BuildLKOPtFlowPyr0.out", "/data/cve/BuildLKOPtFlowPyr1.out",
        "/data/cve/BuildLKOPtFlowPyr2.out", "/data/cve/BuildLKOPtFlowPyr3.out"};

    stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl.stCrop.enCrop = AML_FALSE;
    stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl.stCrop.u16X = 0;
    stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl.stCrop.u16Y = 0;
    stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl.stCrop.u16Width = 200;
    stBuildLKOpticalFlowPyrInfo.stLkBuildOptiFlowPyrCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT("[INFO] BuildLKOpticalFlowPyr CASE 0: Output layer 1 \n");
        pstBuildLkOptiFlowPyrCtrl->u8MaxLevel = 0;
        break;
    case 1:
        TEST_PRT("[INFO] BuildLKOpticalFlowPyr CASE 1: Output layer 2 \n");
        pstBuildLkOptiFlowPyrCtrl->u8MaxLevel = 1;
        break;
    case 2:
        TEST_PRT("[INFO] BuildLKOpticalFlowPyr CASE 2: Output layer 3 \n");
        pstBuildLkOptiFlowPyrCtrl->u8MaxLevel = 2;
        break;
    case 3:
        TEST_PRT("[INFO] BuildLKOpticalFlowPyr CASE 3: Output layer 4 \n");
        pstBuildLkOptiFlowPyrCtrl->u8MaxLevel = 3;
        break;
    default:
        printf("the Build LK Optical Flow Pyr case index is invalid! valid index:\n");
        SAMPLE_CVE_BuildLKOpticalFlowPyrCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    for (i = 0; i <= pstBuildLkOptiFlowPyrCtrl->u8MaxLevel; i++) {
        printf("dst%d file name:%s\n", i, pFpDstName[i]);
    }

    s32Ret = SAMPLE_CVE_BuildLKOpticalFlowPyrInit(&stBuildLKOpticalFlowPyrInfo, u32Width, u32Height,
                                                  pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_BuildLKOpticalFlowPyrInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_BuildLKOpticalFlowPyrProc(&stBuildLKOpticalFlowPyrInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_BuildLKOpticalFlowPyrProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_BuildLKOpticalFlowPyrUninit(&stBuildLKOpticalFlowPyrInfo);
    memset(&stBuildLKOpticalFlowPyrInfo, 0, sizeof(SAMPLE_CVE_BuildLkOpticalFlowPyr_INFO_T));

    return s32Ret;
}
