/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 * All information contained herein is Amlogic confidential.
 *
 */
#include "lib_cve.h"
#include "sample_comm_cve.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

typedef struct {
    CVE_SRC_IMAGE_T stSrc;
    CVE_DST_IMAGE_T stDst;
    CVE_16BIT_TO_8BIT_CTRL_T stThrCtrl;
    FILE *pFpSrc;
    FILE *pFpDst;
} SAMPLE_CVE_16BIT_TO_8BIT_INFO_T;

SAMPLE_CVE_16BIT_TO_8BIT_INFO_T st16BitTo8BitInfo;

void SAMPLE_CVE_16BitTo8BitCaseList(void)
{
    printf("\t\t  0) SrcType:S16C1 DstType:S8C1 16BitTo8BitMode: S16 To S8.\n");
    printf("\t\t  1) SrcType:S16C1 DstType:U8C1 16BitTo8BitMode: S16 To U8 ABS.\n");
    printf("\t\t  2) SrcType:S16C1 DstType:U8C1 16BitTo8BitMode: S16 To U8 BIAS.\n");
    printf("\t\t  3) SrcType:U16C1 DstType:U8C1 16BitTo8BitMode: U16 To U8.\n");
    return;
}

static AML_VOID SAMPLE_CVE_16BitTo8BitUninit(SAMPLE_CVE_16BIT_TO_8BIT_INFO_T *pst16BitTo8BitInfo)
{
    AML_S32 s32Ret = AML_SUCCESS;
    s32Ret = SAMPLE_COMM_CVE_WriteFile(&pst16BitTo8BitInfo->stDst, pst16BitTo8BitInfo->pFpDst);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Write Dst Image failed!\n", s32Ret);
    }
    CVE_PMZ_FREE(pst16BitTo8BitInfo->stSrc.au64PhyAddr[0],
                 pst16BitTo8BitInfo->stSrc.au64VirAddr[0]);
    CVE_PMZ_FREE(pst16BitTo8BitInfo->stDst.au64PhyAddr[0],
                 pst16BitTo8BitInfo->stDst.au64VirAddr[0]);
    CVE_CLOSE_FILE(pst16BitTo8BitInfo->pFpSrc);
    CVE_CLOSE_FILE(pst16BitTo8BitInfo->pFpDst);
}

static AML_S32 SAMPLE_CVE_16BitTo8BitInit(SAMPLE_CVE_16BIT_TO_8BIT_INFO_T *pst16BitTo8BitInfo,
                                          CVE_IMAGE_TYPE_E enSrcType, CVE_IMAGE_TYPE_E enDstType,
                                          AML_U32 u32Width, AML_U32 u32Height,
                                          AML_CHAR *pchSrcFileName, AML_CHAR *pchDstFileName)
{
    AML_S32 s32Ret = AML_SUCCESS;

    memset(&pst16BitTo8BitInfo->stSrc, 0, sizeof(CVE_SRC_IMAGE_T));
    memset(&pst16BitTo8BitInfo->stDst, 0, sizeof(CVE_DST_IMAGE_T));

    CVE_OPEN_FILE(pst16BitTo8BitInfo->pFpSrc, pchSrcFileName, "r+");
    CVE_OPEN_FILE(pst16BitTo8BitInfo->pFpDst, pchDstFileName, "w");

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pst16BitTo8BitInfo->stSrc, enSrcType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Src Image failed!\n", s32Ret);
        goto CVE_16BIT_TO_8BIT_EXIT1;
    }

    s32Ret =
        SAMPLE_COMM_CVE_CreateImage(&pst16BitTo8BitInfo->stDst, enDstType, u32Width, u32Height);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Create Dst Image failed!\n", s32Ret);
        goto CVE_16BIT_TO_8BIT_EXIT2;
    }

    s32Ret = SAMPLE_COMM_CVE_ReadFile(&pst16BitTo8BitInfo->stSrc, pst16BitTo8BitInfo->pFpSrc);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] Read Src2 Image failed!\n", s32Ret);
        goto CVE_16BIT_TO_8BIT_EXIT3;
    }

    goto CVE_16BIT_TO_8BIT_EXIT0;

CVE_16BIT_TO_8BIT_EXIT3:
    CVE_PMZ_FREE(pst16BitTo8BitInfo->stDst.au64PhyAddr[0],
                 pst16BitTo8BitInfo->stDst.au64VirAddr[0]);
CVE_16BIT_TO_8BIT_EXIT2:
    CVE_PMZ_FREE(pst16BitTo8BitInfo->stSrc.au64PhyAddr[0],
                 pst16BitTo8BitInfo->stSrc.au64VirAddr[0]);
CVE_16BIT_TO_8BIT_EXIT1:
    CVE_CLOSE_FILE(pst16BitTo8BitInfo->pFpSrc);
    CVE_CLOSE_FILE(pst16BitTo8BitInfo->pFpDst);
CVE_16BIT_TO_8BIT_EXIT0:

    return s32Ret;
}

static AML_S32 SAMPLE_CVE_16BitTo8BitProc(SAMPLE_CVE_16BIT_TO_8BIT_INFO_T *pst16BitTo8BitInfo)
{
    AML_BOOL_E bInstant = AML_FALSE;
    AML_BOOL_E bFinish = AML_FALSE;
    CVE_HANDLE cveHandle;
    AML_S32 s32Ret = AML_SUCCESS;

    s32Ret = CVE_16BitTo8Bit(&cveHandle, &pst16BitTo8BitInfo->stSrc, &pst16BitTo8BitInfo->stDst,
                             &pst16BitTo8BitInfo->stThrCtrl, bInstant);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE 16BitTo8Bit Proc error\n");
        return s32Ret;
    }
    s32Ret = CVE_Query(cveHandle, &bFinish, AML_TRUE);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("CVE 16BitTo8Bit Query error\n");
        return s32Ret;
    }

    return s32Ret;
}

AML_S32 SAMPLE_CVE_16BitTo8BitCase(AML_U32 u32CaseIndex)
{
    AML_U32 u32Width = 704;
    AML_U32 u32Height = 576;
    CVE_IMAGE_TYPE_E enSrcType;
    CVE_IMAGE_TYPE_E enDstType;
    AML_S32 s32Ret;
    CVE_16BIT_TO_8BIT_CTRL_T *pstThrCtrl = &st16BitTo8BitInfo.stThrCtrl;
    AML_CHAR *SrcName = "/data/cve/00_704x576.s16";
    AML_CHAR pFpSrcName[64] = {0};
    AML_CHAR *pFpDstName = "/data/cve/16bit_to_8bit.out";

    st16BitTo8BitInfo.stThrCtrl.stCrop.enCrop = AML_FALSE;
    st16BitTo8BitInfo.stThrCtrl.stCrop.u16X = 0;
    st16BitTo8BitInfo.stThrCtrl.stCrop.u16Y = 0;
    st16BitTo8BitInfo.stThrCtrl.stCrop.u16Width = 200;
    st16BitTo8BitInfo.stThrCtrl.stCrop.u16Height = 200;

    switch (u32CaseIndex) {
    case 0:
        TEST_PRT(
            "[INFO] 16BitTo8Bit CASE 0: SrcType:S16C1 DstType:S8C1 16BitTo8BitMode:S16 To S8\n");
        enSrcType = CVE_IMAGE_TYPE_S16C1;
        enDstType = CVE_IMAGE_TYPE_S8C1;
        pstThrCtrl->enMode = CVE_16BIT_TO_8BIT_MODE_S16_TO_S8;
        pstThrCtrl->u8LineCoefThr = 32767;
        pstThrCtrl->s8Bias = 0;
        break;
    case 1:
        TEST_PRT("[INFO] 16BitTo8Bit CASE 0: SrcType:S16C1 DstType:U8C1 16BitTo8BitMode:S16 To U8 "
                 "ABS\n");
        enSrcType = CVE_IMAGE_TYPE_S16C1;
        enDstType = CVE_IMAGE_TYPE_U8C1;
        pstThrCtrl->enMode = CVE_16BIT_TO_8BIT_MODE_S16_TO_U8_ABS;
        pstThrCtrl->u8LineCoefThr = 32767;
        pstThrCtrl->s8Bias = 0;
        break;
    case 2:
        TEST_PRT("[INFO] 16BitTo8Bit CASE 0: SrcType:S16C1 DstType:U8C1 16BitTo8BitMode:S16 To U8 "
                 "BIAS\n");
        enSrcType = CVE_IMAGE_TYPE_S16C1;
        enDstType = CVE_IMAGE_TYPE_U8C1;
        pstThrCtrl->enMode = CVE_16BIT_TO_8BIT_MODE_S16_TO_U8_BIAS;
        pstThrCtrl->u8LineCoefThr = 32767;
        pstThrCtrl->s8Bias = 20;
        break;
    case 3:
        TEST_PRT(
            "[INFO] 16BitTo8Bit CASE 0: SrcType:U16C1 DstType:U8C1 16BitTo8BitMode:U16 To U8\n");
        enSrcType = CVE_IMAGE_TYPE_U16C1;
        enDstType = CVE_IMAGE_TYPE_U8C1;
        pstThrCtrl->enMode = CVE_16BIT_TO_8BIT_MODE_U16_TO_U8;
        pstThrCtrl->u8LineCoefThr = 32767;
        pstThrCtrl->s8Bias = 0;
        break;
    default:
        printf("the thresh case index is invalid! valid index:\n");
        SAMPLE_CVE_16BitTo8BitCaseList();
        return AML_FAILURE;
    }

    printf("please input src file name:");
    SAMPLE_COMM_CVE_Input_FileName(pFpSrcName, sizeof(pFpSrcName), SrcName);
    printf("src file name:%s\n", pFpSrcName);
    printf("dst file name:%s\n", pFpDstName);

    s32Ret = SAMPLE_CVE_16BitTo8BitInit(&st16BitTo8BitInfo, enSrcType, enDstType, u32Width,
                                        u32Height, pFpSrcName, pFpDstName);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_16BitTo8BitInit failed!\n", s32Ret);
        return s32Ret;
    }

    s32Ret = SAMPLE_CVE_16BitTo8BitProc(&st16BitTo8BitInfo);
    if (s32Ret != AML_SUCCESS) {
        TEST_PRT("[ERROR][%x] SAMPLE_CVE_16BitTo8BitProc failed!\n", s32Ret);
    }

    SAMPLE_CVE_16BitTo8BitUninit(&st16BitTo8BitInfo);
    memset(&st16BitTo8BitInfo, 0, sizeof(SAMPLE_CVE_16BIT_TO_8BIT_INFO_T));

    return s32Ret;
}
