/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 *
 * This source code is subject to the terms and conditions defined in below
 * which is part of this source code package.
 *
 */

#ifndef __SYS_CVE_ION_H
#define __SYS_CVE_ION_H

#include "aml_type.h"

typedef unsigned int uint32_t;
typedef unsigned long ulong;

enum { INPUT_BUFF_TYPE = 0x1000, OUTPUT_BUFF_TYPE, CONFIG_BUFF_TYPE, GDC_BUFF_TYPE_MAX };

struct usr_ctx_s {
    int ion_dev;
    char *i_buff;
    void *cmemParm;
    ulong i_len;
    int fd;
};

struct cve_ion_buffer {
    int used;
    int dmafd;
    struct usr_ctx_s *ctx;
    AML_U32 size;
    AML_U64 viraddr;
};

int init_ion_buffer(void);
int cve_alloc_ion(int *dmafd, AML_VOID **u64VirAddr, AML_U32 len);
int cve_free_ion(int dmafd, AML_VOID *u64VirAddr);

#endif /* __SYS_MBI_ION_H */
