/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 */

#ifndef _AML_COMMON_H_
#define _AML_COMMON_H_

#include "aml_type.h"

typedef enum AML_ERR_LEVEL_E {
    AML_ERR_LEVEL_DEBUG = 0,
    AML_ERR_LEVEL_INFO,
    AML_ERR_LEVEL_NOTICE,
    AML_ERR_LEVEL_WARNING,
    AML_ERR_LEVEL_ERROR,
    AML_ERR_LEVEL_CRIT,
    AML_ERR_LEVEL_ALERT,
    AML_ERR_LEVEL_FATAL,
    AML_ERR_LEVEL_BUTT
} ERR_LEVEL_E;

#define AML_ERR_APPID (0x80000000L + 0x20000000L)
#define AML_DEF_ERR(level, errid) ((int)((AML_ERR_APPID) | ((level) << 13) | (errid)))

typedef AML_S32 CVE_HANDLE;

#define AML_INVALID_HANDLE (-1)

typedef enum {
    AML_ERR_INVALID_DEVID = 1,
    AML_ERR_INVALID_CHNID = 2,
    AML_ERR_ILLEGAL_PARAM = 3,
    AML_ERR_EXIST = 4,
    AML_ERR_UNEXIST = 5,
    AML_ERR_NULL_PTR = 6,
    AML_ERR_NOT_CONFIG = 7,
    AML_ERR_NOT_SUPPORT = 8,
    AML_ERR_NOT_PERM = 9,
    AML_ERR_INVALID_PIPEID = 10,
    AML_ERR_INVALID_STITCHGRPID = 11,
    AML_ERR_NOMEM = 12,
    AML_ERR_NOBUF = 13,
    AML_ERR_BUF_EMPTY = 14,
    AML_ERR_BUF_FULL = 15,
    AML_ERR_SYS_NOTREADY = 16,
    AML_ERR_BADADDR = 17,
    AML_ERR_BUSY = 18,
    AML_ERR_SIZE_NOT_ENOUGH = 19,
    AML_ERR_BUTT = 63,
} AML_ERR_CODE_E;

#endif /*_AML_COMMON_H_*/
