/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 */

#ifndef __AML_CVE_REG_H__
#define __AML_CVE_REG_H__

#define CVE_REG_BASE (0xfe046000 >> 2)
#define CVE_REG_OFFSET 0x00000100
#define CVE_REG_SIZE 0x10000

#define CVE_TOP_HW_CTRL_REG0 (CVE_REG_BASE + 0x0)
#define CVE_TOP_HW_CTRL_REG1 (CVE_REG_BASE + 0x1)
#define CVE_TOP_HW_CTRL_REG2 (CVE_REG_BASE + 0x2)
#define CVE_CQ_REG0 (CVE_REG_BASE + 0x3)
#define CVE_CQ_REG1 (CVE_REG_BASE + 0x4)
#define CVE_CQ_REG2 (CVE_REG_BASE + 0x5)
#define CVE_INTR_STAT_WRITE_REG0 (CVE_REG_BASE + 0x6)
#define CVE_INTR_STAT_WRITE_REG1 (CVE_REG_BASE + 0x7)
#define CVE_INTR_STAT_CLR_WRITE_REG0 (CVE_REG_BASE + 0x8)
#define CVE_INTR_STAT_CLR_WRITE_REG1 (CVE_REG_BASE + 0x9)
#define CVE_INTR_MASKN_REG0 (CVE_REG_BASE + 0xa)
#define CVE_INTR_MASKN_REG1 (CVE_REG_BASE + 0xb)
#define CVE_INTR_STATUS_REG0 (CVE_REG_BASE + 0xc)
#define CVE_INTR_STATUS_REG1 (CVE_REG_BASE + 0xd)
#define CVE_OP_ONCE_RUN_CYCLES_REG (CVE_REG_BASE + 0xe)
#define CVE_CQ_REG3 (CVE_REG_BASE + 0xf)
#define CVE_CQ_REG4 (CVE_REG_BASE + 0x10)
#define CVE_ID_STA_REG0 (CVE_REG_BASE + 0x11)
#define CVE_ID_STA_REG1 (CVE_REG_BASE + 0x12)
#define CVE_TIMEOUT_REG0 (CVE_REG_BASE + 0x13)
#define CVE_TIMEOUT_REG1 (CVE_REG_BASE + 0x14)
#define CVE_UTE_REG0 (CVE_REG_BASE + 0x15)
#define CVE_UTE_REG1 (CVE_REG_BASE + 0x16)
#define CVE_STATUS_REG (CVE_REG_BASE + 0x17)

#define CVE_NCC_U64NUM_REG0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x3d)
#define CVE_NCC_U64NUM_REG1 (CVE_REG_BASE + CVE_REG_OFFSET + 0x3e)
#define CVE_NCC_U64QUADSUM1_REG0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x3f)
#define CVE_NCC_U64QUADSUM1_REG1 (CVE_REG_BASE + CVE_REG_OFFSET + 0x40)
#define CVE_NCC_U64QUADSUM2_REG0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x41)
#define CVE_NCC_U64QUADSUM2_REG1 (CVE_REG_BASE + CVE_REG_OFFSET + 0x42)

#define CVE_CCL_REG0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x43)
#define CVE_BGMODE_REG1 (CVE_REG_BASE + CVE_REG_OFFSET + 0x28)
#define CVE_BGMODE_REG2 (CVE_REG_BASE + CVE_REG_OFFSET + 0x29)
#define CVE_UPDATEBGMODE_REG2 (CVE_REG_BASE + CVE_REG_OFFSET + 0x2c)
#define CVE_UPDATEBGMODE_REG3 (CVE_REG_BASE + CVE_REG_OFFSET + 0x2d)
#define CVE_LK_REG2_0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x52)
#define CVE_STCORNER_REG0 (CVE_REG_BASE + CVE_REG_OFFSET + 0x63)
#define CVE_CANNY_REG1 (CVE_REG_BASE + CVE_REG_OFFSET + 0x4b)

#define CVE_LUT_REG0 (CVE_REG_BASE + 0xf0)
#define CVE_LUT_REG1 (CVE_REG_BASE + 0xf1)
#define CVE_LUT_DONE 0x0
#define CVE_EQHIST_AU8CURV_LUT 0x1
#define CVE_TOF_BPC_LUT 0x2
#define CVE_HIST_LUT 0x4
#define CVE_MAP_AU16MAP_LUT 0x8
#define CVE_TOF_IR_HIST_LUT 0x10
#define CVE_TOF_Q2_HIST_LUT 0x20
#define CVE_TOF_Q3_HIST_LUT 0x40

#define CVE_TOP_CTRL_REG0 0x0
#define CVE_TOP_CTRL_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOP_CTRL_REG0_HMASK0 0
#define CVE_TOP_CTRL_REG0_LMASK0 0

#define CVE_TOP_CTRL_REG1 0x1
#define CVE_TOP_CTRL_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOP_CTRL_REG1_HMASK0 31
#define CVE_TOP_CTRL_REG1_LMASK0 0

#define CVE_COMMON_CTRL_REG0 0x2
#define CVE_COMMON_CTRL_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG0_HMASK0 0
#define CVE_COMMON_CTRL_REG0_LMASK0 0
#define CVE_COMMON_CTRL_REG0_HMASK1 1
#define CVE_COMMON_CTRL_REG0_LMASK1 1
#define CVE_COMMON_CTRL_REG0_HMASK2 4
#define CVE_COMMON_CTRL_REG0_LMASK2 4
#define CVE_COMMON_CTRL_REG0_HMASK3 12
#define CVE_COMMON_CTRL_REG0_LMASK3 8
#define CVE_COMMON_CTRL_REG0_HMASK4 20
#define CVE_COMMON_CTRL_REG0_LMASK4 16
#define CVE_COMMON_CTRL_REG0_HMASK5 31
#define CVE_COMMON_CTRL_REG0_LMASK5 24
#else
#define CVE_COMMON_CTRL_REG0_HMASK0 31
#define CVE_COMMON_CTRL_REG0_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG1_0 0x3
#define CVE_COMMON_CTRL_REG1_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_0_HMASK0 31
#define CVE_COMMON_CTRL_REG1_0_LMASK0 0

#define CVE_COMMON_CTRL_REG1_1 0x4
#define CVE_COMMON_CTRL_REG1_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_1_HMASK0 31
#define CVE_COMMON_CTRL_REG1_1_LMASK0 0

#define CVE_COMMON_CTRL_REG1_2 0x5
#define CVE_COMMON_CTRL_REG1_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_2_HMASK0 31
#define CVE_COMMON_CTRL_REG1_2_LMASK0 0

#define CVE_COMMON_CTRL_REG1_3 0x6
#define CVE_COMMON_CTRL_REG1_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_3_HMASK0 31
#define CVE_COMMON_CTRL_REG1_3_LMASK0 0

#define CVE_COMMON_CTRL_REG1_4 0x7
#define CVE_COMMON_CTRL_REG1_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_4_HMASK0 31
#define CVE_COMMON_CTRL_REG1_4_LMASK0 0

#define CVE_COMMON_CTRL_REG1_5 0x8
#define CVE_COMMON_CTRL_REG1_5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_5_HMASK0 31
#define CVE_COMMON_CTRL_REG1_5_LMASK0 0

#define CVE_COMMON_CTRL_REG1_6 0x9
#define CVE_COMMON_CTRL_REG1_6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_6_HMASK0 31
#define CVE_COMMON_CTRL_REG1_6_LMASK0 0

#define CVE_COMMON_CTRL_REG1_7 0xa
#define CVE_COMMON_CTRL_REG1_7_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG1_7_HMASK0 31
#define CVE_COMMON_CTRL_REG1_7_LMASK0 0

#define CVE_COMMON_CTRL_REG2_0 0xb
#define CVE_COMMON_CTRL_REG2_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG2_0_HMASK0 31
#define CVE_COMMON_CTRL_REG2_0_LMASK0 0

#define CVE_COMMON_CTRL_REG2_1 0xc
#define CVE_COMMON_CTRL_REG2_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG2_1_HMASK0 31
#define CVE_COMMON_CTRL_REG2_1_LMASK0 0

#define CVE_COMMON_CTRL_REG2_2 0xd
#define CVE_COMMON_CTRL_REG2_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG2_2_HMASK0 31
#define CVE_COMMON_CTRL_REG2_2_LMASK0 0

#define CVE_COMMON_CTRL_REG2_3 0xe
#define CVE_COMMON_CTRL_REG2_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG2_3_HMASK0 31
#define CVE_COMMON_CTRL_REG2_3_LMASK0 0

#define CVE_COMMON_CTRL_REG2_4 0xf
#define CVE_COMMON_CTRL_REG2_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG2_4_HMASK0 31
#define CVE_COMMON_CTRL_REG2_4_LMASK0 0

#define CVE_COMMON_CTRL_REG3_0 0x10
#define CVE_COMMON_CTRL_REG3_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG3_0_HMASK0 12
#define CVE_COMMON_CTRL_REG3_0_LMASK0 0
#define CVE_COMMON_CTRL_REG3_0_HMASK1 28
#define CVE_COMMON_CTRL_REG3_0_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG3_0_HMASK0 31
#define CVE_COMMON_CTRL_REG3_0_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG3_1 0x11
#define CVE_COMMON_CTRL_REG3_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG3_1_HMASK0 12
#define CVE_COMMON_CTRL_REG3_1_LMASK0 0
#define CVE_COMMON_CTRL_REG3_1_HMASK1 28
#define CVE_COMMON_CTRL_REG3_1_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG3_1_HMASK0 31
#define CVE_COMMON_CTRL_REG3_1_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG3_2 0x12
#define CVE_COMMON_CTRL_REG3_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG3_2_HMASK0 12
#define CVE_COMMON_CTRL_REG3_2_LMASK0 0
#define CVE_COMMON_CTRL_REG3_2_HMASK1 28
#define CVE_COMMON_CTRL_REG3_2_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG3_2_HMASK0 31
#define CVE_COMMON_CTRL_REG3_2_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG3_3 0x13
#define CVE_COMMON_CTRL_REG3_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG3_3_HMASK0 12
#define CVE_COMMON_CTRL_REG3_3_LMASK0 0
#define CVE_COMMON_CTRL_REG3_3_HMASK1 28
#define CVE_COMMON_CTRL_REG3_3_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG3_3_HMASK0 31
#define CVE_COMMON_CTRL_REG3_3_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG4_0 0x14
#define CVE_COMMON_CTRL_REG4_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG4_0_HMASK0 12
#define CVE_COMMON_CTRL_REG4_0_LMASK0 0
#define CVE_COMMON_CTRL_REG4_0_HMASK1 28
#define CVE_COMMON_CTRL_REG4_0_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG4_0_HMASK0 31
#define CVE_COMMON_CTRL_REG4_0_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG4_1 0x15
#define CVE_COMMON_CTRL_REG4_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG4_1_HMASK0 12
#define CVE_COMMON_CTRL_REG4_1_LMASK0 0
#define CVE_COMMON_CTRL_REG4_1_HMASK1 28
#define CVE_COMMON_CTRL_REG4_1_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG4_1_HMASK0 31
#define CVE_COMMON_CTRL_REG4_1_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG5 0x16
#define CVE_COMMON_CTRL_REG5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_COMMON_CTRL_REG5_HMASK0 28
#define CVE_COMMON_CTRL_REG5_LMASK0 16

#define CVE_COMMON_CTRL_REG6 0x17
#define CVE_COMMON_CTRL_REG6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG6_HMASK0 13
#define CVE_COMMON_CTRL_REG6_LMASK0 0
#define CVE_COMMON_CTRL_REG6_HMASK1 29
#define CVE_COMMON_CTRL_REG6_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG6_HMASK0 31
#define CVE_COMMON_CTRL_REG6_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG7 0x18
#define CVE_COMMON_CTRL_REG7_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG7_HMASK0 13
#define CVE_COMMON_CTRL_REG7_LMASK0 0
#define CVE_COMMON_CTRL_REG7_HMASK1 29
#define CVE_COMMON_CTRL_REG7_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG7_HMASK0 31
#define CVE_COMMON_CTRL_REG7_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG8 0x19
#define CVE_COMMON_CTRL_REG8_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG8_HMASK0 13
#define CVE_COMMON_CTRL_REG8_LMASK0 0
#define CVE_COMMON_CTRL_REG8_HMASK1 29
#define CVE_COMMON_CTRL_REG8_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG8_HMASK0 31
#define CVE_COMMON_CTRL_REG8_LMASK0 0
#endif

#define CVE_COMMON_CTRL_REG9 0x1a
#define CVE_COMMON_CTRL_REG9_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_COMMON_CTRL_REG9_HMASK0 13
#define CVE_COMMON_CTRL_REG9_LMASK0 0
#define CVE_COMMON_CTRL_REG9_HMASK1 29
#define CVE_COMMON_CTRL_REG9_LMASK1 16
#else
#define CVE_COMMON_CTRL_REG9_HMASK0 31
#define CVE_COMMON_CTRL_REG9_LMASK0 0
#endif

#define CVE_DMA_REG0 0x1b
#define CVE_DMA_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_DMA_REG0_HMASK0 7
#define CVE_DMA_REG0_LMASK0 0
#define CVE_DMA_REG0_HMASK1 15
#define CVE_DMA_REG0_LMASK1 8
#define CVE_DMA_REG0_HMASK2 23
#define CVE_DMA_REG0_LMASK2 16
#define CVE_DMA_REG0_HMASK3 24
#define CVE_DMA_REG0_LMASK3 24
#define CVE_DMA_REG0_HMASK4 30
#define CVE_DMA_REG0_LMASK4 28
#else
#define CVE_DMA_REG0_HMASK0 31
#define CVE_DMA_REG0_LMASK0 0
#endif

#define CVE_DMA_REG1 0x1c
#define CVE_DMA_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_DMA_REG1_HMASK0 31
#define CVE_DMA_REG1_LMASK0 0

#define CVE_DMA_REG2 0x1d
#define CVE_DMA_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_DMA_REG2_HMASK0 31
#define CVE_DMA_REG2_LMASK0 0

#define CVE_DMA_REG3 0x1e
#define CVE_DMA_REG3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_DMA_REG3_HMASK0 7
#define CVE_DMA_REG3_LMASK0 0
#define CVE_DMA_REG3_HMASK1 15
#define CVE_DMA_REG3_LMASK1 8
#define CVE_DMA_REG3_HMASK2 29
#define CVE_DMA_REG3_LMASK2 16
#define CVE_DMA_REG3_HMASK3 31
#define CVE_DMA_REG3_LMASK3 30
#else
#define CVE_DMA_REG3_HMASK0 31
#define CVE_DMA_REG3_LMASK0 0
#endif

#define CVE_FILTER_REG2 0x1f
#define CVE_FILTER_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG2_HMASK0 21
#define CVE_FILTER_REG2_LMASK0 16
#define CVE_FILTER_REG2_HMASK1 24
#define CVE_FILTER_REG2_LMASK1 24
#else
#define CVE_FILTER_REG2_HMASK0 24
#define CVE_FILTER_REG2_LMASK0 16
#endif

#define CVE_FILTER_REG1_0 0x20
#define CVE_FILTER_REG1_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG1_0_HMASK0 7
#define CVE_FILTER_REG1_0_LMASK0 0
#define CVE_FILTER_REG1_0_HMASK1 15
#define CVE_FILTER_REG1_0_LMASK1 8
#define CVE_FILTER_REG1_0_HMASK2 23
#define CVE_FILTER_REG1_0_LMASK2 16
#define CVE_FILTER_REG1_0_HMASK3 31
#define CVE_FILTER_REG1_0_LMASK3 24
#else
#define CVE_FILTER_REG1_0_HMASK0 31
#define CVE_FILTER_REG1_0_LMASK0 0
#endif

#define CVE_FILTER_REG1_1 0x21
#define CVE_FILTER_REG1_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG1_1_HMASK0 7
#define CVE_FILTER_REG1_1_LMASK0 0
#define CVE_FILTER_REG1_1_HMASK1 15
#define CVE_FILTER_REG1_1_LMASK1 8
#define CVE_FILTER_REG1_1_HMASK2 23
#define CVE_FILTER_REG1_1_LMASK2 16
#define CVE_FILTER_REG1_1_HMASK3 31
#define CVE_FILTER_REG1_1_LMASK3 24
#else
#define CVE_FILTER_REG1_1_HMASK0 31
#define CVE_FILTER_REG1_1_LMASK0 0
#endif

#define CVE_FILTER_REG2_3 0x22
#define CVE_FILTER_REG2_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_FILTER_REG2_3_HMASK0 7
#define CVE_FILTER_REG2_3_LMASK0 0

#define CVE_CSC_REG0 0x23
#define CVE_CSC_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG0_HMASK0 10
#define CVE_CSC_REG0_LMASK0 8
#define CVE_CSC_REG0_HMASK1 14
#define CVE_CSC_REG0_LMASK1 12
#define CVE_CSC_REG0_HMASK2 18
#define CVE_CSC_REG0_LMASK2 16
#define CVE_CSC_REG0_HMASK3 22
#define CVE_CSC_REG0_LMASK3 20
#define CVE_CSC_REG0_HMASK4 24
#define CVE_CSC_REG0_LMASK4 24
#define CVE_CSC_REG0_HMASK5 30
#define CVE_CSC_REG0_LMASK5 28
#else
#define CVE_CSC_REG0_HMASK0 31
#define CVE_CSC_REG0_LMASK0 8
#endif

#define CVE_CSC_REG 0x24
#define CVE_CSC_REG_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG_HMASK0 0x15
#define CVE_CSC_REG_LMASK0 0x10
#define CVE_CSC_REG_HMASK1 0x1d
#define CVE_CSC_REG_LMASK1 0x18
#else
#define CVE_CSC_REG_HMASK0 0x1d
#define CVE_CSC_REG_LMASK0 0x10
#endif

#define CVE_SOBEL_REG0 0x25
#define CVE_SOBEL_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_SOBEL_REG0_HMASK0 25
#define CVE_SOBEL_REG0_LMASK0 24

#define CVE_MAGANDANG_REG0 0x26
#define CVE_MAGANDANG_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_MAGANDANG_REG0_HMASK0 15
#define CVE_MAGANDANG_REG0_LMASK0 0
#define CVE_MAGANDANG_REG0_HMASK1 16
#define CVE_MAGANDANG_REG0_LMASK1 16
#define CVE_MAGANDANG_REG0_HMASK2 25
#define CVE_MAGANDANG_REG0_LMASK2 24
#else
#define CVE_MAGANDANG_REG0_HMASK0 31
#define CVE_MAGANDANG_REG0_LMASK0 0
#endif

#define CVE_BGMODE_REG0 0x27
#define CVE_BGMODE_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_BGMODE_REG0_HMASK0 1
#define CVE_BGMODE_REG0_LMASK0 0
#define CVE_BGMODE_REG0_HMASK1 5
#define CVE_BGMODE_REG0_LMASK1 4
#define CVE_BGMODE_REG0_HMASK2 15
#define CVE_BGMODE_REG0_LMASK2 8
#define CVE_BGMODE_REG0_HMASK3 27
#define CVE_BGMODE_REG0_LMASK3 16
#else
#define CVE_BGMODE_REG0_HMASK0 31
#define CVE_BGMODE_REG0_LMASK0 0
#endif

#ifdef CVE_OUTPUT_PROC
#define CVE_BGMODE_REG1 0x28
#define CVE_BGMODE_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_BGMODE_REG1_HMASK0 31
#define CVE_BGMODE_REG1_LMASK0 0

#define CVE_BGMODE_REG2 0x29
#define CVE_BGMODE_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_BGMODE_REG2_HMASK0 31
#define CVE_BGMODE_REG2_LMASK0 0
#endif

#define CVE_UPDATEBGMODE_REG0 0x2a
#define CVE_UPDATEBGMODE_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_UPDATEBGMODE_REG0_HMASK0 15
#define CVE_UPDATEBGMODE_REG0_LMASK0 0
#define CVE_UPDATEBGMODE_REG0_HMASK1 31
#define CVE_UPDATEBGMODE_REG0_LMASK1 16
#else
#define CVE_UPDATEBGMODE_REG0_HMASK0 31
#define CVE_UPDATEBGMODE_REG0_LMASK0 0
#endif

#define CVE_UPDATEBGMODE_REG1 0x2b
#define CVE_UPDATEBGMODE_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_UPDATEBGMODE_REG1_HMASK0 15
#define CVE_UPDATEBGMODE_REG1_LMASK0 0
#define CVE_UPDATEBGMODE_REG1_HMASK1 31
#define CVE_UPDATEBGMODE_REG1_LMASK1 16
#else
#define CVE_UPDATEBGMODE_REG1_HMASK0 31
#define CVE_UPDATEBGMODE_REG1_LMASK0 0
#endif

#ifdef CVE_OUTPUT_PROC
#define CVE_UPDATEBGMODE_REG2 0x2c
#define CVE_UPDATEBGMODE_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_UPDATEBGMODE_REG2_HMASK0 31
#define CVE_UPDATEBGMODE_REG2_LMASK0 0

#define CVE_UPDATEBGMODE_REG3 0x2d
#define CVE_UPDATEBGMODE_REG3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_UPDATEBGMODE_REG3_HMASK0 31
#define CVE_UPDATEBGMODE_REG3_LMASK0 0
#endif

#define CVE_ERODEDILATE_REG0 0x2e
#define CVE_ERODEDILATE_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_ERODEDILATE_REG0_HMASK0 0
#define CVE_ERODEDILATE_REG0_LMASK0 0

#define CVE_THRESH_REG0 0x2f
#define CVE_THRESH_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESH_REG0_HMASK0 23
#define CVE_THRESH_REG0_LMASK0 16
#define CVE_THRESH_REG0_HMASK1 26
#define CVE_THRESH_REG0_LMASK1 24
#else
#define CVE_THRESH_REG0_HMASK0 26
#define CVE_THRESH_REG0_LMASK0 16
#endif

#define CVE_THRESH_REG1 0x30
#define CVE_THRESH_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESH_REG1_HMASK0 7
#define CVE_THRESH_REG1_LMASK0 0
#define CVE_THRESH_REG1_HMASK1 15
#define CVE_THRESH_REG1_LMASK1 8
#define CVE_THRESH_REG1_HMASK2 23
#define CVE_THRESH_REG1_LMASK2 16
#define CVE_THRESH_REG1_HMASK3 31
#define CVE_THRESH_REG1_LMASK3 24
#else
#define CVE_THRESH_REG1_HMASK0 31
#define CVE_THRESH_REG1_LMASK0 0
#endif

#define CVE_ALU_REG0 0x31
#define CVE_ALU_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_ALU_REG0_HMASK0 9
#define CVE_ALU_REG0_LMASK0 8
#define CVE_ALU_REG0_HMASK1 18
#define CVE_ALU_REG0_LMASK1 16
#else
#define CVE_ALU_REG0_HMASK0 18
#define CVE_ALU_REG0_LMASK0 8
#endif

#define CVE_ALU_REG1 0x32
#define CVE_ALU_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_ALU_REG1_HMASK0 15
#define CVE_ALU_REG1_LMASK0 0
#define CVE_ALU_REG1_HMASK1 31
#define CVE_ALU_REG1_LMASK1 16
#else
#define CVE_ALU_REG1_HMASK0 31
#define CVE_ALU_REG1_LMASK0 0
#endif

#define CVE_INTEG_REG0 0x33
#define CVE_INTEG_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_INTEG_REG0_HMASK0 0
#define CVE_INTEG_REG0_LMASK0 0
#define CVE_INTEG_REG0_HMASK1 17
#define CVE_INTEG_REG0_LMASK1 16
#else
#define CVE_INTEG_REG0_HMASK0 17
#define CVE_INTEG_REG0_LMASK0 0
#endif

#define CVE_EQHIST_REG0 0x34
#define CVE_EQHIST_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_EQHIST_REG0_HMASK0 31
#define CVE_EQHIST_REG0_LMASK0 0

#define CVE_THRESHS16_REG0 0x35
#define CVE_THRESHS16_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESHS16_REG0_HMASK0 7
#define CVE_THRESHS16_REG0_LMASK0 0
#define CVE_THRESHS16_REG0_HMASK1 15
#define CVE_THRESHS16_REG0_LMASK1 8
#define CVE_THRESHS16_REG0_HMASK2 23
#define CVE_THRESHS16_REG0_LMASK2 16
#define CVE_THRESHS16_REG0_HMASK3 25
#define CVE_THRESHS16_REG0_LMASK3 24
#else
#define CVE_THRESHS16_REG0_HMASK0 25
#define CVE_THRESHS16_REG0_LMASK0 0
#endif

#define CVE_THRESHS16_REG1 0x36
#define CVE_THRESHS16_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESHS16_REG1_HMASK0 15
#define CVE_THRESHS16_REG1_LMASK0 0
#define CVE_THRESHS16_REG1_HMASK1 31
#define CVE_THRESHS16_REG1_LMASK1 16
#else
#define CVE_THRESHS16_REG1_HMASK0 31
#define CVE_THRESHS16_REG1_LMASK0 0
#endif

#define CVE_THRESHU16_REG0 0x37
#define CVE_THRESHU16_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESHU16_REG0_HMASK0 7
#define CVE_THRESHU16_REG0_LMASK0 0
#define CVE_THRESHU16_REG0_HMASK1 15
#define CVE_THRESHU16_REG0_LMASK1 8
#define CVE_THRESHU16_REG0_HMASK2 23
#define CVE_THRESHU16_REG0_LMASK2 16
#define CVE_THRESHU16_REG0_HMASK3 24
#define CVE_THRESHU16_REG0_LMASK3 24
#else
#define CVE_THRESHU16_REG0_HMASK0 24
#define CVE_THRESHU16_REG0_LMASK0 0
#endif

#define CVE_THRESHU16_REG1 0x38
#define CVE_THRESHU16_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_THRESHU16_REG1_HMASK0 15
#define CVE_THRESHU16_REG1_LMASK0 0
#define CVE_THRESHU16_REG1_HMASK1 31
#define CVE_THRESHU16_REG1_LMASK1 16
#else
#define CVE_THRESHU16_REG1_HMASK0 31
#define CVE_THRESHU16_REG1_LMASK0 0
#endif

#define CVE_16BITTO8BIT_REG0 0x39
#define CVE_16BITTO8BIT_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_16BITTO8BIT_REG0_HMASK0 25
#define CVE_16BITTO8BIT_REG0_LMASK0 24

#define CVE_16BITTO8BIT_REG1 0x3a
#define CVE_16BITTO8BIT_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_16BITTO8BIT_REG1_HMASK0 7
#define CVE_16BITTO8BIT_REG1_LMASK0 0
#define CVE_16BITTO8BIT_REG1_HMASK1 31
#define CVE_16BITTO8BIT_REG1_LMASK1 16
#else
#define CVE_16BITTO8BIT_REG1_HMASK0 31
#define CVE_16BITTO8BIT_REG1_LMASK0 0
#endif

#define CVE_STATFILTER_REG0 0x3b
#define CVE_STATFILTER_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_STATFILTER_REG0_HMASK0 3
#define CVE_STATFILTER_REG0_LMASK0 0
#define CVE_STATFILTER_REG0_HMASK1 11
#define CVE_STATFILTER_REG0_LMASK1 8
#define CVE_STATFILTER_REG0_HMASK2 19
#define CVE_STATFILTER_REG0_LMASK2 16
#define CVE_STATFILTER_REG0_HMASK3 25
#define CVE_STATFILTER_REG0_LMASK3 24
#else
#define CVE_STATFILTER_REG0_HMASK0 25
#define CVE_STATFILTER_REG0_LMASK0 0
#endif

#define CVE_MAP_REG0 0x3c
#define CVE_MAP_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_MAP_REG0_HMASK0 25
#define CVE_MAP_REG0_LMASK0 24

#define CVE_NCC_REG0 0x3c
#define CVE_NCC_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_NCC_REG0_HMASK0 0
#define CVE_NCC_REG0_LMASK0 0
#define CVE_NCC_REG0_HMASK1 15
#define CVE_NCC_REG0_LMASK1 8
#define CVE_NCC_REG0_HMASK2 23
#define CVE_NCC_REG0_LMASK2 16
#else
#define CVE_NCC_REG0_HMASK0 23
#define CVE_NCC_REG0_LMASK0 0
#endif

#if 0
#define CVE_NCC_U64NUM_REG0 0x3d
#define CVE_NCC_U64NUM_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64NUM_REG0_HMASK0 31
#define CVE_NCC_U64NUM_REG0_LMASK0 0

#define CVE_NCC_U64NUM_REG1 0x3e
#define CVE_NCC_U64NUM_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64NUM_REG1_HMASK0 31
#define CVE_NCC_U64NUM_REG1_LMASK0 0

#define CVE_NCC_U64QUADSUM1_REG0 0x3f
#define CVE_NCC_U64QUADSUM1_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64QUADSUM1_REG0_HMASK0 31
#define CVE_NCC_U64QUADSUM1_REG0_LMASK0 0

#define CVE_NCC_U64QUADSUM1_REG1 0x40
#define CVE_NCC_U64QUADSUM1_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64QUADSUM1_REG1_HMASK0 31
#define CVE_NCC_U64QUADSUM1_REG1_LMASK0 0

#define CVE_NCC_U64QUADSUM2_REG0 0x41
#define CVE_NCC_U64QUADSUM2_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64QUADSUM2_REG0_HMASK0 31
#define CVE_NCC_U64QUADSUM2_REG0_LMASK0 0

#define CVE_NCC_U64QUADSUM2_REG1 0x42
#define CVE_NCC_U64QUADSUM2_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_NCC_U64QUADSUM2_REG1_HMASK0 31
#define CVE_NCC_U64QUADSUM2_REG1_LMASK0 0

#define CVE_CCL_REG0 0x43
#define CVE_CCL_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_CCL_REG0_HMASK0 8
#define CVE_CCL_REG0_LMASK0 0
#endif

#define CVE_GMM_REG0 0x44
#define CVE_GMM_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG0_HMASK0 15
#define CVE_GMM_REG0_LMASK0 0
#define CVE_GMM_REG0_HMASK1 31
#define CVE_GMM_REG0_LMASK1 16
#else
#define CVE_GMM_REG0_HMASK0 31
#define CVE_GMM_REG0_LMASK0 0
#endif

#define CVE_GMM_REG1 0x45
#define CVE_GMM_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG1_HMASK0 15
#define CVE_GMM_REG1_LMASK0 0
#define CVE_GMM_REG1_HMASK1 25
#define CVE_GMM_REG1_LMASK1 24
#define CVE_GMM_REG1_HMASK2 28
#define CVE_GMM_REG1_LMASK2 28
#else
#define CVE_GMM_REG1_HMASK0 28
#define CVE_GMM_REG1_LMASK0 0
#endif

#define CVE_GMM_REG2 0x46
#define CVE_GMM_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG2_HMASK0 1
#define CVE_GMM_REG2_LMASK0 0
#define CVE_GMM_REG2_HMASK1 6
#define CVE_GMM_REG2_LMASK1 4
#define CVE_GMM_REG2_HMASK2 23
#define CVE_GMM_REG2_LMASK2 8
#else
#define CVE_GMM_REG2_HMASK0 23
#define CVE_GMM_REG2_LMASK0 0
#endif

#define CVE_GMM_REG3 0x47
#define CVE_GMM_REG3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG3_HMASK0 11
#define CVE_GMM_REG3_LMASK0 0
#define CVE_GMM_REG3_HMASK1 31
#define CVE_GMM_REG3_LMASK1 16
#else
#define CVE_GMM_REG3_HMASK0 31
#define CVE_GMM_REG3_LMASK0 0
#endif

#define CVE_GMM_REG4 0x48
#define CVE_GMM_REG4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG4_HMASK0 9
#define CVE_GMM_REG4_LMASK0 0
#define CVE_GMM_REG4_HMASK1 31
#define CVE_GMM_REG4_LMASK1 16
#else
#define CVE_GMM_REG4_HMASK0 31
#define CVE_GMM_REG4_LMASK0 0
#endif

#define CVE_GMM_REG5 0x49
#define CVE_GMM_REG5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GMM_REG5_HMASK0 11
#define CVE_GMM_REG5_LMASK0 0
#define CVE_GMM_REG5_HMASK1 15
#define CVE_GMM_REG5_LMASK1 15
#define CVE_GMM_REG5_HMASK2 23
#define CVE_GMM_REG5_LMASK2 23
#define CVE_GMM_REG5_HMASK3 31
#define CVE_GMM_REG5_LMASK3 31
#else
#define CVE_GMM_REG5_HMASK0 31
#define CVE_GMM_REG5_LMASK0 0
#endif

#define CVE_CANNY_REG0 0x4a
#define CVE_CANNY_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CANNY_REG0_HMASK0 15
#define CVE_CANNY_REG0_LMASK0 0
#define CVE_CANNY_REG0_HMASK1 31
#define CVE_CANNY_REG0_LMASK1 16
#else
#define CVE_CANNY_REG0_HMASK0 31
#define CVE_CANNY_REG0_LMASK0 0
#endif

#ifdef CVE_OUTPUT_PROC
#define CVE_CANNY_REG1 0x4b
#define CVE_CANNY_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_CANNY_REG1_HMASK0 31
#define CVE_CANNY_REG1_LMASK0 0
#endif

#define CVE_CANNY_REG2 0x4c
#define CVE_CANNY_REG2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_CANNY_REG2_HMASK0 24
#define CVE_CANNY_REG2_LMASK0 24

#define CVE_LBP_REG0 0x4d
#define CVE_LBP_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_LBP_REG0_HMASK0 23
#define CVE_LBP_REG0_LMASK0 16
#define CVE_LBP_REG0_HMASK1 24
#define CVE_LBP_REG0_LMASK1 24
#else
#define CVE_LBP_REG0_HMASK0 24
#define CVE_LBP_REG0_LMASK0 16
#endif

#define CVE_NORMGRAD_RETG0 0x4e
#define CVE_NORMGRAD_RETG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_NORMGRAD_RETG0_HMASK0 23
#define CVE_NORMGRAD_RETG0_LMASK0 16
#define CVE_NORMGRAD_RETG0_HMASK1 29
#define CVE_NORMGRAD_RETG0_LMASK1 28
#else
#define CVE_NORMGRAD_RETG0_HMASK0 29
#define CVE_NORMGRAD_RETG0_LMASK0 16
#endif

#define CVE_BDLK_REG0 0x4f
#define CVE_BDLK_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_BDLK_REG0_HMASK0 26
#define CVE_BDLK_REG0_LMASK0 24

#define CVE_LK_REG0 0x50
#define CVE_LK_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_LK_REG0_HMASK0 9
#define CVE_LK_REG0_LMASK0 0
#define CVE_LK_REG0_HMASK1 16
#define CVE_LK_REG0_LMASK1 16
#define CVE_LK_REG0_HMASK2 25
#define CVE_LK_REG0_LMASK2 24
#else
#define CVE_LK_REG0_HMASK0 25
#define CVE_LK_REG0_LMASK0 0
#endif

#define CVE_LK_REG1 0x51
#define CVE_LK_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_LK_REG1_HMASK0 15
#define CVE_LK_REG1_LMASK0 8
#define CVE_LK_REG1_HMASK1 23
#define CVE_LK_REG1_LMASK1 16
#define CVE_LK_REG1_HMASK2 25
#define CVE_LK_REG1_LMASK2 24
#else
#define CVE_LK_REG1_HMASK0 25
#define CVE_LK_REG1_LMASK0 8
#endif

#ifdef CVE_OUTPUT_PROC
#define CVE_LK_REG2_0 0x52
#define CVE_LK_REG2_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_0_HMASK0 31
#define CVE_LK_REG2_0_LMASK0 0

#define CVE_LK_REG2_1 0x53
#define CVE_LK_REG2_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_1_HMASK0 31
#define CVE_LK_REG2_1_LMASK0 0

#define CVE_LK_REG2_2 0x54
#define CVE_LK_REG2_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_2_HMASK0 31
#define CVE_LK_REG2_2_LMASK0 0

#define CVE_LK_REG2_3 0x55
#define CVE_LK_REG2_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_3_HMASK0 31
#define CVE_LK_REG2_3_LMASK0 0

#define CVE_LK_REG2_4 0x56
#define CVE_LK_REG2_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_4_HMASK0 31
#define CVE_LK_REG2_4_LMASK0 0

#define CVE_LK_REG2_5 0x57
#define CVE_LK_REG2_5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_5_HMASK0 31
#define CVE_LK_REG2_5_LMASK0 0

#define CVE_LK_REG2_6 0x58
#define CVE_LK_REG2_6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_6_HMASK0 31
#define CVE_LK_REG2_6_LMASK0 0

#define CVE_LK_REG2_7 0x59
#define CVE_LK_REG2_7_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_7_HMASK0 31
#define CVE_LK_REG2_7_LMASK0 0

#define CVE_LK_REG2_8 0x5a
#define CVE_LK_REG2_8_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_8_HMASK0 31
#define CVE_LK_REG2_8_LMASK0 0

#define CVE_LK_REG2_9 0x5b
#define CVE_LK_REG2_9_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_9_HMASK0 31
#define CVE_LK_REG2_9_LMASK0 0

#define CVE_LK_REG2_10 0x5c
#define CVE_LK_REG2_10_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_10_HMASK0 31
#define CVE_LK_REG2_10_LMASK0 0

#define CVE_LK_REG2_11 0x5d
#define CVE_LK_REG2_11_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_11_HMASK0 31
#define CVE_LK_REG2_11_LMASK0 0

#define CVE_LK_REG2_12 0x5e
#define CVE_LK_REG2_12_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_12_HMASK0 31
#define CVE_LK_REG2_12_LMASK0 0

#define CVE_LK_REG2_13 0x5f
#define CVE_LK_REG2_13_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_13_HMASK0 31
#define CVE_LK_REG2_13_LMASK0 0

#define CVE_LK_REG2_14 0x60
#define CVE_LK_REG2_14_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_14_HMASK0 31
#define CVE_LK_REG2_14_LMASK0 0

#define CVE_LK_REG2_15 0x61
#define CVE_LK_REG2_15_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_15_HMASK0 31
#define CVE_LK_REG2_15_LMASK0 0

#define CVE_LK_REG2_16 0x62
#define CVE_LK_REG2_16_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_LK_REG2_16_HMASK0 31
#define CVE_LK_REG2_16_LMASK0 0

#define CVE_STCORNER_REG0 0x63
#define CVE_STCORNER_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_STCORNER_REG0_HMASK0 31
#define CVE_STCORNER_REG0_LMASK0 0
#endif

#define CVE_SAD_REG0 0x64
#define CVE_SAD_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SAD_REG0_HMASK0 7
#define CVE_SAD_REG0_LMASK0 0
#define CVE_SAD_REG0_HMASK1 9
#define CVE_SAD_REG0_LMASK1 8
#else
#define CVE_SAD_REG0_HMASK0 9
#define CVE_SAD_REG0_LMASK0 0
#endif

#define CVE_SAD_REG1 0x65
#define CVE_SAD_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SAD_REG1_HMASK0 3
#define CVE_SAD_REG1_LMASK0 0
#define CVE_SAD_REG1_HMASK1 15
#define CVE_SAD_REG1_LMASK1 8
#define CVE_SAD_REG1_HMASK2 31
#define CVE_SAD_REG1_LMASK2 16
#else
#define CVE_SAD_REG1_HMASK0 31
#define CVE_SAD_REG1_LMASK0 0
#endif

#define CVE_GRADFG_RETG0 0x66
#define CVE_GRADFG_RETG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_GRADFG_RETG0_HMASK0 7
#define CVE_GRADFG_RETG0_LMASK0 0
#define CVE_GRADFG_RETG0_HMASK1 25
#define CVE_GRADFG_RETG0_LMASK1 24
#else
#define CVE_GRADFG_RETG0_HMASK0 25
#define CVE_GRADFG_RETG0_LMASK0 0
#endif

#define CVE_FILTER_REG0_0 0x67
#define CVE_FILTER_REG0_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_0_HMASK0 7
#define CVE_FILTER_REG0_0_LMASK0 0
#define CVE_FILTER_REG0_0_HMASK1 15
#define CVE_FILTER_REG0_0_LMASK1 8
#define CVE_FILTER_REG0_0_HMASK2 23
#define CVE_FILTER_REG0_0_LMASK2 16
#define CVE_FILTER_REG0_0_HMASK3 31
#define CVE_FILTER_REG0_0_LMASK3 24
#else
#define CVE_FILTER_REG0_0_HMASK0 31
#define CVE_FILTER_REG0_0_LMASK0 0
#endif

#define CVE_FILTER_REG0_1 0x68
#define CVE_FILTER_REG0_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_1_HMASK0 7
#define CVE_FILTER_REG0_1_LMASK0 0
#define CVE_FILTER_REG0_1_HMASK1 15
#define CVE_FILTER_REG0_1_LMASK1 8
#define CVE_FILTER_REG0_1_HMASK2 23
#define CVE_FILTER_REG0_1_LMASK2 16
#define CVE_FILTER_REG0_1_HMASK3 31
#define CVE_FILTER_REG0_1_LMASK3 24
#else
#define CVE_FILTER_REG0_1_HMASK0 31
#define CVE_FILTER_REG0_1_LMASK0 0
#endif

#define CVE_FILTER_REG0_2 0x69
#define CVE_FILTER_REG0_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_2_HMASK0 7
#define CVE_FILTER_REG0_2_LMASK0 0
#define CVE_FILTER_REG0_2_HMASK1 15
#define CVE_FILTER_REG0_2_LMASK1 8
#define CVE_FILTER_REG0_2_HMASK2 23
#define CVE_FILTER_REG0_2_LMASK2 16
#define CVE_FILTER_REG0_2_HMASK3 31
#define CVE_FILTER_REG0_2_LMASK3 24
#else
#define CVE_FILTER_REG0_2_HMASK0 31
#define CVE_FILTER_REG0_2_LMASK0 0
#endif

#define CVE_FILTER_REG0_3 0x6a
#define CVE_FILTER_REG0_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_3_HMASK0 7
#define CVE_FILTER_REG0_3_LMASK0 0
#define CVE_FILTER_REG0_3_HMASK1 15
#define CVE_FILTER_REG0_3_LMASK1 8
#define CVE_FILTER_REG0_3_HMASK2 23
#define CVE_FILTER_REG0_3_LMASK2 16
#define CVE_FILTER_REG0_3_HMASK3 31
#define CVE_FILTER_REG0_3_LMASK3 24
#else
#define CVE_FILTER_REG0_3_HMASK0 31
#define CVE_FILTER_REG0_3_LMASK0 0
#endif

#define CVE_FILTER_REG0_4 0x6b
#define CVE_FILTER_REG0_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_4_HMASK0 7
#define CVE_FILTER_REG0_4_LMASK0 0
#define CVE_FILTER_REG0_4_HMASK1 15
#define CVE_FILTER_REG0_4_LMASK1 8
#define CVE_FILTER_REG0_4_HMASK2 23
#define CVE_FILTER_REG0_4_LMASK2 16
#define CVE_FILTER_REG0_4_HMASK3 31
#define CVE_FILTER_REG0_4_LMASK3 24
#else
#define CVE_FILTER_REG0_4_HMASK0 31
#define CVE_FILTER_REG0_4_LMASK0 0
#endif

#define CVE_FILTER_REG0_5 0x6c
#define CVE_FILTER_REG0_5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_5_HMASK0 7
#define CVE_FILTER_REG0_5_LMASK0 0
#define CVE_FILTER_REG0_5_HMASK1 15
#define CVE_FILTER_REG0_5_LMASK1 8
#define CVE_FILTER_REG0_5_HMASK2 23
#define CVE_FILTER_REG0_5_LMASK2 16
#define CVE_FILTER_REG0_5_HMASK3 31
#define CVE_FILTER_REG0_5_LMASK3 24
#else
#define CVE_FILTER_REG0_5_HMASK0 31
#define CVE_FILTER_REG0_5_LMASK0 0
#endif

#define CVE_FILTER_REG0_6 0x6d
#define CVE_FILTER_REG0_6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_FILTER_REG0_6_HMASK0 5
#define CVE_FILTER_REG0_6_LMASK0 0
#define CVE_FILTER_REG0_6_HMASK1 31
#define CVE_FILTER_REG0_6_LMASK1 24
#else
#define CVE_FILTER_REG0_6_HMASK0 31
#define CVE_FILTER_REG0_6_LMASK0 0
#endif

#define CVE_CSC_REG1 0x6e
#define CVE_CSC_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG1_HMASK0 9
#define CVE_CSC_REG1_LMASK0 0
#define CVE_CSC_REG1_HMASK1 19
#define CVE_CSC_REG1_LMASK1 10
#else
#define CVE_CSC_REG1_HMASK0 19
#define CVE_CSC_REG1_LMASK0 0
#endif

#define CVE_CSC_REG1_1 0x6f
#define CVE_CSC_REG1_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_CSC_REG1_1_HMASK0 9
#define CVE_CSC_REG1_1_LMASK0 0

#define CVE_CSC_REG2_0 0x70
#define CVE_CSC_REG2_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG2_0_HMASK0 9
#define CVE_CSC_REG2_0_LMASK0 0
#define CVE_CSC_REG2_0_HMASK1 20
#define CVE_CSC_REG2_0_LMASK1 11
#define CVE_CSC_REG2_0_HMASK2 31
#define CVE_CSC_REG2_0_LMASK2 22
#else
#define CVE_CSC_REG2_0_HMASK0 31
#define CVE_CSC_REG2_0_LMASK0 0
#endif

#define CVE_CSC_REG2_1 0x71
#define CVE_CSC_REG2_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG2_1_HMASK0 9
#define CVE_CSC_REG2_1_LMASK0 0
#define CVE_CSC_REG2_1_HMASK1 20
#define CVE_CSC_REG2_1_LMASK1 11
#define CVE_CSC_REG2_1_HMASK2 31
#define CVE_CSC_REG2_1_LMASK2 22
#else
#define CVE_CSC_REG2_1_HMASK0 31
#define CVE_CSC_REG2_1_LMASK0 0
#endif

#define CVE_CSC_REG2_2 0x72
#define CVE_CSC_REG2_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG2_2_HMASK0 9
#define CVE_CSC_REG2_2_LMASK0 0
#define CVE_CSC_REG2_2_HMASK1 20
#define CVE_CSC_REG2_2_LMASK1 11
#define CVE_CSC_REG2_2_HMASK2 31
#define CVE_CSC_REG2_2_LMASK2 22
#else
#define CVE_CSC_REG2_2_HMASK0 31
#define CVE_CSC_REG2_2_LMASK0 0
#endif

#define CVE_CSC_REG3 0x73
#define CVE_CSC_REG3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG3_HMASK0 9
#define CVE_CSC_REG3_LMASK0 0
#define CVE_CSC_REG3_HMASK1 19
#define CVE_CSC_REG3_LMASK1 10
#else
#define CVE_CSC_REG3_HMASK0 19
#define CVE_CSC_REG3_LMASK0 0
#endif

#define CVE_CSC_REG3_1 0x74
#define CVE_CSC_REG3_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_CSC_REG3_1_HMASK0 2
#define CVE_CSC_REG3_1_LMASK0 0
#define CVE_CSC_REG3_1_HMASK1 25
#define CVE_CSC_REG3_1_LMASK1 16
#else
#define CVE_CSC_REG3_1_HMASK0 25
#define CVE_CSC_REG3_1_LMASK0 0
#endif

#define CVE_SOBEL_REG1_0 0x75
#define CVE_SOBEL_REG1_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_0_HMASK0 5
#define CVE_SOBEL_REG1_0_LMASK0 0
#define CVE_SOBEL_REG1_0_HMASK1 13
#define CVE_SOBEL_REG1_0_LMASK1 8
#define CVE_SOBEL_REG1_0_HMASK2 21
#define CVE_SOBEL_REG1_0_LMASK2 16
#define CVE_SOBEL_REG1_0_HMASK3 29
#define CVE_SOBEL_REG1_0_LMASK3 24
#else
#define CVE_SOBEL_REG1_0_HMASK0 29
#define CVE_SOBEL_REG1_0_LMASK0 0
#endif

#define CVE_SOBEL_REG1_1 0x76
#define CVE_SOBEL_REG1_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_1_HMASK0 5
#define CVE_SOBEL_REG1_1_LMASK0 0
#define CVE_SOBEL_REG1_1_HMASK1 13
#define CVE_SOBEL_REG1_1_LMASK1 8
#define CVE_SOBEL_REG1_1_HMASK2 21
#define CVE_SOBEL_REG1_1_LMASK2 16
#define CVE_SOBEL_REG1_1_HMASK3 29
#define CVE_SOBEL_REG1_1_LMASK3 24
#else
#define CVE_SOBEL_REG1_1_HMASK0 29
#define CVE_SOBEL_REG1_1_LMASK0 0
#endif

#define CVE_SOBEL_REG1_2 0x77
#define CVE_SOBEL_REG1_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_2_HMASK0 5
#define CVE_SOBEL_REG1_2_LMASK0 0
#define CVE_SOBEL_REG1_2_HMASK1 13
#define CVE_SOBEL_REG1_2_LMASK1 8
#define CVE_SOBEL_REG1_2_HMASK2 21
#define CVE_SOBEL_REG1_2_LMASK2 16
#define CVE_SOBEL_REG1_2_HMASK3 29
#define CVE_SOBEL_REG1_2_LMASK3 24
#else
#define CVE_SOBEL_REG1_2_HMASK0 29
#define CVE_SOBEL_REG1_2_LMASK0 0
#endif

#define CVE_SOBEL_REG1_3 0x78
#define CVE_SOBEL_REG1_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_3_HMASK0 5
#define CVE_SOBEL_REG1_3_LMASK0 0
#define CVE_SOBEL_REG1_3_HMASK1 13
#define CVE_SOBEL_REG1_3_LMASK1 8
#define CVE_SOBEL_REG1_3_HMASK2 21
#define CVE_SOBEL_REG1_3_LMASK2 16
#define CVE_SOBEL_REG1_3_HMASK3 29
#define CVE_SOBEL_REG1_3_LMASK3 24
#else
#define CVE_SOBEL_REG1_3_HMASK0 29
#define CVE_SOBEL_REG1_3_LMASK0 0
#endif

#define CVE_SOBEL_REG1_4 0x79
#define CVE_SOBEL_REG1_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_4_HMASK0 5
#define CVE_SOBEL_REG1_4_LMASK0 0
#define CVE_SOBEL_REG1_4_HMASK1 13
#define CVE_SOBEL_REG1_4_LMASK1 8
#define CVE_SOBEL_REG1_4_HMASK2 21
#define CVE_SOBEL_REG1_4_LMASK2 16
#define CVE_SOBEL_REG1_4_HMASK3 29
#define CVE_SOBEL_REG1_4_LMASK3 24
#else
#define CVE_SOBEL_REG1_4_HMASK0 29
#define CVE_SOBEL_REG1_4_LMASK0 0
#endif

#define CVE_SOBEL_REG1_5 0x7a
#define CVE_SOBEL_REG1_5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG1_5_HMASK0 5
#define CVE_SOBEL_REG1_5_LMASK0 0
#define CVE_SOBEL_REG1_5_HMASK1 13
#define CVE_SOBEL_REG1_5_LMASK1 8
#define CVE_SOBEL_REG1_5_HMASK2 21
#define CVE_SOBEL_REG1_5_LMASK2 16
#define CVE_SOBEL_REG1_5_HMASK3 29
#define CVE_SOBEL_REG1_5_LMASK3 24
#else
#define CVE_SOBEL_REG1_5_HMASK0 29
#define CVE_SOBEL_REG1_5_LMASK0 0
#endif

#define CVE_SOBEL_REG1_6 0x7b
#define CVE_SOBEL_REG1_6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_SOBEL_REG1_6_HMASK0 5
#define CVE_SOBEL_REG1_6_LMASK0 0

#define CVE_SOBEL_REG2_0 0x7c
#define CVE_SOBEL_REG2_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_0_HMASK0 5
#define CVE_SOBEL_REG2_0_LMASK0 0
#define CVE_SOBEL_REG2_0_HMASK1 13
#define CVE_SOBEL_REG2_0_LMASK1 8
#define CVE_SOBEL_REG2_0_HMASK2 21
#define CVE_SOBEL_REG2_0_LMASK2 16
#define CVE_SOBEL_REG2_0_HMASK3 29
#define CVE_SOBEL_REG2_0_LMASK3 24
#else
#define CVE_SOBEL_REG2_0_HMASK0 29
#define CVE_SOBEL_REG2_0_LMASK0 0
#endif

#define CVE_SOBEL_REG2_1 0x7d
#define CVE_SOBEL_REG2_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_1_HMASK0 5
#define CVE_SOBEL_REG2_1_LMASK0 0
#define CVE_SOBEL_REG2_1_HMASK1 13
#define CVE_SOBEL_REG2_1_LMASK1 8
#define CVE_SOBEL_REG2_1_HMASK2 21
#define CVE_SOBEL_REG2_1_LMASK2 16
#define CVE_SOBEL_REG2_1_HMASK3 29
#define CVE_SOBEL_REG2_1_LMASK3 24
#else
#define CVE_SOBEL_REG2_1_HMASK0 29
#define CVE_SOBEL_REG2_1_LMASK0 0
#endif

#define CVE_SOBEL_REG2_2 0x7e
#define CVE_SOBEL_REG2_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_2_HMASK0 5
#define CVE_SOBEL_REG2_2_LMASK0 0
#define CVE_SOBEL_REG2_2_HMASK1 13
#define CVE_SOBEL_REG2_2_LMASK1 8
#define CVE_SOBEL_REG2_2_HMASK2 21
#define CVE_SOBEL_REG2_2_LMASK2 16
#define CVE_SOBEL_REG2_2_HMASK3 29
#define CVE_SOBEL_REG2_2_LMASK3 24
#else
#define CVE_SOBEL_REG2_2_HMASK0 29
#define CVE_SOBEL_REG2_2_LMASK0 0
#endif

#define CVE_SOBEL_REG2_3 0x7f
#define CVE_SOBEL_REG2_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_3_HMASK0 5
#define CVE_SOBEL_REG2_3_LMASK0 0
#define CVE_SOBEL_REG2_3_HMASK1 13
#define CVE_SOBEL_REG2_3_LMASK1 8
#define CVE_SOBEL_REG2_3_HMASK2 21
#define CVE_SOBEL_REG2_3_LMASK2 16
#define CVE_SOBEL_REG2_3_HMASK3 29
#define CVE_SOBEL_REG2_3_LMASK3 24
#else
#define CVE_SOBEL_REG2_3_HMASK0 29
#define CVE_SOBEL_REG2_3_LMASK0 0
#endif

#define CVE_SOBEL_REG2_4 0x80
#define CVE_SOBEL_REG2_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_4_HMASK0 5
#define CVE_SOBEL_REG2_4_LMASK0 0
#define CVE_SOBEL_REG2_4_HMASK1 13
#define CVE_SOBEL_REG2_4_LMASK1 8
#define CVE_SOBEL_REG2_4_HMASK2 21
#define CVE_SOBEL_REG2_4_LMASK2 16
#define CVE_SOBEL_REG2_4_HMASK3 29
#define CVE_SOBEL_REG2_4_LMASK3 24
#else
#define CVE_SOBEL_REG2_4_HMASK0 29
#define CVE_SOBEL_REG2_4_LMASK0 0
#endif

#define CVE_SOBEL_REG2_5 0x81
#define CVE_SOBEL_REG2_5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_SOBEL_REG2_5_HMASK0 5
#define CVE_SOBEL_REG2_5_LMASK0 0
#define CVE_SOBEL_REG2_5_HMASK1 13
#define CVE_SOBEL_REG2_5_LMASK1 8
#define CVE_SOBEL_REG2_5_HMASK2 21
#define CVE_SOBEL_REG2_5_LMASK2 16
#define CVE_SOBEL_REG2_5_HMASK3 29
#define CVE_SOBEL_REG2_5_LMASK3 24
#else
#define CVE_SOBEL_REG2_5_HMASK0 29
#define CVE_SOBEL_REG2_5_LMASK0 0
#endif

#define CVE_SOBEL_REG2_6 0x82
#define CVE_SOBEL_REG2_6_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_SOBEL_REG2_6_HMASK0 5
#define CVE_SOBEL_REG2_6_LMASK0 0

#define CVE_TOF_REG0 0x83
#define CVE_TOF_REG0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG0_HMASK0 9
#define CVE_TOF_REG0_LMASK0 0
#define CVE_TOF_REG0_HMASK1 25
#define CVE_TOF_REG0_LMASK1 16
#else
#define CVE_TOF_REG0_HMASK0 25
#define CVE_TOF_REG0_LMASK0 0
#endif

#define CVE_TOF_REG1 0x84
#define CVE_TOF_REG1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG1_HMASK0 9
#define CVE_TOF_REG1_LMASK0 0
#define CVE_TOF_REG1_HMASK1 25
#define CVE_TOF_REG1_LMASK1 16
#else
#define CVE_TOF_REG1_HMASK0 14
#define CVE_TOF_REG1_LMASK0 0
#endif

#define CVE_TOF_REG3_0 0x85
#define CVE_TOF_REG3_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOF_REG3_0_HMASK0 23
#define CVE_TOF_REG3_0_LMASK0 0

#define CVE_TOF_REG3_1 0x86
#define CVE_TOF_REG3_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOF_REG3_1_HMASK0 23
#define CVE_TOF_REG3_1_LMASK0 0

#define CVE_TOF_REG3_2 0x87
#define CVE_TOF_REG3_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOF_REG3_2_HMASK0 23
#define CVE_TOF_REG3_2_LMASK0 0

#define CVE_TOF_REG3_3 0x88
#define CVE_TOF_REG3_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOF_REG3_3_HMASK0 23
#define CVE_TOF_REG3_3_LMASK0 0

#define CVE_TOF_REG3_4 0x89
#define CVE_TOF_REG3_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_TOF_REG3_4_HMASK0 23
#define CVE_TOF_REG3_4_LMASK0 0

#define CVE_TOF_REG4 0x8a
#define CVE_TOF_REG4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG4_HMASK0 8
#define CVE_TOF_REG4_LMASK0 0
#define CVE_TOF_REG4_HMASK1 27
#define CVE_TOF_REG4_LMASK1 16
#else
#define CVE_TOF_REG4_HMASK0 27
#define CVE_TOF_REG4_LMASK0 0
#endif

#define CVE_TOF_REG5 0x8b
#define CVE_TOF_REG5_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG5_HMASK0 8
#define CVE_TOF_REG5_LMASK0 0
#define CVE_TOF_REG5_HMASK1 27
#define CVE_TOF_REG5_LMASK1 16
#else
#define CVE_TOF_REG5_HMASK0 27
#define CVE_TOF_REG5_LMASK0 0
#endif

#define CVE_TOF_REG9_0 0x8c
#define CVE_TOF_REG9_0_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG9_0_HMASK0 7
#define CVE_TOF_REG9_0_LMASK0 0
#define CVE_TOF_REG9_0_HMASK1 15
#define CVE_TOF_REG9_0_LMASK1 8
#define CVE_TOF_REG9_0_HMASK2 23
#define CVE_TOF_REG9_0_LMASK2 16
#else
#define CVE_TOF_REG9_0_HMASK0 23
#define CVE_TOF_REG9_0_LMASK0 0
#endif

#define CVE_TOF_REG9_1 0x8d
#define CVE_TOF_REG9_1_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG9_1_HMASK0 7
#define CVE_TOF_REG9_1_LMASK0 0
#define CVE_TOF_REG9_1_HMASK1 15
#define CVE_TOF_REG9_1_LMASK1 8
#define CVE_TOF_REG9_1_HMASK2 23
#define CVE_TOF_REG9_1_LMASK2 16
#else
#define CVE_TOF_REG9_1_HMASK0 23
#define CVE_TOF_REG9_1_LMASK0 0
#endif

#define CVE_TOF_REG9_2 0x8e
#define CVE_TOF_REG9_2_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG9_2_HMASK0 7
#define CVE_TOF_REG9_2_LMASK0 0
#define CVE_TOF_REG9_2_HMASK1 15
#define CVE_TOF_REG9_2_LMASK1 8
#define CVE_TOF_REG9_2_HMASK2 23
#define CVE_TOF_REG9_2_LMASK2 16
#else
#define CVE_TOF_REG9_2_HMASK0 23
#define CVE_TOF_REG9_2_LMASK0 0
#endif

#define CVE_TOF_REG9_3 0x8f
#define CVE_TOF_REG9_3_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG9_3_HMASK0 7
#define CVE_TOF_REG9_3_LMASK0 0
#define CVE_TOF_REG9_3_HMASK1 15
#define CVE_TOF_REG9_3_LMASK1 8
#define CVE_TOF_REG9_3_HMASK2 23
#define CVE_TOF_REG9_3_LMASK2 16
#else
#define CVE_TOF_REG9_3_HMASK0 23
#define CVE_TOF_REG9_3_LMASK0 0
#endif

#define CVE_TOF_REG9_4 0x90
#define CVE_TOF_REG9_4_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG9_4_HMASK0 7
#define CVE_TOF_REG9_4_LMASK0 0
#define CVE_TOF_REG9_4_HMASK1 15
#define CVE_TOF_REG9_4_LMASK1 8
#define CVE_TOF_REG9_4_HMASK2 23
#define CVE_TOF_REG9_4_LMASK2 16
#else
#define CVE_TOF_REG9_4_HMASK0 23
#define CVE_TOF_REG9_4_LMASK0 0
#endif

#define CVE_TOF_REG10 0x91
#define CVE_TOF_REG10_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG10_HMASK0 7
#define CVE_TOF_REG10_LMASK0 0
#define CVE_TOF_REG10_HMASK1 8
#define CVE_TOF_REG10_LMASK1 8
#define CVE_TOF_REG10_HMASK2 23
#define CVE_TOF_REG10_LMASK2 16
#define CVE_TOF_REG10_HMASK3 26
#define CVE_TOF_REG10_LMASK3 24
#else
#define CVE_TOF_REG10_HMASK0 26
#define CVE_TOF_REG10_LMASK0 0
#endif

#define CVE_TOF_REG11 0x92
#define CVE_TOF_REG11_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG11_HMASK0 7
#define CVE_TOF_REG11_LMASK0 0
#define CVE_TOF_REG11_HMASK1 23
#define CVE_TOF_REG11_LMASK1 16
#else
#define CVE_TOF_REG11_HMASK0 23
#define CVE_TOF_REG11_LMASK0 0
#endif

#define CVE_TOF_REG12 0x93
#define CVE_TOF_REG12_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG12_HMASK0 11
#define CVE_TOF_REG12_LMASK0 0
#define CVE_TOF_REG12_HMASK1 27
#define CVE_TOF_REG12_LMASK1 16
#else
#define CVE_TOF_REG12_HMASK0 27
#define CVE_TOF_REG12_LMASK0 0
#endif

#define CVE_TOF_REG13 0x94
#define CVE_TOF_REG13_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG13_HMASK0 11
#define CVE_TOF_REG13_LMASK0 0
#define CVE_TOF_REG13_HMASK1 27
#define CVE_TOF_REG13_LMASK1 16
#else
#define CVE_TOF_REG13_HMASK0 27
#define CVE_TOF_REG13_LMASK0 0
#endif

#define CVE_TOF_REG14 0x95
#define CVE_TOF_REG14_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG14_HMASK0 15
#define CVE_TOF_REG14_LMASK0 0
#define CVE_TOF_REG14_HMASK1 31
#define CVE_TOF_REG14_LMASK1 16
#else
#define CVE_TOF_REG14_HMASK0 31
#define CVE_TOF_REG14_LMASK0 0
#endif

#define CVE_TOF_REG15 0x96
#define CVE_TOF_REG15_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#ifdef CVE_REG
#define CVE_TOF_REG15_HMASK0 0
#define CVE_TOF_REG15_LMASK0 0
#define CVE_TOF_REG15_HMASK1 9
#define CVE_TOF_REG15_LMASK1 8
#define CVE_TOF_REG15_HMASK2 16
#define CVE_TOF_REG15_LMASK2 16
#define CVE_TOF_REG15_HMASK3 24
#define CVE_TOF_REG15_LMASK3 24
#else
#define CVE_TOF_REG15_HMASK0 24
#define CVE_TOF_REG15_LMASK0 0
#endif

#define CVE_SUB_THRESH_RATIO 0x99
#define CVE_SUB_THRESH_RATIO_BASE (CVE_REG_BASE + CVE_REG_OFFSET)
#define CVE_SUB_THRESH_RATIO_HMASK0 31
#define CVE_SUB_THRESH_RATIO_LMASK0 0

#define CVE_RDMIF_PACK_MODE 0xd8
#define CVE_RDMIF_PACK_MODE_BASE CVE_REG_BASE
#define CVE_RDMIF_PACK_MODE_HMASK0 2
#define CVE_RDMIF_PACK_MODE_LMASK0 0

#define CVE_RDMIF1_PACK_MODE 0xe0
#define CVE_RDMIF1_PACK_MODE_BASE CVE_REG_BASE
#define CVE_RDMIF1_PACK_MODE_HMASK0 2
#define CVE_RDMIF1_PACK_MODE_LMASK0 0

#define CVE_RDMIF2_PACK_MODE 0xe8
#define CVE_RDMIF2_PACK_MODE_BASE CVE_REG_BASE
#define CVE_RDMIF2_PACK_MODE_HMASK0 2
#define CVE_RDMIF2_PACK_MODE_LMASK0 0

#define CVE_WRMIF_PACK_MODE 0xc0
#define CVE_WRMIF_PACK_MODE_BASE CVE_REG_BASE
#define CVE_WRMIF_PACK_MODE_HMASK0 2
#define CVE_WRMIF_PACK_MODE_LMASK0 0

#define CVE_WRMIF1_PACK_MODE 0xc8
#define CVE_WRMIF1_PACK_MODE_BASE CVE_REG_BASE
#define CVE_WRMIF1_PACK_MODE_HMASK0 2
#define CVE_WRMIF1_PACK_MODE_LMASK0 0

#define CVE_WRMIF2_PACK_MODE 0xd0
#define CVE_WRMIF2_PACK_MODE_BASE CVE_REG_BASE
#define CVE_WRMIF2_PACK_MODE_HMASK0 2
#define CVE_WRMIF2_PACK_MODE_LMASK0 0

#define CVE_ADD_DSTSUM_REG (CVE_REG_BASE + CVE_REG_OFFSET + 0x97)
#define CVE_SUB_AREA_REG (CVE_REG_BASE + CVE_REG_OFFSET + 0x98)

#define LMASK_BITS 5
#define HMASK_BITS 5
#define ADDR_BITS 12
#define OP_BITS 10

#define LMASK_MASK ((1 << LMASK_BITS) - 1)
#define HMASK_MASK ((1 << HMASK_BITS) - 1)
#define ADDR_MASK ((1 << ADDR_BITS) - 1)
#define OP_MASK ((1 << OP_BITS) - 1)

#define LMASK_SHIFT 0
#define HMASK_SHIFT (LMASK_SHIFT + LMASK_BITS)
#define ADDR_SHIFT (HMASK_SHIFT + HMASK_BITS)
#define OP_SHIFT (ADDR_SHIFT + ADDR_BITS)

union CVE_TOP_CTRL_REG0_00 {
    struct {
        unsigned int cve_start : 1;
        unsigned int reserved2 : 31;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG0_02 {
    struct {
        unsigned int output_mode : 1;
        unsigned int intput_mode : 1;
        unsigned int reserved0 : 2;
        unsigned int yuv_image_type : 1;
        unsigned int reserved1 : 3;
        unsigned int dst_image_type : 5;
        unsigned int reserved2 : 3;
        unsigned int src_image_type : 5;
        unsigned int reserved3 : 3;
        unsigned int cve_op_type : 8;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_0_03 {
    struct {
        unsigned int src_addr0;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_1_04 {
    struct {
        unsigned int src_addr1;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_2_05 {
    struct {
        unsigned int src_addr2;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_3_06 {
    struct {
        unsigned int src_addr3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_4_07 {
    struct {
        unsigned int src_addr4;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_5_08 {
    struct {
        unsigned int src_addr5;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_6_09 {
    struct {
        unsigned int src_addr6;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG1_7_0a {
    struct {
        unsigned int src_addr7;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG2_0_0b {
    struct {
        unsigned int dst_addr0;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG2_1_0c {
    struct {
        unsigned int dst_addr1;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG2_2_0d {
    struct {
        unsigned int dst_addr2;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG2_3_0e {
    struct {
        unsigned int dst_addr3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG2_4_0f {
    struct {
        unsigned int dst_addr4;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG3_0_10 {
    struct {
        unsigned int src_stride_1 : 13;
        unsigned int reserved0 : 3;
        unsigned int src_stride_0 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG3_1_11 {
    struct {
        unsigned int src_stride_3 : 13;
        unsigned int reserved0 : 3;
        unsigned int src_stride_2 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG3_2_12 {
    struct {
        unsigned int src_stride_5 : 13;
        unsigned int reserved0 : 3;
        unsigned int src_stride_4 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG3_3_13 {
    struct {
        unsigned int src_stride_7 : 13;
        unsigned int reserved0 : 3;
        unsigned int src_stride_6 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG4_0_14 {
    struct {
        unsigned int dst_stride_1 : 13;
        unsigned int reserved0 : 3;
        unsigned int dst_stride_0 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG4_1_15 {
    struct {
        unsigned int dst_stride_3 : 13;
        unsigned int reserved0 : 3;
        unsigned int dst_stride_2 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG5_16 {
    struct {
        unsigned int reserved0 : 16;
        unsigned int dst_stride_4 : 13;
        unsigned int reserved1 : 3;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG6_17 {
    struct {
        unsigned int src_image_height : 14;
        unsigned int reserved0 : 2;
        unsigned int src_image_width : 14;
        unsigned int reserved1 : 2;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG7_18 {
    struct {
        unsigned int dst_image_height : 14;
        unsigned int reserved0 : 2;
        unsigned int dst_image_width : 14;
        unsigned int reserved1 : 2;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG8_19 {
    struct {
        unsigned int cve_crop_ystart : 14;
        unsigned int reserved0 : 2;
        unsigned int cve_crop_xstart : 14;
        unsigned int reserved1 : 2;
    } bits;
    unsigned int reg;
};

union CVE_COMMON_CTRL_REG9_1A {
    struct {
        unsigned int cve_crop_ysize : 14;
        unsigned int reserved0 : 2;
        unsigned int cve_crop_xsize : 14;
        unsigned int reserved1 : 2;
    } bits;
    unsigned int reg;
};

union CVE_DMA_REG0_1B {
    struct {
        unsigned int dma_interval_vsegsize : 8;
        unsigned int dma_interval_hsegsize : 8;
        unsigned int dma_interval_elemsize : 8;
        unsigned int dma_endmode : 1;
        unsigned int reserved0 : 3;
        unsigned int dma_mode_ctrl : 3;
        unsigned int reserved1 : 1;
    } bits;
    unsigned int reg;
};

union CVE_DMA_REG1_1C {
    struct {
        unsigned int dma_u64val_lsb;
    } bits;
    unsigned int reg;
};

union CVE_DMA_REG2_1D {
    struct {
        unsigned int dma_u64val_msb;
    } bits;
    unsigned int reg;
};

union CVE_DMA_REG3_1E {
    struct {
        unsigned int cve_caption_stat_wincnt : 8;
        unsigned int cve_caption_stat_winidx : 8;
        unsigned int dma_interval_xlength : 14;
        unsigned int cve_caption_stat_step : 2;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG2_1F {
    struct {
        unsigned int reserved0 : 16;
        unsigned int filter_norm_uv : 6;
        unsigned int reserved1 : 2;
        unsigned int filter_uv_en : 1;
        unsigned int reserved2 : 7;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG1_0_20 {
    struct {
        unsigned int filter_coef_uv0 : 8;
        unsigned int filter_coef_uv1 : 8;
        unsigned int filter_coef_uv2 : 8;
        unsigned int filter_coef_uv3 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG1_1_21 {
    struct {
        unsigned int filter_coef_uv4 : 8;
        unsigned int filter_coef_uv5 : 8;
        unsigned int filter_coef_uv6 : 8;
        unsigned int filter_coef_uv7 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG2_3_22 {
    struct {
        unsigned int filter_coef_uv8 : 8;
        unsigned int reserved : 24;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG0_23 {
    struct {
        unsigned int reserved0 : 8;
        unsigned int csc_yuv422toyuv420_mode : 3;
        unsigned int reserved1 : 1;
        unsigned int csc_yuv444toyuv422_mode : 3;
        unsigned int reserved2 : 1;
        unsigned int csc_yuv420toyuv422_mode : 3;
        unsigned int reserved3 : 1;
        unsigned int csc_yuv422toyuv444_mode : 3;
        unsigned int reserved4 : 1;
        unsigned int csc_gamma : 1;
        unsigned int reserved5 : 3;
        unsigned int csc_mode : 3;
        unsigned int reserved6 : 1;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG_24 {
    struct {
        unsigned int reserved0 : 16;
        unsigned int dst_u6order : 6;
        unsigned int reserved1 : 2;
        unsigned int src_u6order : 6;
        unsigned int reserved2 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG0_25 {
    struct {
        unsigned int reserved0 : 24;
        unsigned int sobel_output_mode : 2; /*unsigned,RW default:0;  0:horizontal and
                                               vertical;1:horizontal;2:output vertical*/
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_MAGANDANG_REG0_26 {
    struct {
        unsigned int magandang_u16thr : 16; /*unsigned,RW default:1024*/
        unsigned int magandang_mode : 1;    /*unsigned,RW default:0;0:8 directions;1: 9 directions*/
        unsigned int reserved0 : 7;
        unsigned int magandang_output_ctrl : 2; /*unsigned,RW default:0;0:only magnitude
                                                   output;1:magnitude and angle output;2: hog*/
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_BGMODE_REG0_27 {
    struct {
        unsigned int bgmodel_ds_mode : 2; /*unsigned,RW default:1;0:not downsampling;1:2*2;2:4*4.*/
        unsigned int reserved0 : 2;
        unsigned int bgmodel_output_ctrl : 2;
        unsigned int reserved1 : 2;
        unsigned int bgmodel_u8gray_thr : 8;
        unsigned int bgmodel_u8q4dist_thr : 12;
        unsigned int reserved2 : 4;
    } bits;
    unsigned int reg;
};

#ifdef CVE_OUTPUT_PROC
union CVE_BGMODE_REG1_28 {
    struct {
        unsigned int bgmodel_fg_pix_num_r;
    } bits;
    unsigned int reg;
};

union CVE_BGMODE_REG2_29 {
    struct {
        unsigned int bgmodel_sum_lum_r;
    } bits;
    unsigned int reg;
};
#endif

union CVE_UPDATEBGMODE_REG0_2a {
    struct {
        unsigned int updatebgmodel_u16frq_thr : 16; /*unsigned,RW default:120 threshold*/
        unsigned int updatebgmodel_u16del_thr : 16; /*unsigned,RW default:140 threshold*/
    } bits;
    unsigned int reg;
};

union CVE_UPDATEBGMODE_REG1_2b {
    struct {
        unsigned int updatebgmodel_u0q16lr : 16;         /*unsigned,RW default:2620  rate*/
        unsigned int updatebgmodel_u16interval_thr : 16; /*unsigned,RW default:40  threshold*/
    } bits;
    unsigned int reg;
};

#ifdef CVE_OUTPUT_PROC
union CVE_UPDATEBGMODE_REG2_2c {
    struct {
        unsigned int updatebgmodel_bg_pix_num_r; /*unsigned,RO default:0*/
    } bits;
    unsigned int reg;
};

union CVE_UPDATEBGMODE_REG3_2d {
    struct {
        unsigned int updatebgmodel_bg_sum_lum_r; /*unsigned,RO default:0*/
    } bits;
    unsigned int reg;
};
#endif

union CVE_ERODEDILATE_REG0_2E {
    struct {
        unsigned int erodedilate_sel : 1; /*unsigned,RW default:0; 0:Erode op;1:Dilate op */
        unsigned int reserved : 31;
    } bits;
    unsigned int reg;
};

union CVE_THRESH_REG0_2F {
    struct {
        unsigned int reserved0 : 16;
        unsigned int thresh_u8max_val : 8; /*unsigned,RW,default:0*/
        unsigned int thresh_mode : 3;      /*unsigned,RW,default:0;
                                              0:binary;1:trunc;2:TO_MINVAL,3:MIN_MID_MAX;4:ORI_MID_MAX;
                                              5:MIN_MID_ORI;6:MIN_ORI_MAX;7:ORI_MID_ORI*/
        unsigned int reserved1 : 5;
    } bits;
    unsigned int reg;
};

union CVE_THRESH_REG1_30 {
    struct {
        unsigned int thresh_u8mid_val : 8;  /*unsigned,RW,default:128*/
        unsigned int thresh_u8min_val : 8;  /*unsigned,RW,default:128*/
        unsigned int thresh_u8high_thr : 8; /*unsigned,RW,default:128*/
        unsigned int thresh_u8low_thr : 8;  /*unsigned,RW,default:128*/
    } bits;
    unsigned int reg;
};

union CVE_ALU_REG0_31 {
    struct {
        unsigned int reserved0 : 8;
        unsigned int sub_output_mode : 2; /*unsigned,RW,default:0;0:abs;1:shift*/
        unsigned int reserved1 : 6;
        unsigned int cve_alu_sel : 3; /*unsigned,RW,default:0;0:sub;1:or;2:xor;3:and;4:add*/
        unsigned int reserved2 : 13;
    } bits;
    unsigned int reg;
};

union CVE_ALU_REG1_32 {
    struct {
        unsigned int add_u0q16x : 16; /*unsigned,RW,default:65535*/
        unsigned int add_u0q16y : 16; /*unsigned,RW,default:0*/
    } bits;
    unsigned int reg;
};

union CVE_INTEG_REG0_33 {
    struct {
        unsigned int eqhist_curv_mode : 1; /*unsigned,RW,default:0;0:fw calc;1:hw calc*/
        unsigned int reserved0 : 15;
        unsigned int integ_out_ctrl : 2; /*unsigned,RW,default:0;0: combine, 1:sum; 2:sqsum*/
        unsigned int reserved1 : 14;
    } bits;
    unsigned int reg;
};

union CVE_EQHIST_REG0_34 {
    struct {
        unsigned int eqhist_norm;
    } bits;
    unsigned int reg;
};

union CVE_THRESHS16_REG0_35 {
    struct {
        unsigned int thresh_max_val : 8; /*unsigned,RW,default:255*/
        unsigned int thresh_mid_val : 8; /*unsigned,RW,default:128*/
        unsigned int thresh_min_val : 8; /*unsigned,RW,default:0*/
        unsigned int
            thresh_s16tos8oru8_mode : 2; /*unsigned,RW,default:0;
                                      0:THRESH_S16TOS8_MIN_MID_MAX;1:THRESH_S16TOS8_MIN_ORI_MAX;
                                      2:THRESH_S16TOU8_MIN_MID_MAX;3:THRESH_S16TOU8_MIN_ORI_MAX*/
        unsigned int reserved : 6;
    } bits;
    unsigned int reg;
};

union CVE_THRESHS16_REG1_36 {
    struct {
        unsigned int thresh_s16highthr : 16; /*signed,RW,default:0*/
        unsigned int thresh_s16lowthr : 16;  /*signed,RW,default:1024*/
    } bits;
    unsigned int reg;
};

union CVE_THRESHU16_REG0_37 {
    struct {
        unsigned int thresh_max_val : 8;      /*unsigned,RW,default:0*/
        unsigned int thresh_mid_val : 8;      /*unsigned,RW,default:0*/
        unsigned int thresh_min_val : 8;      /*unsigned,RW,default:0*/
        unsigned int thresh_u16tou8_mode : 1; /*unsigned,RW,default:0;0:u16 To U8 Min_Mid_Max; 1:U16
                                                 To U8 Min_Ori_Max*/
        unsigned int reserved : 7;
    } bits;
    unsigned int reg;
};

union CVE_THRESHU16_REG1_38 {
    struct {
        unsigned int thresh_u16_u16highthr : 16; /*unsigned,RW,default:0*/
        unsigned int thresh_u16_u16lowthr : 16;  /*unsigned,RW,default:0*/
    } bits;
    unsigned int reg;
};

union CVE_16BITTO8BIT_REG0_39 {
    struct {
        unsigned int reserved0 : 24;
        unsigned int _16bitto8bit_mode : 2; /*unsigned,RW,default:0; 1:S16TOU8_ABS; 2:S16TOU8_BIAS;
                                               3:U16TOU8*/
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_16BITTO8BIT_REG1_3A {
    struct {
        unsigned int _16bitto8bit_s8bias : 8; /*unsigned,RW,default:65535*/
        unsigned int reserved : 8;
        unsigned int _16bitto8bit_u0q16norm : 16; /*signed,RW,default:20*/
    } bits;
    unsigned int reg;
};

union CVE_STATFILTER_REG0_3B {
    struct {
        unsigned int stat_filter_outidx2 : 4; /*unsigned,RW,default:8;0:filter mode min, 4:filter
                                                 mode median, 8:filter mode max*/
        unsigned int reserved0 : 4;
        unsigned int stat_filter_outidx1 : 4; /*unsigned,RW,default:4;0:filter mode min, 4:filter
                                                 mode median, 8:filter mode max*/
        unsigned int reserved1 : 4;
        unsigned int stat_filter_outidx0 : 4; /*unsigned,RW,default:0;0:filter mode min, 4:filter
                                                 mode median, 8:filter mode max*/
        unsigned int reserved2 : 4;
        unsigned int stat_filter_outnum : 2; /*unsigned,RW,default:1;1:output a result 2:output two
                                                results 3:output three results*/
        unsigned int reserved3 : 6;
    } bits;
    unsigned int reg;
};

union CVE_MAP_REG0_3C {
    struct {
        unsigned int reserved0 : 24;
        unsigned int map_mode : 2; /*unsigned,RW,default:0;0:U8; 1:S16; 2:U16*/
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_NCC_REG0_3C {
    struct {
        unsigned int ncc_mode : 1; /*unsigned,RW,default:0;0:CVE_NCC_COM; 1:CVE_NCC_SIMILAR; */
        unsigned int reserved0 : 7;
        unsigned int ncc_offset1 : 8;
        unsigned int ncc_offset0 : 8;
        unsigned int reserved1 : 8;
    } bits;
    unsigned int reg;
};

#ifdef CVE_OUTPUT_PROC
union CVE_CCL_REG0_43 {
    struct {
        unsigned int ccl_sum : 9; /*unsigned,RO,default:128;max = 383*/
        unsigned int reserved : 27;
    } bits;
    unsigned int reg;
};
#endif
union CVE_GMM_REG0_44 {
    struct {
        unsigned int gmm_u0q16initweight : 16;
        unsigned int gmm_u0q16learnrate : 16;
    } bits;
    unsigned int reg;
};

union CVE_GMM_REG1_45 {
    struct {
        unsigned int gmm_u10q6sigma_init : 16;
        unsigned int reserved0 : 8;
        unsigned int gmm_ds_mode : 2;
        unsigned int reserved1 : 2;
        unsigned int gmm_output_bg_en : 1;
        unsigned int reserved2 : 3;
    } bits;
    unsigned int reg;
};

union CVE_GMM_REG2_46 {
    struct {
        unsigned int gmm_u2nchannels : 2;
        unsigned int reserved0 : 2;
        unsigned int gmm_u3modelnum : 3;
        unsigned int reserved1 : 1;
        unsigned int gmm_u10q6sigma_max : 16;
        unsigned int reserved2 : 8;
    } bits;
    unsigned int reg;
};

union CVE_GMM_REG3_47 {
    struct {
        unsigned int gmm_modellen_in128b : 12;
        unsigned int reserved0 : 4;
        unsigned int gmm_u10q6sigma_min : 16;
    } bits;
    unsigned int reg;
};

union CVE_GMM_REG4_48 {
    struct {
        unsigned int gmm_u3q7sigma_scale : 10;
        unsigned int reserved0 : 6;
        unsigned int gmm_u0q16weight_sum_thr : 16;

    } bits;
    unsigned int reg;
};

union CVE_GMM_REG5_49 {
    struct {
        unsigned int gmm_piclen_in128b : 12;
        unsigned int reserved0 : 3;
        unsigned int gmm_update_factor_mode_en : 1;
        unsigned int reserved1 : 7;
        unsigned int gmm_acc_lr_en : 1;
        unsigned int reserved2 : 7;
        unsigned int gmm_sns_factor_mode_en : 1;
    } bits;
    unsigned int reg;
};

union CVE_CANNY_REG0_4A {
    struct {
        unsigned int canny_u16highthr : 16; /*unsigned,RW,default:70*/
        unsigned int canny_u16lowthr : 16;  /*unsigned,RW,default:30*/
    } bits;
    unsigned int reg;
};

#ifdef CVE_OUTPUT_PROC
union CVE_CANNY_REG1_4B {
    struct {
        unsigned int canny_count; /*unsigned,RO,default:0*/
    } bits;
    unsigned int reg;
};
#endif

union CVE_CANNY_REG2_4C {
    struct {
        unsigned int reserved0 : 24;
        unsigned int canny_gauss_en : 1; /*unsigned,RW,default:0;0:don't need to do gaussian
                                            filter;1:need to do gaussian filter*/
        unsigned int reserved1 : 7;
    } bits;
    unsigned int reg;
};

union CVE_LBP_REG0_4D {
    struct {
        unsigned int reserved0 : 16;
        unsigned int u8bitthr : 8; /*unsigned,RW,default:128*/
        unsigned int cmp_mode : 1; /*unsigned,RW,default:0;0:P(x) - P(center) >= un8BitThr.s8Val,
                                      s(x) = 1 ;else s(x) = 0;1:Abs(P(x) - P(center)) >=
                                      un8BitThr.u8Val, s(x) = 1; else s(x) = 0*/
        unsigned int reserved1 : 7;
    } bits;
    unsigned int reg;
};

union CVE_NORMGRAD_RETG0_4E {
    struct {
        unsigned int reserved0 : 16;
        unsigned int normgrad_u8norm : 8; /*unsigned,RW,default:2*/
        unsigned int reserved1 : 4;
        unsigned int
            normgrad_outmode : 2; /*unsigned,RW,default:0;0:and ver out; 1:hor;  2: ver;3:combine*/
        unsigned int reserved2 : 2;
    } bits;
    unsigned int reg;
};

union CVE_BDLK_REG0_4F {
    struct {
        unsigned int reserved0 : 24;
        unsigned int bdlk_maxLevel : 3;
        unsigned int reserved1 : 5;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG0_50 {
    struct {
        unsigned int lk_u10pstnum : 10; /*unsigned,RW,default:100*/
        unsigned int reserved0 : 6;
        unsigned int lk_buseinitflow : 1; /*unsigned,RW,default:0*/
        unsigned int reserved1 : 7;
        unsigned int lk_mode : 2; /*unsigned,RW,default:1;0:output none ?  1:output status? 2:output
                                     status and erroutput status and err*/
        unsigned int reserved2 : 6;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG1_51 {
    struct {
        unsigned int reserved0 : 8;
        unsigned int u0q8eps : 8;
        unsigned int lk_u8itercnt : 8;
        unsigned int lk_u2maxlevel : 2;
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

#ifdef CVE_OUTPUT_PROC
union CVE_LK_REG2_0_52 {
    struct {
        unsigned int lk_ststatus_0_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_1_53 {
    struct {
        unsigned int lk_ststatus_1_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_2_54 {
    struct {
        unsigned int lk_ststatus_2_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_3_55 {
    struct {
        unsigned int lk_ststatus_3_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_4_56 {
    struct {
        unsigned int lk_ststatus_4_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_5_57 {
    struct {
        unsigned int lk_ststatus_5_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_6_58 {
    struct {
        unsigned int lk_ststatus_6_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_7_59 {
    struct {
        unsigned int lk_ststatus_7_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_8_5A {
    struct {
        unsigned int lk_ststatus_8_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_9_5B {
    struct {
        unsigned int lk_ststatus_9_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_10_5C {
    struct {
        unsigned int lk_ststatus_10_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_11_5D {
    struct {
        unsigned int lk_ststatus_11_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_12_5E {
    struct {
        unsigned int lk_ststatus_12_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_13_5F {
    struct {
        unsigned int lk_ststatus_13_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_14_60 {
    struct {
        unsigned int lk_ststatus_14_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_15_61 {
    struct {
        unsigned int lk_ststatus_15_r;
    } bits;
    unsigned int reg;
};

union CVE_LK_REG2_16_62 {
    struct {
        unsigned int lk_ststatus_16_r;
    } bits;
    unsigned int reg;
};

union CVE_STCORNER_REG0_63 {
    struct {
        unsigned int st_u32pointnum_r;
    } bits;
    unsigned int reg;
};
#endif

union CVE_SAD_REG0_64 {
    struct {
        unsigned int sad_u8minval : 8; /*unsigned,RW,default:128*/
        unsigned int sad_mode : 2;     /*unsigned,RW,default:0;0:4x4;1:8x8;2:16x16*/
        unsigned int reserved : 22;
    } bits;
    unsigned int reg;
};

union CVE_SAD_REG1_65 {
    struct {
        unsigned int sad_u4rightshift : 4; /*unsigned,RW,default:2*/
        unsigned int reserved : 4;
        unsigned int sad_u8maxval : 8; /*unsigned,RW,default:128*/
        unsigned int sad_u16thr : 16;  /*unsigned,RW,default:128*/
    } bits;
    unsigned int reg;
};

union CVE_GRADFG_RETG0_66 {
    struct {
        unsigned int gradfg_u8minmagdiff : 8;
        unsigned int reserved0 : 16;
        unsigned int gradfg_mode : 2;
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_0_67 {
    struct {
        unsigned int filter_coef0 : 8;
        unsigned int filter_coef1 : 8;
        unsigned int filter_coef2 : 8;
        unsigned int filter_coef3 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_1_68 {
    struct {
        unsigned int filter_coef4 : 8;
        unsigned int filter_coef5 : 8;
        unsigned int filter_coef6 : 8;
        unsigned int filter_coef7 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_2_69 {
    struct {
        unsigned int filter_coef8 : 8;
        unsigned int filter_coef9 : 8;
        unsigned int filter_coef10 : 8;
        unsigned int filter_coef11 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_3_6A {
    struct {
        unsigned int filter_coef12 : 8;
        unsigned int filter_coef13 : 8;
        unsigned int filter_coef14 : 8;
        unsigned int filter_coef15 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_4_6B {
    struct {
        unsigned int filter_coef16 : 8;
        unsigned int filter_coef17 : 8;
        unsigned int filter_coef18 : 8;
        unsigned int filter_coef19 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_5_6C {
    struct {
        unsigned int filter_coef20 : 8;
        unsigned int filter_coef21 : 8;
        unsigned int filter_coef22 : 8;
        unsigned int filter_coef23 : 8;
    } bits;
    unsigned int reg;
};

union CVE_FILTER_REG0_6_6D {
    struct {
        unsigned int filter_norm : 6;
        unsigned int reserved : 18;
        unsigned int filter_coef24 : 8;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG1_6E {
    struct {
        unsigned int csc_offset_inp_0 : 10;
        unsigned int csc_offset_inp_1 : 10;
        unsigned int reserved : 12;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG1_1_6F {
    struct {
        unsigned int csc_offset_inp_2 : 10;
        unsigned int reserved : 22;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG2_0_70 {
    struct {
        unsigned int csc_3x3matrix_2_0 : 10;
        unsigned int reserved0 : 1;
        unsigned int csc_3x3matrix_1_0 : 10;
        unsigned int reserved1 : 1;
        unsigned int csc_3x3matrix_0_0 : 10;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG2_1_71 {
    struct {
        unsigned int csc_3x3matrix_2_1 : 10;
        unsigned int reserved0 : 1;
        unsigned int csc_3x3matrix_1_1 : 10;
        unsigned int reserved1 : 1;
        unsigned int csc_3x3matrix_0_1 : 10;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG2_2_72 {
    struct {
        unsigned int csc_3x3matrix_2_2 : 10;
        unsigned int reserved0 : 1;
        unsigned int csc_3x3matrix_1_2 : 10;
        unsigned int reserved1 : 1;
        unsigned int csc_3x3matrix_0_2 : 10;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG3_73 {
    struct {
        unsigned int csc_offset_oup_0 : 10;
        unsigned int csc_offset_oup_1 : 10;
        unsigned int reserved : 12;
    } bits;
    unsigned int reg;
};

union CVE_CSC_REG3_1_74 {
    struct {
        unsigned int csc_3x3matrix_rs : 3;
        unsigned int reserved0 : 13;
        unsigned int csc_offset_oup_2 : 10;
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_0_75 {
    struct {
        unsigned int sobel_coef_h_0 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_1 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_2 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_3 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_1_76 {
    struct {
        unsigned int sobel_coef_h_4 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_5 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_6 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_7 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_2_77 {
    struct {
        unsigned int sobel_coef_h_8 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_9 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_10 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_11 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_3_78 {
    struct {
        unsigned int sobel_coef_h_12 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_13 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_14 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_15 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_4_79 {
    struct {
        unsigned int sobel_coef_h_16 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_17 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_18 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_19 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_5_7A {
    struct {
        unsigned int sobel_coef_h_20 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_h_21 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_h_22 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_h_23 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG1_6_7B {
    struct {
        unsigned int sobel_coef_h_24 : 6;
        unsigned int reserved : 26;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_0_7C {
    struct {
        unsigned int sobel_coef_v_0 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_1 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_2 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_3 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_1_7D {
    struct {
        unsigned int sobel_coef_v_4 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_5 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_6 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_7 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_2_7E {
    struct {
        unsigned int sobel_coef_v_8 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_9 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_10 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_11 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_3_7F {
    struct {
        unsigned int sobel_coef_v_12 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_13 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_14 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_15 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_4_80 {
    struct {
        unsigned int sobel_coef_v_16 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_17 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_18 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_19 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_5_81 {
    struct {
        unsigned int sobel_coef_v_20 : 6;
        unsigned int reserved0 : 2;
        unsigned int sobel_coef_v_21 : 6;
        unsigned int reserved1 : 2;
        unsigned int sobel_coef_v_22 : 6;
        unsigned int reserved2 : 2;
        unsigned int sobel_coef_v_23 : 6;
        unsigned int reserved3 : 2;
    } bits;
    unsigned int reg;
};

union CVE_SOBEL_REG2_6_82 {
    struct {
        unsigned int sobel_coef_v_24 : 6;
        unsigned int reserved0 : 26;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG0_83 {
    struct {
        unsigned int cve_tof_hist_y_start : 10;
        unsigned int reserved0 : 6;
        unsigned int cve_tof_hist_x_start : 10;
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG1_84 {
    struct {
        unsigned int cve_tof_hist_y_end : 10;
        unsigned int reserved0 : 6;
        unsigned int cve_tof_hist_x_end : 10;
        unsigned int reserved1 : 6;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG3_0_85 {
    struct {
        unsigned int cve_tof_p_coef_0 : 24;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG3_1_86 {
    struct {
        unsigned int cve_tof_p_coef_1 : 24;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG3_2_87 {
    struct {
        unsigned int cve_tof_p_coef_2 : 24;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG3_3_88 {
    struct {
        unsigned int cve_tof_p_coef_3 : 24;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG3_4_89 {
    struct {
        unsigned int cve_tof_p_coef_4 : 24;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG4_8a {
    struct {
        unsigned int cve_tof_t_coef1_1 : 9;
        unsigned int reserved0 : 7;
        unsigned int cve_tof_t_coef1_0 : 12;
        unsigned int reserved1 : 4;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG5_8b {
    struct {
        unsigned int cve_tof_t_coef1_3 : 9;
        unsigned int reserved0 : 7;
        unsigned int cve_tof_t_coef1_2 : 12;
        unsigned int reserved1 : 4;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG9_0_8c {
    struct {
        unsigned int cve_tof_spa_mask_2 : 8;
        unsigned int cve_tof_spa_mask_1 : 8;
        unsigned int cve_tof_spa_mask_0 : 8;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG9_1_8d {
    struct {
        unsigned int cve_tof_spa_mask_5 : 8;
        unsigned int cve_tof_spa_mask_4 : 8;
        unsigned int cve_tof_spa_mask_3 : 8;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG9_2_8e {
    struct {
        unsigned int cve_tof_spa_mask_8 : 8;
        unsigned int cve_tof_spa_mask_7 : 8;
        unsigned int cve_tof_spa_mask_6 : 8;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG9_3_8f {
    struct {
        unsigned int cve_tof_spa_mask_11 : 8;
        unsigned int cve_tof_spa_mask_10 : 8;
        unsigned int cve_tof_spa_mask_9 : 8;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG9_4_90 {
    struct {
        unsigned int cve_tof_spa_mask_14 : 8;
        unsigned int cve_tof_spa_mask_13 : 8;
        unsigned int cve_tof_spa_mask_12 : 8;
        unsigned int reserved : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG10_91 {
    struct {
        unsigned int cve_tof_bp_num : 8;
        unsigned int cve_tof_raw_shift_12bit_en : 1;
        unsigned int reserved0 : 7;
        unsigned int cve_tof_spa_norm : 8;
        unsigned int cve_tof_raw_mode : 3;
        unsigned int reserved1 : 5;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG11_92 {
    struct {
        unsigned int cve_tof_temperature_ext : 8;
        unsigned int reserved0 : 8;
        unsigned int cve_tof_temperature_int : 8;
        unsigned int reserved1 : 8;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG12_93 {
    struct {
        unsigned int cve_tof_q23_high_thr : 12;
        unsigned int reserved0 : 4;
        unsigned int cve_tof_q1_high_thr : 12;
        unsigned int reserved1 : 4;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG13_94 {
    struct {
        unsigned int cve_tof_ir_low_thr : 12;
        unsigned int reserved0 : 4;
        unsigned int cve_tof_ir_high_thr : 12;
        unsigned int reserved1 : 4;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG14_95 {
    struct {
        unsigned int cve_tof_dis_min : 16;
        unsigned int cve_tof_dis_max : 16;
    } bits;
    unsigned int reg;
};

union CVE_TOF_REG15_96 {
    struct {
        unsigned int cve_tof_bypass_en : 1;
        unsigned int reserved0 : 7;
        unsigned int cve_tof_fpn_cali_mode : 2;
        unsigned int reserved1 : 6;
        unsigned int cve_tof_spa2_en : 1;
        unsigned int reserved2 : 7;
        unsigned int cve_tof_spa1_en : 1;
        unsigned int reserved3 : 6;
    } bits;
    unsigned int reg;
};

union CVE_SUB_THRESH_RATIO_99 {
    struct {
        unsigned int reserved0 : 16;
        unsigned int sub_thresh_ratio : 16; /*unsigned,RW, default:13107  norm 65536 to 1.0*/
    } bits;
    unsigned int reg;
};

union CVE_RDMIF_PACK_MODE_REG_D8 {
    struct {
        unsigned int rdmif_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

union CVE_RDMIF1_PACK_MODE_REG_E0 {
    struct {
        unsigned int rdmif1_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

union CVE_RDMIF2_PACK_MODE_REG_E8 {
    struct {
        unsigned int rdmif2_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

union CVE_WRMIF_PACK_MODE_REG_C0 {
    struct {
        unsigned int wdmif_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

union CVE_WRMIF1_PACK_MODE_REG_C8 {
    struct {
        unsigned int wdmif1_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

union CVE_WRMIF2_PACK_MODE_REG_D0 {
    struct {
        unsigned int wdmif2_pack_mode : 3;
        unsigned int reserved : 29;
    } bits;
    unsigned int reg;
};

#endif /* __AML_CVE_H__ */
