/*
 * Copyright (C) 2019-2024 Amlogic, Inc. All rights reserved.
 *
 */

#ifndef __MBD_CVE_OP_H__
#define __MBD_CVE_OP_H__

#include "cve.h"

#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif /* __cplusplus */

AML_U32 cve_check_dma_param(CVE_DATA_T *pstSrcDATA, CVE_DST_DATA_T *pstDstDATA,
                            CVE_DMA_CTRL_T *pstDmaCtrl);
AML_S32 cve_check_luamStat_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_MEM_INFO_T *pstDstMem,
                                 CVE_RECT_U16_T *astCveLumaRect,
                                 CVE_LUMA_STAT_ARRAY_CTRL_T *pstLumaStatArrayCtrl);
AML_S32 cve_check_filter_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                               CVE_FILTER_CTRL_T *pstFilterCtrl);
AML_S32 cve_check_csc_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                            CVE_CSC_CTRL_T *pstCscCtrl);
AML_S32 cve_check_filter_csc_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                   CVE_FILTER_AND_CSC_CTRL_T *pstFilterCscCtrl);
AML_S32 cve_check_sobel_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstH,
                              CVE_DST_IMAGE_T *pstDstV, CVE_SOBEL_CTRL_T *pstSobelCtrl);
AML_S32 cve_check_mag_and_ang_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstMag,
                                    CVE_DST_IMAGE_T *pstDstAng,
                                    CVE_MAG_AND_ANG_CTRL_T *pstMagAndAngCtrl);
AML_S32 cve_check_match_bg_model_param(CVE_SRC_IMAGE_T *pstCurImg, CVE_SRC_IMAGE_T *pstPreImg,
                                       CVE_MEM_INFO_T *pstBgModel, CVE_DST_IMAGE_T *pstFg,
                                       CVE_DST_IMAGE_T *pstBg, CVE_DST_IMAGE_T *pstCurDiffBg,
                                       CVE_DST_IMAGE_T *pstFrmDiff, CVE_DST_MEM_INFO_T *pstStatData,
                                       CVE_MATCH_BG_MODEL_CTRL_T *pstMatchBgModelCtrl);
AML_S32 cve_check_dilate_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                               CVE_DILATE_CTRL_T *pstDilateCtrl);
AML_S32 cve_check_erode_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                              CVE_ERODE_CTRL_T *pstErodeCtrl);
AML_S32 cve_check_thresh(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                         CVE_THRESH_CTRL_T *pstThreshCtrl);
AML_S32 cve_check_sub_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_IMAGE_T *pstDst, CVE_SUB_CTRL_T *pstSubCtrl,
                            CVE_DST_MEM_INFO_T *pstDstmem);
AML_S32 cve_check_or_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                           CVE_DST_IMAGE_T *pstDst, CVE_OR_CTRL_T *pstOrCtrl);
AML_S32 cve_check_and_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_IMAGE_T *pstDst, CVE_AND_CTRL_T *pstAndCtrl);
AML_S32 cve_check_xor_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_IMAGE_T *pstDst, CVE_XOR_CTRL_T *pstXorCtrl);
AML_S32 cve_check_add_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_IMAGE_T *pstDst, CVE_ADD_CTRL_T *pstAddCtrl,
                            CVE_DST_MEM_INFO_T *pstDstmem);
AML_S32 cve_check_integ_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                              CVE_INTEG_CTRL_T *pstIntegCtrl);
AML_S32 cve_check_hist_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_MEM_INFO_T *pstDstMem,
                             CVE_HIST_CTRL_T *pstHistCtrl);
AML_S32 cve_check_thresh_s16_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                   CVE_THRESH_S16_CTRL_T *pstThreshS16Ctrl);
AML_S32 cve_check_thresh_u16_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                   CVE_THRESH_U16_CTRL_T *pstThreshU16Ctrl);
AML_S32 cve_check_16bit_to_8bit_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                      CVE_16BIT_TO_8BIT_CTRL_T *pst16BitTo8BitCtrl);
AML_S32 cve_check_ord_stat_filter_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                        CVE_ORD_STAT_FILTER_CTRL_T *pstOrdStatFltCtrl);
AML_S32 cve_check_map_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_SRC_MEM_INFO_T *pstMap,
                            CVE_DST_IMAGE_T *pstDstImage, CVE_MAP_CTRL_T *pstMapCtrl);
AML_S32 cve_check_equalize_hist_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                      CVE_EQUALIZE_HIST_CTRL_T *pstEqualizeHistCtrl);
AML_S32 cve_check_ncc_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_MEM_INFO_T *pstDstmem, CVE_NCC_CTRL_T *pstNccCtrl);
AML_S32 cve_check_ccl_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                            CVE_DST_MEM_INFO_T *pstBlob, CVE_CCL_CTRL_T *pstCclCtrl);
AML_S32 cve_check_gmm_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_SRC_IMAGE_T *pstFactor,
                            CVE_DST_IMAGE_T *pstFg, CVE_DST_IMAGE_T *pstBg,
                            CVE_MEM_INFO_T *pstModel, CVE_GMM_CTRL_T *pstGmmCtrl);
AML_S32 cve_check_canny_hys_edge_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstEdge,
                                       CVE_DST_MEM_INFO_T *pstStack,
                                       CVE_CANNY_HYS_EDGE_CTRL_T *pstCannyHysEdgeCtrl);
AML_S32 cve_check_lbp_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                            CVE_LBP_CTRL_T *pstLbpCtrl);
AML_S32 cve_check_norm_grad_param(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstH,
                                  CVE_DST_IMAGE_T *pstDstV, CVE_DST_IMAGE_T *pstDstHV,
                                  CVE_NORM_GRAD_CTRL_T *pstNormGradCtrl);
AML_S32 cve_check_build_lk_optical_flow_pyr_param(
    CVE_SRC_IMAGE_T *pstSrcPyr, CVE_SRC_IMAGE_T astDstPyr[],
    CVE_BUILD_LK_OPTICAL_FLOW_PYR_CTRL_T *pstBuildLkOptiFlowPyrCtrl);
AML_S32 cve_check_lk_optical_flow_pyr_param(CVE_SRC_IMAGE_T astSrcPrevPyr[],
                                            CVE_SRC_IMAGE_T astSrcNextPyr[],
                                            CVE_SRC_MEM_INFO_T *pstPrevPts,
                                            CVE_MEM_INFO_T *pstNextPts,
                                            CVE_DST_MEM_INFO_T *pstStatus,
                                            CVE_LK_OPTICAL_FLOW_PYR_CTRL_T *pstLkOptiFlowPyrCtrl);
AML_S32 cve_check_st_candi_corner_param(CVE_SRC_IMAGE_T *pstSrc, CVE_DST_IMAGE_T *pstLabel,
                                        CVE_DST_IMAGE_T *pstCandiCorner,
                                        CVE_DST_MEM_INFO_T *pstCandiCornerPoint,
                                        CVE_ST_CANDI_CORNER_CTRL_T *pstStCandiCornerCtrl);
AML_S32 cve_check_sad_param(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                            CVE_DST_IMAGE_T *pstSad, CVE_DST_IMAGE_T *pstThr,
                            CVE_SAD_CTRL_T *pstSadCtrl);
AML_S32 cve_check_grad_fg_param(CVE_SRC_IMAGE_T *pstBgDiffFg, CVE_SRC_IMAGE_T *pstCurGrad,
                                CVE_SRC_IMAGE_T *pstBgGrad, CVE_DST_IMAGE_T *pstGradFg,
                                CVE_GRAD_FG_CTRL_T *pstGradFgCtrl);
AML_S32 cve_check_update_bg_model_param(CVE_SRC_IMAGE_T *pstCurImg, CVE_MEM_INFO_T *pstBgModel1,
                                        CVE_MEM_INFO_T *pstBgModel2,
                                        CVE_DST_MEM_INFO_T *pstStatData,
                                        CVE_UPDATE_BG_MODEL_CTRL_T *pstUpdateBgModelCtrl);
AML_S32 cve_check_tof_param(CVE_SRC_RAW_T *pstSrcRaw, CVE_SRC_RAW_T *pstSrcFpn,
                            CVE_SRC_MEM_INFO_T *pstSrcCoef, CVE_SRC_MEM_INFO_T *pstBpc,
                            CVE_DST_MEM_INFO_T *pstDtsStatus, CVE_DST_MEM_INFO_T *pstDtsIR,
                            CVE_DST_MEM_INFO_T *pstDtsData, CVE_DST_MEM_INFO_T *pstDstHist,
                            CVE_TOF_CTRL_T *pstTofCtrl);
int cve_fill_dma_task(CVE_DATA_T *pstSrcDATA, CVE_DST_DATA_T *pstDstDATA,
                      CVE_DMA_CTRL_T *pstDmaCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_luma_stat_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_MEM_INFO_T *pstDstMem,
                            CVE_RECT_U16_T *pstCveLumaRect,
                            CVE_LUMA_STAT_ARRAY_CTRL_T *pstLumaStatArrayCtrl,
                            unsigned char idx_windows, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_filter_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                         CVE_FILTER_CTRL_T *pstFilterCtrl, char *cmd_buf,
                         unsigned int *cmd_line_num);
int cve_fill_csc_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                      CVE_CSC_CTRL_T *pstCscCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_filter_and_csc_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                 CVE_FILTER_AND_CSC_CTRL_T *pstFilterCscCtrl, char *cmd_buf,
                                 unsigned int *cmd_line_num);
int cve_fill_sobel_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstH,
                        CVE_DST_IMAGE_T *pstDstV, CVE_SOBEL_CTRL_T *pstSobelCtrl, char *cmd_buf,
                        unsigned int *cmd_line_num);
int cve_fill_mag_and_ang_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstMag,
                              CVE_DST_IMAGE_T *pstDstAng, CVE_MAG_AND_ANG_CTRL_T *pstMagAndAngCtrl,
                              char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_match_bg_model_task(CVE_SRC_IMAGE_T *pstCurImg, CVE_SRC_IMAGE_T *pstPreImg,
                                 CVE_MEM_INFO_T *pstBgModel, CVE_DST_IMAGE_T *pstFg,
                                 CVE_DST_IMAGE_T *pstBg, CVE_DST_IMAGE_T *pstCurDiffBg,
                                 CVE_DST_IMAGE_T *pstFrmDiff,
                                 CVE_MATCH_BG_MODEL_CTRL_T *pstMatchBgModelCtrl, char *cmd_buf,
                                 unsigned int *cmd_line_num);
int cve_fill_dilate_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                         CVE_DILATE_CTRL_T *pstDilateCtrl, char *cmd_buf,
                         unsigned int *cmd_line_num);
int cve_fill_erode_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                        CVE_ERODE_CTRL_T *pstErodeCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_thresh_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                         CVE_THRESH_CTRL_T *pstThreshCtrl, char *cmd_buf,
                         unsigned int *cmd_line_num);
int cve_fill_alu1_task(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                       CVE_DST_IMAGE_T *pstDst, cve_alu_sel_e alu_sel, CVE_SUB_CTRL_T *pstSubCtrl,
                       CVE_ADD_CTRL_T *pstAddCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_alu2_task(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                       CVE_DST_IMAGE_T *pstDst, cve_alu_sel_e alu_sel, CVE_AND_CTRL_T *pstAndCtrl,
                       CVE_OR_CTRL_T *pstOrCtrl, CVE_XOR_CTRL_T *pstXorCtrl, char *cmd_buf,
                       unsigned int *cmd_line_num);
int cve_fill_integ_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                        CVE_INTEG_CTRL_T *pstIntegCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_hist_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_MEM_INFO_T *pstDstMem,
                       CVE_HIST_CTRL_T *pstHistCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_thresh_s16_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                             CVE_THRESH_S16_CTRL_T *pstThreshS16Ctrl, char *cmd_buf,
                             unsigned int *cmd_line_num);
int cve_fill_thresh_u16_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                             CVE_THRESH_U16_CTRL_T *pstThreshU16Ctrl, char *cmd_buf,
                             unsigned int *cmd_line_num);
unsigned int cve_fill_16bit_to_8bit_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                         CVE_16BIT_TO_8BIT_CTRL_T *pst16BitTo8BitCtrl,
                                         char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_ord_stat_filter_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                  CVE_ORD_STAT_FILTER_CTRL_T *pstOrdStatFltCtrl, char *cmd_buf,
                                  unsigned int *cmd_line_num);
int cve_fill_map_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_SRC_MEM_INFO_T *pstMap,
                      CVE_DST_IMAGE_T *pstDstImage, CVE_MAP_CTRL_T *pstMapCtrl, char *cmd_buf,
                      unsigned int *cmd_line_num);
int cve_fill_equalize_hist_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                                CVE_EQUALIZE_HIST_CTRL_T *pstEqualizeHistCtrl, char *cmd_buf,
                                unsigned int *cmd_line_num);
int cve_fill_ncc_task(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                      CVE_NCC_CTRL_T *pstNccCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_ccl_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                      CVE_DST_MEM_INFO_T *pstBlob, CVE_CCL_CTRL_T *pstCclCtrl, char *cmd_buf,
                      unsigned int *cmd_line_num);
int cve_fill_gmm_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_SRC_IMAGE_T *pstFactor,
                      CVE_DST_IMAGE_T *pstFg, CVE_DST_IMAGE_T *pstBg, CVE_MEM_INFO_T *pstModel,
                      CVE_GMM_CTRL_T *pstGmmCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_canny_hys_edge_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstEdge,
                                 CVE_DST_MEM_INFO_T *pstStack,
                                 CVE_CANNY_HYS_EDGE_CTRL_T *pstCannyHysEdgeCtrl, char *cmd_buf,
                                 unsigned int *cmd_line_num);
int cve_fill_lbp_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstImage,
                      CVE_LBP_CTRL_T *pstLbpCtrl, char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_norm_grad_task(CVE_SRC_IMAGE_T *pstSrcImage, CVE_DST_IMAGE_T *pstDstH,
                            CVE_DST_IMAGE_T *pstDstV, CVE_DST_IMAGE_T *pstDstHV,
                            CVE_NORM_GRAD_CTRL_T *pstNormGradCtrl, char *cmd_buf,
                            unsigned int *cmd_line_num);
int cve_fill_build_lk_optical_flow_pyr_task(
    CVE_SRC_IMAGE_T *pstSrcPyr, CVE_SRC_IMAGE_T astDstPyr[],
    CVE_BUILD_LK_OPTICAL_FLOW_PYR_CTRL_T *pstBuildLkOptiFlowPyrCtrl, char *cmd_buf,
    unsigned int *cmd_line_num);
int cve_fill_lk_optical_flow_pyr_task(CVE_SRC_IMAGE_T astSrcPrevPyr[],
                                      CVE_SRC_IMAGE_T astSrcNextPyr[],
                                      CVE_SRC_MEM_INFO_T *pstPrevPts, CVE_MEM_INFO_T *pstNextPts,
                                      CVE_LK_OPTICAL_FLOW_PYR_CTRL_T *pstLkOptiFlowPyrCtrl,
                                      char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_st_candi_corner_task(CVE_SRC_IMAGE_T *pstSrc, CVE_DST_IMAGE_T *pstLabel,
                                  CVE_DST_IMAGE_T *pstCandiCorner,
                                  CVE_DST_MEM_INFO_T *pstCandiCornerPoint,
                                  CVE_ST_CANDI_CORNER_CTRL_T *pstStCandiCornerCtrl, char *cmd_buf,
                                  unsigned int *cmd_line_num);
int cve_fill_sad_task(CVE_SRC_IMAGE_T *pstSrcImage1, CVE_SRC_IMAGE_T *pstSrcImage2,
                      CVE_DST_IMAGE_T *pstSad, CVE_DST_IMAGE_T *pstThr, CVE_SAD_CTRL_T *pstSadCtrl,
                      char *cmd_buf, unsigned int *cmd_line_num);
int cve_fill_grad_fg_task(CVE_SRC_IMAGE_T *pstBgDiffFg, CVE_SRC_IMAGE_T *pstCurGrad,
                          CVE_SRC_IMAGE_T *pstBgGrad, CVE_DST_IMAGE_T *pstGradFg,
                          CVE_GRAD_FG_CTRL_T *pstGradFgCtrl, char *cmd_buf,
                          unsigned int *cmd_line_num);
int cve_fill_update_bg_model_task(CVE_SRC_IMAGE_T *pstCurImg, CVE_MEM_INFO_T *pstBgModel1,
                                  CVE_MEM_INFO_T *pstBgModel2,
                                  CVE_UPDATE_BG_MODEL_CTRL_T *pstUpdateBgModelCtrl, char *cmd_buf,
                                  unsigned int *cmd_line_num);
int cve_fill_tof_task(CVE_SRC_RAW_T *pstSrcRaw, CVE_SRC_RAW_T *pstSrcFpn,
                      CVE_SRC_MEM_INFO_T *pstSrcCoef, CVE_DST_MEM_INFO_T *pstDstStatus,
                      CVE_DST_MEM_INFO_T *pstDstIR, CVE_DST_MEM_INFO_T *pstDstData,
                      CVE_TOF_CTRL_T *pstTofCtrl, char *cmd_buf, unsigned int *cmd_line_num);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif /* __MBD_CVE_OP_H__ */
