#ifndef __TVIN_TYPE_H
#define __TVIN_TYPE_H

enum tvin_trans_fmt {
	TVIN_TFMT_2D = 0,
	TVIN_TFMT_3D_LRH_OLOR,
	/* 1 Primary: Side-by-Side(Half) Odd/Left picture, Odd/Right p */

	TVIN_TFMT_3D_LRH_OLER,
	/* 2 Primary: Side-by-Side(Half) Odd/Left picture, Even/Right picture */

	TVIN_TFMT_3D_LRH_ELOR,
	/* 3 Primary: Side-by-Side(Half) Even/Left picture, Odd/Right picture */

	TVIN_TFMT_3D_LRH_ELER,
	/* 4 Primary: Side-by-Side(Half) Even/Left picture, Even/Right picture*/

	TVIN_TFMT_3D_TB,	/* 5 Primary: Top-and-Bottom */
	TVIN_TFMT_3D_FP,	/* 6 Primary: Frame Packing */
	TVIN_TFMT_3D_FA,	/* 7 Secondary: Field Alternative */
	TVIN_TFMT_3D_LA,	/* 8 Secondary: Line Alternative */
	TVIN_TFMT_3D_LRF,	/* 9 Secondary: Side-by-Side(Full) */
	TVIN_TFMT_3D_LD,	/* 10 Secondary: L+depth */
	TVIN_TFMT_3D_LDGD, /* 11 Secondary: L+depth+Graphics+Graphics-depth */
	/* normal 3D format */
	TVIN_TFMT_3D_DET_TB,	/* 12 */
	TVIN_TFMT_3D_DET_LR,	/* 13 */
	TVIN_TFMT_3D_DET_INTERLACE,	/* 14 */
	TVIN_TFMT_3D_DET_CHESSBOARD,	/* 15 */
};

/* tvin signal format table */
enum tvin_sig_fmt_e {
	TVIN_SIG_FMT_NULL = 0,
	/* HDMI Formats */
	TVIN_SIG_FMT_HDMI_640X480P_60HZ = 0x401,
	TVIN_SIG_FMT_HDMI_720X480P_60HZ = 0x402,
	TVIN_SIG_FMT_HDMI_1280X720P_60HZ = 0x403,
	TVIN_SIG_FMT_HDMI_1920X1080I_60HZ = 0x404,
	TVIN_SIG_FMT_HDMI_1440X480I_60HZ = 0x405,
	TVIN_SIG_FMT_HDMI_1440X240P_60HZ = 0x406,
	TVIN_SIG_FMT_HDMI_2880X480I_60HZ = 0x407,
	TVIN_SIG_FMT_HDMI_2880X240P_60HZ = 0x408,
	TVIN_SIG_FMT_HDMI_1440X480P_60HZ = 0x409,
	TVIN_SIG_FMT_HDMI_1920X1080P_60HZ = 0x40a,
	TVIN_SIG_FMT_HDMI_720X576P_50HZ = 0x40b,
	TVIN_SIG_FMT_HDMI_1280X720P_50HZ = 0x40c,
	TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_A = 0x40d,
	TVIN_SIG_FMT_HDMI_1440X576I_50HZ = 0x40e,
	TVIN_SIG_FMT_HDMI_1440X288P_50HZ = 0x40f,
	TVIN_SIG_FMT_HDMI_2880X576I_50HZ = 0x410,
	TVIN_SIG_FMT_HDMI_2880X288P_50HZ = 0x411,
	TVIN_SIG_FMT_HDMI_1440X576P_50HZ = 0x412,
	TVIN_SIG_FMT_HDMI_1920X1080P_50HZ = 0x413,
	TVIN_SIG_FMT_HDMI_1920X1080P_24HZ = 0x414,
	TVIN_SIG_FMT_HDMI_1920X1080P_25HZ = 0x415,
	TVIN_SIG_FMT_HDMI_1920X1080P_30HZ = 0x416,
	TVIN_SIG_FMT_HDMI_2880X480P_60HZ = 0x417,
	TVIN_SIG_FMT_HDMI_2880X576P_50HZ = 0x418,
	TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_B = 0x419,
	TVIN_SIG_FMT_HDMI_1920X1080I_100HZ = 0x41a,
	TVIN_SIG_FMT_HDMI_1280X720P_100HZ = 0x41b,
	TVIN_SIG_FMT_HDMI_720X576P_100HZ = 0x41c,
	TVIN_SIG_FMT_HDMI_1440X576I_100HZ = 0x41d,
	TVIN_SIG_FMT_HDMI_1920X1080I_120HZ = 0x41e,
	TVIN_SIG_FMT_HDMI_1280X720P_120HZ = 0x41f,
	TVIN_SIG_FMT_HDMI_720X480P_120HZ = 0x420,
	TVIN_SIG_FMT_HDMI_1440X480I_120HZ = 0x421,
	TVIN_SIG_FMT_HDMI_720X576P_200HZ = 0x422,
	TVIN_SIG_FMT_HDMI_1440X576I_200HZ = 0x423,
	TVIN_SIG_FMT_HDMI_720X480P_240HZ = 0x424,
	TVIN_SIG_FMT_HDMI_1440X480I_240HZ = 0x425,
	TVIN_SIG_FMT_HDMI_1280X720P_24HZ = 0x426,
	TVIN_SIG_FMT_HDMI_1280X720P_25HZ = 0x427,
	TVIN_SIG_FMT_HDMI_1280X720P_30HZ = 0x428,
	TVIN_SIG_FMT_HDMI_1920X1080P_120HZ = 0x429,
	TVIN_SIG_FMT_HDMI_1920X1080P_100HZ = 0x42a,
	TVIN_SIG_FMT_HDMI_1280X720P_60HZ_FRAME_PACKING = 0x42b,
	TVIN_SIG_FMT_HDMI_1280X720P_50HZ_FRAME_PACKING = 0x42c,
	TVIN_SIG_FMT_HDMI_1280X720P_24HZ_FRAME_PACKING = 0x42d,
	TVIN_SIG_FMT_HDMI_1280X720P_30HZ_FRAME_PACKING = 0x42e,
	TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_FRAME_PACKING = 0x42f,
	TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_FRAME_PACKING = 0x430,
	TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_FRAME_PACKING = 0x431,
	TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_FRAME_PACKING = 0x432,
	TVIN_SIG_FMT_HDMI_800X600_00HZ = 0x433,
	TVIN_SIG_FMT_HDMI_1024X768_00HZ = 0x434,
	TVIN_SIG_FMT_HDMI_720X400_00HZ = 0x435,
	TVIN_SIG_FMT_HDMI_1280X768_00HZ = 0x436,
	TVIN_SIG_FMT_HDMI_1280X800_00HZ = 0x437,
	TVIN_SIG_FMT_HDMI_1280X960_00HZ = 0x438,
	TVIN_SIG_FMT_HDMI_1280X1024_00HZ = 0x439,
	TVIN_SIG_FMT_HDMI_1360X768_00HZ = 0x43a,
	TVIN_SIG_FMT_HDMI_1366X768_00HZ = 0x43b,
	TVIN_SIG_FMT_HDMI_1600X1200_00HZ = 0x43c,
	TVIN_SIG_FMT_HDMI_1920X1200_00HZ = 0x43d,
	TVIN_SIG_FMT_HDMI_1440X900_00HZ = 0x43e,
	TVIN_SIG_FMT_HDMI_1400X1050_00HZ = 0x43f,
	TVIN_SIG_FMT_HDMI_1680X1050_00HZ = 0x440,
	/* for alternative and 4k2k */
	TVIN_SIG_FMT_HDMI_1920X1080I_60HZ_ALTERNATIVE = 0x441,
	TVIN_SIG_FMT_HDMI_1920X1080I_50HZ_ALTERNATIVE = 0x442,
	TVIN_SIG_FMT_HDMI_1920X1080P_24HZ_ALTERNATIVE = 0x443,
	TVIN_SIG_FMT_HDMI_1920X1080P_30HZ_ALTERNATIVE = 0x444,
	TVIN_SIG_FMT_HDMI_3840_2160_00HZ = 0x445,
	TVIN_SIG_FMT_HDMI_4096_2160_00HZ = 0x446,
	TVIN_SIG_FMT_HDMI_1600X900_60HZ = 0x447,
	TVIN_SIG_FMT_HDMI_RESERVE8 = 0x448,
	TVIN_SIG_FMT_HDMI_RESERVE9 = 0x449,
	TVIN_SIG_FMT_HDMI_RESERVE10 = 0x44a,
	TVIN_SIG_FMT_HDMI_RESERVE11 = 0x44b,
	TVIN_SIG_FMT_HDMI_720X480P_60HZ_FRAME_PACKING = 0x44c,
	TVIN_SIG_FMT_HDMI_720X576P_50HZ_FRAME_PACKING = 0x44d,
	TVIN_SIG_FMT_HDMI_640X480P_72HZ = 0x44e,
	TVIN_SIG_FMT_HDMI_640X480P_75HZ = 0x44f,
	TVIN_SIG_FMT_HDMI_1152X864_00HZ = 0x450,
	TVIN_SIG_FMT_HDMI_3840X600_00HZ = 0x451,
	TVIN_SIG_FMT_HDMI_720X350_00HZ = 0x452,
	TVIN_SIG_FMT_HDMI_2688X1520_00HZ = 0x453,
	TVIN_SIG_FMT_HDMI_2560X1440_00HZ = 0x454,
	TVIN_SIG_FMT_HDMI_640X350_85HZ = 0x455,
	TVIN_SIG_FMT_HDMI_640X400_85HZ = 0x456,
	TVIN_SIG_FMT_HDMI_848X480_60HZ = 0x457,
	TVIN_SIG_FMT_HDMI_1792X1344_85HZ = 0x458,
	TVIN_SIG_FMT_HDMI_1856X1392_00HZ = 0x459,
	TVIN_SIG_FMT_HDMI_1920X1440_00HZ = 0x45a,
	TVIN_SIG_FMT_HDMI_2048X1152_60HZ = 0x45b,
	TVIN_SIG_FMT_HDMI_2560X1600_00HZ = 0x45c,
	TVIN_SIG_FMT_HDMI_MAX = 0x45d,
	TVIN_SIG_FMT_HDMI_THRESHOLD = 0x600,
	/* Video Formats */
	TVIN_SIG_FMT_CVBS_NTSC_M = 0x601,
	TVIN_SIG_FMT_CVBS_NTSC_443 = 0x602,
	TVIN_SIG_FMT_CVBS_PAL_I = 0x603,
	TVIN_SIG_FMT_CVBS_PAL_M = 0x604,
	TVIN_SIG_FMT_CVBS_PAL_60 = 0x605,
	TVIN_SIG_FMT_CVBS_PAL_CN = 0x606,
	TVIN_SIG_FMT_CVBS_SECAM = 0x607,
	TVIN_SIG_FMT_CVBS_NTSC_50 = 0x608,
	TVIN_SIG_FMT_CVBS_MAX = 0x609,
	TVIN_SIG_FMT_CVBS_THRESHOLD = 0x800,
	/* 656 Formats */
	TVIN_SIG_FMT_BT656IN_576I_50HZ = 0x801,
	TVIN_SIG_FMT_BT656IN_480I_60HZ = 0x802,
	/* 601 Formats */
	TVIN_SIG_FMT_BT601IN_576I_50HZ = 0x803,
	TVIN_SIG_FMT_BT601IN_480I_60HZ = 0x804,
	/* Camera Formats */
	TVIN_SIG_FMT_CAMERA_640X480P_30HZ = 0x805,
	TVIN_SIG_FMT_CAMERA_800X600P_30HZ = 0x806,
	TVIN_SIG_FMT_CAMERA_1024X768P_30HZ = 0x807,
	TVIN_SIG_FMT_CAMERA_1920X1080P_30HZ = 0x808,
	TVIN_SIG_FMT_CAMERA_1280X720P_30HZ = 0x809,
	TVIN_SIG_FMT_BT601_MAX = 0x80a,
	TVIN_SIG_FMT_BT601_THRESHOLD = 0xa00,
	TVIN_SIG_FMT_MAX,
};


/* tvin signal status */
enum tvin_sig_status_e {
	TVIN_SIG_STATUS_NULL = 0,
	/* processing status from init to */
	/*the finding of the 1st confirmed status */

	TVIN_SIG_STATUS_NOSIG,	/* no signal - physically no signal */
	TVIN_SIG_STATUS_UNSTABLE,	/* unstable - physically bad signal */
	TVIN_SIG_STATUS_NOTSUP,
	/* not supported - physically good signal & not supported */

	TVIN_SIG_STATUS_STABLE,
	/* stable - physically good signal & supported */
};

enum tvin_color_fmt_e {
	TVIN_RGB444 = 0,
	TVIN_YUV422,		/* 1 */
	TVIN_YUV444,		/* 2 */
	TVIN_YUYV422,		/* 3 */
	TVIN_YVYU422,		/* 4 */
	TVIN_UYVY422,		/* 5 */
	TVIN_VYUY422,		/* 6 */
	TVIN_NV12,		/* 7 */
	TVIN_NV21,		/* 8 */
	TVIN_BGGR,		/* 9  raw data */
	TVIN_RGGB,		/* 10 raw data */
	TVIN_GBRG,		/* 11 raw data */
	TVIN_GRBG,		/* 12 raw data */
	TVIN_COLOR_FMT_MAX,
};

enum tvin_aspect_ratio_e {
	TVIN_ASPECT_NULL = 0,
	TVIN_ASPECT_1x1,
	TVIN_ASPECT_4x3_FULL,
	TVIN_ASPECT_14x9_FULL,
	TVIN_ASPECT_14x9_LB_CENTER,
	TVIN_ASPECT_14x9_LB_TOP,
	TVIN_ASPECT_16x9_FULL,
	TVIN_ASPECT_16x9_LB_CENTER,
	TVIN_ASPECT_16x9_LB_TOP,
	TVIN_ASPECT_MAX,
};

struct tvin_info_s {
    enum tvin_trans_fmt trans_fmt;
    enum tvin_sig_fmt_e fmt;
    enum tvin_sig_status_e status;
    enum tvin_color_fmt_e cfmt;
    unsigned int fps;
    unsigned int is_dvi;
    unsigned int signal_type;
    enum tvin_aspect_ratio_e aspect_ratio;
    unsigned char amldolby_vision;
    unsigned char low_latency;
};
#define TVIN_IOC_MAGIC 'T'
#define TVIN_IOC_G_SIG_INFO _IOR(TVIN_IOC_MAGIC, 0x07, struct tvin_info_s)

#endif

